/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.dataexport;

import com.infor.igf.core.persistency.PersistencyContainer;
import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.PersistencyDataSet;
import com.varial.base.persistency.criterion.Conjunction;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Junction;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.types.date.DateHelper;
import com.varial.framework.domain.dataexport.DataExportExceptionMapper;
import com.varial.personnel.domain.dataexport.CompPlantYear;
import com.varial.personnel.domain.dataexport.DataTable;
import com.varial.personnel.domain.dataexport.ExportColumn;
import com.varial.personnel.domain.dataexport.ExportHelper;
import com.varial.personnel.domain.dataexport.TableColumn;
import com.varial.personnel.domain.dataexport.TableColumnStruct;
import com.varial.personnel.domain.dataexport.dls.ArbeitnehmerBean;
import com.varial.personnel.domain.dataexport.dls.ExportTypeEnum;
import com.varial.personnel.domain.dataexport.dls.LohnartenabrechnungBean;
import com.varial.personnel.domain.dataexport.dls.LohnkontoBean;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.IEmployeePersistencyManager;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.employee.valueposition.ValuePositionPersistencyManager;
import com.varial.personnel.domain.typeofvalue.ValueType;
import com.varial.personnel.domain.typeofvalue.ValueTypeTP;
import com.varial.personnel.framework.DateComparator;
import com.varial.personnel.framework.basictypes.PDateHelper;
import com.varial.personnel.framework.mapper.PBigDecimalMapper;
import com.varial.personnel.persistency.calculation.calculationbasic.CalculationbasicContainer;
import com.varial.personnel.persistency.calculation.calculationbasic.ICalculationbasicDao;
import com.varial.personnel.persistency.employee.employmentall.EmploymentallContainer;
import com.varial.personnel.persistency.employee.employmentall.IEmploymentallDao;
import com.varial.personnel.persistency.employee.insuranceall.IInsuranceallDao;
import com.varial.personnel.persistency.employee.insuranceall.InsuranceallContainer;
import com.varial.personnel.persistency.employee.valueposition.IValuepositionDao;
import com.varial.personnel.persistency.employee.valueposition.ValuepositionContainer;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.domain.textoutput.FieldSeparator;
import com.varial.serverbase.domain.textoutput.LineSeparator;
import com.varial.serverbase.domain.textoutput.OutputField;
import com.varial.serverbase.domain.textoutput.OutputLine;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jdom.Content;
import org.jdom.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExportTable {
    private static Logger LOGGER = LoggerFactory.getLogger(ExportTable.class);
    private static IEmploymentallDao daoEmploymentall = (IEmploymentallDao)UtilitiesManager.getApplicationContext().getBean("employmentallDao");
    private static IInsuranceallDao daoInsuranceall = (IInsuranceallDao)UtilitiesManager.getApplicationContext().getBean("insuranceallDao");
    private static IValuepositionDao dao = (IValuepositionDao)UtilitiesManager.getApplicationContext().getBean("valuepositionDao");
    private static IValuepositionDao daoRR = (IValuepositionDao)UtilitiesManager.getApplicationContext().getBean("valuepositionDao");
    private static ICalculationbasicDao daoCalculationbasic = (ICalculationbasicDao)UtilitiesManager.getApplicationContext().getBean("calculationbasicDao");
    public final String VALUETYPE_KEY_STEUERFREI_SFN = "99940";
    public final String VALUETYPE_DESCRIPTION_STEUERFREI_SFN = "Steuerfr. S/F/N-Zuschl\u00e4ge";
    public ValuepositionContainer vpContainerSteuerfreiSFN = null;
    public ValueType valueTypeSteuerfreiSFN = null;
    public BigDecimal amountSteuerfreiSFN = null;
    private final String mCode;
    private final String mDescription;
    private final String mFileName;
    protected ExportColumn[] mColumns;
    protected ExportColumn[] mVisibleColumns;
    protected OutputField[] mVisibleOutputFields;
    protected OutputLine mVisibleOutputLine;
    private final LineSeparator mLineSeparator;
    private final FieldSeparator mFieldSeparator;
    private final char mDecimalPoint;
    private final char mDigitGroupingSymbol;
    private boolean mIsVisible;
    private final boolean mFixedLength;
    protected BufferedWriter mActiveWriter;
    private CompPlantYear mYear;
    private boolean mStorno = false;
    private Date mEffectiveFrom;
    private String mCalculationType;
    private Employee mEmployeeForOutput;
    private Date mEffectiveFromForOutput;
    private Date mValidFromForOutput;
    private Integer mValuetypenumberForOuput;
    private BigDecimal mResultForOutput = BigDecimal.ZERO;
    private BigDecimal mResultNewForOutput = BigDecimal.ZERO;
    private final int mCountOfRetroaciveCalculationForOutput = 1;
    private LohnartenabrechnungBean mLohnartenabrechnungBean;
    private ArbeitnehmerBean mArbeitnehmerBean;
    private LohnkontoBean mLohnkontoBean;

    protected ExportTable(String code, String description, String fileName, FieldSeparator fieldSeparator, LineSeparator lineSeparator, char decimalPoint) {
        this.mCode = code;
        this.mDescription = description;
        this.mFileName = fileName;
        this.mFieldSeparator = fieldSeparator;
        this.mLineSeparator = lineSeparator;
        this.mDecimalPoint = decimalPoint;
        this.mDigitGroupingSymbol = (char)46;
        this.mIsVisible = true;
        this.mFixedLength = false;
    }

    public ExportColumn[] getColumns() {
        return this.mColumns;
    }

    public ExportColumn[] getVisibleColumns() {
        return this.mVisibleColumns;
    }

    protected void setColumns(ExportColumn[] columns) {
        this.mColumns = columns;
    }

    public String getCode() {
        return this.mCode;
    }

    public String getFileName() {
        return this.mFileName;
    }

    public void setIsVisible(boolean b) {
        this.mIsVisible = b;
    }

    public boolean getIsVsisible() {
        return this.mIsVisible;
    }

    public DataTable getIdlDescription() {
        TableColumn[] columns = new TableColumn[this.mColumns.length];
        for (int i = 0; i < this.mColumns.length; ++i) {
            columns[i] = this.mColumns[i].getIdlDescription();
        }
        String tableDescription = this.mDescription;
        switch (this.mCode) {
            case "DLS-Programminfo": {
                tableDescription = "Programminfo";
                break;
            }
            case "DLS-Arbeitgeber": {
                tableDescription = "Stammdaten des Arbeitgebers";
                break;
            }
            case "DLS-Arbeitnehmer": {
                tableDescription = "Stammdaten des Arbeitnehmers";
                break;
            }
            case "DLS-Lohnarten": {
                tableDescription = "Stammdaten der Lohnarten";
                break;
            }
            case "DLS-Lohnartenabrechnung": {
                tableDescription = "Daten der Lohnartenabrechnung";
                break;
            }
            case "DLS-Lohnkonto": {
                tableDescription = "Daten des Lohnkontos";
                break;
            }
            case "DLS-Sozialversicherung": {
                tableDescription = "Daten der Sozialversicherung";
            }
        }
        DataTable result = new DataTable(this.mCode, tableDescription, columns);
        return result;
    }

    public void setVisibleColumns(TableColumnStruct[] columns) throws BusinessDomainException {
        int i;
        HashSet<String> columnSet = new HashSet<String>(columns.length);
        for (int i2 = 0; i2 < columns.length; ++i2) {
            columnSet.add(columns[i2].code);
        }
        ArrayList<ExportColumn> columList = new ArrayList<ExportColumn>(this.mColumns.length);
        for (i = 0; i < this.mColumns.length; ++i) {
            if (columnSet.remove(this.mColumns[i].getCode())) {
                this.mColumns[i].setIsVisible(true);
                columList.add(this.mColumns[i]);
                continue;
            }
            this.mColumns[i].setIsVisible(false);
        }
        if (!columnSet.isEmpty()) {
            throw ExceptionMapper.makeApplicationException((String)("unknown columns for table " + this.mCode));
        }
        this.mVisibleColumns = new ExportColumn[columList.size()];
        columList.toArray(this.mVisibleColumns);
        this.mVisibleOutputFields = new OutputField[this.mVisibleColumns.length];
        for (i = 0; i < this.mVisibleOutputFields.length; ++i) {
            this.mVisibleOutputFields[i] = this.mVisibleColumns[i].getOutputField();
        }
        this.mVisibleOutputLine = this.makeOutputLine(this.mVisibleOutputFields);
    }

    public CompPlantYear getYear() {
        return this.mYear;
    }

    public Date getValidFromForOutput() {
        return this.mValidFromForOutput;
    }

    public boolean getStorno() {
        return this.mStorno;
    }

    public String getCalculationType() {
        return this.mCalculationType;
    }

    public int getCountOfRetroaciveCalculationForOutput() {
        return 1;
    }

    public Date getEffectiveFromForOutput() {
        return this.mEffectiveFromForOutput;
    }

    public BigDecimal getResultForOutput() {
        return this.mResultForOutput == null ? BigDecimalMapper.ZERO : this.mResultForOutput;
    }

    public BigDecimal getResultNewForOutput() {
        return this.mResultNewForOutput == null ? BigDecimalMapper.ZERO : this.mResultNewForOutput;
    }

    public Integer getValuetypenumberForOuput() {
        return this.mValuetypenumberForOuput;
    }

    public Employee getEmployeeForOuput() {
        return this.mEmployeeForOutput;
    }

    public LohnartenabrechnungBean getLohnartenabrechnungBean() {
        return this.mLohnartenabrechnungBean;
    }

    public ArbeitnehmerBean getArbeitnehmerBean() {
        return this.mArbeitnehmerBean;
    }

    public LohnkontoBean getLohnkontoBean() {
        return this.mLohnkontoBean;
    }

    protected abstract PersistencyDataSet getDataSet();

    protected abstract PersistencyDataSet getDataSetPlants();

    protected abstract boolean getPlants();

    protected abstract ExportTypeEnum getExportType();

    public int exportData(File folder) throws BusinessDomainException {
        Writer writer = null;
        try {
            File file = new File(folder, this.mFileName);
            try {
                if (!file.createNewFile()) {
                    throw DataExportExceptionMapper.makeFileExistsAlreadyNotCreatedDomainException((String)file.getAbsolutePath());
                }
            }
            catch (IOException ioe) {
                throw DataExportExceptionMapper.makeFileCouldNotBeCreatedDomainException((String)file.getAbsolutePath());
            }
            catch (SecurityException se) {
                throw DataExportExceptionMapper.makeWriteAccessDeniedFileCouldNotBeCreatedDomainException((String)file.getAbsolutePath());
            }
            writer = new FileWriter(file);
            this.mActiveWriter = new BufferedWriter(writer);
            int lineCount = 0;
            if (this.getExportType() == ExportTypeEnum.STANDARD) {
                lineCount = this.getRecordsForStandard(lineCount);
            }
            if (this.getExportType() == ExportTypeEnum.BERECHNUNGSERGEBNISSE) {
                lineCount = this.getRecordsForMaValueTypes(lineCount);
            }
            if (this.getExportType() == ExportTypeEnum.LOHNARTENABRECHNUNG) {
                lineCount = this.getRecordsForLohnartenabrechnung(lineCount);
            }
            if (this.getExportType() == ExportTypeEnum.ARBEITNEHMERSTAMMDATEN) {
                lineCount = this.getRecordsForArbeitnehmer(lineCount);
            }
            if (this.getExportType() == ExportTypeEnum.SOZIALVERSICHERUNG) {
                lineCount = this.getRecordsForSozialversicherung(lineCount);
            }
            if (this.getExportType() == ExportTypeEnum.LOHNKONTEN) {
                lineCount = this.getRecordsForLohnkonten(lineCount);
            }
            if (this.getPlants()) {
                lineCount = this.getRecordsForPlant(lineCount);
            }
            int n = lineCount;
            return n;
        }
        catch (BusinessDomainException de) {
            throw de;
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        finally {
            if (this.mActiveWriter != null) {
                try {
                    this.mActiveWriter.flush();
                    this.mActiveWriter.close();
                    this.mActiveWriter = null;
                }
                catch (IOException ie) {
                    ExceptionMapper.printException((Throwable)ie);
                }
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException ie) {
                    ExceptionMapper.printException((Throwable)ie);
                }
            }
        }
    }

    private int getRecordsForSozialversicherung(int lineCount) throws BusinessDomainException, IOException {
        Date listFirstDate = this.mYear.getListValidFrom();
        Date listEndDate = this.mYear.getListValidUntil();
        EmploymentallContainer[] employmentallContainers = null;
        Employee[] allEmployeesOfCompanyOrPlant = StringMapper.isNullString((String)this.mYear.getOidPlant()) ? this.getIEmployeePM().getAllEEPCompany(this.mYear.getOidPCompany()) : this.getIEmployeePM().getAllEEPlant(this.mYear.getOidPlant(), VDate.getDateMax(), VDate.getDateMax());
        for (int i = 0; i < allEmployeesOfCompanyOrPlant.length; ++i) {
            SortedMap<Date, Date> hMDatesOfRc;
            Employee currentEmployee = allEmployeesOfCompanyOrPlant[i];
            if (!this.isSuitable(currentEmployee)) continue;
            String currentOidEmployee = currentEmployee.getObjectid();
            Date currentEmployeeFirstDate = listFirstDate;
            Date currentEmployeeEndDate = listEndDate;
            Junction filterForEmployment = Restrictions.conjunction().add((Criterion)this.mYear.getDateFilter()).add(Restrictions.eq((String)"oidemployee", (String)currentOidEmployee));
            employmentallContainers = daoEmploymentall.getRows(null, (Criterion)filterForEmployment);
            if (employmentallContainers.length == 0) continue;
            PersistencyDataSet dataset = null;
            while (DateHelper.before((Date)currentEmployeeFirstDate, (Date)currentEmployeeEndDate)) {
                dataset = daoInsuranceall.getDataSet(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)currentOidEmployee), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)currentEmployeeFirstDate)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)currentEmployeeFirstDate)), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)currentEmployeeFirstDate))), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)currentEmployeeFirstDate)))}));
                while (dataset.hasNext()) {
                    InsuranceallContainer container = (InsuranceallContainer)dataset.getNext();
                    this.mArbeitnehmerBean = new ArbeitnehmerBean(1, DateHelper.getFirstDayOfMonth((Date)currentEmployeeFirstDate), DateHelper.getFirstDayOfMonth((Date)currentEmployeeFirstDate), currentEmployee);
                    this.fillVisibleOutputFields((PersistencyContainer)container);
                    this.writeLine(this.mVisibleOutputLine);
                    ++lineCount;
                }
                currentEmployeeFirstDate = PDateHelper.getFirstDayNextMonth((Date)currentEmployeeFirstDate);
            }
            if (dataset != null) {
                dataset.dispose();
            }
            if ((hMDatesOfRc = this.getDatesOfRc(currentEmployee, listFirstDate, listEndDate)).isEmpty()) continue;
            Date[] effectiveDatesOfRc = hMDatesOfRc.keySet().toArray(new Date[hMDatesOfRc.keySet().size()]);
            for (int k = 0; k < hMDatesOfRc.size(); ++k) {
                Date hMValidFrom = (Date)hMDatesOfRc.get(effectiveDatesOfRc[k]);
                Date hMEffectiveFrom = effectiveDatesOfRc[k];
                currentEmployeeEndDate = DateHelper.after((Date)listEndDate, (Date)hMEffectiveFrom) ? DateHelper.addMonths((Date)hMEffectiveFrom, (int)-1) : DateHelper.getFirstDayOfMonth((Date)listEndDate);
                Date validFromOfRc = DateHelper.getFirstDayOfMonth((Date)hMValidFrom);
                while (DateHelper.beforeOrEqual((Date)validFromOfRc, (Date)currentEmployeeEndDate)) {
                    PersistencyDataSet datasetRR = daoInsuranceall.getDataSet(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)currentOidEmployee), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)hMEffectiveFrom)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)hMEffectiveFrom)), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)validFromOfRc)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)validFromOfRc))}));
                    while (datasetRR.hasNext()) {
                        InsuranceallContainer container = (InsuranceallContainer)datasetRR.getNext();
                        this.mArbeitnehmerBean = new ArbeitnehmerBean(k + 2, DateHelper.getFirstDayOfMonth((Date)hMEffectiveFrom), DateHelper.getLastDayOfMonth((Date)validFromOfRc), currentEmployee);
                        this.fillVisibleOutputFields((PersistencyContainer)container);
                        this.writeLine(this.mVisibleOutputLine);
                        ++lineCount;
                    }
                    datasetRR.dispose();
                    validFromOfRc = DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)validFromOfRc));
                }
            }
        }
        return lineCount;
    }

    private int getRecordsForPlant(int lineCount) throws BusinessDomainException, IOException {
        PersistencyDataSet dataSetPlants = this.getDataSetPlants();
        while (dataSetPlants.hasNext()) {
            PersistencyContainer containerPlants = dataSetPlants.getNext();
            this.fillVisibleOutputFieldsPlants(containerPlants);
            this.writeLine(this.mVisibleOutputLine);
            ++lineCount;
        }
        return lineCount;
    }

    private int getRecordsForStandard(int lineCount) throws BusinessDomainException, IOException {
        PersistencyDataSet dataSet = this.getDataSet();
        while (dataSet.hasNext()) {
            PersistencyContainer container = dataSet.getNext();
            this.fillVisibleOutputFields(container);
            this.writeLine(this.mVisibleOutputLine);
            ++lineCount;
        }
        return lineCount;
    }

    private int getRecordsForMaValueTypes(int lineCount) throws BusinessDomainException, IOException {
        Date listFirstDate = this.mYear.getListValidFrom();
        Date calculationStartDate = this.mYear.getCompanyStart();
        Date listEndDate = this.mYear.getListValidUntil();
        Employee[] allEmployeesOfCompanyOrPlant = StringMapper.isNullString((String)this.mYear.getOidPlant()) ? this.getIEmployeePM().getAllEEPCompany(this.mYear.getOidPCompany()) : this.getIEmployeePM().getAllEEPlant(this.mYear.getOidPlant(), VDate.getDateMax(), VDate.getDateMax());
        for (int i = 0; i < allEmployeesOfCompanyOrPlant.length; ++i) {
            Employee currentEmployee = allEmployeesOfCompanyOrPlant[i];
            if (!this.isSuitable(currentEmployee)) continue;
            Conjunction listFilElemStruct = Restrictions.conjunction();
            String currentOidEmployee = currentEmployee.getObjectid();
            this.mEffectiveFrom = currentEmployee.getJournalizedUntil();
            Criterion fes = Restrictions.eq((String)"oidemployee", (String)currentOidEmployee);
            listFilElemStruct.add((Criterion)this.mYear.getDateFilter());
            listFilElemStruct.add(fes);
            Order[] sortEmployment = new Order[]{Order.asc((String)"personnelnumber"), Order.asc((String)"validfrom"), Order.asc((String)"effectivefrom")};
            EmploymentallContainer[] employmentallsEmployee = daoEmploymentall.getRows(sortEmployment, (Criterion)listFilElemStruct);
            if (employmentallsEmployee.length == 0) continue;
            Date currentEmployeeFirstDate = listFirstDate;
            Date currentEmployeeEndDate = listEndDate;
            Order[] sort = new Order[]{Order.asc((String)"oidemployee"), Order.asc((String)"valuetypenumber"), Order.asc((String)"effectivefrom"), Order.asc((String)"validfrom")};
            PersistencyDataSet dataset = null;
            while (DateHelper.before((Date)currentEmployeeFirstDate, (Date)currentEmployeeEndDate)) {
                Criterion filter = this.getFilter(currentOidEmployee, currentEmployeeFirstDate, this.mEffectiveFrom);
                dataset = dao.getDataSet(sort, filter);
                int valTypeNumb = -1;
                int zaehl = 0;
                PersistencyContainer containerBefore = null;
                while (dataset.hasNext()) {
                    PersistencyContainer container = dataset.getNext();
                    ValuepositionContainer valPosCont = (ValuepositionContainer)container;
                    boolean mmpayrollresult = ValueType.getValueType((String)valPosCont.oidvaluetype).getValueTypeTP(VDate.getDateMax(), VDate.getDateMax()).getValueTypeFoundation().getPrintSettings().getMonthlyPayrollResult();
                    if (valPosCont.valuetypenumber > 99900 && !mmpayrollresult || BigDecimalMapper.isZeroOrNull((BigDecimal)valPosCont.results)) continue;
                    if (++zaehl == 1) {
                        valTypeNumb = valPosCont.valuetypenumber;
                        this.mResultNewForOutput = BigDecimal.ZERO;
                    }
                    if (valTypeNumb != valPosCont.valuetypenumber) {
                        this.mCalculationType = "akt";
                        this.mValidFromForOutput = DateHelper.getLastDayOfMonth((Date)currentEmployeeFirstDate);
                        this.mEffectiveFromForOutput = DateHelper.getFirstDayOfMonth((Date)this.mEffectiveFrom);
                        this.mEmployeeForOutput = currentEmployee;
                        this.fillVisibleOutputFields(containerBefore);
                        this.writeLine(this.mVisibleOutputLine);
                        ++lineCount;
                        this.mResultNewForOutput = BigDecimal.ZERO;
                    }
                    containerBefore = container;
                    valTypeNumb = valPosCont.valuetypenumber;
                    this.mValuetypenumberForOuput = valTypeNumb;
                    this.mResultNewForOutput = this.mResultNewForOutput.add(valPosCont.results);
                }
                this.mResultNewForOutput = BigDecimal.ZERO;
                currentEmployeeFirstDate = PDateHelper.getFirstDayNextMonth((Date)currentEmployeeFirstDate);
            }
            if (dataset != null) {
                dataset.dispose();
            }
            currentEmployeeFirstDate = listFirstDate;
            PersistencyDataSet calculationbasicData = daoCalculationbasic.getDataSet(new Order[]{Order.asc((String)"effectivefrom"), Order.asc((String)"validfrom")}, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)currentOidEmployee), Restrictions.ge((String)"effectivefrom", (String)DateMapper.toString((Date)currentEmployeeFirstDate)), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)currentEmployeeEndDate)), Restrictions.sqlRestriction((String)"validfrom < effectivefrom")}));
            HashMap<Date, String> hMDates = new HashMap<Date, String>();
            while (calculationbasicData.hasNext()) {
                CalculationbasicContainer calculationbasicContainer = (CalculationbasicContainer)calculationbasicData.getNext();
                if (!DateHelper.beforeOrEqual((Date)calculationbasicContainer.effectivefrom, (Date)DateHelper.getFirstDayOfMonth((Date)currentEmployee.getJournalizedUntil())) || !DateHelper.afterOrEqual((Date)calculationbasicContainer.validfrom, (Date)currentEmployeeFirstDate)) continue;
                String minValidDate = (String)hMDates.get(calculationbasicContainer.effectivefrom);
                if (minValidDate != null) {
                    if (!DateMapper.toDate((String)minValidDate).after(calculationbasicContainer.validfrom)) continue;
                    hMDates.put(calculationbasicContainer.effectivefrom, calculationbasicContainer.validfrom.toString());
                    continue;
                }
                hMDates.put(calculationbasicContainer.effectivefrom, calculationbasicContainer.validfrom.toString());
            }
            if (hMDates.isEmpty()) continue;
            Date[] arrDates = hMDates.keySet().toArray(new Date[hMDates.keySet().size()]);
            Arrays.sort(arrDates, new DateComparator());
            Date retroactiveCorrectionValidFrom = null;
            for (int k = 0; k < hMDates.size(); ++k) {
                Date hMValidFrom = DateMapper.toDate((String)((String)hMDates.get(arrDates[k])));
                Date hMEffectiveFrom = arrDates[k];
                currentEmployeeEndDate = DateHelper.after((Date)listEndDate, (Date)hMEffectiveFrom) ? hMEffectiveFrom : DateHelper.getFirstDayOfMonth((Date)listEndDate);
                retroactiveCorrectionValidFrom = DateHelper.getFirstDayOfMonth((Date)hMValidFrom);
                retroactiveCorrectionValidFrom = DateHelper.before((Date)retroactiveCorrectionValidFrom, (Date)calculationStartDate) ? calculationStartDate : retroactiveCorrectionValidFrom;
                Date oldEffectiveDate = DateHelper.yesterday((Date)DateHelper.getFirstDayOfMonth((Date)hMEffectiveFrom));
                PersistencyDataSet datasetRR = null;
                PersistencyDataSet datasetNew = null;
                HashMap<Integer, BigDecimal> vpNewHashMapResult = new HashMap<Integer, BigDecimal>();
                HashMap<Integer, BigDecimal> vpOldHashMapResult = new HashMap<Integer, BigDecimal>();
                while (DateHelper.before((Date)retroactiveCorrectionValidFrom, (Date)currentEmployeeEndDate)) {
                    Criterion filterNew = this.getFilter(currentOidEmployee, retroactiveCorrectionValidFrom, hMEffectiveFrom);
                    datasetNew = daoRR.getDataSet(sort, filterNew);
                    PersistencyContainer containerNew = null;
                    PersistencyContainer containerOld = null;
                    while (datasetNew.hasNext()) {
                        containerNew = datasetNew.getNext();
                        ValuepositionContainer valPosContNew = (ValuepositionContainer)containerNew;
                        boolean mmpayrollresult = ValueType.getValueType((String)valPosContNew.oidvaluetype).getValueTypeTP(VDate.getDateMax(), VDate.getDateMax()).getValueTypeFoundation().getPrintSettings().getMonthlyPayrollResult();
                        if (valPosContNew.valuetypenumber > 99900 && !mmpayrollresult || BigDecimalMapper.isZeroOrNull((BigDecimal)valPosContNew.results)) continue;
                        if (vpNewHashMapResult.get(valPosContNew.valuetypenumber) == null) {
                            vpNewHashMapResult.put(valPosContNew.valuetypenumber, valPosContNew.results);
                            continue;
                        }
                        this.mResultNewForOutput = ((BigDecimal)vpNewHashMapResult.get(valPosContNew.valuetypenumber)).add(valPosContNew.results);
                        vpNewHashMapResult.put(valPosContNew.valuetypenumber, this.mResultNewForOutput);
                    }
                    Criterion filterRR = this.getFilter(currentOidEmployee, retroactiveCorrectionValidFrom, oldEffectiveDate);
                    datasetRR = dao.getDataSet(sort, filterRR);
                    while (datasetRR.hasNext()) {
                        containerOld = datasetRR.getNext();
                        ValuepositionContainer valPosContOld = (ValuepositionContainer)containerOld;
                        boolean mmpayrollresult = ValueType.getValueType((String)valPosContOld.oidvaluetype).getValueTypeTP(VDate.getDateMax(), VDate.getDateMax()).getValueTypeFoundation().getPrintSettings().getMonthlyPayrollResult();
                        if (valPosContOld.valuetypenumber > 99900 && !mmpayrollresult || BigDecimalMapper.isZeroOrNull((BigDecimal)valPosContOld.results)) continue;
                        if (vpOldHashMapResult.get(valPosContOld.valuetypenumber) == null) {
                            vpOldHashMapResult.put(valPosContOld.valuetypenumber, valPosContOld.results);
                            continue;
                        }
                        this.mResultForOutput = ((BigDecimal)vpOldHashMapResult.get(valPosContOld.valuetypenumber)).add(valPosContOld.results);
                        vpOldHashMapResult.put(valPosContOld.valuetypenumber, this.mResultForOutput);
                    }
                    this.mResultForOutput = BigDecimal.ZERO;
                    this.mResultNewForOutput = BigDecimal.ZERO;
                    Iterator itOldHM = vpOldHashMapResult.keySet().iterator();
                    while (itOldHM.hasNext()) {
                        int vtOld = (Integer)itOldHM.next();
                        this.mResultForOutput = (BigDecimal)vpOldHashMapResult.get(vtOld);
                        if (vpNewHashMapResult.get(vtOld) != null) {
                            this.mResultNewForOutput = (BigDecimal)vpNewHashMapResult.get(vtOld);
                            if (this.mResultForOutput.compareTo(this.mResultNewForOutput) == 0) continue;
                            this.mEmployeeForOutput = currentEmployee;
                            this.mValidFromForOutput = DateHelper.getLastDayOfMonth((Date)retroactiveCorrectionValidFrom);
                            this.mValuetypenumberForOuput = vtOld;
                            this.mStorno = true;
                            this.mCalculationType = "alt";
                            this.mEffectiveFromForOutput = DateHelper.getFirstDayOfMonth((Date)oldEffectiveDate);
                            this.fillVisibleOutputFields(containerOld);
                            this.writeLine(this.mVisibleOutputLine);
                            ++lineCount;
                            this.mStorno = false;
                            this.mCalculationType = "neu";
                            this.mEffectiveFromForOutput = DateHelper.getFirstDayOfMonth((Date)hMEffectiveFrom);
                            this.fillVisibleOutputFields(containerNew);
                            this.writeLine(this.mVisibleOutputLine);
                            ++lineCount;
                            continue;
                        }
                        this.mCalculationType = "alt";
                        this.mStorno = false;
                        this.mEmployeeForOutput = currentEmployee;
                        this.mEffectiveFromForOutput = DateHelper.getFirstDayOfMonth((Date)oldEffectiveDate);
                        this.mValidFromForOutput = DateHelper.getLastDayOfMonth((Date)retroactiveCorrectionValidFrom);
                        this.mValuetypenumberForOuput = vtOld;
                        this.mResultNewForOutput = (BigDecimal)vpOldHashMapResult.get(vtOld);
                        this.fillVisibleOutputFields(containerOld);
                        this.writeLine(this.mVisibleOutputLine);
                        ++lineCount;
                    }
                    Iterator itNewHM = vpNewHashMapResult.keySet().iterator();
                    while (itNewHM.hasNext()) {
                        int vtNew = (Integer)itNewHM.next();
                        if (vpOldHashMapResult.get(vtNew) != null) continue;
                        this.mCalculationType = "neu";
                        this.mStorno = false;
                        this.mEmployeeForOutput = currentEmployee;
                        this.mEffectiveFromForOutput = DateHelper.getFirstDayOfMonth((Date)hMEffectiveFrom);
                        this.mValidFromForOutput = DateHelper.getLastDayOfMonth((Date)retroactiveCorrectionValidFrom);
                        this.mValuetypenumberForOuput = vtNew;
                        this.mResultNewForOutput = (BigDecimal)vpNewHashMapResult.get(vtNew);
                        this.fillVisibleOutputFields(containerOld);
                        this.writeLine(this.mVisibleOutputLine);
                        ++lineCount;
                    }
                    this.mStorno = false;
                    vpNewHashMapResult.clear();
                    vpOldHashMapResult.clear();
                    retroactiveCorrectionValidFrom = PDateHelper.getFirstDayNextMonth((Date)retroactiveCorrectionValidFrom);
                }
                if (datasetRR != null) {
                    datasetRR.dispose();
                }
                if (datasetNew == null) continue;
                datasetNew.dispose();
            }
        }
        return lineCount;
    }

    private int getRecordsForLohnartenabrechnung(int lineCount) throws BusinessDomainException, IOException {
        Date listFirstDate = this.mYear.getListValidFrom();
        Date listEndDate = this.mYear.getListValidUntil();
        Employee[] allEmployeesOfCompanyOrPlant = StringMapper.isNullString((String)this.mYear.getOidPlant()) ? this.getIEmployeePM().getAllEEPCompany(this.mYear.getOidPCompany()) : this.getIEmployeePM().getAllEEPlant(this.mYear.getOidPlant(), VDate.getDateMax(), VDate.getDateMax());
        for (int i = 0; i < allEmployeesOfCompanyOrPlant.length; ++i) {
            SortedMap<Date, Date> hMDatesOfRc;
            Employee currentEmployee = allEmployeesOfCompanyOrPlant[i];
            if (!this.isSuitable(currentEmployee)) continue;
            String currentOidEmployee = currentEmployee.getObjectid();
            Date currentEmployeeFirstDate = listFirstDate;
            Date currentEmployeeEndDate = listEndDate;
            Junction filterForEmployment = Restrictions.conjunction().add((Criterion)this.mYear.getDateFilter()).add(Restrictions.eq((String)"oidemployee", (String)currentOidEmployee));
            Order[] sortForEmployment = new Order[]{Order.asc((String)"personnelnumber"), Order.asc((String)"validfrom"), Order.asc((String)"effectivefrom")};
            EmploymentallContainer[] allEmployment = daoEmploymentall.getRows(sortForEmployment, (Criterion)filterForEmployment);
            if (allEmployment.length == 0) continue;
            Order[] sortForValuePosition = new Order[]{Order.asc((String)"oidemployee"), Order.asc((String)"valuetypenumber"), Order.asc((String)"effectivefrom"), Order.asc((String)"validfrom")};
            PersistencyDataSet dataset = null;
            while (DateHelper.before((Date)currentEmployeeFirstDate, (Date)currentEmployeeEndDate)) {
                Criterion filterForValuePosition = this.getFilter(currentOidEmployee, currentEmployeeFirstDate, currentEmployeeFirstDate);
                dataset = dao.getDataSet(sortForValuePosition, filterForValuePosition);
                int zaehl = 0;
                int valueTypeNumberBefore = -1;
                BigDecimal resultBefore = BigDecimal.ZERO;
                ValuepositionContainer containerBefore = null;
                while (dataset.hasNext()) {
                    ValuepositionContainer valuePositionContainer = (ValuepositionContainer)dataset.getNext();
                    boolean mmpayrollresult = ValueType.getValueType((String)valuePositionContainer.oidvaluetype).getValueTypeTP(VDate.getDateMax(), VDate.getDateMax()).getValueTypeFoundation().getPrintSettings().getMonthlyPayrollResult();
                    if (valuePositionContainer.valuetypenumber > 99900 && !mmpayrollresult) continue;
                    if (++zaehl == 1) {
                        valueTypeNumberBefore = valuePositionContainer.valuetypenumber;
                        resultBefore = BigDecimal.ZERO;
                    }
                    if (valueTypeNumberBefore != valuePositionContainer.valuetypenumber) {
                        this.mLohnartenabrechnungBean = new LohnartenabrechnungBean(1, DateHelper.getFirstDayOfMonth((Date)currentEmployeeFirstDate), DateHelper.getLastDayOfMonth((Date)currentEmployeeFirstDate), currentEmployee, valueTypeNumberBefore, resultBefore, containerBefore.factor1 == null ? BigDecimalMapper.ZERO : containerBefore.factor1, containerBefore.factor2 == null ? BigDecimalMapper.ZERO : containerBefore.factor2, containerBefore.percentage == null ? BigDecimalMapper.ZERO : containerBefore.percentage.setScale(2, RoundingMode.HALF_UP));
                        this.vpContainerSteuerfreiSFN = null;
                        this.valueTypeSteuerfreiSFN = null;
                        this.amountSteuerfreiSFN = null;
                        this.fillVisibleOutputFields((PersistencyContainer)containerBefore);
                        this.writeLine(this.mVisibleOutputLine);
                        ++lineCount;
                        if (this.vpContainerSteuerfreiSFN != null && this.valueTypeSteuerfreiSFN != null) {
                            this.mLohnartenabrechnungBean = new LohnartenabrechnungBean(1, DateHelper.getFirstDayOfMonth((Date)currentEmployeeFirstDate), DateHelper.getLastDayOfMonth((Date)currentEmployeeFirstDate), currentEmployee, Integer.valueOf("99940").intValue(), this.amountSteuerfreiSFN == null ? BigDecimalMapper.ZERO : this.amountSteuerfreiSFN, BigDecimalMapper.ZERO, BigDecimalMapper.ZERO, BigDecimalMapper.ZERO);
                            this.fillVisibleOutputFields((PersistencyContainer)this.vpContainerSteuerfreiSFN);
                            this.writeLine(this.mVisibleOutputLine);
                            ++lineCount;
                        }
                        resultBefore = BigDecimal.ZERO;
                    }
                    containerBefore = valuePositionContainer;
                    valueTypeNumberBefore = valuePositionContainer.valuetypenumber;
                    resultBefore = resultBefore.add(valuePositionContainer.results);
                }
                resultBefore = BigDecimal.ZERO;
                currentEmployeeFirstDate = PDateHelper.getFirstDayNextMonth((Date)currentEmployeeFirstDate);
            }
            if (dataset != null) {
                dataset.dispose();
            }
            if ((hMDatesOfRc = this.getDatesOfRc(currentEmployee, listFirstDate, listEndDate)).isEmpty()) continue;
            Date[] effectiveDatesOfRc = hMDatesOfRc.keySet().toArray(new Date[hMDatesOfRc.keySet().size()]);
            for (int k = 0; k < hMDatesOfRc.size(); ++k) {
                Date hMValidFrom = (Date)hMDatesOfRc.get(effectiveDatesOfRc[k]);
                Date hMEffectiveFrom = effectiveDatesOfRc[k];
                Date validFromOfRc = DateHelper.getFirstDayOfMonth((Date)hMValidFrom);
                Date oldEffectiveDate = PDateHelper.getLastDayPreviousMonth((Date)hMEffectiveFrom);
                currentEmployeeEndDate = DateHelper.after((Date)listEndDate, (Date)hMEffectiveFrom) ? DateHelper.addMonths((Date)hMEffectiveFrom, (int)-1) : DateHelper.getFirstDayOfMonth((Date)listEndDate);
                PersistencyDataSet datasetNew = null;
                PersistencyDataSet datasetOld = null;
                HashMap<Integer, BigDecimal> vpNewHashMapResult = new HashMap<Integer, BigDecimal>();
                HashMap<Integer, BigDecimal> vpOldHashMapResult = new HashMap<Integer, BigDecimal>();
                while (DateHelper.beforeOrEqual((Date)validFromOfRc, (Date)currentEmployeeEndDate)) {
                    boolean mmpayrollresult;
                    datasetNew = daoRR.getDataSet(sortForValuePosition, this.getFilter(currentOidEmployee, validFromOfRc, hMEffectiveFrom));
                    PersistencyContainer containerNew = null;
                    PersistencyContainer containerOld = null;
                    BigDecimal resultNew = BigDecimal.ZERO;
                    BigDecimal resultOld = BigDecimal.ZERO;
                    while (datasetNew.hasNext()) {
                        containerNew = datasetNew.getNext();
                        ValuepositionContainer valuePositionContainerNew = (ValuepositionContainer)containerNew;
                        mmpayrollresult = ValueType.getValueType((String)valuePositionContainerNew.oidvaluetype).getValueTypeTP(VDate.getDateMax(), VDate.getDateMax()).getValueTypeFoundation().getPrintSettings().getMonthlyPayrollResult();
                        if (valuePositionContainerNew.valuetypenumber > 99900 && !mmpayrollresult) continue;
                        if (vpNewHashMapResult.get(valuePositionContainerNew.valuetypenumber) == null) {
                            vpNewHashMapResult.put(valuePositionContainerNew.valuetypenumber, valuePositionContainerNew.results);
                            continue;
                        }
                        resultNew = ((BigDecimal)vpNewHashMapResult.get(valuePositionContainerNew.valuetypenumber)).add(valuePositionContainerNew.results);
                        vpNewHashMapResult.put(valuePositionContainerNew.valuetypenumber, resultNew);
                    }
                    datasetOld = dao.getDataSet(sortForValuePosition, this.getFilter(currentOidEmployee, validFromOfRc, oldEffectiveDate));
                    while (datasetOld.hasNext()) {
                        containerOld = datasetOld.getNext();
                        ValuepositionContainer valuePositionContainerOld = (ValuepositionContainer)containerOld;
                        mmpayrollresult = ValueType.getValueType((String)valuePositionContainerOld.oidvaluetype).getValueTypeTP(VDate.getDateMax(), VDate.getDateMax()).getValueTypeFoundation().getPrintSettings().getMonthlyPayrollResult();
                        if (valuePositionContainerOld.valuetypenumber > 99900 && !mmpayrollresult) continue;
                        if (vpOldHashMapResult.get(valuePositionContainerOld.valuetypenumber) == null) {
                            vpOldHashMapResult.put(valuePositionContainerOld.valuetypenumber, valuePositionContainerOld.results);
                            continue;
                        }
                        resultOld = ((BigDecimal)vpOldHashMapResult.get(valuePositionContainerOld.valuetypenumber)).add(valuePositionContainerOld.results);
                        vpOldHashMapResult.put(valuePositionContainerOld.valuetypenumber, resultOld);
                    }
                    resultNew = BigDecimal.ZERO;
                    resultOld = BigDecimal.ZERO;
                    Iterator itOldHM = vpOldHashMapResult.keySet().iterator();
                    while (itOldHM.hasNext()) {
                        int vtOld = (Integer)itOldHM.next();
                        resultOld = (BigDecimal)vpOldHashMapResult.get(vtOld);
                        if (vpNewHashMapResult.get(vtOld) != null) {
                            resultNew = (BigDecimal)vpNewHashMapResult.get(vtOld);
                            if (BigDecimalMapper.isZeroOrNull((BigDecimal)resultOld)) {
                                resultOld = new BigDecimal(0).setScale(2);
                            }
                            if (BigDecimalMapper.isZeroOrNull((BigDecimal)resultNew)) {
                                resultNew = new BigDecimal(0).setScale(2);
                            }
                            resultNew = resultNew.subtract(resultOld);
                            this.mLohnartenabrechnungBean = new LohnartenabrechnungBean(k + 2, DateHelper.getFirstDayOfMonth((Date)hMEffectiveFrom), DateHelper.getLastDayOfMonth((Date)validFromOfRc), currentEmployee, vtOld, resultNew);
                            this.fillVisibleOutputFields(containerNew);
                            this.writeLine(this.mVisibleOutputLine);
                            ++lineCount;
                            continue;
                        }
                        this.mLohnartenabrechnungBean = new LohnartenabrechnungBean(k + 2, DateHelper.getFirstDayOfMonth((Date)oldEffectiveDate), DateHelper.getLastDayOfMonth((Date)validFromOfRc), currentEmployee, vtOld, ((BigDecimal)vpOldHashMapResult.get(vtOld)).negate());
                        this.fillVisibleOutputFields(containerOld);
                        this.writeLine(this.mVisibleOutputLine);
                        ++lineCount;
                    }
                    Iterator itNewHM = vpNewHashMapResult.keySet().iterator();
                    while (itNewHM.hasNext()) {
                        int vtNew = (Integer)itNewHM.next();
                        if (vpOldHashMapResult.get(vtNew) != null) continue;
                        this.mLohnartenabrechnungBean = new LohnartenabrechnungBean(k + 2, DateHelper.getFirstDayOfMonth((Date)hMEffectiveFrom), DateHelper.getLastDayOfMonth((Date)validFromOfRc), currentEmployee, vtNew, (BigDecimal)vpNewHashMapResult.get(vtNew));
                        this.fillVisibleOutputFields(containerOld);
                        this.writeLine(this.mVisibleOutputLine);
                        ++lineCount;
                    }
                    this.mStorno = false;
                    vpNewHashMapResult.clear();
                    vpOldHashMapResult.clear();
                    validFromOfRc = PDateHelper.getFirstDayNextMonth((Date)validFromOfRc);
                }
                if (datasetOld != null) {
                    datasetOld.dispose();
                }
                if (datasetNew == null) continue;
                datasetNew.dispose();
            }
        }
        return lineCount;
    }

    private int getRecordsForLohnkonten(int lineCount) throws BusinessDomainException, IOException {
        Date listFirstDate = this.mYear.getListValidFrom();
        Date listEndDate = this.mYear.getListValidUntil();
        Employee[] allEmployeesOfCompanyOrPlant = StringMapper.isNullString((String)this.mYear.getOidPlant()) ? this.getIEmployeePM().getAllEEPCompany(this.mYear.getOidPCompany()) : this.getIEmployeePM().getAllEEPlant(this.mYear.getOidPlant(), VDate.getDateMax(), VDate.getDateMax());
        for (int i = 0; i < allEmployeesOfCompanyOrPlant.length; ++i) {
            SortedMap<Date, Date> hMDatesOfRc;
            Employee currentEmployee = allEmployeesOfCompanyOrPlant[i];
            if (!this.isSuitable(currentEmployee)) continue;
            String currentOidEmployee = currentEmployee.getObjectid();
            Date currentEmployeeFirstDate = listFirstDate;
            Date currentEmployeeEndDate = listEndDate;
            Junction filterForEmployment = Restrictions.conjunction().add((Criterion)this.mYear.getDateFilter()).add(Restrictions.eq((String)"oidemployee", (String)currentOidEmployee));
            Order[] sortForEmployment = new Order[]{Order.asc((String)"personnelnumber"), Order.asc((String)"validfrom"), Order.asc((String)"effectivefrom")};
            EmploymentallContainer[] allEmployment = daoEmploymentall.getRows(sortForEmployment, (Criterion)filterForEmployment);
            if (allEmployment.length == 0) continue;
            Order[] sortForValuePosition = new Order[]{Order.asc((String)"oidemployee"), Order.desc((String)"valuetypenumber")};
            PersistencyDataSet dataset = null;
            while (DateHelper.before((Date)currentEmployeeFirstDate, (Date)currentEmployeeEndDate)) {
                Criterion filterForValuePosition = this.getFilter(currentOidEmployee, currentEmployeeFirstDate, currentEmployeeFirstDate);
                dataset = dao.getDataSet(sortForValuePosition, filterForValuePosition);
                this.mLohnkontoBean = new LohnkontoBean(dataset, 1, DateHelper.getFirstDayOfMonth((Date)currentEmployeeFirstDate), DateHelper.getLastDayOfMonth((Date)currentEmployeeFirstDate), currentEmployee).build();
                this.fillVisibleOutputFields(null);
                this.writeLine(this.mVisibleOutputLine);
                ++lineCount;
                currentEmployeeFirstDate = PDateHelper.getFirstDayNextMonth((Date)currentEmployeeFirstDate);
            }
            if (dataset != null) {
                dataset.dispose();
            }
            if ((hMDatesOfRc = this.getDatesOfRc(currentEmployee, listFirstDate, listEndDate)).isEmpty()) continue;
            Date[] effectiveDatesOfRc = hMDatesOfRc.keySet().toArray(new Date[hMDatesOfRc.keySet().size()]);
            for (int k = 0; k < hMDatesOfRc.size(); ++k) {
                Date hMValidFrom = (Date)hMDatesOfRc.get(effectiveDatesOfRc[k]);
                Date hMEffectiveFrom = effectiveDatesOfRc[k];
                Date validFromOfRc = DateHelper.getFirstDayOfMonth((Date)hMValidFrom);
                Date oldEffectiveDate = PDateHelper.getLastDayPreviousMonth((Date)hMEffectiveFrom);
                currentEmployeeEndDate = DateHelper.after((Date)listEndDate, (Date)hMEffectiveFrom) ? DateHelper.addMonths((Date)hMEffectiveFrom, (int)-1) : DateHelper.getFirstDayOfMonth((Date)listEndDate);
                PersistencyDataSet datasetNew = null;
                PersistencyDataSet datasetOld = null;
                while (DateHelper.beforeOrEqual((Date)validFromOfRc, (Date)currentEmployeeEndDate)) {
                    LohnkontoBean lohnkontoBeanDiff;
                    datasetNew = daoRR.getDataSet(sortForValuePosition, this.getFilter(currentOidEmployee, validFromOfRc, hMEffectiveFrom));
                    LohnkontoBean lohnkontoBeanNew = new LohnkontoBean(datasetNew, k + 2, DateHelper.getFirstDayOfMonth((Date)hMEffectiveFrom), DateHelper.getLastDayOfMonth((Date)validFromOfRc), currentEmployee).build();
                    datasetOld = dao.getDataSet(sortForValuePosition, this.getFilter(currentOidEmployee, validFromOfRc, oldEffectiveDate));
                    LohnkontoBean lohnkontoBeanOld = new LohnkontoBean(datasetOld, k + 2, DateHelper.getFirstDayOfMonth((Date)oldEffectiveDate), DateHelper.getLastDayOfMonth((Date)validFromOfRc), currentEmployee).build();
                    this.mLohnkontoBean = lohnkontoBeanDiff = lohnkontoBeanNew.diff(lohnkontoBeanOld);
                    this.fillVisibleOutputFields(null);
                    this.writeLine(this.mVisibleOutputLine);
                    ++lineCount;
                    validFromOfRc = PDateHelper.getFirstDayNextMonth((Date)validFromOfRc);
                }
                if (datasetOld != null) {
                    datasetOld.dispose();
                }
                if (datasetNew == null) continue;
                datasetNew.dispose();
            }
        }
        return lineCount;
    }

    private int getRecordsForArbeitnehmer(int lineCount) throws BusinessDomainException, IOException {
        Date listFirstDate = this.mYear.getListValidFrom();
        Date listEndDate = this.mYear.getListValidUntil();
        Employee[] allEmployeesOfCompanyOrPlant = StringMapper.isNullString((String)this.mYear.getOidPlant()) ? this.getIEmployeePM().getAllEEPCompany(this.mYear.getOidPCompany()) : this.getIEmployeePM().getAllEEPlant(this.mYear.getOidPlant(), VDate.getDateMax(), VDate.getDateMax());
        for (int i = 0; i < allEmployeesOfCompanyOrPlant.length; ++i) {
            SortedMap<Date, Date> hMDatesOfRc;
            Employee currentEmployee = allEmployeesOfCompanyOrPlant[i];
            if (!this.isSuitable(currentEmployee)) continue;
            String currentOidEmployee = currentEmployee.getObjectid();
            Date currentEmployeeFirstDate = listFirstDate;
            Date currentEmployeeEndDate = listEndDate;
            Junction filterForEmployment = Restrictions.conjunction().add((Criterion)this.mYear.getDateFilter()).add(Restrictions.eq((String)"oidemployee", (String)currentOidEmployee));
            EmploymentallContainer[] employmentallContainers = daoEmploymentall.getRows(null, (Criterion)filterForEmployment);
            if (employmentallContainers.length == 0) continue;
            PersistencyDataSet dataset = null;
            while (DateHelper.before((Date)currentEmployeeFirstDate, (Date)currentEmployeeEndDate)) {
                dataset = daoEmploymentall.getDataSet(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)currentOidEmployee), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)currentEmployeeFirstDate)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)currentEmployeeFirstDate)), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)currentEmployeeFirstDate))), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)currentEmployeeFirstDate)))}));
                while (dataset.hasNext()) {
                    EmploymentallContainer container = (EmploymentallContainer)dataset.getNext();
                    this.mArbeitnehmerBean = new ArbeitnehmerBean(1, DateHelper.getFirstDayOfMonth((Date)currentEmployeeFirstDate), DateHelper.getLastDayOfMonth((Date)currentEmployeeFirstDate), currentEmployee);
                    this.fillVisibleOutputFields((PersistencyContainer)container);
                    this.writeLine(this.mVisibleOutputLine);
                    ++lineCount;
                }
                currentEmployeeFirstDate = PDateHelper.getFirstDayNextMonth((Date)currentEmployeeFirstDate);
            }
            if (dataset != null) {
                dataset.dispose();
            }
            if ((hMDatesOfRc = this.getDatesOfRc(currentEmployee, listFirstDate, listEndDate)).isEmpty()) continue;
            Date[] effectiveDatesOfRc = hMDatesOfRc.keySet().toArray(new Date[hMDatesOfRc.keySet().size()]);
            for (int k = 0; k < hMDatesOfRc.size(); ++k) {
                Date hMValidFrom = (Date)hMDatesOfRc.get(effectiveDatesOfRc[k]);
                Date hMEffectiveFrom = effectiveDatesOfRc[k];
                currentEmployeeEndDate = DateHelper.after((Date)listEndDate, (Date)hMEffectiveFrom) ? DateHelper.addMonths((Date)hMEffectiveFrom, (int)-1) : DateHelper.getFirstDayOfMonth((Date)listEndDate);
                Date validFromOfRc = DateHelper.getFirstDayOfMonth((Date)hMValidFrom);
                while (DateHelper.beforeOrEqual((Date)validFromOfRc, (Date)currentEmployeeEndDate)) {
                    PersistencyDataSet datasetRR = daoEmploymentall.getDataSet(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)currentOidEmployee), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)hMEffectiveFrom)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)hMEffectiveFrom)), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)validFromOfRc)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)validFromOfRc))}));
                    while (datasetRR.hasNext()) {
                        EmploymentallContainer container = (EmploymentallContainer)datasetRR.getNext();
                        this.mArbeitnehmerBean = new ArbeitnehmerBean(k + 2, DateHelper.getFirstDayOfMonth((Date)hMEffectiveFrom), DateHelper.getLastDayOfMonth((Date)validFromOfRc), currentEmployee);
                        this.fillVisibleOutputFields((PersistencyContainer)container);
                        this.writeLine(this.mVisibleOutputLine);
                        ++lineCount;
                    }
                    datasetRR.dispose();
                    validFromOfRc = PDateHelper.getFirstDayNextMonth((Date)validFromOfRc);
                }
            }
        }
        return lineCount;
    }

    private SortedMap<Date, Date> getDatesOfRc(Employee employee, Date first, Date end) {
        TreeMap<Date, Date> datesForRR = new TreeMap<Date, Date>((Comparator<Date>)new DateComparator());
        PersistencyDataSet calculationbasicData = daoCalculationbasic.getDataSet(new Order[]{Order.asc((String)"effectivefrom"), Order.asc((String)"validfrom")}, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)employee.getObjectid()), Restrictions.ge((String)"effectivefrom", (String)DateMapper.toString((Date)first)), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)end)), Restrictions.sqlRestriction((String)"validfrom < effectivefrom")}));
        while (calculationbasicData.hasNext()) {
            CalculationbasicContainer calculationbasicContainer = (CalculationbasicContainer)calculationbasicData.getNext();
            if (!DateHelper.beforeOrEqual((Date)calculationbasicContainer.effectivefrom, (Date)DateHelper.getFirstDayOfMonth((Date)employee.getJournalizedUntil())) || !DateHelper.afterOrEqual((Date)calculationbasicContainer.validfrom, (Date)first)) continue;
            Date minValidDate = (Date)datesForRR.get(calculationbasicContainer.effectivefrom);
            if (minValidDate != null) {
                if (!minValidDate.after(calculationbasicContainer.validfrom)) continue;
                datesForRR.put(calculationbasicContainer.effectivefrom, calculationbasicContainer.validfrom);
                continue;
            }
            datesForRR.put(calculationbasicContainer.effectivefrom, calculationbasicContainer.validfrom);
        }
        ArrayList<Date> removeDatesOfRc = new ArrayList<Date>();
        if (!datesForRR.isEmpty()) {
            for (Date searchDate : datesForRR.keySet()) {
                boolean relevant = false;
                ValuePosition[] vps = ValuePositionPersistencyManager.queryWithOutSort((Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)employee.getObjectid()), Restrictions.eq((String)"effectivefrom", (String)DateMapper.toString((Date)searchDate)), Restrictions.eq((String)"validfrom", (String)DateMapper.toString((Date)searchDate)), Restrictions.eq((String)"valuetypenumber", (String)String.valueOf(882000))}));
                if (vps.length > 0 && !BigDecimalMapper.isZeroOrNull((BigDecimal)vps[0].getResult())) {
                    relevant = true;
                }
                if (vps.length > 0 && BigDecimalMapper.isZeroOrNull((BigDecimal)vps[0].getResult())) {
                    Date hMValidFrom = (Date)datesForRR.get(searchDate);
                    Date hMEffectiveFrom = searchDate;
                    Date validFromOfRc = DateHelper.getFirstDayOfMonth((Date)hMValidFrom);
                    Date oldEffectiveDate = PDateHelper.getLastDayPreviousMonth((Date)hMEffectiveFrom);
                    Date until = DateHelper.after((Date)this.mYear.getListValidUntil(), (Date)hMEffectiveFrom) ? DateHelper.addMonths((Date)hMEffectiveFrom, (int)-1) : DateHelper.getFirstDayOfMonth((Date)this.mYear.getListValidUntil());
                    while (DateHelper.beforeOrEqual((Date)validFromOfRc, (Date)until) && !relevant) {
                        BigDecimal oldSpeziellesBrutto;
                        BigDecimal newSpeziellesBrutto;
                        BigDecimal oldPauschSteuern;
                        BigDecimal newPauschSteuern = this.getPauschSteuern(employee, hMEffectiveFrom, validFromOfRc);
                        if (!PBigDecimalMapper.isEqual((BigDecimal)newPauschSteuern, (BigDecimal)(oldPauschSteuern = this.getPauschSteuern(employee, oldEffectiveDate, validFromOfRc)))) {
                            relevant = true;
                        }
                        if (!PBigDecimalMapper.isEqual((BigDecimal)(newSpeziellesBrutto = this.getSpeziellesBrutto(employee, hMEffectiveFrom, validFromOfRc)), (BigDecimal)(oldSpeziellesBrutto = this.getSpeziellesBrutto(employee, oldEffectiveDate, validFromOfRc)))) {
                            relevant = true;
                        }
                        validFromOfRc = PDateHelper.getFirstDayNextMonth((Date)validFromOfRc);
                    }
                }
                if (relevant) continue;
                removeDatesOfRc.add(searchDate);
            }
            for (Date date : removeDatesOfRc) {
                datesForRR.remove(date);
            }
        }
        return datesForRR;
    }

    private BigDecimal getPauschSteuern(Employee employee, Date hMEffectiveFrom, Date validFromOfRc) {
        ValuePosition[] pauschSteuern = ValuePositionPersistencyManager.queryWithOutSort((Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)employee.getObjectid()), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)hMEffectiveFrom)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)hMEffectiveFrom)), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)validFromOfRc)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)validFromOfRc)), Restrictions.in((String)"valuetypenumber", (String[])new String[]{String.valueOf(710010), String.valueOf(760600)})}));
        BigDecimal result = BigDecimal.ZERO;
        for (int m = 0; m < pauschSteuern.length; ++m) {
            result = result.add(pauschSteuern[m].getResult());
        }
        return result;
    }

    private BigDecimal getSpeziellesBrutto(Employee employee, Date hMEffectiveFrom, Date validFromOfRc) {
        ValuePosition[] pauschSteuern = ValuePositionPersistencyManager.queryWithOutSort((Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)employee.getObjectid()), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)hMEffectiveFrom)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)hMEffectiveFrom)), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)validFromOfRc)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)validFromOfRc)), Restrictions.in((String)"valuetypenumber", (String[])new String[]{String.valueOf(110000), String.valueOf(101000)})}));
        BigDecimal result = BigDecimal.ZERO;
        for (int m = 0; m < pauschSteuern.length; ++m) {
            result = result.add(pauschSteuern[m].getResult());
        }
        return result;
    }

    private OutputLine makeOutputLine(OutputField[] fields) {
        if (fields == null) {
            fields = new OutputField[]{};
        }
        LinkedList<Object> fieldList = new LinkedList<Object>();
        for (int i = 0; i < fields.length; ++i) {
            if (i > 0 && this.mFieldSeparator != null) {
                fieldList.add(this.mFieldSeparator);
            }
            fieldList.add(fields[i]);
        }
        OutputField[] allFields = new OutputField[fieldList.size()];
        fieldList.toArray(allFields);
        OutputLine result = new OutputLine(allFields);
        return result;
    }

    protected abstract void fillVisibleOutputFields(PersistencyContainer var1) throws BusinessDomainException;

    protected abstract void fillVisibleOutputFieldsPlants(PersistencyContainer var1) throws BusinessDomainException;

    protected void writeLine(OutputLine line) throws IOException {
        LOGGER.debug("writing line {}", (Object)(line == null ? "null" : line.getOutputString()));
        if (line != null) {
            this.mActiveWriter.write(line.getOutputString());
            if (this.mLineSeparator != null) {
                this.mActiveWriter.write(this.mLineSeparator.getAsString());
            }
        }
    }

    public Element getXMLDescription() {
        Element url = new Element("URL");
        url.setText(this.mFileName);
        Element name = new Element("Name");
        String withoutCharacter = this.getWithoutCharacters(this.mCode);
        name.setText(withoutCharacter);
        Element description = new Element("Description");
        withoutCharacter = this.getWithoutCharacters(this.mDescription);
        name.setText(withoutCharacter);
        Element decimalSymbol = new Element("DecimalSymbol");
        decimalSymbol.setText(new String(new char[]{this.mDecimalPoint}));
        Element digitGroupuingSymbol = new Element("DigitGroupingSymbol");
        digitGroupuingSymbol.setText(new String(new char[]{this.mDigitGroupingSymbol}));
        Element result = new Element("Table");
        result.addContent((Content)url);
        result.addContent((Content)name);
        result.addContent((Content)description);
        result.addContent((Content)decimalSymbol);
        result.addContent((Content)digitGroupuingSymbol);
        Element recordDelimiter = this.getRecordDelimiter();
        Element columnDelimiter = null;
        StringBuffer columnsName = new StringBuffer();
        if (this.mFixedLength) {
            columnsName.append("Fixed");
        } else {
            columnsName.append("Variable");
            columnDelimiter = this.getColumnDelimiter();
        }
        columnsName.append("Length");
        Element columnsElement = new Element(columnsName.toString());
        if (recordDelimiter != null) {
            columnsElement.addContent((Content)recordDelimiter);
        }
        if (columnDelimiter != null) {
            columnsElement.addContent((Content)columnDelimiter);
        }
        int columnStart = 1;
        for (int i = 0; i < this.mVisibleColumns.length; ++i) {
            columnsElement.addContent((Content)this.mVisibleColumns[i].getXMLDescription(columnStart));
            columnStart += this.mVisibleColumns[i].getMaxLength();
            columnStart += this.mFieldSeparator.getLength();
        }
        result.addContent((Content)columnsElement);
        return result;
    }

    protected Element getRecordDelimiter() {
        Element recordDelimiter = new Element("RecordDelimiter");
        recordDelimiter.setText(ExportHelper.toXMLNotation((String)this.mLineSeparator.getAsString()));
        return recordDelimiter;
    }

    protected Element getColumnDelimiter() {
        Element columnDelimiter = new Element("ColumnDelimiter");
        columnDelimiter.setText(ExportHelper.toXMLNotation((String)this.mFieldSeparator.getAsString()));
        return columnDelimiter;
    }

    protected String[] getRelevantVT(Date effectivefrom, Date validfrom) {
        Order[] sortVT = new Order[]{Order.asc((String)"valuetypenumber"), Order.asc((String)"effectivefrom"), Order.asc((String)"validfrom")};
        ValueTypeTP[] vtTP = ValueType.getValueTypes((Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)effectivefrom))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)effectivefrom))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfYear((Date)validfrom))), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfYear((Date)validfrom))), Restrictions.eq((String)"mmpayrollresult", (String)"T")}), (Order[])sortVT);
        String[] liTP = new String[vtTP.length];
        for (int i = 0; i < vtTP.length; ++i) {
            if (vtTP[i].getValueType().getValueTypeKey() >= 890000) continue;
            liTP[i] = Integer.toString(vtTP[i].getValueType().getValueTypeKey());
        }
        return liTP;
    }

    protected Criterion getFilter(String oidEmployee, Date validFrom, Date effectiveDate) {
        Conjunction listFilElemStructEmpl2 = Restrictions.conjunction();
        listFilElemStructEmpl2.add((Criterion)this.getDateFilterMonthEmployee(oidEmployee, validFrom, effectiveDate));
        Criterion fes2 = Restrictions.le((String)"valuetypenumber", (String)"890100");
        listFilElemStructEmpl2.add(fes2);
        Conjunction filter = listFilElemStructEmpl2;
        return filter;
    }

    protected Junction getDateFilterMonthEmployee(String oidEmployee, Date validfrom, Date effectiveFrom) {
        Conjunction dateFilter = Restrictions.conjunction();
        Criterion fes = Restrictions.le((String)"effectiveFrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)effectiveFrom)));
        dateFilter.add(fes);
        fes = Restrictions.ge((String)"effectiveUntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)effectiveFrom)));
        dateFilter.add(fes);
        fes = Restrictions.le((String)"validFrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)validfrom)));
        dateFilter.add(fes);
        fes = Restrictions.ge((String)"validUntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)validfrom)));
        dateFilter.add(fes);
        fes = Restrictions.eq((String)"oidemployee", (String)oidEmployee);
        dateFilter.add(fes);
        return dateFilter;
    }

    protected boolean compare(ValuepositionContainer valPosContOld, ValuepositionContainer valPosContNew) {
        if (valPosContNew.valuetypenumber == valPosContOld.valuetypenumber) {
            BigDecimal percOld = valPosContOld.percentage == null ? new BigDecimal("0.000") : valPosContOld.percentage;
            BigDecimal percNew = valPosContNew.percentage == null ? new BigDecimal("0.000") : valPosContNew.percentage;
            if (valPosContNew.factor1.compareTo(valPosContOld.factor1) != 0 || valPosContNew.results.compareTo(valPosContOld.results) != 0 || percNew.compareTo(percOld) != 0) {
                return true;
            }
        }
        return false;
    }

    private String getWithoutCharacters(String code) {
        String withoutCharacter = code;
        withoutCharacter = withoutCharacter.replaceAll("\u00f6", "oe");
        withoutCharacter = withoutCharacter.replaceAll("\u00e4", "ae");
        withoutCharacter = withoutCharacter.replaceAll("\u00fc", "ue");
        withoutCharacter = withoutCharacter.replaceAll("\u00df", "ss");
        withoutCharacter = withoutCharacter.replace(' ', '_');
        withoutCharacter = withoutCharacter.replaceAll("\u00d6", "Oe");
        withoutCharacter = withoutCharacter.replaceAll("\u00c4", "Ae");
        withoutCharacter = withoutCharacter.replaceAll("\u00dc", "Ue");
        withoutCharacter = withoutCharacter.replaceAll("\u00a7", "Par.");
        return withoutCharacter;
    }

    private IEmployeePersistencyManager getIEmployeePM() {
        return (IEmployeePersistencyManager)UtilitiesManager.getBean((String)"employeePersistencyManager", IEmployeePersistencyManager.class);
    }

    public void setCompPlantYear(CompPlantYear cpYear) {
        this.mYear = cpYear;
    }

    public boolean isSuitable(Employee employee) throws BusinessDomainException {
        int months = employee.getPCompany().getCompanyFoundations(VDate.getDateMax(), VDate.getDateMax()).getMonthsOfCalculation();
        Date startDateForOutput = DateMapper.toDate((String)this.mYear.getShortStruct().validFromMin);
        Date referenceDate = DateHelper.getFirstDayOfMonth((Date)new VDate(startDateForOutput).addMonths(months *= -1).getDate());
        Date lastDateOfWithdrawal = employee.getLastDateOfWithdrawal();
        return lastDateOfWithdrawal == null || !DateHelper.beforeOrEqual((Date)lastDateOfWithdrawal, (Date)referenceDate);
    }
}

