/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.framework.checkup;

import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.common.persistency.payment.IPaymentsessionDao;
import com.varial.personnel.domain.pcompany.PCompany;
import com.varial.personnel.domain.pcompany.PCompanyPersistencyManager;
import com.varial.personnel.domain.reports.mapper.PaymentExceptionMapper;
import com.varial.serverbase.mapper.StringMapper;

public class NameOfPayment {
    private static IPaymentsessionDao daoPaymentsession = (IPaymentsessionDao)UtilitiesManager.getApplicationContext().getBean("paymentsessionDao");
    private final String mNameOfPayment;
    private final PCompany mPCompany;

    public NameOfPayment(String nameOfPayment) {
        this.mNameOfPayment = nameOfPayment;
        this.mPCompany = null;
    }

    public NameOfPayment(String nameOfPayment, String oidPCompany) {
        this.mNameOfPayment = nameOfPayment;
        this.mPCompany = PCompanyPersistencyManager.getPCompany((String)oidPCompany);
    }

    public NameOfPayment(String nameOfPayment, PCompany pCompany) {
        this.mNameOfPayment = nameOfPayment;
        this.mPCompany = pCompany;
    }

    public void checkNameOfPayment() throws BusinessDomainException {
        if (this.isNullString()) {
            throw PaymentExceptionMapper.makeNoNameForPaymentDomainException();
        }
        if (this.isInvalidLength()) {
            throw PaymentExceptionMapper.makeNameOfPaymentToLongDomainException();
        }
        if (this.isNameDuplicate()) {
            if (this.mPCompany != null) {
                throw PaymentExceptionMapper.makeDuplicateName((String)("der Name: " + this.mNameOfPayment + " f\u00fcr die Firma: " + this.mPCompany.getPCompanyKey()));
            }
            throw PaymentExceptionMapper.makeDuplicateName((String)("der Name: " + this.mNameOfPayment));
        }
        for (char c : this.mNameOfPayment.toCharArray()) {
            switch (c) {
                case '\"': 
                case '*': 
                case '/': 
                case ':': 
                case '<': 
                case '>': 
                case '?': 
                case '\\': 
                case '|': {
                    throw PaymentExceptionMapper.makeWrongCharName((String)this.mNameOfPayment);
                }
            }
        }
    }

    public boolean isNullString() {
        return StringMapper.isNullString((String)this.mNameOfPayment);
    }

    public boolean isInvalidLength() {
        return this.mNameOfPayment.length() > 28;
    }

    public boolean isNameDuplicate() {
        long rowCount = 0L;
        rowCount = this.mPCompany == null ? daoPaymentsession.getRowCount(Restrictions.eq((String)"name", (String)this.mNameOfPayment)) : daoPaymentsession.getRowCount(Restrictions.and((Criterion)Restrictions.eq((String)"name", (String)(this.mNameOfPayment + "          0")), (Criterion)Restrictions.eq((String)"oidcompany", (String)this.mPCompany.getObjectid())));
        return rowCount > 0L;
    }
}

