/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.framework;

import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.security.AuthorizationToken;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.absenttime.EEAbsentTimeTP;
import com.varial.personnel.domain.employee.advancepayment.AdvancePaymentTP;
import com.varial.personnel.domain.employee.deuvdskk.EEDeuvDskkTP;
import com.varial.personnel.domain.employee.fixedpayment.FixedPaymentTP;
import com.varial.personnel.domain.employee.scalepayment.ScalePaymentTP;
import com.varial.personnel.domain.employee.varpayment.VarPaymentTP;
import com.varial.personnel.framework.IValuationManager;
import com.varial.personnel.framework.PersonnelPersistenceObject;
import com.varial.personnel.framework.mapper.FrameWorkExceptionMapper;
import com.varial.personnel.framework.personnelbasic.PersonnelBasic;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.persistency.PersistentObject;
import java.util.Date;

public abstract class PersonnelTimedPersistenceObject
extends PersistentObject {
    protected Date mEffectiveFrom;
    protected Date mEffectiveUntil;
    protected Date mValidFrom;
    protected Date mValidUntil;
    protected boolean mValuateNeeded = false;
    protected boolean mOnlyValidUntilChanged = false;
    protected boolean mDEUVTriggerNeededIndependent = false;
    protected boolean mDEUVTriggerNeededDependent = false;

    protected PersonnelTimedPersistenceObject(int priority) {
        super(priority);
    }

    protected PersonnelTimedPersistenceObject(int priority, String oid) {
        super(priority, oid);
    }

    protected PersonnelTimedPersistenceObject(int priority, String oid, int version) {
        super(priority, oid, version);
    }

    protected PersonnelTimedPersistenceObject(int priority, boolean readOnly) {
        super(priority, readOnly);
    }

    public Date getEffectiveFrom() {
        this.requireLoaded();
        return this.mEffectiveFrom;
    }

    public void setEffectiveFrom(Date effectiveFrom) {
        this.protocol("EffectivFrom", this.mEffectiveFrom, effectiveFrom);
        this.mEffectiveFrom = effectiveFrom;
    }

    public Date getEffectiveUntil() {
        this.requireLoaded();
        return this.mEffectiveUntil;
    }

    public void setEffectiveUntil(Date effectiveUntil) {
        if (effectiveUntil == null || effectiveUntil.equals("")) {
            effectiveUntil = VDate.getDateMax();
        }
        this.protocol("EffectiveUntil", this.mEffectiveUntil, effectiveUntil);
        this.mEffectiveUntil = effectiveUntil;
    }

    public Date getValidFrom() {
        this.requireLoaded();
        return this.mValidFrom;
    }

    public void setValidFrom(Date validFrom) {
        this.protocol("ValidFrom", this.mValidFrom, validFrom);
        this.mValidFrom = validFrom;
    }

    public Date getValidUntil() {
        this.requireLoaded();
        return this.mValidUntil;
    }

    public void setValidUntil(Date validUntil) {
        if (validUntil == null || validUntil.equals("")) {
            validUntil = VDate.getDateMax();
        }
        this.protocol("ValidUntil", this.mValidUntil, validUntil);
        this.mValidUntil = validUntil;
    }

    public boolean getValuateNeeded() {
        return this.mValuateNeeded;
    }

    public void setValuateNeeded(boolean valuateNeeded) {
        this.mValuateNeeded = valuateNeeded;
    }

    public boolean getOnlyValidUntilChanged() {
        return this.mOnlyValidUntilChanged;
    }

    public void setOnlyValidUntilChanged(boolean onlyValidUntilChanged) {
        this.mOnlyValidUntilChanged = onlyValidUntilChanged;
    }

    public boolean getDEUVTriggerNeededDependent() {
        return this.mDEUVTriggerNeededDependent;
    }

    public void setDEUVTriggerNeededDependent(boolean deuvTriggerNeeded) {
        this.mDEUVTriggerNeededDependent = deuvTriggerNeeded;
    }

    public void lastExecuteImpl() throws BusinessDomainException {
        this.save();
    }

    protected abstract PersonnelTimedPersistenceObject createNew();

    public abstract void checkAttributes() throws BusinessDomainException;

    public void checkDates() throws BusinessDomainException {
        if (this.mValidFrom == null) {
            throw FrameWorkExceptionMapper.makeValidFromIsEmptyDomainException();
        }
        if (DateHelper.after((Date)this.mValidFrom, (Date)VDate.getDateMax())) {
            this.setValidFrom(VDate.getDateMax());
        }
        if (DateHelper.after((Date)this.mValidUntil, (Date)VDate.getDateMax())) {
            this.setValidUntil(VDate.getDateMax());
        }
        if (DateHelper.before((Date)this.mValidUntil, (Date)this.mValidFrom)) {
            throw FrameWorkExceptionMapper.makeValidFromGreaterThanValidUntilDomainException();
        }
        if (this.mEffectiveFrom == null) {
            this.setEffectiveFrom(this.mValidFrom);
        }
        PersonnelBasic pb = PersonnelBasic.getPersonnelBasic();
        if (DateHelper.before((Date)this.getEffectiveFrom(), (Date)pb.getSystemStart())) {
            this.setEffectiveFrom(pb.getSystemStart());
        }
        if (!(this instanceof VarPaymentTP || this instanceof FixedPaymentTP || this instanceof ScalePaymentTP || this instanceof EEAbsentTimeTP || this instanceof AdvancePaymentTP || this instanceof EEDeuvDskkTP)) {
            this.mValidFrom = DateHelper.getFirstDayOfMonth((Date)this.mValidFrom);
        }
    }

    public void checkValidFromAgainstRetroactiveCalculation(Employee employee) throws BusinessDomainException {
    }

    public boolean inEffectiveness(Date stichTag) {
        boolean result = false;
        if (DateHelper.afterOrEqual((Date)stichTag, (Date)this.mEffectiveFrom) && DateHelper.beforeOrEqual((Date)stichTag, (Date)this.mEffectiveUntil)) {
            result = true;
        }
        return result;
    }

    public boolean inValidness(Date stichTag) {
        boolean result = false;
        if (DateHelper.afterOrEqual((Date)stichTag, (Date)this.mValidFrom) && DateHelper.beforeOrEqual((Date)stichTag, (Date)this.mValidUntil)) {
            result = true;
        }
        return result;
    }

    public void makeComplete() {
        if (this.mEffectiveUntil == null) {
            this.mEffectiveUntil = VDate.getDateMax();
        }
        if (this.mValidUntil == null) {
            this.mValidUntil = VDate.getDateMax();
        }
    }

    public abstract String getRootDomainKey();

    public abstract String getNaturalLanguageClassName();

    protected void checkTimePeriods(PersonnelPersistenceObject<?> bo) throws BusinessDomainException {
        if (bo != null) {
            bo.checkTimePeriod(this.mEffectiveFrom, this.mValidFrom);
        }
    }

    public void createCalculationJob(AuthorizationToken token, Employee employee, PersonnelTimedPersistenceObject old, String className) throws BusinessDomainException {
        if (this.getValuateNeeded()) {
            PersonnelBasic pb;
            Date valuateEffectiveFrom = this.getEffectiveFrom();
            Date valuateValidFrom = DateHelper.getFirstDayOfMonth((Date)this.getValidFrom());
            if (this.getOnlyValidUntilChanged() && DateHelper.after((Date)(valuateValidFrom = DateHelper.before((Date)old.getValidUntil(), (Date)this.getValidUntil()) ? old.getValidUntil() : this.getValidUntil()), (Date)(pb = PersonnelBasic.getPersonnelBasic()).getCalculationUntil(employee.getJournalizedUntil()))) {
                valuateValidFrom = pb.getCalculationUntil(employee.getJournalizedUntil());
            }
            valuateValidFrom = employee.checkAndCorrectValidFromStartOfValuate(valuateEffectiveFrom, valuateValidFrom);
            ((IValuationManager)UtilitiesManager.getBean((String)"valuationManager", IValuationManager.class)).valuate(token, employee, valuateEffectiveFrom, valuateValidFrom, className);
        }
    }

    protected void toStringValues(StringBuilder b) {
        b.append("valid").append('[').append(DateMapper.toDDMMYYYYPointSeparationString((Date)this.mValidFrom)).append("-");
        b.append(DateMapper.toDDMMYYYYPointSeparationString((Date)this.mValidUntil)).append(']').append(',');
        b.append("effective").append('[').append(DateMapper.toDDMMYYYYPointSeparationString((Date)this.mEffectiveFrom)).append("-");
        b.append(DateMapper.toDDMMYYYYPointSeparationString((Date)this.mEffectiveUntil)).append(']').append(',');
    }
}

