/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.reports.statementofcontributionzvk;

import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.jasperreports.JasperParameterHashMap;
import com.varial.base.persistency.PersistencyDataSet;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.session.SessionContext;
import com.varial.base.types.date.DateHelper;
import com.varial.framework.basictypes.CorbaExceptionMapper;
import com.varial.personnel.domain.assignments.pcompanyzvk.AssignmentPCompanyZVK;
import com.varial.personnel.domain.assignments.pcompanyzvk.AssignmentPCompanyZVKPersistencyManager;
import com.varial.personnel.domain.assignments.pcompanyzvk.AssignmentPCompanyZVKTP;
import com.varial.personnel.domain.companyplant.CompanyPlantPostalAddress;
import com.varial.personnel.domain.companyplant.Foundations;
import com.varial.personnel.domain.companyplant.GeneralEmploymentOffice;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.IEmployeePersistencyManager;
import com.varial.personnel.domain.employee.master.Master;
import com.varial.personnel.domain.employee.zvk.EEZVK;
import com.varial.personnel.domain.global.bank.Bank;
import com.varial.personnel.domain.global.recipient.ModeOfPaymentEnum;
import com.varial.personnel.domain.global.recipient.Recipient;
import com.varial.personnel.domain.global.recipient.RecipientTP;
import com.varial.personnel.domain.global.recipient.zvk.ZVK;
import com.varial.personnel.domain.pcompany.PCompany;
import com.varial.personnel.domain.pcompany.account.CompanyAccount;
import com.varial.personnel.domain.pcompany.emploffice.CompanyEmploymentOffice;
import com.varial.personnel.domain.pcompany.foundations.CompanyFoundations;
import com.varial.personnel.domain.plant.IPlantPersistencyManager;
import com.varial.personnel.domain.plant.Plant;
import com.varial.personnel.domain.plant.emploffice.PlantEmploymentOffice;
import com.varial.personnel.domain.plant.foundations.PlantFoundations;
import com.varial.personnel.domain.reports.ArchivingMetadata;
import com.varial.personnel.domain.reports.EmployeeForReport;
import com.varial.personnel.domain.reports.ProgressBarUpdater;
import com.varial.personnel.domain.reports.ReportFirstFilterStruct;
import com.varial.personnel.domain.reports.ReportSecondFilterStruct;
import com.varial.personnel.domain.reports.ReportSortStruct;
import com.varial.personnel.domain.reports.ReportThirdFilterStruct;
import com.varial.personnel.domain.reports.library.EmployeeForReportGenerator;
import com.varial.personnel.domain.reports.library.ReportEmployeesHandlingHelper;
import com.varial.personnel.domain.reports.library.ReportHelper;
import com.varial.personnel.domain.reports.library.ReportValues;
import com.varial.personnel.domain.reports.mapper.ReportExceptionMapper;
import com.varial.personnel.domain.reports.statementofcontributionkvdr.PaymentCompHealthFundBean;
import com.varial.personnel.domain.reports.statementofcontributionzvk.PaymentCompRecipientBean;
import com.varial.personnel.domain.reports.statementofcontributionzvk.StatementOfContributionListTypeEnum;
import com.varial.personnel.domain.reports.statementofcontributionzvk.StatementOfContributionZVKAvisReportBean;
import com.varial.personnel.domain.reports.statementofcontributionzvk.StatementOfContributionZVKReportBean;
import com.varial.personnel.domain.reports.statementofcontributionzvk.StatementOfContributionZVKReportBeans;
import com.varial.personnel.domain.reports.statementofcontributionzvk.StatementOfContributionZVKSummBean;
import com.varial.personnel.domain.reports.statementofcontributionzvk.StatementOfContributionZVKTypeBean;
import com.varial.personnel.domain.reports.statementofcontributionzvk.ZVKReportPayment;
import com.varial.personnel.framework.ISpecialAccessPersistencyContext;
import com.varial.personnel.framework.basictypes.BankAccount;
import com.varial.personnel.framework.basictypes.PDateHelper;
import com.varial.personnel.framework.basictypes.PostalAddress;
import com.varial.personnel.framework.basictypes.TypeOfBankTransferEnum;
import com.varial.personnel.framework.mapper.FrameWorkExceptionMapper;
import com.varial.personnel.persistency.company.companyaccount.CompanyaccountContainer;
import com.varial.personnel.persistency.company.companyaccount.ICompanyaccountDao;
import com.varial.personnel.persistency.company.companyaccounttp.CompanyaccounttpContainer;
import com.varial.personnel.persistency.company.companyaccounttp.ICompanyaccounttpDao;
import com.varial.personnel.persistency.employee.valueposition.ValuepositionContainer;
import com.varial.personnel.persistency.global.fstateregionall.FstateregionallContainer;
import com.varial.personnel.persistency.global.fstateregionall.IFstateregionallDao;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.domain.language.Language;
import com.varial.serverbase.domain.language.LanguageManager;
import com.varial.serverbase.mapper.BigDecimalFormatter;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.persistency.IPersistentObject;
import com.varial.serverbase.query.AllCallback;
import com.varial.serverbase.query.PutDataException;
import com.varial.shared.Version;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StatementOfContributionZVKReportDataSource
implements JRDataSource {
    private static IFstateregionallDao daoFstateregionall = (IFstateregionallDao)UtilitiesManager.getBean((String)"fstateregionallDao", IFstateregionallDao.class);
    private static IPlantPersistencyManager pm = (IPlantPersistencyManager)UtilitiesManager.getBean((String)"plantPersistencyManager", IPlantPersistencyManager.class);
    private ICompanyaccounttpDao daoCompanyaccounttp = (ICompanyaccounttpDao)UtilitiesManager.getBean((String)"companyaccounttpDao", ICompanyaccounttpDao.class);
    private final ICompanyaccountDao daoCompanyaccount = (ICompanyaccountDao)UtilitiesManager.getBean((String)"companyaccountDao", ICompanyaccountDao.class);
    private static Logger LOGGER = LoggerFactory.getLogger(StatementOfContributionZVKReportDataSource.class);
    private final ReportHelper mReportHelper = (ReportHelper)UtilitiesManager.getBean((String)"reportHelper", ReportHelper.class);
    private final String[] mResultValueTypeNumber = new String[]{"100900", "100910", "100920", "100930", "100970", "100940", "100950", "100960", "111200"};
    private PaymentCompHealthFundBean mPaymentCompHealthFundBean;
    Map<String, StatementOfContributionZVKAvisReportBean> ZVKAvisBeanHM = new HashMap<String, StatementOfContributionZVKAvisReportBean>();
    private String FIELD_jahr = "";
    private String FIELD_firma_bezeichnung = "";
    private String FIELD_betriebsstaette_bezeichnung = "";
    private final String FIELD_betriebsstaette_beitragskonto_nr = "";
    private String FIELD_recipient_bezeichnung = "";
    private String FIELD_recipient_key = "";
    private String FIELD_firma_nr = "";
    private String FIELD_betriebsstaette_nr = "";
    private String FIELD_recipient_str_nr = "";
    private String FIELD_recipient_plz_ort = "";
    private String FIELD_zvk_betriebsnummer = "";
    private String FIELD_zvk_art = "";
    private String FIELD_umlage_aga = "";
    private String FIELD_umlage_ana = "";
    private String FIELD_zusaetzl_umlage_aga = "";
    private String FIELD_zusatzbeitr_aga = "";
    private String FIELD_zusatzbeitr_ana = "";
    private String FIELD_sanierungsgeld = "";
    private String FIELD_sv_pflicht_anteil = "";
    private BigDecimal FIELD_hoechstbetrag = BigDecimal.ZERO;
    private BigDecimal FIELD_grenzbetrag = BigDecimal.ZERO;
    private String FIELD_verdoppelungsmonat = "";
    private String FIELD_AG_str_nr = "";
    private String FIELD_AG_plz_ort = "";
    private String FIELD_AG_beitragskontonummer = "";
    private String FIELD_AG_VWE_NR = "";
    private final String FIELD_rk_header = "";
    private String FIELD_AG_bezeichnung = "";
    private String FIELD_AG_betriebsnummer = "";
    private String FIELD_header_monat_bezeichnung = "";
    private static final String PARAMETER_USER = "Parameter_User";
    private static final String staticText_internalUse = "internalUse";
    private static final String staticText_sichtDatum = "sichtDatum";
    private String mStaticText_internalUse = "";
    private String mSichtDatum = "";
    private final Language mReportLanguage;
    private final String mVersion;
    private String mUser = "";
    private Integer FIELD_seitenzahl = 0;
    private String FIELD_seitenwechsel = "Seitenwechesl_1";
    private String mPCompanyLongDescription = "";
    private Foundations mPCompanyFoundations;
    private final PCompany mPCompanyForFoundations;
    private final PCompany mPCompanyForSettings;
    private CompanyPlantPostalAddress mPCompanyPlantPostalAddress;
    private GeneralEmploymentOffice mPCompanyGeneralEmploymentOffice;
    private final Date mForEffectiveDate;
    private final Date mForValidDate;
    private Date mListFirstDate;
    private Date mListEndDate;
    private final Date mCalculationStartDate;
    private boolean mInternalUse = true;
    private boolean mPayment = false;
    private boolean mFirstPurchase = true;
    private boolean mHasNaxt = false;
    private boolean mLeaveNext = false;
    private String mSelectedRecipientDescription = "";
    private String mCompanyEmployerNumber = "";
    private final boolean mIsConsolidation;
    @Deprecated
    private final Map<String, Foundations> mPlantFoundationsMap = new HashMap<String, Foundations>();
    @Deprecated
    private final Map<String, String> mPlantLongDescriptionMap = new HashMap<String, String>();
    @Deprecated
    private final Map<String, Plant> mPlantMap = new HashMap<String, Plant>();
    @Deprecated
    private final Map<String, String> mPlantKeyMap = new HashMap<String, String>();
    @Deprecated
    private final Map<String, EEZVK> mEEZVKMap = new HashMap<String, EEZVK>();
    @Deprecated
    private final Map<String, Employee> mEmployeeMap = new HashMap<String, Employee>();
    @Deprecated
    private final Map<String, String> mPlantEmployerNumberHM = new HashMap<String, String>();
    @Deprecated
    private final Map<String, CompanyPlantPostalAddress> mPlantPostalAdressMap = new HashMap<String, CompanyPlantPostalAddress>();
    @Deprecated
    private final Map<String, Recipient> mRecipientHM = new HashMap<String, Recipient>();
    @Deprecated
    private final Map<String, RecipientTP> mRecipientTPHM = new HashMap<String, RecipientTP>();
    @Deprecated
    private final Map<String, AssignmentPCompanyZVK> mPCompanyZVKHM = new HashMap<String, AssignmentPCompanyZVK>();
    @Deprecated
    private final Map<String, AssignmentPCompanyZVKTP> mPCompanyZVKTPHM = new HashMap<String, AssignmentPCompanyZVKTP>();
    private final Iterator<StatementOfContributionZVKReportBean> mEmployeeForReportIt;
    private final Collection<StatementOfContributionZVKTypeBean> mEmployeeBeanCollection = new LinkedList<StatementOfContributionZVKTypeBean>();
    private final Collection<StatementOfContributionZVKSummBean> mSummCollection = new LinkedList<StatementOfContributionZVKSummBean>();
    private BigDecimal FIELD_100900 = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_100910 = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_100920 = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_100930 = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_100970 = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_100940 = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_100950 = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_100960 = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_111200 = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_entgelt_zus_umlage = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_monatliches_gesamt_entgelt = BigDecimal.valueOf(0L, 2);
    private BigDecimal FIELD_monatliche_zus_umlage = BigDecimal.valueOf(0L, 2);
    private BigDecimal entgelt_bd = BigDecimal.valueOf(0L, 2);
    private BigDecimal umlage_an_bd = BigDecimal.valueOf(0L, 2);
    private BigDecimal umlage_ag_bd = BigDecimal.valueOf(0L, 2);
    private BigDecimal san_geld_bd = BigDecimal.valueOf(0L, 2);
    private BigDecimal zusatzbeitrag_bd = BigDecimal.valueOf(0L, 2);
    private BigDecimal pausch_beitrag_bd = BigDecimal.valueOf(0L, 2);
    private BigDecimal entgelt_zus_umlage_bd = BigDecimal.valueOf(0L, 2);
    private BigDecimal zus_umlage_bd = BigDecimal.valueOf(0L, 2);
    private BigDecimal umlage_an_vj_bd = BigDecimal.valueOf(0L, 2);
    private BigDecimal umlage_ag_vj_bd = BigDecimal.valueOf(0L, 2);
    private BigDecimal san_geld_vj_bd = BigDecimal.valueOf(0L, 2);
    private BigDecimal zusatzbeitrag_vj_bd = BigDecimal.valueOf(0L, 2);
    private BigDecimal zus_umlage_vj_bd = BigDecimal.valueOf(0L, 2);
    private BigDecimal entgelt_jahr_bd = BigDecimal.valueOf(0L, 2);
    private BigDecimal umlage_an_jahr_bd = BigDecimal.valueOf(0L, 2);
    private BigDecimal umlage_ag_jahr_bd = BigDecimal.valueOf(0L, 2);
    private BigDecimal san_geld_jahr_bd = BigDecimal.valueOf(0L, 2);
    private BigDecimal zusatzbeitrag_jahr_bd = BigDecimal.valueOf(0L, 2);
    private BigDecimal pausch_beitrag_jahr_bd = BigDecimal.valueOf(0L, 2);
    private BigDecimal entgelt_zus_umlage_jahr_bd = BigDecimal.valueOf(0L, 2);
    private BigDecimal zus_umlage_jahr_bd = BigDecimal.valueOf(0L, 2);
    private BigDecimal grenzbetrag_zus_umlage = BigDecimal.valueOf(0L, 2);
    private StatementOfContributionZVKReportBean mSOCTypeBeanForReport;
    private StatementOfContributionZVKReportBean mSOCTypeBeanForReportNext;
    private final String mNameForPayment;
    private final Map<String, List<PaymentCompRecipientBean>> mPaymentHashMap = new HashMap<String, List<PaymentCompRecipientBean>>();
    private final List<String> noAuszahlungsbetragOrCompHFErrorList = new LinkedList<String>();
    private boolean mAbrechnungJanuar = false;
    private final EmployeeForReportGenerator generator;
    private final StatementOfContributionListTypeEnum mTypeOfList;
    private final ReportValues mReportValues;
    protected final ProgressBarUpdater mProgressBar;

    public void setDaoCompanyaccounttp(ICompanyaccounttpDao daoCompanyaccounttp) {
        this.daoCompanyaccounttp = daoCompanyaccounttp;
    }

    public StatementOfContributionZVKReportDataSource(AllCallback callback, ISpecialAccessPersistencyContext specialAccessPersistencyContext, ReportFirstFilterStruct firstFilter, ReportSecondFilterStruct[] secondFilters, ReportThirdFilterStruct thirdFilter, ReportSortStruct[] sorts, Date forEffectiveDate, Date forValidDate, String name, boolean payment, boolean internalUse, StatementOfContributionListTypeEnum typeOfList, ProgressBarUpdater progressBar) throws BusinessDomainException, PutDataException {
        this.mProgressBar = progressBar;
        this.mReportValues = new ReportValues();
        this.mUser = SessionContext.getInstance().getSession().getUserCode();
        this.mReportLanguage = LanguageManager.getInstance().getDefaultLanguage();
        new BigDecimalFormatter(this.mReportLanguage.getLocale());
        this.mVersion = Version.getVersion();
        this.mInternalUse = internalUse;
        this.mForEffectiveDate = DateHelper.getLastDayOfMonth((Date)forEffectiveDate);
        this.mForValidDate = DateHelper.getLastDayOfMonth((Date)forValidDate);
        this.mTypeOfList = payment ? StatementOfContributionListTypeEnum.SOCLT_NurMonatswerte : typeOfList;
        this.mNameForPayment = name;
        this.mPayment = payment;
        this.initCurrentObjects();
        if (firstFilter != null && !StringMapper.isNullString((String)firstFilter.oidRecipient)) {
            this.mSelectedRecipientDescription = this.getZVKDescriptionForSort(firstFilter.oidRecipient, this.mForEffectiveDate, this.mForValidDate);
        }
        LinkedList errorList = new LinkedList();
        this.generator = new EmployeeForReportGenerator(specialAccessPersistencyContext, firstFilter, secondFilters, thirdFilter, sorts, forEffectiveDate, this.mListFirstDate, this.mListEndDate, errorList);
        EmployeeForReport[] efrs = this.generator.getEmployeesForReport();
        this.mIsConsolidation = this.generator.isSuperiorForConsolidation();
        if (!errorList.isEmpty()) {
            String[] temp = errorList.toArray(new String[errorList.size()]);
            BusinessDomainException de = ReportExceptionMapper.makeStickyEmployeesInEmployeeForReport((String[])temp);
            errorList.clear();
            callback.setDomainException(CorbaExceptionMapper.toDomainExceptionStruct((BusinessDomainException)de));
        }
        if (this.mProgressBar != null) {
            this.mProgressBar.setTotal(efrs.length);
        }
        List oidPlantLi = ReportEmployeesHandlingHelper.getOidUniqueOidPlantList((EmployeeForReport[])efrs);
        for (String oidPlant : oidPlantLi) {
            this.setEmployeePlantIsEast(oidPlant);
        }
        this.mPCompanyForFoundations = this.generator.getPCompanyForFoundations();
        this.mPCompanyForSettings = this.generator.getPCompanyForSettings();
        this.mPCompanyFoundations = this.getCompanyFoundations();
        this.mPCompanyLongDescription = this.getCompanyLongDescription();
        Date ersterTageDesJahres = DateHelper.getFirstDayOfYear((Date)this.mForValidDate);
        if (DateHelper.afterOrEqual((Date)this.mForValidDate, (Date)ersterTageDesJahres) && DateHelper.beforeOrEqual((Date)this.mForValidDate, (Date)DateHelper.getLastDayOfMonth((Date)ersterTageDesJahres))) {
            this.mAbrechnungJanuar = true;
        }
        if (this.mPayment) {
            ReportHelper.getPaymentSessionName((String)this.mNameForPayment, (String)this.mPCompanyForSettings.getObjectid());
        }
        this.mCalculationStartDate = this.mReportHelper.getCalculationStartDate(this.mPCompanyForFoundations.getCompanyFoundations(this.mForEffectiveDate, this.mListEndDate));
        this.mListFirstDate = DateHelper.max((Date)this.mListFirstDate, (Date)this.mCalculationStartDate);
        StatementOfContributionZVKReportBeans socZVKBeans = new StatementOfContributionZVKReportBeans(this.mSelectedRecipientDescription);
        for (EmployeeForReport currentEmployee : efrs) {
            Date retroactiveCorrectionValidFromNew;
            this.mProgressBar.update();
            String currentOidEmployee = currentEmployee.getOidEmployee();
            Employee employee = this.getIEmployeePM().getEmployee(currentOidEmployee);
            Date journalizedUntil = DateHelper.getFirstDayOfMonth((Date)employee.getJournalizedUntil());
            Date retroactiveCorrectionDate = ReportEmployeesHandlingHelper.getRetroactiveCorrectionDate((String[])new String[]{currentEmployee.getOidEmployee()}, (Date)this.mForEffectiveDate, (Date)this.mListFirstDate, (Date)this.mCalculationStartDate);
            EEZVK eeZVK = this.getEEZVK(currentOidEmployee, this.mForEffectiveDate, this.mForValidDate);
            if (!this.isEmployeeRelevant(currentEmployee, eeZVK, retroactiveCorrectionDate)) continue;
            if (!this.mInternalUse && PDateHelper.getDiffInMonths((Date)this.mForValidDate, (Date)journalizedUntil) > 0) {
                throw ReportExceptionMapper.makeEmployeeNotJournalized();
            }
            Date currentValidFromDate = this.mForValidDate;
            Date currentValidUntilDate = DateHelper.getLastDayOfMonth((Date)this.mForValidDate);
            if (eeZVK != null) {
                Date currentEmployeeLastDate = eeZVK.getDateOfWithdrawl();
                currentEmployeeLastDate = currentEmployeeLastDate == null ? VDate.getDateMax() : currentEmployeeLastDate;
                currentValidUntilDate = DateHelper.min((Date)currentValidUntilDate, (Date)currentEmployeeLastDate);
                Recipient zVKRecipient = eeZVK.getZVK();
                if (zVKRecipient != null) {
                    this.putRecipientHM(zVKRecipient);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("eeZVK.getMembershipNumber()=  {0}", (Object)eeZVK.getMembershipNumber());
                    }
                    if (this.mTypeOfList != StatementOfContributionListTypeEnum.SOCLT_NurJahreswerte) {
                        StatementOfContributionZVKReportBean sOCTypeZVKBean = new StatementOfContributionZVKReportBean(this.checkPNRForConsolidation(currentEmployee.getPersonnelNumber(), currentEmployee.getOidPCompany()), currentEmployee.getPersonnelNumber(), currentEmployee.getSurname(), currentEmployee.getFirstname(), eeZVK.getMembershipNumber(), currentOidEmployee, currentEmployee.getOidPCompany(), currentEmployee.getOidPlant(), zVKRecipient.getObjectid(), DateMapper.toDDMMYYYYPointSeparationString((Date)eeZVK.getDateOfEntry()), DateMapper.toDDMMYYYYPointSeparationString((Date)eeZVK.getDateOfWithdrawl()), this.mForEffectiveDate, currentValidFromDate, currentValidUntilDate);
                        sOCTypeZVKBean.setJustForYearAddition(false);
                        sOCTypeZVKBean.setStatus_int(0);
                        sOCTypeZVKBean.setF_status("");
                        this.getEmployeeProperties(sOCTypeZVKBean, this.mForEffectiveDate, currentValidFromDate);
                        socZVKBeans.add(sOCTypeZVKBean);
                    }
                    if (this.mTypeOfList != StatementOfContributionListTypeEnum.SOCLT_NurMonatswerte) {
                        Date validFromYearDate = DateHelper.getFirstDayOfYear((Date)this.mForValidDate);
                        Date validUntilYearDate = DateHelper.getLastDayOfMonth((Date)this.mForValidDate);
                        if (currentEmployee.getDateOfWithDrawal() != null) {
                            validUntilYearDate = DateHelper.min((Date)validUntilYearDate, (Date)currentEmployee.getDateOfWithDrawal());
                        }
                        if (eeZVK.getDateOfWithdrawl() != null) {
                            validUntilYearDate = DateHelper.min((Date)validUntilYearDate, (Date)eeZVK.getDateOfWithdrawl());
                        }
                        StatementOfContributionZVKReportBean sOCTypeZVKBean = new StatementOfContributionZVKReportBean(this.checkPNRForConsolidation(currentEmployee.getPersonnelNumber(), currentEmployee.getOidPCompany()), currentEmployee.getPersonnelNumber(), currentEmployee.getSurname(), currentEmployee.getFirstname(), this.mTypeOfList == StatementOfContributionListTypeEnum.SOCLT_NurJahreswerte ? eeZVK.getMembershipNumber() : "", currentOidEmployee, currentEmployee.getOidPCompany(), currentEmployee.getOidPlant(), zVKRecipient.getObjectid(), this.mTypeOfList == StatementOfContributionListTypeEnum.SOCLT_NurJahreswerte ? DateMapper.toDDMMYYYYPointSeparationString((Date)eeZVK.getDateOfEntry()) : "", this.mTypeOfList == StatementOfContributionListTypeEnum.SOCLT_NurJahreswerte ? DateMapper.toDDMMYYYYPointSeparationString((Date)eeZVK.getDateOfWithdrawl()) : "", this.mForEffectiveDate, validFromYearDate, validUntilYearDate);
                        sOCTypeZVKBean.setJustForYearAddition(false);
                        sOCTypeZVKBean.setStatus_int(0);
                        sOCTypeZVKBean.setF_status("");
                        sOCTypeZVKBean.setAreYearDatas(true);
                        this.getEmployeeProperties(sOCTypeZVKBean, this.mForEffectiveDate, validUntilYearDate);
                        socZVKBeans.add(sOCTypeZVKBean);
                    }
                }
            }
            if (this.mTypeOfList == StatementOfContributionListTypeEnum.SOCLT_NurJahreswerte || !DateHelper.equal((Date)this.mForEffectiveDate, (Date)this.mForValidDate) || retroactiveCorrectionDate == null) continue;
            StatementOfContributionZVKReportBean employeeForSOCBeanNew = null;
            StatementOfContributionZVKReportBean employeeForSOCBeanOld = null;
            Date oldEffectiveDate = DateHelper.yesterday((Date)DateHelper.getFirstDayOfMonth((Date)this.mForEffectiveDate));
            Date lastRRMonth = DateHelper.yesterday((Date)DateHelper.getFirstDayOfMonth((Date)this.mForValidDate));
            Date retroactiveCorrectionValidFrom = retroactiveCorrectionValidFromNew = retroactiveCorrectionDate;
            while (DateHelper.beforeOrEqual((Date)retroactiveCorrectionValidFrom, (Date)lastRRMonth)) {
                Recipient zVKRecipientOld;
                EEZVK eeZVKOld;
                Recipient zVKRecipientNew;
                Date validUntilDate = DateHelper.getLastDayOfMonth((Date)retroactiveCorrectionValidFrom);
                validUntilDate = DateHelper.min((Date)validUntilDate, (Date)lastRRMonth);
                EEZVK eeZVKNew = this.getEEZVK(currentEmployee.getOidEmployee(), this.mForEffectiveDate, retroactiveCorrectionValidFrom);
                if (eeZVKNew == null) {
                    eeZVKNew = this.getEEZVK(currentEmployee.getOidEmployee(), this.mForEffectiveDate, DateHelper.getLastDayOfMonth((Date)retroactiveCorrectionValidFrom));
                }
                if (eeZVKNew != null && (zVKRecipientNew = eeZVKNew.getZVK()) != null) {
                    employeeForSOCBeanNew = new StatementOfContributionZVKReportBean(this.checkPNRForConsolidation(currentEmployee.getPersonnelNumber(), currentEmployee.getOidPCompany()), currentEmployee.getPersonnelNumber(), currentEmployee.getSurname(), currentEmployee.getFirstname(), eeZVKNew.getMembershipNumber(), currentOidEmployee, currentEmployee.getOidPCompany(), currentEmployee.getOidPlant(), zVKRecipientNew.getObjectid(), DateMapper.toDDMMYYYYPointSeparationString((Date)eeZVKNew.getDateOfEntry()), DateMapper.toDDMMYYYYPointSeparationString((Date)eeZVKNew.getDateOfWithdrawl()), this.mForEffectiveDate, retroactiveCorrectionValidFrom, validUntilDate);
                    this.getEmployeeProperties(employeeForSOCBeanNew, this.mForEffectiveDate, retroactiveCorrectionValidFrom);
                    employeeForSOCBeanNew.setJustForYearAddition(false);
                }
                if ((eeZVKOld = this.getEEZVK(currentEmployee.getOidEmployee(), oldEffectiveDate, retroactiveCorrectionValidFrom)) == null) {
                    eeZVKOld = this.getEEZVK(currentEmployee.getOidEmployee(), this.mForEffectiveDate, DateHelper.getLastDayOfMonth((Date)retroactiveCorrectionValidFrom));
                }
                if (eeZVKOld != null && (zVKRecipientOld = eeZVKOld.getZVK()) != null) {
                    employeeForSOCBeanOld = new StatementOfContributionZVKReportBean(this.checkPNRForConsolidation(currentEmployee.getPersonnelNumber(), currentEmployee.getOidPCompany()), currentEmployee.getPersonnelNumber(), currentEmployee.getSurname(), currentEmployee.getFirstname(), eeZVKOld.getMembershipNumber(), currentOidEmployee, currentEmployee.getOidPCompany(), currentEmployee.getOidPlant(), zVKRecipientOld.getObjectid(), DateMapper.toDDMMYYYYPointSeparationString((Date)eeZVKOld.getDateOfEntry()), DateMapper.toDDMMYYYYPointSeparationString((Date)eeZVKOld.getDateOfWithdrawl()), oldEffectiveDate, retroactiveCorrectionValidFrom, validUntilDate);
                    this.getEmployeeProperties(employeeForSOCBeanOld, oldEffectiveDate, retroactiveCorrectionValidFrom);
                    employeeForSOCBeanOld.setJustForYearAddition(false);
                }
                if (employeeForSOCBeanNew != null || employeeForSOCBeanOld != null) {
                    if (employeeForSOCBeanNew != null && employeeForSOCBeanOld == null) {
                        this.setNewTypeBean(employeeForSOCBeanNew);
                        socZVKBeans.add(employeeForSOCBeanNew);
                    }
                    if (employeeForSOCBeanNew == null && employeeForSOCBeanOld != null) {
                        this.setOldTypeBean(employeeForSOCBeanOld);
                        socZVKBeans.add(employeeForSOCBeanOld);
                    }
                    if (employeeForSOCBeanNew != null && employeeForSOCBeanOld != null && !this.areEqualWerteBeans(employeeForSOCBeanNew.getFieldValues(), employeeForSOCBeanOld.getFieldValues())) {
                        this.setNewTypeBean(employeeForSOCBeanNew);
                        socZVKBeans.add(employeeForSOCBeanNew);
                        this.setOldTypeBean(employeeForSOCBeanOld);
                        socZVKBeans.add(employeeForSOCBeanOld);
                    }
                }
                retroactiveCorrectionValidFrom = DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)retroactiveCorrectionValidFrom));
            }
        }
        if (socZVKBeans.isEmpty()) {
            throw ReportExceptionMapper.makeNoEmployeeForThisAssortment();
        }
        this.mEmployeeForReportIt = socZVKBeans.iterator();
    }

    private boolean isEmployeeRelevant(EmployeeForReport currentEmployee, EEZVK eeZVK, Date retroactiveCorrectionDate) {
        boolean isRelevant = false;
        if (eeZVK != null) {
            if (currentEmployee.getDateOfWithDrawal() == null || DateHelper.beforeOrEqual((Date)DateHelper.getFirstDayOfMonth((Date)this.mForValidDate), (Date)currentEmployee.getDateOfWithDrawal()) || DateHelper.before((Date)retroactiveCorrectionDate, (Date)this.mForValidDate)) {
                isRelevant = true;
            }
            if (!isRelevant && this.mTypeOfList != StatementOfContributionListTypeEnum.SOCLT_NurMonatswerte) {
                if (eeZVK.getDateOfWithdrawl() != null) {
                    if (DateHelper.afterOrEqual((Date)eeZVK.getDateOfWithdrawl(), (Date)DateHelper.getFirstDayOfYear((Date)this.mForValidDate))) {
                        isRelevant = true;
                    }
                } else if (currentEmployee.getDateOfWithDrawal() != null && DateHelper.afterOrEqual((Date)currentEmployee.getDateOfWithDrawal(), (Date)DateHelper.getFirstDayOfYear((Date)this.mForValidDate))) {
                    isRelevant = true;
                }
            }
        }
        return isRelevant;
    }

    private void addZVKAvisReportBean(String key, BigDecimal amountAktJahr, BigDecimal amountVorjahr, StatementOfContributionZVKReportBean ZVKReportBean) throws BusinessDomainException {
        StatementOfContributionZVKAvisReportBean ZVKAvisReportBean = this.ZVKAvisBeanHM.get(key);
        CompanyPlantPostalAddress companyPostalAdress = this.getCompanyPostalAdress();
        if (ZVKAvisReportBean != null) {
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)amountAktJahr)) {
                ZVKAvisReportBean.setAmountYear(ZVKAvisReportBean.getAmountYear().add(amountAktJahr));
            }
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)amountVorjahr)) {
                ZVKAvisReportBean.setAmountPriorYear(ZVKAvisReportBean.getAmountPriorYear().add(amountVorjahr));
            }
            ZVKAvisReportBean.addAmountTotal(amountAktJahr.add(amountVorjahr));
        } else {
            ZVKAvisReportBean = new StatementOfContributionZVKAvisReportBean();
            ZVKAvisReportBean.setArbeitgeber_bezeichnung(this.getCompanyLongDescription());
            ZVKAvisReportBean.setArbeitgeber_plz_ort(companyPostalAdress.getPostalCode() + " " + companyPostalAdress.getCity());
            ZVKAvisReportBean.setArbeitgeber_str_nr(companyPostalAdress.getStreet());
            ZVKAvisReportBean.setMonth(String.valueOf(ZVKReportBean.getMonat_int() + 1) + "/" + ZVKReportBean.getYear());
            ZVKAvisReportBean.setRecipient_bezeichnung(ZVKReportBean.getRefereToZVKRecipientDescription());
            ZVKAvisReportBean.setRecipient_plz_ort(ZVKReportBean.getRecipient_plz_ort());
            ZVKAvisReportBean.setRecipient_str_nr(ZVKReportBean.getRecipient_str_nr());
            ZVKAvisReportBean.setBookingCode("BookingCode");
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)amountAktJahr)) {
                ZVKAvisReportBean.setAmountYear(ZVKAvisReportBean.getAmountYear().add(amountAktJahr));
            }
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)amountVorjahr)) {
                ZVKAvisReportBean.setAmountPriorYear(ZVKAvisReportBean.getAmountPriorYear().add(amountVorjahr));
            }
            ZVKAvisReportBean.addAmountTotal(amountAktJahr.add(amountVorjahr));
        }
        this.ZVKAvisBeanHM.put(key, ZVKAvisReportBean);
    }

    private boolean areEqualWerteBeans(String[] fieldsNew, String[] fieldsOld) {
        for (int i = 0; i < fieldsNew.length; ++i) {
            if (StringMapper.equal((String)fieldsNew[i], (String)fieldsOld[i])) continue;
            return false;
        }
        return true;
    }

    private String getDateOfBirth(String oidEmployee, Date forEffectiveDate, Date forValidDate) throws BusinessDomainException {
        Master master = this.getEmployee(oidEmployee).getMaster(forEffectiveDate, forValidDate);
        if (master != null) {
            return DateMapper.toDDMMYYYYPointSeparationString((Date)master.getDateOfBirth());
        }
        return "";
    }

    private String checkPNRForConsolidation(String personnelNumber, String oidPCompany) throws BusinessDomainException {
        Object tempPersonnelNumber = this.getPurePersonnelNumber(personnelNumber);
        if (this.mIsConsolidation) {
            String pCompanyKey = this.mReportValues.getPCompany(oidPCompany).getPCompanyKey();
            tempPersonnelNumber = pCompanyKey + "/" + (String)tempPersonnelNumber;
        }
        return tempPersonnelNumber;
    }

    private String getPurePersonnelNumber(String personnelNumber) {
        return StringMapper.removeLeftSideZero((String)personnelNumber);
    }

    private void initCurrentObjects() {
        this.mStaticText_internalUse = this.mInternalUse ? "Interner Gebrauch" : "";
        this.mSichtDatum = DateMapper.toDDMMYYYYPointSeparationString((Date)this.mForEffectiveDate);
        this.mListFirstDate = DateHelper.getFirstDayOfMonth((Date)this.mForValidDate);
        this.mListEndDate = DateHelper.getLastDayOfMonth((Date)this.mForValidDate);
        this.getHashMapFstateregionall();
    }

    public Map<String, Object> getParameters() {
        JasperParameterHashMap parameters = new JasperParameterHashMap();
        parameters.put(PARAMETER_USER, this.mUser);
        parameters.put(staticText_internalUse, this.mStaticText_internalUse);
        parameters.put(staticText_sichtDatum, this.mSichtDatum);
        return parameters;
    }

    public Object getFieldValue(JRField field) throws JRException {
        Integer value = null;
        String fieldName = field.getName();
        if (fieldName.equals("version")) {
            return this.mVersion;
        }
        if (fieldName.equals("monat_bezeichnung")) {
            return this.FIELD_header_monat_bezeichnung;
        }
        if (fieldName.equals("jahr")) {
            return Integer.toString(new VDate(this.mForValidDate).getYear());
        }
        if (fieldName.equals("firma_bezeichnung")) {
            return this.FIELD_firma_bezeichnung;
        }
        if (fieldName.equals("firma_nr")) {
            return this.FIELD_firma_nr;
        }
        if (fieldName.equals("betriebsstaette_bezeichnung")) {
            return this.FIELD_betriebsstaette_bezeichnung;
        }
        if (fieldName.equals("betriebsstaette_nr")) {
            return this.FIELD_betriebsstaette_nr;
        }
        if (fieldName.equals("recipient_bezeichnung")) {
            return this.FIELD_recipient_key + " " + this.FIELD_recipient_bezeichnung;
        }
        if (fieldName.equals("recipient_str_nr")) {
            return this.FIELD_recipient_str_nr;
        }
        if (fieldName.equals("recipient_plz_ort")) {
            return this.FIELD_recipient_plz_ort;
        }
        if (fieldName.equals("zvk_betriebsnummer")) {
            return this.FIELD_zvk_betriebsnummer;
        }
        if (fieldName.equals("zvk_art")) {
            return this.FIELD_zvk_art;
        }
        if (fieldName.equals("umlage_aga")) {
            return this.FIELD_umlage_aga.replace('.', ',');
        }
        if (fieldName.equals("umlage_ana")) {
            return this.FIELD_umlage_ana.replace('.', ',');
        }
        if (fieldName.equals("zusaetzl_umlage_aga")) {
            return this.FIELD_zusaetzl_umlage_aga.replace('.', ',');
        }
        if (fieldName.equals("zusatzbeitr_aga")) {
            return this.FIELD_zusatzbeitr_aga.replace('.', ',');
        }
        if (fieldName.equals("zusatzbeitr_ana")) {
            return this.FIELD_zusatzbeitr_ana.replace('.', ',');
        }
        if (fieldName.equals("sanierungsgeld")) {
            return this.FIELD_sanierungsgeld.replace('.', ',');
        }
        if (fieldName.equals("sv_pflicht_anteil")) {
            return this.FIELD_sv_pflicht_anteil.replace('.', ',');
        }
        if (fieldName.equals("hoechstbetrag")) {
            return ReportHelper.toCurrencyFormatIfNullString((Object)this.FIELD_hoechstbetrag);
        }
        if (fieldName.equals("grenzbetrag")) {
            return ReportHelper.toCurrencyFormatIfNullString((Object)this.FIELD_grenzbetrag);
        }
        if (fieldName.equals("verdoppelungsmonat")) {
            return this.FIELD_verdoppelungsmonat;
        }
        if (fieldName.equals("AG_str_nr")) {
            return this.FIELD_AG_str_nr;
        }
        if (fieldName.equals("AG_plz_ort")) {
            return this.FIELD_AG_plz_ort;
        }
        if (fieldName.equals("AG_bezeichnung")) {
            return StatementOfContributionZVKReportDataSource.cutCR(this.FIELD_AG_bezeichnung);
        }
        if (fieldName.equals("AG_beitragskontonummer")) {
            return this.FIELD_AG_beitragskontonummer;
        }
        if (fieldName.equals("AG_betriebsnummer")) {
            return this.FIELD_AG_betriebsnummer;
        }
        if (fieldName.equals("AG_VWE_NR")) {
            return this.FIELD_AG_VWE_NR;
        }
        if (fieldName.equals("rk_header")) {
            return "";
        }
        if (fieldName.equals("seitenwechsel")) {
            this.FIELD_seitenwechsel = this.FIELD_seitenwechsel.equals("Seitenwechesl_1") ? "Seitenwechesl_2" : "Seitenwechesl_1";
            return this.FIELD_seitenwechsel;
        }
        if (fieldName.equals("seitenzahl")) {
            value = this.FIELD_seitenzahl;
            this.FIELD_seitenzahl = 0;
            return value;
        }
        if (fieldName.equals("subreport_employee_bean_collection")) {
            return this.mEmployeeBeanCollection;
        }
        if (fieldName.equals("subreport_summ_bean_collection")) {
            return this.mSummCollection;
        }
        if (fieldName.equals("archi_string")) {
            ArchivingMetadata am = new ArchivingMetadata();
            am.setReportName(this.getReportName());
            am.setUserID(SessionContext.getInstance().getSession().getUserCode());
            am.setCompanyKey(this.FIELD_firma_nr);
            am.setName(this.FIELD_recipient_bezeichnung);
            am.setPlantKey(this.FIELD_betriebsstaette_nr);
            am.setStdCompanyNr(this.FIELD_AG_betriebsnummer);
            am.setValidFrom(this.mListFirstDate);
            am.setValidUntil(this.mListEndDate);
            return am.getArchiString();
        }
        return value;
    }

    private static String cutCR(String string) {
        return string == null ? null : string.split("\\r?\\n", 2)[0];
    }

    private String getReportName() {
        return "Beitragsliste ZVK";
    }

    public boolean next() throws JRException {
        try {
            this.getHasNext();
            this.resetComponents();
            while (this.mHasNaxt) {
                if (!this.mFirstPurchase) {
                    this.mSOCTypeBeanForReport = this.mSOCTypeBeanForReportNext;
                    this.mSOCTypeBeanForReportNext = null;
                } else {
                    this.mSOCTypeBeanForReport = this.mEmployeeForReportIt.next();
                    this.mFirstPurchase = false;
                }
                if (this.mEmployeeForReportIt.hasNext()) {
                    this.mSOCTypeBeanForReportNext = this.mEmployeeForReportIt.next();
                }
                this.setFieldsFromBeanFields();
                this.leaveNext();
                if (!this.mLeaveNext) continue;
                this.buildSummCollection();
                return true;
            }
            this.makePayment();
            return false;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JRException((Throwable)e);
        }
    }

    private void leaveNext() {
        this.mLeaveNext = this.mSOCTypeBeanForReportNext == null || !this.mEmployeeForReportIt.hasNext() && this.isChnageInTypeBeans() || this.mEmployeeForReportIt.hasNext() && this.isChnageInTypeBeans();
    }

    private void putRecipientHM(Recipient recipient) {
        Recipient pRecipient = this.mRecipientHM.get(recipient.getObjectid());
        if (pRecipient == null) {
            this.mRecipientHM.put(recipient.getObjectid(), recipient);
        }
    }

    private void getHasNext() {
        this.mHasNaxt = false;
        if (this.mEmployeeForReportIt.hasNext() || this.mSOCTypeBeanForReportNext != null) {
            this.mHasNaxt = true;
        }
    }

    private void resetComponents() {
        this.mEmployeeBeanCollection.clear();
        this.mSummCollection.clear();
        this.resetSummFields();
        this.resetBigDecimalFields();
    }

    private boolean isChnageInTypeBeans() {
        return !StringMapper.equal((String)this.mSOCTypeBeanForReport.getArbeitgeber_VWE_Nr(), (String)this.mSOCTypeBeanForReportNext.getArbeitgeber_VWE_Nr()) || !StringMapper.equal((String)this.mSOCTypeBeanForReport.getRecipient_key(), (String)this.mSOCTypeBeanForReportNext.getRecipient_key()) || !StringMapper.equal((String)this.mSOCTypeBeanForReport.getRechtskreis(), (String)this.mSOCTypeBeanForReportNext.getRechtskreis());
    }

    private GeneralEmploymentOffice getGeneralCompanyEmploymentOfficeTP() throws BusinessDomainException {
        if (this.mPCompanyGeneralEmploymentOffice == null) {
            CompanyEmploymentOffice compEmplOffice = null;
            try {
                compEmplOffice = this.mPCompanyForSettings.getCompanyEmploymentOffice(this.mForEffectiveDate, this.mForValidDate);
            }
            catch (BusinessDomainException e) {
                throw ReportExceptionMapper.makeCompanyEmployeeOfficeMissingDomainException();
            }
            this.mPCompanyGeneralEmploymentOffice = compEmplOffice.getGeneralEmploymentOffice();
            if (this.mPCompanyGeneralEmploymentOffice == null) {
                throw ReportExceptionMapper.makeCompanyEmployeeOfficeMissingDomainException();
            }
        }
        return this.mPCompanyGeneralEmploymentOffice;
    }

    private String getCompanyEmployerNumber() throws BusinessDomainException {
        GeneralEmploymentOffice genCompEmplOf;
        if (StringMapper.isNullString((String)this.mCompanyEmployerNumber) && (genCompEmplOf = this.getGeneralCompanyEmploymentOfficeTP()) != null) {
            this.mCompanyEmployerNumber = genCompEmplOf.getEmployerNumber();
            if (StringMapper.isNullString((String)this.mCompanyEmployerNumber)) {
                throw ReportExceptionMapper.makeCompanyEmployeeOfficeMissingDomainException();
            }
        }
        return this.mCompanyEmployerNumber;
    }

    private String getPlantEmployerNumber(String oidPlant) throws BusinessDomainException {
        GeneralEmploymentOffice genPlantEmplOf;
        String key = oidPlant;
        String employerNumber = this.mPlantEmployerNumberHM.get(key);
        if (employerNumber == null && (genPlantEmplOf = this.getGeneralPlantEmploymentOfficeTP(oidPlant)) != null && StringMapper.isNullString((String)(employerNumber = genPlantEmplOf.getEmployerNumber()))) {
            throw ReportExceptionMapper.makePlantEmployeeOfficeMissingDomainException();
        }
        return employerNumber;
    }

    private GeneralEmploymentOffice getGeneralPlantEmploymentOfficeTP(String oidPlant) throws BusinessDomainException {
        GeneralEmploymentOffice genEmplOffice = null;
        Plant ePlant = this.getPlant(oidPlant);
        if (ePlant != null) {
            PlantEmploymentOffice plantEmplOffice = null;
            try {
                plantEmplOffice = ePlant.getPlantEmploymentOffice(this.mForEffectiveDate, this.mForValidDate);
            }
            catch (BusinessDomainException e) {
                throw ReportExceptionMapper.makePlantEmployeeOfficeMissingDomainException();
            }
            genEmplOffice = plantEmplOffice.getGeneralEmploymentOffice();
            if (genEmplOffice == null) {
                throw ReportExceptionMapper.makePlantEmployeeOfficeMissingDomainException();
            }
        }
        return genEmplOffice;
    }

    private RecipientTP getRecipientTP(String recipientOid, Date effectiveDate, Date validDate) throws BusinessDomainException {
        String key = recipientOid + VDate.toString((Date)effectiveDate) + VDate.toString((Date)validDate);
        RecipientTP recipientTP = this.mRecipientTPHM.get(key);
        if (recipientTP == null) {
            Recipient recipient = this.getRecipient(recipientOid);
            recipientTP = recipient.getRecipientTP(effectiveDate, validDate);
            this.mRecipientTPHM.put(key, recipientTP);
        }
        return recipientTP;
    }

    private Recipient getRecipient(String recipientOid) {
        Recipient recipient = this.mRecipientHM.get(recipientOid);
        if (recipient == null) {
            recipient = Recipient.getRecipient((String)recipientOid);
            this.mRecipientHM.put(recipientOid, recipient);
        }
        return recipient;
    }

    private CompanyPlantPostalAddress getPlantPostalAdress(String oidPlant) throws BusinessDomainException {
        String key = oidPlant;
        CompanyPlantPostalAddress companyPlantPostalAdress = this.mPlantPostalAdressMap.get(key);
        if (companyPlantPostalAdress == null) {
            Foundations plantFoundations = this.getPlantFoundations(oidPlant);
            companyPlantPostalAdress = plantFoundations.getPostalAddress();
            if (companyPlantPostalAdress == null) {
                throw ReportExceptionMapper.makeNoPlantAdressDomainException((String)plantFoundations.getLongDescription());
            }
            this.mPlantPostalAdressMap.put(key, companyPlantPostalAdress);
        }
        return companyPlantPostalAdress;
    }

    private CompanyPlantPostalAddress getCompanyPostalAdress() throws BusinessDomainException {
        if (this.mPCompanyPlantPostalAddress == null) {
            this.mPCompanyPlantPostalAddress = this.getCompanyFoundations().getPostalAddress();
            if (this.mPCompanyPlantPostalAddress == null) {
                throw ReportExceptionMapper.makeNoCompanyAdressDomainException((String)this.getCompanyLongDescription());
            }
        }
        return this.mPCompanyPlantPostalAddress;
    }

    private String getCompanyLongDescription() throws BusinessDomainException {
        if (StringMapper.isNullString((String)this.mPCompanyLongDescription)) {
            this.mPCompanyLongDescription = this.getCompanyFoundations().getLongDescription();
        }
        return this.mPCompanyLongDescription;
    }

    private String getPlantLongDescription(String oidPlant) throws BusinessDomainException {
        String key = oidPlant;
        String plantLongDescription = this.mPlantLongDescriptionMap.get(key);
        if (plantLongDescription == null) {
            plantLongDescription = this.getPlantFoundations(oidPlant).getLongDescription();
            if (StringMapper.isNullString((String)plantLongDescription)) {
                throw ReportExceptionMapper.makeNoPlantLongDescriptionDomainException();
            }
            this.mPlantLongDescriptionMap.put(key, plantLongDescription);
        }
        return plantLongDescription;
    }

    private Foundations getCompanyFoundations() throws BusinessDomainException {
        if (this.mPCompanyFoundations == null) {
            CompanyFoundations companyFoundations = null;
            try {
                companyFoundations = this.mPCompanyForFoundations.getCompanyFoundations(this.mForEffectiveDate, this.mForValidDate);
            }
            catch (BusinessDomainException e) {
                ExceptionMapper.printException((Throwable)e);
                throw ReportExceptionMapper.makeCompanyFoundationsMissingDomainException((String)this.getCompanyLongDescription());
            }
            this.mPCompanyFoundations = companyFoundations.getFoundations();
            if (this.mPCompanyFoundations == null) {
                throw ReportExceptionMapper.makeCompanyFoundationsMissingDomainException((String)this.getCompanyLongDescription());
            }
        }
        return this.mPCompanyFoundations;
    }

    private void setEmployeePlantIsEast(String oidPlant) throws BusinessDomainException {
        Foundations plantFoundation = this.getPlantFoundations(oidPlant);
        plantFoundation.getFederalState().getFederalStateTP(this.mForEffectiveDate, this.mForValidDate).getLawArea();
    }

    private Foundations getPlantFoundations(String oidPlant) throws BusinessDomainException {
        String key = oidPlant;
        Foundations plantFoundation = this.mPlantFoundationsMap.get(key);
        if (plantFoundation == null) {
            PlantFoundations plantFoundations = null;
            try {
                plantFoundations = this.getPlant(oidPlant).getPlantFoundations(this.mForEffectiveDate, this.mForValidDate);
            }
            catch (BusinessDomainException e) {
                ExceptionMapper.printException((Throwable)e);
                throw ReportExceptionMapper.makePlantFoundationsMissingDomainException((String)"");
            }
            plantFoundation = plantFoundations.getFoundations();
            if (plantFoundation == null) {
                throw ReportExceptionMapper.makePlantFoundationsMissingDomainException((String)"");
            }
            this.mPlantFoundationsMap.put(key, plantFoundation);
        }
        return plantFoundation;
    }

    private Plant getPlant(String oidPlant) throws BusinessDomainException {
        Plant plant = this.mPlantMap.get(oidPlant);
        if (plant == null) {
            plant = (Plant)this.generator.used((IPersistentObject)pm.getPlant(oidPlant));
            if (plant.isNew()) {
                throw ReportExceptionMapper.makeNoPlantDomainException();
            }
            this.mPlantMap.put(oidPlant, plant);
        }
        return plant;
    }

    private String getPlantKey(String oidPlant) throws BusinessDomainException {
        String plantKey = this.mPlantKeyMap.get(oidPlant);
        if (plantKey == null && StringMapper.isNullString((String)(plantKey = this.getPlant(oidPlant).getPlantKey()))) {
            throw ReportExceptionMapper.makeNoPlantKeyDomainException((String)"");
        }
        this.mPlantKeyMap.put(oidPlant, plantKey);
        return plantKey;
    }

    private EEZVK getEEZVK(String oidEmployee, Date forEffectiveDate, Date forValidDate) throws BusinessDomainException {
        Employee eE;
        String key = oidEmployee + DateMapper.toDDMMYYYYString((Date)forEffectiveDate) + DateMapper.toDDMMYYYYString((Date)forValidDate);
        EEZVK eezvk = this.mEEZVKMap.get(key);
        if (eezvk == null && (eE = this.getEmployee(oidEmployee)) != null) {
            block3: {
                try {
                    eezvk = eE.getEEZVK(forEffectiveDate, forValidDate);
                }
                catch (BusinessDomainException e) {
                    if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) break block3;
                    throw e;
                }
            }
            this.mEEZVKMap.put(key, eezvk);
        }
        return eezvk;
    }

    private Employee getEmployee(String oidEmployee) {
        String key = oidEmployee;
        Employee eE = this.mEmployeeMap.get(key);
        if (eE == null) {
            eE = (Employee)this.generator.used((IPersistentObject)this.getIEmployeePM().getEmployee(oidEmployee));
            this.mEmployeeMap.put(key, eE);
        }
        return eE;
    }

    private void getEmployeeProperties(StatementOfContributionZVKReportBean sOCTypeZVKBean, Date effectiveDate, Date validDate) throws BusinessDomainException {
        RecipientTP zVKRecipientTP;
        String oidRecipient = sOCTypeZVKBean.getOidRecipient();
        String oidPlant = sOCTypeZVKBean.getOidPlant();
        Date forEffectiveDate = sOCTypeZVKBean.getForEffectiveDate();
        Date forValidDate = sOCTypeZVKBean.getForValidFromDate();
        Recipient zVKRecipient = this.getRecipient(oidRecipient);
        if (zVKRecipient != null && (zVKRecipientTP = zVKRecipient.getRecipientTP(effectiveDate, validDate)) != null) {
            AssignmentPCompanyZVK aPCZVK;
            ZVK zvk = zVKRecipientTP.getZVK();
            if (zvk != null) {
                switch (zvk.getTypeOfZvk().value()) {
                    case 0: {
                        sOCTypeZVKBean.setZvk_art("ZVK West");
                        break;
                    }
                    case 1: {
                        sOCTypeZVKBean.setZvk_art("ZVK Ost");
                        break;
                    }
                    case 2: {
                        sOCTypeZVKBean.setZvk_art("VBL");
                        break;
                    }
                    case 3: {
                        sOCTypeZVKBean.setZvk_art("KZVK");
                        break;
                    }
                    case 4: {
                        sOCTypeZVKBean.setZvk_art("Abrechnungsverband 2");
                        break;
                    }
                    case 5: {
                        sOCTypeZVKBean.setZvk_art("Bayerische ZVK");
                        break;
                    }
                    case 6: {
                        sOCTypeZVKBean.setZvk_art("ZVK Darmstadt");
                    }
                }
                sOCTypeZVKBean.setRecipient_betriebsnummer(zVKRecipientTP.getStandardCompanyNumber());
                sOCTypeZVKBean.setUmlage_aga(zvk.getAssessmentErPercentage().toString());
                sOCTypeZVKBean.setUmlage_ana(zvk.getAssessmentEePercentage().toString());
                sOCTypeZVKBean.setZusaetzl_umlage_aga(zvk.getAddAssesmentErPercentage().toString());
                sOCTypeZVKBean.setZusatzbeitr_aga(zvk.getAddContErPercentage().toString());
                sOCTypeZVKBean.setZusatzbeitr_ana(zvk.getAddContEePercentage().toString());
                sOCTypeZVKBean.setSanierungsgeld(zvk.getRecapitalisationPercentage().toString());
                sOCTypeZVKBean.setSv_pflicht_anteil(zvk.getPartLiableForSIPercentage().toString());
                sOCTypeZVKBean.setHoechstbetrag(zvk.getMaximumAmount());
                sOCTypeZVKBean.setGrenzbetrag(zvk.getMarginalValueAddAssessmentEr());
                sOCTypeZVKBean.setVerdoppelungsmonat(Integer.toString(zvk.getDuplicationMonth()));
                this.grenzbetrag_zus_umlage = zvk.getMarginalValueAddAssessmentEr();
            }
            String recipientDescriptionForSort = zVKRecipientTP.getLongDescription() + sOCTypeZVKBean.getOidRecipient();
            sOCTypeZVKBean.setSortZVKRecipientDescription(recipientDescriptionForSort);
            sOCTypeZVKBean.setRefereToZVKRecipientDescription(zVKRecipientTP.getLongDescription());
            sOCTypeZVKBean.setReferToOidZVKRecipient(zVKRecipient.getObjectid());
            sOCTypeZVKBean.setRecipient_key(zVKRecipient.getRecipientKey());
            PostalAddress postalAdress = zVKRecipientTP.getAddress();
            sOCTypeZVKBean.setRecipient_plz_ort(postalAdress.getPostalCode() + " " + postalAdress.getCity());
            sOCTypeZVKBean.setRecipient_str_nr(postalAdress.getStreet());
            AssignmentPCompanyZVKTP aPCZVKTP = null;
            if (!StringMapper.isNullString((String)oidPlant) && !this.mIsConsolidation && (aPCZVK = this.getAssignmentPCompanyZVK(this.mPCompanyForSettings.getObjectid(), oidPlant, oidRecipient)) != null && (aPCZVKTP = this.getAssignmentPCompanyZVKTP(this.mPCompanyForSettings.getObjectid(), oidPlant, oidRecipient, forEffectiveDate, forValidDate)) != null) {
                sOCTypeZVKBean.setEmployeeZVKRecipientToPlant(true);
                sOCTypeZVKBean.setArbeitgeber_beitragskonto_nr(aPCZVKTP.getIdentNumber());
            }
            if (aPCZVKTP == null && (aPCZVK = this.getAssignmentPCompanyZVK(this.mPCompanyForSettings.getObjectid(), "", oidRecipient)) != null && (aPCZVKTP = this.getAssignmentPCompanyZVKTP(this.mPCompanyForSettings.getObjectid(), "", oidRecipient, forEffectiveDate, forValidDate)) != null) {
                sOCTypeZVKBean.setEmployeeZVKRecipientToPlant(false);
                sOCTypeZVKBean.setArbeitgeber_beitragskonto_nr(aPCZVKTP.getIdentNumber());
            }
            this.getDataForEmployee(sOCTypeZVKBean);
        }
    }

    private AssignmentPCompanyZVKTP getAssignmentPCompanyZVKTP(String oidPCompany, String oidPlant, String oidRecipient, Date forEffectiveDate, Date forValidDate) {
        String key = oidPCompany + oidPlant + oidRecipient + DateMapper.toDDMMYYYYString((Date)forEffectiveDate) + DateMapper.toDDMMYYYYString((Date)forValidDate);
        AssignmentPCompanyZVKTP aPCZVKTP = this.mPCompanyZVKTPHM.get(key);
        if (aPCZVKTP == null) {
            try {
                aPCZVKTP = this.getAssignmentPCompanyZVK(oidPCompany, oidPlant, oidRecipient).getAssignmentPCompanyZVKTP(forEffectiveDate, forValidDate);
                this.mPCompanyZVKTPHM.put(key, aPCZVKTP);
            }
            catch (BusinessDomainException e) {
                ReportExceptionMapper.ignoredException((Throwable)e);
            }
        }
        return aPCZVKTP;
    }

    private AssignmentPCompanyZVK getAssignmentPCompanyZVK(String oidPCompany, String oidPlant, String oidRecipient) {
        String key = oidPlant + oidRecipient;
        AssignmentPCompanyZVK aPCZVK = this.mPCompanyZVKHM.get(key);
        if (aPCZVK == null) {
            Criterion filters = this.getAssignmentPCompanyZVKFilter(oidPCompany, oidPlant, oidRecipient);
            AssignmentPCompanyZVK[] aPCZVKArray = AssignmentPCompanyZVKPersistencyManager.query(null, (Criterion)filters);
            if (aPCZVKArray != null && aPCZVKArray.length > 0) {
                aPCZVK = aPCZVKArray[0];
            }
            this.mPCompanyZVKHM.put(key, aPCZVK);
        }
        return aPCZVK;
    }

    private Criterion getAssignmentPCompanyZVKFilter(String oidPCompany, String oidPlant, String oidRecipient) {
        return Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidpcompany", (String)oidPCompany), Restrictions.eq((String)"oidplant", (String)oidPlant), Restrictions.eq((String)"oidrecipient", (String)oidRecipient)});
    }

    private String getZVKDescriptionForSort(String recipientObjectId, Date forEffectiveDate, Date forValidDate) throws BusinessDomainException {
        String recipientDescription = Recipient.getRecipient((String)recipientObjectId).getRecipientTP(forEffectiveDate, forValidDate).getLongDescription();
        return recipientDescription + recipientObjectId;
    }

    private void setNewTypeBean(StatementOfContributionZVKReportBean newTypeBean) {
        newTypeBean.setF_status("Neu");
        newTypeBean.setStatus_int(2);
    }

    private void setOldTypeBean(StatementOfContributionZVKReportBean oldTypeBean) {
        oldTypeBean.setF_status("Storno");
        oldTypeBean.setStatus_int(1);
        oldTypeBean.makeNegativeValues();
    }

    private void getDataForEmployee(StatementOfContributionZVKReportBean sOCTypeZVKBean) throws BusinessDomainException {
        String oidEmployee = sOCTypeZVKBean.getOidEmployee();
        String oidPlant = sOCTypeZVKBean.getOidPlant();
        Date forEffectiveDate = sOCTypeZVKBean.getForEffectiveDate();
        Date forValidFromDate = sOCTypeZVKBean.getForValidFromDate();
        Date forValidUntilDate = sOCTypeZVKBean.getForValidUntilDate();
        if (sOCTypeZVKBean.isAreYearDatas()) {
            if (this.mTypeOfList == StatementOfContributionListTypeEnum.SOCLT_NurJahreswerte) {
                sOCTypeZVKBean.setF_geburts_datum(this.getDateOfBirth(oidEmployee, this.mForEffectiveDate, this.mForValidDate));
            } else {
                sOCTypeZVKBean.setF_geburts_datum("");
            }
        } else {
            sOCTypeZVKBean.setF_geburts_datum(this.getDateOfBirth(oidEmployee, this.mForEffectiveDate, this.mForValidDate));
        }
        sOCTypeZVKBean.setHeader_monat_bezeichnung(ReportHelper.getMonthDescription((int)new VDate(this.mForValidDate).getMonth()));
        if (sOCTypeZVKBean.isAreYearDatas()) {
            sOCTypeZVKBean.setF_monat_bezeichnung("Jahresbetrag / " + DateMapper.toYYYYString((Date)forValidFromDate));
        } else {
            sOCTypeZVKBean.setF_monat_bezeichnung(ReportHelper.getMonthDescription((int)new VDate(forValidFromDate).getMonth()) + " / " + DateMapper.toYYYYString((Date)forValidFromDate));
        }
        sOCTypeZVKBean.setMonat_int(new VDate(this.mForEffectiveDate).getMonth());
        sOCTypeZVKBean.setYear(Integer.toString(new VDate(forValidFromDate).getYear()));
        sOCTypeZVKBean.setFirma_bezeichnung(this.getCompanyLongDescription());
        sOCTypeZVKBean.setFirma_VWE_Nr(this.mPCompanyForFoundations.getPCompanyKey());
        if (sOCTypeZVKBean.getEmployeeZVKRecipientToPlant()) {
            String plantDescrition = this.getPlantLongDescription(oidPlant);
            sOCTypeZVKBean.setBetriebsstaette_bezeichnung(plantDescrition);
            sOCTypeZVKBean.setBetriebsstaette_VWE_Nr(this.getPlantKey(oidPlant));
            sOCTypeZVKBean.setArbeitgeber_betriebsnr(this.getPlantEmployerNumber(oidPlant));
            sOCTypeZVKBean.setArbeitgeber_bezeichnung(plantDescrition);
            CompanyPlantPostalAddress plantPostalAdress = this.getPlantPostalAdress(oidPlant);
            sOCTypeZVKBean.setArbeitgeber_plz_ort(plantPostalAdress.getPostalCode() + " " + plantPostalAdress.getCity());
            sOCTypeZVKBean.setArbeitgeber_str_nr(plantPostalAdress.getStreet());
            sOCTypeZVKBean.setArbeitgeber_VWE_Nr(this.getPlantKey(oidPlant));
        } else {
            sOCTypeZVKBean.setArbeitgeber_betriebsnr(this.getCompanyEmployerNumber());
            sOCTypeZVKBean.setArbeitgeber_bezeichnung(this.getCompanyLongDescription());
            CompanyPlantPostalAddress companyPostalAdress = this.getCompanyPostalAdress();
            sOCTypeZVKBean.setArbeitgeber_plz_ort(companyPostalAdress.getPostalCode() + " " + companyPostalAdress.getCity());
            sOCTypeZVKBean.setArbeitgeber_str_nr(companyPostalAdress.getStreet());
            sOCTypeZVKBean.setArbeitgeber_VWE_Nr(this.mPCompanyForFoundations.getPCompanyKey());
            sOCTypeZVKBean.setBetriebsstaette_bezeichnung("");
            sOCTypeZVKBean.setBetriebsstaette_VWE_Nr("");
        }
        List liste = ReportEmployeesHandlingHelper.getValuePositionsLi((String)oidEmployee, (String[])this.mResultValueTypeNumber, (Date)forEffectiveDate, (Date)forValidFromDate, (Date)forValidUntilDate);
        this.resetBigDecimalFields();
        if (liste != null) {
            Date tempForValidUntilDate = DateHelper.getLastDayOfMonth((Date)forValidUntilDate);
            Date tempForValidFromDate = DateHelper.getFirstDayOfMonth((Date)tempForValidUntilDate);
            while (DateHelper.beforeOrEqual((Date)forValidFromDate, (Date)tempForValidUntilDate)) {
                this.FIELD_monatliches_gesamt_entgelt = BigDecimal.valueOf(0L, 2);
                this.FIELD_monatliche_zus_umlage = BigDecimal.valueOf(0L, 2);
                this.getValuePositionFieldValues(liste, tempForValidFromDate, tempForValidUntilDate);
                if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.FIELD_monatliche_zus_umlage)) {
                    this.FIELD_entgelt_zus_umlage = this.FIELD_entgelt_zus_umlage.add(this.FIELD_monatliches_gesamt_entgelt.subtract(this.grenzbetrag_zus_umlage));
                }
                tempForValidUntilDate = DateHelper.yesterday((Date)tempForValidFromDate);
                tempForValidFromDate = DateHelper.getFirstDayOfMonth((Date)tempForValidUntilDate);
            }
        }
        sOCTypeZVKBean.setEntgelt_bd(this.FIELD_100900);
        sOCTypeZVKBean.setUmlage_an_bd(this.FIELD_100940);
        sOCTypeZVKBean.setUmlage_ag_bd(this.FIELD_100950);
        sOCTypeZVKBean.setSan_geld_bd(this.FIELD_100910);
        sOCTypeZVKBean.setZusatzbeitrag_bd(this.FIELD_100920.add(this.FIELD_100930).add(this.FIELD_100970));
        sOCTypeZVKBean.setPausch_beitrag_bd(this.FIELD_111200);
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.FIELD_100960)) {
            sOCTypeZVKBean.setEntgelt_zusaetz_umlage_bd(this.FIELD_entgelt_zus_umlage);
            sOCTypeZVKBean.setZusaetz_umlage_db(this.FIELD_100960);
            sOCTypeZVKBean.setF_kennz_zusaetz_umlage("17");
            sOCTypeZVKBean.setF_entgelt_zusaetz_umlage(ReportHelper.toCurrencyFormatIfNullString((Object)this.FIELD_entgelt_zus_umlage));
            sOCTypeZVKBean.setF_zusaetz_umlage(ReportHelper.toCurrencyFormatIfNullString((Object)this.FIELD_100960));
        }
        sOCTypeZVKBean.setF_entgelt(ReportHelper.toCurrencyFormatIfNullString((Object)this.FIELD_100900));
        sOCTypeZVKBean.setF_umlage_an(ReportHelper.toCurrencyFormatIfNullString((Object)this.FIELD_100940));
        sOCTypeZVKBean.setF_umlage_ag(ReportHelper.toCurrencyFormatIfNullString((Object)this.FIELD_100950));
        sOCTypeZVKBean.setF_san_geld(ReportHelper.toCurrencyFormatIfNullString((Object)this.FIELD_100910));
        sOCTypeZVKBean.setF_zusatzbeitrag(ReportHelper.toCurrencyFormatIfNullString((Object)this.FIELD_100920.add(this.FIELD_100930).add(this.FIELD_100970)));
        sOCTypeZVKBean.setF_pausch_beitrag(ReportHelper.toCurrencyFormatIfNullString((Object)this.FIELD_111200));
    }

    private Map<String, LinkedList<FstateregionallContainer>> getHashMapFstateregionall() {
        try {
            PersistencyDataSet fstateregionallDataSet = daoFstateregionall.getDataSet(new Order[]{Order.asc((String)"fstateregionkey")}, null);
            HashMap<String, LinkedList<FstateregionallContainer>> fstateregionallMap = null;
            if (fstateregionallDataSet != null) {
                fstateregionallMap = new HashMap<String, LinkedList<FstateregionallContainer>>();
                while (fstateregionallDataSet.hasNext()) {
                    FstateregionallContainer fstateregionallContainer = (FstateregionallContainer)fstateregionallDataSet.getNext();
                    LinkedList<FstateregionallContainer> liste = (LinkedList<FstateregionallContainer>)fstateregionallMap.get(Integer.toString(fstateregionallContainer.fstateregionkey));
                    if (liste == null) {
                        liste = new LinkedList<FstateregionallContainer>();
                        fstateregionallMap.put(Integer.toString(fstateregionallContainer.fstateregionkey), liste);
                    }
                    liste.add(fstateregionallContainer);
                }
            }
            return fstateregionallMap;
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    private void getValuePositionFieldValues(List<ValuepositionContainer> liste, Date beginnDate, Date endDate) {
        BigDecimal betrag_100900 = BigDecimal.valueOf(0L, 2);
        BigDecimal betrag_100910 = BigDecimal.valueOf(0L, 2);
        BigDecimal betrag_100920 = BigDecimal.valueOf(0L, 2);
        BigDecimal betrag_100930 = BigDecimal.valueOf(0L, 2);
        BigDecimal betrag_100970 = BigDecimal.valueOf(0L, 2);
        BigDecimal betrag_100940 = BigDecimal.valueOf(0L, 2);
        BigDecimal betrag_100950 = BigDecimal.valueOf(0L, 2);
        BigDecimal betrag_100960 = BigDecimal.valueOf(0L, 2);
        BigDecimal betrag_111200 = BigDecimal.valueOf(0L, 2);
        BigDecimal betrag_monatliches_gesamt_entgelt = BigDecimal.valueOf(0L, 2);
        BigDecimal betrag_monatliche_zus_umlage = BigDecimal.valueOf(0L, 2);
        for (ValuepositionContainer valuepositionContainer : liste) {
            if (!DateHelper.beforeOrEqual((Date)valuepositionContainer.validfrom, (Date)endDate) || !DateHelper.afterOrEqual((Date)valuepositionContainer.validuntil, (Date)beginnDate)) continue;
            Date valueBeginnDate = DateHelper.max((Date)valuepositionContainer.validfrom, (Date)beginnDate);
            Date valueEndDate = DateHelper.min((Date)valuepositionContainer.validuntil, (Date)endDate);
            valueEndDate = DateHelper.getLastDayOfMonth((Date)valueEndDate);
            BigDecimal augend = valuepositionContainer.results.multiply(new BigDecimal(PDateHelper.getDiffInMonths((Date)DateHelper.tomorrow((Date)valueEndDate), (Date)valueBeginnDate)));
            switch (valuepositionContainer.valuetypenumber) {
                case 100900: {
                    betrag_100900 = betrag_100900.add(augend);
                    betrag_monatliches_gesamt_entgelt = betrag_monatliches_gesamt_entgelt.add(augend);
                    break;
                }
                case 100910: {
                    betrag_100910 = betrag_100910.add(augend);
                    break;
                }
                case 100920: {
                    betrag_100920 = betrag_100920.add(augend);
                    break;
                }
                case 100930: {
                    betrag_100930 = betrag_100930.add(augend);
                    break;
                }
                case 100970: {
                    betrag_100970 = betrag_100970.add(augend);
                    break;
                }
                case 100940: {
                    betrag_100940 = betrag_100940.add(augend);
                    break;
                }
                case 100950: {
                    betrag_100950 = betrag_100950.add(augend);
                    break;
                }
                case 100960: {
                    betrag_100960 = betrag_100960.add(augend);
                    betrag_monatliche_zus_umlage = betrag_monatliche_zus_umlage.add(augend);
                    break;
                }
                case 111200: {
                    betrag_111200 = betrag_111200.add(augend);
                }
            }
        }
        this.FIELD_100900 = this.FIELD_100900.add(betrag_100900);
        this.FIELD_100910 = this.FIELD_100910.add(betrag_100910);
        this.FIELD_100920 = this.FIELD_100920.add(betrag_100920);
        this.FIELD_100930 = this.FIELD_100930.add(betrag_100930);
        this.FIELD_100970 = this.FIELD_100970.add(betrag_100970);
        this.FIELD_100940 = this.FIELD_100940.add(betrag_100940);
        this.FIELD_100950 = this.FIELD_100950.add(betrag_100950);
        this.FIELD_100960 = this.FIELD_100960.add(betrag_100960);
        this.FIELD_111200 = this.FIELD_111200.add(betrag_111200);
        this.FIELD_monatliches_gesamt_entgelt = this.FIELD_monatliches_gesamt_entgelt.add(betrag_monatliches_gesamt_entgelt);
        this.FIELD_monatliche_zus_umlage = this.FIELD_monatliche_zus_umlage.add(betrag_monatliche_zus_umlage);
    }

    private void resetBigDecimalFields() {
        this.FIELD_100900 = BigDecimal.valueOf(0L, 2);
        this.FIELD_100910 = BigDecimal.valueOf(0L, 2);
        this.FIELD_100920 = BigDecimal.valueOf(0L, 2);
        this.FIELD_100930 = BigDecimal.valueOf(0L, 2);
        this.FIELD_100970 = BigDecimal.valueOf(0L, 2);
        this.FIELD_100940 = BigDecimal.valueOf(0L, 2);
        this.FIELD_100950 = BigDecimal.valueOf(0L, 2);
        this.FIELD_100960 = BigDecimal.valueOf(0L, 2);
        this.FIELD_111200 = BigDecimal.valueOf(0L, 2);
        this.FIELD_entgelt_zus_umlage = BigDecimal.valueOf(0L, 2);
    }

    private void setFieldsFromBeanFields() {
        this.FIELD_header_monat_bezeichnung = this.mSOCTypeBeanForReport.getHeader_monat_bezeichnung();
        this.FIELD_jahr = DateMapper.toYYYYString((Date)this.mForValidDate);
        this.FIELD_recipient_bezeichnung = this.mSOCTypeBeanForReport.getRefereToZVKRecipientDescription();
        this.FIELD_recipient_key = this.mSOCTypeBeanForReport.getRecipient_key();
        this.FIELD_recipient_str_nr = this.mSOCTypeBeanForReport.getRecipient_str_nr();
        if (!StringMapper.isNullString((String)this.FIELD_recipient_str_nr)) {
            this.FIELD_recipient_str_nr = this.FIELD_recipient_str_nr + ", ";
        }
        this.FIELD_recipient_plz_ort = this.mSOCTypeBeanForReport.getRecipient_plz_ort();
        this.FIELD_zvk_betriebsnummer = this.mSOCTypeBeanForReport.getRecipient_betriebsnummer();
        this.FIELD_zvk_art = this.mSOCTypeBeanForReport.getZvk_art();
        this.FIELD_umlage_aga = this.mSOCTypeBeanForReport.getUmlage_aga();
        this.FIELD_umlage_ana = this.mSOCTypeBeanForReport.getUmlage_ana();
        this.FIELD_zusaetzl_umlage_aga = this.mSOCTypeBeanForReport.getZusaetzl_umlage_aga();
        this.FIELD_zusatzbeitr_aga = this.mSOCTypeBeanForReport.getZusatzbeitr_aga();
        this.FIELD_zusatzbeitr_ana = this.mSOCTypeBeanForReport.getZusatzbeitr_ana();
        this.FIELD_sanierungsgeld = this.mSOCTypeBeanForReport.getSanierungsgeld();
        this.FIELD_sv_pflicht_anteil = this.mSOCTypeBeanForReport.getSv_pflicht_anteil();
        this.FIELD_hoechstbetrag = this.mSOCTypeBeanForReport.getHoechstbetrag();
        this.FIELD_grenzbetrag = this.mSOCTypeBeanForReport.getGrenzbetrag();
        this.FIELD_verdoppelungsmonat = this.mSOCTypeBeanForReport.getVerdoppelungsmonat();
        this.FIELD_firma_bezeichnung = this.mSOCTypeBeanForReport.getFirma_bezeichnung();
        this.FIELD_firma_nr = this.mSOCTypeBeanForReport.getFirma_VWE_Nr();
        if (this.mSOCTypeBeanForReport.getEmployeeZVKRecipientToPlant()) {
            this.FIELD_betriebsstaette_bezeichnung = this.mSOCTypeBeanForReport.getBetriebsstaette_bezeichnung();
            this.FIELD_betriebsstaette_nr = this.mSOCTypeBeanForReport.getBetriebsstaette_VWE_Nr();
        }
        this.FIELD_AG_str_nr = this.mSOCTypeBeanForReport.getArbeitgeber_str_nr();
        if (!StringMapper.isNullString((String)this.FIELD_AG_str_nr)) {
            this.FIELD_AG_str_nr = this.FIELD_AG_str_nr + ", ";
        }
        this.FIELD_AG_plz_ort = this.mSOCTypeBeanForReport.getArbeitgeber_plz_ort();
        this.FIELD_AG_bezeichnung = this.mSOCTypeBeanForReport.getArbeitgeber_bezeichnung();
        this.FIELD_AG_beitragskontonummer = this.mSOCTypeBeanForReport.getArbeitgeber_beitragskonto_nr();
        this.FIELD_AG_betriebsnummer = this.mSOCTypeBeanForReport.getArbeitgeber_betriebsnr();
        this.FIELD_AG_VWE_NR = this.mSOCTypeBeanForReport.getArbeitgeber_VWE_Nr();
        if (!this.mSOCTypeBeanForReport.getJustForYearAddition()) {
            this.mEmployeeBeanCollection.add(new StatementOfContributionZVKTypeBean(this.mSOCTypeBeanForReport.getF_austritt(), this.mSOCTypeBeanForReport.getF_eintritt(), this.mSOCTypeBeanForReport.getF_entgelt(), this.mSOCTypeBeanForReport.getF_umlage_an(), this.mSOCTypeBeanForReport.getF_umlage_ag(), this.mSOCTypeBeanForReport.getF_san_geld(), this.mSOCTypeBeanForReport.getF_zusatzbeitrag(), this.mSOCTypeBeanForReport.getF_pausch_beitrag(), this.mSOCTypeBeanForReport.getF_familienname(), this.mSOCTypeBeanForReport.getF_geburts_datum(), this.mSOCTypeBeanForReport.getF_mitgliedsnummer(), this.mSOCTypeBeanForReport.getF_monat_bezeichnung(), this.mSOCTypeBeanForReport.getF_pers_nr(), (String)(StringMapper.isNullString((String)this.mSOCTypeBeanForReport.getF_status()) ? "" : this.mSOCTypeBeanForReport.getF_status() + " "), this.mSOCTypeBeanForReport.getF_vorname(), DateMapper.toMMYYYYPointSeparationString((Date)this.mForValidDate), this.mSOCTypeBeanForReport.getF_kennz_zusaetz_umlage(), this.mSOCTypeBeanForReport.getF_entgelt_zusaetz_umlage(), this.mSOCTypeBeanForReport.getF_zusaetz_umlage()));
        }
        if (!this.mSOCTypeBeanForReport.isAreYearDatas()) {
            this.entgelt_bd = this.entgelt_bd.add(this.mSOCTypeBeanForReport.getEntgelt_bd());
            this.umlage_an_bd = this.umlage_an_bd.add(this.mSOCTypeBeanForReport.getUmlage_an_bd());
            this.umlage_ag_bd = this.umlage_ag_bd.add(this.mSOCTypeBeanForReport.getUmlage_ag_bd());
            this.san_geld_bd = this.san_geld_bd.add(this.mSOCTypeBeanForReport.getSan_geld_bd());
            this.zusatzbeitrag_bd = this.zusatzbeitrag_bd.add(this.mSOCTypeBeanForReport.getZusatzbeitrag_bd());
            this.pausch_beitrag_bd = this.pausch_beitrag_bd.add(this.mSOCTypeBeanForReport.getPausch_beitrag_bd());
            this.entgelt_zus_umlage_bd = this.entgelt_zus_umlage_bd.add(this.mSOCTypeBeanForReport.getEntgelt_zusaetz_umlage_bd());
            this.zus_umlage_bd = this.zus_umlage_bd.add(this.mSOCTypeBeanForReport.getZusaetz_umlage_db());
            if (this.mAbrechnungJanuar && DateHelper.before((Date)this.mSOCTypeBeanForReport.getForValidFromDate(), (Date)DateHelper.getFirstDayOfYear((Date)this.mForValidDate))) {
                this.umlage_an_vj_bd = this.umlage_an_vj_bd.add(this.mSOCTypeBeanForReport.getUmlage_an_bd());
                this.umlage_ag_vj_bd = this.umlage_ag_vj_bd.add(this.mSOCTypeBeanForReport.getUmlage_ag_bd());
                this.san_geld_vj_bd = this.san_geld_vj_bd.add(this.mSOCTypeBeanForReport.getSan_geld_bd());
                this.zusatzbeitrag_vj_bd = this.zusatzbeitrag_vj_bd.add(this.mSOCTypeBeanForReport.getZusatzbeitrag_bd());
                this.zus_umlage_vj_bd = this.zus_umlage_vj_bd.add(this.mSOCTypeBeanForReport.getZusaetz_umlage_db());
            }
        } else {
            this.entgelt_jahr_bd = this.entgelt_jahr_bd.add(this.mSOCTypeBeanForReport.getEntgelt_bd());
            this.umlage_an_jahr_bd = this.umlage_an_jahr_bd.add(this.mSOCTypeBeanForReport.getUmlage_an_bd());
            this.umlage_ag_jahr_bd = this.umlage_ag_jahr_bd.add(this.mSOCTypeBeanForReport.getUmlage_ag_bd());
            this.san_geld_jahr_bd = this.san_geld_jahr_bd.add(this.mSOCTypeBeanForReport.getSan_geld_bd());
            this.zusatzbeitrag_jahr_bd = this.zusatzbeitrag_jahr_bd.add(this.mSOCTypeBeanForReport.getZusatzbeitrag_bd());
            this.pausch_beitrag_jahr_bd = this.pausch_beitrag_jahr_bd.add(this.mSOCTypeBeanForReport.getPausch_beitrag_bd());
            this.entgelt_zus_umlage_jahr_bd = this.entgelt_zus_umlage_jahr_bd.add(this.mSOCTypeBeanForReport.getEntgelt_zusaetz_umlage_bd());
            this.zus_umlage_jahr_bd = this.zus_umlage_jahr_bd.add(this.mSOCTypeBeanForReport.getZusaetz_umlage_db());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("FIELD_jahr = {}FIELD_recipient_bezeichnung={}FIELD_recipient_key={}FIELD_recipient_str_nr ={}FIELD_recipient_plz_ort ={}FIELD_AG_bezeichnung ={}FIELD_AG_betriebsnummer ={}FIELD_AG_beitragskontonummer ={}FIELD_AG_VWE_NR ={}FIELD_AG_str_nr ={}FIELD_AG_plz_ort ={}FIELD_firma_bezeichnung={}FIELD_firma_nr={}", new Object[]{this.FIELD_jahr, this.FIELD_recipient_bezeichnung, this.FIELD_recipient_key, this.FIELD_recipient_str_nr, this.FIELD_recipient_plz_ort, this.FIELD_AG_bezeichnung, this.FIELD_AG_betriebsnummer, this.FIELD_AG_beitragskontonummer, this.FIELD_AG_VWE_NR, this.FIELD_AG_str_nr, this.FIELD_AG_plz_ort, this.FIELD_firma_bezeichnung, this.FIELD_firma_nr});
            if (this.mSOCTypeBeanForReport.getEmployeeZVKRecipientToPlant()) {
                LOGGER.debug("FIELD_betriebsstaette_bezeichnung= {}FIELD_betriebsstaette_beitragskonto_nr={}FIELD_betriebsstaette_nr={}", new Object[]{this.FIELD_betriebsstaette_bezeichnung, "", this.FIELD_betriebsstaette_nr});
            }
            LOGGER.debug("FIELD_header_monat_bezeichnung = {}getF_monat_bezeichnung ={}getMonat_int ={}getF_status ={}getStatus_int ={}getF_pers_nr ={}getF_vorname ={}getF_familienname ={}getF_geburts_datum={}getF_eintritt={}getF_mitgliedsnummer ={}(mSOCTypeBeanForReport.getEmployee_brutto_bd()={}mSOCTypeBeanForReport.getEmployee_an_anteil_bd()={}mSOCTypeBeanForReport.getEmployee_ag_anteil_bd()={}mSOCTypeBeanForReport.getEmployee_gesamt_beitrag_bd()={}", new Object[]{this.mSOCTypeBeanForReport.getHeader_monat_bezeichnung(), this.mSOCTypeBeanForReport.getF_monat_bezeichnung(), this.mSOCTypeBeanForReport.getMonat_int(), this.mSOCTypeBeanForReport.getF_status(), this.mSOCTypeBeanForReport.getStatus_int(), this.mSOCTypeBeanForReport.getF_pers_nr(), this.mSOCTypeBeanForReport.getF_vorname(), this.mSOCTypeBeanForReport.getF_familienname(), this.mSOCTypeBeanForReport.getF_geburts_datum(), this.mSOCTypeBeanForReport.getF_eintritt(), this.mSOCTypeBeanForReport.getF_mitgliedsnummer(), this.mSOCTypeBeanForReport.getEntgelt_bd(), this.mSOCTypeBeanForReport.getUmlage_an_bd(), this.mSOCTypeBeanForReport.getUmlage_ag_bd(), this.mSOCTypeBeanForReport.getSan_geld_bd(), this.mSOCTypeBeanForReport.getZusatzbeitrag_bd(), this.mSOCTypeBeanForReport.getPausch_beitrag_bd()});
        }
    }

    private void resetSummFields() {
        this.entgelt_bd = BigDecimal.valueOf(0L, 2);
        this.umlage_an_bd = BigDecimal.valueOf(0L, 2);
        this.umlage_ag_bd = BigDecimal.valueOf(0L, 2);
        this.san_geld_bd = BigDecimal.valueOf(0L, 2);
        this.zusatzbeitrag_bd = BigDecimal.valueOf(0L, 2);
        this.pausch_beitrag_bd = BigDecimal.valueOf(0L, 2);
        this.entgelt_jahr_bd = BigDecimal.valueOf(0L, 2);
        this.umlage_an_jahr_bd = BigDecimal.valueOf(0L, 2);
        this.umlage_ag_jahr_bd = BigDecimal.valueOf(0L, 2);
        this.san_geld_jahr_bd = BigDecimal.valueOf(0L, 2);
        this.zusatzbeitrag_jahr_bd = BigDecimal.valueOf(0L, 2);
        this.pausch_beitrag_jahr_bd = BigDecimal.valueOf(0L, 2);
        this.entgelt_zus_umlage_bd = BigDecimal.valueOf(0L, 2);
        this.zus_umlage_bd = BigDecimal.valueOf(0L, 2);
        this.entgelt_zus_umlage_jahr_bd = BigDecimal.valueOf(0L, 2);
        this.zus_umlage_jahr_bd = BigDecimal.valueOf(0L, 2);
        this.umlage_an_vj_bd = BigDecimal.valueOf(0L, 2);
        this.umlage_ag_vj_bd = BigDecimal.valueOf(0L, 2);
        this.san_geld_vj_bd = BigDecimal.valueOf(0L, 2);
        this.zusatzbeitrag_vj_bd = BigDecimal.valueOf(0L, 2);
        this.zus_umlage_vj_bd = BigDecimal.valueOf(0L, 2);
    }

    private void buildSummCollection() throws BusinessDomainException {
        if (this.mTypeOfList != StatementOfContributionListTypeEnum.SOCLT_NurJahreswerte) {
            this.mSummCollection.add(new StatementOfContributionZVKSummBean("Gesamt lfd. Monat " + DateMapper.toMMYYYYPointSeparationString((Date)this.mForValidDate), ReportHelper.toCurrencyFormatIfNullString((Object)this.entgelt_bd), ReportHelper.toCurrencyFormatIfNullString((Object)this.umlage_an_bd), ReportHelper.toCurrencyFormatIfNullString((Object)this.umlage_ag_bd), ReportHelper.toCurrencyFormatIfNullString((Object)this.san_geld_bd), ReportHelper.toCurrencyFormatIfNullString((Object)this.zusatzbeitrag_bd), ReportHelper.toCurrencyFormatIfNullString((Object)this.pausch_beitrag_bd), BigDecimalMapper.isZeroOrNull((BigDecimal)this.zus_umlage_bd) ? "" : "17", ReportHelper.toCurrencyFormatIfNullString((Object)this.entgelt_zus_umlage_bd), ReportHelper.toCurrencyFormatIfNullString((Object)this.zus_umlage_bd)));
        }
        if (this.mTypeOfList != StatementOfContributionListTypeEnum.SOCLT_NurMonatswerte) {
            this.mSummCollection.add(new StatementOfContributionZVKSummBean("Gesamt lfd. Jahr " + DateMapper.toYYYYString((Date)this.mForValidDate), ReportHelper.toCurrencyFormatIfNullString((Object)this.entgelt_jahr_bd), ReportHelper.toCurrencyFormatIfNullString((Object)this.umlage_an_jahr_bd), ReportHelper.toCurrencyFormatIfNullString((Object)this.umlage_ag_jahr_bd), ReportHelper.toCurrencyFormatIfNullString((Object)this.san_geld_jahr_bd), ReportHelper.toCurrencyFormatIfNullString((Object)this.zusatzbeitrag_jahr_bd), ReportHelper.toCurrencyFormatIfNullString((Object)this.pausch_beitrag_bd), BigDecimalMapper.isZeroOrNull((BigDecimal)this.zus_umlage_jahr_bd) ? "" : "17", ReportHelper.toCurrencyFormatIfNullString((Object)this.entgelt_zus_umlage_jahr_bd), ReportHelper.toCurrencyFormatIfNullString((Object)this.zus_umlage_jahr_bd)));
        }
        if (this.mPayment) {
            String oidRecipient = this.mSOCTypeBeanForReport.getOidRecipient();
            RecipientTP zVKRecipientTP = this.getRecipientTP(oidRecipient, this.mForEffectiveDate, this.mForValidDate);
            BigDecimal umlagenVorjahr = this.umlage_an_vj_bd.add(this.umlage_ag_vj_bd).add(this.zus_umlage_vj_bd);
            BigDecimal umlagenAktJahr = this.umlage_an_bd.add(this.umlage_ag_bd).add(this.zus_umlage_bd).subtract(umlagenVorjahr);
            BigDecimal sanGeldVorjahr = this.san_geld_vj_bd;
            BigDecimal sanGeldAktJahr = this.san_geld_bd.subtract(sanGeldVorjahr);
            BigDecimal zusatzbeitragVorjahr = this.zusatzbeitrag_vj_bd;
            BigDecimal zusatzbeitragAktJahr = this.zusatzbeitrag_bd.subtract(zusatzbeitragVorjahr);
            if (!(BigDecimalMapper.isZero((BigDecimal)umlagenAktJahr.add(umlagenVorjahr)) && BigDecimalMapper.isZero((BigDecimal)sanGeldAktJahr.add(sanGeldVorjahr)) && BigDecimalMapper.isZero((BigDecimal)zusatzbeitragAktJahr.add(zusatzbeitragVorjahr)))) {
                if (zVKRecipientTP.getModeOfPaymentEnum().value() == 0 || zVKRecipientTP.getModeOfPaymentEnum().value() == 1) {
                    Bank bank3;
                    Bank bank2;
                    List<PaymentCompRecipientBean> tempPaymentList;
                    Bank bank1;
                    String assignmentPCompanyRecipientKey = this.mSOCTypeBeanForReport.getEmployeeZVKRecipientToPlant() ? this.mSOCTypeBeanForReport.getOidPlant() + this.mSOCTypeBeanForReport.getOidRecipient() : this.mSOCTypeBeanForReport.getOidRecipient();
                    AssignmentPCompanyZVK aPCZVK = this.mPCompanyZVKHM.get(assignmentPCompanyRecipientKey);
                    AssignmentPCompanyZVKTP aPCZVKTP = aPCZVK.getAssignmentPCompanyZVKTP(this.mForEffectiveDate, this.mForValidDate);
                    String stdZVKDescription = zVKRecipientTP.getLongDescription();
                    PostalAddress stdZVKAddress = zVKRecipientTP.getAddress();
                    String stdIdentNumber = aPCZVKTP.getIdentNumber();
                    BankAccount bankAccountStd = zVKRecipientTP.getBankAccount();
                    ModeOfPaymentEnum stdModeOfPayment = zVKRecipientTP.getModeOfPaymentEnum();
                    TypeOfBankTransferEnum stdTypeOfBankTransfer = zVKRecipientTP.getTypeOfBankTransfer();
                    String stdAccountNumber = "";
                    String stdIban = "";
                    String stdReasonForTransfer = "";
                    String stdBankCodeNumber = "";
                    String stdBicCode = "";
                    String stdBankDescription = "";
                    String stdOidCompanyAccount = this.getStandardCompanyAccount();
                    BigDecimal stdAmountAktJahr = BigDecimal.ZERO;
                    BigDecimal stdAmountVorjahr = BigDecimal.ZERO;
                    String tempAccountNumber = "";
                    String tempIban = "";
                    String tempReasonForTransferAktJahr = "";
                    String tempReasonForTransferVorjahr = "";
                    String tempBankCodeNumber = "";
                    String tempBicCode = "";
                    String tempBankDescription = "";
                    String tempOidCompanyAccount = "";
                    BigDecimal tempAmount = BigDecimal.ZERO;
                    if (bankAccountStd != null) {
                        stdAccountNumber = bankAccountStd.getAccountNumber();
                        stdIban = bankAccountStd.getIban();
                        stdReasonForTransfer = bankAccountStd.getReasonForTransfer();
                    }
                    BankAccount bankAccount1 = aPCZVKTP.getBankAccount1();
                    BankAccount bankAccount2 = aPCZVKTP.getBankAccount2();
                    BankAccount bankAccount3 = aPCZVKTP.getBankAccount3();
                    CompanyAccount companyAccount1 = aPCZVKTP.getCompanyAccount1();
                    CompanyAccount companyAccount2 = aPCZVKTP.getCompanyAccount2();
                    CompanyAccount companyAccount3 = aPCZVKTP.getCompanyAccount3();
                    tempAmount = BigDecimal.ZERO;
                    if (bankAccount1 != null && !BigDecimalMapper.isZero((BigDecimal)umlagenAktJahr.add(umlagenVorjahr)) && (bank1 = bankAccount1.getBank()) != null) {
                        tempAccountNumber = bankAccount1.getAccountNumber();
                        tempIban = bankAccount1.getIban();
                        tempReasonForTransferAktJahr = StringMapper.isNullString((String)bankAccount1.getReasonForTransfer()) ? stdReasonForTransfer : bankAccount1.getReasonForTransfer();
                        tempReasonForTransferAktJahr = this.checkModifiyReasonForTransfer(tempReasonForTransferAktJahr, this.mForValidDate);
                        tempReasonForTransferVorjahr = StringMapper.isNullString((String)aPCZVKTP.getReasonOfTransferPreviousYear1()) ? stdReasonForTransfer : aPCZVKTP.getReasonOfTransferPreviousYear1();
                        tempReasonForTransferVorjahr = this.checkModifiyReasonForTransfer(tempReasonForTransferVorjahr, DateHelper.addMonths((Date)this.mForValidDate, (int)-1));
                        tempBankCodeNumber = bank1.getBankTP(this.mForEffectiveDate, this.mForValidDate).getBankCodeNumber();
                        tempBicCode = bank1.getBankTP(this.mForEffectiveDate, this.mForValidDate).getBicCode();
                        tempBankDescription = bank1.getBankTP(this.mForEffectiveDate, this.mForValidDate).getShortDescription();
                        tempAmount = umlagenAktJahr.add(umlagenVorjahr);
                        tempOidCompanyAccount = companyAccount1 != null ? companyAccount1.getObjectid() : "";
                        tempPaymentList = this.mPaymentHashMap.get(tempOidCompanyAccount);
                        if (tempPaymentList == null) {
                            tempPaymentList = new LinkedList<PaymentCompRecipientBean>();
                        }
                        if (!BigDecimalMapper.isZero((BigDecimal)umlagenAktJahr)) {
                            tempPaymentList.add(new PaymentCompRecipientBean(zVKRecipientTP.getRecipient(), tempOidCompanyAccount, stdModeOfPayment, stdTypeOfBankTransfer, tempAccountNumber, tempIban, tempReasonForTransferAktJahr, tempBankCodeNumber, tempBicCode, tempBankDescription, stdZVKDescription, stdZVKAddress, stdIdentNumber, BigDecimalMapper.compareTo((BigDecimal)umlagenVorjahr, (BigDecimal)BigDecimal.ZERO) < 0 ? umlagenAktJahr.add(umlagenVorjahr) : umlagenAktJahr, this.mIsConsolidation ? "" : this.mSOCTypeBeanForReport.getOidPlant(), this.mSOCTypeBeanForReport.getOidPCompany()));
                            this.addZVKAvisReportBean(oidRecipient + tempReasonForTransferAktJahr, umlagenAktJahr, BigDecimalMapper.compareTo((BigDecimal)umlagenVorjahr, (BigDecimal)BigDecimal.ZERO) < 0 ? umlagenVorjahr : BigDecimal.ZERO, this.mSOCTypeBeanForReport);
                        }
                        if (BigDecimalMapper.compareTo((BigDecimal)umlagenVorjahr, (BigDecimal)BigDecimal.ZERO) > 0) {
                            tempPaymentList.add(new PaymentCompRecipientBean(zVKRecipientTP.getRecipient(), tempOidCompanyAccount, stdModeOfPayment, stdTypeOfBankTransfer, tempAccountNumber, tempIban, tempReasonForTransferVorjahr, tempBankCodeNumber, tempBicCode, tempBankDescription, stdZVKDescription, stdZVKAddress, stdIdentNumber, umlagenVorjahr, this.mIsConsolidation ? "" : this.mSOCTypeBeanForReport.getOidPlant(), this.mSOCTypeBeanForReport.getOidPCompany()));
                            this.addZVKAvisReportBean(oidRecipient + tempReasonForTransferVorjahr, BigDecimal.ZERO, umlagenVorjahr, this.mSOCTypeBeanForReport);
                        }
                        this.mPaymentHashMap.put(tempOidCompanyAccount, tempPaymentList);
                    }
                    if (BigDecimalMapper.isZero((BigDecimal)tempAmount)) {
                        stdAmountAktJahr = stdAmountAktJahr.add(umlagenAktJahr);
                        stdAmountVorjahr = stdAmountVorjahr.add(umlagenVorjahr);
                    }
                    tempAmount = BigDecimal.ZERO;
                    if (bankAccount2 != null && !BigDecimalMapper.isZero((BigDecimal)sanGeldAktJahr.add(sanGeldVorjahr)) && (bank2 = bankAccount2.getBank()) != null) {
                        tempAccountNumber = bankAccount2.getAccountNumber();
                        tempIban = bankAccount2.getIban();
                        tempReasonForTransferAktJahr = StringMapper.isNullString((String)bankAccount2.getReasonForTransfer()) ? stdReasonForTransfer : bankAccount2.getReasonForTransfer();
                        tempReasonForTransferAktJahr = this.checkModifiyReasonForTransfer(tempReasonForTransferAktJahr, this.mForValidDate);
                        tempReasonForTransferVorjahr = StringMapper.isNullString((String)aPCZVKTP.getReasonOfTransferPreviousYear2()) ? stdReasonForTransfer : aPCZVKTP.getReasonOfTransferPreviousYear2();
                        tempReasonForTransferVorjahr = this.checkModifiyReasonForTransfer(tempReasonForTransferVorjahr, DateHelper.addMonths((Date)this.mForValidDate, (int)-1));
                        tempBankCodeNumber = bank2.getBankTP(this.mForEffectiveDate, this.mForValidDate).getBankCodeNumber();
                        tempBankDescription = bank2.getBankTP(this.mForEffectiveDate, this.mForValidDate).getShortDescription();
                        tempBicCode = bank2.getBankTP(this.mForEffectiveDate, this.mForValidDate).getBicCode();
                        tempAmount = sanGeldAktJahr.add(sanGeldVorjahr);
                        tempOidCompanyAccount = companyAccount2 != null ? companyAccount2.getObjectid() : "";
                        tempPaymentList = this.mPaymentHashMap.get(tempOidCompanyAccount);
                        if (tempPaymentList == null) {
                            tempPaymentList = new LinkedList<PaymentCompRecipientBean>();
                        }
                        if (!BigDecimalMapper.isZero((BigDecimal)sanGeldAktJahr)) {
                            tempPaymentList.add(new PaymentCompRecipientBean(zVKRecipientTP.getRecipient(), tempOidCompanyAccount, stdModeOfPayment, stdTypeOfBankTransfer, tempAccountNumber, tempIban, tempReasonForTransferAktJahr, tempBankCodeNumber, tempBicCode, tempBankDescription, stdZVKDescription, stdZVKAddress, stdIdentNumber, BigDecimalMapper.compareTo((BigDecimal)sanGeldVorjahr, (BigDecimal)BigDecimal.ZERO) < 0 ? sanGeldAktJahr.add(sanGeldVorjahr) : sanGeldAktJahr, this.mIsConsolidation ? "" : this.mSOCTypeBeanForReport.getOidPlant(), this.mSOCTypeBeanForReport.getOidPCompany()));
                            this.addZVKAvisReportBean(oidRecipient + tempReasonForTransferAktJahr, sanGeldAktJahr, BigDecimalMapper.compareTo((BigDecimal)sanGeldVorjahr, (BigDecimal)BigDecimal.ZERO) < 0 ? sanGeldVorjahr : BigDecimal.ZERO, this.mSOCTypeBeanForReport);
                        }
                        if (BigDecimalMapper.compareTo((BigDecimal)sanGeldVorjahr, (BigDecimal)BigDecimal.ZERO) > 0) {
                            tempPaymentList.add(new PaymentCompRecipientBean(zVKRecipientTP.getRecipient(), tempOidCompanyAccount, stdModeOfPayment, stdTypeOfBankTransfer, tempAccountNumber, tempIban, tempReasonForTransferVorjahr, tempBankCodeNumber, tempBicCode, tempBankDescription, stdZVKDescription, stdZVKAddress, stdIdentNumber, sanGeldVorjahr, this.mIsConsolidation ? "" : this.mSOCTypeBeanForReport.getOidPlant(), this.mSOCTypeBeanForReport.getOidPCompany()));
                            this.addZVKAvisReportBean(oidRecipient + tempReasonForTransferVorjahr, BigDecimal.ZERO, sanGeldVorjahr, this.mSOCTypeBeanForReport);
                        }
                        this.mPaymentHashMap.put(tempOidCompanyAccount, tempPaymentList);
                    }
                    if (BigDecimalMapper.isZero((BigDecimal)tempAmount)) {
                        stdAmountAktJahr = stdAmountAktJahr.add(sanGeldAktJahr);
                        stdAmountVorjahr = stdAmountVorjahr.add(sanGeldVorjahr);
                    }
                    tempAmount = BigDecimal.ZERO;
                    if (bankAccount3 != null && !BigDecimalMapper.isZero((BigDecimal)zusatzbeitragAktJahr.add(zusatzbeitragVorjahr)) && (bank3 = bankAccount3.getBank()) != null) {
                        tempAccountNumber = bankAccount3.getAccountNumber();
                        tempIban = bankAccount3.getIban();
                        tempReasonForTransferAktJahr = StringMapper.isNullString((String)bankAccount3.getReasonForTransfer()) ? stdReasonForTransfer : bankAccount3.getReasonForTransfer();
                        tempReasonForTransferAktJahr = this.checkModifiyReasonForTransfer(tempReasonForTransferAktJahr, this.mForValidDate);
                        tempReasonForTransferVorjahr = StringMapper.isNullString((String)aPCZVKTP.getReasonOfTransferPreviousYear3()) ? stdReasonForTransfer : aPCZVKTP.getReasonOfTransferPreviousYear3();
                        tempReasonForTransferVorjahr = this.checkModifiyReasonForTransfer(tempReasonForTransferVorjahr, DateHelper.addMonths((Date)this.mForValidDate, (int)-1));
                        tempBankCodeNumber = bank3.getBankTP(this.mForEffectiveDate, this.mForValidDate).getBankCodeNumber();
                        tempBankDescription = bank3.getBankTP(this.mForEffectiveDate, this.mForValidDate).getShortDescription();
                        tempBicCode = bank3.getBankTP(this.mForEffectiveDate, this.mForValidDate).getBicCode();
                        tempAmount = zusatzbeitragAktJahr.add(zusatzbeitragVorjahr);
                        tempOidCompanyAccount = companyAccount3 != null ? companyAccount3.getObjectid() : "";
                        tempPaymentList = this.mPaymentHashMap.get(tempOidCompanyAccount);
                        if (tempPaymentList == null) {
                            tempPaymentList = new LinkedList<PaymentCompRecipientBean>();
                        }
                        if (!BigDecimalMapper.isZero((BigDecimal)zusatzbeitragAktJahr)) {
                            tempPaymentList.add(new PaymentCompRecipientBean(zVKRecipientTP.getRecipient(), tempOidCompanyAccount, stdModeOfPayment, stdTypeOfBankTransfer, tempAccountNumber, tempIban, tempReasonForTransferAktJahr, tempBankCodeNumber, tempBicCode, tempBankDescription, stdZVKDescription, stdZVKAddress, stdIdentNumber, BigDecimalMapper.compareTo((BigDecimal)zusatzbeitragVorjahr, (BigDecimal)BigDecimal.ZERO) < 0 ? zusatzbeitragAktJahr.add(zusatzbeitragVorjahr) : zusatzbeitragAktJahr, this.mIsConsolidation ? "" : this.mSOCTypeBeanForReport.getOidPlant(), this.mSOCTypeBeanForReport.getOidPCompany()));
                            this.addZVKAvisReportBean(oidRecipient + tempReasonForTransferAktJahr, zusatzbeitragAktJahr, BigDecimalMapper.compareTo((BigDecimal)zusatzbeitragVorjahr, (BigDecimal)BigDecimal.ZERO) < 0 ? zusatzbeitragVorjahr : BigDecimal.ZERO, this.mSOCTypeBeanForReport);
                        }
                        if (BigDecimalMapper.compareTo((BigDecimal)zusatzbeitragVorjahr, (BigDecimal)BigDecimal.ZERO) > 0) {
                            tempPaymentList.add(new PaymentCompRecipientBean(zVKRecipientTP.getRecipient(), tempOidCompanyAccount, stdModeOfPayment, stdTypeOfBankTransfer, tempAccountNumber, tempIban, tempReasonForTransferVorjahr, tempBankCodeNumber, tempBicCode, tempBankDescription, stdZVKDescription, stdZVKAddress, stdIdentNumber, zusatzbeitragVorjahr, this.mIsConsolidation ? "" : this.mSOCTypeBeanForReport.getOidPlant(), this.mSOCTypeBeanForReport.getOidPCompany()));
                            this.addZVKAvisReportBean(oidRecipient + tempReasonForTransferVorjahr, BigDecimal.ZERO, zusatzbeitragVorjahr, this.mSOCTypeBeanForReport);
                        }
                        this.mPaymentHashMap.put(tempOidCompanyAccount, tempPaymentList);
                    }
                    if (BigDecimalMapper.isZero((BigDecimal)tempAmount)) {
                        stdAmountAktJahr = stdAmountAktJahr.add(zusatzbeitragAktJahr);
                        stdAmountVorjahr = stdAmountVorjahr.add(zusatzbeitragVorjahr);
                    }
                    if (!BigDecimalMapper.isZeroOrNull((BigDecimal)stdAmountAktJahr.add(stdAmountVorjahr)) && bankAccountStd != null) {
                        Bank bankStd = bankAccountStd.getBank();
                        if (bankStd != null) {
                            stdBankCodeNumber = bankStd.getBankTP(this.mForEffectiveDate, this.mForValidDate).getBankCodeNumber();
                            stdBicCode = bankStd.getBankTP(this.mForEffectiveDate, this.mForValidDate).getBicCode();
                            stdBankDescription = bankStd.getBankTP(this.mForEffectiveDate, this.mForValidDate).getShortDescription();
                        }
                        if ((tempPaymentList = this.mPaymentHashMap.get(stdOidCompanyAccount)) == null) {
                            tempPaymentList = new LinkedList<PaymentCompRecipientBean>();
                            tempPaymentList.add(new PaymentCompRecipientBean(zVKRecipientTP.getRecipient(), stdOidCompanyAccount, stdModeOfPayment, stdTypeOfBankTransfer, stdAccountNumber, stdIban, stdReasonForTransfer, stdBankCodeNumber, stdBicCode, stdBankDescription, stdZVKDescription, stdZVKAddress, stdIdentNumber, stdAmountAktJahr.add(stdAmountVorjahr), this.mIsConsolidation ? "" : this.mSOCTypeBeanForReport.getOidPlant(), this.mSOCTypeBeanForReport.getOidPCompany()));
                            this.addZVKAvisReportBean(oidRecipient + stdReasonForTransfer, stdAmountAktJahr, stdAmountVorjahr, this.mSOCTypeBeanForReport);
                            this.mPaymentHashMap.put(stdOidCompanyAccount, tempPaymentList);
                        } else {
                            tempPaymentList.add(new PaymentCompRecipientBean(zVKRecipientTP.getRecipient(), stdOidCompanyAccount, stdModeOfPayment, stdTypeOfBankTransfer, stdAccountNumber, stdIban, stdReasonForTransfer, stdBankCodeNumber, stdBicCode, stdBankDescription, stdZVKDescription, stdZVKAddress, stdIdentNumber, stdAmountAktJahr.add(stdAmountVorjahr), this.mIsConsolidation ? "" : this.mSOCTypeBeanForReport.getOidPlant(), this.mSOCTypeBeanForReport.getOidPCompany()));
                            this.addZVKAvisReportBean(oidRecipient + stdReasonForTransfer, stdAmountAktJahr, stdAmountVorjahr, this.mSOCTypeBeanForReport);
                        }
                    }
                }
            } else {
                this.addNoAuszahlungsbetragOrCompHFErrorList(this.mPaymentCompHealthFundBean, this.umlage_an_bd.add(this.umlage_ag_bd).add(this.zus_umlage_bd));
            }
        }
    }

    private String checkModifiyReasonForTransfer(String reasonForTransfer, Date validDate) {
        String[] monat = DateMapper.toDDMMYYYYSlashSeparationString((Date)validDate).split("/");
        String jjjjmm = monat[2] + "-" + monat[1];
        String datum = "";
        int indexBegin = 0;
        int indexEnd = 0;
        int index = 0;
        if (reasonForTransfer.contains("#")) {
            for (int i = 0; i < reasonForTransfer.length(); ++i) {
                if (!StringMapper.equal((String)"#", (String)reasonForTransfer.substring(i, i + 1))) continue;
                if (index == 0) {
                    indexBegin = i;
                    ++index;
                    continue;
                }
                if (index != 1) continue;
                indexEnd = i;
                ++index;
            }
            if (index == 2) {
                datum = reasonForTransfer.substring(indexBegin + 1, indexEnd);
                datum = datum.replace("MM", jjjjmm.substring(5, 7));
                datum = datum.replace("YYYY", jjjjmm.substring(0, 4));
            }
        }
        if (StringMapper.isNullString((String)datum)) {
            return reasonForTransfer + "-" + jjjjmm;
        }
        return reasonForTransfer.substring(0, indexBegin) + datum;
    }

    private void makePayment() throws BusinessDomainException {
        if (!this.mPaymentHashMap.isEmpty()) {
            ZVKReportPayment zVKReportPayment = (ZVKReportPayment)UtilitiesManager.getBean((String)"zVKReportPayment", ZVKReportPayment.class);
            zVKReportPayment.setZVKAvisBeanHM(this.ZVKAvisBeanHM);
            zVKReportPayment.setForValidDate(this.mForValidDate);
            zVKReportPayment.setOidPCompany(this.mPCompanyForSettings.getObjectid());
            zVKReportPayment.setName(this.mNameForPayment);
            zVKReportPayment.setPaymentHashMap(this.mPaymentHashMap);
            zVKReportPayment.startWorking();
            this.ZVKAvisBeanHM = zVKReportPayment.getZVKAvisBeanHM();
        }
    }

    private void addNoAuszahlungsbetragOrCompHFErrorList(PaymentCompHealthFundBean paymentCompHealthFundBean, BigDecimal f_summe_zahlender_beitrag) {
        Object message = "";
        if (paymentCompHealthFundBean == null && f_summe_zahlender_beitrag == null) {
            message = "Ein Datensatz aus der Zuordnungstabelle Firma/Krankenkasse fehlt sowie der Auszahlungsbetrag";
        } else {
            if (paymentCompHealthFundBean == null) {
                message = "Zum Auszahlungsbetrag: " + f_summe_zahlender_beitrag + "fehlt der Datensatz aus der Zuordnungstabelle Firma/Krankenkasse.";
            }
            if (f_summe_zahlender_beitrag == null) {
                message = "Zur Beitragskontonummer: " + paymentCompHealthFundBean.getNameOdHealthFund() + "fehlt der Auszahlungsbetrag.";
            }
        }
        if (!StringMapper.isNullString((String)message)) {
            this.noAuszahlungsbetragOrCompHFErrorList.add((String)message);
        }
    }

    private String getStandardCompanyAccount() {
        try {
            PersistencyDataSet companyAccountDatas = this.daoCompanyaccount.getDataSet(null, Restrictions.eq((String)"oidpcompany", (String)this.mPCompanyForSettings.getObjectid()));
            while (companyAccountDatas.hasNext()) {
                CompanyaccountContainer companyAccountContainer = (CompanyaccountContainer)companyAccountDatas.getNext();
                if (companyAccountContainer == null || !this.isCompanyStandardAccount(companyAccountContainer.getObjectid())) continue;
                return companyAccountContainer.getObjectid();
            }
            return null;
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    private boolean isCompanyStandardAccount(String oidCompanyAccount) {
        boolean standardAccount = false;
        try {
            PersistencyDataSet companyAccounttpDatas = this.daoCompanyaccounttp.getDataSet(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidcompanyaccount", (String)oidCompanyAccount), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)this.mForEffectiveDate))), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mForEffectiveDate))), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)this.mForValidDate))), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getFirstDayOfMonth((Date)this.mForValidDate)))}));
            CompanyaccounttpContainer companyAccounttpContainer = (CompanyaccounttpContainer)companyAccounttpDatas.getNext();
            if (companyAccounttpContainer != null) {
                standardAccount = companyAccounttpContainer.standardaccount;
            }
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        return standardAccount;
    }

    private IEmployeePersistencyManager getIEmployeePM() {
        return (IEmployeePersistencyManager)UtilitiesManager.getBean((String)"employeePersistencyManager", IEmployeePersistencyManager.class);
    }

    public List<StatementOfContributionZVKAvisReportBean> getZVKAvisBeanList() {
        LinkedList<StatementOfContributionZVKAvisReportBean> ZVKAvisBeanList = new LinkedList<StatementOfContributionZVKAvisReportBean>();
        for (Map.Entry<String, StatementOfContributionZVKAvisReportBean> entry : this.ZVKAvisBeanHM.entrySet()) {
            ZVKAvisBeanList.add(entry.getValue());
        }
        Collections.sort(ZVKAvisBeanList, new ZVKAvisComparator());
        return ZVKAvisBeanList;
    }

    public class ZVKAvisComparator
    implements Comparator<StatementOfContributionZVKAvisReportBean> {
        @Override
        public int compare(StatementOfContributionZVKAvisReportBean o1, StatementOfContributionZVKAvisReportBean o2) {
            String string1 = o1.getRecipient_bezeichnung();
            String string2 = o2.getRecipient_bezeichnung();
            int comp = 0;
            try {
                comp = StringMapper.compareTo((String)string1, (String)string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return comp;
        }
    }
}

