/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.pueg.receive;

import com.varial.base.exception.BusinessDomainException;
import com.varial.personnel.domain.deuv.PerfidiaDataType;
import com.varial.personnel.domain.deuvmessaging.BasicReceive;
import com.varial.personnel.domain.deuvmessaging.perfidia.PerfidiaHelper;
import com.varial.personnel.domain.global.deuv.recipient.DEUVRecipient;
import com.varial.personnel.domain.global.deuv.sender.DEUVSender;
import com.varial.personnel.domain.global.healthfund.TypeOfHealthFundEnum;
import com.varial.personnel.domain.pueg.IPuegAntwort;
import com.varial.personnel.domain.pueg.puegantwort.PuegAntwort;
import com.varial.personnel.domain.pueg.puegantwort.PuegKind;
import com.varial.personnel.domain.pueg.puegantwortkeundigung.PuegAntwortKuendigung;
import com.varial.personnel.framework.PFileHelper;
import com.varial.serverbase.mapper.StringMapper;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class PuegReceive
extends BasicReceive<IPuegAntwort> {
    private static final String[] FILENAMEFILTER = new String[]{"ERPA0", "TRPA0"};
    private static String DXPA = "DXPA";
    private static String DXKA = "DXKA";
    private static String DSID = "DSID";
    private static String DSIDUR = "DSIDUR";
    private static String DATUMANFRAGE = "DATUMANFRAGE";
    private static String DATUMANTWORT = "DATUMANTWORT";
    private static String KDNR = "KDNR";
    private static String ZUORDNUNG = "ZUORDNUNG";
    private static String AZVU = "AZVU";
    private static String IDNR = "IDNR";
    private static String ANZHINWEIS = "ANZHINWEIS";
    private static String REST = "REST";
    protected static final Pattern SVTOAG_DXSV = Pattern.compile("DXSV010000(?<VM>APR|RPA).{2}(?<ABSENDER>.{8})(?<EMPFAENGER>.{8})(?<DATUM>\\d{17})(?<DATEINUMMER>\\d{6})");
    private static final Pattern DXPA_DXKA = Pattern.compile("(?<KENNUNG>DXPA|DXKA)010000.(?<DSID>.{36})(?<DSIDUR>.{36})(?<DATUMANFRAGE>\\d{17})(?<DATUMANTWORT>\\d{17})(?<KDNR>\\d{10})(?<ZUORDNUNG>.{40})(?<AZVU>.{40})(?<IDNR>\\d{11})(?<ANZHINWEIS>\\d{3})(?<REST>.*)");
    private static final int DXPA_DXKA_MIN_LENGTH = 221;

    public PuegReceive(DEUVSender deuvSender) {
        super(deuvSender);
    }

    @Override
    public FilenameFilter getFilenameFilter() {
        return PerfidiaHelper.getFilenameFilter((String[])FILENAMEFILTER);
    }

    @Override
    public List<File> getFilesForProcessing() throws BusinessDomainException {
        this.initFiles(TypeOfHealthFundEnum.TOHF_RENTENVERSICHERUNG);
        return this.getFileList();
    }

    @Override
    protected boolean isFileValid(File file, DEUVRecipient deuvRecipient) throws BusinessDomainException {
        PFileHelper.checkFile(file, "R\u00fcckmeldung PUEG");
        LinkedList<String> records = PFileHelper.getFileLines(file, ISO_8859_1);
        Matcher matcherVosz = SVTOAG_DXSV.matcher((CharSequence)records.getFirst());
        return matcherVosz.matches();
    }

    @Override
    public String getProcedureName() {
        return "PUEG-Meldeverfahren";
    }

    @Override
    public String getFileDescription() {
        return "R\u00fcckmeldung(en) PUEG";
    }

    @Override
    public String getActionName() {
        return "importieren";
    }

    public void readPueg() throws BusinessDomainException {
        this.initFiles(TypeOfHealthFundEnum.TOHF_RENTENVERSICHERUNG);
        for (File file : this.getFileList()) {
            this.readPuegReceives(file);
        }
    }

    private void readPuegReceives(File input) throws BusinessDomainException {
        this.mCurrent = input;
        LinkedList<String> records = PFileHelper.getFileLines(input, ISO_8859_1);
        Matcher matcherVosz = SVTOAG_DXSV.matcher((CharSequence)records.getFirst());
        if (matcherVosz.matches()) {
            records.pollFirst();
            while (!records.isEmpty()) {
                this.readPueg((String)records.pollFirst());
            }
        } else {
            throw new IllegalStateException(input.getPath() + " don't match: " + matcherVosz);
        }
        int subFolderNr = PerfidiaHelper.getPerfidiaSubFolderNumber((DEUVSender)this.mDeuvSender, (TypeOfHealthFundEnum)TypeOfHealthFundEnum.TOHF_RENTENVERSICHERUNG);
        this.mAcknowledgement.addProcessedFile(input, PerfidiaDataType.RPA, subFolderNr, this.getFileNumberFromFileName(this.mCurrent.getName()));
        this.mPerfidiaResult.addReceivedFile(input);
    }

    private void readPueg(String input) throws BusinessDomainException {
        Matcher matcher = this.checkInputGetMatcher(input, 221, DXPA_DXKA);
        if (input.startsWith(DXPA)) {
            PuegAntwort antwort = this.createPuegAntwort(matcher);
            this.mImporteds.add(antwort);
        } else if (input.startsWith(DXKA)) {
            PuegAntwortKuendigung antwortkuendigung = this.createPuegAntwortKuendigung(matcher);
            this.mImporteds.add(antwortkuendigung);
        }
    }

    private PuegAntwort createPuegAntwort(Matcher matcher) {
        PuegAntwort antwort;
        String rest = this.fillBasicData((IPuegAntwort)(antwort = new PuegAntwort()), matcher);
        String elterneigenschaftab = rest.substring(0, 8);
        antwort.setElterneigenschaftab(StringMapper.isNullString((String)elterneigenschaftab) ? null : this.asDate(elterneigenschaftab));
        rest = rest.substring(8);
        int anzKinder = this.asInteger(rest.substring(0, 2));
        rest = rest.substring(2);
        PuegKind[] kinder = new PuegKind[anzKinder];
        for (int i = 0; i < anzKinder; ++i) {
            PuegKind kind;
            int anzahl = this.asInteger(rest.substring(0, 2).trim());
            Date abDatum = this.asDate(rest.substring(2, 10));
            kinder[i] = kind = new PuegKind(antwort, anzahl, abDatum);
            rest = rest.substring(10);
        }
        antwort.setPuegKinder(kinder);
        return antwort;
    }

    private PuegAntwortKuendigung createPuegAntwortKuendigung(Matcher matcher) {
        PuegAntwortKuendigung antwortkuend = new PuegAntwortKuendigung();
        this.fillBasicData((IPuegAntwort)antwortkuend, matcher);
        return antwortkuend;
    }

    private String fillBasicData(IPuegAntwort antwort, Matcher matcher) {
        antwort.setMessageid(this.asString(matcher.group(DSID)));
        antwort.setMessageidref(this.asString(matcher.group(DSIDUR)));
        antwort.setDatumanfrage(this.asString(matcher.group(DATUMANFRAGE)));
        antwort.setDatumantwort(this.asString(matcher.group(DATUMANTWORT)));
        antwort.setKundennummer(this.asString(matcher.group(KDNR)));
        antwort.setZuordnungsmerkmal(this.asString(matcher.group(ZUORDNUNG)));
        antwort.setOrdnungsbegriff(this.asString(matcher.group(AZVU)));
        antwort.setIdnr(this.asString(matcher.group(IDNR)));
        int anzHinweis = this.asInteger(matcher.group(ANZHINWEIS));
        antwort.setHinweiscode(this.getHinweiscode(matcher.group(REST), anzHinweis));
        return matcher.group(REST).substring(anzHinweis * 11);
    }

    private String getHinweiscode(String input, int anzHinweis) {
        ArrayList<String> hinweiscodes = new ArrayList<String>();
        for (int i = 0; i < anzHinweis; ++i) {
            hinweiscodes.add(input.substring(0, 11).trim());
            input = input.substring(11);
        }
        return hinweiscodes.stream().collect(Collectors.joining(", "));
    }
}

