/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.global.socialinsurance;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.global.socialinsurance.SocialInsurance;
import com.varial.personnel.domain.global.socialinsurance.SocialInsurancePersistencyManager;
import com.varial.personnel.domain.global.socialinsurance.SocialInsuranceTPPersistencyManager;
import com.varial.personnel.domain.global.socialinsurance.global.SocialInsuranceGlobal;
import com.varial.personnel.domain.global.socialinsurance.lawarea.SocialInsuranceLawArea;
import com.varial.personnel.domain.global.socialinsurance.mapper.SocialInsuranceExceptionMapper;
import com.varial.personnel.framework.PersonnelTimedPersistenceObject;
import com.varial.personnel.framework.mapper.FrameWorkExceptionMapper;
import com.varial.personnel.framework.personnelbasic.PersonnelBasic;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;

public class SocialInsuranceTP
extends PersonnelTimedPersistenceObject {
    private boolean mIsCreate = false;
    private SocialInsuranceGlobal mGlobal;
    private SocialInsuranceLawArea mLawAreaWest;
    private SocialInsuranceLawArea mLawAreaEast;
    private static final int PRIORITY = 1;

    public SocialInsuranceTP() {
        super(1);
    }

    private SocialInsuranceTP(String objectid) {
        super(1, objectid);
    }

    public SocialInsuranceTP(String objectid, int version) {
        super(1, objectid, version);
    }

    protected SocialInsuranceTP(boolean readOnly) {
        super(1, readOnly);
    }

    public static SocialInsuranceTP getSocialInsuranceTP(String objectid) {
        return new SocialInsuranceTP(objectid);
    }

    protected void load() {
        SocialInsuranceTPPersistencyManager.load((SocialInsuranceTP)this);
    }

    protected void saveImpl() {
        SocialInsuranceTPPersistencyManager.save((SocialInsuranceTP)this);
    }

    protected void deleteImpl() {
        SocialInsuranceTPPersistencyManager.delete((SocialInsuranceTP)this);
    }

    @Override
    public void lastExecuteImpl() throws BusinessDomainException {
        this.saveImpl();
    }

    public String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    @Override
    public PersonnelTimedPersistenceObject createNew() {
        SocialInsuranceTP si = new SocialInsuranceTP();
        si.mEffectiveFrom = this.mEffectiveFrom;
        si.mEffectiveUntil = this.mEffectiveUntil;
        si.mValidFrom = this.mValidFrom;
        si.mValidUntil = this.mValidUntil;
        si.mGlobal = this.mGlobal;
        si.mLawAreaWest = this.mLawAreaWest;
        si.mLawAreaEast = this.mLawAreaEast;
        return si;
    }

    public String getDomainKey() {
        return "SocialInsurance / " + DateMapper.toString((Date)this.mEffectiveFrom) + " / " + DateMapper.toString((Date)this.mValidFrom);
    }

    @Override
    public void checkAttributes() throws BusinessDomainException {
        this.checkDates();
        this.checkValidFrom();
        this.checkGlobal();
        this.checkLawAreaWest();
        this.checkLawAreaEast();
    }

    @Override
    public void checkDates() throws BusinessDomainException {
        super.checkDates();
        PersonnelBasic pb = PersonnelBasic.getPersonnelBasic();
        if (DateHelper.before((Date)this.getValidFrom(), (Date)pb.getSystemStart())) {
            throw FrameWorkExceptionMapper.makeStartHistoryBeforeSystemStartDomainException();
        }
        if (this.getIsCreate()) {
            this.setEffectiveFrom(pb.getSystemStart());
        }
    }

    public void checkValidFrom() throws BusinessDomainException {
        Date dateOfcomparison = DateHelper.today();
        dateOfcomparison = new VDate(dateOfcomparison).addYears(-1).getDate();
        dateOfcomparison = DateHelper.getFirstDayOfYear((Date)dateOfcomparison);
        if (DateHelper.before((Date)this.getValidFrom(), (Date)dateOfcomparison)) {
            throw FrameWorkExceptionMapper.makeThisValidFromNotAllowdDomainException();
        }
    }

    private void checkGlobal() throws BusinessDomainException {
        block18: {
            if (this.getGlobal() == null) {
                throw SocialInsuranceExceptionMapper.makeGlobalMissingDomainException();
            }
            if (BigDecimalMapper.isZero((BigDecimal)this.getGlobal().getAverageGeneralContributionRateForAllowanceInPHI())) {
                throw SocialInsuranceExceptionMapper.makeAverageGeneralContributionRateAllowanceInPrivateHIMissingDomainException();
            }
            if (BigDecimalMapper.isZero((BigDecimal)this.getGlobal().getTotalContributionRateForPensionersInsurance())) {
                throw SocialInsuranceExceptionMapper.makeTotalContributionRatePIMissingDomainException();
            }
            if (BigDecimalMapper.isZero((BigDecimal)this.getGlobal().getTotalContributionRateForUnemploymentInsurance())) {
                throw SocialInsuranceExceptionMapper.makeTotalContributionRateUIMissingDomainException();
            }
            if (BigDecimalMapper.isZero((BigDecimal)this.getGlobal().getTotalContributionRateForNursingInsurance())) {
                throw SocialInsuranceExceptionMapper.makeTotalContributionRateNIMissingDomainException();
            }
            if (BigDecimalMapper.isZero((BigDecimal)this.getGlobal().getTotalContributionRateForMinersPensionersInsurance())) {
                throw SocialInsuranceExceptionMapper.makeTotalContributionRateMPIMissingDomainException();
            }
            if (BigDecimalMapper.isZero((BigDecimal)this.getGlobal().getBlanketContributionRateForHealthInsuranceConcerningLowIncomeEarners())) {
                throw SocialInsuranceExceptionMapper.makeBlanketContributionRateHIConcerningLowIncomeEarnersMissingDomainException();
            }
            if (BigDecimalMapper.isZero((BigDecimal)this.getGlobal().getBlanketContributionRateForPensionersInsuranceConcerningLowIncomeEarners())) {
                throw SocialInsuranceExceptionMapper.makeBlanketContributionRatePIConcerningLowIncomeEarnersMissingDomainException();
            }
            if (BigDecimalMapper.isZero((BigDecimal)this.getGlobal().getInsignificantMaximumLimitForLowIncomeEarnersAmount())) {
                throw SocialInsuranceExceptionMapper.makeInsignificantMaxLimitLowIncomeEarnersAmountMissingDomainException();
            }
            if (BigDecimalMapper.isZero((BigDecimal)this.getGlobal().getMinimumCalculationBasisForLowIncomeEarnersAmount())) {
                throw SocialInsuranceExceptionMapper.makeMinCalculationBasisLowIncomeEarnersAmountMissingDomainException();
            }
            SocialInsurance si = SocialInsurancePersistencyManager.getInstance();
            VDate validFrom = new VDate(this.getValidFrom());
            try {
                si.getSocialInsurance(this.getEffectiveFrom(), new VDate(validFrom.getYear() - 1, 2, 1).getDate());
                if (DateHelper.compare((Date)this.getValidFrom(), (Date)DateHelper.getFirstDayOfYear((Date)this.getValidFrom())) != 0) {
                    si.getSocialInsurance(this.getEffectiveFrom(), new VDate(validFrom.getYear(), 0, 1).getDate());
                }
            }
            catch (BusinessDomainException e) {
                if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) break block18;
                throw e;
            }
        }
        if (BigDecimalMapper.compareTo((BigDecimal)this.mGlobal.getTotalContributionRateForPensionersInsurance(), (BigDecimal)this.mGlobal.getTotalContributionRateForUnemploymentInsurance()) != 1) {
            throw SocialInsuranceExceptionMapper.makeTotalContributionRateUIFalseDomainException();
        }
        if (BigDecimalMapper.compareTo((BigDecimal)this.mGlobal.getTotalContributionRateForPensionersInsurance(), (BigDecimal)this.mGlobal.getTotalContributionRateForNursingInsurance()) != 1) {
            throw SocialInsuranceExceptionMapper.makeTotalContributionRateNIFalseDomainException();
        }
        if (BigDecimalMapper.compareTo((BigDecimal)this.mGlobal.getTotalContributionRateForPensionersInsurance(), (BigDecimal)this.mGlobal.getBlanketContributionRateForHealthInsuranceConcerningLowIncomeEarners()) != 1) {
            throw SocialInsuranceExceptionMapper.makeBlanketContributionRateHIConcerningLowIncomeEarnersFalseDomainException();
        }
        if (BigDecimalMapper.compareTo((BigDecimal)this.mGlobal.getTotalContributionRateForPensionersInsurance(), (BigDecimal)this.mGlobal.getBlanketContributionRateForPensionersInsuranceConcerningLowIncomeEarners()) != 1) {
            throw SocialInsuranceExceptionMapper.makeBlanketContributionRatePIConcerningLowIncomeEarnersFalseDomainException();
        }
        if (BigDecimalMapper.compareTo((BigDecimal)this.mGlobal.getTotalContributionRateForMinersPensionersInsurance(), (BigDecimal)this.mGlobal.getTotalContributionRateForPensionersInsurance()) != 1) {
            throw SocialInsuranceExceptionMapper.makeTotalContributionRateMPIFalseDomainException();
        }
    }

    private void checkLawAreaEast() throws BusinessDomainException {
        if (this.getLawAreaEast() == null) {
            throw SocialInsuranceExceptionMapper.makeLawAreaEastMissingDomainException();
        }
        this.checkLawArea(this.getLawAreaEast(), "OST");
    }

    private void checkLawAreaWest() throws BusinessDomainException {
        if (this.getLawAreaWest() == null) {
            throw SocialInsuranceExceptionMapper.makeLawAreaWestMissingDomainException();
        }
        this.checkLawArea(this.getLawAreaWest(), "West");
    }

    private void checkLawArea(SocialInsuranceLawArea siLawArea, String lawArea) throws BusinessDomainException {
        if (BigDecimalMapper.isZero((BigDecimal)siLawArea.getBasicAmountForHealthAndNursingInsurance())) {
            throw SocialInsuranceExceptionMapper.makeBasicAmountHIandNIMissingDomainException((String)lawArea);
        }
        if (BigDecimalMapper.isZero((BigDecimal)siLawArea.getBasicAmountForPensionersAndUnemploymentInsurance())) {
            throw SocialInsuranceExceptionMapper.makeBasicAmountPIandUIMissingDomainException((String)lawArea);
        }
        if (BigDecimalMapper.isZero((BigDecimal)siLawArea.getMaximumAssessableEarningsForHealthAndNursingInsurance())) {
            throw SocialInsuranceExceptionMapper.makeMaxAssessableEarningsHIandNIMissingDomainException((String)lawArea);
        }
        if (BigDecimalMapper.isZero((BigDecimal)siLawArea.getMaximumAssessableEarningsForPensionersAndUnemploymentInsurance())) {
            throw SocialInsuranceExceptionMapper.makeMaxAssessableEarningsPIandUIMissingDomainException((String)lawArea);
        }
        if (BigDecimalMapper.isZero((BigDecimal)siLawArea.getMaximumAssessableEarningsForMinersPensionersInsurance())) {
            throw SocialInsuranceExceptionMapper.makeMaxAssessableEarningsMPIMissingDomainException((String)lawArea);
        }
        if (BigDecimalMapper.isZero((BigDecimal)siLawArea.getMinimumCalculationBasisForContributionOfHealthAndNursingInsurance())) {
            throw SocialInsuranceExceptionMapper.makeMinCalculationBasisContributionOfHIandNIMissingDomainException((String)lawArea);
        }
        if (BigDecimalMapper.isZero((BigDecimal)siLawArea.getMinimumCalculationBasisForContributionOfPensionersInsurance())) {
            throw SocialInsuranceExceptionMapper.makeMinCalculationBasisContributionOfPIMissingDomainException((String)lawArea);
        }
        if (BigDecimalMapper.isZero((BigDecimal)siLawArea.getCalculationBasisForContributionOfHealthAndNursingInsurance())) {
            throw SocialInsuranceExceptionMapper.makeCalculationBasisContributionOfHIandNIMissingDomainException((String)lawArea);
        }
        if (BigDecimalMapper.isZero((BigDecimal)siLawArea.getCalculationBasisForContributionOfPensionersAndUnemploymentInsurance())) {
            throw SocialInsuranceExceptionMapper.makeCalculationBasisContributionOfPIandUIMissingDomainException((String)lawArea);
        }
        if (BigDecimalMapper.isZero((BigDecimal)siLawArea.getCalculationBasisForContributionOfUnemploymentInsurance())) {
            throw SocialInsuranceExceptionMapper.makeCalculationBasisContributionOfUIMissingDomainException((String)lawArea);
        }
        if (BigDecimalMapper.isZero((BigDecimal)siLawArea.getGeneralMarginalValueOfLowIncomeEarners())) {
            throw SocialInsuranceExceptionMapper.makeGeneralMarginalValueOfLowIncomeEarnersMissingDomainException((String)lawArea);
        }
        if (BigDecimalMapper.isZero((BigDecimal)siLawArea.getMinimumIncomeLimitForContributionOfHealtAndNursingInsuranceConcerningRetirementIncome())) {
            throw SocialInsuranceExceptionMapper.makeMinIncomeLimitContributionOfHIandNIConcerningRetirementIncomeMissingDomainException((String)lawArea);
        }
        if (BigDecimalMapper.isZero((BigDecimal)siLawArea.getAnnualEarningsLimitHI())) {
            throw SocialInsuranceExceptionMapper.makeAnnualEarningsLimitHIMissingDomainException((String)lawArea);
        }
        if (BigDecimalMapper.compareTo((BigDecimal)this.mLawAreaWest.getMaximumAssessableEarningsForPensionersAndUnemploymentInsurance(), (BigDecimal)this.mLawAreaWest.getMaximumAssessableEarningsForHealthAndNursingInsurance()) != 1) {
            throw SocialInsuranceExceptionMapper.makeMaxAssessableEarningsHIandNIFalseDomainException((String)lawArea);
        }
        BigDecimal compValue5 = siLawArea.getBasicAmountForHealthAndNursingInsurance();
        compValue5 = compValue5.divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_DOWN).multiply(BigDecimal.valueOf(5L));
        if (BigDecimalMapper.compareTo((BigDecimal)siLawArea.getMinimumIncomeLimitForContributionOfHealtAndNursingInsuranceConcerningRetirementIncome(), (BigDecimal)compValue5) != 0) {
            throw SocialInsuranceExceptionMapper.makeMinIncomeLimitContributionOfHIandNIConcerningRetirementIncomeFalseDomainException((String)lawArea);
        }
        BigDecimal compValue20 = siLawArea.getBasicAmountForHealthAndNursingInsurance();
        compValue20 = compValue20.divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_DOWN).multiply(BigDecimal.valueOf(20L));
        if (BigDecimalMapper.compareTo((BigDecimal)siLawArea.getCalculationBasisForContributionOfHealthAndNursingInsurance(), (BigDecimal)compValue20) != 0) {
            throw SocialInsuranceExceptionMapper.makeCalculationBasisContributionOfHIandNIFalseDomainException((String)lawArea);
        }
        compValue20 = siLawArea.getBasicAmountForPensionersAndUnemploymentInsurance();
        compValue20 = compValue20.divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_DOWN).multiply(BigDecimal.valueOf(20L));
        if (BigDecimalMapper.compareTo((BigDecimal)siLawArea.getCalculationBasisForContributionOfPensionersAndUnemploymentInsurance(), (BigDecimal)compValue20) != 0) {
            throw SocialInsuranceExceptionMapper.makeCalculationBasisContributionOfPIandUIFalseDomainException((String)lawArea);
        }
        BigDecimal compValue80 = siLawArea.getBasicAmountForPensionersAndUnemploymentInsurance();
        compValue80 = compValue80.divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_DOWN).multiply(BigDecimal.valueOf(80L));
        if (BigDecimalMapper.compareTo((BigDecimal)siLawArea.getMinimumCalculationBasisForContributionOfPensionersInsurance(), (BigDecimal)compValue80) != 0) {
            throw SocialInsuranceExceptionMapper.makeMinCalculationBasisContributionOfPIFalseDomainException((String)lawArea);
        }
    }

    public void setData(Date effectiveFrom, Date effectiveUntil, Date validFrom, Date validUntil, SocialInsuranceGlobal globalValues, SocialInsuranceLawArea westValues, SocialInsuranceLawArea eastValues) {
        this.mEffectiveFrom = effectiveFrom;
        this.mEffectiveUntil = effectiveUntil;
        this.mValidFrom = validFrom;
        this.mValidUntil = validUntil;
        this.mGlobal = globalValues;
        this.mLawAreaWest = westValues;
        this.mLawAreaEast = eastValues;
    }

    public boolean getIsCreate() {
        return this.mIsCreate;
    }

    public void setIsCreate(boolean isCreate) {
        this.mIsCreate = isCreate;
    }

    public SocialInsuranceGlobal getGlobal() {
        this.requireLoaded();
        return this.mGlobal;
    }

    public SocialInsuranceLawArea getLawAreaWest() {
        this.requireLoaded();
        return this.mLawAreaWest;
    }

    public SocialInsuranceLawArea getLawAreaEast() {
        this.requireLoaded();
        return this.mLawAreaEast;
    }

    public void setGlobal(SocialInsuranceGlobal globalValues) {
        this.mGlobal = globalValues;
    }

    public void setLawAreaWest(SocialInsuranceLawArea westValues) {
        this.mLawAreaWest = westValues;
    }

    public void setLawAreaEast(SocialInsuranceLawArea eastValues) {
        this.mLawAreaEast = eastValues;
    }

    public void compareToOld(SocialInsuranceTP old) {
        if (old == null) {
            return;
        }
        this.setValuateNeeded(true);
    }

    @Override
    public String getRootDomainKey() {
        return "Globale Sozialversicherung";
    }

    @Override
    public String getNaturalLanguageClassName() {
        return "Globale Sozialversicherung";
    }

    public void calculationOfRemainingFields() {
        BigDecimal bd;
        BigDecimal ZERO = BigDecimalMapper.ZERO;
        BigDecimal ZWEI = BigDecimal.valueOf(2L);
        Date marginalDate = new VDate(2009, 0, 1).getDate();
        SocialInsuranceGlobal globalValues = this.getGlobal();
        globalValues.setEESurchargeHI(globalValues.getSurchargeHI());
        globalValues.setERSurchargeHI(ZERO);
        if (DateHelper.before((Date)this.getValidFrom(), (Date)marginalDate)) {
            globalValues.setEEaverageGeneralContributionRateForAllowanceInPHI(globalValues.getAverageGeneralContributionRateForAllowanceInPHI().divide(ZWEI, 2, RoundingMode.HALF_UP));
            globalValues.setERaverageGeneralContributionRateForAllowanceInPHI(globalValues.getAverageGeneralContributionRateForAllowanceInPHI().divide(ZWEI, 2, RoundingMode.HALF_UP));
        } else {
            bd = globalValues.getAverageGeneralContributionRateForAllowanceInPHI().subtract(globalValues.getSurchargeHI());
            globalValues.setERaverageGeneralContributionRateForAllowanceInPHI(bd.divide(ZWEI, 2, RoundingMode.HALF_UP));
            globalValues.setEEaverageGeneralContributionRateForAllowanceInPHI(globalValues.getERaverageGeneralContributionRateForAllowanceInPHI().add(globalValues.getSurchargeHI()));
        }
        if (DateHelper.before((Date)this.getValidFrom(), (Date)marginalDate)) {
            globalValues.setEEaverageReducedContributionRateForAllowanceInPHI(globalValues.getAverageReducedContributionRateForAllowanceInPHI().divide(ZWEI, 2, RoundingMode.HALF_UP));
            globalValues.setERaverageReducedContributionRateForAllowanceInPHI(globalValues.getAverageReducedContributionRateForAllowanceInPHI().divide(ZWEI, 2, RoundingMode.HALF_UP));
        } else {
            bd = globalValues.getAverageReducedContributionRateForAllowanceInPHI().subtract(globalValues.getSurchargeHI());
            globalValues.setERaverageReducedContributionRateForAllowanceInPHI(bd.divide(ZWEI, 2, RoundingMode.HALF_UP));
            globalValues.setEEaverageReducedContributionRateForAllowanceInPHI(globalValues.getERaverageReducedContributionRateForAllowanceInPHI().add(globalValues.getSurchargeHI()));
        }
        globalValues.setEEtotalContributionRateForPensionersInsurance(globalValues.getTotalContributionRateForPensionersInsurance().divide(ZWEI, 2, RoundingMode.HALF_UP));
        globalValues.setERtotalContributionRateForPI(globalValues.getTotalContributionRateForPensionersInsurance().divide(ZWEI, 2, RoundingMode.HALF_UP));
        globalValues.setEEtotalContributionRateForUI(globalValues.getTotalContributionRateForUnemploymentInsurance().divide(ZWEI, 2, RoundingMode.HALF_UP));
        globalValues.setERtotalContributionRateForUI(globalValues.getTotalContributionRateForUnemploymentInsurance().divide(ZWEI, 2, RoundingMode.HALF_UP));
        globalValues.setEEtotalContributionRateForNI(globalValues.getTotalContributionRateForNursingInsurance().divide(ZWEI, 3, RoundingMode.HALF_UP));
        globalValues.setERtotalContributionRateForNI(globalValues.getTotalContributionRateForNursingInsurance().divide(ZWEI, 3, RoundingMode.HALF_UP));
        globalValues.setEEtotalContributionRateForMinersPI(globalValues.getEEtotalContributionRateForPI());
        globalValues.setERtotalContributionRateForMinersPI(globalValues.getTotalContributionRateForMinersPensionersInsurance().subtract(globalValues.getEEtotalContributionRateForMinersPI()));
        globalValues.setEEblanketContributionRateForHIConcerningLowIncomeEarners(ZERO);
        globalValues.setERblanketContributionRateForHIConcerningLowIncomeEarners(globalValues.getBlanketContributionRateForHealthInsuranceConcerningLowIncomeEarners());
        globalValues.setEEblanketContributionRateForPIConcerningLowIncomeEarners(ZERO);
        globalValues.setERblanketContributionRateForPIConcerningLowIncomeEarners(globalValues.getBlanketContributionRateForPensionersInsuranceConcerningLowIncomeEarners());
        globalValues.setEESurchargeNI(globalValues.getSurchargeNI());
        globalValues.setERSurchargeNI(ZERO);
        globalValues.setEESurchargeUI(ZERO);
        globalValues.setERSurchargeUI(ZERO);
        globalValues.setEESurchargePI(ZERO);
        globalValues.setERSurchargePI(ZERO);
        marginalDate = new VDate(2019, 0, 1).getDate();
        if (DateHelper.before((Date)this.getValidFrom(), (Date)marginalDate)) {
            globalValues.setAdditionalDuesHIEE(globalValues.getAdditionalDuesHI());
            globalValues.setAdditionalDuesHIER(ZERO);
        } else {
            globalValues.setAdditionalDuesHIEE(globalValues.getAdditionalDuesHI().divide(ZWEI, 2, RoundingMode.HALF_UP));
            globalValues.setAdditionalDuesHIER(globalValues.getAdditionalDuesHIEE());
        }
        BigDecimal ZWANZIG = BigDecimal.valueOf(20L);
        BigDecimal ACHTZIG = BigDecimal.valueOf(80L);
        BigDecimal HUNDERT = BigDecimal.valueOf(100L);
        SocialInsuranceLawArea westValues = this.getLawAreaWest();
        westValues.setMinimumCalculationBasisForContributionOfHealthAndNursingInsurance(westValues.getBasicAmountForHealthAndNursingInsurance().multiply(ZWANZIG).divide(HUNDERT, 2, RoundingMode.HALF_UP));
        westValues.setMinimumCalculationBasisForContributionOfPensionersInsurance(westValues.getBasicAmountForPensionersAndUnemploymentInsurance().multiply(ACHTZIG).divide(HUNDERT, 2, RoundingMode.HALF_UP));
        westValues.setCalculationBasisForContributionOfHealthAndNursingInsurance(westValues.getBasicAmountForHealthAndNursingInsurance().multiply(ZWANZIG).divide(HUNDERT, 2, RoundingMode.HALF_UP));
        westValues.setCalculationBasisForContributionOfPensionersAndUnemploymentInsurance(westValues.getBasicAmountForPensionersAndUnemploymentInsurance().multiply(ZWANZIG).divide(HUNDERT, 2, RoundingMode.HALF_UP));
        westValues.setCalculationBasisForContributionOfUnemploymentInsurance(westValues.getBasicAmountForPensionersAndUnemploymentInsurance());
        westValues.setMinimumIncomeLimitForContributionOfHealtAndNursingInsuranceConcerningRetirementIncome(westValues.getBasicAmountForHealthAndNursingInsurance().divide(ZWANZIG, 2, RoundingMode.HALF_UP));
        SocialInsuranceLawArea eastValues = this.getLawAreaEast();
        eastValues.setMinimumCalculationBasisForContributionOfHealthAndNursingInsurance(eastValues.getBasicAmountForHealthAndNursingInsurance().multiply(ZWANZIG).divide(HUNDERT, 2, RoundingMode.HALF_UP));
        eastValues.setMinimumCalculationBasisForContributionOfPensionersInsurance(eastValues.getBasicAmountForPensionersAndUnemploymentInsurance().multiply(ACHTZIG).divide(HUNDERT, 2, RoundingMode.HALF_UP));
        eastValues.setCalculationBasisForContributionOfHealthAndNursingInsurance(eastValues.getBasicAmountForHealthAndNursingInsurance().multiply(ZWANZIG).divide(HUNDERT, 2, RoundingMode.HALF_UP));
        eastValues.setCalculationBasisForContributionOfPensionersAndUnemploymentInsurance(eastValues.getBasicAmountForPensionersAndUnemploymentInsurance().multiply(ZWANZIG).divide(HUNDERT, 2, RoundingMode.HALF_UP));
        eastValues.setCalculationBasisForContributionOfUnemploymentInsurance(eastValues.getBasicAmountForPensionersAndUnemploymentInsurance());
        eastValues.setMinimumIncomeLimitForContributionOfHealtAndNursingInsuranceConcerningRetirementIncome(eastValues.getBasicAmountForHealthAndNursingInsurance().divide(ZWANZIG, 2, RoundingMode.HALF_UP));
    }
}

