/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.global.healthfund.itsg.xml;

import com.varial.base.BigDecimalHelper;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.session.SessionContext;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.global.healthfund.AnswerBackEnum;
import com.varial.personnel.domain.global.healthfund.Assessment;
import com.varial.personnel.domain.global.healthfund.HealthFund;
import com.varial.personnel.domain.global.healthfund.HealthFundTP;
import com.varial.personnel.domain.global.healthfund.TypeOfHealthFundEnum;
import com.varial.personnel.domain.global.healthfund.itsg.AssessmentItsg;
import com.varial.personnel.domain.global.healthfund.itsg.HealthFundItsg;
import com.varial.personnel.domain.global.healthfund.itsg.HealthFundTPItsg;
import com.varial.personnel.domain.global.healthfund.itsg.ItsgImport;
import com.varial.personnel.domain.global.healthfund.itsg.xml.DFUEComparator;
import com.varial.personnel.domain.global.healthfund.mapper.RefundSIEREnumMapper;
import com.varial.personnel.domain.global.healthfund.mapper.TypeOfHealthFundEnumMapper;
import com.varial.personnel.domain.global.masterdata.xmlimport.XmlImport;
import com.varial.personnel.domain.global.socialinsurance.SocialInsurance;
import com.varial.personnel.domain.reports.Progressbar;
import com.varial.personnel.framework.basictypes.PostalAddress;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.StringMapper;
import de.gkv.masterdata.version1.AnschriftCtp;
import de.gkv.masterdata.version1.Stammdatendatei;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ItsgXmlImport
extends XmlImport {
    private final Date mStartDate;
    private final Date mEffectiveFrom;
    private Date mUntilDate;
    private List<Date> mGaps;
    private Iterator<Date> mIteratorGap;
    private Date mCurrentGap;
    private String mPreviousKey;
    private HealthFundItsg mHealthFundItsg;
    private Stammdatendatei.Einzugsstelle mCurrectEinzugstelle;
    private List<Stammdatendatei.Einzugsstelle.Adressdaten.DFUE> mDfues;
    private static final int AOK = 14;
    private static final int BKK = 15;
    private static final int EKK = 16;
    private static final int IKK = 17;
    private static final int BUKN = 18;
    private static final int SEEK = 19;
    private static final int LKK = 20;
    private static final int VVAG = 21;

    public ItsgXmlImport(Stammdatendatei stammdatendatei, Date begin) {
        super(stammdatendatei);
        this.mStartDate = DateHelper.getFirstDayOfMonth((Date)begin);
        this.mEffectiveFrom = ItsgImport.getItsgBegin();
    }

    public int getSize() {
        return this.mMasterdata.getEinzugsstelle().size();
    }

    public void addGap(Date begin) {
        if (DateHelper.afterOrEqual((Date)begin, (Date)this.mStartDate)) {
            if (this.mGaps == null) {
                this.mGaps = new LinkedList<Date>();
            }
            this.mGaps.add(begin);
            Collections.sort(this.mGaps, Collections.reverseOrder());
        }
    }

    public void create(Progressbar<?> progressBar) throws BusinessDomainException {
        List einzugsstellen = this.mMasterdata.getEinzugsstelle();
        if (progressBar != null) {
            progressBar.setTotal(einzugsstellen.size());
        }
        for (Stammdatendatei.Einzugsstelle einzugsstelle : einzugsstellen) {
            if (einzugsstelle.getGueltigBis() == null || DateHelper.afterOrEqual((Date)ItsgXmlImport.toDate(einzugsstelle.getGueltigBis()), (Date)this.mStartDate)) {
                this.mCurrectEinzugstelle = einzugsstelle;
                this.initUntil();
                this.initGaps();
                this.mHealthFundItsg = new HealthFundItsg();
                this.mHealthFundItsg.setHealthFund(this.mCurrectEinzugstelle.getAdressdaten().getKurzbezeichnung());
                ++this.mCreated;
                String bbnr = this.mCurrectEinzugstelle.getBbnr();
                this.mDfues = this.mCurrectEinzugstelle.getAdressdaten().getDFUE();
                Collections.sort(this.mDfues, new DFUEComparator());
                for (Date date : this.getDates()) {
                    this.save(bbnr, date);
                }
                SessionContext.getInstance().getPersistencySession().flush();
            }
            if (progressBar == null) continue;
            progressBar.nextProcessed();
        }
    }

    private void initUntil() {
        this.mUntilDate = VDate.getDateMax();
    }

    private void initGaps() {
        if (this.mGaps != null) {
            this.mIteratorGap = this.mGaps.iterator();
            if (this.mIteratorGap.hasNext()) {
                this.mCurrentGap = this.mIteratorGap.next();
            }
        }
    }

    private List<Date> getDates() {
        Date date;
        ArrayList<Date> result = new ArrayList<Date>();
        for (Stammdatendatei.BeitragssaetzeSv beitragssaetzeSv : this.mMasterdata.getBeitragssaetzeSv()) {
            date = ItsgXmlImport.toDate(beitragssaetzeSv.getGueltigAb());
            if (date == null || result.contains(date)) continue;
            result.add(date);
        }
        for (Stammdatendatei.Einzugsstelle.Adressdaten.DFUE dFUE : this.mDfues) {
            date = ItsgXmlImport.toDate(dFUE.getGueltigAb());
            if (date == null || result.contains(date)) continue;
            result.add(date);
        }
        if (this.mCurrectEinzugstelle.getAbrechnungsdaten().size() > 0) {
            for (Stammdatendatei.Einzugsstelle.Abrechnungsdaten.Kibs kibs : ((Stammdatendatei.Einzugsstelle.Abrechnungsdaten)this.mCurrectEinzugstelle.getAbrechnungsdaten().get(0)).getKibs()) {
                date = ItsgXmlImport.toDate(kibs.getAgGueltigAb());
                if (date == null || result.contains(date)) continue;
                result.add(date);
            }
            for (Stammdatendatei.Einzugsstelle.Abrechnungsdaten.Ume ume : ((Stammdatendatei.Einzugsstelle.Abrechnungsdaten)this.mCurrectEinzugstelle.getAbrechnungsdaten().get(0)).getUme()) {
                date = ItsgXmlImport.toDate(ume.getGueltigAb());
                if (date == null || result.contains(date)) continue;
                result.add(date);
            }
        }
        Collections.sort(result, Collections.reverseOrder());
        return result;
    }

    private boolean save(String id, Date begin) throws BusinessDomainException {
        String currentKey;
        if (this.mCurrentGap != null && this.mCurrentGap.compareTo(begin) >= 0) {
            if (this.mCurrentGap.compareTo(begin) > 0) {
                begin = this.mCurrentGap;
            }
            this.mCurrentGap = this.mIteratorGap.hasNext() ? this.mIteratorGap.next() : null;
        }
        if ((currentKey = id + begin).equals(this.mPreviousKey)) {
            return false;
        }
        this.mPreviousKey = currentKey;
        HealthFundTPItsg tp = new HealthFundTPItsg((HealthFund)this.mHealthFundItsg);
        this.merge(tp);
        this.mergeDFUE(tp, this.getDFUE(begin));
        this.mergeBeitragssaetzeSv(tp, this.getBeitragssaetzeSv(begin));
        this.mergeUme(tp, this.getUme(begin));
        this.mergeKibs(tp, this.getKibs(begin));
        if (DateHelper.before((Date)begin, (Date)this.mStartDate)) {
            begin = this.mStartDate;
        }
        Date val = begin;
        Date end = VDate.getDateMax();
        tp.setEffectiveFrom(this.mEffectiveFrom);
        tp.setEffectiveUntil(end);
        tp.setValidFrom(val);
        tp.setValidUntil(this.mUntilDate);
        tp.fillDues(SocialInsurance.getSocialInsuranceHistory((Date)this.mEffectiveFrom, (Date)val));
        this.mUntilDate = this.previousDate(begin);
        ++this.mCreatedTP;
        return true;
    }

    private void merge(HealthFundTPItsg tp) {
        tp.setStandardCompanyNumber(this.mCurrectEinzugstelle.getBbnr());
        tp.setShortDescription(this.mCurrectEinzugstelle.getAdressdaten().getKurzbezeichnung());
        StringBuilder b = new StringBuilder();
        this.append(b, this.mCurrectEinzugstelle.getAdressdaten().getName1());
        this.append(b, this.mCurrectEinzugstelle.getAdressdaten().getName2());
        this.append(b, this.mCurrectEinzugstelle.getAdressdaten().getName3());
        tp.setLongDescription(b.toString());
        tp.setAnswerBackEnum(AnswerBackEnum.ABE_Krankenkasse);
        tp.setTypeOfHealthFundEnum(this.getTypeOfHealthFundEnum());
        tp.setStandardCompanyNumberSuccessor(this.mCurrectEinzugstelle.getNachfolgeBn());
        tp.setStandardCompanyNumberValidUntil(ItsgXmlImport.toDate(this.mCurrectEinzugstelle.getGueltigBis()));
        tp.setAddress(this.getAddress());
        tp.setCreditorId(this.mCurrectEinzugstelle.getAdressdaten().getGlaeubigerId());
    }

    private TypeOfHealthFundEnum getTypeOfHealthFundEnum() {
        int t = -1;
        switch (this.mCurrectEinzugstelle.getKassenart()) {
            case 14: {
                t = 0;
                break;
            }
            case 15: {
                t = 2;
                break;
            }
            case 16: {
                t = 3;
                break;
            }
            case 17: 
            case 21: {
                t = 1;
                break;
            }
            case 18: {
                t = 6;
                break;
            }
            case 19: {
                t = 4;
                break;
            }
            case 20: {
                t = 5;
            }
        }
        if (t == -1) {
            t = -1;
        }
        return TypeOfHealthFundEnumMapper.toTypeOfHealthFundEnum((int)t);
    }

    private PostalAddress getAddress() {
        for (AnschriftCtp each : this.mCurrectEinzugstelle.getAdressdaten().getAnschrift()) {
            if ("Anschrift".equals(each.getArt())) {
                StringBuffer street = new StringBuffer();
                street.append(each.getStrasse());
                if (!StringMapper.isNullString((String)each.getHausnummer())) {
                    street.append(" ");
                    street.append(each.getHausnummer());
                }
                return new PostalAddress(street.toString(), each.getPlz(), each.getOrt(), null);
            }
            if (!"Postfach".equals(each.getArt())) continue;
            return new PostalAddress(each.getPostfach(), each.getPlz(), each.getOrt(), null);
        }
        return new PostalAddress(null, null, null, null);
    }

    private Stammdatendatei.Einzugsstelle.Adressdaten.DFUE getDFUE(Date begin) {
        for (Stammdatendatei.Einzugsstelle.Adressdaten.DFUE each : this.mDfues) {
            Date gueltigAb = ItsgXmlImport.toDate(each.getGueltigAb());
            if (gueltigAb == null || DateHelper.after((Date)gueltigAb, (Date)VDate.getCurrentLocalizedDateAndTime())) continue;
            return each;
        }
        return null;
    }

    private void mergeDFUE(HealthFundTPItsg tp, Stammdatendatei.Einzugsstelle.Adressdaten.DFUE dfue) {
        if (dfue == null) {
            return;
        }
        tp.setHealthFundDAV(HealthFund.getHealthFundDAV((String)dfue.getDavbn().getBbnr()));
    }

    private Stammdatendatei.BeitragssaetzeSv getBeitragssaetzeSv(Date begin) {
        for (Stammdatendatei.BeitragssaetzeSv each : this.mMasterdata.getBeitragssaetzeSv()) {
            Date gueltigAb = ItsgXmlImport.toDate(each.getGueltigAb());
            if (gueltigAb == null || gueltigAb.compareTo(begin) > 0) continue;
            return each;
        }
        return null;
    }

    private void mergeBeitragssaetzeSv(HealthFundTPItsg tp, Stammdatendatei.BeitragssaetzeSv bts) {
        if (bts == null) {
            return;
        }
        BigDecimal value = bts.getKvAllgemein();
        tp.setPercentageGeneral(value);
        BigDecimal halve = this.halve(value);
        tp.setPercentageGeneralEE(halve);
        tp.setPercentageGeneralER(halve);
        value = bts.getKvErmaessigt();
        tp.setPercentageReduced(value);
        halve = this.halve(value);
        tp.setPercentageReducedEE(halve);
        tp.setPercentageReducedER(halve);
        value = new BigDecimal("99.99");
        tp.setPercentageIncreased(value);
        halve = this.halve(value);
        tp.setPercentageIncreasedEE(halve);
        tp.setPercentageIncreasedER(halve);
        if (tp.getTypeOfHealthFundEnum() == TypeOfHealthFundEnum.TOHF_LKK) {
            tp.setAdditionalDues(bts.getKvDzban());
        }
        tp.setContributionForPensionersPercentage(bts.getKvAllgemein());
        tp.setContributionForPensionersPercentageEE(bts.getKvAllgemein());
    }

    private Stammdatendatei.Einzugsstelle.Abrechnungsdaten.Ume getUme(Date begin) {
        if (this.mCurrectEinzugstelle.getAbrechnungsdaten().size() > 0) {
            for (Stammdatendatei.Einzugsstelle.Abrechnungsdaten.Ume each : ((Stammdatendatei.Einzugsstelle.Abrechnungsdaten)this.mCurrectEinzugstelle.getAbrechnungsdaten().get(0)).getUme()) {
                Date gueltigAb = ItsgXmlImport.toDate(each.getGueltigAb());
                if (gueltigAb == null || gueltigAb.compareTo(begin) > 0) continue;
                return each;
            }
        }
        return null;
    }

    private void mergeUme(HealthFundTPItsg tp, Stammdatendatei.Einzugsstelle.Abrechnungsdaten.Ume ume) {
        if (ume == null) {
            return;
        }
        List<Stammdatendatei.Einzugsstelle.Abrechnungsdaten.Ume.Umlage> u1s = this.reorgUmlagenU1(ume);
        List<Stammdatendatei.Einzugsstelle.Abrechnungsdaten.Ume.Umlage> u2s = this.reorgUmlagenU2(ume);
        int bbgU1U2Mutterschaft = 0;
        int bbgU1U2Mutterschaft_u2_1 = 0;
        int bbgU2Beschaeftigungsverbot = 0;
        int erstattungBeitragTp = 9;
        int erstattungBeitragTp_u2_1 = 9;
        BigDecimal erstattungTatPausch = BigDecimal.ZERO;
        BigDecimal erstattungTatPausch_u2_1 = BigDecimal.ZERO;
        BigDecimal umlageSatz_u1_1 = BigDecimal.ZERO;
        BigDecimal erstattungsatz_u1_1 = BigDecimal.ZERO;
        BigDecimal umlageSatz_u1_2 = BigDecimal.ZERO;
        BigDecimal erstattungsatz_u1_2 = BigDecimal.ZERO;
        BigDecimal umlageSatz_u1_3 = BigDecimal.ZERO;
        BigDecimal erstattungsatz_u1_3 = BigDecimal.ZERO;
        BigDecimal umlageSatz_u1_4 = BigDecimal.ZERO;
        BigDecimal erstattungsatz_u1_4 = BigDecimal.ZERO;
        BigDecimal umlageSatz_u1_5 = BigDecimal.ZERO;
        BigDecimal erstattungsatz_u1_5 = BigDecimal.ZERO;
        BigDecimal umlageSatz_u1_6 = BigDecimal.ZERO;
        BigDecimal erstattungsatz_u1_6 = BigDecimal.ZERO;
        BigDecimal umlageSatz_u2_1 = BigDecimal.ZERO;
        BigDecimal erstattungsatz_u2_1 = BigDecimal.ZERO;
        BigDecimal umlageSatz_u2_2 = BigDecimal.ZERO;
        BigDecimal erstattungsatz_u2_2 = BigDecimal.ZERO;
        BigDecimal umlageSatz_u2_3 = BigDecimal.ZERO;
        BigDecimal erstattungsatz_u2_3 = BigDecimal.ZERO;
        for (Stammdatendatei.Einzugsstelle.Abrechnungsdaten.Ume.Umlage each : u1s) {
            if ("U1_1".equals(each.getId())) {
                bbgU1U2Mutterschaft = each.getBbgU1U2Mutterschaft();
                erstattungBeitragTp = each.getErstattungBeitragTp();
                erstattungTatPausch = each.getErstattungTatPausch();
                umlageSatz_u1_1 = each.getUmlagesatz();
                erstattungsatz_u1_1 = each.getErstattungssatz();
            }
            if ("U1_2".equals(each.getId())) {
                umlageSatz_u1_2 = each.getUmlagesatz();
                erstattungsatz_u1_2 = each.getErstattungssatz();
            }
            if ("U1_3".equals(each.getId())) {
                umlageSatz_u1_3 = each.getUmlagesatz();
                erstattungsatz_u1_3 = each.getErstattungssatz();
            }
            if ("U1_4".equals(each.getId())) {
                umlageSatz_u1_4 = each.getUmlagesatz();
                erstattungsatz_u1_4 = each.getErstattungssatz();
            }
            if ("U1_5".equals(each.getId())) {
                umlageSatz_u1_5 = each.getUmlagesatz();
                erstattungsatz_u1_5 = each.getErstattungssatz();
            }
            if (!"U1_6".equals(each.getId())) continue;
            umlageSatz_u1_6 = each.getUmlagesatz();
            erstattungsatz_u1_6 = each.getErstattungssatz();
        }
        for (Stammdatendatei.Einzugsstelle.Abrechnungsdaten.Ume.Umlage each : u2s) {
            if ("U2_1".equals(each.getId())) {
                bbgU1U2Mutterschaft_u2_1 = each.getBbgU1U2Mutterschaft();
                bbgU2Beschaeftigungsverbot = each.getBbgU2Beschaeftigungsverbot();
                erstattungBeitragTp_u2_1 = each.getErstattungBeitragTp();
                erstattungTatPausch_u2_1 = each.getErstattungTatPausch();
                umlageSatz_u2_1 = each.getUmlagesatz();
                erstattungsatz_u2_1 = new BigDecimal("100.00");
            }
            if (!"U2_2".equals(each.getId())) continue;
            umlageSatz_u2_2 = each.getUmlagesatz();
            erstattungsatz_u2_2 = each.getErstattungssatz();
        }
        tp.setU1Limitation(bbgU1U2Mutterschaft == 1);
        tp.setU1RefundSocialInsuranceER(RefundSIEREnumMapper.toRefundSIEREnum((int)erstattungBeitragTp));
        tp.setU1RefundPercentageFact(erstattungTatPausch);
        tp.setU2LimittationMother(bbgU1U2Mutterschaft_u2_1 == 1);
        tp.setU2LimitationProhibitionToEmploy(bbgU2Beschaeftigungsverbot == 1);
        tp.setU2RefundSocialInsuranceER(RefundSIEREnumMapper.toRefundSIEREnum((int)erstattungBeitragTp_u2_1));
        tp.setU2RefundPercentageFact(erstattungTatPausch_u2_1);
        Assessment[] as = tp.getAssessments();
        if (new BigDecimal("100.00").equals(erstattungsatz_u2_2)) {
            BigDecimal temp = umlageSatz_u2_2;
            umlageSatz_u2_2 = umlageSatz_u2_1;
            umlageSatz_u2_1 = temp;
            temp = erstattungsatz_u2_2;
            erstattungsatz_u2_2 = erstattungsatz_u2_1;
            erstattungsatz_u2_1 = temp;
        }
        BigDecimal[][] values1 = new BigDecimal[][]{{umlageSatz_u1_1, erstattungsatz_u1_1}, {umlageSatz_u1_2, erstattungsatz_u1_2}, {umlageSatz_u1_3, erstattungsatz_u1_3}, {umlageSatz_u2_1, erstattungsatz_u2_1}, {umlageSatz_u2_2, erstattungsatz_u2_2}, {umlageSatz_u2_3, erstattungsatz_u2_3}};
        for (int i = 0; i < values1.length; ++i) {
            AssessmentItsg a = new AssessmentItsg((HealthFundTP)tp);
            a.setSerialNumber(i + 1);
            a.setSubmitPercentage(values1[i][0]);
            a.setRefundPercentage(values1[i][1]);
            if (!a.isEmpty()) {
                as[i] = a;
                continue;
            }
            a.makeReadOnly();
        }
        if (as.length < 15) {
            return;
        }
        BigDecimal[][] values2 = new BigDecimal[][]{{umlageSatz_u1_4, erstattungsatz_u1_4}, {umlageSatz_u1_5, erstattungsatz_u1_5}, {umlageSatz_u1_6, erstattungsatz_u1_6}};
        int i = 0;
        int j = 9;
        while (i < values2.length) {
            AssessmentItsg a = new AssessmentItsg((HealthFundTP)tp);
            a.setSerialNumber(j + 1);
            a.setSubmitPercentage(values2[i][0]);
            a.setRefundPercentage(values2[i][1]);
            if (!a.isEmpty()) {
                as[j] = a;
            } else {
                a.makeReadOnly();
            }
            ++i;
            ++j;
        }
    }

    private Stammdatendatei.Einzugsstelle.Abrechnungsdaten.Kibs getKibs(Date begin) {
        if (this.mCurrectEinzugstelle.getAbrechnungsdaten().size() > 0) {
            for (Stammdatendatei.Einzugsstelle.Abrechnungsdaten.Kibs each : ((Stammdatendatei.Einzugsstelle.Abrechnungsdaten)this.mCurrectEinzugstelle.getAbrechnungsdaten().get(0)).getKibs()) {
                Date gueltigAb = ItsgXmlImport.toDate(each.getAgGueltigAb());
                if (gueltigAb == null || gueltigAb.compareTo(begin) > 0) continue;
                return each;
            }
        }
        return null;
    }

    private void mergeKibs(HealthFundTPItsg tp, Stammdatendatei.Einzugsstelle.Abrechnungsdaten.Kibs kibs) {
        if (kibs == null) {
            return;
        }
        if (tp.getTypeOfHealthFundEnum() != TypeOfHealthFundEnum.TOHF_LKK) {
            tp.setAdditionalDues(kibs.getBeitragssatz().getValue());
            tp.setAdditionalDuesValidFrom(ItsgXmlImport.toDate(kibs.getZsGueltigAbFusion()));
        }
    }

    protected List<Stammdatendatei.Einzugsstelle.Abrechnungsdaten.Ume.Umlage> reorgUmlagenU1(Stammdatendatei.Einzugsstelle.Abrechnungsdaten.Ume ume) {
        ArrayList<Sortable> sortedu1s = new ArrayList<Sortable>();
        for (Stammdatendatei.Einzugsstelle.Abrechnungsdaten.Ume.Umlage each : ume.getUmlage()) {
            if (!each.getId().startsWith("U1_")) continue;
            int tp = each.getErstattungBeitragTp();
            if (tp == 1 || tp == 2) {
                each.setErstattungssatz(this.sum2nk(each.getErstattungssatz(), each.getErstattungTatPausch()));
            }
            sortedu1s.add(new Sortable(each, each.getErstattungssatz()));
        }
        Collections.sort(sortedu1s, Collections.reverseOrder());
        ArrayList<Stammdatendatei.Einzugsstelle.Abrechnungsdaten.Ume.Umlage> u1s = new ArrayList<Stammdatendatei.Einzugsstelle.Abrechnungsdaten.Ume.Umlage>();
        int sortedIndex = 0;
        for (Sortable each : sortedu1s) {
            each.umlage.setId("U1_" + ++sortedIndex);
            u1s.add(each.umlage);
        }
        return u1s;
    }

    protected List<Stammdatendatei.Einzugsstelle.Abrechnungsdaten.Ume.Umlage> reorgUmlagenU2(Stammdatendatei.Einzugsstelle.Abrechnungsdaten.Ume ume) {
        Stammdatendatei.Einzugsstelle.Abrechnungsdaten.Ume.Umlage u21 = null;
        ArrayList<Stammdatendatei.Einzugsstelle.Abrechnungsdaten.Ume.Umlage> u2s = new ArrayList<Stammdatendatei.Einzugsstelle.Abrechnungsdaten.Ume.Umlage>();
        for (Stammdatendatei.Einzugsstelle.Abrechnungsdaten.Ume.Umlage each : ume.getUmlage()) {
            if (each.getId().startsWith("U2_")) {
                u2s.add(each);
            }
            if (!"U2_1".equals(each.getId())) continue;
            u21 = each;
        }
        if (u21 == null) {
            throw new IllegalStateException("Missed U2_1 in UME node");
        }
        Stammdatendatei.Einzugsstelle.Abrechnungsdaten.Ume.Umlage u22 = this.copyAsU22(u21);
        u2s.add(u22);
        return u2s;
    }

    private Stammdatendatei.Einzugsstelle.Abrechnungsdaten.Ume.Umlage copyAsU22(Stammdatendatei.Einzugsstelle.Abrechnungsdaten.Ume.Umlage u21) {
        BigDecimal compare = new BigDecimal("100.000");
        BigDecimal erstattungssatz = u21.getErstattungssatz();
        BigDecimal umlagesatz = u21.getUmlagesatz();
        BigDecimal etp = u21.getErstattungTatPausch();
        if (BigDecimalMapper.compareTo((BigDecimal)compare, (BigDecimal)etp) > 0) {
            erstattungssatz = this.sum2nk(erstattungssatz, etp);
        } else if (compare.equals(etp)) {
            if (erstattungssatz != null) {
                erstattungssatz = null;
            }
            if (umlagesatz != null) {
                umlagesatz = null;
            }
        } else {
            throw new IllegalStateException("\"U2 Erstattung tats\u00e4chlich/pauschal 2; Besch\u00e4ftigungsverbot\" must be less or equal 100, found: " + etp);
        }
        Stammdatendatei.Einzugsstelle.Abrechnungsdaten.Ume.Umlage clone = new Stammdatendatei.Einzugsstelle.Abrechnungsdaten.Ume.Umlage();
        clone.setId("U2_2");
        clone.setBbgU1U2Mutterschaft(u21.getBbgU1U2Mutterschaft());
        clone.setBbgU2Beschaeftigungsverbot(u21.getBbgU2Beschaeftigungsverbot());
        clone.setErstattungBeitragTp(u21.getErstattungBeitragTp());
        clone.setErstattungTatPausch(etp);
        clone.setErstattungssatz(erstattungssatz);
        clone.setUmlagesatz(umlagesatz);
        return clone;
    }

    private BigDecimal sum2nk(BigDecimal erstattungssatz, BigDecimal erstattungTatPausch) {
        return BigDecimalHelper.sum((BigDecimal[])new BigDecimal[]{erstattungssatz, erstattungTatPausch}).setScale(2);
    }

    private void append(StringBuilder b, String string) {
        if (StringMapper.isNullString((String)string)) {
            return;
        }
        if (b.length() > 0) {
            b.append(' ');
        }
        b.append(string);
    }

    private Date previousDate(Date date) {
        return DateHelper.yesterday((Date)date);
    }

    public BigDecimal halve(BigDecimal value) {
        if (value == null) {
            return null;
        }
        return value.divide(BigDecimal.valueOf(2L), 2, RoundingMode.HALF_UP);
    }

    private class Sortable
    implements Comparable<Sortable> {
        private final Stammdatendatei.Einzugsstelle.Abrechnungsdaten.Ume.Umlage umlage;
        private final BigDecimal erstattungsbetrag;

        public Sortable(Stammdatendatei.Einzugsstelle.Abrechnungsdaten.Ume.Umlage umlage, BigDecimal erstattungsbetrag) {
            this.umlage = umlage;
            this.erstattungsbetrag = erstattungsbetrag;
        }

        @Override
        public int compareTo(Sortable another) {
            return this.erstattungsbetrag.compareTo(another.erstattungsbetrag);
        }
    }
}

