/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.global.healthfund.itsg;

import com.varial.base.UtilitiesManager;
import com.varial.base.exception.ApplicationException;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.security.AuthorizationToken;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.calculation.WriteCalculationJob;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.IEmployeePersistencyManager;
import com.varial.personnel.domain.global.healthfund.HealthFund;
import com.varial.personnel.domain.global.healthfund.HealthFundTP;
import com.varial.personnel.domain.global.healthfund.itsg.Difference;
import com.varial.personnel.domain.global.healthfund.itsg.HealthFundItsg;
import com.varial.personnel.framework.IValuationManager;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.DateMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.springframework.dao.DataAccessException;

public class DifferencesItsg {
    private static final String[] FIELD_NAMES = new String[]{"mValidFrom", "mShortDescription", "mLongDescription", "mAnswerBackEnum", "mTypeOfHealthFundEnum", "mStandardCompanyNumber", "mStandardCompanyNumberSuccessor", "mStandardCompanyNumberValidUntil", "mStreet", "mPostalCode", "mCity", "mDistrict", "mContributionForPensionersPercentage", "mContributionForPensionersPercentageEE", "mContributionForPensionersPercentageER", "mPercentageGeneral", "mPercentageReduced", "mPercentageIncreased", "mPercentageGeneralEE", "mPercentageReducedEE", "mPercentageIncreasedEE", "mPercentageGeneralER", "mPercentageReducedER", "mPercentageIncreasedER", "mDuesVHIGeneral", "mDuesVHIReduced", "mDuesVHIIncreased", "mDuesVHIGeneralGrant", "mDuesVHIReducedGrant", "mDuesVHIIncreasedGrant", "mDuesVNIGeneral", "mVNIableForGrantGen", "mAssessments", "mHealthFundDAV", "mAdditionalDues", "mAdditionalDuesEE", "mAdditionalDuesER", "mHealthFund", "mAdditionalDuesValidFrom"};
    private static final String[] FIELD_CAPTIONS = new String[]{"G\u00fcltig ab", "Kurzbezeichnung", "Name", "Funktion", "Kassenart", "Betriebs-Nr.", "Betriebs-Nr. Folgeorganisation", "Betriebs-Nr. g\u00fcltig bis", "Stra\u00dfe/Postfach", "Postleitzahl", "Ort", "Ortsteil", "Beitragssatz Versorgungsbez\u00fcge Gesamter %-Satz", "Beitragssatz Versorgungsbez\u00fcge AN-Anteil %-Satz", "Beitragssatz Versorgungsbez\u00fcge AG-Anteil %-Satz", "Gesetzl. KV Beitragssatz allgemein gesamter %-Satz", "Gesetzl. KV Beitragssatz erm\u00e4\u00dfigt gesamter %-Satz", "Gesetzl. KV Beitragssatz erh\u00f6ht gesamter %-Satz", "Gesetzl. KV Beitragssatz allgemein AN %-Satz", "Gesetzl. KV Beitragssatz erm\u00e4\u00dfigt AN %-Satz", "Gesetzl. KV Beitragssatz erh\u00f6ht AN %-Satz", "Gesetzl. KV Beitragssatz allgemein AG %-Satz", "Gesetzl. KV Beitragssatz erm\u00e4\u00dfigt AG %-Satz", "Gesetzl. KV Beitragssatz erh\u00f6ht AG %-Satz", "Freiw. KV Beitrag allgemein Gesamter Beitrag", "Freiw. KV Beitrag erm\u00e4\u00dfigt Gesamter Beitrag", "Freiw. KV Beitrag erh\u00f6ht Gesamter Beitrag", "Freiw. KV Beitrag allgemein AG-zuschussf\u00e4hig", "Freiw. KV Beitrag erm\u00e4\u00dfigt AG-zuschussf\u00e4hig", "Freiw. KV Beitrag erh\u00f6ht AG-zuschussf\u00e4hig", "Freiw. PV Betrag allg. gesamter Beitrag", "Freiw. PV Betrag allg. AG-zuschu\u00dff\u00e4hig", "Umlages\u00e4tze", "Referenz Datenannahmestelle", "Zusatzbeitrag gesamter %-Satz,", "AN-Zusatzbeitrag gesamter %-Satz", "AG-Zusatzbeitrag gesamter %-Satz", "Krankenkasse (Schl\u00fcssel)", "G\u00fcltig ab ZB bei Fusion (nur VBZ)"};
    private HealthFund mHealthFund;
    private String mId;
    private String mName;
    private Date mValidFrom;
    @Deprecated
    private List<Date> mDates;
    @Deprecated
    private List<HealthFundTP> mFundTPs;
    @Deprecated
    private List<HealthFundTP> mItsgTPs;
    @Deprecated
    private Employee[] mEmployees;
    @Deprecated
    private List<List<Difference>> mDifferences;
    private Date mFirstValuateNeeded;

    @Deprecated
    public DifferencesItsg(HealthFundItsg itsg, Date begin) throws BusinessDomainException {
        this(itsg, HealthFund.getByStdCompanyNo((String)DifferencesItsg.getStandardCompanyNumber(itsg)), begin);
    }

    public DifferencesItsg(HealthFundItsg itsg, HealthFund orig, Date begin) throws BusinessDomainException {
        this.mId = DifferencesItsg.getStandardCompanyNumber(itsg);
        if (!HealthFund.isPersistent((String)this.mId)) {
            return;
        }
        this.mHealthFund = orig;
        this.mName = itsg.getHealthFund();
        this.mValidFrom = begin;
        this.mDates = new LinkedList<Date>();
        this.mFundTPs = new LinkedList<HealthFundTP>();
        this.mItsgTPs = new LinkedList<HealthFundTP>();
        this.initTPs(orig.getHealthFundHistory(begin), (HealthFundTP[])itsg.getHealthFundItsgHistory(begin));
        this.initEmployees();
        this.initDifferences();
    }

    public static String getStandardCompanyNumber(HealthFundItsg itsg) throws BusinessDomainException {
        HealthFundTP tp = itsg.getHealthFundTP(VDate.getDateMax(), VDate.getDateMax());
        return tp.getStandardCompanyNumber();
    }

    private void initTPs(HealthFundTP[] ftps, HealthFundTP[] itps) {
        Date d;
        int i;
        Date first = itps[0].getValidFrom();
        if (DateHelper.after((Date)first, (Date)this.mValidFrom)) {
            this.mValidFrom = first;
        }
        if (ftps.length > 0 && DateHelper.after((Date)(first = ftps[0].getValidFrom()), (Date)this.mValidFrom)) {
            this.mValidFrom = first;
        }
        for (i = ftps.length - 1; i >= 0 && !DateHelper.before((Date)(d = ftps[i].getValidFrom()), (Date)this.mValidFrom); --i) {
            this.mDates.add(0, d);
        }
        for (i = itps.length - 1; i >= 0 && !DateHelper.before((Date)(d = itps[i].getValidFrom()), (Date)this.mValidFrom); --i) {
            int pos = Collections.binarySearch(this.mDates, d);
            if (pos >= 0) continue;
            pos = -pos - 1;
            this.mDates.add(pos, d);
        }
        if (this.mDates.isEmpty()) {
            this.mDates.add(0, this.mValidFrom);
        }
        i = ftps.length - 1;
        int j = itps.length - 1;
        ListIterator<Date> it = this.mDates.listIterator(this.mDates.size());
        while (it.hasPrevious()) {
            Date begin = it.previous();
            if (i > 0 && DateHelper.after((Date)ftps[i].getValidFrom(), (Date)begin)) {
                --i;
            }
            if (j > 0 && DateHelper.after((Date)itps[j].getValidFrom(), (Date)begin)) {
                --j;
            }
            this.mFundTPs.add(0, ftps[i]);
            this.mItsgTPs.add(0, itps[j]);
        }
    }

    private void initEmployees() {
        if (this.mHealthFund == null) {
            return;
        }
        Iterator<HealthFundTP> fit = this.mFundTPs.iterator();
        Iterator<HealthFundTP> iit = this.mItsgTPs.iterator();
        for (Date differenceFrom : this.mDates) {
            HealthFundTP itp;
            HealthFundTP ftp = fit.next();
            if (!ftp.compareToOld(itp = iit.next())) continue;
            this.mFirstValuateNeeded = differenceFrom;
            break;
        }
        this.mEmployees = this.mFirstValuateNeeded != null ? this.getIEmployeePM().getAllEEHealthFund(this.mHealthFund.getObjectid(), this.mFirstValuateNeeded, this.mFirstValuateNeeded, false) : new Employee[0];
    }

    private void initDifferences() {
        this.mDifferences = new ArrayList<List<Difference>>();
        if (this.mHealthFund == null) {
            return;
        }
        Iterator<HealthFundTP> fit = this.mFundTPs.iterator();
        Iterator<HealthFundTP> iit = this.mItsgTPs.iterator();
        while (fit.hasNext()) {
            HealthFundTP ftp = fit.next();
            HealthFundTP itp = iit.next();
            this.mDifferences.add(ftp.differences(itp));
        }
    }

    public String getId() {
        return this.mId;
    }

    public String getName() {
        return this.mName;
    }

    public Date getBegin() {
        return this.mValidFrom;
    }

    public Date getValuateFrom() {
        return this.mFirstValuateNeeded;
    }

    public HealthFund getBo() {
        return this.mHealthFund;
    }

    public List<Date> getDates() {
        return this.mDates;
    }

    public List<HealthFundTP> getFundTPs() {
        return this.mFundTPs;
    }

    public List<HealthFundTP> getItsgTPs() {
        return this.mItsgTPs;
    }

    public boolean getValuateNeeded() {
        return this.mEmployees == null ? false : this.mEmployees.length != 0;
    }

    public Employee[] getEmployees() {
        return this.mEmployees;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(1024);
        if (this.mHealthFund != null) {
            StringBuilder b = new StringBuilder(1024);
            this.valuationsString(b);
            this.differencesString(b);
            if (b.length() > 0) {
                buffer.append("Betriebs-Nr. ").append(this.mId).append(", ");
                buffer.append(this.mName).append("\r\n");
                buffer.append((CharSequence)b).append("\r\n");
            }
        }
        return buffer.toString();
    }

    private void valuationsString(StringBuilder buffer) {
        StringBuilder b = new StringBuilder(256);
        int len = this.mEmployees.length;
        if (len != 0) {
            if (len == 1) {
                b.append("einem Mitarbeiter");
            } else {
                b.append(len);
                b.append(" Mitarbeitern");
            }
            b.append(" betroffen.\r\n");
            for (int i = 0; i < len; ++i) {
                try {
                    b.append(' ').append(this.mEmployees[i].getIDString());
                    b.append("\r\n");
                    continue;
                }
                catch (ApplicationException applicationException) {
                    continue;
                }
                catch (DataAccessException dataAccessException) {
                    // empty catch block
                }
            }
        }
        if (b.length() > 0) {
            buffer.append("Durch die \u00c4nderung sind Abrechnungen von ");
            buffer.append((CharSequence)b);
        }
    }

    private void differencesString(StringBuilder buffer) {
        Iterator<List<Difference>> itd = this.mDifferences.iterator();
        for (Date validFrom : this.mDates) {
            StringBuilder b = new StringBuilder(1024);
            List<Difference> diffs = this.reorgFieldNames(itd.next());
            this.diffsToString(diffs, b);
            if (b.length() <= 0) continue;
            buffer.append(DateMapper.toDDMMYYYYPointSeparationString((Date)validFrom)).append(" ([Krankenkasse] [GKV-Beitragssatz] Bezeichnung)\r\n");
            buffer.append((CharSequence)b);
        }
    }

    private List<Difference> reorgFieldNames(List<Difference> diffs) {
        ArrayList<Difference> result = new ArrayList<Difference>(diffs.size());
        for (Difference diff : diffs) {
            result.add(this.reorgFieldName(diff));
        }
        return result;
    }

    private Difference reorgFieldName(Difference d) {
        for (int i = 0; i < FIELD_NAMES.length; ++i) {
            if (!d.getFieldName().equals(FIELD_NAMES[i])) continue;
            d.setFieldName(FIELD_CAPTIONS[i]);
            return d;
        }
        return d;
    }

    private void diffsToString(List<Difference> differences, StringBuilder buffer) {
        for (Difference element : differences) {
            buffer.append(' ').append(element).append("\r\n");
        }
    }

    public static final StringBuilder summaryString(StringBuilder b, int count, int differences, int valuations, int notfound) {
        if (count == 1 && notfound == 1) {
            b.append("Die Krankenkasse ist selbstverwaltet und kann nicht abgeglichen werden. \r\n\r\n");
        } else if (notfound == 1) {
            b.append("Eine Krankenkasse ist selbstverwaltet und kann nicht abgeglichen werden. \r\n\r\n");
        } else if (notfound > 1) {
            b.append(notfound).append(" Krankenkassen sind selbstverwaltet und k\u00f6nnen nicht abgeglichen werden. \r\n\r\n");
        }
        if (differences == 0) {
            if (notfound == 0) {
                b.append("Keine Unterschiede gefunden. ");
            }
        } else {
            if (differences != 1) {
                b.append(differences).append(" mit ");
            }
            b.append("Differenzen");
            if (valuations == 0) {
                b.append(" ohne Auswirkung");
            } else {
                if (differences != 1) {
                    b.append(", davon ").append(valuations);
                }
                b.append(" mit Auswirkungen");
            }
            b.append(" auf Mitarbeiter und Abrechnungen.\r\n\r\n");
        }
        return b;
    }

    public boolean isDifferent() {
        if (this.mDifferences == null) {
            return false;
        }
        for (List<Difference> differences : this.mDifferences) {
            if (differences.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public WriteCalculationJob valuate(AuthorizationToken token, Date schedulerTime) throws BusinessDomainException {
        return ((IValuationManager)UtilitiesManager.getBean((String)"valuationManager", IValuationManager.class)).valuate(token, this.mEmployees, this.mFirstValuateNeeded, HealthFundItsg.class.getName(), schedulerTime);
    }

    public void removeWithdrawalEmployees(Date date) {
        if (this.mEmployees == null) {
            return;
        }
        HashSet<Employee> result = new HashSet<Employee>();
        for (Employee employee : this.mEmployees) {
            if (!employee.isLastDateOfWithdrawalAfter(date)) continue;
            result.add(employee);
        }
        this.mEmployees = result.toArray(new Employee[result.size()]);
        Arrays.sort(this.mEmployees, (e1, e2) -> e1.getPersonnelnumber() - e2.getPersonnelnumber());
    }

    private IEmployeePersistencyManager getIEmployeePM() {
        return (IEmployeePersistencyManager)UtilitiesManager.getBean((String)"employeePersistencyManager", IEmployeePersistencyManager.class);
    }
}

