/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.evaluation.formula;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.calculation.CalculationBasicPersistencyManager;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.employee.valueposition.ValuePositionHistory;
import com.varial.personnel.domain.employee.varpayment.VarPaymentTP;
import com.varial.personnel.domain.evaluation.library.CalculationLibrary;
import com.varial.personnel.domain.evaluation.library.EmployeeLibrary;
import com.varial.personnel.domain.evaluation.library.ValuePositionLibrary;
import com.varial.personnel.domain.evaluation.mapper.ValueTypeHelper;
import com.varial.personnel.domain.typeofvalue.ValueType;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.persistency.PersistentObject;
import java.math.BigDecimal;
import java.util.Date;

public class ErmittlungZVKBruttoDifferenzVorjahrFormula {
    private final CalculationLibrary callib;
    private final ValuePositionLibrary wplib;
    private final EmployeeLibrary eelib;

    public ErmittlungZVKBruttoDifferenzVorjahrFormula(CalculationLibrary calculationLibrary, EmployeeLibrary employeeLibrary, ValuePositionLibrary valuePositionLibrary) {
        this.callib = calculationLibrary;
        this.eelib = employeeLibrary;
        this.wplib = valuePositionLibrary;
    }

    public void ermittel() throws BusinessDomainException {
        if (this.wplib.wertPosition().getGenesisOfParentObjects() instanceof VarPaymentTP) {
            switch (this.wplib.wertartenNummer()) {
                case 99991: {
                    this.wplib.addNeueWertPosition(100901, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.wplib.result(), false, (PersistentObject)this.wplib.wertPosition());
                    this.wplib.addNeueWertPosition(100906, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.wplib.result().negate(), false, (PersistentObject)this.wplib.wertPosition());
                    break;
                }
                case 99992: {
                    this.wplib.addNeueWertPosition(100903, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, this.wplib.result(), false, (PersistentObject)this.wplib.wertPosition());
                    this.wplib.addNeueWertPosition(110610, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, false, (PersistentObject)this.wplib.wertPosition());
                    this.wplib.addNeueWertPosition(130610, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, false, (PersistentObject)this.wplib.wertPosition());
                }
            }
            this.callib.result(this.wplib.result());
        } else {
            switch (this.wplib.wertartenNummer()) {
                case 99991: {
                    this.ermittelVorjahr();
                    break;
                }
                case 99992: {
                    this.ermittelFolgejahr();
                }
            }
        }
    }

    private void ermittelVorjahr() throws BusinessDomainException {
        ValuePosition[] vpArray;
        BigDecimal zvkBruttoLfdAkt = BigDecimal.ZERO;
        BigDecimal zvkBruttoSdZAkt = BigDecimal.ZERO;
        BigDecimal zvkBruttoFiktiveAkt = BigDecimal.ZERO;
        block14: for (ValuePosition vPos : vpArray = this.wplib.wpAusWPListeOderDB(this.callib.berchnungWirksamAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungWirksamAb()), this.callib.berchnungGueltigAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungWirksamAb()), ValueTypeHelper.getValueTypes((int[])new int[]{100901, 100902, 100903, 100908}))) {
            ValuePosition parentVP = this.getValuePositionFromParent(vPos);
            if (parentVP == null || !this.isParentRelevant(parentVP)) continue;
            BigDecimal result = vPos.getResult();
            switch (vPos.getValueType().getValueTypeKey()) {
                case 100901: {
                    zvkBruttoLfdAkt = zvkBruttoLfdAkt.add(result);
                    continue block14;
                }
                case 100902: {
                    zvkBruttoFiktiveAkt = zvkBruttoFiktiveAkt.add(result);
                    continue block14;
                }
                case 100903: 
                case 100908: {
                    zvkBruttoSdZAkt = zvkBruttoSdZAkt.add(result);
                }
            }
        }
        BigDecimal zvkBruttoLfdNachFJ = BigDecimal.ZERO;
        BigDecimal zvkBruttoFiktivNachFJ = BigDecimal.ZERO;
        BigDecimal zvkBruttoSdZNachFJ = BigDecimal.ZERO;
        BigDecimal zvkBruttoLfdAlt = BigDecimal.ZERO;
        BigDecimal zvkBruttoSdZAlt = BigDecimal.ZERO;
        BigDecimal zvkBruttoFiktiveAlt = BigDecimal.ZERO;
        block15: for (ValuePosition vPos : vpArray = this.wplib.wpAusWPListeOderDB(DateHelper.getFirstDayOfMonth((Date)DateHelper.yesterday((Date)this.callib.berchnungWirksamAb())), DateHelper.yesterday((Date)this.callib.berchnungWirksamAb()), this.callib.berchnungGueltigAb(), DateHelper.getLastDayOfMonth((Date)this.callib.berchnungGueltigAb()), ValueTypeHelper.getValueTypes((int[])new int[]{100901, 100902, 100903, 100906, 100907, 100908}))) {
            BigDecimal result;
            ValuePosition parentVP;
            if (vPos == null || (parentVP = this.getValuePositionFromParent(vPos)) == null || !this.isParentRelevant(parentVP)) continue;
            if (parentVP.getValueType().getValueTypeKey() != 99991 && parentVP.getValueType().getValueTypeKey() != 99992) {
                result = vPos.getResult();
                switch (vPos.getValueType().getValueTypeKey()) {
                    case 100901: {
                        zvkBruttoLfdAlt = zvkBruttoLfdAlt.add(result);
                        break;
                    }
                    case 100902: {
                        zvkBruttoFiktiveAlt = zvkBruttoFiktiveAlt.add(result);
                        break;
                    }
                    case 100903: 
                    case 100908: {
                        zvkBruttoSdZAlt = zvkBruttoSdZAlt.add(result);
                    }
                }
                continue;
            }
            result = vPos.getResult();
            switch (vPos.getValueType().getValueTypeKey()) {
                case 100906: {
                    if (vPos.getPersistentBuffer5() != null && vPos.getPersistentBuffer5().equals(BigDecimal.ONE)) {
                        zvkBruttoFiktivNachFJ = zvkBruttoFiktivNachFJ.add(result);
                        continue block15;
                    }
                    zvkBruttoLfdNachFJ = zvkBruttoLfdNachFJ.add(result);
                    continue block15;
                }
                case 100907: {
                    zvkBruttoSdZNachFJ = zvkBruttoSdZNachFJ.add(result);
                }
            }
        }
        BigDecimal resultZVKLfd = zvkBruttoLfdAlt.subtract(zvkBruttoLfdAkt).subtract(zvkBruttoLfdNachFJ);
        BigDecimal resultZVKFiktiv = zvkBruttoFiktiveAlt.subtract(zvkBruttoFiktiveAkt).subtract(zvkBruttoFiktivNachFJ);
        BigDecimal resultZVKSdZ = zvkBruttoSdZAlt.subtract(zvkBruttoSdZAkt).subtract(zvkBruttoSdZNachFJ);
        if (!(BigDecimalMapper.isZeroOrNull((BigDecimal)resultZVKLfd) && BigDecimalMapper.isZeroOrNull((BigDecimal)resultZVKFiktiv) && BigDecimalMapper.isZeroOrNull((BigDecimal)resultZVKSdZ))) {
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)resultZVKLfd)) {
                this.wplib.addNeueWertPosition(100901, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, resultZVKLfd, false, (PersistentObject)this.wplib.wertPosition());
                this.wplib.addNeueWertPosition(100906, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, resultZVKLfd.negate(), false, (PersistentObject)this.wplib.wertPosition());
            }
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)resultZVKFiktiv)) {
                this.wplib.addNeueWertPosition(100902, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, resultZVKFiktiv, false, (PersistentObject)this.wplib.wertPosition());
                ValuePosition newVP = this.wplib.wertPosition().create(ValueType.getValueType((int)100906), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, resultZVKFiktiv.negate());
                if (newVP != null) {
                    newVP.setPersistentBuffer5(BigDecimal.ONE);
                    newVP.setGenesisOfParentObjects(this.wplib.wertPosition());
                    newVP.setParentObject(this.wplib.wertPosition());
                    ValuePositionHistory vpHistory = this.callib.getCalculationCase().getValuePositionHistory();
                    vpHistory.addItem(newVP);
                    vpHistory.sort();
                }
            }
            if (!BigDecimalMapper.isZeroOrNull((BigDecimal)resultZVKSdZ)) {
                this.wplib.addNeueWertPosition(100903, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, resultZVKSdZ, false, (PersistentObject)this.wplib.wertPosition());
                this.wplib.addNeueWertPosition(100907, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, resultZVKSdZ.negate(), false, (PersistentObject)this.wplib.wertPosition());
            }
            BigDecimal resultGesamt = resultZVKLfd.add(resultZVKSdZ).add(resultZVKFiktiv);
            this.callib.result(resultGesamt);
            this.callib.setKenzeichenZVKRR(true);
        } else {
            this.wplib.loescheWertPosition(this.wplib.wertPosition());
        }
    }

    private ValuePosition getValuePositionFromParent(ValuePosition vp) {
        ValuePosition result = null;
        PersistentObject parent = vp.getParentObject();
        if (parent instanceof ValuePosition) {
            result = (ValuePosition)parent;
        }
        return result;
    }

    private boolean isParentRelevant(ValuePosition parentVP) {
        return parentVP.getValueType().getValueTypeKey() != 99991 || !(parentVP.getGenesisOfParentObjects() instanceof VarPaymentTP);
    }

    private void ermittelFolgejahr() throws BusinessDomainException {
        BigDecimal zvkBruttoLfdAlt = BigDecimal.ZERO;
        BigDecimal zvkBruttoSdZAlt = BigDecimal.ZERO;
        BigDecimal zvkBruttoLfdAkt = BigDecimal.ZERO;
        BigDecimal zvkBruttoSdZAkt = BigDecimal.ZERO;
        if (DateHelper.before((Date)this.wplib.gueltigBis(), (Date)this.wplib.wirksamAb())) {
            ValuePosition[] vpArray;
            block12: for (ValuePosition vPos : vpArray = this.wplib.wpAusWPListeOderDB(DateHelper.getFirstDayOfMonth((Date)DateHelper.yesterday((Date)this.wplib.wirksamAb())), DateHelper.yesterday((Date)this.wplib.wirksamAb()), DateHelper.getFirstDayOfMonth((Date)this.wplib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.wplib.gueltigAb()), ValueTypeHelper.getValueTypes((int[])new int[]{100901, 100903, 100908}))) {
                ValuePosition genesisVP;
                if (vPos == null || (genesisVP = vPos.getValuePositionFromGenesisParent()) == null || genesisVP.getValueType().getValueTypeKey() != 99992) continue;
                BigDecimal result = vPos.getResult();
                switch (vPos.getValueType().getValueTypeKey()) {
                    case 100901: {
                        zvkBruttoLfdAkt = zvkBruttoLfdAkt.add(result);
                        continue block12;
                    }
                    case 100903: 
                    case 100908: {
                        zvkBruttoSdZAkt = zvkBruttoSdZAkt.add(result);
                    }
                }
            }
        } else {
            Date suchdatum = CalculationBasicPersistencyManager.getDateOfReverseProjection((String)this.eelib.marb().getObjectid(), (Date)this.eelib.marb().getJournalizedUntil());
            Date pruefungsende = DateHelper.yesterday((Date)DateHelper.getFirstDayOfYear((Date)this.wplib.gueltigAb()));
            while (DateHelper.before((Date)suchdatum, (Date)pruefungsende)) {
                ValuePosition[] vpArray;
                block14: for (ValuePosition vPos : vpArray = this.wplib.wpAusWPListeOderDB(DateHelper.getFirstDayOfMonth((Date)DateHelper.yesterday((Date)this.wplib.wirksamAb())), DateHelper.yesterday((Date)this.wplib.wirksamAb()), suchdatum, DateHelper.getLastDayOfMonth((Date)suchdatum), ValueTypeHelper.getValueTypes((int[])new int[]{100906, 100907}))) {
                    switch (vPos.getValueType().getValueTypeKey()) {
                        case 100906: {
                            zvkBruttoLfdAlt = zvkBruttoLfdAlt.add(vPos.getResult());
                            continue block14;
                        }
                        case 100907: {
                            zvkBruttoSdZAlt = zvkBruttoSdZAlt.add(vPos.getResult());
                            continue block14;
                        }
                    }
                }
                block15: for (ValuePosition vPos : vpArray = this.wplib.wpAusWPListeOderDB(this.wplib.wirksamAb(), this.wplib.wirksamBis(), suchdatum, DateHelper.getLastDayOfMonth((Date)suchdatum), ValueTypeHelper.getValueTypes((int[])new int[]{100906, 100907}))) {
                    switch (vPos.getValueType().getValueTypeKey()) {
                        case 100906: {
                            zvkBruttoLfdAkt = zvkBruttoLfdAkt.add(vPos.getResult());
                            continue block15;
                        }
                        case 100907: {
                            zvkBruttoSdZAkt = zvkBruttoSdZAkt.add(vPos.getResult());
                        }
                    }
                }
                suchdatum = DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)suchdatum));
            }
        }
        BigDecimal resultZVKLfd = zvkBruttoLfdAkt.subtract(zvkBruttoLfdAlt);
        BigDecimal resultZVKSdZ = zvkBruttoSdZAkt.subtract(zvkBruttoSdZAlt);
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)resultZVKLfd) || !BigDecimalMapper.isZeroOrNull((BigDecimal)resultZVKSdZ)) {
            BigDecimal resultGesamt = resultZVKLfd.add(resultZVKSdZ);
            this.wplib.addNeueWertPosition(100903, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, resultGesamt, false, (PersistentObject)this.wplib.wertPosition());
            this.wplib.addNeueWertPosition(110610, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, false, (PersistentObject)this.wplib.wertPosition());
            this.wplib.addNeueWertPosition(130610, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, false, (PersistentObject)this.wplib.wertPosition());
            this.callib.result(resultGesamt);
        } else {
            this.wplib.loescheWertPosition(this.wplib.wertPosition());
        }
    }
}

