/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.evaluation.formula;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.employee.insurance.MultiplyEmploymentEnum;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.evaluation.library.CalculationLibrary;
import com.varial.personnel.domain.evaluation.library.EmployeeLibrary;
import com.varial.personnel.domain.evaluation.library.GlobalLibrary;
import com.varial.personnel.domain.evaluation.library.ValuePositionLibrary;
import com.varial.personnel.domain.evaluation.mapper.EvaluationExceptionMapper;
import com.varial.personnel.domain.evaluation.mapper.ValueTypeHelper;
import com.varial.personnel.domain.typeofvalue.ValueType;
import com.varial.personnel.framework.mapper.FrameWorkExceptionMapper;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;

public class ErmittlungRVEntgeltEGAFormula {
    private static final BigDecimal DREISSIG = BigDecimal.valueOf(30L);
    private final CalculationLibrary mCalLib;
    private final EmployeeLibrary mEeLib;
    private final GlobalLibrary mGlLib;
    private final ValuePositionLibrary mVpLib;
    private BigDecimal mSummeRVEntgeltLfd = BigDecimal.ZERO;
    private BigDecimal mSummeRVEntgeltEGA = BigDecimal.ZERO;
    private BigDecimal mSummeRVEntgeltLfdAndererAG = BigDecimal.ZERO;
    private BigDecimal mSummeRVEntgeltEGAAndererAG = BigDecimal.ZERO;

    public ErmittlungRVEntgeltEGAFormula(CalculationLibrary calculationLibrary, EmployeeLibrary employeeLibrary, GlobalLibrary globalLibrary, ValuePositionLibrary valuePositionLibrary) {
        this.mCalLib = calculationLibrary;
        this.mEeLib = employeeLibrary;
        this.mGlLib = globalLibrary;
        this.mVpLib = valuePositionLibrary;
    }

    public void ermittel() throws BusinessDomainException {
        BigDecimal aktuellesEGA = this.mVpLib.result();
        ValuePosition[] aufgelaufenesEntgeltImMonat = this.ermittleRVEntgeltImMonat();
        if (this.mVpLib.result().compareTo(BigDecimal.ZERO) < 0) {
            BigDecimal ueberBBG = BigDecimal.ZERO;
            for (ValuePosition lElement : aufgelaufenesEntgeltImMonat) {
                if (lElement.getBufferResult() == null) continue;
                ueberBBG = ueberBBG.add(lElement.getBufferResult());
            }
            if (ueberBBG.compareTo(this.mVpLib.result().negate()) > 0) {
                this.mVpLib.wertPosition().setBufferResult(this.mVpLib.result());
                aktuellesEGA = BigDecimal.ZERO;
            } else {
                this.mVpLib.wertPosition().setBufferResult(ueberBBG.negate());
                aktuellesEGA = this.mVpLib.result().add(ueberBBG);
            }
        }
        BigDecimal fiktivesArbeitsentgelt = BigDecimal.valueOf(0L);
        if (this.mEeLib.isMarbGeringverdiener() && this.mVpLib.svTage().compareTo(DREISSIG) != 0) {
            if (this.mVpLib.svTage().compareTo(BigDecimal.ZERO) != 0) {
                fiktivesArbeitsentgelt = this.mSummeRVEntgeltLfd.multiply(DREISSIG).divide(this.mVpLib.svTage(), 2, RoundingMode.HALF_UP).subtract(this.mSummeRVEntgeltLfd);
                this.mVpLib.addNeueWertPosition(327520, BigDecimal.ZERO, BigDecimal.ZERO, this.mVpLib.svTage(), BigDecimal.ZERO, fiktivesArbeitsentgelt, true);
            }
            this.mSummeRVEntgeltLfd = this.mSummeRVEntgeltLfd.add(fiktivesArbeitsentgelt);
        }
        if (!(this.mEeLib.isMarbGeringverdiener() && this.mSummeRVEntgeltLfd.compareTo(this.mGlLib.svGeringverdienerGrenze()) <= 0 || this.mEeLib.marbPgs() == 122 && this.mEeLib.isPGS122Geringverdiener() || this.mEeLib.isBufdi())) {
            this.bewerteNormal(aktuellesEGA);
        } else {
            this.bewerteGfB(aktuellesEGA);
        }
    }

    private void bewerteGfB(BigDecimal aktuellesEGA) throws BusinessDomainException {
        BigDecimal rvEntgeltEGA = BigDecimal.ZERO;
        if (this.mEeLib.marbBgrRv() == 1 || this.mEeLib.marbBgrRv() == 2 || this.mEeLib.marbBgrRv() == 3) {
            if (this.mEeLib.marbPgs() == 122 || this.mEeLib.isBufdi()) {
                this.mVpLib.addNeueWertPosition(329620, aktuellesEGA);
            } else if (this.mSummeRVEntgeltLfd.add(this.mSummeRVEntgeltEGA).compareTo(this.mGlLib.svGeringverdienerGrenze()) <= 0) {
                BigDecimal rvLuft = this.mGlLib.svGeringverdienerGrenze().subtract(this.mSummeRVEntgeltLfd.add(this.mSummeRVEntgeltEGA));
                if (rvLuft.compareTo(BigDecimal.ZERO) < 0) {
                    rvLuft = BigDecimal.ZERO;
                }
                if (rvLuft.compareTo(aktuellesEGA) >= 0) {
                    this.mVpLib.addNeueWertPosition(329620, aktuellesEGA);
                } else {
                    this.mVpLib.addNeueWertPosition(329620, rvLuft);
                    this.mVpLib.addNeueWertPosition(328610, aktuellesEGA.subtract(rvLuft));
                    this.mVpLib.addNeueWertPosition(329610, aktuellesEGA.subtract(rvLuft));
                    rvEntgeltEGA = aktuellesEGA;
                }
            } else {
                this.mVpLib.addNeueWertPosition(328610, aktuellesEGA);
                this.mVpLib.addNeueWertPosition(329610, aktuellesEGA);
            }
            rvEntgeltEGA = aktuellesEGA;
        }
        this.mCalLib.result(rvEntgeltEGA);
        BigDecimal rvTage = this.mVpLib.rvTageMarb();
        this.mCalLib.factor1(rvTage);
        this.modifiziereUmlage(rvEntgeltEGA, rvTage);
    }

    private void bewerteNormal(BigDecimal aktuellesEGA) throws BusinessDomainException {
        boolean mfb = false;
        boolean isMfBUndVersorgung = false;
        if (this.mEeLib.isMehrfachbeschaeftigt()) {
            switch (this.mEeLib.marbVersorgungsart().value()) {
                case 1: 
                case 2: 
                case 3: {
                    if (this.mEeLib.marbBgrRvAndererAG() != 0 || this.mEeLib.marbBgrRv() != 0 || this.mEeLib.marbMehrfachBeschaeftigung() == MultiplyEmploymentEnum.MEE_BEITRAGSTEILUNG_OHNE_BV || this.mEeLib.marbMehrfachBeschaeftigung() == MultiplyEmploymentEnum.MEE_BEITRAGSTEILUNG_UND_ANDERER_RECHTSKREIS_OHNE_BV) break;
                    isMfBUndVersorgung = true;
                }
            }
            mfb = true;
        }
        boolean dbbgVorhanden = false;
        boolean mfbOhneDBBG = false;
        if ((this.mEeLib.marbBgrRvAndererAG() == 1 && this.mEeLib.marbBgrRv() == 1 || this.mEeLib.marbBgrRvAndererAG() == 3 && this.mEeLib.marbBgrRv() == 3) && (this.mEeLib.marbBgrKvAndererAG() != 6 || this.mEeLib.marbBgrKv() != 6) && mfb || isMfBUndVersorgung) {
            if (DateHelper.afterOrEqual((Date)this.mCalLib.berchnungGueltigAb(), (Date)new VDate(2013, 0, 1).getDate()) && (dbbgVorhanden = isMfBUndVersorgung && DateHelper.afterOrEqual((Date)this.mCalLib.berchnungGueltigAb(), (Date)new VDate(2020, 0, 1).getDate()) ? false : this.mCalLib.dbbgVorhanden()) && DateHelper.afterOrEqual((Date)this.mCalLib.berchnungGueltigAb(), (Date)new VDate(2015, 0, 1).getDate()) && !StringMapper.equal((String)this.mCalLib.dbbgRVEBBG(), (String)"J")) {
                dbbgVorhanden = false;
            }
            if (!dbbgVorhanden) {
                mfbOhneDBBG = true;
                if (DateHelper.afterOrEqual((Date)this.mCalLib.berchnungGueltigAb(), (Date)new VDate(2013, 0, 1).getDate())) {
                    this.ermittleFremdentgelt2013();
                } else {
                    this.ermittleFremdentgelt();
                }
            }
        }
        BigDecimal aufgelaufenesRVPflichtigeEntgelt = BigDecimal.ZERO;
        boolean beitragspflichtig = this.mEeLib.marb().isContributory(this.mCalLib.berchnungWirksamAb(), this.mCalLib.berchnungGueltigAb());
        aufgelaufenesRVPflichtigeEntgelt = DateHelper.afterOrEqual((Date)this.mCalLib.berchnungGueltigAb(), (Date)new VDate(2013, 0, 1).getDate()) ? this.holeAufgelaufenesRVPflichtigesEntgelt2013(beitragspflichtig, mfb).add(this.mSummeRVEntgeltLfd).add(this.mSummeRVEntgeltLfdAndererAG) : this.holeAufgelaufenesRVPflichtigesEntgelt(mfbOhneDBBG).add(this.mSummeRVEntgeltLfd).add(this.mSummeRVEntgeltLfdAndererAG).add(this.mSummeRVEntgeltEGA);
        BigDecimal rvTage = this.mVpLib.summeRVTageFuerEGA(beitragspflichtig);
        BigDecimal rvBBG = this.mVpLib.aufgelBbgRv(beitragspflichtig);
        BigDecimal rvLuft = rvBBG.subtract(aufgelaufenesRVPflichtigeEntgelt);
        if (DateHelper.afterOrEqual((Date)this.mCalLib.berchnungGueltigAb(), (Date)new VDate(2013, 0, 1).getDate())) {
            if (dbbgVorhanden) {
                if (BigDecimalMapper.compareTo((BigDecimal)this.mCalLib.dbbgEGARV(), (BigDecimal)this.mSummeRVEntgeltEGA.add(aktuellesEGA)) < 0) {
                    BigDecimal temp1 = rvLuft.subtract(this.mSummeRVEntgeltEGA);
                    rvLuft = this.mCalLib.dbbgEGARV().subtract(this.mSummeRVEntgeltEGA);
                    if (aktuellesEGA.compareTo(rvLuft) > 0) {
                        BigDecimal diff = aktuellesEGA.subtract(rvLuft);
                        BigDecimal diff2 = temp1.subtract(aktuellesEGA);
                        if (diff2.compareTo(BigDecimal.ZERO) < 0) {
                            diff = diff.add(diff2);
                        }
                        if (!BigDecimalMapper.isZero((BigDecimal)diff)) {
                            this.mVpLib.addNeueWertPosition(327695, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, diff, false);
                        }
                    }
                } else {
                    rvLuft = rvLuft.subtract(this.mSummeRVEntgeltEGA);
                }
            } else {
                rvLuft = rvLuft.subtract(this.mSummeRVEntgeltEGA);
            }
        }
        if (rvLuft.compareTo(BigDecimal.ZERO) < 0) {
            rvLuft = BigDecimal.ZERO;
        }
        if (mfbOhneDBBG && DateHelper.before((Date)this.mCalLib.berchnungGueltigAb(), (Date)new VDate(2013, 0, 1).getDate()) && rvLuft.compareTo(aktuellesEGA.add(this.mSummeRVEntgeltEGA).add(this.mSummeRVEntgeltEGAAndererAG)) < 0) {
            rvLuft = rvLuft.multiply(aktuellesEGA.add(this.mSummeRVEntgeltEGA)).divide(aktuellesEGA.add(this.mSummeRVEntgeltEGA).add(this.mSummeRVEntgeltEGAAndererAG), 2, RoundingMode.HALF_UP);
        }
        BigDecimal rvEntgeltEGA = BigDecimal.ZERO;
        if (rvLuft.compareTo(aktuellesEGA) >= 0) {
            rvEntgeltEGA = aktuellesEGA;
        } else {
            rvEntgeltEGA = rvLuft;
            this.mVpLib.wertPosition().setBufferResult(aktuellesEGA.subtract(rvLuft));
        }
        this.mCalLib.result(rvEntgeltEGA);
        this.mCalLib.factor1(rvTage);
        this.modifiziereUmlage(rvEntgeltEGA, rvTage);
        this.erzeugeWertpositionNormal(rvEntgeltEGA, rvTage);
    }

    private void erzeugeWertpositionNormal(BigDecimal rvEntgeltEGA, BigDecimal rvTage) throws BusinessDomainException {
        BigDecimal rvBBG = this.ermittleRVBbg(rvTage);
        if (this.mEeLib.isBehinderterMA()) {
            BigDecimal percentage = this.mVpLib.prozentsatz();
            switch (this.mEeLib.marbBgrRv()) {
                case 1: 
                case 2: {
                    if (BigDecimalMapper.compareTo((BigDecimal)percentage, (BigDecimal)BigDecimal.valueOf(100L)) == 0) {
                        this.mVpLib.addNeueWertPosition(329620, rvEntgeltEGA);
                        break;
                    }
                    this.mVpLib.addNeueWertPosition(328610, rvEntgeltEGA);
                    this.mVpLib.addNeueWertPosition(329610, rvEntgeltEGA);
                }
            }
        } else {
            switch (this.mEeLib.marbBgrRv()) {
                case 0: {
                    if (!DateHelper.afterOrEqual((Date)this.mCalLib.berchnungGueltigAb(), (Date)new VDate(2011, 0, 1).getDate()) || this.mEeLib.marbVersorgungsart().value() == 0) break;
                    if (this.mEeLib.marbBgrKv() == 6) {
                        if (this.mEeLib.marbVerzichtRvReduzierung()) {
                            this.mVpLib.addNeueWertPosition(328512, rvEntgeltEGA);
                        }
                        this.mVpLib.addNeueWertPosition(329512, rvEntgeltEGA);
                        break;
                    }
                    if (this.mEeLib.marbPgs() != 109) {
                        this.mVpLib.addNeueWertPosition(327690, BigDecimal.ZERO, BigDecimal.ZERO, rvTage, BigDecimal.ZERO, rvBBG, true);
                        this.mVpLib.addNeueWertPosition(328610, rvEntgeltEGA);
                        this.mVpLib.addNeueWertPosition(329610, rvEntgeltEGA);
                        break;
                    }
                    this.mVpLib.addNeueWertPosition(328512, rvEntgeltEGA);
                    this.mVpLib.addNeueWertPosition(329512, rvEntgeltEGA);
                    break;
                }
                case 1: 
                case 2: {
                    if (this.mEeLib.marbPgs() != 109) {
                        this.mVpLib.addNeueWertPosition(327690, BigDecimal.ZERO, BigDecimal.ZERO, rvTage, BigDecimal.ZERO, rvBBG, true);
                        this.mVpLib.addNeueWertPosition(328610, rvEntgeltEGA);
                        this.mVpLib.addNeueWertPosition(329610, rvEntgeltEGA);
                        break;
                    }
                    this.mVpLib.addNeueWertPosition(328512, rvEntgeltEGA);
                    this.mVpLib.addNeueWertPosition(329512, rvEntgeltEGA);
                    break;
                }
                case 3: {
                    this.mVpLib.addNeueWertPosition(327690, BigDecimal.ZERO, BigDecimal.ZERO, rvTage, BigDecimal.ZERO, rvBBG, true);
                    this.mVpLib.addNeueWertPosition(329610, rvEntgeltEGA);
                    break;
                }
                case 5: 
                case 6: {
                    this.mVpLib.addNeueWertPosition(329512, rvEntgeltEGA);
                    break;
                }
            }
        }
    }

    private void ermittleFremdentgelt() throws BusinessDomainException {
        ValuePosition[] lAufgelaufenesEntgeltImMonat;
        block4: for (ValuePosition vp : lAufgelaufenesEntgeltImMonat = this.mVpLib.wpAusWPListeBisUebergebeneWP(this.mVpLib.wirksamAb(), this.mVpLib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.mVpLib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.mVpLib.gueltigAb()), this.mVpLib.wertPosition(), ValueTypeHelper.getValueTypes((int[])new int[]{129200, 129205, 129210, 129215}))) {
            switch (vp.getValueType().getValueTypeKey()) {
                case 129200: 
                case 129205: {
                    this.mSummeRVEntgeltLfdAndererAG = this.mSummeRVEntgeltLfdAndererAG.add(vp.getResult());
                    continue block4;
                }
                case 129210: 
                case 129215: {
                    this.mSummeRVEntgeltEGAAndererAG = this.mSummeRVEntgeltEGAAndererAG.add(vp.getResult());
                    continue block4;
                }
                default: {
                    throw EvaluationExceptionMapper.makeWrongValueTypeDomaineException(this.getClass().getName(), vp.getValueType().getValueTypeKey());
                }
            }
        }
    }

    private void ermittleFremdentgelt2013() throws BusinessDomainException {
        ValuePosition[] lAufgelaufenesEntgeltImMonat = this.mVpLib.wpAusWPListeBisUebergebeneWP(this.mVpLib.wirksamAb(), this.mVpLib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.mVpLib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.mVpLib.gueltigAb()), this.mVpLib.wertPosition(), ValueTypeHelper.getValueTypes((int[])new int[]{129200, 129205, 129210, 129215, 327595, 327596, 327695}));
        BigDecimal temp1 = BigDecimal.ZERO;
        BigDecimal temp2 = BigDecimal.ZERO;
        BigDecimal temp3 = BigDecimal.ZERO;
        BigDecimal temp4 = BigDecimal.ZERO;
        block6: for (ValuePosition vp : lAufgelaufenesEntgeltImMonat) {
            switch (vp.getValueType().getValueTypeKey()) {
                case 129200: 
                case 129205: {
                    temp1 = temp1.add(vp.getResult());
                    continue block6;
                }
                case 129210: 
                case 129215: {
                    temp2 = temp2.add(vp.getResult());
                    continue block6;
                }
                case 327595: 
                case 327596: {
                    temp3 = temp3.add(vp.getResult());
                    continue block6;
                }
                case 327695: {
                    temp4 = temp4.add(vp.getResult());
                    continue block6;
                }
                default: {
                    throw EvaluationExceptionMapper.makeWrongValueTypeDomaineException(this.getClass().getName(), vp.getValueType().getValueTypeKey());
                }
            }
        }
        this.mSummeRVEntgeltLfdAndererAG = temp3.compareTo(BigDecimal.ZERO) != 0 ? this.mSummeRVEntgeltLfdAndererAG.add(temp3) : this.mSummeRVEntgeltLfdAndererAG.add(temp1);
        this.mSummeRVEntgeltEGAAndererAG = temp4.compareTo(BigDecimal.ZERO) != 0 ? this.mSummeRVEntgeltEGAAndererAG.add(temp4) : this.mSummeRVEntgeltEGAAndererAG.add(temp2);
    }

    private ValuePosition[] ermittleRVEntgeltImMonat() throws BusinessDomainException {
        ValuePosition[] aufgelaufenesEntgeltImMonat;
        for (ValuePosition vp : aufgelaufenesEntgeltImMonat = this.mVpLib.wpAusWPListeBisUebergebeneWP(this.mVpLib.wirksamAb(), this.mVpLib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.mVpLib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.mVpLib.gueltigAb()), this.mVpLib.wertPosition(), ValueTypeHelper.getValueTypes((int[])new int[]{327510, 327720, 327740, 327550, 327555}))) {
            this.mSummeRVEntgeltLfd = this.mSummeRVEntgeltLfd.add(vp.getResult());
        }
        for (ValuePosition vPos : aufgelaufenesEntgeltImMonat = this.mVpLib.wpAusWPListeBisUebergebeneWP(this.mCalLib.berchnungWirksamAb(), DateHelper.getLastDayOfMonth((Date)this.mCalLib.berchnungWirksamAb()), this.mCalLib.berchnungGueltigAb(), DateHelper.getLastDayOfMonth((Date)this.mCalLib.berchnungGueltigAb()), this.mVpLib.wertPosition(), ValueTypeHelper.getValueTypes((int[])new int[]{327610}))) {
            this.mSummeRVEntgeltEGA = this.mSummeRVEntgeltEGA.add(vPos.getResult());
        }
        return aufgelaufenesEntgeltImMonat;
    }

    private BigDecimal ermittleRVBbg(BigDecimal rvTage) throws BusinessDomainException {
        BigDecimal rvBBG = BigDecimal.ZERO;
        switch (this.mGlLib.krkTyp()) {
            case 6: {
                if (this.mEeLib.marbErhBeitrErmKnappschRV()) {
                    if (rvTage.compareTo(DREISSIG) != 0) {
                        rvBBG = this.mGlLib.svBbgKnappschaft().multiply(rvTage).divide(DREISSIG, 2, RoundingMode.HALF_UP);
                        break;
                    }
                    rvBBG = this.mGlLib.svBbgKnappschaft();
                    break;
                }
            }
            default: {
                rvBBG = rvTage.compareTo(DREISSIG) != 0 ? this.mGlLib.svBbgRvAv().multiply(rvTage).divide(DREISSIG, 2, RoundingMode.HALF_UP) : this.mGlLib.svBbgRvAv();
            }
        }
        return rvBBG;
    }

    private BigDecimal holeAufgelaufenesRVPflichtigesEntgelt2013(boolean beitragspflichtig, boolean mfb) throws BusinessDomainException {
        BigDecimal result = BigDecimal.ZERO;
        Date suchDatum = DateHelper.getFirstDayOfYear((Date)this.mVpLib.gueltigAb());
        ValueType[] vtArray = new ValueType[]{};
        while (DateHelper.before((Date)suchDatum, (Date)DateHelper.getFirstDayOfMonth((Date)this.mVpLib.gueltigAb()))) {
            if (this.mEeLib.marb().isContributory(this.mCalLib.berchnungWirksamAb(), suchDatum) == beitragspflichtig) {
                ValuePosition[] alteVP;
                vtArray = ValueTypeHelper.getValueTypes((int[])new int[]{327510, 327610, 327616, 327720, 327740, 327655, 327665, 327675, 327550, 327555, 327730, 773510, 773610, 773616, 773720, 773740, 773655, 773665, 773675, 773550, 773555, 773730});
                block4: for (ValuePosition vp : alteVP = this.mVpLib.wpAusWPListeOderDB(this.mVpLib.wirksamAb(), this.mVpLib.wirksamBis(), suchDatum, DateHelper.getLastDayOfMonth((Date)suchDatum), vtArray)) {
                    if (DateHelper.after((Date)vp.getEffectiveFrom(), (Date)this.mVpLib.wirksamAb())) continue;
                    switch (vp.getValueType().getValueTypeKey()) {
                        case 327730: {
                            result = result.add(vp.getResult().subtract(vp.getPersistentBuffer1()));
                            continue block4;
                        }
                        default: {
                            result = result.add(vp.getResult());
                        }
                    }
                }
                if (mfb) {
                    for (ValuePosition vPos : alteVP = this.mVpLib.wpAusWPListeOderDB(this.mVpLib.wirksamAb(), this.mVpLib.wirksamBis(), suchDatum, DateHelper.getLastDayOfMonth((Date)suchDatum), ValueTypeHelper.getValueTypes((int[])new int[]{327595, 327596, 327695, 773595, 773596, 773695}))) {
                        result = result.add(vPos.getResult());
                    }
                }
            }
            suchDatum = DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)suchDatum));
        }
        result = result.add(this.mEeLib.vortragSozialVersicherungRVEntgelt(this.mVpLib.gueltigAb()));
        return result;
    }

    private void modifiziereUmlage(BigDecimal rvEntgeltEGA, BigDecimal rvTage) throws BusinessDomainException {
        ValuePosition vp = this.mVpLib.folgeWertartVomGenesis(360200);
        if (vp != null) {
            vp.setResult(rvEntgeltEGA);
            vp.setFactor1(rvTage);
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private BigDecimal holeAufgelaufenesRVPflichtigesEntgelt(boolean mfbOhneDBBG) throws BusinessDomainException {
        result = BigDecimal.ZERO;
        suchDatum = DateHelper.getFirstDayOfYear((Date)this.mVpLib.gueltigAb());
        vtArray = new ValueType[]{};
        while (DateHelper.before((Date)suchDatum, (Date)DateHelper.getFirstDayOfMonth((Date)this.mVpLib.gueltigAb()))) {
            vtArray = DateHelper.afterOrEqual((Date)suchDatum, (Date)new VDate(2011, 0, 1).getDate()) != false ? ValueTypeHelper.getValueTypes((int[])new int[]{327510, 327610, 327616, 327720, 327740, 327655, 327665, 327675, 327550, 327555, 327730, 773510, 773610, 773616, 773720, 773740, 773655, 773665, 773675, 773550, 773555, 773730}) : ValueTypeHelper.getValueTypes((int[])new int[]{327510, 327610, 327616, 327720, 327740, 327650, 327655, 327660, 327665, 327670, 327675, 327550, 327555, 327730});
            block9: for (ValuePosition[] vp : alteVP = this.mVpLib.wpAusWPListeOderDB(this.mVpLib.wirksamAb(), this.mVpLib.wirksamBis(), suchDatum, DateHelper.getLastDayOfMonth((Date)suchDatum), vtArray)) {
                if (DateHelper.after((Date)vp.getEffectiveFrom(), (Date)this.mVpLib.wirksamAb())) continue;
                switch (vp.getValueType().getValueTypeKey()) {
                    case 327730: {
                        result = result.add(vp.getResult().subtract(vp.getPersistentBuffer1()));
                        continue block9;
                    }
                    default: {
                        result = result.add(vp.getResult());
                    }
                }
            }
            if (DateHelper.afterOrEqual((Date)suchDatum, (Date)new VDate(2013, 0, 1).getDate())) {
                try {
                    svDatenMA = this.mEeLib.marb().getInsurance(this.mCalLib.berchnungWirksamAb(), suchDatum);
                    if (svDatenMA.getMultiplyEmployment() != MultiplyEmploymentEnum.MEE_BEITRAGSTEILUNG && svDatenMA.getMultiplyEmployment() != MultiplyEmploymentEnum.MEE_BEITRAGSTEILUNG_UND_ANDERER_RECHTSKREIS || svDatenMA.getDuesGroupPIOfOther() != 1 && svDatenMA.getDuesGroupPIOfOther() != 3 || svDatenMA.getHealthFund().getHealthFundTP(this.mCalLib.berchnungWirksamAb(), suchDatum).getTypeOfHealthFundEnum().value() == 6) ** GOTO lbl45
                    alteVP = this.mVpLib.wpAusWPListeOderDB(this.mVpLib.wirksamAb(), this.mVpLib.wirksamBis(), suchDatum, DateHelper.getLastDayOfMonth((Date)suchDatum), ValueTypeHelper.getValueTypes((int[])new int[]{129200, 129205, 129210, 129215, 327595, 327596, 327695}));
                    temp2 = BigDecimal.ZERO;
                    temp1 = BigDecimal.ZERO;
                    vp = alteVP;
                    var10_13 = vp.length;
                    block10: for (var11_14 = 0; var11_14 < var10_13; ++var11_14) {
                        vPos = vp[var11_14];
                        switch (vPos.getValueType().getValueTypeKey()) {
                            case 327595: 
                            case 327596: 
                            case 327695: {
                                temp2 = temp2.add(vPos.getResult());
                                continue block10;
                            }
                            default: {
                                temp1 = temp1.add(vPos.getResult());
                            }
                        }
                    }
                    if (BigDecimalMapper.isZeroOrNull((BigDecimal)temp2)) {
                        result = result.add(temp1);
                    }
                    result = result.add(temp2);
                }
                catch (BusinessDomainException e) {
                    if (FrameWorkExceptionMapper.isHistoryException((BusinessDomainException)e)) ** GOTO lbl45
                    throw e;
                }
            } else if (mfbOhneDBBG) {
                for (ValuePosition lElement : alteVP = this.mVpLib.wpAusWPListeOderDB(this.mVpLib.wirksamAb(), this.mVpLib.wirksamBis(), suchDatum, DateHelper.getLastDayOfMonth((Date)suchDatum), ValueTypeHelper.getValueTypes((int[])new int[]{129200, 129205, 129210, 129215}))) {
                    result = result.add(lElement.getResult());
                }
            }
lbl45:
            // 7 sources

            suchDatum = DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)suchDatum));
        }
        result = result.add(this.mEeLib.vortragSozialVersicherungRVEntgelt(this.mVpLib.gueltigAb()));
        return result;
    }
}

