/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.evaluation.formula;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.employee.valueposition.ValuePosition;
import com.varial.personnel.domain.evaluation.library.CalculationLibrary;
import com.varial.personnel.domain.evaluation.library.EmployeeLibrary;
import com.varial.personnel.domain.evaluation.library.GlobalLibrary;
import com.varial.personnel.domain.evaluation.library.ValuePositionLibrary;
import com.varial.personnel.domain.evaluation.mapper.ValueTypeHelper;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;

public class ErmittlungKVEntgeltEGAFormula {
    private static final BigDecimal DREISSIG = BigDecimal.valueOf(30L);
    private final CalculationLibrary mCalLib;
    private final EmployeeLibrary mEeLib;
    private final GlobalLibrary mGlLib;
    private final ValuePositionLibrary mVpLib;
    private BigDecimal mSummeKVEntgeltLfd = BigDecimal.ZERO;
    private BigDecimal mSummeKVEntgeltEGA = BigDecimal.ZERO;
    private BigDecimal mSummeKVEntgeltEGAAndererAG = BigDecimal.ZERO;
    private BigDecimal mSummeKVEntgeltLfdAndererAG = BigDecimal.ZERO;

    public ErmittlungKVEntgeltEGAFormula(CalculationLibrary calLib, EmployeeLibrary eeLib, GlobalLibrary glLib, ValuePositionLibrary wpLib) {
        this.mCalLib = calLib;
        this.mEeLib = eeLib;
        this.mGlLib = glLib;
        this.mVpLib = wpLib;
    }

    public void ermittel() throws BusinessDomainException {
        BigDecimal aktuellesEGA = this.mVpLib.result();
        ValuePosition[] aufgelKVEntgelt = this.ermittleKVEntgeltImMonat();
        if (this.mVpLib.result().compareTo(BigDecimal.ZERO) < 0) {
            BigDecimal ueberBBG = BigDecimal.ZERO;
            for (ValuePosition element : aufgelKVEntgelt) {
                if (element.getBufferResult() == null) continue;
                ueberBBG = ueberBBG.add(element.getBufferResult());
            }
            if (ueberBBG.compareTo(this.mVpLib.result().negate()) > 0) {
                this.mVpLib.wertPosition().setBasicResult(this.mVpLib.result());
                aktuellesEGA = BigDecimal.ZERO;
            } else {
                this.mVpLib.wertPosition().setBufferResult(ueberBBG.negate());
                aktuellesEGA = this.mVpLib.result().add(ueberBBG);
            }
        }
        BigDecimal fiktivesArbeitsentgelt = BigDecimal.ZERO;
        if (this.mEeLib.isMarbGeringverdiener() && this.mVpLib.svTage().compareTo(DREISSIG) != 0) {
            if (this.mVpLib.svTage().compareTo(BigDecimal.ZERO) != 0) {
                fiktivesArbeitsentgelt = this.mSummeKVEntgeltLfd.multiply(DREISSIG).divide(this.mVpLib.svTage(), 2, RoundingMode.HALF_UP).subtract(this.mSummeKVEntgeltLfd);
                this.mVpLib.addNeueWertPosition(321520, BigDecimal.ZERO, BigDecimal.ZERO, this.mVpLib.svTage(), BigDecimal.ZERO, fiktivesArbeitsentgelt, true);
            }
            this.mSummeKVEntgeltLfd = this.mSummeKVEntgeltLfd.add(fiktivesArbeitsentgelt);
        }
        if (!(this.mEeLib.isMarbGeringverdiener() && this.mSummeKVEntgeltLfd.compareTo(this.mGlLib.svGeringverdienerGrenze()) <= 0 || this.mEeLib.marbPgs() == 122 && this.mEeLib.isPGS122Geringverdiener() || this.mEeLib.isBufdi())) {
            this.bewerteNormal(aktuellesEGA);
        } else {
            this.bewerteGfB(aktuellesEGA);
        }
    }

    private ValuePosition[] ermittleKVEntgeltImMonat() throws BusinessDomainException {
        ValuePosition[] aufgelKVEntgelt;
        for (ValuePosition valuePosition : aufgelKVEntgelt = this.mVpLib.wpAusWPListeBisUebergebeneWP(this.mVpLib.wirksamAb(), this.mVpLib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.mVpLib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.mVpLib.gueltigAb()), this.mVpLib.wertPosition(), ValueTypeHelper.getValueTypes((int[])new int[]{321510, 321720, 321740, 321725}))) {
            this.mSummeKVEntgeltLfd = this.mSummeKVEntgeltLfd.add(valuePosition.getResult());
        }
        for (ValuePosition valuePosition : aufgelKVEntgelt = this.mVpLib.wpAusWPListeBisUebergebeneWP(this.mVpLib.wirksamAb(), this.mVpLib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.mVpLib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.mVpLib.gueltigAb()), this.mVpLib.wertPosition(), ValueTypeHelper.getValueTypes((int[])new int[]{321610}))) {
            this.mSummeKVEntgeltEGA = this.mSummeKVEntgeltEGA.add(valuePosition.getResult());
        }
        return aufgelKVEntgelt;
    }

    private void bewerteGfB(BigDecimal aktuellesEGA) throws BusinessDomainException {
        BigDecimal kvEntgeltEGA = BigDecimal.ZERO;
        if (this.mEeLib.marbBgrKv() == 1 || this.mEeLib.marbBgrKv() == 2 || this.mEeLib.marbBgrKv() == 3) {
            if (this.mEeLib.marbPgs() == 122 || this.mEeLib.isBufdi()) {
                this.mVpLib.addNeueWertPosition(323620, aktuellesEGA);
                this.mVpLib.addNeueWertPosition(323625, aktuellesEGA);
            } else if (this.mSummeKVEntgeltLfd.add(this.mSummeKVEntgeltEGA).compareTo(this.mGlLib.svGeringverdienerGrenze()) <= 0) {
                BigDecimal kvLuft = this.mGlLib.svGeringverdienerGrenze().subtract(this.mSummeKVEntgeltLfd.add(this.mSummeKVEntgeltEGA));
                if (kvLuft.compareTo(BigDecimal.ZERO) < 0) {
                    kvLuft = BigDecimal.ZERO;
                }
                if (kvLuft.compareTo(aktuellesEGA) >= 0) {
                    this.mVpLib.addNeueWertPosition(323620, aktuellesEGA);
                } else if (DateHelper.afterOrEqual((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2015, 0, 1).getDate())) {
                    this.mVpLib.addNeueWertPosition(323620, kvLuft);
                    this.mVpLib.addNeueWertPosition(323625, BigDecimal.valueOf(100L), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, kvLuft, false);
                    this.mVpLib.addNeueWertPosition(322610, aktuellesEGA.subtract(kvLuft));
                    this.mVpLib.addNeueWertPosition(322616, BigDecimal.valueOf(100L), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, aktuellesEGA.subtract(kvLuft), false);
                    this.mVpLib.addNeueWertPosition(323610, aktuellesEGA.subtract(kvLuft));
                    this.mVpLib.addNeueWertPosition(323615, BigDecimal.valueOf(100L), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, aktuellesEGA.subtract(kvLuft), false);
                } else {
                    this.mVpLib.addNeueWertPosition(323620, kvLuft);
                    this.mVpLib.addNeueWertPosition(322610, aktuellesEGA.subtract(kvLuft));
                    if (DateHelper.afterOrEqual((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2005, 6, 1).getDate())) {
                        this.mVpLib.addNeueWertPosition(322616, aktuellesEGA.subtract(kvLuft));
                        if (DateHelper.afterOrEqual((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2019, 0, 1).getDate())) {
                            this.mVpLib.addNeueWertPosition(323615, aktuellesEGA.subtract(kvLuft));
                        }
                    }
                    this.mVpLib.addNeueWertPosition(323610, aktuellesEGA.subtract(kvLuft));
                }
            } else {
                this.mVpLib.addNeueWertPosition(322610, aktuellesEGA);
                if (DateHelper.afterOrEqual((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2005, 6, 1).getDate())) {
                    this.mVpLib.addNeueWertPosition(322616, aktuellesEGA);
                    if (DateHelper.afterOrEqual((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2019, 0, 1).getDate())) {
                        this.mVpLib.addNeueWertPosition(323615, aktuellesEGA);
                    }
                }
                this.mVpLib.addNeueWertPosition(323610, aktuellesEGA);
            }
            kvEntgeltEGA = aktuellesEGA;
        }
        this.mCalLib.result(kvEntgeltEGA);
        this.mCalLib.factor1(this.mVpLib.kvTageMarb());
    }

    private void bewerteNormal(BigDecimal aktuellesEGA) throws BusinessDomainException {
        boolean mfb = false;
        if (this.mEeLib.isMehrfachbeschaeftigt() && (this.mEeLib.marbBgrKvAndererAG() == 1 || this.mEeLib.marbBgrKvAndererAG() == 3 || this.mEeLib.marbBgrKvAndererAG() == 9 || this.mEeLib.marbPKv()) && (this.mEeLib.marbBgrKv() == 1 || this.mEeLib.marbBgrKv() == 3 || this.mEeLib.marbBgrKv() == 9 || this.mEeLib.marbPKv())) {
            mfb = true;
        }
        boolean dbbgVorhanden = false;
        boolean mfbOhneDBBG = false;
        if (mfb) {
            if (DateHelper.afterOrEqual((Date)this.mCalLib.berchnungGueltigAb(), (Date)new VDate(2013, 0, 1).getDate()) && (dbbgVorhanden = this.mCalLib.dbbgVorhanden()) && DateHelper.afterOrEqual((Date)this.mCalLib.berchnungGueltigAb(), (Date)new VDate(2015, 0, 1).getDate()) && !StringMapper.equal((String)this.mCalLib.dbbgKVEBBG(), (String)"J")) {
                dbbgVorhanden = false;
            }
            if (!dbbgVorhanden) {
                mfbOhneDBBG = true;
                if (DateHelper.afterOrEqual((Date)this.mCalLib.berchnungGueltigAb(), (Date)new VDate(2013, 0, 1).getDate())) {
                    this.ermittleFremdentgelt2013();
                } else {
                    this.ermittleFremdentgelt();
                }
            }
        }
        BigDecimal aufgelaufenesKVPflichtigeEntgelt = BigDecimal.ZERO;
        boolean beitragspflichtig = this.mEeLib.marb().isContributory(this.mCalLib.berchnungWirksamAb(), this.mCalLib.berchnungGueltigAb());
        aufgelaufenesKVPflichtigeEntgelt = DateHelper.afterOrEqual((Date)this.mCalLib.berchnungGueltigAb(), (Date)new VDate(2013, 0, 1).getDate()) ? this.holeAufgelaufenesKVPflichtigesEntgelt2013(beitragspflichtig, mfb).add(this.mSummeKVEntgeltLfd).add(this.mSummeKVEntgeltLfdAndererAG) : this.holeAufgelaufenesKVPflichtigesEntgelt(mfbOhneDBBG).add(this.mSummeKVEntgeltLfd).add(this.mSummeKVEntgeltLfdAndererAG).add(this.mSummeKVEntgeltEGA);
        BigDecimal kvTage = this.mVpLib.summeKVTageFuerEGA(beitragspflichtig);
        BigDecimal kvBBG = this.mVpLib.aufgelBbgKv(beitragspflichtig);
        BigDecimal kVLuft = kvBBG.subtract(aufgelaufenesKVPflichtigeEntgelt);
        if (DateHelper.afterOrEqual((Date)this.mCalLib.berchnungGueltigAb(), (Date)new VDate(2013, 0, 1).getDate())) {
            if (dbbgVorhanden) {
                if (BigDecimalMapper.compareTo((BigDecimal)this.mCalLib.dbbgEGAKV(), (BigDecimal)this.mSummeKVEntgeltEGA.add(aktuellesEGA)) < 0) {
                    BigDecimal temp1 = kVLuft.subtract(this.mSummeKVEntgeltEGA);
                    kVLuft = this.mCalLib.dbbgEGAKV().subtract(this.mSummeKVEntgeltEGA);
                    if (aktuellesEGA.compareTo(kVLuft) > 0) {
                        BigDecimal diff = aktuellesEGA.subtract(kVLuft);
                        BigDecimal diff2 = temp1.subtract(aktuellesEGA);
                        if (diff2.compareTo(BigDecimal.ZERO) < 0) {
                            diff = diff.add(diff2);
                        }
                        if (!BigDecimalMapper.isZero((BigDecimal)diff)) {
                            this.mVpLib.addNeueWertPosition(321695, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, diff, false);
                        }
                    }
                } else {
                    kVLuft = kVLuft.subtract(this.mSummeKVEntgeltEGA);
                }
            } else {
                kVLuft = kVLuft.subtract(this.mSummeKVEntgeltEGA);
            }
        }
        if (kVLuft.compareTo(BigDecimal.ZERO) < 0) {
            kVLuft = BigDecimal.ZERO;
        }
        if (mfbOhneDBBG && DateHelper.before((Date)this.mCalLib.berchnungGueltigAb(), (Date)new VDate(2013, 0, 1).getDate()) && kVLuft.compareTo(aktuellesEGA.add(this.mSummeKVEntgeltEGA).add(this.mSummeKVEntgeltEGAAndererAG)) < 0) {
            kVLuft = kVLuft.multiply(this.mSummeKVEntgeltEGA.add(aktuellesEGA)).divide(this.mSummeKVEntgeltEGA.add(aktuellesEGA).add(this.mSummeKVEntgeltEGAAndererAG), 2, RoundingMode.HALF_UP);
        }
        BigDecimal kvEntgeltEGA = BigDecimal.ZERO;
        if (kVLuft.compareTo(aktuellesEGA) >= 0) {
            kvEntgeltEGA = aktuellesEGA;
        } else {
            kvEntgeltEGA = kVLuft;
            this.mVpLib.wertPosition().setBufferResult(aktuellesEGA.subtract(kVLuft));
        }
        this.mCalLib.result(kvEntgeltEGA);
        this.mCalLib.factor1(kvTage);
        if (this.mEeLib.isBehinderterMA()) {
            BigDecimal percentage = this.mVpLib.prozentsatz();
            switch (this.mEeLib.marbBgrKv()) {
                case 1: 
                case 2: 
                case 3: {
                    if (BigDecimalMapper.compareTo((BigDecimal)percentage, (BigDecimal)BigDecimal.valueOf(100L)) == 0) {
                        if (DateHelper.afterOrEqual((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2015, 0, 1).getDate())) {
                            this.mVpLib.addNeueWertPosition(323620, kvEntgeltEGA);
                            this.mVpLib.addNeueWertPosition(323625, kvEntgeltEGA);
                            break;
                        }
                        this.mVpLib.addNeueWertPosition(323620, kvEntgeltEGA);
                        break;
                    }
                    this.mVpLib.addNeueWertPosition(322610, kvEntgeltEGA);
                    if (DateHelper.afterOrEqual((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2005, 6, 1).getDate())) {
                        this.mVpLib.addNeueWertPosition(322616, kvEntgeltEGA);
                        if (DateHelper.afterOrEqual((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2019, 0, 1).getDate())) {
                            this.mVpLib.addNeueWertPosition(323615, kvEntgeltEGA);
                        }
                    }
                    this.mVpLib.addNeueWertPosition(323610, kvEntgeltEGA);
                }
            }
        } else {
            switch (this.mEeLib.marbBgrKv()) {
                case 1: 
                case 2: 
                case 3: {
                    this.mVpLib.addNeueWertPosition(321690, BigDecimal.ZERO, BigDecimal.ZERO, kvTage, BigDecimal.ZERO, kvBBG, true);
                    this.mVpLib.addNeueWertPosition(322610, kvEntgeltEGA);
                    if (DateHelper.afterOrEqual((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2005, 6, 1).getDate())) {
                        this.mVpLib.addNeueWertPosition(322616, kvEntgeltEGA);
                        if (DateHelper.afterOrEqual((Date)this.mVpLib.gueltigAb(), (Date)new VDate(2019, 0, 1).getDate())) {
                            this.mVpLib.addNeueWertPosition(323615, kvEntgeltEGA);
                        }
                    }
                    this.mVpLib.addNeueWertPosition(323610, kvEntgeltEGA);
                    break;
                }
                case 5: {
                    this.mVpLib.addNeueWertPosition(321690, BigDecimal.ZERO, BigDecimal.ZERO, kvTage, BigDecimal.ZERO, kvBBG, true);
                    this.mVpLib.addNeueWertPosition(323610, kvEntgeltEGA);
                    break;
                }
                case 6: {
                    this.mVpLib.addNeueWertPosition(323512, kvEntgeltEGA);
                    break;
                }
            }
        }
    }

    private void ermittleFremdentgelt() throws BusinessDomainException {
        ValuePosition[] vpArray;
        block4: for (ValuePosition element : vpArray = this.mVpLib.wpAusWPListeBisParentUebergebenerWP(this.mVpLib.wirksamAb(), this.mVpLib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.mVpLib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.mVpLib.gueltigAb()), this.mVpLib.wertPosition(), ValueTypeHelper.getValueTypes((int[])new int[]{129200, 129205, 129210, 129215}))) {
            switch (element.getValueType().getValueTypeKey()) {
                case 129200: 
                case 129205: {
                    this.mSummeKVEntgeltLfdAndererAG = this.mSummeKVEntgeltLfdAndererAG.add(element.getResult());
                    continue block4;
                }
                case 129210: 
                case 129215: {
                    this.mSummeKVEntgeltEGAAndererAG = this.mSummeKVEntgeltEGAAndererAG.add(element.getResult());
                    continue block4;
                }
            }
        }
    }

    private void ermittleFremdentgelt2013() throws BusinessDomainException {
        ValuePosition[] vpArray = this.mVpLib.wpAusWPListeBisUebergebeneWP(this.mVpLib.wirksamAb(), this.mVpLib.wirksamBis(), DateHelper.getFirstDayOfMonth((Date)this.mVpLib.gueltigAb()), DateHelper.getLastDayOfMonth((Date)this.mVpLib.gueltigAb()), this.mVpLib.wertPosition(), ValueTypeHelper.getValueTypes((int[])new int[]{129200, 129205, 129210, 129215, 321595, 321596, 321695}));
        BigDecimal temp1 = BigDecimal.ZERO;
        BigDecimal temp2 = BigDecimal.ZERO;
        BigDecimal temp3 = BigDecimal.ZERO;
        BigDecimal temp4 = BigDecimal.ZERO;
        block6: for (ValuePosition vPos : vpArray) {
            switch (vPos.getValueType().getValueTypeKey()) {
                case 129200: 
                case 129205: {
                    temp1 = temp1.add(vPos.getResult());
                    continue block6;
                }
                case 129210: 
                case 129215: {
                    temp2 = temp2.add(vPos.getResult());
                    continue block6;
                }
                case 321595: 
                case 321596: {
                    temp3 = temp3.add(vPos.getResult());
                    continue block6;
                }
                case 321695: {
                    temp4 = temp4.add(vPos.getResult());
                    continue block6;
                }
            }
        }
        this.mSummeKVEntgeltLfdAndererAG = BigDecimalMapper.isZero((BigDecimal)temp3) ? this.mSummeKVEntgeltLfdAndererAG.add(temp1) : this.mSummeKVEntgeltLfdAndererAG.add(temp3);
        this.mSummeKVEntgeltEGAAndererAG = BigDecimalMapper.isZeroOrNull((BigDecimal)temp4) ? this.mSummeKVEntgeltEGAAndererAG.add(temp4) : this.mSummeKVEntgeltEGAAndererAG.add(temp2);
    }

    private BigDecimal holeAufgelaufenesKVPflichtigesEntgelt2013(boolean beitragspflichtig, boolean mfb) throws BusinessDomainException {
        BigDecimal result = BigDecimal.ZERO;
        Date suchDatum = DateHelper.getFirstDayOfYear((Date)this.mVpLib.gueltigAb());
        while (DateHelper.before((Date)suchDatum, (Date)DateHelper.getFirstDayOfMonth((Date)this.mVpLib.gueltigAb()))) {
            if (this.mEeLib.marb().isContributory(this.mCalLib.berchnungWirksamAb(), suchDatum) == beitragspflichtig) {
                ValuePosition[] alteVP;
                block4: for (ValuePosition vPos : alteVP = this.mVpLib.wpAusWPListeOderDB(this.mVpLib.wirksamAb(), this.mVpLib.wirksamBis(), suchDatum, DateHelper.getLastDayOfMonth((Date)suchDatum), ValueTypeHelper.getValueTypes((int[])new int[]{321510, 321610, 321616, 321720, 321740, 321725, 321730}))) {
                    if (DateHelper.after((Date)vPos.getEffectiveFrom(), (Date)this.mVpLib.wirksamAb())) continue;
                    switch (vPos.getValueType().getValueTypeKey()) {
                        case 321730: {
                            result = result.add(vPos.getResult().subtract(vPos.getPersistentBuffer1()));
                            continue block4;
                        }
                        default: {
                            result = result.add(vPos.getResult());
                        }
                    }
                }
                if (mfb) {
                    for (ValuePosition vPos : alteVP = this.mVpLib.wpAusWPListeOderDB(this.mVpLib.wirksamAb(), this.mVpLib.wirksamBis(), suchDatum, DateHelper.getLastDayOfMonth((Date)suchDatum), ValueTypeHelper.getValueTypes((int[])new int[]{321595, 321596, 321695}))) {
                        result = result.add(vPos.getResult());
                    }
                }
            }
            suchDatum = DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)suchDatum));
        }
        result = result.add(this.mEeLib.vortragSozialVersicherungKVEntgelt(this.mVpLib.gueltigAb()));
        return result;
    }

    private BigDecimal holeAufgelaufenesKVPflichtigesEntgelt(boolean mfbOhneDBBG) throws BusinessDomainException {
        BigDecimal result = BigDecimal.ZERO;
        Date suchDatum = DateHelper.getFirstDayOfYear((Date)this.mVpLib.gueltigAb());
        while (DateHelper.before((Date)suchDatum, (Date)DateHelper.getFirstDayOfMonth((Date)this.mVpLib.gueltigAb()))) {
            ValuePosition[] alteVP;
            block4: for (ValuePosition vPos : alteVP = this.mVpLib.wpAusWPListeOderDB(this.mVpLib.wirksamAb(), this.mVpLib.wirksamBis(), suchDatum, DateHelper.getLastDayOfMonth((Date)suchDatum), ValueTypeHelper.getValueTypes((int[])new int[]{321510, 321610, 321616, 321720, 321740, 321725, 321730}))) {
                if (DateHelper.after((Date)vPos.getEffectiveFrom(), (Date)this.mVpLib.wirksamAb())) continue;
                switch (vPos.getValueType().getValueTypeKey()) {
                    case 321730: {
                        result = result.add(vPos.getResult().subtract(vPos.getPersistentBuffer1()));
                        continue block4;
                    }
                    default: {
                        result = result.add(vPos.getResult());
                    }
                }
            }
            if (mfbOhneDBBG) {
                for (ValuePosition element : alteVP = this.mVpLib.wpAusWPListeOderDB(this.mVpLib.wirksamAb(), this.mVpLib.wirksamBis(), suchDatum, DateHelper.getLastDayOfMonth((Date)suchDatum), ValueTypeHelper.getValueTypes((int[])new int[]{129200, 129205, 129210, 129215}))) {
                    result = result.add(element.getResult());
                }
            }
            suchDatum = DateHelper.tomorrow((Date)DateHelper.getLastDayOfMonth((Date)suchDatum));
        }
        result = result.add(this.mEeLib.vortragSozialVersicherungKVEntgelt(this.mVpLib.gueltigAb()));
        return result;
    }
}

