/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.employee.zvk;

import com.varial.base.exception.BusinessDomainException;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.assignments.pcompanyzvk.AssignmentPCompanyZVKTP;
import com.varial.personnel.domain.designationtype.designation.Designation;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.IEmployeeReferenced;
import com.varial.personnel.domain.employee.mapper.EmployeeExceptionMapper;
import com.varial.personnel.domain.employee.pensionscheme.AdvancementTypeEnum;
import com.varial.personnel.domain.employee.tax.Tax;
import com.varial.personnel.domain.employee.tax.TaxacationEnum;
import com.varial.personnel.domain.employee.zvk.CalcOfAddContEnum;
import com.varial.personnel.domain.employee.zvk.EEZVKPersistencyManager;
import com.varial.personnel.domain.employee.zvk.FurtherInsuranceEnum;
import com.varial.personnel.domain.employee.zvk.ZvkTypeOfCalcAddContEnum;
import com.varial.personnel.domain.employee.zvk.ZvkTypeOfCalculationEnum;
import com.varial.personnel.domain.global.recipient.Recipient;
import com.varial.personnel.domain.global.recipient.TypeOfRecipientEnum;
import com.varial.personnel.domain.global.recipient.zvk.TypeOfZvkEnum;
import com.varial.personnel.domain.pcompany.PCompany;
import com.varial.personnel.domain.plant.Plant;
import com.varial.personnel.framework.PersonnelTimedPersistenceObject;
import com.varial.personnel.framework.basictypes.PDateHelper;
import com.varial.personnel.framework.mapper.FrameWorkExceptionMapper;
import com.varial.personnel.framework.mapper.PBigDecimalMapper;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.math.BigDecimal;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EEZVK
extends PersonnelTimedPersistenceObject
implements IEmployeeReferenced {
    private static Logger LOGGER = LoggerFactory.getLogger(EEZVK.class);
    private static final int PRIORITY = 5;
    private FurtherInsuranceEnum mFurtherInsurance;
    private Designation mZVEReason;
    private Designation mZVEState;
    private int mNumberOfChildren;
    private Date mChangeOfChildrenDate;
    private int mNumberOfChildrenAfter;
    private boolean mAddAmountEE3No63EStG = true;
    private boolean mCalculateAddAssessment;
    private boolean mCutExemptionLimit;
    private Date mDateOfEntry;
    private Date mDateOfWithdrawl;
    private Employee mEmployee;
    private String mMembershipNumber;
    private boolean mToShiftLumpSumCTax = false;
    private boolean mToShiftLumpSumITax = false;
    private boolean mToShiftLumpSumSTax = false;
    private ZvkTypeOfCalcAddContEnum mTypeOfCalcAddCont;
    private ZvkTypeOfCalculationEnum mTypeOfCalculation;
    private Recipient mZVK;
    private boolean mBeginAgePartTimeBefore2003;
    private CalcOfAddContEnum mCalculationOfAddCont;
    private AdvancementTypeEnum mAdvancementTypeAsCtPays;
    private BigDecimal mMonthCompValueErAddCont;
    private boolean mPriorInsurance;
    private boolean mOnlyDateOfWithdrawalChanged = false;
    private boolean mSpecialChecks = true;

    public static EEZVK getEEZVK(String objectID) {
        return new EEZVK(objectID);
    }

    protected EEZVK(boolean readOnly) {
        super(5, readOnly);
    }

    public EEZVK(Employee employee) {
        super(5);
        this.mEmployee = employee;
    }

    public EEZVK(Employee ee, boolean readOnly) {
        super(5, readOnly);
        this.mEmployee = ee;
    }

    public EEZVK(String objectID) {
        super(5, objectID);
    }

    public EEZVK(String objectId, int version, Employee employee) {
        super(5, objectId, version);
        this.mEmployee = employee;
    }

    @Override
    public void checkAttributes() throws BusinessDomainException {
        this.requireLoaded();
        this.checkDates();
        if (this.mSpecialChecks) {
            this.checkValidFromAgainstRetroactiveCalculation(this.getEmployee());
        }
        if (this.mZVK == null) {
            throw EmployeeExceptionMapper.makeNoRecipientForZvkDomainException();
        }
        TypeOfRecipientEnum toCheck = this.mZVK.getRecipientTP(this.mEffectiveFrom, this.mValidFrom).getTypeOfRecipientEnum();
        if (toCheck.value() != 6) {
            throw EmployeeExceptionMapper.makeOnlyRecipientsOfTypeZVKAllowedDomainException();
        }
        TypeOfZvkEnum typeofZvk = this.mZVK.getRecipientTP(this.mEffectiveUntil, this.mValidFrom).getZVK().getTypeOfZvk();
        if (typeofZvk == TypeOfZvkEnum.TOZE_ZVE_DATENANNAHMESTELLE_VBL || typeofZvk == TypeOfZvkEnum.TOZE_ZVE_DATENANNAHMESTELLE_AKA) {
            throw EmployeeExceptionMapper.makeOnlyZveAllowedDomainException();
        }
        Plant plant = this.mEmployee.getEmployment(this.mEffectiveFrom, this.mValidFrom).getPlant();
        AssignmentPCompanyZVKTP zuordnungZVK = AssignmentPCompanyZVKTP.getAssignmentZVKTP((Recipient)this.mZVK, (PCompany)this.mEmployee.getPCompany(), (Plant)plant, (Date)this.mEffectiveFrom, (Date)this.mValidFrom);
        if (zuordnungZVK == null) {
            throw EmployeeExceptionMapper.makeNoAssignementOfZvkToPCompanyOrPlant(this.mValidFrom);
        }
        if (this.mZVEReason != null) {
            this.mZVEReason.getDesignationTP(this.mEffectiveFrom, this.mValidFrom);
        }
        if (this.mZVEState != null) {
            this.mZVEState.getDesignationTP(this.mEffectiveFrom, this.mValidFrom);
        }
        switch (this.mTypeOfCalcAddCont.value()) {
            case 0: 
            case 1: 
            case 2: {
                if (!this.mAddAmountEE3No63EStG) break;
                throw EmployeeExceptionMapper.makeNo3Nr36IfNoNewAgreementDomainException();
            }
        }
        if (this.mDateOfWithdrawl != null && this.mZVEReason == null) {
            throw EmployeeExceptionMapper.makeZvkWithdrawalReasonMissingDomainException();
        }
        if (this.mSpecialChecks) {
            this.checkAdvancement();
        }
    }

    public void checkAdvancement() throws BusinessDomainException {
        Tax tax;
        if (this.mAdvancementTypeAsCtPays == AdvancementTypeEnum.NEIN && !BigDecimalMapper.isZeroOrNull((BigDecimal)this.mMonthCompValueErAddCont)) {
            throw FrameWorkExceptionMapper.makeInputNotAllowedDomainException((String)"Kombination von Einrechnung in den F\u00f6rderbetrag = Nein und einem zugeh\u00f6rigen Betrag gr\u00f6\u00dfer 0");
        }
        if (DateHelper.before((Date)this.mValidFrom, (Date)new VDate(2018, 0, 1).getDate()) && this.mAdvancementTypeAsCtPays != AdvancementTypeEnum.NEIN) {
            throw EmployeeExceptionMapper.makeAdvancementNotAllowedBefore2018DomainException();
        }
        if (this.mAdvancementTypeAsCtPays == AdvancementTypeEnum.JA_AB_2017 && (tax = (Tax)this.getEmployee().getTaxHistory().getItemOrNull(this.mEffectiveFrom, this.mValidFrom)) != null && (tax.getTaxBracket() == 6 || tax.getTaxacation() == TaxacationEnum.TE_STEUERFREIE_BESCHAEFTIGUNG || tax.getTaxacation() == TaxacationEnum.TE_DBA_TUERKEI || tax.getTaxacation() == TaxacationEnum.TE_STEUERFREIER_AUSLANDSTAETIGKEITSERLASS)) {
            throw EmployeeExceptionMapper.makeBavAdvancementNotAllowedForEmployeetaxDomainException();
        }
    }

    @Override
    public void checkDates() throws BusinessDomainException {
        this.requireLoaded();
        super.checkDates();
        Date[] dates = this.mEmployee.checkDates(false, this.mValidFrom);
        this.setEffectiveFrom(dates[0]);
        this.setValidFrom(dates[1]);
        if (this.mDateOfEntry == null) {
            throw EmployeeExceptionMapper.makeNoDateOfEntryZVKDomainException();
        }
        Date minimumValidFrom = this.mEmployee.getZVKHistory().getMinValidFromOfHistory();
        if (DateHelper.after((Date)(minimumValidFrom = PDateHelper.minIgnoringNulls((Date[])new Date[]{minimumValidFrom, this.mValidFrom})), (Date)this.mEmployee.getCalculationStart()) && DateHelper.before((Date)this.mDateOfEntry, (Date)minimumValidFrom)) {
            throw EmployeeExceptionMapper.makeDateOfEntryZvkVbluFalseDomainException();
        }
        if (this.mDateOfWithdrawl != null && DateHelper.before((Date)this.mDateOfWithdrawl, (Date)this.mValidFrom)) {
            throw EmployeeExceptionMapper.makeDateOfWithDrawalBeforeValidFromDomainException();
        }
    }

    public void compareToOld(EEZVK old) {
        if (old == null) {
            return;
        }
        old.requireLoaded();
        if (DateHelper.equal((Date)old.getValidFrom(), (Date)this.mValidFrom) && old.getTypeOfCalcAddCont() == this.mTypeOfCalcAddCont && old.getTypeOfCalculation() == this.mTypeOfCalculation && old.isToShiftLumpSumITax() == this.mToShiftLumpSumITax && old.isToShiftLumpSumSTax() == this.mToShiftLumpSumSTax && old.isCutExemptionLimit() == this.mCutExemptionLimit && old.isCalculateAddAssessment() == this.mCalculateAddAssessment && old.isAddAmountEE3No63EStG() == this.mAddAmountEE3No63EStG && old.getFurtherInsurance() == this.mFurtherInsurance && old.getBeginAgePartTimeBefore2003() == this.mBeginAgePartTimeBefore2003 && old.getCalculationOfAddCont() == this.mCalculationOfAddCont && old.getAdvancementTypeAsCtPays() == this.mAdvancementTypeAsCtPays && PBigDecimalMapper.isEqual((BigDecimal)old.getMonthCompValueErAddCont(), (BigDecimal)this.mMonthCompValueErAddCont) && DateHelper.compareDateWithNull((Date)old.getDateOfWithdrawl(), (Date)this.mDateOfWithdrawl) != 0) {
            this.setOnlyDateOfWithdrawalChanged(true);
        }
        if (DateHelper.compareDateWithNull((Date)old.getDateOfEntry(), (Date)this.mDateOfEntry) != 0) {
            this.setValuateNeeded(true);
            return;
        }
        if (DateHelper.compareDateWithNull((Date)old.getDateOfWithdrawl(), (Date)this.mDateOfWithdrawl) != 0) {
            this.setValuateNeeded(true);
            return;
        }
        if (old.getTypeOfCalcAddCont() != this.mTypeOfCalcAddCont) {
            this.setValuateNeeded(true);
            return;
        }
        if (old.getTypeOfCalculation() != this.mTypeOfCalculation) {
            this.setValuateNeeded(true);
            return;
        }
        if (old.isToShiftLumpSumITax() != this.mToShiftLumpSumITax) {
            this.setValuateNeeded(true);
            return;
        }
        if (old.isToShiftLumpSumSTax() != this.mToShiftLumpSumSTax) {
            this.setValuateNeeded(true);
            return;
        }
        if (old.isToShiftLumpSumCTax() != this.mToShiftLumpSumCTax) {
            this.setValuateNeeded(true);
            return;
        }
        if (old.isCutExemptionLimit() != this.mCutExemptionLimit) {
            this.setValuateNeeded(true);
            return;
        }
        if (old.isCalculateAddAssessment() != this.mCalculateAddAssessment) {
            this.setValuateNeeded(true);
            return;
        }
        if (old.isAddAmountEE3No63EStG() != this.mAddAmountEE3No63EStG) {
            this.setValuateNeeded(true);
            return;
        }
        if (old.getFurtherInsurance() != this.mFurtherInsurance) {
            this.setValuateNeeded(true);
            return;
        }
        if (old.getBeginAgePartTimeBefore2003() != this.mBeginAgePartTimeBefore2003) {
            this.setValuateNeeded(true);
            return;
        }
        if (old.getCalculationOfAddCont() != this.mCalculationOfAddCont) {
            this.setValuateNeeded(true);
            return;
        }
        if (old.getAdvancementTypeAsCtPays() != this.mAdvancementTypeAsCtPays) {
            this.setValuateNeeded(true);
            return;
        }
        if (!PBigDecimalMapper.isEqual((BigDecimal)old.getMonthCompValueErAddCont(), (BigDecimal)this.mMonthCompValueErAddCont)) {
            this.setValuateNeeded(true);
            return;
        }
    }

    @Override
    protected PersonnelTimedPersistenceObject createNew() {
        EEZVK result = new EEZVK(this.mEmployee);
        result.mEffectiveFrom = this.mEffectiveFrom;
        result.mEffectiveUntil = this.mEffectiveUntil;
        result.mValidFrom = this.mValidFrom;
        result.mValidUntil = this.mValidUntil;
        result.mZVK = this.mZVK;
        result.mDateOfEntry = this.mDateOfEntry;
        result.mDateOfWithdrawl = this.mDateOfWithdrawl;
        result.mMembershipNumber = this.mMembershipNumber;
        result.mTypeOfCalcAddCont = this.mTypeOfCalcAddCont;
        result.mTypeOfCalculation = this.mTypeOfCalculation;
        result.mToShiftLumpSumITax = this.mToShiftLumpSumITax;
        result.mToShiftLumpSumSTax = this.mToShiftLumpSumSTax;
        result.mToShiftLumpSumCTax = this.mToShiftLumpSumCTax;
        result.mCutExemptionLimit = this.mCutExemptionLimit;
        result.mCalculateAddAssessment = this.mCalculateAddAssessment;
        result.mAddAmountEE3No63EStG = this.mAddAmountEE3No63EStG;
        result.mFurtherInsurance = this.mFurtherInsurance;
        result.mZVEReason = this.mZVEReason;
        result.mZVEState = this.mZVEState;
        result.mNumberOfChildren = this.mNumberOfChildren;
        result.mChangeOfChildrenDate = this.mChangeOfChildrenDate;
        result.mNumberOfChildrenAfter = this.mNumberOfChildrenAfter;
        result.mBeginAgePartTimeBefore2003 = this.mBeginAgePartTimeBefore2003;
        result.mCalculationOfAddCont = this.mCalculationOfAddCont;
        result.mAdvancementTypeAsCtPays = this.getAdvancementTypeAsCtPays();
        result.mMonthCompValueErAddCont = this.getMonthCompValueErAddCont();
        result.mPriorInsurance = this.getPriorInsurance();
        return result;
    }

    protected void deleteImpl() {
        EEZVKPersistencyManager.delete((EEZVK)this);
    }

    public String getClassName() {
        return ((Object)((Object)this)).getClass().getCanonicalName();
    }

    public Date getDateOfEntry() {
        this.requireLoaded();
        return this.mDateOfEntry;
    }

    public Date getDateOfWithdrawl() {
        this.requireLoaded();
        return this.mDateOfWithdrawl;
    }

    public String getDomainKey() {
        this.requireLoaded();
        return new StringBuffer().append(this.getEmployee().getDomainKey()).append(" / ").append(DateMapper.toString((Date)this.mEffectiveFrom)).append(" / ").append(DateMapper.toString((Date)this.mValidFrom)).toString();
    }

    public Employee getEmployee() {
        this.requireLoaded();
        return this.mEmployee;
    }

    public String getMembershipNumber() {
        this.requireLoaded();
        return this.mMembershipNumber;
    }

    @Override
    public String getNaturalLanguageClassName() {
        return "Mitarbeiter - Zusatzversorgung";
    }

    @Override
    public String getRootDomainKey() {
        return this.getEmployee().getDomainKey();
    }

    public ZvkTypeOfCalcAddContEnum getTypeOfCalcAddCont() {
        this.requireLoaded();
        return this.mTypeOfCalcAddCont;
    }

    public ZvkTypeOfCalculationEnum getTypeOfCalculation() {
        this.requireLoaded();
        return this.mTypeOfCalculation;
    }

    public Recipient getZVK() {
        this.requireLoaded();
        return this.mZVK;
    }

    public boolean isCalculateAddAssessment() {
        return this.mCalculateAddAssessment;
    }

    public boolean isCutExemptionLimit() {
        this.requireLoaded();
        return this.mCutExemptionLimit;
    }

    public boolean isToShiftLumpSumCTax() {
        this.requireLoaded();
        return this.mToShiftLumpSumCTax;
    }

    public boolean isToShiftLumpSumITax() {
        this.requireLoaded();
        return this.mToShiftLumpSumITax;
    }

    public boolean isToShiftLumpSumSTax() {
        this.requireLoaded();
        return this.mToShiftLumpSumSTax;
    }

    public boolean isAddAmountEE3No63EStG() {
        this.requireLoaded();
        return this.mAddAmountEE3No63EStG;
    }

    public FurtherInsuranceEnum getFurtherInsurance() {
        this.requireLoaded();
        return this.mFurtherInsurance;
    }

    public Designation getZVEReason() {
        this.requireLoaded();
        return this.mZVEReason;
    }

    public Designation getZVEState() {
        this.requireLoaded();
        return this.mZVEState;
    }

    public int getNumberOfChildren() {
        this.requireLoaded();
        return this.mNumberOfChildren;
    }

    public Date getChangeOfChildrenDate() {
        this.requireLoaded();
        return this.mChangeOfChildrenDate;
    }

    public int getNumberOfChildrenAfter() {
        this.requireLoaded();
        return this.mNumberOfChildrenAfter;
    }

    public boolean getBeginAgePartTimeBefore2003() {
        this.requireLoaded();
        return this.mBeginAgePartTimeBefore2003;
    }

    public void setBeginAgePartTimeBefore2003(boolean beginAgePartTimeBefore2003) {
        this.mBeginAgePartTimeBefore2003 = beginAgePartTimeBefore2003;
    }

    public CalcOfAddContEnum getCalculationOfAddCont() {
        this.requireLoaded();
        return this.mCalculationOfAddCont;
    }

    public void setCalculationOfAddCont(CalcOfAddContEnum calculationOfAddCont) {
        this.mCalculationOfAddCont = calculationOfAddCont;
    }

    public AdvancementTypeEnum getAdvancementTypeAsCtPays() {
        this.requireLoaded();
        return this.mAdvancementTypeAsCtPays;
    }

    public void setAdvancementTypeAsCtPays(AdvancementTypeEnum advancementTypeAsCtPays) {
        this.mAdvancementTypeAsCtPays = advancementTypeAsCtPays;
    }

    public BigDecimal getMonthCompValueErAddCont() {
        this.requireLoaded();
        return this.mMonthCompValueErAddCont;
    }

    public void setMonthCompValueErAddCont(BigDecimal monthCompValueErAddCont) {
        this.mMonthCompValueErAddCont = monthCompValueErAddCont;
    }

    public boolean getPriorInsurance() {
        this.requireLoaded();
        return this.mPriorInsurance;
    }

    public void setPriorInsurance(boolean priorInsurance) {
        this.mPriorInsurance = priorInsurance;
    }

    protected void load() {
        EEZVKPersistencyManager.load((EEZVK)this);
    }

    protected void saveImpl() throws BusinessDomainException {
        EEZVKPersistencyManager.save((EEZVK)this);
    }

    protected void setData(Date effectiveFrom, Date effectiveUntil, Date validFrom, Date validUntil, Recipient zvk, Date dateOfEntry, Date dateOfWithdrawl, String membershipNumber, ZvkTypeOfCalcAddContEnum typeOfCalcAddCont, ZvkTypeOfCalculationEnum typeOfCalculation, boolean toShiftLumpSumITax, boolean toShiftLumpSumSTax, boolean toShiftLumpSumCTax, boolean cutExemptionLimit, boolean calculateAddAssessment, boolean addAmountEE3No63EStG, FurtherInsuranceEnum furtherInsurance, Designation zVEReason, Designation zVEState, int numberOfChildren, Date changeOfChildrenDate, int numberOfChildrenAfter, boolean beginAgePartTimeBefore2003, CalcOfAddContEnum calculationOfAddCont, AdvancementTypeEnum advancementTypeAsCtPays, BigDecimal monthCompValueErAddCont, boolean priorInsurance) {
        this.mEffectiveFrom = effectiveFrom;
        this.mEffectiveUntil = effectiveUntil;
        this.mValidFrom = validFrom;
        this.mValidUntil = validUntil;
        this.mZVK = zvk;
        this.mDateOfEntry = dateOfEntry;
        this.mDateOfWithdrawl = dateOfWithdrawl;
        this.mMembershipNumber = membershipNumber;
        this.mTypeOfCalcAddCont = typeOfCalcAddCont;
        this.mTypeOfCalculation = typeOfCalculation;
        this.mToShiftLumpSumITax = toShiftLumpSumITax;
        this.mToShiftLumpSumSTax = toShiftLumpSumSTax;
        this.mToShiftLumpSumCTax = toShiftLumpSumCTax;
        this.mCutExemptionLimit = cutExemptionLimit;
        this.mCalculateAddAssessment = calculateAddAssessment;
        this.mAddAmountEE3No63EStG = addAmountEE3No63EStG;
        this.mFurtherInsurance = furtherInsurance;
        this.mZVEReason = zVEReason;
        this.mZVEState = zVEState;
        this.mNumberOfChildren = numberOfChildren;
        this.mChangeOfChildrenDate = changeOfChildrenDate;
        this.mNumberOfChildrenAfter = numberOfChildrenAfter;
        this.mBeginAgePartTimeBefore2003 = beginAgePartTimeBefore2003;
        this.mCalculationOfAddCont = calculationOfAddCont;
        this.mAdvancementTypeAsCtPays = advancementTypeAsCtPays;
        this.mMonthCompValueErAddCont = monthCompValueErAddCont;
        this.mPriorInsurance = priorInsurance;
    }

    public void setAddAmount3No63EStG(boolean addAmountEE3No63EStG) {
        this.mAddAmountEE3No63EStG = addAmountEE3No63EStG;
    }

    public void setCalculateAddAssessment(boolean calculateAddAssessment) {
        this.mCalculateAddAssessment = calculateAddAssessment;
    }

    public void setCutExemptionLimit(boolean cutExemptionLimit) {
        this.mCutExemptionLimit = cutExemptionLimit;
    }

    public void setDateOfEntry(Date dateOfEntry) {
        this.mDateOfEntry = dateOfEntry;
    }

    public void setDateOfWithdrawl(Date dateOfWithdrawl) {
        this.mDateOfWithdrawl = dateOfWithdrawl;
    }

    public void setEmployee(Employee employee) {
        this.mEmployee = employee;
    }

    public void setMembershipNumber(String membershipNumber) {
        this.mMembershipNumber = membershipNumber;
    }

    public void setToShiftLumpSumCTax(boolean toShiftLumpSumCTax) {
        this.mToShiftLumpSumCTax = toShiftLumpSumCTax;
    }

    public void setToShiftLumpSumITax(boolean toShiftLumpSumITax) {
        this.mToShiftLumpSumITax = toShiftLumpSumITax;
    }

    public void setToShiftLumpSumSTax(boolean toShiftLumpSumSTax) {
        this.mToShiftLumpSumSTax = toShiftLumpSumSTax;
    }

    public void setTypeOfCalcAddCont(ZvkTypeOfCalcAddContEnum typeOfCalcAddCont) {
        this.mTypeOfCalcAddCont = typeOfCalcAddCont;
    }

    public void setTypeOfCalculation(ZvkTypeOfCalculationEnum typeOfCalculation) {
        this.mTypeOfCalculation = typeOfCalculation;
    }

    public void setZVK(Recipient zvk) {
        this.mZVK = zvk;
    }

    public void setFurtherInsurance(FurtherInsuranceEnum furtherInsurance) {
        this.mFurtherInsurance = furtherInsurance;
    }

    public void setZVEReason(Designation zVEReason) {
        this.mZVEReason = zVEReason;
    }

    public void setZVEState(Designation zVEState) {
        this.mZVEState = zVEState;
    }

    public void setNumberOfChildren(int numberOfChildren) {
        this.mNumberOfChildren = numberOfChildren;
    }

    public void setChangeOfChildrenDate(Date changeOfChildrenDate) {
        this.mChangeOfChildrenDate = changeOfChildrenDate;
    }

    public void setNumberOfChildrenAfter(int numberOfChildrenAfter) {
        this.mNumberOfChildrenAfter = numberOfChildrenAfter;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void checkEntryAndWithdrawal() throws BusinessDomainException {
        LOGGER.debug("Pnr: " + this.mEmployee.getDomainKey());
        String message = null;
        EEZVK[] eeZVKs = this.mEmployee.getEffectiveZVKHistory(VDate.getDateMax());
        Date entry = eeZVKs[0].getDateOfEntry();
        Date withdrawal = eeZVKs[0].getDateOfWithdrawl();
        LOGGER.debug("Eintritt: " + entry + " Austritt: " + withdrawal);
        int i = 1;
        while (i <= eeZVKs.length - 1) {
            Date validFrom;
            Date nextWithdrawal;
            Date nextEntry;
            block17: {
                nextEntry = eeZVKs[i].getDateOfEntry();
                nextWithdrawal = eeZVKs[i].getDateOfWithdrawl();
                validFrom = eeZVKs[i].getValidFrom();
                LOGGER.debug("n\u00e4chster Eintritt: " + nextEntry + " n\u00e4chster Austritt: " + nextWithdrawal);
                if (withdrawal == null && !DateHelper.equal((Date)nextEntry, (Date)entry)) {
                    Date minimumDate = DateHelper.max((Date)this.mEmployee.getMinimumDateOfEntry(), (Date)this.mEmployee.getPCompany().getCompanyFoundations(VDate.getDateMax(), VDate.getDateMax()).getCalculationStart());
                    if (DateHelper.before((Date)entry, (Date)minimumDate)) {
                        if (DateHelper.beforeOrEqual((Date)validFrom, (Date)minimumDate)) {
                            LOGGER.debug("Minimum von Eintritt-Besch\u00e4ftigung und Berechnungsstart: " + minimumDate);
                            break block17;
                        } else {
                            message = "neuer Eintritt ohne Austritt f\u00fcr g\u00fcltig ab: " + DateMapper.toDDMMYYYYPointSeparationString((Date)validFrom);
                            break;
                        }
                    }
                    if (DateHelper.after((Date)validFrom, (Date)DateHelper.getFirstDayOfMonth((Date)entry))) {
                        message = "neuer Eintritt ohne Austritt f\u00fcr g\u00fcltig ab: " + DateMapper.toDDMMYYYYPointSeparationString((Date)validFrom);
                        break;
                    }
                }
            }
            if (withdrawal != null) {
                if (DateHelper.equal((Date)nextEntry, (Date)entry) && DateHelper.equal((Date)nextWithdrawal, (Date)withdrawal)) {
                    ++i;
                    continue;
                }
                if (DateHelper.equal((Date)nextEntry, (Date)entry) && !DateHelper.equal((Date)nextWithdrawal, (Date)withdrawal) && !this.isWithdrawalReason0406(eeZVKs[i - 1]) && DateHelper.after((Date)validFrom, (Date)DateHelper.getFirstDayOfMonth((Date)withdrawal))) {
                    message = "neuer Austritt ohne neuen Eintritt oder Austritt falsch ge\u00e4ndert f\u00fcr g\u00fcltig ab: " + DateMapper.toDDMMYYYYPointSeparationString((Date)validFrom);
                    break;
                }
                if (!DateHelper.equal((Date)nextEntry, (Date)entry)) {
                    if (DateHelper.after((Date)validFrom, (Date)nextEntry)) {
                        message = "das Eintrittsdatum liegt vor dem g\u00fcltig ab: " + DateMapper.toDDMMYYYYPointSeparationString((Date)validFrom);
                        break;
                    }
                    if (DateHelper.equal((Date)nextWithdrawal, (Date)withdrawal)) {
                        message = "neuer Eintritt ohne vorherigen Austritt f\u00fcr g\u00fcltig ab: " + DateMapper.toDDMMYYYYPointSeparationString((Date)validFrom);
                        break;
                    }
                    if (DateHelper.beforeOrEqual((Date)validFrom, (Date)DateHelper.getFirstDayOfMonth((Date)withdrawal))) {
                        message = "neuer Eintritt ohne vorherigen Austritt(\u00fcberschrieben) f\u00fcr g\u00fcltig ab: " + DateMapper.toDDMMYYYYPointSeparationString((Date)validFrom);
                        break;
                    }
                    if (DateHelper.beforeOrEqual((Date)nextEntry, (Date)withdrawal)) {
                        message = "neuer Eintritt nicht gr\u00f6\u00dfer letztem Austritt f\u00fcr g\u00fcltig ab: " + DateMapper.toDDMMYYYYPointSeparationString((Date)validFrom);
                        break;
                    }
                    if (this.isWithdrawalReason0406(eeZVKs[i - 1]) && DateHelper.after((Date)nextEntry, (Date)DateHelper.tomorrow((Date)withdrawal))) {
                        message = "keine l\u00fcckenlose zvk-pflicht nach Abmeldung mit Grund 04 bzw. 06 f\u00fcr g\u00fcltig ab: " + DateMapper.toDDMMYYYYPointSeparationString((Date)validFrom);
                    }
                }
            }
            if (nextWithdrawal != null && DateHelper.before((Date)nextWithdrawal, (Date)nextEntry)) {
                message = "neuer Austritt kleiner Eintritt f\u00fcr g\u00fcltig ab: " + DateMapper.toDDMMYYYYPointSeparationString((Date)validFrom);
                break;
            }
            ++i;
            entry = nextEntry;
            withdrawal = nextWithdrawal;
        }
        if (message != null) {
            throw EmployeeExceptionMapper.makeZvkEntryWithdrawalHistoryFalseDomainException(message);
        }
    }

    public boolean isWithdrawalReason0406(EEZVK eeZvk) {
        return eeZvk.getDateOfWithdrawl() != null && eeZvk.getZVEReason() != null && (StringMapper.equal((String)eeZvk.getZVEReason().getDesignation(), (String)"04") || StringMapper.equal((String)eeZvk.getZVEReason().getDesignation(), (String)"06"));
    }

    public boolean getOnlyDateOfWithdrawalChanged() {
        return this.mOnlyDateOfWithdrawalChanged;
    }

    public void setOnlyDateOfWithdrawalChanged(boolean onlyDateOfWithdrawalChanged) {
        this.mOnlyDateOfWithdrawalChanged = onlyDateOfWithdrawalChanged;
    }

    public void setSpecialChecks(boolean specialChecks) {
        this.mSpecialChecks = specialChecks;
    }
}

