/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.employee.piecework;

import com.infor.igf.core.util.CloneUtils;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Conjunction;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.designationtype.costcenter.CostCenter;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.piecework.EEPieceWorkData;
import com.varial.personnel.domain.employee.piecework.EEPieceWorkFilterStruct;
import com.varial.personnel.domain.employee.piecework.EEPieceWorkPersistencyManager;
import com.varial.personnel.domain.employee.piecework.EEPieceWorkTP;
import com.varial.personnel.domain.employee.piecework.EEPieceWorkTPComparator;
import com.varial.personnel.domain.employee.piecework.EEPieceWorkTPPersistencyManager;
import com.varial.personnel.domain.employee.piecework.mapper.EEPieceWorkFilterStructMapper;
import com.varial.personnel.domain.typeofvalue.ValueType;
import com.varial.personnel.framework.PersonnelHistory;
import com.varial.personnel.framework.PersonnelPersistenceObject;
import com.varial.personnel.framework.PersonnelTimedPersistenceObject;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.persistency.IPersistentObject;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class EEPieceWork
extends PersonnelPersistenceObject<EEPieceWorkTP> {
    private static final int PRIORITY = 5;
    private Employee mEmployee;
    private ValueType mValueType;

    public EEPieceWork(Employee employee) {
        super(5);
        this.mEmployee = employee;
    }

    public static EEPieceWork getEEPieceWork(String objectID) {
        return new EEPieceWork(objectID);
    }

    public EEPieceWork(String objectID) {
        super(5, objectID);
    }

    public EEPieceWork(String objectId, int version) {
        super(5, objectId, version);
    }

    protected EEPieceWork(boolean readOnly) {
        super(5, readOnly);
    }

    protected void saveImpl() {
        EEPieceWorkPersistencyManager.save((EEPieceWork)this);
    }

    protected void load() {
        EEPieceWorkPersistencyManager.load((EEPieceWork)this);
    }

    protected void deleteImpl() {
        EEPieceWorkPersistencyManager.delete((EEPieceWork)this);
    }

    protected void destroyImpl() throws BusinessDomainException {
        EEPieceWorkTP[] totp;
        for (EEPieceWorkTP lElement : totp = this.getSpecialHistory()) {
            lElement.remove();
        }
    }

    public String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getDomainKey() {
        this.requireLoaded();
        return new StringBuffer().append(this.mEmployee.getDomainKey()).append(" / ").append(this.mValueType.getDomainKey()).toString();
    }

    public static EEPieceWork[] getEEPieceWork(Order[] sortierung, Criterion filters) {
        return EEPieceWorkPersistencyManager.query((Order[])sortierung, (Criterion)filters);
    }

    protected void setData(EEPieceWorkData data) {
        this.mEmployee = data.getEmployee();
        this.mValueType = data.getValueType();
    }

    public Employee getEmployee() {
        this.requireLoaded();
        return this.mEmployee;
    }

    public void setEmployee(Employee employee) {
        this.protocol("Employee", (IPersistentObject)this.mEmployee, (IPersistentObject)employee);
        this.mEmployee = employee;
    }

    public ValueType getValueType() {
        this.requireLoaded();
        return this.mValueType;
    }

    public void setValueType(ValueType valueType) {
        this.protocol("ValueType", (IPersistentObject)this.mValueType, (IPersistentObject)valueType);
        this.mValueType = valueType;
    }

    public PersonnelHistory<EEPieceWorkTP> getHistory() {
        this.requireLoaded();
        if (this.mHistory == null) {
            this.mHistory = new PersonnelHistory((PersonnelTimedPersistenceObject[])this.getSpecialHistory());
        }
        return this.mHistory;
    }

    public EEPieceWorkTP[] getEEPieceWorkTPs() {
        this.requireLoaded();
        return (EEPieceWorkTP[])this.listToArray(this.getHistory().getAll(), EEPieceWorkTP.class);
    }

    public EEPieceWorkTP[] getSpecialHistory() {
        if (this.isNew()) {
            return new EEPieceWorkTP[0];
        }
        return EEPieceWorkTPPersistencyManager.getEEPieceWorkHistory((EEPieceWork)this);
    }

    public EEPieceWorkTP[] getEEPieceWorkHistory(Date destinationTimePoint) {
        if (this.isNew()) {
            return new EEPieceWorkTP[0];
        }
        PersonnelHistory ph = new PersonnelHistory((PersonnelTimedPersistenceObject[])EEPieceWorkTPPersistencyManager.getEEPieceWorkHistory((EEPieceWork)this));
        List items = ph.getItems(destinationTimePoint);
        return items.toArray(new EEPieceWorkTP[items.size()]);
    }

    public EEPieceWorkTP getEEPieceWorkTP(Date effectiveTimePoint, Date validTimePoint) throws BusinessDomainException {
        this.requireLoaded();
        return (EEPieceWorkTP)this.getHistory().getItem(effectiveTimePoint, validTimePoint);
    }

    public EEPieceWorkTP[] getEffectivEEPieceWorkTP(Date effectivTimePoint) {
        return this.getEEPieceWorkHistory(effectivTimePoint);
    }

    public EEPieceWorkTP[] getCurrentEffectivEEPieceWorkTP() {
        List items = this.getHistory().getItems(new Date());
        return items.toArray(new EEPieceWorkTP[items.size()]);
    }

    public EEPieceWorkTP[] getActiveEffectiveEEPieceWorkHistory() {
        List items = this.getHistory().getItems(VDate.getDateMax());
        return items.toArray(new EEPieceWorkTP[items.size()]);
    }

    public EEPieceWorkTP getCurrentEEPieceWorkTP() throws BusinessDomainException {
        EEPieceWorkTP result = (EEPieceWorkTP)this.mHistory.getItem(new Date(), new Date());
        return result;
    }

    public EEPieceWorkTP[] getTimePeriods(EEPieceWorkTP ptpo) throws BusinessDomainException {
        return (EEPieceWorkTP[])this.getHistory().getPeriods((PersonnelTimedPersistenceObject)ptpo);
    }

    public static EEPieceWorkTP[] getActiveEEPieceWorks(EEPieceWorkFilterStruct[] idlFilters, Order[] sortierung) {
        Conjunction filters = Restrictions.conjunction();
        filters.add(EEPieceWorkFilterStructMapper.toFilter((EEPieceWorkFilterStruct[])idlFilters));
        Criterion crit = Restrictions.sqlRestriction((String)"validuntil = ( select max(validuntil) from eepieceworktp_T A where A.oideepiecework = eepieceworkall_v.oideepiecework and A.effectiveuntil = ? )", (String)VDate.getDateMaxAsString());
        filters.add(crit);
        EEPieceWorkTP[] eePieceWorkTPArray = EEPieceWorkTPPersistencyManager.queryAll((Order[])sortierung, (Criterion)filters, (boolean)true);
        if (sortierung == null || sortierung.length == 0) {
            Arrays.sort(eePieceWorkTPArray, new EEPieceWorkTPComparator());
        }
        return eePieceWorkTPArray;
    }

    public EEPieceWorkTP getActiveEEPieceWorkTP() {
        EEPieceWorkTP[] eePieceWorkTP = EEPieceWorkTPPersistencyManager.query(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oideepiecework", (String)this.getObjectid()), Restrictions.eq((String)"effectiveuntil", (String)VDate.getDateMaxAsString()), Restrictions.sqlRestriction((String)"validuntil = ( select max(validuntil) from eepieceworktp_T A where A.oideepiecework = eepieceworktp_t.oideepiecework and A.effectiveuntil = ? )", (String)VDate.getDateMaxAsString())}), (EEPieceWork)this, (boolean)true);
        if (eePieceWorkTP.length == 0) {
            throw ExceptionMapper.makeDataNotFoundPersistencyException((String)this.getObjectid());
        }
        return eePieceWorkTP[0];
    }

    public EEPieceWorkTP getObjectFromObjectId(Date effectiveTimePoint, Date validTimePoint) {
        EEPieceWorkTP[] tpArray;
        if (validTimePoint == null) {
            throw ExceptionMapper.makeApplicationException((String)"input validFrom is wrong");
        }
        if (effectiveTimePoint == null) {
            effectiveTimePoint = validTimePoint;
        }
        if (DateHelper.before((Date)effectiveTimePoint, (Date)validTimePoint)) {
            effectiveTimePoint = validTimePoint;
        }
        if ((tpArray = EEPieceWorkTPPersistencyManager.query(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oideepiecework", (String)this.getObjectid()), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)effectiveTimePoint)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)effectiveTimePoint)), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)validTimePoint)), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)validTimePoint))}), (EEPieceWork)this, (boolean)true)).length == 0) {
            throw ExceptionMapper.makeDataNotFoundPersistencyException((String)this.getObjectid());
        }
        return tpArray[0];
    }

    public void addHistory(EEPieceWorkTP eePieceWorkTP, boolean removeNew) throws BusinessDomainException {
        eePieceWorkTP.checkAttributes();
        EEPieceWorkTP[] changedArray = (EEPieceWorkTP[])this.listToArray(this.addVPItem(eePieceWorkTP, removeNew), EEPieceWorkTP.class);
        if (changedArray.length == 1) {
            eePieceWorkTP.setEffectiveFrom(DateHelper.tomorrow((Date)this.getEmployee().getJournalizedUntil()));
        }
        for (EEPieceWorkTP lElement : changedArray) {
            lElement.makeSaveable();
            lElement.registerForLastExecute();
        }
    }

    public void setHistory(EEPieceWorkTP eePieceWorkTP, boolean removeNew, Date oldEffectiveFrom) throws BusinessDomainException {
        EEPieceWorkTP[] changedArray;
        eePieceWorkTP.checkAttributes();
        if (DateHelper.equal((Date)eePieceWorkTP.getEffectiveFrom(), (Date)oldEffectiveFrom)) {
            changedArray = (EEPieceWorkTP[])this.listToArray(this.getHistory().setItem((PersonnelTimedPersistenceObject)eePieceWorkTP, removeNew), EEPieceWorkTP.class);
        } else {
            removeNew = true;
            changedArray = (EEPieceWorkTP[])this.listToArray(this.addVPItem(eePieceWorkTP, removeNew), EEPieceWorkTP.class);
        }
        for (EEPieceWorkTP lElement : changedArray) {
            lElement.makeSaveable();
            lElement.registerForLastExecute();
        }
    }

    public List<EEPieceWorkTP> addVPItem(EEPieceWorkTP eePieceWorkTP, boolean removeNew) throws BusinessDomainException {
        PersonnelHistory<EEPieceWorkTP> ph = this.getHistory();
        Date oldValidUntil = CloneUtils.clone((Date)VDate.getDateMax());
        Date oldValidFrom = CloneUtils.clone((Date)eePieceWorkTP.getValidFrom());
        Date oldEffectiveFrom = CloneUtils.clone((Date)eePieceWorkTP.getEffectiveFrom());
        if (eePieceWorkTP.getValidUntil() != null) {
            oldValidUntil = eePieceWorkTP.getValidUntil();
        }
        List changedList = ph.addItem((PersonnelTimedPersistenceObject)eePieceWorkTP, removeNew);
        for (int i = 0; i < changedList.size(); ++i) {
            EEPieceWorkTP wfTP = (EEPieceWorkTP)changedList.get(i);
            if (!DateHelper.equal((Date)wfTP.getValidFrom(), (Date)oldValidFrom) || !DateHelper.equal((Date)wfTP.getEffectiveFrom(), (Date)oldEffectiveFrom)) continue;
            wfTP.setValidUntil(oldValidUntil);
        }
        return changedList;
    }

    public void deleteEEPieceWork() throws BusinessDomainException {
        boolean deletable = true;
        PersonnelHistory<EEPieceWorkTP> eePieceWorkHistory = this.getHistory();
        for (int i = 0; i < eePieceWorkHistory.getSize(); ++i) {
            if (!((EEPieceWorkTP)eePieceWorkHistory.getItem(i)).getEffectiveFrom().before(this.mEmployee.getJournalizedUntil())) continue;
            deletable = false;
        }
        if (deletable) {
            this.makeSaveable();
            this.destroy();
        } else {
            this.deleteEEPieceWorkHistory();
        }
    }

    public void deleteEEPieceWorkHistory() throws BusinessDomainException {
        for (int i = 0; i < this.mHistory.getSize(); ++i) {
            if (((EEPieceWorkTP)this.mHistory.getItem(i)).inEffectiveness(this.mEmployee.getJournalizedUntil())) {
                ((EEPieceWorkTP)this.mHistory.getItem(i)).setEffectiveUntil(this.mEmployee.getJournalizedUntil());
                ((EEPieceWorkTP)this.mHistory.getItem(i)).makeSaveable();
                continue;
            }
            if (!DateHelper.after((Date)((EEPieceWorkTP)this.mHistory.getItem(i)).getEffectiveFrom(), (Date)this.mEmployee.getJournalizedUntil())) continue;
            ((EEPieceWorkTP)this.mHistory.getItem(i)).makeSaveable();
            ((EEPieceWorkTP)this.mHistory.getItem(i)).destroy();
        }
    }

    public void checkVWECostCenter(CostCenter costCenter, Date effectiveFrom, Date validFrom) throws BusinessDomainException {
        this.getEmployee().checkVWECostCenter(costCenter, effectiveFrom, validFrom);
    }
}

