/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.eel.eelaccount;

import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Conjunction;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Order;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.session.SessionContext;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.eel.EelAdvice;
import com.varial.personnel.domain.eel.EelEmployee;
import com.varial.personnel.domain.eel.eelaccount.EelAdviceStateEnum;
import com.varial.personnel.domain.eel.eelaccount.IEelAccountPersistencyManager;
import com.varial.personnel.domain.eel.eeldslw.EelDslw;
import com.varial.personnel.domain.elo2.account.Elo2Advice;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.IEmployeePersistencyManager;
import com.varial.personnel.domain.employee.IEmployeeReferenced;
import com.varial.personnel.domain.employee.absenttime.EEAbsentTimeTP;
import com.varial.personnel.domain.employee.absenttime.EEAbsentTimeTPPersistencyManager;
import com.varial.personnel.domain.global.deuv.recipient.DEUVRecipient;
import com.varial.personnel.domain.reports.ReportFirstFilterStruct;
import com.varial.personnel.framework.basictypes.PRestrictions;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.persistency.PersistentObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kernpruefung.Rueckgabe;

public class EelAccount
extends PersistentObject
implements IEmployeeReferenced {
    public static final String FD = ";";
    public static final String QM = "\"";
    public static final String LD = System.getProperty("line.separator");
    public static final String ZERO = "0";
    public static final String N = "N";
    public static final String J = "J";
    public static final String X = "X";
    private static final int PRIORITY = 1;
    private EelEmployee mEelEmployee;
    private Employee mEmployee;
    private Date mEffectiveFrom;
    private String mCreatedOn;
    private Date mValidFrom;
    private Date mValidUntil;
    private int mReasonOfDelivery;
    private boolean mTransmitted;
    private int mCurrentFileNumber;
    private String mCanceled;
    private String mErrorMessage;
    private String mAktenzeichenSV;
    private String mAktenzeichenVU;
    private EelAdviceStateEnum mAdviceState;
    private DEUVRecipient mDEUVRecipient;
    private EelDslw mEelDslw;

    public EelAccount(int priority) {
        super(priority);
    }

    public static EelAccount getEelAccount(String objectID) {
        return new EelAccount(objectID);
    }

    public EelAccount(Employee employee) {
        super(1);
        this.mEmployee = employee;
    }

    public EelAccount(Employee employee, boolean readOnly) {
        super(1, readOnly);
        this.mEmployee = employee;
    }

    public EelAccount(String objectID) {
        super(1, objectID);
    }

    public EelAccount(String objectID, int version) {
        super(1, objectID, version);
    }

    protected void load() {
        EelAccount.getIEelAccountPM().load(this);
    }

    protected void saveImpl() throws BusinessDomainException {
        EelAccount.getIEelAccountPM().save(this);
    }

    protected void deleteImpl() {
        EelAccount.getIEelAccountPM().delete(this);
    }

    protected void destroyImpl() throws BusinessDomainException {
        this.requireLoaded();
        if (this.mTransmitted) {
            throw new IllegalStateException("never destroy transmitted accounts!");
        }
        if (this.mEelDslw != null) {
            this.mEelDslw.destroy();
        }
    }

    public void makeReadOnly() {
        super.makeReadOnly();
        if (this.mEelDslw != null) {
            this.mEelDslw.makeReadOnly();
        }
    }

    public void makeSaveable() {
        super.makeSaveable();
        this.requireLoaded();
        if (this.mTransmitted) {
            return;
        }
        if (this.mEelDslw != null) {
            this.mEelDslw.makeSaveable();
        }
    }

    public String getClassName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getDomainKey() {
        return this.getObjectid();
    }

    public String getCreatedOn() {
        this.requireLoaded();
        return this.mCreatedOn;
    }

    public void setCreatedOn(String createdOn) {
        this.mCreatedOn = createdOn;
    }

    public int getCurrentFileNumber() {
        this.requireLoaded();
        return this.mCurrentFileNumber;
    }

    public void setCurrentFileNumber(int currentFileNumber) {
        this.mCurrentFileNumber = currentFileNumber;
    }

    public Date getEffectiveFrom() {
        this.requireLoaded();
        return this.mEffectiveFrom;
    }

    public void setEffectiveFrom(Date effectiveFrom) {
        this.mEffectiveFrom = effectiveFrom;
    }

    public Employee getEmployee() {
        this.requireLoaded();
        return this.mEmployee;
    }

    public void setEmployee(Employee employee) {
        this.mEmployee = employee;
    }

    public int getReasonOfDelivery() {
        this.requireLoaded();
        return this.mReasonOfDelivery;
    }

    public void setReasonOfDelivery(int reasonOfDelivery) {
        this.mReasonOfDelivery = reasonOfDelivery;
        if (this.mEelDslw != null) {
            this.mEelDslw.setAbgabegrund(reasonOfDelivery);
        }
    }

    public boolean getTransmitted() {
        this.requireLoaded();
        return this.mTransmitted;
    }

    public void setTransmitted(boolean transmitted) {
        this.mTransmitted = transmitted;
    }

    public Date getValidFrom() {
        this.requireLoaded();
        return this.mValidFrom;
    }

    public void setValidFrom(Date validFrom) {
        this.mValidFrom = validFrom;
    }

    public Date getValidUntil() {
        this.requireLoaded();
        return this.mValidUntil;
    }

    public void setValidUntil(Date validUntil) {
        this.mValidUntil = validUntil;
    }

    public String getCanceled() {
        this.requireLoaded();
        return this.mCanceled;
    }

    public void setCanceled(String canceled) {
        this.mCanceled = canceled;
    }

    public String getErrorMessage() {
        this.requireLoaded();
        return this.mErrorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.mErrorMessage = errorMessage;
    }

    public String getAktenzeichenSV() {
        this.requireLoaded();
        return this.mAktenzeichenSV;
    }

    public void setAktenzeichenSV(String aktenzeichenSV) {
        this.mAktenzeichenSV = aktenzeichenSV;
    }

    public String getAktenzeichenVU() {
        this.requireLoaded();
        return this.mAktenzeichenVU;
    }

    public void setAktenzeichenVU(String aktenzeichenVU) {
        this.mAktenzeichenVU = aktenzeichenVU;
    }

    public EelAdviceStateEnum getAdviceState() {
        this.requireLoaded();
        return this.mAdviceState;
    }

    public void setAdviceState(EelAdviceStateEnum adviceState) {
        this.mAdviceState = adviceState;
    }

    public EelEmployee getEelEmployee() {
        this.requireLoaded();
        return this.mEelEmployee;
    }

    public void setEelEmployee(EelEmployee eelEmployee) {
        this.mEelEmployee = eelEmployee;
    }

    public void updateUntransmitted(String createdOn) {
        this.requireLoaded();
        if (this.mTransmitted) {
            throw new IllegalStateException("never change transmitted accounts!");
        }
        this.mCreatedOn = createdOn;
        this.makeSaveable();
    }

    public EelDslw createEelDslw() {
        if (this.mEelDslw != null) {
            throw new IllegalStateException("EelDslw already exists");
        }
        this.mEelDslw = new EelDslw();
        this.mEelDslw.setEelAccount(this);
        return this.mEelDslw;
    }

    public void setEelDslw(EelDslw dslw) {
        this.mEelDslw = dslw;
    }

    public EelDslw getEelDslw() {
        if (this.mEelDslw == null) {
            EelDslw[] rs = EelDslw.getEelDslws((Criterion)Restrictions.eq((String)"oidEelAccount", (String)this.getObjectid()), null);
            if (rs.length != 1) {
                throw new IllegalStateException("Advice inconsistent, " + rs.length + " DSLW (not 1).");
            }
            this.mEelDslw = rs[0];
        }
        return this.mEelDslw;
    }

    public boolean isCancelled() {
        this.requireLoaded();
        return !StringMapper.equal((String)this.mCanceled, (String)N);
    }

    public EelAccount createNew() throws BusinessDomainException {
        EelAccount account = new EelAccount(this.mEmployee);
        account.mEelEmployee = this.getEelEmployee();
        account.mEelDslw = this.getEelDslw().createNew(account);
        account.mEffectiveFrom = this.getEffectiveFrom();
        account.mCreatedOn = this.getCreatedOn();
        account.mValidFrom = this.getValidFrom();
        account.mValidUntil = this.getValidUntil();
        account.mReasonOfDelivery = this.getReasonOfDelivery();
        account.mTransmitted = false;
        account.mCurrentFileNumber = 0;
        account.mCanceled = this.getCanceled();
        account.mAktenzeichenSV = this.getAktenzeichenSV();
        account.mAktenzeichenVU = this.getAktenzeichenVU();
        account.mAdviceState = this.getAdviceState();
        account.mDEUVRecipient = this.getDEUVRecipient();
        return account;
    }

    public void addError(String errorMessage) {
        this.mErrorMessage = StringMapper.isNullString((String)this.getErrorMessage()) ? errorMessage : this.mErrorMessage.trim() + ", " + errorMessage;
        if (this.mErrorMessage.length() > 254) {
            this.mErrorMessage = this.mErrorMessage.substring(0, 254);
        }
    }

    public void toStringValues(StringBuilder b) {
        b.append(this.mCanceled).append(',');
        b.append(this.mTransmitted ? J : N).append(',');
        b.append(this.mCreatedOn).append(',');
        b.append(DateMapper.toString((Date)this.mValidFrom)).append(',');
        b.append(DateMapper.toString((Date)this.mValidUntil)).append(',');
        if (this.mEmployee != null) {
            b.append(this.mEmployee.getDomainID()).append(',');
        }
    }

    public static EelAccount[] getEelAccount(String oidPCompany, String oidPlant, String oidEmployee, Date fromDate, Date untilDate, int reasonOfDelivery, int adviceState) throws BusinessDomainException {
        Order[] sort = new Order[]{Order.asc((String)"aktenzeichenvu"), Order.asc((String)"createdon")};
        Criterion filter = EelAccount.createFilterEelAccount(fromDate, untilDate, reasonOfDelivery, adviceState);
        if (filter == null) {
            return new EelAccount[0];
        }
        ArrayList<EelAccount> accounts = new ArrayList<EelAccount>();
        for (Criterion empFilter : EelAccount.getEmployeeFilter(oidPCompany, oidPlant, oidEmployee)) {
            EelAccount[] rows = EelAccount.getIEelAccountPM().query(sort, Restrictions.and((Criterion)filter, (Criterion)empFilter), true);
            accounts.addAll(Arrays.asList(rows));
        }
        return accounts.toArray(new EelAccount[accounts.size()]);
    }

    public static EelAccount[] getEelAccountByEeAbsentTime(String oidEmployee, String validFrom, int reasonOfDelivery) {
        Conjunction filter = Restrictions.conjunction();
        filter.add(Restrictions.eq((String)"oidEmployee", (String)oidEmployee));
        filter.add(Restrictions.eq((String)"validFrom", (String)validFrom));
        if (reasonOfDelivery != 0 && reasonOfDelivery != 1 && reasonOfDelivery != 2 && reasonOfDelivery != 3 && reasonOfDelivery != 11 && reasonOfDelivery != 12 && reasonOfDelivery != 21 && reasonOfDelivery != 22 && reasonOfDelivery != 23) {
            filter.add(Restrictions.eq((String)"reasonofdelivery", (String)String.valueOf(reasonOfDelivery)));
        } else {
            filter.add(Restrictions.ne((String)"reasonofdelivery", (String)"61"));
            filter.add(Restrictions.ne((String)"reasonofdelivery", (String)"62"));
            filter.add(Restrictions.ne((String)"reasonofdelivery", (String)"71"));
            filter.add(Restrictions.ne((String)"reasonofdelivery", (String)"41"));
        }
        filter.add(Restrictions.ne((String)"advicestate", (String)("" + EelAdviceStateEnum.toInt((EelAdviceStateEnum)EelAdviceStateEnum.VORSCHLAG_STORNO_GELOESCHT))));
        filter.add(Restrictions.ne((String)"advicestate", (String)("" + EelAdviceStateEnum.toInt((EelAdviceStateEnum)EelAdviceStateEnum.ABGELEHNT))));
        filter.add(Restrictions.eq((String)"canceled", (String)N));
        return EelAccount.getIEelAccountPM().query(null, (Criterion)filter, true);
    }

    public static EelAccount[] getEelAccountByEeAbsentTimeAI(String oidEmployee, String validFrom) {
        String[] reasons = new String[]{"21", "22", "23"};
        Order[] sort = new Order[]{Order.desc((String)"validfrom")};
        Conjunction filter = Restrictions.conjunction();
        filter.add(Restrictions.eq((String)"oidEmployee", (String)oidEmployee));
        filter.add(Restrictions.eq((String)"validFrom", (String)validFrom));
        filter.add(Restrictions.in((String)"reasonofdelivery", (String[])reasons));
        filter.add(Restrictions.ne((String)"advicestate", (String)("" + EelAdviceStateEnum.toInt((EelAdviceStateEnum)EelAdviceStateEnum.VORSCHLAG_STORNO_GELOESCHT))));
        return EelAccount.getIEelAccountPM().query(sort, (Criterion)filter, true);
    }

    public static EelAccount[] getEelAccount(String oidEmployee, Date validFrom, int reasonOfDelivery, EelAdviceStateEnum state) {
        Order[] sort = new Order[]{Order.desc((String)"createdon")};
        Conjunction filter = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)oidEmployee), Restrictions.ge((String)"validfrom", (String)DateMapper.toString((Date)validFrom)), Restrictions.eq((String)"reasonofdelivery", (String)("" + reasonOfDelivery)), Restrictions.eq((String)"advicestate", (String)("" + EelAdviceStateEnum.toInt((EelAdviceStateEnum)state))), Restrictions.eq((String)"errormessage", (String)"")});
        EelAccount[] result = EelAccount.getIEelAccountPM().query(sort, (Criterion)filter, true);
        return result;
    }

    public static boolean hasEelAccountToParse(String oidEmployee, Date validFrom, int reasonOfDelivery, int fileNumber) {
        Conjunction filter = Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)oidEmployee), Restrictions.eq((String)"validfrom", (String)DateMapper.toString((Date)validFrom)), Restrictions.eq((String)"reasonofdelivery", (String)("" + reasonOfDelivery)), Restrictions.eq((String)"currentfilenumber", (String)("" + fileNumber))});
        EelAccount[] result = EelAccount.getIEelAccountPM().query(null, (Criterion)filter, true);
        return result != null && result.length > 0;
    }

    private static IEelAccountPersistencyManager getIEelAccountPM() {
        return (IEelAccountPersistencyManager)UtilitiesManager.getBean((String)"eelAccountPersistencyManager", IEelAccountPersistencyManager.class);
    }

    public static List<Criterion> getEmployeeFilter(String oidPCompany, String oidPlant, String oidEmployee) {
        String[] oidEmployees = null;
        if (StringMapper.isNullString((String)oidEmployee)) {
            if (!StringMapper.isNullString((String)oidPlant)) {
                ReportFirstFilterStruct firstFilter = new ReportFirstFilterStruct();
                firstFilter.oidPlant = oidPlant;
                firstFilter.oidPCompany = oidPCompany;
                oidEmployees = EelAccount.getEmployeePM().getOidEmployees(oidPCompany, firstFilter);
            } else {
                oidEmployees = EelAccount.getEmployeePM().getOidEmployees(oidPCompany);
            }
            if (oidEmployees.length == 0) {
                return new ArrayList<Criterion>();
            }
            return PRestrictions.in((String)"oidemployee", (String[])oidEmployees);
        }
        ArrayList<Criterion> filter = new ArrayList<Criterion>();
        filter.add(Restrictions.eq((String)"oidEmployee", (String)oidEmployee));
        return filter;
    }

    private static Criterion createFilterEelAccount(Date fromDate, Date untilDate, int reasonOfDelivery, int adviceState) {
        Conjunction filter = Restrictions.conjunction();
        if (fromDate != null && untilDate != null) {
            filter.add(Restrictions.le((String)"createdon", (String)EelAdvice.formatEelTimestampForQuery(DateHelper.tomorrow((Date)untilDate))));
            filter.add(Restrictions.ge((String)"createdon", (String)EelAdvice.formatEelTimestampForQuery(fromDate)));
        } else if (fromDate != null && untilDate == null) {
            filter.add(Restrictions.ge((String)"createdon", (String)EelAdvice.formatEelTimestampForQuery(fromDate)));
        } else if (fromDate == null && untilDate != null) {
            filter.add(Restrictions.le((String)"createdon", (String)EelAdvice.formatEelTimestampForQuery(DateHelper.tomorrow((Date)untilDate))));
        }
        if (reasonOfDelivery > 0) {
            filter.add(Restrictions.eq((String)"reasonofdelivery", (String)String.valueOf(reasonOfDelivery)));
        }
        if (adviceState >= 0) {
            filter.add(Restrictions.eq((String)"advicestate", (String)("" + adviceState)));
        } else {
            filter.add(Restrictions.ne((String)"advicestate", (String)("" + EelAdviceStateEnum.toInt((EelAdviceStateEnum)EelAdviceStateEnum.VORSCHLAG_STORNO_GELOESCHT))));
        }
        return filter;
    }

    public EelAccount makeCancelation() throws BusinessDomainException {
        this.mCanceled = X;
        this.mAdviceState = EelAdviceStateEnum.VORSCHLAG_STORNO;
        this.makeSaveable();
        EelAccount storno = this.createNew();
        storno.mCanceled = J;
        storno.setLastuser(SessionContext.getInstance().getSession().getUserCode());
        EelDslw dslw = storno.getEelDslw();
        dslw.setKennzStorno(J);
        dslw.setFehlerKennz(ZERO);
        return storno;
    }

    public boolean hasErrors() {
        return this.mErrorMessage != null && !this.mErrorMessage.isEmpty();
    }

    public DEUVRecipient getDEUVRecipient() {
        this.requireLoaded();
        return this.mDEUVRecipient;
    }

    public void setDEUVRecipient(DEUVRecipient deuvRecipient) {
        this.mDEUVRecipient = deuvRecipient;
    }

    public void addIfError(Rueckgabe rueckgabe) {
        if (rueckgabe.getReturnCode() == 2 || rueckgabe.getReturnCode() == 3 || rueckgabe.getReturnCode() == 4) {
            for (String error : rueckgabe.getRueckgabeMeldungen()) {
                this.addError(error);
            }
        }
    }

    public static EelAccount[] getEelAccountsForCancelCheck(Date eelStart, String oidPCompany) {
        ArrayList<EelAccount> accounts = new ArrayList<EelAccount>();
        for (Criterion empFilter : EelAccount.getEmployeeFilter(oidPCompany, null, null)) {
            EelAccount[] rows = EelAccount.getEelAccountsForCancelCheck(eelStart, empFilter);
            accounts.addAll(Arrays.asList(rows));
        }
        return accounts.toArray(new EelAccount[accounts.size()]);
    }

    private static EelAccount[] getEelAccountsForCancelCheck(Date eelStart, Criterion empFilter) {
        Order[] sort = new Order[]{Order.asc((String)"aktenzeichenvu"), Order.asc((String)"createdon")};
        Conjunction filter = Restrictions.conjunction();
        Date date = DateHelper.addMonths((Date)VDate.getCurrentLocalizedDateAndTime(), (int)-6);
        if (DateHelper.before((Date)date, (Date)eelStart)) {
            date = eelStart;
        }
        filter.add(Restrictions.ge((String)"createdon", (String)Elo2Advice.formatElo2Timestamp((Date)date)));
        filter.add(Restrictions.eq((String)"advicestate", (String)("" + EelAdviceStateEnum.toInt((EelAdviceStateEnum)EelAdviceStateEnum.VERARBEITET))));
        filter.add(Restrictions.eq((String)"canceled", (String)N));
        filter.add(Restrictions.ne((String)"reasonofdelivery", (String)"41"));
        filter.add(Restrictions.ne((String)"reasonofdelivery", (String)"61"));
        filter.add(Restrictions.ne((String)"reasonofdelivery", (String)"62"));
        filter.add(Restrictions.ne((String)"reasonofdelivery", (String)"66"));
        filter.add(empFilter);
        return EelAccount.getIEelAccountPM().query(sort, (Criterion)filter, true);
    }

    private static IEmployeePersistencyManager getEmployeePM() {
        return (IEmployeePersistencyManager)UtilitiesManager.getBean((String)"employeePersistencyManager", IEmployeePersistencyManager.class);
    }

    public boolean hasModifications(EEAbsentTimeTP tp) {
        return !this.getValidUntil().equals(tp.getValidUntil());
    }

    public boolean isCancelationNewReason() {
        return this.getReasonOfDelivery() != 1 && this.getReasonOfDelivery() != 3 && this.getReasonOfDelivery() != 4 && this.getReasonOfDelivery() != 11 && this.getReasonOfDelivery() != 12 && this.getReasonOfDelivery() != 21 && this.getReasonOfDelivery() != 22 && this.getReasonOfDelivery() != 31;
    }

    public EEAbsentTimeTP getEEAbsentTimeTP() {
        Employee emp = null;
        emp = this.getEelEmployee() != null ? this.getEelEmployee().getEmployee() : this.getEmployee();
        EEAbsentTimeTP[] tps = EEAbsentTimeTPPersistencyManager.queryAll(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)emp.getObjectid()), Restrictions.eq((String)"deleted", (String)"F"), Restrictions.eq((String)"effectiveuntil", (String)DateMapper.toString((Date)VDate.getDateMax())), Restrictions.eq((String)"validfrom", (String)DateMapper.toString((Date)this.getValidFrom())), Restrictions.in((String)"deuvabsenttimekey", (String[])EelAdvice.getDeuvAbsentTimeKeys(this.getReasonOfDelivery()))}), (boolean)true);
        if (this.getReasonOfDelivery() == 4) {
            tps = EelAdvice.shrinkEEAbsentTimeTPListForReason04(tps);
        }
        if (tps.length < 1) {
            return null;
        }
        return tps[0];
    }

    public boolean isCancelDeleted(Date eelStart) {
        return this.getEelAccountsForCancelDeletedCheck(eelStart).length > 0;
    }

    private EelAccount[] getEelAccountsForCancelDeletedCheck(Date eelStart) {
        Order[] sort = new Order[]{Order.asc((String)"aktenzeichenvu"), Order.asc((String)"createdon")};
        Conjunction filter = Restrictions.conjunction();
        Date date = DateHelper.add((Date)VDate.getCurrentLocalizedDateAndTime(), (int)-6);
        if (DateHelper.before((Date)date, (Date)eelStart)) {
            date = eelStart;
        }
        filter.add(Restrictions.eq((String)"oidemployee", (String)this.getEmployee().getObjectid()));
        filter.add(Restrictions.eq((String)"validfrom", (String)DateMapper.toString((Date)this.getValidFrom())));
        filter.add(Restrictions.eq((String)"reasonofdelivery", (String)("" + this.getReasonOfDelivery())));
        filter.add(Restrictions.ge((String)"createdon", (String)Elo2Advice.formatElo2TimestampForQuery((Date)date)));
        filter.add(Restrictions.eq((String)"advicestate", (String)("" + EelAdviceStateEnum.toInt((EelAdviceStateEnum)EelAdviceStateEnum.VORSCHLAG_STORNO_GELOESCHT))));
        return EelAccount.getIEelAccountPM().query(sort, (Criterion)filter, true);
    }

    public boolean hasReason51(Date eelStart) {
        return this.getEelAccountsByReason51(eelStart).length > 0;
    }

    private EelAccount[] getEelAccountsByReason51(Date eelStart) {
        Order[] sort = new Order[]{Order.asc((String)"aktenzeichenvu"), Order.asc((String)"createdon")};
        Conjunction filter = Restrictions.conjunction();
        Date date = DateHelper.add((Date)VDate.getCurrentLocalizedDateAndTime(), (int)-6);
        if (DateHelper.before((Date)date, (Date)eelStart)) {
            date = eelStart;
        }
        filter.add(Restrictions.eq((String)"oidemployee", (String)this.getEmployee().getObjectid()));
        filter.add(Restrictions.eq((String)"validfrom", (String)DateMapper.toString((Date)this.getValidFrom())));
        filter.add(Restrictions.eq((String)"reasonofdelivery", (String)"51"));
        filter.add(Restrictions.eq((String)"canceled", (String)N));
        filter.add(Restrictions.ge((String)"createdon", (String)Elo2Advice.formatElo2TimestampForQuery((Date)date)));
        return EelAccount.getIEelAccountPM().query(sort, (Criterion)filter, true);
    }

    public static EelAccount getEelAccountOneOriginOrNull(String oidEmployee, Date validFrom, String[] reasons) {
        EelAccount[] result = EelAccount.getEelAccountOrigins(oidEmployee, validFrom, reasons, null);
        if (result != null && result.length == 1) {
            return result[0];
        }
        return null;
    }

    public static EelAccount[] getEelAccountOrigins(String oidEmployee, Date validFrom, String[] reasons, String[] states) {
        Conjunction filter = Restrictions.conjunction();
        filter.add(Restrictions.eq((String)"oidEmployee", (String)oidEmployee));
        filter.add(Restrictions.eq((String)"validFrom", (String)DateMapper.toString((Date)validFrom)));
        filter.add(Restrictions.in((String)"reasonofdelivery", (String[])reasons));
        if (states != null) {
            filter.add(Restrictions.in((String)"advicestate", (String[])states));
        }
        filter.add(Restrictions.ne((String)"advicestate", (String)("" + EelAdviceStateEnum.toInt((EelAdviceStateEnum)EelAdviceStateEnum.VORSCHLAG_STORNO_GELOESCHT))));
        filter.add(Restrictions.ne((String)"advicestate", (String)("" + EelAdviceStateEnum.toInt((EelAdviceStateEnum)EelAdviceStateEnum.VORSCHLAG_STORNO))));
        return EelAccount.getIEelAccountPM().query(null, (Criterion)filter, true);
    }

    public static EelAccount[] getEelAccountsByFileNr(String dateiNr, DEUVRecipient responder) {
        Conjunction filter = Restrictions.conjunction();
        filter.add(Restrictions.eq((String)"currentfilenumber", (String)dateiNr));
        filter.add(Restrictions.eq((String)"oiddeuvrecipient", (String)responder.getObjectid()));
        return EelAccount.getIEelAccountPM().query(null, (Criterion)filter, true);
    }

    public void cleanUp() throws BusinessDomainException {
        if (this.getEelDslw().getAbgabegrund() != 22 && this.getEelDslw().getAbgabegrund() != 31 && this.getEelDslw().hasMmDbvo() && this.getEelDslw().getDbvo().getAnzahlAu() < 1) {
            this.getEelDslw().getDbvo().makeSaveable();
            this.getEelDslw().getDbvo().destroy();
            this.getEelDslw().setMmDbvo(false);
            if (this.getEelDslw().getDblt() != null) {
                this.getEelDslw().getDblt().setVorer(N);
            }
        }
    }
}

