/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.deuv;

import com.varial.personnel.domain.deuv.DeuvBasicComponents;
import com.varial.personnel.domain.deuv.IDbanData;
import com.varial.personnel.domain.deuv.IDbgbData;
import com.varial.personnel.domain.deuv.IDbnaData;
import com.varial.personnel.domain.deuv.dbkv.DeuvDbkv;
import com.varial.personnel.domain.deuv.deuvaccount.DEUVAccount;
import com.varial.personnel.domain.deuv.deuvaccount.UVRiskPeriod;
import com.varial.personnel.domain.deuv.deuvdbme.DEUVDbme;
import com.varial.personnel.domain.deuv.deuvdbpa.IDeuvDbpa;
import com.varial.personnel.domain.deuv.deuvdbso.DEUVDbso;
import com.varial.personnel.domain.deuv.deuvdbst.DEUVDbst;
import com.varial.personnel.domain.deuv.deuvdbuv.DEUVDbuv;
import com.varial.personnel.domain.deuv.deuvdsbd.IDeuvDsbd;
import com.varial.personnel.domain.deuv.deuvdsfz.DEUVDsfz;
import com.varial.personnel.domain.deuv.deuvdsme.DEUVDsme;
import com.varial.personnel.domain.deuv.dsak.dbdl.IDsakDbdl;
import com.varial.personnel.domain.deuv.dsak.dbgd.IDsakDbgd;
import com.varial.personnel.domain.deuv.dsak.dbko.IDsakDbko;
import com.varial.personnel.domain.deuv.dsak.dbsl.IDsakDbsl;
import com.varial.personnel.domain.deuv.dsak.dbwu.IDsakDbwu;
import com.varial.personnel.domain.deuv.dsak.dsak.IDeuvDsak;
import com.varial.personnel.domain.deuv.dsvv.DEUVDsvv;
import java.math.BigDecimal;
import java.util.Date;

public final class DeuvComponents {
    private static final String DSMEBASEPATTERN_V10 = ".{15}.{15}10(\\d{20})\\d(?<FEHLERANZ>\\d)(.{12}).{2}(.{15})(.{20}).{15}.{20}.{15}(\\d{3})(\\d{2})(.{3})(?<MMME>[JN])(?<MMNA>[JN])(?<MMGB>[JN])(?<MMAN>[JN]).[JN][JN][JN][JN][JN]...[JN]...{2}(?<MMKV>[JN])..{20}(?<MMST>[ JN])..{7}.{8}(?<DsId>.{32}).{15}(?<DsIdUr>.{32}).{32}(?<HABBNR>.{15}).{7}(?<KennzKv>\\d).{98}.{100}(?<DatenBausteine>.*)";
    private static final String DSMEBASEPATTERN_V11 = ".{15}.{15}11(\\d{20})\\d(?<FEHLERANZ>\\d)(.{12}).{2}(.{15})(.{20}).{15}.{20}.{15}(\\d{3})(\\d{2})(.{3})(?<MMME>[JN])(?<MMNA>[JN])(?<MMGB>[JN])(?<MMAN>[JN]).[JN][JN][JN][JN][JN]...[JN]...{2}(?<MMKV>[JN])..{20}(?<MMST>[ JN])..{7}.{8}(?<DsId>.{32}).{15}(?<DsIdUr>.{32}).{32}(?<HABBNR>.{15}).{7}(?<KennzKv>\\d).{98}[ JN].{99}(?<DatenBausteine>.*)";
    public static final int DSME_LENGTH = 559;
    public static final String DSME_REST = "DatenBausteine";
    public static final String DBMEPATTERN = "DBME([JN])(.)(\\d{8})(\\d{8})\\d{2}.(\\d{6})(\\d{4})(.{9})(.)(.).(.)(\\d{6}).{93}(.*)";
    public static final int DBME_LENGTH = 147;
    public static final int DBME_REST_GROUP_V05 = 12;
    public static final String DBKVPATTERN = "DBKV([JN]).{2}(\\d{2})(\\d{8})(\\d{8}).{8}(\\d{8}).{27}(\\d{4})(.)(\\d{8})(\\d{8})(\\d{8}).{53}(.*)";
    public static final int DBKV_LENGTH = 150;
    public static final int DBKV_REST_GROUP = 11;
    public static final String DSBDPATTERN_V04 = "DSBDBTRAG(?<ABSN>.{15})(?<EPNR>.{15})04(?<ED>\\d{20})\\d(?<FEHLERANZ>\\d)(?<BBNRBB>.{15})(?<DTEREIGNIS>\\d{8}).{3}(?<BBNRAS>.{15})(?<GD>.{2}).{5}.{30}.{30}.{30}.{10}.{34}.{33}.{9}(?<RF>\\d{3})(?<RFERG>\\d{2}).{5}.{10}(?<KENNZEND>[ B]).{15}.{1}.{30}.{20}.{20}.{70}(?<AZVU>.{20})(?<DsId>.{32})(?<KENNZNAME>[JN])(?<KENNZANSCHRIFT>[JN])(?<KENNZANSPRECH>[JN]).{7}.{8}(?<MMPA>[JN])(?<MMTN>[JN]).{5}(?<DatenBausteine>.*)";
    public static final String DSBDPATTERN_V05 = "DSBDBTRAG(?<ABSN>.{15})(?<EPNR>.{15})05(?<ED>\\d{20})\\d(?<FEHLERANZ>\\d)(?<BBNRBB>.{15})(?<DTEREIGNIS>\\d{8}).{3}(?<BBNRAS>.{15})(?<GD>.{2}).{5}.{30}.{30}.{30}.{10}.{34}.{33}.{9}(?<RF>\\d{3})(?<RFERG>\\d{2})(?<UNRS>\\d{15})(?<KENNZEND>[ B]).{15}(?<KENNZUNRS>[JN]).{30}.{20}.{20}.{70}(?<AZVU>.{20})(?<DsId>.{32})(?<KENNZNAME>[JN])(?<KENNZANSCHRIFT>[JN])(?<KENNZANSPRECH>[JN]).{7}.{8}(?<MMPA>[JN])(?<MMTN>[JN]).{5}(?<DatenBausteine>.*)";
    public static final int DSBD_LENGTH = 541;
    public static final String DSFZPATTERN = "DSFZDEUEV(?<KENNZST>[JN])(?<ABSN>.{15})(?<EPNR>.{15})01(?<ED>\\d{20}).{7}.{8}(?<DsId>.{32})(?<DsIdUr>.{32})\\d(?<FEHLERANZ>\\d)(?<BBNRVU>.{15})(?<AZVU>.{20})(?<BBNRAS>.{15})(?<VSNR>.{12})(?<GD>\\d{2})(?<BE>\\d{8})(?<EE>\\d{8}).{100}(?<MMNA>[JN])(?<MMGB>[JN])(?<MMAN>[JN])(?<DatenBausteine>.*)";
    public static final int DSFZ_LENGTH = 326;
    public static final String DSAKPATTERN_V02 = "DSAKDEUEV(?<KENNZST>[JN])(?<ABSN>.{15})(?<EPNR>.{15})02(?<ED>\\d{20}).{7}.{8}(?<DsId>.{32})(?<DsIdUr>.{32})\\d(?<FEHLERANZ>\\d)(?<BBNRVU>.{15})(?<AZVU>.{20})(?<BBNRAS>.{15})(?<GD>\\d{2}).{100}(?<MMGD>[JN])(?<MMKO>[JN])(?<MMDL>[JN])(?<MMWA>[JN])(?<MMSL>[JN]).{100}(?<DatenBausteine>.*)";
    public static final String DSAKPATTERN_V03 = "DSAKDEUEV(?<KENNZST>[JN])(?<ABSN>.{15})(?<EPNR>.{15})03(?<ED>\\d{20}).{7}.{8}(?<DsId>.{32})(?<DsIdUr>.{32})\\d(?<FEHLERANZ>\\d)(?<BBNRVU>.{15})(?<AZVU>.{20})(?<BBNRAS>.{15})(?<GD>\\d{2}).{100}(?<MMGD>[JN])(?<MMKO>[JN])(?<MMDL>[JN])(?<MMWA>[JN])(?<MMSL>[JN]).{100}(?<DatenBausteine>.*)";
    public static final int DSAK_LENGTH = 400;

    private DeuvComponents() {
    }

    public static String getContentDeuvAccount(DEUVAccount account) {
        StringBuilder builder = new StringBuilder();
        DEUVDsme deuvDsme = account.getDEUVDsme();
        builder.append(DeuvComponents.getContentDsme(deuvDsme));
        if (account.getDEUVDbme() != null) {
            builder.append(DeuvComponents.getContentDbme(account.getDEUVDbme()));
        }
        if (account.getDEUVDbna() != null) {
            builder.append(DeuvBasicComponents.getContentDbna((IDbnaData)account.getDEUVDbna()));
        }
        if (account.getDEUVDbgb() != null) {
            builder.append(DeuvBasicComponents.getContentDbgb((IDbgbData)account.getDEUVDbgb()));
        }
        if (account.getDEUVDban() != null) {
            builder.append(DeuvBasicComponents.getContentDban((IDbanData)account.getDEUVDban()));
        }
        if (account.getDEUVDbuv() != null) {
            builder.append(DeuvComponents.getContentDbuv(account.getDEUVDbuv()));
        }
        if (account.getDEUVDbso() != null) {
            builder.append(DeuvComponents.getContentDbso(account.getDEUVDbso()));
        }
        if (account.getDeuvDbkv() != null) {
            builder.append(DeuvComponents.getContentDbkv(account.getDeuvDbkv()));
        }
        if (account.getDeuvDbst() != null) {
            builder.append(DeuvComponents.getContentDbst(account.getDeuvDbst()));
        }
        return builder.toString();
    }

    public static String getContentDsme(DEUVDsme dsme) {
        StringBuilder builder = new StringBuilder();
        DeuvBasicComponents.append((StringBuilder)builder, (String)"DSME", (int)4);
        DeuvBasicComponents.append((StringBuilder)builder, (String)"DEUEV", (int)5);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsme.getBbnrAbsender(), (int)15);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsme.getBbnrEmpfaenger(), (int)15);
        DeuvBasicComponents.appNum((StringBuilder)builder, (String)dsme.getVersionsNr(), (int)2);
        DeuvBasicComponents.appNum((StringBuilder)builder, (String)dsme.getDatumErstellung(), (int)20);
        DeuvBasicComponents.appNum((StringBuilder)builder, (String)"0", (int)1);
        DeuvBasicComponents.appNum((StringBuilder)builder, (String)"0", (int)1);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsme.getVersicherungsnr(), (int)12);
        DeuvBasicComponents.append((StringBuilder)builder, (String)"", (int)2);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsme.getBbnrVerursacher(), (int)15);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsme.getAzVerursacher(), (int)20);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsme.getBbnrKrankenkasse(), (int)15);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsme.getAzKrankenkasse(), (int)20);
        DeuvBasicComponents.append((StringBuilder)builder, (String)"", (int)15);
        DeuvBasicComponents.appNum((StringBuilder)builder, (int)dsme.getPersonengruppe(), (int)3);
        DeuvBasicComponents.appNum((StringBuilder)builder, (String)dsme.getAbgabegrund(), (int)2);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsme.getStaat(), (int)3);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsme.getMmMeldedaten(), (int)1);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsme.getMmName(), (int)1);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsme.getMmGeburtsangaben(), (int)1);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsme.getMmAnschrift(), (int)1);
        DeuvBasicComponents.append((StringBuilder)builder, (String)"", (int)1);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsme.getMmUvDaten(), (int)1);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsme.getMmKnappschaftSee(), (int)1);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsme.getMmSva(), (int)1);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsme.getMmVergabeRueck(), (int)1);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsme.getMmRueckGrv(), (int)1);
        DeuvBasicComponents.append((StringBuilder)builder, (String)"", (int)3);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsme.getMmSoDaten(), (int)1);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsme.getStatuskennzeichen(), (int)1);
        DeuvBasicComponents.append((StringBuilder)builder, (String)"", (int)1);
        DeuvBasicComponents.append((StringBuilder)builder, (String)"", (int)2);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsme.getMmKv(), (int)1);
        DeuvBasicComponents.append((StringBuilder)builder, (String)"", (int)1);
        DeuvBasicComponents.appNum((StringBuilder)builder, (String)"", (int)20);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsme.getMmSteuerdaten(), (int)1);
        DeuvBasicComponents.append((StringBuilder)builder, (String)"", (int)1);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsme.getProdId(), (int)7);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsme.getModId(), (int)8);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsme.getDatensatzId(), (int)32);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsme.getBbnrAbsender(), (int)15);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsme.getDatensatzIdUrsprung(), (int)32);
        DeuvBasicComponents.append((StringBuilder)builder, (String)"", (int)32);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsme.getHauptbetriebsnummer(), (int)15);
        DeuvBasicComponents.append((StringBuilder)builder, (String)"", (int)7);
        DeuvBasicComponents.appNum((StringBuilder)builder, (int)dsme.getKennzkv(), (int)1);
        DeuvBasicComponents.append((StringBuilder)builder, (String)"", (int)98);
        DeuvBasicComponents.append((StringBuilder)builder, (String)"", (int)100);
        return builder.toString();
    }

    public static String getContentDbme(DEUVDbme dbme) {
        StringBuilder builder = new StringBuilder();
        DeuvBasicComponents.append((StringBuilder)builder, (String)"DBME", (int)4);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dbme.getStornokennzeichen(), (int)1);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dbme.getGleitzone(), (int)1);
        DeuvBasicComponents.appDate((StringBuilder)builder, (Date)dbme.getBeginn(), (int)8);
        DeuvBasicComponents.appDate((StringBuilder)builder, (Date)dbme.getEnde(), (int)8);
        DeuvBasicComponents.appNum((StringBuilder)builder, (int)0, (int)2);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dbme.getWaehrung(), (int)1);
        DeuvBasicComponents.appNk0((StringBuilder)builder, (BigDecimal)dbme.getEntgelt(), (int)6);
        DeuvBasicComponents.appNum((StringBuilder)builder, (String)dbme.getBeitragsgruppe(), (int)4);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dbme.getTaetigkeitssl(), (int)9);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dbme.getRechtskreis(), (int)1);
        DeuvBasicComponents.append((StringBuilder)builder, (String)"", (int)1);
        DeuvBasicComponents.appNum((StringBuilder)builder, (int)0, (int)1);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dbme.getKennzSaisonarbeitnehmer(), (int)1);
        DeuvBasicComponents.appNk0((StringBuilder)builder, (BigDecimal)dbme.getEntgeltRb(), (int)6);
        DeuvBasicComponents.append((StringBuilder)builder, (String)"", (int)93);
        return builder.toString();
    }

    public static String getContentDbst(DEUVDbst dbst) {
        StringBuilder builder = new StringBuilder();
        DeuvBasicComponents.append((StringBuilder)builder, (String)"DBST", (int)4);
        DeuvBasicComponents.appNum((StringBuilder)builder, (int)dbst.getSteuerart(), (int)1);
        DeuvBasicComponents.appNum((StringBuilder)builder, (String)dbst.getStag(), (int)13);
        DeuvBasicComponents.appNum((StringBuilder)builder, (String)dbst.getIdnran(), (int)11);
        return builder.toString();
    }

    public static String getContentDbuv(DEUVDbuv dbuv) {
        StringBuilder builder = new StringBuilder();
        DeuvBasicComponents.append((StringBuilder)builder, (String)"DBUV", (int)4);
        DeuvBasicComponents.appNum((StringBuilder)builder, (String)dbuv.getAnzahlUV(), (int)1);
        for (UVRiskPeriod each : dbuv.getUVRiskPeriods()) {
            DeuvBasicComponents.append((StringBuilder)builder, (String)each.getUVGrund(), (int)3);
            DeuvBasicComponents.append((StringBuilder)builder, (String)each.getBbnrUV(), (int)15);
            DeuvBasicComponents.append((StringBuilder)builder, (String)each.getMitgliedsNr(), (int)20);
            DeuvBasicComponents.appNum((StringBuilder)builder, (String)each.getUnrs(), (int)15);
            DeuvBasicComponents.append((StringBuilder)builder, (String)each.getBbnrGTS(), (int)15);
            DeuvBasicComponents.append((StringBuilder)builder, (String)each.getGtStelle(), (int)8);
            DeuvBasicComponents.appNk0((StringBuilder)builder, (BigDecimal)each.getUvEntgelt(), (int)6);
            DeuvBasicComponents.append((StringBuilder)builder, (String)"", (int)4);
        }
        return builder.toString();
    }

    public static String getContentDbso(DEUVDbso dbso) {
        StringBuilder builder = new StringBuilder();
        DeuvBasicComponents.append((StringBuilder)builder, (String)"DBSO", (int)4);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dbso.getStornokennzeichen(), (int)1);
        DeuvBasicComponents.appDate((StringBuilder)builder, (Date)dbso.getBeginn(), (int)8);
        return builder.toString();
    }

    public static String getContentDbkv(DeuvDbkv dbkv) {
        StringBuilder builder = new StringBuilder();
        DeuvBasicComponents.append((StringBuilder)builder, (String)"DBKV", (int)4);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dbkv.getKennzst(), (int)1);
        DeuvBasicComponents.appNum((StringBuilder)builder, (String)"", (int)2);
        DeuvBasicComponents.appNum((StringBuilder)builder, (int)dbkv.getSvtg(), (int)2);
        DeuvBasicComponents.appDate((StringBuilder)builder, (Date)dbkv.getZrbgkv(), (int)8);
        DeuvBasicComponents.appDate((StringBuilder)builder, (Date)dbkv.getZrenkv(), (int)8);
        DeuvBasicComponents.appNum((StringBuilder)builder, (String)"", (int)8);
        DeuvBasicComponents.appCents((StringBuilder)builder, (BigDecimal)dbkv.getEzeg(), (int)8);
        DeuvBasicComponents.append((StringBuilder)builder, (String)"", (int)27);
        DeuvBasicComponents.appNum((StringBuilder)builder, (String)dbkv.getBygr(), (int)4);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dbkv.getKennzrk(), (int)1);
        DeuvBasicComponents.appCents((StringBuilder)builder, (BigDecimal)dbkv.getLfdkv(), (int)8);
        DeuvBasicComponents.appCents((StringBuilder)builder, (BigDecimal)dbkv.getLfdrv(), (int)8);
        DeuvBasicComponents.appCents((StringBuilder)builder, (BigDecimal)dbkv.getLfdav(), (int)8);
        DeuvBasicComponents.append((StringBuilder)builder, (String)"", (int)53);
        return builder.toString();
    }

    public static String getContentDsbd(IDeuvDsbd dsbd) {
        StringBuilder builder = new StringBuilder();
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsbd.getKennung(), (int)4);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsbd.getVerfahren(), (int)5);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsbd.getBbnrAbsender(), (int)15);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsbd.getBbnrEmpfaenger(), (int)15);
        DeuvBasicComponents.appNum((StringBuilder)builder, (String)dsbd.getVersionNr(), (int)2);
        DeuvBasicComponents.appNum((StringBuilder)builder, (String)dsbd.getDatumErstellung(), (int)20);
        DeuvBasicComponents.appNum((StringBuilder)builder, (String)"0", (int)1);
        DeuvBasicComponents.appNum((StringBuilder)builder, (String)"0", (int)1);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsbd.getBbnrBeschBetrieb(), (int)15);
        DeuvBasicComponents.appDate((StringBuilder)builder, (Date)dsbd.getDatumEreignis(), (int)8);
        DeuvBasicComponents.append((StringBuilder)builder, (String)"", (int)3);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsbd.getBbnrAbrstelle(), (int)15);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsbd.getAbgabegrund(), (int)2);
        DeuvBasicComponents.append((StringBuilder)builder, (String)"", (int)5);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsbd.getName1(), (int)30);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsbd.getName2(), (int)30);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsbd.getName3(), (int)30);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsbd.getPostleitzahl(), (int)10);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsbd.getOrt(), (int)34);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsbd.getStrasse(), (int)33);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsbd.getHausnummer(), (int)9);
        DeuvBasicComponents.appNum((StringBuilder)builder, (String)dsbd.getRechtsform(), (int)3);
        DeuvBasicComponents.appNum((StringBuilder)builder, (String)dsbd.getRechtsformergaenzung(), (int)2);
        DeuvBasicComponents.appNum((StringBuilder)builder, (String)dsbd.getUnrs(), (int)15);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsbd.getKennzBeendigung(), (int)1);
        DeuvBasicComponents.append((StringBuilder)builder, (String)"", (int)15);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsbd.getKennzunrs(), (int)1);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsbd.getNameAP(), (int)30);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsbd.getTelefonAP(), (int)20);
        DeuvBasicComponents.append((StringBuilder)builder, (String)"", (int)20);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsbd.getEmailAP(), (int)70);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsbd.getAzVerursacher(), (int)20);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsbd.getDatensatzId(), (int)32);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsbd.getKennzName(), (int)1);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsbd.getKennzAnschrift(), (int)1);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsbd.getKennzAP(), (int)1);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsbd.getProdId(), (int)7);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsbd.getModId(), (int)8);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsbd.getMmAbwanschrift(), (int)1);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsbd.getMmTeilnahmepflicht(), (int)1);
        DeuvBasicComponents.append((StringBuilder)builder, (String)"", (int)5);
        if (dsbd.hasMmpa()) {
            builder.append(DeuvComponents.getContentDbpa((IDeuvDbpa)dsbd.getDbpa()));
        }
        return builder.toString();
    }

    private static String getContentDbpa(IDeuvDbpa dbpa) {
        StringBuilder builder = new StringBuilder();
        DeuvBasicComponents.append((StringBuilder)builder, (String)dbpa.getKennung(), (int)4);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dbpa.getName1(), (int)30);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dbpa.getName2(), (int)30);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dbpa.getName3(), (int)30);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dbpa.getPostleitzahl(), (int)10);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dbpa.getOrt(), (int)34);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dbpa.getStrasse(), (int)33);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dbpa.getHausnummer(), (int)9);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dbpa.getPlzpostfach(), (int)10);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dbpa.getPostfach(), (int)10);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dbpa.getLaenderkennzeichen(), (int)3);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dbpa.getKennzLoeschenPa(), (int)1);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dbpa.getArtPostanschrift(), (int)1);
        DeuvBasicComponents.append((StringBuilder)builder, (String)"", (int)3);
        return builder.toString();
    }

    public static String getContentDsak(IDeuvDsak dsak) {
        StringBuilder builder = new StringBuilder();
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsak.getKennung(), (int)4);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsak.getVerfahren(), (int)5);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsak.getKennzStorno(), (int)1);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsak.getBbnrAbsender(), (int)15);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsak.getBbnrEmpfaenger(), (int)15);
        DeuvBasicComponents.appNum((StringBuilder)builder, (String)dsak.getVersionsNr(), (int)2);
        DeuvBasicComponents.appNum((StringBuilder)builder, (String)dsak.getDatumErstellung(), (int)20);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsak.getProdId(), (int)7);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsak.getModId(), (int)8);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsak.getDatensatzId(), (int)32);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsak.getDatensatzIdUrsprung(), (int)32);
        DeuvBasicComponents.appNum((StringBuilder)builder, (String)"0", (int)1);
        DeuvBasicComponents.appNum((StringBuilder)builder, (String)"0", (int)1);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsak.getBbnrVerursacher(), (int)15);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsak.getAzVerursacher(), (int)20);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsak.getBbnrAbrechnungsstelle(), (int)15);
        DeuvBasicComponents.appNum((StringBuilder)builder, (int)dsak.getAbgabegrund(), (int)2);
        DeuvBasicComponents.append((StringBuilder)builder, (String)"", (int)100);
        DeuvBasicComponents.appBool((StringBuilder)builder, (boolean)dsak.hasMmGd());
        DeuvBasicComponents.appBool((StringBuilder)builder, (boolean)dsak.hasMmKo());
        DeuvBasicComponents.appBool((StringBuilder)builder, (boolean)dsak.hasMmDl());
        DeuvBasicComponents.appBool((StringBuilder)builder, (boolean)dsak.hasMmWa());
        DeuvBasicComponents.appBool((StringBuilder)builder, (boolean)dsak.hasMmSl());
        DeuvBasicComponents.append((StringBuilder)builder, (String)"", (int)100);
        if (dsak.hasMmGd()) {
            builder.append(DeuvComponents.getContentDbgd((IDsakDbgd)dsak.getDbgd()));
        }
        if (dsak.hasMmKo()) {
            builder.append(DeuvComponents.getContentDbko((IDsakDbko)dsak.getDbko()));
        }
        if (dsak.hasMmDl()) {
            builder.append(DeuvComponents.getContentDbdl((IDsakDbdl)dsak.getDbdl()));
        }
        if (dsak.hasMmWa()) {
            builder.append(DeuvComponents.getContentDbwu((IDsakDbwu)dsak.getDbwu()));
        }
        if (dsak.hasMmSl()) {
            builder.append(DeuvComponents.getContentDbsl((IDsakDbsl)dsak.getDbsl()));
        }
        return builder.toString();
    }

    private static String getContentDbgd(IDsakDbgd dbgd) {
        StringBuilder builder = new StringBuilder();
        DeuvBasicComponents.append((StringBuilder)builder, (String)dbgd.getKennung(), (int)4);
        DeuvBasicComponents.appDate((StringBuilder)builder, (Date)dbgd.getGueltigAb(), (int)8);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dbgd.getNameAP(), (int)30);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dbgd.getTelAP(), (int)20);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dbgd.getEmailAP(), (int)70);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dbgd.getNameAddressAG().getName1(), (int)30);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dbgd.getNameAddressAG().getName2(), (int)30);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dbgd.getNameAddressAG().getName3(), (int)30);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dbgd.getNameAddressAG().getPostleitzahl(), (int)10);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dbgd.getNameAddressAG().getOrt(), (int)34);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dbgd.getNameAddressAG().getStrasse(), (int)33);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dbgd.getNameAddressAG().getHausnummer(), (int)9);
        DeuvBasicComponents.appNum((StringBuilder)builder, (String)dbgd.getRechtsform(), (int)5);
        return builder.toString();
    }

    private static String getContentDbko(IDsakDbko dbko) {
        StringBuilder builder = new StringBuilder();
        DeuvBasicComponents.append((StringBuilder)builder, (String)dbko.getKennung(), (int)4);
        DeuvBasicComponents.appDate((StringBuilder)builder, (Date)dbko.getGueltigAb(), (int)8);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dbko.getKorrespondenzAnschrift().getName1(), (int)30);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dbko.getKorrespondenzAnschrift().getName2(), (int)30);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dbko.getKorrespondenzAnschrift().getName3(), (int)30);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dbko.getKorrespondenzAnschrift().getPostleitzahl(), (int)10);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dbko.getKorrespondenzAnschrift().getOrt(), (int)34);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dbko.getKorrespondenzAnschrift().getStrasse(), (int)33);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dbko.getKorrespondenzAnschrift().getHausnummer(), (int)9);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dbko.getKorrespondenzAnschrift().getPostfach(), (int)10);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dbko.getKorrespondenzAnschrift().getLaenderKennz(), (int)3);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dbko.getKennzloeschen(), (int)1);
        return builder.toString();
    }

    private static String getContentDbdl(IDsakDbdl dbdl) {
        StringBuilder builder = new StringBuilder();
        DeuvBasicComponents.append((StringBuilder)builder, (String)dbdl.getKennung(), (int)4);
        DeuvBasicComponents.appDate((StringBuilder)builder, (Date)dbdl.getGueltigAb(), (int)8);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dbdl.getNameAP(), (int)30);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dbdl.getTelAP(), (int)20);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dbdl.getEmailAP(), (int)70);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dbdl.getAnschriftDL().getName1(), (int)30);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dbdl.getAnschriftDL().getName2(), (int)30);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dbdl.getAnschriftDL().getName3(), (int)30);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dbdl.getAnschriftDL().getPostleitzahl(), (int)10);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dbdl.getAnschriftDL().getOrt(), (int)34);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dbdl.getAnschriftDL().getStrasse(), (int)33);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dbdl.getAnschriftDL().getHausnummer(), (int)9);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dbdl.getAnschriftDL().getPostfach(), (int)10);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dbdl.getAnschriftDL().getLaenderKennz(), (int)3);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dbdl.getKennzloeschen(), (int)1);
        return builder.toString();
    }

    private static String getContentDbwu(IDsakDbwu dbwu) {
        StringBuilder builder = new StringBuilder();
        DeuvBasicComponents.append((StringBuilder)builder, (String)dbwu.getKennung(), (int)4);
        DeuvBasicComponents.appDate((StringBuilder)builder, (Date)dbwu.getGueltigAb(), (int)8);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dbwu.getTeilnahmeU1(), (int)1);
        DeuvBasicComponents.appNk2((StringBuilder)builder, (BigDecimal)dbwu.getErstattungssatz(), (int)5);
        return builder.toString();
    }

    private static String getContentDbsl(IDsakDbsl dbsl) {
        StringBuilder builder = new StringBuilder();
        DeuvBasicComponents.append((StringBuilder)builder, (String)dbsl.getKennung(), (int)4);
        DeuvBasicComponents.appDate((StringBuilder)builder, (Date)dbsl.getGueltigAb(), (int)8);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dbsl.getGlaeubigerId(), (int)35);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dbsl.getKontoinhaber(), (int)30);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dbsl.getStrasse(), (int)33);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dbsl.getHausnummer(), (int)9);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dbsl.getPostleitzahl(), (int)10);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dbsl.getOrt(), (int)34);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dbsl.getIban(), (int)34);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dbsl.getKennzw(), (int)1);
        DeuvBasicComponents.append((StringBuilder)builder, (String)"", (int)49);
        return builder.toString();
    }

    public static String getContentDsfz(DEUVDsfz dsfz) {
        StringBuilder builder = new StringBuilder();
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsfz.getKennung(), (int)4);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsfz.getVerfahren(), (int)5);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsfz.getKennzst(), (int)1);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsfz.getAbsn(), (int)15);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsfz.getEpnr(), (int)15);
        DeuvBasicComponents.appNum((StringBuilder)builder, (String)dsfz.getVernr(), (int)2);
        DeuvBasicComponents.appNum((StringBuilder)builder, (String)dsfz.getEd(), (int)20);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsfz.getProdid(), (int)7);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsfz.getModid(), (int)8);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsfz.getDsid(), (int)32);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsfz.getDsidur(), (int)32);
        DeuvBasicComponents.appNum((StringBuilder)builder, (String)"0", (int)1);
        DeuvBasicComponents.appNum((StringBuilder)builder, (String)"0", (int)1);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsfz.getBbnrvu(), (int)15);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsfz.getAzvu(), (int)20);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsfz.getBbnras(), (int)15);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsfz.getVsnr(), (int)12);
        DeuvBasicComponents.appNum((StringBuilder)builder, (int)dsfz.getGd(), (int)2);
        DeuvBasicComponents.appDate((StringBuilder)builder, (Date)dsfz.getBe(), (int)8);
        DeuvBasicComponents.appDate((StringBuilder)builder, (Date)dsfz.getEe(), (int)8);
        DeuvBasicComponents.append((StringBuilder)builder, (String)"", (int)100);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsfz.getMmna(), (int)1);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsfz.getMmgb(), (int)1);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsfz.getMman(), (int)1);
        if ("J".equals(dsfz.getMmna())) {
            builder.append(DeuvBasicComponents.getContentDbna((IDbnaData)dsfz.getDeuvDbna()));
        }
        if ("J".equals(dsfz.getMmgb())) {
            builder.append(DeuvBasicComponents.getContentDbgb((IDbgbData)dsfz.getDeuvDbgb()));
        }
        if ("J".equals(dsfz.getMman())) {
            builder.append(DeuvBasicComponents.getContentDban((IDbanData)dsfz.getDeuvDban()));
        }
        return builder.toString();
    }

    public static String getContentDsvv(DEUVDsvv dsvv) {
        StringBuilder builder = new StringBuilder();
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsvv.getKennung(), (int)4);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsvv.getVerfahren(), (int)5);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsvv.getAbsn(), (int)15);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsvv.getEpnr(), (int)15);
        DeuvBasicComponents.appNum((StringBuilder)builder, (String)dsvv.getVernr(), (int)2);
        DeuvBasicComponents.appNum((StringBuilder)builder, (String)dsvv.getEd(), (int)20);
        DeuvBasicComponents.appNum((StringBuilder)builder, (String)"0", (int)1);
        DeuvBasicComponents.appNum((StringBuilder)builder, (String)"0", (int)1);
        DeuvBasicComponents.append((StringBuilder)builder, (String)"", (int)12);
        DeuvBasicComponents.appNum((StringBuilder)builder, (String)"0", (int)1);
        DeuvBasicComponents.append((StringBuilder)builder, (String)"", (int)1);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsvv.getBbnrvu(), (int)15);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsvv.getAzvu(), (int)20);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsvv.getDsid(), (int)32);
        DeuvBasicComponents.append((StringBuilder)builder, (String)"", (int)2);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsvv.getMmueb(), (int)1);
        DeuvBasicComponents.append((StringBuilder)builder, (String)"", (int)24);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsvv.getMmna(), (int)1);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsvv.getMmgb(), (int)1);
        DeuvBasicComponents.append((StringBuilder)builder, (String)dsvv.getMman(), (int)1);
        DeuvBasicComponents.append((StringBuilder)builder, (String)"", (int)26);
        if ("J".equals(dsvv.getMmna())) {
            builder.append(DeuvBasicComponents.getContentDbna((IDbnaData)dsvv.getDbna()));
        }
        if ("J".equals(dsvv.getMmgb())) {
            builder.append(DeuvBasicComponents.getContentDbgb((IDbgbData)dsvv.getDbgb()));
        }
        if ("J".equals(dsvv.getMman())) {
            builder.append(DeuvBasicComponents.getContentDban((IDbanData)dsvv.getDban()));
        }
        return builder.toString();
    }

    public static String getDsmePattern_V10(String verfahren) {
        return "DSME" + verfahren + DSMEBASEPATTERN_V10;
    }

    public static String getDsmePattern_V11(String verfahren) {
        return "DSME" + verfahren + DSMEBASEPATTERN_V11;
    }
}

