/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.dataexport.dls;

import com.infor.igf.core.persistency.PersistencyContainer;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.PersistencyDataSet;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.dataexport.BigDecimalExportColumn;
import com.varial.personnel.domain.dataexport.ExportColumn;
import com.varial.personnel.domain.dataexport.IntegerExportColumn;
import com.varial.personnel.domain.dataexport.SpecialTextExportColumn;
import com.varial.personnel.domain.dataexport.TextExportColumn;
import com.varial.personnel.domain.dataexport.dls.DLSExportTable;
import com.varial.personnel.domain.dataexport.dls.DateExportColumn;
import com.varial.personnel.domain.dataexport.dls.ExportTypeEnum;
import com.varial.personnel.domain.employee.Employee;
import com.varial.serverbase.domain.textoutput.FieldSeparator;
import com.varial.serverbase.domain.textoutput.LineSeparator;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.util.Date;

public class LohnkontoExportTable
extends DLSExportTable {
    private final IntegerExportColumn mAbrJahr = new IntegerExportColumn("Abr_Jahr", "Abrechnungsjahr", 4, true);
    private final IntegerExportColumn mAbrMon = new IntegerExportColumn("Abr_Mon", "Abrechnungsmonat", 2, true);
    private final IntegerExportColumn mAnmJahr = new IntegerExportColumn("Anm_Jahr", "Anmeldungsjahr", 4, true);
    private final IntegerExportColumn mAnmZtr = new IntegerExportColumn("Anm_Ztr", "Anmeldungszeitraum", 2, true);
    private final DateExportColumn mZahlDatum = new DateExportColumn("Zahl_Datum", "Tag der Lohnzahlung gem. \u00a7 4 Abs. 2 Nr. 1 und  Nr. 3  LStDV", true);
    private final IntegerExportColumn mAendZahl = new IntegerExportColumn("Aend_Zahl", "\u00c4nderungsz\u00e4hler", 3, true);
    private final IntegerExportColumn mAbrZahl = new IntegerExportColumn("Abr_Zahl", "Abrechnungsz\u00e4hler", 3, true);
    private final TextExportColumn mPersNr = new TextExportColumn("Pers_Nr", "Personalnummer", 8, true);
    private final TextExportColumn mIDNr = new TextExportColumn("ID_Nr", "Identifikationsnummer", 80, true);
    private final TextExportColumn mAnzU = new TextExportColumn("Anz_U", "Anzahl der Unterbrechungen", 2, true);
    private final TextExportColumn mGBS = new TextExportColumn("GB_S", "sonstige Bez\u00fcge", 1, true);
    private final TextExportColumn mGBB = new TextExportColumn("GB_B", "besondere LSt-Tabelle", 1, true);
    private final TextExportColumn mGBF = new TextExportColumn("GB_F", "Sammelbef\u00f6rderung", 1, true);
    private final TextExportColumn mGBFR = new TextExportColumn("GB_FR", "Franz\u00f6sische Grenzg\u00e4nger", 1, true);
    private final TextExportColumn mGBM = new TextExportColumn("GB_M", "Gestellung von Mahlzeiten", 1, true);
    private final TextExportColumn mGB = new TextExportColumn("GB", "Gro\u00dfbuchstaben", 16, true);
    private final BigDecimalExportColumn mStBrutto;
    private final BigDecimalExportColumn mLStnachJA;
    private final BigDecimalExportColumn mSolZ;
    private final BigDecimalExportColumn mKiStAN;
    private final BigDecimalExportColumn mKiStEG;
    private final BigDecimalExportColumn mVersBez;
    private final SpecialTextExportColumn mVersBezstbegmKj;
    private final BigDecimalExportColumn mVersBezmKj;
    private final BigDecimalExportColumn mEbALEnt;
    private final BigDecimalExportColumn mALmKjEnt;
    private final BigDecimalExportColumn mLStebBez;
    private final BigDecimalExportColumn mSolzebBez;
    private final BigDecimalExportColumn mKiStANebBez;
    private final BigDecimalExportColumn mKiStEGebBez;
    private final BigDecimalExportColumn mLoEL;
    private final BigDecimalExportColumn mLoELKUG;
    private final BigDecimalExportColumn mStfrALDBA;
    private final BigDecimalExportColumn mStfrALATE;
    private final BigDecimalExportColumn mStfrAGLFWA;
    private final BigDecimalExportColumn mPAGLFWA;
    private final BigDecimalExportColumn mNebALEnt;
    private final BigDecimalExportColumn mStfrVerpflZAuswT;
    private final BigDecimalExportColumn mStfrAGLdHH;
    private final BigDecimalExportColumn mRVAGges;
    private final BigDecimalExportColumn mRVAGbst;
    private final BigDecimalExportColumn mRVANges;
    private final BigDecimalExportColumn mRVANbst;
    private final SpecialTextExportColumn mKVPVAG;
    private final BigDecimalExportColumn mGKVAG;
    private final BigDecimalExportColumn mPKVAG;
    private final BigDecimalExportColumn mGPVAG;
    private final BigDecimalExportColumn mKVAN;
    private final BigDecimalExportColumn mPVAN;
    private final BigDecimalExportColumn mAVAN;
    private final BigDecimalExportColumn mPrivKVPV;
    private final SpecialTextExportColumn mBMGVERSFB;
    private final BigDecimalExportColumn mSterbKapAbfNzVB;
    private final SpecialTextExportColumn mKiGe;
    private final BigDecimalExportColumn mFBDBATR;
    private final BigDecimalExportColumn mBMGpSt;
    private final BigDecimalExportColumn mPLSt;
    private final BigDecimalExportColumn mPSolZ;
    private final BigDecimalExportColumn mPKiSt;
    private final BigDecimalExportColumn mBMGpSt37b;
    private final BigDecimalExportColumn mPLSt37b;
    private final BigDecimalExportColumn mBMGKnapp;
    private final BigDecimalExportColumn mPLStKnapp;
    private final BigDecimalExportColumn mBMGKammerHB;
    private final BigDecimalExportColumn mBMGKammerSL;
    private final BigDecimalExportColumn mKammerHB;
    private final BigDecimalExportColumn mKammerSL;
    private final SpecialTextExportColumn mSVAN;
    private final IntegerExportColumn mStTage;
    private final BigDecimalExportColumn mLStvorJA;
    private final BigDecimalExportColumn mAuszBetr;
    private final BigDecimalExportColumn mBAVFoerd;
    private final BigDecimalExportColumn mBAVRef2016;
    private final SpecialTextExportColumn mVermBetstfr;
    private final SpecialTextExportColumn mVermBetstpfl;

    public LohnkontoExportTable(FieldSeparator fieldSeparator, LineSeparator lineSeparator, char decimalPoint) {
        super("DLS-Lohnkonto", "Lohnkontendaten", "lohnkontendaten.csv", fieldSeparator, lineSeparator, decimalPoint);
        this.mStBrutto = new BigDecimalExportColumn("St_Brutto", "Steuerbrutto", 12, true, 2, decimalPoint);
        this.mLStnachJA = new BigDecimalExportColumn("LSt_nach_JA", "Lohnsteuer nach Lohnsteuerjahresausgleich", 12, true, 2, decimalPoint);
        this.mSolZ = new BigDecimalExportColumn("SolZ", "Solidarit\u00e4tszuschlag", 12, true, 2, decimalPoint);
        this.mKiStAN = new BigDecimalExportColumn("KiSt_AN", "Kirchensteuer des Arbeitnehmers", 12, true, 2, decimalPoint);
        this.mKiStEG = new BigDecimalExportColumn("KiSt_EG", "Kirchensteuer des Ehegatten", 12, true, 2, decimalPoint);
        this.mVersBez = new BigDecimalExportColumn("Vers_Bez", "Versorgungsbezug", 12, true, 2, decimalPoint);
        this.mVersBezstbegmKj = new SpecialTextExportColumn("Vers_Bez_stbeg_mKj", "steuerbeg\u00fcnstigte Versorgungsbez\u00fcge f\u00fcr mehrere Kalenderjahre", 1, true);
        this.mVersBezmKj = new BigDecimalExportColumn("Vers_Bez_mKj", "Versorgungsbez\u00fcge f\u00fcr mehrere Kalenderjahre", 12, true, 2, decimalPoint);
        this.mEbALEnt = new BigDecimalExportColumn("eb_AL_Ent", "erm\u00e4\u00dfigt besteuerter Arbeitslohn f\u00fcr mehrere Kalenderjahre und erm\u00e4\u00dfigt besteuerte Entsch\u00e4digungen", 12, true, 2, decimalPoint);
        this.mALmKjEnt = new BigDecimalExportColumn("AL_mKj_Ent", "Arbeitslohn f\u00fcr mehrere Kalenderjahre und Entsch\u00e4digungen", 12, true, 2, decimalPoint);
        this.mLStebBez = new BigDecimalExportColumn("LSt_eb_Bez", "Lohnsteuer auf erm\u00e4\u00dfigt besteuerte Bez\u00fcge", 12, true, 2, decimalPoint);
        this.mSolzebBez = new BigDecimalExportColumn("Solz_eb_Bez", "Solidarit\u00e4tszuschlag auf erm\u00e4\u00dfigt besteuerte Bez\u00fcge", 12, true, 2, decimalPoint);
        this.mKiStANebBez = new BigDecimalExportColumn("KiSt_AN_eb_Bez", "Kirchensteuer des Arbeitnehmers auf erm\u00e4\u00dfigt besteuerte Bez\u00fcge", 12, true, 2, decimalPoint);
        this.mKiStEGebBez = new BigDecimalExportColumn("KiSt_EG_eb_Bez", "Kirchensteuer des Ehegatten des Arbeitnehmers auf erm\u00e4\u00dfigt besteuerte Bez\u00fcge", 12, true, 2, decimalPoint);
        this.mLoEL = new BigDecimalExportColumn("LoEL", "bescheinigungspfllichtige Lohnersatzleistungen", 12, true, 2, decimalPoint);
        this.mLoELKUG = new BigDecimalExportColumn("LoELKUG", "gesondert bescheinigungspfllichtige Lohnersatzleistungen", 12, true, 2, decimalPoint);
        this.mStfrALDBA = new BigDecimalExportColumn("stfr_AL_DBA", "steuerfreier Arbeitslohn nach DBA", 12, true, 2, decimalPoint);
        this.mStfrALATE = new BigDecimalExportColumn("stfr_AL_ATE", "steuerfreier Arbeitslohn nach ATE", 12, true, 2, decimalPoint);
        this.mStfrAGLFWA = new BigDecimalExportColumn("stfr_AGL_FWA", "steuerfreie Arbeitgeberleistungen, die auf die Entfernungspauschale anzurechnen sind bzw. bis 2019 f\u00fcr Fahrten zwischen Wohnung und erster T\u00e4tigkeitsst\u00e4tte", 12, true, 2, decimalPoint);
        this.mPAGLFWA = new BigDecimalExportColumn("p_AGL_FWA", "pauschal besteuerte Arbeitgeberleistung f\u00fcr Fahrten zwischen Wohnung und erster T\u00e4tigkeitsst\u00e4tte", 12, true, 2, decimalPoint);
        this.mNebALEnt = new BigDecimalExportColumn("neb_AL_Ent", "nicht erm\u00e4\u00dfigt besteuerter Arbeitslohn f\u00fcr mehrere Kalenderjahre und nicht erm\u00e4\u00dfigt besteuerte Entsch\u00e4digung", 12, true, 2, decimalPoint);
        this.mStfrVerpflZAuswT = new BigDecimalExportColumn("stfr_VerpflZ_AuswT", "steuerfreier Verpflegungszuschuss bei Ausw\u00e4rtst\u00e4tigkeit", 12, true, 2, decimalPoint);
        this.mStfrAGLdHH = new BigDecimalExportColumn("stfr_AGL_dHH", "steuerfreie Arbeitgeberleistung f\u00fcr doppelte Haushaltsf\u00fchrung", 12, true, 2, decimalPoint);
        this.mRVAGges = new BigDecimalExportColumn("RV_AG_ges", "Arbeitgeberanteil/-zuschuss zur gesetzlichen Rentenversicherung", 12, true, 2, decimalPoint);
        this.mRVAGbst = new BigDecimalExportColumn("RV_AG_bst", "Arbeitgeberanteil/-zuschuss an berufsst\u00e4ndische Versorgungseinrichtungen", 12, true, 2, decimalPoint);
        this.mRVANges = new BigDecimalExportColumn("RV_AN_ges", "Arbeitnehmeranteil zur gesetzlichen Rentenversicherung", 12, true, 2, decimalPoint);
        this.mRVANbst = new BigDecimalExportColumn("RV_AN_bst", "Arbeitnehmeranteil an berufsst\u00e4ndische Versorgungseinrichtungen", 12, true, 2, decimalPoint);
        this.mKVPVAG = new SpecialTextExportColumn("KV_PV_AG", "Steuerfreie Arbeitgeberzusch\u00fcsse zur Krankenversicherung und Pflegeversicherung", 1, true);
        this.mGKVAG = new BigDecimalExportColumn("gKV_AG", "Steuerfreie Arbeitgeberzusch\u00fcsse zur gesetzlichen Krankenversicherung", 12, true, 2, decimalPoint);
        this.mPKVAG = new BigDecimalExportColumn("pKV_AG", "Steuerfreie Arbeitgeberzusch\u00fcsse zur privaten Krankenversicherung", 12, true, 2, decimalPoint);
        this.mGPVAG = new BigDecimalExportColumn("gPV_AG", "Steuerfreie Arbeitgeberzusch\u00fcsse zur gesetzlichen Pflegeversicherung", 12, true, 2, decimalPoint);
        this.mKVAN = new BigDecimalExportColumn("KV_AN", "Arbeitnehmerbeitr\u00e4ge zur gesetzlichen Krankenversicherung", 12, true, 2, decimalPoint);
        this.mPVAN = new BigDecimalExportColumn("PV_AN", "Arbeitnehmerbeitr\u00e4ge zur sozialen Pflegeversicherung", 12, true, 2, decimalPoint);
        this.mAVAN = new BigDecimalExportColumn("AV_AN", "Arbeitnehmerbeitr\u00e4ge zur Arbeitslosenversicherung", 12, true, 2, decimalPoint);
        this.mPrivKVPV = new BigDecimalExportColumn("priv_KV_PV", "Beitr\u00e4ge zur privaten Krankenversicherung und Pflege-Pflichtversicherung", 12, true, 2, decimalPoint);
        this.mBMGVERSFB = new SpecialTextExportColumn("BMG_VERSFB", "Bemessungsgrundlage Versorgungsfreibetrag", 1, true);
        this.mSterbKapAbfNzVB = new BigDecimalExportColumn("Sterb_Kap_Abf_NzVB", "Sterbegeld, Kapitalauszahlungen/Abfindungen und Nachzahlungen von Versorgungsbez\u00fcgen", 12, true, 2, decimalPoint);
        this.mKiGe = new SpecialTextExportColumn("KiGe", "Kindergeld", 1, true);
        this.mFBDBATR = new BigDecimalExportColumn("FB_DBA_TR", "Freibetrag DBA T\u00fcrkei", 12, true, 2, decimalPoint);
        this.mBMGpSt = new BigDecimalExportColumn("BMG_p_St", "BMG pauschale LSt ohne \u00a7 37b und Knappschaft", 12, true, 2, decimalPoint);
        this.mPLSt = new BigDecimalExportColumn("P_LSt", "Pauschale LSt", 12, true, 2, decimalPoint);
        this.mPSolZ = new BigDecimalExportColumn("P_SolZ", "SolZ in den F\u00e4llen der Lohnsteuerpauschalierung", 12, true, 2, decimalPoint);
        this.mPKiSt = new BigDecimalExportColumn("P_KiSt", "KiSt in den F\u00e4llen der Lohnsteuerpauschalierung", 12, true, 2, decimalPoint);
        this.mBMGpSt37b = new BigDecimalExportColumn("BMG_p_St37b", "BMG pauschale LSt nach \u00a7 37b", 12, true, 2, decimalPoint);
        this.mPLSt37b = new BigDecimalExportColumn("P_LSt_37b", "Pauschale LSt \u00a7 37b", 12, true, 2, decimalPoint);
        this.mBMGKnapp = new BigDecimalExportColumn("BMG_Knapp", "BMG pauschale LSt Knappschaft", 12, true, 2, decimalPoint);
        this.mPLStKnapp = new BigDecimalExportColumn("P_LSt_Knapp", "Pauschale LSt Knappschaft", 12, true, 2, decimalPoint);
        this.mBMGKammerHB = new BigDecimalExportColumn("BMG_Kammer_HB", "BMG Kammerbeitrag Bremen", 12, true, 2, decimalPoint);
        this.mBMGKammerSL = new BigDecimalExportColumn("BMG_Kammer_SL", "BMG Kammerbeitrag Saarland", 12, true, 2, decimalPoint);
        this.mKammerHB = new BigDecimalExportColumn("Kammer_HB", "Kammerbeitrag Bremen", 12, true, 2, decimalPoint);
        this.mKammerSL = new BigDecimalExportColumn("Kammer_SL", "Kammerbeitrag Saarland", 12, true, 2, decimalPoint);
        this.mSVAN = new SpecialTextExportColumn("SV_AN", "Arbeitnehmeranteil zur Gesamtsozialversicherung", 1, true);
        this.mStTage = new IntegerExportColumn("St_Tage", "Steuertage pro AN", 3, true);
        this.mLStvorJA = new BigDecimalExportColumn("LSt_vor_JA", "Lohnsteuer vor Lohnsteuerjahresausgleich", 12, true, 2, decimalPoint);
        this.mAuszBetr = new BigDecimalExportColumn("Ausz_Betr", "Auszahlungsbetrag", 12, true, 2, decimalPoint);
        this.mBAVFoerd = new BigDecimalExportColumn("BAV_Foerd", "F\u00f6rderbetrag zur betrieblichen Altersversorgung gem. \u00a7 100 EStG", 12, true, 2, decimalPoint);
        this.mBAVRef2016 = new BigDecimalExportColumn("BAV_Ref_2016", "Referenzbetrag f\u00fcr den F\u00f6rderbetrag zur betrieblichen Altersversorgung gem. \u00a7 100 EStG - Jahresbetrag", 12, true, 2, decimalPoint);
        this.mVermBetstfr = new SpecialTextExportColumn("VermBet_stfr", "nicht zu besteuernder Vorteil gem. \u00a7 19a Abs.1 Satz 4 EStG", 1, true);
        this.mVermBetstpfl = new SpecialTextExportColumn("VermBet_stpfl", "zu besteuernder Vorteil gem. \u00a7 19a Abs. 4 Satz 3 EStG", 1, true);
        this.setColumns(new ExportColumn[]{this.mAbrJahr, this.mAbrMon, this.mAnmJahr, this.mAnmZtr, this.mZahlDatum, this.mAendZahl, this.mAbrZahl, this.mPersNr, this.mIDNr, this.mAnzU, this.mGBS, this.mGBB, this.mGBF, this.mGBFR, this.mGBM, this.mGB, this.mStBrutto, this.mLStnachJA, this.mSolZ, this.mKiStAN, this.mKiStEG, this.mVersBez, this.mVersBezstbegmKj, this.mVersBezmKj, this.mEbALEnt, this.mALmKjEnt, this.mLStebBez, this.mSolzebBez, this.mKiStANebBez, this.mKiStEGebBez, this.mLoEL, this.mLoELKUG, this.mStfrALDBA, this.mStfrALATE, this.mStfrAGLFWA, this.mPAGLFWA, this.mNebALEnt, this.mStfrVerpflZAuswT, this.mStfrAGLdHH, this.mRVAGges, this.mRVAGbst, this.mRVANges, this.mRVANbst, this.mKVPVAG, this.mGKVAG, this.mPKVAG, this.mGPVAG, this.mKVAN, this.mPVAN, this.mAVAN, this.mPrivKVPV, this.mBMGVERSFB, this.mSterbKapAbfNzVB, this.mKiGe, this.mFBDBATR, this.mBMGpSt, this.mPLSt, this.mPSolZ, this.mPKiSt, this.mBMGpSt37b, this.mPLSt37b, this.mBMGKnapp, this.mPLStKnapp, this.mBMGKammerHB, this.mBMGKammerSL, this.mKammerHB, this.mKammerSL, this.mSVAN, this.mStTage, this.mLStvorJA, this.mAuszBetr, this.mBAVFoerd, this.mBAVRef2016, this.mVermBetstfr, this.mVermBetstpfl});
    }

    protected void fillVisibleOutputFields(PersistencyContainer persistencyContainer) throws BusinessDomainException {
        this.init();
        Date validTimePoint = this.getLohnkontoBean().getValidFrom();
        Date effectiveTimePoint = this.getLohnkontoBean().getEffectiveFrom();
        Employee employee = this.getLohnkontoBean().getEmployee();
        this.mAbrJahr.setInteger(Integer.valueOf(DateHelper.getYear((Date)validTimePoint) + 1900));
        this.mAbrMon.setInteger(Integer.valueOf(DateHelper.getMonth((Date)validTimePoint) + 1));
        this.mAnmJahr.setInteger(Integer.valueOf(DateHelper.getYear((Date)effectiveTimePoint) + 1900));
        this.mAnmZtr.setInteger(Integer.valueOf(this.getAnmeldezeitraum(effectiveTimePoint, validTimePoint)));
        this.mZahlDatum.setDate(DateHelper.getLastDayOfMonth((Date)effectiveTimePoint));
        this.mAbrZahl.setInteger(Integer.valueOf(this.getLohnkontoBean().getCalculationCount()));
        this.mAendZahl.setInteger(Integer.valueOf(this.getLohnkontoBean().getCalculationCount()));
        this.mPersNr.setText(String.valueOf(employee.getPersonnelnumber()));
        this.mIDNr.setText(this.getIDnr(employee));
        this.mAnzU.setText(String.valueOf(this.getLohnkontoBean().getAnzU()));
        Object mGrossbuchstaben = this.getLohnkontoBean().getGBS();
        if (!StringMapper.isNullString((String)this.getLohnkontoBean().getGBF())) {
            mGrossbuchstaben = StringMapper.isNullString((String)mGrossbuchstaben) ? this.getLohnkontoBean().getGBF() : (String)mGrossbuchstaben + ", " + this.getLohnkontoBean().getGBF();
        }
        if (!StringMapper.isNullString((String)this.getLohnkontoBean().getGBFR())) {
            mGrossbuchstaben = StringMapper.isNullString((String)mGrossbuchstaben) ? this.getLohnkontoBean().getGBFR() : (String)mGrossbuchstaben + ", " + this.getLohnkontoBean().getGBFR();
        }
        if (!StringMapper.isNullString((String)this.getLohnkontoBean().getGBM())) {
            mGrossbuchstaben = StringMapper.isNullString((String)mGrossbuchstaben) ? this.getLohnkontoBean().getGBM() : (String)mGrossbuchstaben + ", " + this.getLohnkontoBean().getGBM();
        }
        this.mGB.setText((String)mGrossbuchstaben);
        this.mStBrutto.setBigDecimal(this.getLohnkontoBean().getStBrutto());
        this.mLStnachJA.setBigDecimal(this.getLohnkontoBean().getLStnachJA());
        this.mSolZ.setBigDecimal(this.getLohnkontoBean().getSolZ());
        this.mKiStAN.setBigDecimal(this.getLohnkontoBean().getKiStAN());
        this.mKiStEG.setBigDecimal(this.getLohnkontoBean().getKiStEG());
        this.mVersBez.setBigDecimal(this.getLohnkontoBean().getVersBez());
        this.mVersBezstbegmKj.setText(" ");
        this.mVersBezmKj.setBigDecimal(this.getLohnkontoBean().getVersBezmKj());
        this.mEbALEnt.setBigDecimal(this.getLohnkontoBean().getEbALEnt());
        this.mALmKjEnt.setBigDecimal(this.getLohnkontoBean().getALmKjEnt());
        this.mLStebBez.setBigDecimal(this.getLohnkontoBean().getLStebBez());
        this.mSolzebBez.setBigDecimal(this.getLohnkontoBean().getSolzebBez());
        this.mKiStANebBez.setBigDecimal(this.getLohnkontoBean().getKiStANebBez());
        this.mKiStEGebBez.setBigDecimal(this.getLohnkontoBean().getKiStEGebBez());
        this.mLoEL.setBigDecimal(this.getLohnkontoBean().getLoEL());
        this.mLoELKUG.setBigDecimal(this.getLohnkontoBean().getLoELKUG());
        this.mStfrALDBA.setBigDecimal(this.getLohnkontoBean().getStfrALDBA());
        this.mStfrALATE.setBigDecimal(this.getLohnkontoBean().getStfrALATE());
        this.mStfrAGLFWA.setBigDecimal(this.getLohnkontoBean().getStfrAGLFWA());
        this.mPAGLFWA.setBigDecimal(this.getLohnkontoBean().getPAGLFWA());
        this.mNebALEnt.setBigDecimal(this.getLohnkontoBean().getNebALEnt());
        this.mStfrVerpflZAuswT.setBigDecimal(this.getLohnkontoBean().getStfrVerpflZAuswT());
        this.mStfrAGLdHH.setBigDecimal(this.getLohnkontoBean().getStfrAGLdHH());
        this.mRVAGges.setBigDecimal(this.getLohnkontoBean().getRVAGges());
        this.mRVAGbst.setBigDecimal(this.getLohnkontoBean().getRVAGbst());
        this.mRVANges.setBigDecimal(this.getLohnkontoBean().getRVANges());
        this.mRVANbst.setBigDecimal(this.getLohnkontoBean().getRVANbst());
        this.mKVPVAG.setText(" ");
        this.mGKVAG.setBigDecimal(this.getLohnkontoBean().getGKVAG());
        this.mPKVAG.setBigDecimal(this.getLohnkontoBean().getPKVAG());
        this.mGPVAG.setBigDecimal(this.getLohnkontoBean().getGPVAG());
        this.mKVAN.setBigDecimal(this.getLohnkontoBean().getKVAN());
        this.mPVAN.setBigDecimal(this.getLohnkontoBean().getPVAN());
        this.mAVAN.setBigDecimal(this.getLohnkontoBean().getAVAN());
        this.mPrivKVPV.setBigDecimal(this.getLohnkontoBean().getPrivKVPV());
        this.mBMGVERSFB.setText(" ");
        this.mSterbKapAbfNzVB.setBigDecimal(this.getLohnkontoBean().getSterbKapAbfNzVB());
        this.mKiGe.setText(" ");
        this.mFBDBATR.setBigDecimal(this.getLohnkontoBean().getFBDBATR());
        this.mBMGpSt.setBigDecimal(this.getLohnkontoBean().getBMGpSt());
        this.mPLSt.setBigDecimal(this.getLohnkontoBean().getPLSt());
        this.mPSolZ.setBigDecimal(this.getLohnkontoBean().getPSolZ());
        this.mPKiSt.setBigDecimal(this.getLohnkontoBean().getPKiSt());
        this.mBMGpSt37b.setBigDecimal(this.getLohnkontoBean().getBMGpSt37b());
        this.mPLSt37b.setBigDecimal(this.getLohnkontoBean().getPLSt37b());
        this.mBMGKnapp.setBigDecimal(this.getLohnkontoBean().getBMGKnapp());
        this.mPLStKnapp.setBigDecimal(this.getLohnkontoBean().getPLStKnapp());
        this.mBMGKammerHB.setBigDecimal(this.getLohnkontoBean().getBMGKammerHB());
        this.mBMGKammerSL.setBigDecimal(this.getLohnkontoBean().getBMGKammerSL());
        this.mKammerHB.setBigDecimal(this.getLohnkontoBean().getKammerHB());
        this.mKammerSL.setBigDecimal(this.getLohnkontoBean().getKammerSL());
        this.mSVAN.setText(" ");
        this.mStTage.setInteger(Integer.valueOf(this.getLohnkontoBean().getStTage().intValue()));
        this.mLStvorJA.setBigDecimal(this.getLohnkontoBean().getLStvorJA());
        this.mAuszBetr.setBigDecimal(this.getLohnkontoBean().getAuszBetr());
        this.mBAVFoerd.setBigDecimal(this.getLohnkontoBean().getBAVFoerd());
        this.mBAVRef2016.setBigDecimal(this.getLohnkontoBean().getBAVRef2016());
        this.mVermBetstfr.setText(" ");
        this.mVermBetstpfl.setText(" ");
    }

    private void init() {
        this.mAbrJahr.setInteger(Integer.valueOf(0));
        this.mAbrMon.setInteger(Integer.valueOf(0));
        this.mAnmJahr.setInteger(Integer.valueOf(0));
        this.mAnmZtr.setInteger(Integer.valueOf(0));
        this.mZahlDatum.setDate(null);
        this.mAendZahl.setInteger(Integer.valueOf(1));
        this.mAbrZahl.setInteger(Integer.valueOf(1));
        this.mPersNr.setText("0");
        this.mIDNr.setText("0");
        this.mAnzU.setText("");
        this.mGBS.setText("");
        this.mGBB.setText("");
        this.mGBF.setText("");
        this.mGBFR.setText("");
        this.mGBM.setText("");
        this.mGB.setText("");
        this.mStBrutto.setBigDecimal(BigDecimalMapper.ZERO);
        this.mLStnachJA.setBigDecimal(BigDecimalMapper.ZERO);
        this.mSolZ.setBigDecimal(BigDecimalMapper.ZERO);
        this.mKiStAN.setBigDecimal(BigDecimalMapper.ZERO);
        this.mKiStEG.setBigDecimal(BigDecimalMapper.ZERO);
        this.mVersBez.setBigDecimal(BigDecimalMapper.ZERO);
        this.mVersBezstbegmKj.setText(" ");
        this.mVersBezmKj.setBigDecimal(BigDecimalMapper.ZERO);
        this.mEbALEnt.setBigDecimal(BigDecimalMapper.ZERO);
        this.mALmKjEnt.setBigDecimal(BigDecimalMapper.ZERO);
        this.mLStebBez.setBigDecimal(BigDecimalMapper.ZERO);
        this.mSolzebBez.setBigDecimal(BigDecimalMapper.ZERO);
        this.mKiStANebBez.setBigDecimal(BigDecimalMapper.ZERO);
        this.mKiStEGebBez.setBigDecimal(BigDecimalMapper.ZERO);
        this.mLoEL.setBigDecimal(BigDecimalMapper.ZERO);
        this.mLoELKUG.setBigDecimal(BigDecimalMapper.ZERO);
        this.mStfrALDBA.setBigDecimal(BigDecimalMapper.ZERO);
        this.mStfrALATE.setBigDecimal(BigDecimalMapper.ZERO);
        this.mStfrAGLFWA.setBigDecimal(BigDecimalMapper.ZERO);
        this.mPAGLFWA.setBigDecimal(BigDecimalMapper.ZERO);
        this.mNebALEnt.setBigDecimal(BigDecimalMapper.ZERO);
        this.mStfrVerpflZAuswT.setBigDecimal(BigDecimalMapper.ZERO);
        this.mStfrAGLdHH.setBigDecimal(BigDecimalMapper.ZERO);
        this.mRVAGges.setBigDecimal(BigDecimalMapper.ZERO);
        this.mRVAGbst.setBigDecimal(BigDecimalMapper.ZERO);
        this.mRVANges.setBigDecimal(BigDecimalMapper.ZERO);
        this.mRVANbst.setBigDecimal(BigDecimalMapper.ZERO);
        this.mKVPVAG.setText(" ");
        this.mGKVAG.setBigDecimal(BigDecimalMapper.ZERO);
        this.mPKVAG.setBigDecimal(BigDecimalMapper.ZERO);
        this.mGPVAG.setBigDecimal(BigDecimalMapper.ZERO);
        this.mKVAN.setBigDecimal(BigDecimalMapper.ZERO);
        this.mPVAN.setBigDecimal(BigDecimalMapper.ZERO);
        this.mAVAN.setBigDecimal(BigDecimalMapper.ZERO);
        this.mPrivKVPV.setBigDecimal(BigDecimalMapper.ZERO);
        this.mBMGVERSFB.setText(" ");
        this.mSterbKapAbfNzVB.setBigDecimal(BigDecimalMapper.ZERO);
        this.mKiGe.setText(" ");
        this.mFBDBATR.setBigDecimal(BigDecimalMapper.ZERO);
        this.mBMGpSt.setBigDecimal(BigDecimalMapper.ZERO);
        this.mPLSt.setBigDecimal(BigDecimalMapper.ZERO);
        this.mPSolZ.setBigDecimal(BigDecimalMapper.ZERO);
        this.mPKiSt.setBigDecimal(BigDecimalMapper.ZERO);
        this.mBMGpSt37b.setBigDecimal(BigDecimalMapper.ZERO);
        this.mPLSt37b.setBigDecimal(BigDecimalMapper.ZERO);
        this.mBMGKnapp.setBigDecimal(BigDecimalMapper.ZERO);
        this.mPLStKnapp.setBigDecimal(BigDecimalMapper.ZERO);
        this.mBMGKammerHB.setBigDecimal(BigDecimalMapper.ZERO);
        this.mBMGKammerSL.setBigDecimal(BigDecimalMapper.ZERO);
        this.mKammerHB.setBigDecimal(BigDecimalMapper.ZERO);
        this.mKammerSL.setBigDecimal(BigDecimalMapper.ZERO);
        this.mSVAN.setText(" ");
        this.mStTage.setInteger(Integer.valueOf(0));
        this.mLStvorJA.setBigDecimal(BigDecimalMapper.ZERO);
        this.mAuszBetr.setBigDecimal(BigDecimalMapper.ZERO);
        this.mBAVFoerd.setBigDecimal(BigDecimalMapper.ZERO);
        this.mBAVRef2016.setBigDecimal(BigDecimalMapper.ZERO);
        this.mVermBetstfr.setText(" ");
        this.mVermBetstpfl.setText(" ");
    }

    protected PersistencyDataSet getDataSet() {
        return null;
    }

    public boolean getPlants() {
        return false;
    }

    protected PersistencyDataSet getDataSetPlants() {
        return null;
    }

    protected void fillVisibleOutputFieldsPlants(PersistencyContainer persistencyContainer) throws BusinessDomainException {
    }

    protected ExportTypeEnum getExportType() {
        return ExportTypeEnum.LOHNKONTEN;
    }
}

