/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.dataexport.dls;

import com.varial.base.UtilitiesManager;
import com.varial.base.persistency.PersistencyDataSet;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.IEECompanyPlant;
import com.varial.personnel.domain.employee.tax.Tax;
import com.varial.personnel.persistency.employee.valueposition.ValuepositionContainer;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.math.BigDecimal;
import java.util.Date;

public class LohnkontoBean {
    private final PersistencyDataSet mDataset;
    private final int mCalculationCount;
    private final Date mEffectiveFrom;
    private final Date mValidFrom;
    private final Employee mEmployee;
    private final int mYear;
    private int mAnzU;
    private String mGBS;
    private String mGBB;
    private String mGBF;
    private String mGBFR;
    private String mGBM;
    private BigDecimal mStBrutto;
    private BigDecimal mLStnachJA;
    private BigDecimal mSolZ;
    private BigDecimal mKiStAN;
    private BigDecimal mKiStEG;
    private BigDecimal mVersBez;
    private BigDecimal mVersBezstbegmKj;
    private BigDecimal mVersBezmKj;
    private BigDecimal mEbALEnt;
    private BigDecimal mALmKjEnt;
    private BigDecimal mLStebBez;
    private BigDecimal mSolzebBez;
    private BigDecimal mKiStANebBez;
    private BigDecimal mKiStEGebBez;
    private BigDecimal mLoEL;
    private BigDecimal mLoELKUG;
    private BigDecimal mStfrALDBA;
    private BigDecimal mStfrALATE;
    private BigDecimal mStfrAGLFWA;
    private BigDecimal mPAGLFWA;
    private BigDecimal mNebALEnt;
    private BigDecimal mStfrVerpflZAuswT;
    private BigDecimal mStfrAGLdHH;
    private BigDecimal mRVAGges;
    private BigDecimal mRVAGbst;
    private BigDecimal mRVANges;
    private BigDecimal mRVANbst;
    private String mKVPVAG;
    private BigDecimal mgKVAG;
    private BigDecimal mpKVAG;
    private BigDecimal mgPVAG;
    private BigDecimal mKVAN;
    private BigDecimal mPVAN;
    private BigDecimal mAVAN;
    private BigDecimal mprivKVPV;
    private String mBMGVERSFB;
    private BigDecimal mSterbKapAbfNzVB;
    private BigDecimal mKiGe;
    private BigDecimal mFBDBATR;
    private BigDecimal mBMGpSt;
    private BigDecimal mPLSt;
    private BigDecimal mPSolZ;
    private BigDecimal mPKiSt;
    private BigDecimal mBMGpSt37b;
    private BigDecimal mPLSt37b;
    private BigDecimal mBMGKnapp;
    private BigDecimal mPLStKnapp;
    private BigDecimal mBMGKammerHB;
    private BigDecimal mBMGKammerSL;
    private BigDecimal mKammerHB;
    private BigDecimal mKammerSL;
    private String mSVAN;
    private BigDecimal mStTage;
    private BigDecimal mLStvorJA;
    private BigDecimal mAuszBetr;
    private BigDecimal mBAVFoerd;
    private BigDecimal mBAVRef2016;
    private BigDecimal mGesamtBerufVersorg;
    private BigDecimal mBMGKammer;

    public LohnkontoBean(PersistencyDataSet dataset, int calculationCount, Date effectiveFrom, Date validFrom, Employee employee) {
        this.mDataset = dataset;
        this.mCalculationCount = calculationCount;
        this.mEffectiveFrom = effectiveFrom;
        this.mValidFrom = validFrom;
        this.mEmployee = employee;
        this.mYear = DateHelper.getYear((Date)validFrom) + 1900;
        this.init();
    }

    private void init() {
        this.mAnzU = 0;
        this.mGBS = "";
        this.mGBB = "";
        this.mGBF = "";
        this.mGBFR = "";
        this.mGBM = "";
        this.mStBrutto = BigDecimalMapper.ZERO;
        this.mLStnachJA = BigDecimalMapper.ZERO;
        this.mSolZ = BigDecimalMapper.ZERO;
        this.mKiStAN = BigDecimalMapper.ZERO;
        this.mKiStEG = BigDecimalMapper.ZERO;
        this.mVersBez = BigDecimalMapper.ZERO;
        this.mVersBezstbegmKj = BigDecimalMapper.ZERO;
        this.mVersBezmKj = BigDecimalMapper.ZERO;
        this.mEbALEnt = BigDecimalMapper.ZERO;
        this.mALmKjEnt = BigDecimalMapper.ZERO;
        this.mLStebBez = BigDecimalMapper.ZERO;
        this.mSolzebBez = BigDecimalMapper.ZERO;
        this.mKiStANebBez = BigDecimalMapper.ZERO;
        this.mKiStEGebBez = BigDecimalMapper.ZERO;
        this.mLoEL = BigDecimalMapper.ZERO;
        this.mLoELKUG = BigDecimalMapper.ZERO;
        this.mStfrALDBA = BigDecimalMapper.ZERO;
        this.mStfrALATE = BigDecimalMapper.ZERO;
        this.mStfrAGLFWA = BigDecimalMapper.ZERO;
        this.mPAGLFWA = BigDecimalMapper.ZERO;
        this.mNebALEnt = BigDecimalMapper.ZERO;
        this.mStfrVerpflZAuswT = BigDecimalMapper.ZERO;
        this.mStfrAGLdHH = BigDecimalMapper.ZERO;
        this.mRVAGges = BigDecimalMapper.ZERO;
        this.mRVAGbst = BigDecimalMapper.ZERO;
        this.mRVANges = BigDecimalMapper.ZERO;
        this.mRVANbst = BigDecimalMapper.ZERO;
        this.mKVPVAG = " ";
        this.mgKVAG = BigDecimalMapper.ZERO;
        this.mpKVAG = BigDecimalMapper.ZERO;
        this.mgPVAG = BigDecimalMapper.ZERO;
        this.mKVAN = BigDecimalMapper.ZERO;
        this.mPVAN = BigDecimalMapper.ZERO;
        this.mAVAN = BigDecimalMapper.ZERO;
        this.mprivKVPV = BigDecimalMapper.ZERO;
        this.mBMGVERSFB = "";
        this.mSterbKapAbfNzVB = BigDecimalMapper.ZERO;
        this.mKiGe = BigDecimalMapper.ZERO;
        this.mFBDBATR = BigDecimalMapper.ZERO;
        this.mBMGpSt = BigDecimalMapper.ZERO;
        this.mPLSt = BigDecimalMapper.ZERO;
        this.mPSolZ = BigDecimalMapper.ZERO;
        this.mPKiSt = BigDecimalMapper.ZERO;
        this.mBMGpSt37b = BigDecimalMapper.ZERO;
        this.mPLSt37b = BigDecimalMapper.ZERO;
        this.mBMGKnapp = BigDecimalMapper.ZERO;
        this.mPLStKnapp = BigDecimalMapper.ZERO;
        this.mBMGKammerHB = BigDecimalMapper.ZERO;
        this.mBMGKammerSL = BigDecimalMapper.ZERO;
        this.mKammerHB = BigDecimalMapper.ZERO;
        this.mKammerSL = BigDecimalMapper.ZERO;
        this.mSVAN = " ";
        this.mStTage = BigDecimalMapper.ZERO;
        this.mLStvorJA = BigDecimalMapper.ZERO;
        this.mAuszBetr = BigDecimalMapper.ZERO;
        this.mBAVFoerd = BigDecimalMapper.ZERO;
        this.mBAVRef2016 = BigDecimalMapper.ZERO;
        this.mGesamtBerufVersorg = BigDecimalMapper.ZERO;
        this.mBMGKammer = BigDecimalMapper.ZERO;
    }

    public PersistencyDataSet getDataset() {
        return this.mDataset;
    }

    public int getCalculationCount() {
        return this.mCalculationCount;
    }

    public Date getEffectiveFrom() {
        return this.mEffectiveFrom;
    }

    public Date getValidFrom() {
        return this.mValidFrom;
    }

    public Employee getEmployee() {
        return this.mEmployee;
    }

    public int getAnzU() {
        return this.mAnzU;
    }

    public String getGBS() {
        return this.mGBS;
    }

    public String getGBF() {
        return this.mGBF;
    }

    public String getGBFR() {
        return this.mGBFR;
    }

    public String getGBM() {
        return this.mGBM;
    }

    public BigDecimal getStBrutto() {
        return this.mStBrutto;
    }

    public BigDecimal getLStnachJA() {
        return this.mLStnachJA;
    }

    public BigDecimal getSolZ() {
        return this.mSolZ;
    }

    public BigDecimal getKiStAN() {
        return this.mKiStAN;
    }

    public BigDecimal getKiStEG() {
        return this.mKiStEG;
    }

    public BigDecimal getVersBez() {
        return this.mVersBez;
    }

    public BigDecimal getVersBezstbegmKj() {
        return this.mVersBezstbegmKj;
    }

    public BigDecimal getVersBezmKj() {
        return this.mVersBezmKj;
    }

    public BigDecimal getEbALEnt() {
        return this.mEbALEnt;
    }

    public BigDecimal getALmKjEnt() {
        return this.mALmKjEnt;
    }

    public BigDecimal getLStebBez() {
        return this.mLStebBez;
    }

    public BigDecimal getSolzebBez() {
        return this.mSolzebBez;
    }

    public BigDecimal getKiStANebBez() {
        return this.mKiStANebBez;
    }

    public BigDecimal getKiStEGebBez() {
        return this.mKiStEGebBez;
    }

    public BigDecimal getLoEL() {
        return this.mLoEL;
    }

    public BigDecimal getLoELKUG() {
        return this.mLoELKUG;
    }

    public BigDecimal getStfrALDBA() {
        return this.mStfrALDBA;
    }

    public BigDecimal getStfrALATE() {
        return this.mStfrALATE;
    }

    public BigDecimal getStfrAGLFWA() {
        return this.mStfrAGLFWA;
    }

    public BigDecimal getPAGLFWA() {
        return this.mPAGLFWA;
    }

    public BigDecimal getNebALEnt() {
        return this.mNebALEnt;
    }

    public BigDecimal getStfrVerpflZAuswT() {
        return this.mStfrVerpflZAuswT;
    }

    public BigDecimal getStfrAGLdHH() {
        return this.mStfrAGLdHH;
    }

    public BigDecimal getRVAGges() {
        return this.mRVAGges;
    }

    public BigDecimal getRVAGbst() {
        return this.mRVAGbst;
    }

    public BigDecimal getRVANges() {
        return this.mRVANges;
    }

    public BigDecimal getRVANbst() {
        return this.mRVANbst;
    }

    public String getKVPVAG() {
        return this.mKVPVAG;
    }

    public BigDecimal getGKVAG() {
        return this.mgKVAG;
    }

    public BigDecimal getPKVAG() {
        return this.mpKVAG;
    }

    public BigDecimal getGPVAG() {
        return this.mgPVAG;
    }

    public BigDecimal getKVAN() {
        return this.mKVAN;
    }

    public BigDecimal getPVAN() {
        return this.mPVAN;
    }

    public BigDecimal getAVAN() {
        return this.mAVAN;
    }

    public BigDecimal getPrivKVPV() {
        return this.mprivKVPV;
    }

    public String getBMGVERSFB() {
        return this.mBMGVERSFB;
    }

    public BigDecimal getSterbKapAbfNzVB() {
        return this.mSterbKapAbfNzVB;
    }

    public BigDecimal getKiGe() {
        return this.mKiGe;
    }

    public BigDecimal getFBDBATR() {
        return this.mFBDBATR;
    }

    public BigDecimal getBMGpSt() {
        return this.mBMGpSt;
    }

    public BigDecimal getPLSt() {
        return this.mPLSt;
    }

    public BigDecimal getPSolZ() {
        return this.mPSolZ;
    }

    public BigDecimal getPKiSt() {
        return this.mPKiSt;
    }

    public BigDecimal getBMGpSt37b() {
        return this.mBMGpSt37b;
    }

    public BigDecimal getPLSt37b() {
        return this.mPLSt37b;
    }

    public BigDecimal getBMGKnapp() {
        return this.mBMGKnapp;
    }

    public BigDecimal getPLStKnapp() {
        return this.mPLStKnapp;
    }

    public BigDecimal getBMGKammerHB() {
        return this.mBMGKammerHB;
    }

    public BigDecimal getBMGKammerSL() {
        return this.mBMGKammerSL;
    }

    public BigDecimal getKammerHB() {
        return this.mKammerHB;
    }

    public BigDecimal getKammerSL() {
        return this.mKammerSL;
    }

    public String getSVAN() {
        return this.mSVAN;
    }

    public BigDecimal getStTage() {
        return this.mStTage;
    }

    public BigDecimal getLStvorJA() {
        return this.mLStvorJA;
    }

    public BigDecimal getAuszBetr() {
        return this.mAuszBetr;
    }

    public BigDecimal getBAVFoerd() {
        return this.mBAVFoerd;
    }

    public BigDecimal getBAVRef2016() {
        return this.mBAVRef2016;
    }

    public LohnkontoBean build() {
        while (this.mDataset.hasNext()) {
            ValuepositionContainer valuePositionContainer = (ValuepositionContainer)this.mDataset.getNext();
            this.fill(valuePositionContainer);
        }
        Tax tax = (Tax)this.mEmployee.getTaxHistory().getItemOrNull(this.mEffectiveFrom, this.mValidFrom);
        if (tax != null) {
            IEECompanyPlant mEECompanyPlant = null;
            int federalStateKey = (mEECompanyPlant = this.getEECompanyPlant(mEECompanyPlant, this.mEmployee, this.mEffectiveFrom, DateHelper.getLastDayOfMonth((Date)this.mValidFrom))).getFederalStateTP().getFederalState().getFederalState();
            if (federalStateKey == 8) {
                this.mGBFR = "FR1";
            } else if (federalStateKey == 7) {
                this.mGBFR = "FR2";
            } else if (federalStateKey == 10) {
                this.mGBFR = "FR3";
            }
        }
        this.mRVANbst = this.mGesamtBerufVersorg.subtract(this.mRVAGbst);
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.mKammerHB)) {
            this.mBMGKammerHB = this.mBMGKammer;
        }
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)this.mKammerSL)) {
            this.mBMGKammerSL = this.mBMGKammer;
        }
        return this;
    }

    private void fill(ValuepositionContainer container) {
        BigDecimal result = container.results;
        if (result == null) {
            result = BigDecimalMapper.ZERO;
        }
        switch (container.valuetypenumber) {
            case 102590: {
                if (StringMapper.isNullString((String)this.mGBS)) {
                    this.mGBS = "E";
                    break;
                }
                this.mGBS = this.mGBS + ", E";
                break;
            }
            case 110595: {
                if (BigDecimalMapper.isZeroOrNull((BigDecimal)container.factor1)) break;
                this.mAnzU += container.factor1.intValue();
                break;
            }
            case 103570: {
                this.mGBF = "F";
                break;
            }
            case 103590: {
                this.mGBM = "M";
                break;
            }
            case 220695: {
                if (StringMapper.isNullString((String)this.mGBS)) {
                    this.mGBS = "S";
                    break;
                }
                this.mGBS = this.mGBS + ", S";
                break;
            }
            case 110510: 
            case 110610: 
            case 110630: {
                this.mStBrutto = this.mStBrutto.add(result);
                break;
            }
            case 220510: 
            case 220610: {
                this.mLStnachJA = this.mLStnachJA.add(result);
                this.mLStvorJA = this.mLStvorJA.add(result);
                break;
            }
            case 220630: {
                this.mLStnachJA = this.mLStnachJA.add(result);
                break;
            }
            case 760100: {
                if (!LohnkontoBean.isDecember(this.mValidFrom)) break;
                this.mLStnachJA = this.mLStnachJA.subtract(result);
                break;
            }
            case 760450: {
                if (!LohnkontoBean.isDecember(this.mValidFrom) || container.category != 22) break;
                this.mLStnachJA = this.mLStnachJA.add(result);
                break;
            }
            case 223510: 
            case 223610: 
            case 223630: {
                this.mSolZ = this.mSolZ.add(result);
                break;
            }
            case 760110: {
                if (!LohnkontoBean.isDecember(this.mValidFrom)) break;
                this.mSolZ = this.mSolZ.subtract(result);
                break;
            }
            case 760460: {
                if (!LohnkontoBean.isDecember(this.mValidFrom) || container.category != 22) break;
                this.mSolZ = this.mSolZ.add(result);
                break;
            }
            case 226510: 
            case 226610: 
            case 226630: {
                this.mKiStAN = this.mKiStAN.add(result);
                break;
            }
            case 760120: {
                if (!LohnkontoBean.isDecember(this.mValidFrom)) break;
                this.mKiStAN = this.mKiStAN.subtract(result);
                break;
            }
            case 760470: {
                if (!LohnkontoBean.isDecember(this.mValidFrom) || container.category != 22) break;
                this.mKiStAN = this.mKiStAN.add(result);
                break;
            }
            case 227510: 
            case 227610: 
            case 227630: {
                this.mKiStEG = this.mKiStEG.add(result);
                break;
            }
            case 760130: {
                if (!LohnkontoBean.isDecember(this.mValidFrom)) break;
                this.mKiStEG = this.mKiStEG.subtract(result);
                break;
            }
            case 760480: {
                if (!LohnkontoBean.isDecember(this.mValidFrom) || container.category != 22) break;
                this.mKiStEG = this.mKiStEG.add(result);
                break;
            }
            case 102500: 
            case 102505: {
                this.mVersBez = this.mVersBez.add(result);
                break;
            }
            case 102520: {
                this.mVersBezmKj = this.mVersBezmKj.add(result);
                break;
            }
            case 102540: 
            case 102550: {
                if (this.mYear < 2025) {
                    this.mEbALEnt = this.mEbALEnt.add(result);
                    break;
                }
                this.mALmKjEnt = this.mALmKjEnt.add(result);
                break;
            }
            case 220620: {
                if (this.mYear >= 2025) break;
                this.mLStebBez = this.mLStebBez.add(result);
                break;
            }
            case 223620: {
                if (this.mYear >= 2025) break;
                this.mSolzebBez = this.mSolzebBez.add(result);
                break;
            }
            case 226620: {
                if (this.mYear >= 2025) break;
                this.mKiStANebBez = this.mKiStANebBez.add(result);
                break;
            }
            case 227620: {
                if (this.mYear >= 2025) break;
                this.mKiStEGebBez = this.mKiStEGebBez.add(result);
                break;
            }
            case 103500: 
            case 400100: 
            case 400400: 
            case 695200: 
            case 695500: {
                this.mLoEL = this.mLoEL.add(result);
                break;
            }
            case 230510: {
                this.mLoEL = this.mLoEL.add(result);
                this.mLoELKUG = this.mLoELKUG.add(result);
                break;
            }
            case 103510: 
            case 103515: {
                this.mStfrALDBA = this.mStfrALDBA.add(result);
                break;
            }
            case 103520: {
                this.mStfrALATE = this.mStfrALATE.add(result);
                break;
            }
            case 103530: {
                this.mStfrAGLFWA = this.mStfrAGLFWA.add(result);
                break;
            }
            case 101590: {
                this.mPAGLFWA = this.mPAGLFWA.add(result);
                break;
            }
            case 102580: {
                this.mNebALEnt = this.mNebALEnt.add(result);
                this.mStBrutto = this.mStBrutto.add(result);
                break;
            }
            case 220400: {
                this.mNebALEnt = this.mNebALEnt.add(result);
                break;
            }
            case 103540: {
                this.mStfrVerpflZAuswT = this.mStfrVerpflZAuswT.add(result);
                break;
            }
            case 103550: {
                this.mStfrAGLdHH = this.mStfrAGLdHH.add(result);
                break;
            }
            case 329630: 
            case 329640: {
                this.mRVAGges = this.mRVAGges.add(result);
                break;
            }
            case 329510: 
            case 329512: 
            case 329514: 
            case 329520: 
            case 329560: 
            case 329610: 
            case 329620: 
            case 329730: {
                this.mRVAGges = this.mRVAGges.add(result);
                break;
            }
            case 772110: 
            case 772120: 
            case 775510: 
            case 775512: 
            case 775514: 
            case 775520: 
            case 775550: 
            case 775555: 
            case 775560: 
            case 775610: 
            case 775620: 
            case 775630: 
            case 775640: 
            case 775650: 
            case 775655: 
            case 775720: 
            case 775725: 
            case 775730: {
                this.mRVAGbst = this.mRVAGbst.add(result);
                break;
            }
            case 328620: 
            case 328630: {
                this.mRVANges = this.mRVANges.add(result);
                break;
            }
            case 328510: 
            case 328512: 
            case 328514: 
            case 328550: 
            case 328610: 
            case 328730: {
                this.mRVANges = this.mRVANges.add(result);
                break;
            }
            case 772010: 
            case 774510: 
            case 774511: 
            case 774512: 
            case 774514: 
            case 774550: 
            case 774560: 
            case 774565: 
            case 774610: 
            case 774620: 
            case 774630: 
            case 774710: 
            case 774720: 
            case 774730: {
                this.mGesamtBerufVersorg = this.mGesamtBerufVersorg.add(result);
                break;
            }
            case 770020: 
            case 770025: 
            case 770030: 
            case 770035: 
            case 770040: 
            case 770045: {
                this.mgKVAG = this.mgKVAG.add(result);
                break;
            }
            case 770120: 
            case 770130: 
            case 770140: {
                this.mpKVAG = this.mpKVAG.add(result);
                break;
            }
            case 771020: 
            case 771030: 
            case 771040: 
            case 771120: 
            case 771130: 
            case 771140: {
                this.mgPVAG = this.mgPVAG.add(result);
                break;
            }
            case 322620: 
            case 322626: {
                this.mKVAN = this.mKVAN.add(result);
                break;
            }
            case 322510: 
            case 322514: 
            case 322516: 
            case 322518: 
            case 322610: 
            case 322616: 
            case 322630: 
            case 322636: 
            case 323730: 
            case 323736: 
            case 351510: 
            case 351516: 
            case 750300: {
                this.mKVAN = this.mKVAN.add(result);
                break;
            }
            case 750200: {
                this.mKVAN = this.mKVAN.subtract(result);
                break;
            }
            case 340620: 
            case 340626: {
                this.mPVAN = this.mPVAN.add(result);
                break;
            }
            case 340510: 
            case 340514: 
            case 340516: 
            case 340518: 
            case 340610: 
            case 340616: 
            case 340630: 
            case 340636: 
            case 340730: 
            case 340736: 
            case 355510: 
            case 355516: {
                this.mPVAN = this.mPVAN.add(result);
                break;
            }
            case 334620: {
                this.mAVAN = this.mAVAN.add(result);
                break;
            }
            case 334510: 
            case 334514: 
            case 334610: 
            case 334630: 
            case 334730: {
                this.mAVAN = this.mAVAN.add(result);
                break;
            }
            case 104710: 
            case 104720: 
            case 104730: {
                this.mprivKVPV = this.mprivKVPV.add(result);
                break;
            }
            case 102560: 
            case 102570: {
                this.mSterbKapAbfNzVB = this.mSterbKapAbfNzVB.add(result);
            }
            case 760500: {
                this.mKiGe = this.mKiGe.add(result);
                break;
            }
            case 103600: {
                this.mFBDBATR = this.mFBDBATR.add(result);
                break;
            }
            case 101000: {
                this.mBMGpSt = this.mBMGpSt.add(result);
                break;
            }
            case 101610: {
                this.mBMGpSt = this.mBMGpSt.subtract(result);
                this.mBMGpSt37b = this.mBMGpSt37b.add(result);
                break;
            }
            case 101680: {
                this.mBMGpSt = this.mBMGpSt.subtract(result);
                this.mBMGKnapp = this.mBMGKnapp.add(result);
                break;
            }
            case 710510: {
                this.mPLSt = this.mPLSt.add(result);
                break;
            }
            case 728300: 
            case 728800: {
                this.mPLSt = this.mPLSt.subtract(result);
                this.mPLSt37b = this.mPLSt37b.add(result);
                break;
            }
            case 710520: {
                this.mPSolZ = this.mPSolZ.add(result);
                break;
            }
            case 710600: {
                this.mPKiSt = this.mPKiSt.add(result);
                break;
            }
            case 710280: {
                this.mPLStKnapp = this.mPLStKnapp.add(result);
                break;
            }
            case 115100: {
                this.mBMGKammer = this.mBMGKammer.add(result);
                break;
            }
            case 250510: {
                this.mKammerHB = this.mKammerHB.add(result);
                break;
            }
            case 250610: {
                this.mKammerSL = this.mKammerSL.add(result);
                break;
            }
            case 320510: {
                break;
            }
            case 110590: {
                this.mStTage = this.mStTage.add(result);
                break;
            }
            case 890000: {
                this.mAuszBetr = this.mAuszBetr.add(result);
                break;
            }
            case 890100: {
                this.mAuszBetr = this.mAuszBetr.subtract(result);
                break;
            }
            case 760600: {
                this.mBAVFoerd = this.mBAVFoerd.add(result);
                break;
            }
            case 145515: 
            case 145525: {
                this.mBAVRef2016 = this.mBAVRef2016.add(result);
            }
        }
    }

    private static boolean isDecember(Date date) {
        return new VDate(date).getMonth() == 11;
    }

    public LohnkontoBean diff(LohnkontoBean lohnkontoBeanOld) {
        LohnkontoBean lohnkontoBeanNew = this;
        this.mAnzU = lohnkontoBeanNew.getAnzU() - lohnkontoBeanOld.getAnzU() > 0 ? 0 : lohnkontoBeanNew.getAnzU() - lohnkontoBeanOld.getAnzU();
        this.mGBS = lohnkontoBeanNew.getGBS();
        this.mGBB = " ";
        this.mGBF = lohnkontoBeanNew.getGBF();
        this.mGBFR = lohnkontoBeanNew.getGBFR();
        this.mGBM = lohnkontoBeanNew.getGBM();
        this.mStBrutto = lohnkontoBeanNew.getStBrutto().subtract(lohnkontoBeanOld.getStBrutto());
        this.mLStnachJA = lohnkontoBeanNew.getLStnachJA().subtract(lohnkontoBeanOld.getLStnachJA());
        this.mSolZ = lohnkontoBeanNew.getSolZ().subtract(lohnkontoBeanOld.getSolZ());
        this.mKiStAN = lohnkontoBeanNew.getKiStAN().subtract(lohnkontoBeanOld.getKiStAN());
        this.mKiStEG = lohnkontoBeanNew.getKiStEG().subtract(lohnkontoBeanOld.getKiStEG());
        this.mVersBez = lohnkontoBeanNew.getVersBez().subtract(lohnkontoBeanOld.getVersBez());
        this.mVersBezstbegmKj = lohnkontoBeanNew.getVersBezstbegmKj().subtract(lohnkontoBeanOld.getVersBezstbegmKj());
        this.mVersBezmKj = lohnkontoBeanNew.getVersBezmKj().subtract(lohnkontoBeanOld.getVersBezmKj());
        this.mEbALEnt = lohnkontoBeanNew.getEbALEnt().subtract(lohnkontoBeanOld.getEbALEnt());
        this.mALmKjEnt = lohnkontoBeanNew.getALmKjEnt().subtract(lohnkontoBeanOld.getALmKjEnt());
        this.mLStebBez = lohnkontoBeanNew.getLStebBez().subtract(lohnkontoBeanOld.getLStebBez());
        this.mSolzebBez = lohnkontoBeanNew.getSolzebBez().subtract(lohnkontoBeanOld.getSolzebBez());
        this.mKiStANebBez = lohnkontoBeanNew.getKiStANebBez().subtract(lohnkontoBeanOld.getKiStANebBez());
        this.mKiStEGebBez = lohnkontoBeanNew.getKiStEGebBez().subtract(lohnkontoBeanOld.getKiStEGebBez());
        this.mLoEL = lohnkontoBeanNew.getLoEL().subtract(lohnkontoBeanOld.getLoEL());
        this.mLoELKUG = lohnkontoBeanNew.getLoELKUG().subtract(lohnkontoBeanOld.getLoELKUG());
        this.mStfrALDBA = lohnkontoBeanNew.getStfrALDBA().subtract(lohnkontoBeanOld.getStfrALDBA());
        this.mStfrALATE = lohnkontoBeanNew.getStfrALATE().subtract(lohnkontoBeanOld.getStfrALATE());
        this.mStfrAGLFWA = lohnkontoBeanNew.getStfrAGLFWA().subtract(lohnkontoBeanOld.getStfrAGLFWA());
        this.mPAGLFWA = lohnkontoBeanNew.getPAGLFWA().subtract(lohnkontoBeanOld.getPAGLFWA());
        this.mNebALEnt = lohnkontoBeanNew.getNebALEnt().subtract(lohnkontoBeanOld.getNebALEnt());
        this.mStfrVerpflZAuswT = lohnkontoBeanNew.getStfrVerpflZAuswT().subtract(lohnkontoBeanOld.getStfrVerpflZAuswT());
        this.mStfrAGLdHH = lohnkontoBeanNew.getStfrAGLdHH().subtract(lohnkontoBeanOld.getStfrAGLdHH());
        this.mRVAGges = lohnkontoBeanNew.getRVAGges().subtract(lohnkontoBeanOld.getRVAGges());
        this.mRVAGbst = lohnkontoBeanNew.getRVAGbst().subtract(lohnkontoBeanOld.getRVAGbst());
        this.mRVANges = lohnkontoBeanNew.getRVANges().subtract(lohnkontoBeanOld.getRVANges());
        this.mRVANbst = lohnkontoBeanNew.getRVANbst().subtract(lohnkontoBeanOld.getRVANbst());
        this.mKVPVAG = " ";
        this.mgKVAG = lohnkontoBeanNew.getGKVAG().subtract(lohnkontoBeanOld.getGKVAG());
        this.mpKVAG = lohnkontoBeanNew.getPKVAG().subtract(lohnkontoBeanOld.getPKVAG());
        this.mgPVAG = lohnkontoBeanNew.getGPVAG().subtract(lohnkontoBeanOld.getGPVAG());
        this.mKVAN = lohnkontoBeanNew.getKVAN().subtract(lohnkontoBeanOld.getKVAN());
        this.mPVAN = lohnkontoBeanNew.getPVAN().subtract(lohnkontoBeanOld.getPVAN());
        this.mAVAN = lohnkontoBeanNew.getAVAN().subtract(lohnkontoBeanOld.getAVAN());
        this.mprivKVPV = lohnkontoBeanNew.getPrivKVPV().subtract(lohnkontoBeanOld.getPrivKVPV());
        this.mBMGVERSFB = "";
        this.mSterbKapAbfNzVB = lohnkontoBeanNew.getSterbKapAbfNzVB().subtract(lohnkontoBeanOld.getSterbKapAbfNzVB());
        this.mKiGe = lohnkontoBeanNew.getKiGe().subtract(lohnkontoBeanOld.getKiGe());
        this.mFBDBATR = lohnkontoBeanNew.getFBDBATR().subtract(lohnkontoBeanOld.getFBDBATR());
        this.mBMGpSt = lohnkontoBeanNew.getBMGpSt().subtract(lohnkontoBeanOld.getBMGpSt());
        this.mPLSt = lohnkontoBeanNew.getPLSt().subtract(lohnkontoBeanOld.getPLSt());
        this.mPSolZ = lohnkontoBeanNew.getPSolZ().subtract(lohnkontoBeanOld.getPSolZ());
        this.mPKiSt = lohnkontoBeanNew.getPKiSt().subtract(lohnkontoBeanOld.getPKiSt());
        this.mBMGpSt37b = lohnkontoBeanNew.getBMGpSt37b().subtract(lohnkontoBeanOld.getBMGpSt37b());
        this.mPLSt37b = lohnkontoBeanNew.getPLSt37b().subtract(lohnkontoBeanOld.getPLSt37b());
        this.mBMGKnapp = lohnkontoBeanNew.getBMGKnapp().subtract(lohnkontoBeanOld.getBMGKnapp());
        this.mPLStKnapp = lohnkontoBeanNew.getPLStKnapp().subtract(lohnkontoBeanOld.getPLStKnapp());
        this.mBMGKammerHB = lohnkontoBeanNew.getBMGKammerHB().subtract(lohnkontoBeanOld.getBMGKammerHB());
        this.mBMGKammerSL = lohnkontoBeanNew.getBMGKammerSL().subtract(lohnkontoBeanOld.getBMGKammerSL());
        this.mKammerHB = lohnkontoBeanNew.getKammerHB().subtract(lohnkontoBeanOld.getKammerHB());
        this.mKammerSL = lohnkontoBeanNew.getKammerSL().subtract(lohnkontoBeanOld.getKammerSL());
        this.mSVAN = " ";
        this.mStTage = lohnkontoBeanNew.getStTage().subtract(lohnkontoBeanOld.getStTage());
        this.mLStvorJA = lohnkontoBeanNew.getLStvorJA().subtract(lohnkontoBeanOld.getLStvorJA());
        this.mAuszBetr = lohnkontoBeanNew.getAuszBetr().subtract(lohnkontoBeanOld.getAuszBetr());
        this.mBAVFoerd = lohnkontoBeanNew.getBAVFoerd().subtract(lohnkontoBeanOld.getBAVFoerd());
        this.mBAVRef2016 = lohnkontoBeanNew.getBAVRef2016().subtract(lohnkontoBeanOld.getBAVRef2016());
        return lohnkontoBeanNew;
    }

    public IEECompanyPlant getEECompanyPlant(IEECompanyPlant eeCompanyPlant, Employee employee, Date effectiveTimePoint, Date validTimePoint) {
        if (eeCompanyPlant == null) {
            eeCompanyPlant = (IEECompanyPlant)UtilitiesManager.getBean((String)"eeCompanyPlant", IEECompanyPlant.class);
        }
        eeCompanyPlant.setEmployee(employee);
        eeCompanyPlant.setEffectiveFrom(effectiveTimePoint);
        eeCompanyPlant.setValidFrom(validTimePoint);
        return eeCompanyPlant;
    }
}

