/*
 * Decompiled with CFR 0.152.
 */
package com.varial.personnel.domain.dataexport.dls;

import com.infor.igf.core.persistency.PersistencyContainer;
import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.PersistencyDataSet;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.types.date.DateHelper;
import com.varial.personnel.domain.dataexport.BigDecimalExportColumn;
import com.varial.personnel.domain.dataexport.ExportColumn;
import com.varial.personnel.domain.dataexport.IntegerExportColumn;
import com.varial.personnel.domain.dataexport.SpecialTextExportColumn;
import com.varial.personnel.domain.dataexport.TextExportColumn;
import com.varial.personnel.domain.dataexport.dls.DLSExportTable;
import com.varial.personnel.domain.dataexport.dls.DateExportColumn;
import com.varial.personnel.domain.dataexport.dls.ExportTypeEnum;
import com.varial.personnel.domain.employee.Employee;
import com.varial.personnel.domain.employee.IEECompanyPlant;
import com.varial.personnel.domain.employee.bankdetails.EEBankDetailsTP;
import com.varial.personnel.domain.employee.bankdetails.IEEBankDetailsTPPersistencyManager;
import com.varial.personnel.domain.employee.insurance.Insurance;
import com.varial.personnel.domain.employee.master.Master;
import com.varial.personnel.domain.employee.materialexpenses.EEMaterialExpensesTP;
import com.varial.personnel.domain.employee.materialexpenses.EEMaterialExpensesTPPersistencyManager;
import com.varial.personnel.domain.employee.tax.ChurchTaxEnum;
import com.varial.personnel.domain.employee.tax.Tax;
import com.varial.personnel.domain.employee.tax.TaxacationEnum;
import com.varial.personnel.domain.employee.tax.mapper.ChurchTaxEnumMapper;
import com.varial.personnel.domain.global.bank.BankTP;
import com.varial.personnel.domain.global.healthfund.HealthFundTP;
import com.varial.personnel.domain.global.occupationlong.OccupationLongTP;
import com.varial.personnel.domain.workingtime.WorkingTimeTP;
import com.varial.personnel.framework.basictypes.PostalAddress;
import com.varial.personnel.persistency.employee.employmentall.EmploymentallContainer;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.domain.textoutput.FieldSeparator;
import com.varial.serverbase.domain.textoutput.LineSeparator;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.math.BigDecimal;
import java.util.Date;

public class ArbeitnehmerExportTable
extends DLSExportTable {
    private final IntegerExportColumn mAbrJahr = new IntegerExportColumn("Abr_Jahr", "Abrechnungsjahr", 4, true);
    private final IntegerExportColumn mAbrMon = new IntegerExportColumn("Abr_Mon", "Abrechnungsmonat", 2, true);
    private final IntegerExportColumn mAnmJahr = new IntegerExportColumn("Anm_Jahr", "Anmeldungsjahr", 4, true);
    private final IntegerExportColumn mAnmZtr = new IntegerExportColumn("Anm_Ztr", "Anmeldungszeitraum", 2, true);
    private final IntegerExportColumn mAendZahl = new IntegerExportColumn("Aend_Zahl", "\u00c4nderungsz\u00e4hler", 2, true);
    private final TextExportColumn mPersNr = new TextExportColumn("Pers_Nr", "Personalnummer", 8, true);
    private final TextExportColumn mIDNr = new TextExportColumn("ID_Nr", "Identifikationsnummer", 80, true);
    private final TextExportColumn mANVorname = new TextExportColumn("AN_Vorname", "Vorname des Arbeitnehmers", 50, true);
    private final TextExportColumn mANNachname = new TextExportColumn("AN_Nachname", "Nachname des Arbeitnehmers", 50, true);
    private final TextExportColumn mAGebName = new TextExportColumn("AN_Geb_Name", "Geburtsname des Arbeitnehmers", 50, true);
    private final TextExportColumn mANTitel = new TextExportColumn("AN_Titel", "Titel des Arbeitnehmers", 20, true);
    private final TextExportColumn mANStrasseNHW = new TextExportColumn("AN_Strasse_Nr_HW", "Stra\u00dfe und Hausnummer des Arbeitnehmers", 60, true);
    private final TextExportColumn mANPLZHW = new TextExportColumn("AN_PLZ_HW", "PLZ des Arbeitnehmers", 10, true);
    private final TextExportColumn mANOrtHW = new TextExportColumn("AN_Ort_HW", "Ort des Arbeitnehmers", 50, true);
    private final TextExportColumn mANLandHW = new TextExportColumn("AN_Land_HW", "Land des Arbeitnehmers", 2, true);
    private final DateExportColumn mGebDat = new DateExportColumn("Geb_Dat", "Geburtsdatum", true);
    private final TextExportColumn mGeschl = new TextExportColumn("Geschl", "Geschlecht", 1, true);
    private final TextExportColumn mANBank = new TextExportColumn("AN_Bank", "Kreditinstitut", 256, true);
    private final TextExportColumn mANBLZ = new TextExportColumn("AN_BLZ", "Bankleitzahl", 1, true);
    private final TextExportColumn mANKtoNr = new TextExportColumn("AN_Kto_Nr", "Kontonummer", 1, true);
    private final DateExportColumn mEintritt = new DateExportColumn("Eintritt", "Besch\u00e4ftigungsbeginn", true);
    private final DateExportColumn mAustritt = new DateExportColumn("Austritt", "Besch\u00e4ftigungsende", true);
    private final SpecialTextExportColumn mEintritt2 = new SpecialTextExportColumn("Eintritt2", "Wiedereintritt", 10, true);
    private final SpecialTextExportColumn mAustritt2 = new SpecialTextExportColumn("Austritt2", "Wiederaustritt", 10, true);
    private final DateExportColumn mEintrittL = new DateExportColumn("Eintritt_L", "Letzter Wiedereintritt", true);
    private final DateExportColumn mAustrittL = new DateExportColumn("Austritt_L", "Letzter Wiederaustritt", true);
    private final IntegerExportColumn mEKMFWA = new IntegerExportColumn("EKM_FWA", "Entfernungskilometer", 4, true);
    private final IntegerExportColumn mStKl = new IntegerExportColumn("St_Kl", "Steuerklasse", 1, true);
    private final TextExportColumn mANKonf = new TextExportColumn("AN_Konf", "Konfession", 2, true);
    private final TextExportColumn mEGKonf = new TextExportColumn("EG_Konf", "Konfession des Ehegatten", 2, true);
    private final BigDecimalExportColumn mKFB;
    private final TextExportColumn mStpfl;
    private final TextExportColumn mDBA;
    private final TextExportColumn mATE;
    private final TextExportColumn mGrenzg;
    private final BigDecimalExportColumn mJFB;
    private final BigDecimalExportColumn mMFB;
    private final BigDecimalExportColumn mHZB;
    private final TextExportColumn mTab;
    private final TextExportColumn meTINNr;
    private final TextExportColumn mBerufsBez;
    private final TextExportColumn mIBAN;
    private final TextExportColumn mBIC;
    private final TextExportColumn mANStrasseNrNW;
    private final TextExportColumn mANPlzNW;
    private final TextExportColumn mANOrtNW;
    private final TextExportColumn mANLandNW;
    private final TextExportColumn mGerfBesch2vH;
    private final TextExportColumn mHeuerKZ;
    private final DateExportColumn mATZBeg;
    private final DateExportColumn mATZEnde;
    private final BigDecimalExportColumn mWoechArbz;
    private final SpecialTextExportColumn mAEBetrag;
    private final TextExportColumn mVEmpfKZ;
    private final SpecialTextExportColumn mVEmpfBeg;
    private final SpecialTextExportColumn mVEmpfEnde;
    private final TextExportColumn mVEmpfJahr;
    private final TextExportColumn mVEmpfBM;
    private final TextExportColumn mVEmpfEM;
    private final BigDecimalExportColumn mStKlFaktor;
    private final TextExportColumn mWerkANStrasseNr;
    private final TextExportColumn mWerkANPLZ;
    private final TextExportColumn mWerkANOrt;
    private final TextExportColumn mZuschlPVOrt;
    private final TextExportColumn mZuschlPVKind;
    private final IntegerExportColumn mPVKindAnzahl;
    private final TextExportColumn mAufstRV;
    private final BigDecimalExportColumn mZBgesvH;
    private final TextExportColumn mELSTAMAbruf;
    private final TextExportColumn mWerkANOrg;
    private final TextExportColumn mWerkANUOrg;
    private IEECompanyPlant mEECompanyPlant;

    public ArbeitnehmerExportTable(FieldSeparator fieldSeparator, LineSeparator lineSeparator, char decimalPoint) {
        super("DLS-Arbeitnehmer", "Arbeitnehmerstammdaten", "arbeitnehmerstammdaten.csv", fieldSeparator, lineSeparator, decimalPoint);
        this.mKFB = new BigDecimalExportColumn("KFB", "Kinderfreibetrag", 2, true, 1, decimalPoint);
        this.mStpfl = new TextExportColumn("Stpfl", "Steuerpflicht", 2, true);
        this.mDBA = new TextExportColumn("DBA", "Doppelbesteuerungsabkommen", 4, true);
        this.mATE = new TextExportColumn("ATE", "Auslandst\u00e4tigkeitserlass", 4, true);
        this.mGrenzg = new TextExportColumn("Grenzg", "Grenzg\u00e4nger", 4, true);
        this.mJFB = new BigDecimalExportColumn("JFB", "Jahresfreibetrag", 12, true, 2, decimalPoint);
        this.mMFB = new BigDecimalExportColumn("MFB", "Monatsfreibetrag", 12, true, 2, decimalPoint);
        this.mHZB = new BigDecimalExportColumn("HZB", "Hinzurechnungsbetrag", 12, true, 2, decimalPoint);
        this.mTab = new TextExportColumn("Tab", "Steuertabelle", 1, true);
        this.meTINNr = new TextExportColumn("eTIN_Nr", "Elektronische Transferidentifikationsnummer", 1, true);
        this.mBerufsBez = new TextExportColumn("Berufs_Bez", "Berufsbezeichnung", 256, true);
        this.mIBAN = new TextExportColumn("IBAN", "International Bankaccountnumber", 128, true);
        this.mBIC = new TextExportColumn("BIC", "Bankidentificationcode", 64, true);
        this.mANStrasseNrNW = new TextExportColumn("AN_Strasse_Nr_NW", "Stra\u00dfe und Hausnummer des Arbeitnehmers NW", 1, true);
        this.mANPlzNW = new TextExportColumn("AN_Plz_NW", "PLZ des Arbeitnehmers NW", 1, true);
        this.mANOrtNW = new TextExportColumn("AN_Ort_NW", "Ort des Arbeitnehmers NW", 1, true);
        this.mANLandNW = new TextExportColumn("AN_Land_NW", "Land des Arbeitnehmers NW", 1, true);
        this.mGerfBesch2vH = new TextExportColumn("Gerf_Besch_2vH", "Geringf\u00fcgige Besch\u00e4ftigung 2 v.H.", 4, true);
        this.mHeuerKZ = new TextExportColumn("Heuer_KZ", "Heuerkennzeichen", 1, true);
        this.mATZBeg = new DateExportColumn("ATZ_Beg", "Altersteilzeit Beginn", true);
        this.mATZEnde = new DateExportColumn("ATZ_Ende", "Altersteilzeit Ende", true);
        this.mWoechArbz = new BigDecimalExportColumn("Woech_Arbz", "W\u00f6chentliche Arbeitszeit", 12, true, 2, decimalPoint);
        this.mAEBetrag = new SpecialTextExportColumn("AE_Betrag", "Altersentlastungsbetrag", 1, true);
        this.mVEmpfKZ = new TextExportColumn("V_Empf_KZ", "Versorgungsempf\u00e4nger", 4, true);
        this.mVEmpfBeg = new SpecialTextExportColumn("V_Empf_Beg", "Versorgungsbeginn", 10, true);
        this.mVEmpfEnde = new SpecialTextExportColumn("V_Empf_Ende", "Versorgungsende", 10, true);
        this.mVEmpfJahr = new TextExportColumn("V_Empf_Jahr", "Jahr des erstmaligen Versorgungsbeginns", 4, true);
        this.mVEmpfBM = new TextExportColumn("V_Empf_B_M", "Monat bei unterj\u00e4hrigem Versorgungsbeginn", 2, true);
        this.mVEmpfEM = new TextExportColumn("V_Empf_E_M", "Monat bei unterj\u00e4hrigen Versorgungsende", 2, true);
        this.mStKlFaktor = new BigDecimalExportColumn("StKl_Faktor", "Steuerklassenfaktor", 1, true, 3, decimalPoint);
        this.mWerkANStrasseNr = new TextExportColumn("Werk_AN_Strasse_Nr", "Stra\u00dfe und Hausnummer der Anschrift des Besch\u00e4ftigungsortes des AN", 50, true);
        this.mWerkANPLZ = new TextExportColumn("Werk_AN_PLZ", "PLZ der Anschrift des Besch\u00e4ftigungsortes des AN", 10, true);
        this.mWerkANOrt = new TextExportColumn("Werk_AN_Ort", "Ort der Anschrift des Besch\u00e4ftigungsortes des AN", 50, true);
        this.mZuschlPVOrt = new TextExportColumn("Zuschl_PV_Ort", "Zuschlag zur Pflegeversicherung ortsabh\u00e4ngig", 4, true);
        this.mZuschlPVKind = new TextExportColumn("Zuschl_PV_Kind", "Zuschlag zur Pflegeversicherung wegen Kinderlosigkeit", 4, true);
        this.mPVKindAnzahl = new IntegerExportColumn("PV_Kind_Anzahl", "Anzahl der Kinder f\u00fcr die Berechnung des Pflegeversicherungsbeitrags", 1, true);
        this.mAufstRV = new TextExportColumn("Aufst_RV", "Aufstockung Rentenversicherungsbeitrag", 1, true);
        this.mZBgesvH = new BigDecimalExportColumn("ZB_ges_vH", "Beitragssatz zum Zusatzbeitrag zur gesetzlichen Krankenversicherung", 12, true, 2, decimalPoint);
        this.mELSTAMAbruf = new TextExportColumn("ELSTAM_Abruf", "Abruf elektronischer Lohnsteuerabzugsmerkmale ", 4, true);
        this.mWerkANOrg = new TextExportColumn("Werk_AN_Org", "Organisationseinheit", 1, true);
        this.mWerkANUOrg = new TextExportColumn("Werk_AN_U_Org", "Unterorganisationseinheit", 1, true);
        this.setColumns(new ExportColumn[]{this.mAbrJahr, this.mAbrMon, this.mAnmJahr, this.mAnmZtr, this.mAendZahl, this.mPersNr, this.mIDNr, this.mANVorname, this.mANNachname, this.mAGebName, this.mANTitel, this.mANStrasseNHW, this.mANPLZHW, this.mANOrtHW, this.mANLandHW, this.mGebDat, this.mGeschl, this.mANBank, this.mANBLZ, this.mANKtoNr, this.mEintritt, this.mAustritt, this.mEintritt2, this.mAustritt2, this.mEintrittL, this.mAustrittL, this.mEKMFWA, this.mStKl, this.mANKonf, this.mEGKonf, this.mKFB, this.mStpfl, this.mDBA, this.mATE, this.mGrenzg, this.mJFB, this.mMFB, this.mHZB, this.mTab, this.meTINNr, this.mBerufsBez, this.mIBAN, this.mBIC, this.mANStrasseNrNW, this.mANPlzNW, this.mANOrtNW, this.mANLandNW, this.mGerfBesch2vH, this.mHeuerKZ, this.mATZBeg, this.mATZEnde, this.mWoechArbz, this.mAEBetrag, this.mVEmpfKZ, this.mVEmpfBeg, this.mVEmpfEnde, this.mVEmpfJahr, this.mVEmpfBM, this.mVEmpfEM, this.mStKlFaktor, this.mWerkANStrasseNr, this.mWerkANPLZ, this.mWerkANOrt, this.mZuschlPVOrt, this.mZuschlPVKind, this.mPVKindAnzahl, this.mAufstRV, this.mZBgesvH, this.mELSTAMAbruf, this.mWerkANOrg, this.mWerkANUOrg});
    }

    protected void fillVisibleOutputFields(PersistencyContainer persistencyContainer) throws BusinessDomainException {
        HealthFundTP hfTP;
        VDate endKVDR;
        WorkingTimeTP workingTimeTP;
        Date validTimePoint = this.getArbeitnehmerBean().getValidFrom();
        Date effectiveTimePoint = this.getArbeitnehmerBean().getEffectiveFrom();
        Employee employee = this.getArbeitnehmerBean().getEmployee();
        this.init();
        this.mAbrJahr.setInteger(Integer.valueOf(DateHelper.getYear((Date)validTimePoint) + 1900));
        this.mAbrMon.setInteger(Integer.valueOf(DateHelper.getMonth((Date)validTimePoint) + 1));
        this.mAnmJahr.setInteger(Integer.valueOf(DateHelper.getYear((Date)effectiveTimePoint) + 1900));
        this.mAnmZtr.setInteger(Integer.valueOf(this.getAnmeldezeitraum(effectiveTimePoint, validTimePoint)));
        this.mAendZahl.setInteger(Integer.valueOf(this.getArbeitnehmerBean().getCalculationCount()));
        this.mPersNr.setText(String.valueOf(employee.getPersonnelnumber()));
        this.mIDNr.setText(this.getIDnr(employee));
        EmploymentallContainer employmentallContainer = (EmploymentallContainer)persistencyContainer;
        Master master = (Master)employee.getMasterHistory().getItemOrNull(effectiveTimePoint, DateHelper.getLastDayOfMonth((Date)validTimePoint));
        Insurance insurance = (Insurance)employee.getInsuranceHistory().getItemOrNull(effectiveTimePoint, DateHelper.getLastDayOfMonth((Date)validTimePoint));
        EEBankDetailsTP[] eeBankDetailsTP = this.getIEEBankDetailsTPPM().queryAll(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)employee.getObjectid()), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)effectiveTimePoint)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)effectiveTimePoint)), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)validTimePoint))), Restrictions.ge((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)validTimePoint))), Restrictions.eq((String)"rankingnumber", (String)String.valueOf(99))}), true);
        Tax tax = (Tax)employee.getTaxHistory().getItemOrNull(effectiveTimePoint, DateHelper.getLastDayOfMonth((Date)validTimePoint));
        if (master != null) {
            this.mANVorname.setText(master.getFirstname());
            this.mANNachname.setText(master.getSurname());
        }
        if (insurance != null) {
            this.mAGebName.setText(insurance.getNameAtBirth());
        }
        if (master != null) {
            this.mANTitel.setText(master.getTitle());
            this.mANStrasseNHW.setText(new StringBuffer(master.getStreet()).append(" ").append(master.getStreetNumber()).toString());
            this.mANPLZHW.setText(master.getPostalCode());
            this.mANOrtHW.setText(master.getDomicile());
            this.mANLandHW.setText(this.getIsoCode3166_1(master.getState()));
            this.mGebDat.setDate(master.getDateOfBirth());
        }
        if (eeBankDetailsTP.length > 0 && eeBankDetailsTP[0].getBankAccount() != null && eeBankDetailsTP[0].getBankAccount().getBank() != null) {
            BankTP bankTP = (BankTP)eeBankDetailsTP[0].getBankAccount().getBank().getHistory().getItemOrNull(VDate.getDateMax(), VDate.getDateMax());
            this.mANBank.setText(bankTP.getLongDescription());
        }
        Date minimumDateofEntry = employee.getMinimumDateOfEntry();
        this.mEintritt.setDate(minimumDateofEntry);
        this.mAustritt.setDate(employee.getDateOfWithdrawalToDateOfEntry(minimumDateofEntry));
        this.mEintrittL.setDate(employmentallContainer.dateofentry);
        this.mAustrittL.setDate(employmentallContainer.dateofwithdrawal);
        this.mEKMFWA.setInteger(this.getDistance(employee, effectiveTimePoint, validTimePoint));
        if (tax != null) {
            this.mStKl.setInteger(Integer.valueOf(tax.getTaxBracket()));
            this.mANKonf.setText(ChurchTaxEnumMapper.toDlsString((ChurchTaxEnum)tax.getChurchTaxEE()));
            this.mEGKonf.setText(ChurchTaxEnumMapper.toDlsString((ChurchTaxEnum)tax.getChurchTaxSpouse()));
            this.mKFB.setBigDecimal(tax.getChildRelief());
            if (tax.getTaxacation() == TaxacationEnum.TE_BESCHRAENKTE_STEUERPFLICHT) {
                this.mStpfl.setText("b");
            } else if (tax.getTaxacation() == TaxacationEnum.TE_UNBESCHRAENKTE_STEUERPFLICHT) {
                this.mStpfl.setText("ub");
            } else if (tax.getTaxacation() == TaxacationEnum.TE_STEUERFREIE_BESCHAEFTIGUNG) {
                this.mStpfl.setText("k");
            } else {
                this.mStpfl.setText("eb");
            }
            this.mDBA.setText(this.getDBA(tax));
            if (tax.getTaxacation() == TaxacationEnum.TE_STEUERFREIER_AUSLANDSTAETIGKEITSERLASS) {
                this.mATE.setText("ja");
            } else {
                this.mATE.setText("nein");
            }
            if (tax.getTaxacation() == TaxacationEnum.TE_GRENZGAENGER || tax.getTaxacation() == TaxacationEnum.TE_SCHWEIZER_GRENZGAENGER || tax.getTaxacation() == TaxacationEnum.TE_SCHWEIZER_GRENZGAENGER_ABWANDERER || tax.getCrossBorderEmployeeFrance()) {
                this.mGrenzg.setText("ja");
            } else {
                this.mGrenzg.setText("nein");
            }
            this.mJFB.setBigDecimal(tax.getFreeAllowanceYY());
            this.mMFB.setBigDecimal(tax.getFreeAllowanceMM());
            this.mHZB.setBigDecimal(tax.getAddAmountYY());
        }
        if (insurance != null && insurance.getOccupationLong() != null) {
            this.mBerufsBez.setText(((OccupationLongTP)insurance.getOccupationLong().getHistory().getItemOrNull(VDate.getDateMax(), VDate.getDateMax())).getLongDescription());
        }
        if (eeBankDetailsTP.length > 0 && eeBankDetailsTP[0].getBankAccount() != null) {
            this.mIBAN.setText(eeBankDetailsTP[0].getBankAccount().getIban());
            if (eeBankDetailsTP[0].getBankAccount().getBank() != null) {
                BankTP bankTP = (BankTP)eeBankDetailsTP[0].getBankAccount().getBank().getHistory().getItemOrNull(VDate.getDateMax(), VDate.getDateMax());
                this.mBIC.setText(bankTP.getBicCode());
            }
        }
        if (tax != null && tax.getTaxacation() == TaxacationEnum.TE_PAUSCHAL_EINHEITLICHE_PAUSCHSTEUER_GFB) {
            this.mGerfBesch2vH.setText("ja");
        }
        if (insurance != null) {
            this.mATZBeg.setDate(insurance.getBeginAgePartTime());
            this.mATZEnde.setDate(insurance.getEndAgePartTime());
        }
        if ((workingTimeTP = (WorkingTimeTP)employee.getAppurtenantWorkingTime(effectiveTimePoint, DateHelper.getLastDayOfMonth((Date)validTimePoint)).getHistory().getItemOrNull(effectiveTimePoint, DateHelper.getLastDayOfMonth((Date)validTimePoint))) != null) {
            this.mWoechArbz.setBigDecimal(workingTimeTP.getWeeklyWorkingTime());
        }
        if (tax != null) {
            if (tax.getPensionFreeDues()) {
                this.mVEmpfKZ.setText("ja");
            } else {
                this.mVEmpfKZ.setText("nein");
            }
            if (tax.getStartDateOfPension() != null) {
                VDate startDateOfPension = new VDate(tax.getStartDateOfPension());
                this.mVEmpfJahr.setText(String.valueOf(startDateOfPension.getYear()));
                if (startDateOfPension.getMonth() > 0) {
                    this.mVEmpfBM.setText(String.valueOf(startDateOfPension.getMonth()));
                }
            }
        }
        if (insurance != null && insurance.getEndKVDR() != null && (endKVDR = new VDate(insurance.getEndKVDR())).getMonth() < 11) {
            this.mVEmpfEM.setText(String.valueOf(endKVDR.getMonth()));
        }
        if (tax != null) {
            this.mStKlFaktor.setBigDecimal(tax.getPercentageSplit());
        }
        this.mEECompanyPlant = this.getEECompanyPlant(this.mEECompanyPlant, employee, effectiveTimePoint, DateHelper.getLastDayOfMonth((Date)validTimePoint));
        PostalAddress address = this.mEECompanyPlant.getAdress();
        if (address != null) {
            this.mWerkANStrasseNr.setText(address.getStreet());
            this.mWerkANPLZ.setText(address.getPostalCode());
            this.mWerkANOrt.setText(address.getCity());
        }
        if (this.mEECompanyPlant.getFederalStateTP() != null && this.mEECompanyPlant.getFederalStateTP().getFederalState().getFederalState() == 15) {
            this.mZuschlPVOrt.setText("ja");
        }
        if (insurance != null) {
            if (insurance.getNIChildEducation()) {
                this.mZuschlPVKind.setText("nein");
            }
            if (insurance.getNIChildEducation()) {
                BigDecimal anzahlKinder = BigDecimal.ZERO;
                if (DateHelper.afterOrEqual((Date)DateHelper.getLastDayOfMonth((Date)validTimePoint), (Date)new VDate(2023, 6, 1).getDate()) && BigDecimalMapper.compareTo((BigDecimal)(anzahlKinder = employee.getEffectiveNumberOfChildrenForNI(effectiveTimePoint, DateHelper.getLastDayOfMonth((Date)validTimePoint), true, false)), (BigDecimal)BigDecimal.valueOf(5L)) >= 0) {
                    anzahlKinder = BigDecimal.valueOf(5L);
                }
                this.mPVKindAnzahl.setInteger(Integer.valueOf(anzahlKinder.intValue()));
            }
        }
        if (insurance != null && (hfTP = this.getEmployeeHealthFund(insurance, validTimePoint, effectiveTimePoint)) != null) {
            this.mZBgesvH.setBigDecimal(hfTP.getAdditionalDues());
        }
        if (tax != null && !StringMapper.isNullString((String)tax.getTin()) && !tax.getNoElstam() && tax.getTaxBracket() >= 1 && tax.getTaxBracket() <= 6) {
            this.mELSTAMAbruf.setText("ja");
        }
    }

    private String getDBA(Tax tax) {
        if (tax.getTaxacation() == TaxacationEnum.TE_DBA_TUERKEI) {
            return "ja";
        }
        if (tax.getTaxacation() == TaxacationEnum.TE_STEUERFREIE_BESCHAEFTIGUNG && tax.getCtfcDBAwoutTax()) {
            return "ja";
        }
        return "nein";
    }

    private Integer getDistance(Employee employee, Date effectiveTimePoint, Date validTimePoint) {
        int distance = 0;
        EEMaterialExpensesTP[] eeMaterialExpensesTP = EEMaterialExpensesTPPersistencyManager.queryAll(null, (Criterion)Restrictions.conjunction((Criterion[])new Criterion[]{Restrictions.eq((String)"oidemployee", (String)employee.getObjectid()), Restrictions.le((String)"effectivefrom", (String)DateMapper.toString((Date)effectiveTimePoint)), Restrictions.ge((String)"effectiveuntil", (String)DateMapper.toString((Date)effectiveTimePoint)), Restrictions.le((String)"validfrom", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)validTimePoint))), Restrictions.le((String)"validuntil", (String)DateMapper.toString((Date)DateHelper.getLastDayOfMonth((Date)validTimePoint))), Restrictions.eq((String)"monetarybenefit", (String)"T")}), (boolean)true);
        if (eeMaterialExpensesTP.length > 0 && eeMaterialExpensesTP[0].getCar() != null) {
            distance = eeMaterialExpensesTP[0].getCar().getDistance().signum();
        }
        return distance;
    }

    private void init() {
        this.mAbrJahr.setInteger(Integer.valueOf(0));
        this.mAbrMon.setInteger(Integer.valueOf(0));
        this.mAnmJahr.setInteger(Integer.valueOf(0));
        this.mAnmZtr.setInteger(Integer.valueOf(0));
        this.mAendZahl.setInteger(Integer.valueOf(0));
        this.mPersNr.setText("");
        this.mIDNr.setText("");
        this.mANVorname.setText("");
        this.mANNachname.setText("");
        this.mAGebName.setText("");
        this.mANTitel.setText("");
        this.mANStrasseNHW.setText("");
        this.mANPLZHW.setText("");
        this.mANOrtHW.setText("");
        this.mANLandHW.setText("DE");
        this.mGebDat.setDate(null);
        this.mGeschl.setText(" ");
        this.mANBank.setText("");
        this.mANBLZ.setText(" ");
        this.mANKtoNr.setText(" ");
        this.mEintritt.setDate(null);
        this.mAustritt.setDate(null);
        this.mEintritt2.setText("00.00.0000");
        this.mAustritt2.setText("00.00.0000");
        this.mEintrittL.setDate(null);
        this.mAustrittL.setDate(null);
        this.mEKMFWA.setInteger(Integer.valueOf(0));
        this.mStKl.setInteger(Integer.valueOf(0));
        this.mANKonf.setText("0");
        this.mEGKonf.setText("0");
        this.mKFB.setBigDecimal(new BigDecimal(0).setScale(1));
        this.mStpfl.setText("ub");
        this.mDBA.setText("nein");
        this.mATE.setText("nein");
        this.mGrenzg.setText("nein");
        this.mJFB.setBigDecimal(new BigDecimal(0).setScale(2));
        this.mMFB.setBigDecimal(new BigDecimal(0).setScale(2));
        this.mHZB.setBigDecimal(new BigDecimal(0).setScale(2));
        this.mTab.setText(" ");
        this.meTINNr.setText(" ");
        this.mBerufsBez.setText("");
        this.mIBAN.setText("");
        this.mBIC.setText("");
        this.mANStrasseNrNW.setText(" ");
        this.mANPlzNW.setText(" ");
        this.mANOrtNW.setText(" ");
        this.mANLandNW.setText(" ");
        this.mGerfBesch2vH.setText("nein");
        this.mHeuerKZ.setText(" ");
        this.mATZBeg.setDate(null);
        this.mATZEnde.setDate(null);
        this.mWoechArbz.setBigDecimal(new BigDecimal(0).setScale(2));
        this.mAEBetrag.setText(" ");
        this.mVEmpfKZ.setText("nein");
        this.mVEmpfBeg.setText("00.00.0000");
        this.mVEmpfEnde.setText("00.00.0000");
        this.mVEmpfJahr.setText("");
        this.mVEmpfBM.setText("");
        this.mVEmpfEM.setText("");
        this.mStKlFaktor.setBigDecimal(new BigDecimal(0).setScale(3));
        this.mWerkANStrasseNr.setText("");
        this.mWerkANPLZ.setText("");
        this.mWerkANOrt.setText("");
        this.mZuschlPVOrt.setText("nein");
        this.mZuschlPVKind.setText("ja");
        this.mPVKindAnzahl.setInteger(Integer.valueOf(0));
        this.mAufstRV.setText(" ");
        this.mZBgesvH.setBigDecimal(new BigDecimal(0).setScale(2));
        this.mELSTAMAbruf.setText("nein");
        this.mWerkANOrg.setText(" ");
        this.mWerkANUOrg.setText(" ");
    }

    private IEEBankDetailsTPPersistencyManager getIEEBankDetailsTPPM() {
        return (IEEBankDetailsTPPersistencyManager)UtilitiesManager.getBean((String)"eeBankDetailsTPPersistencyManager", IEEBankDetailsTPPersistencyManager.class);
    }

    protected PersistencyDataSet getDataSet() {
        return null;
    }

    public boolean getPlants() {
        return false;
    }

    protected PersistencyDataSet getDataSetPlants() {
        return null;
    }

    protected void fillVisibleOutputFieldsPlants(PersistencyContainer persistencyContainer) throws BusinessDomainException {
    }

    protected ExportTypeEnum getExportType() {
        return ExportTypeEnum.ARBEITNEHMERSTAMMDATEN;
    }
}

