/*
 * Decompiled with CFR 0.152.
 */
package com.varial.framework.domain.country.vatcheck.vies;

import com.varial.base.UtilitiesManager;
import com.varial.base.vat.VATException;
import com.varial.base.vat.VATNumber;
import com.varial.base.vat.viesclient.ViesClient;
import com.varial.base.vat.viesclient.ViesQualifiedRequestBuilder;
import com.varial.base.vat.viesclient.ViesResponse;
import com.varial.framework.domain.country.vatcheck.IVATQualifiedCheckService;
import com.varial.framework.domain.country.vatcheck.VATQualifiedCheck;
import com.varial.framework.domain.country.vatcheck.VATQualifiedCheckRequest;
import com.varial.framework.domain.country.vatcheck.VATQualifiedCheckService;
import com.varial.interfaces.IAccountingCompany;

public class ViesVATQualifiedCheckService
extends VATQualifiedCheckService
implements IVATQualifiedCheckService {
    private ViesVATQualifiedCheckService() {
    }

    public static ViesVATQualifiedCheckService getInstance() {
        return SingletonHelper.INSTANCE;
    }

    @Override
    public VATQualifiedCheck checkVat(VATNumber requesterVAT, VATQualifiedCheckRequest request, IAccountingCompany company) {
        try {
            ViesQualifiedRequestBuilder builder = new ViesQualifiedRequestBuilder(request.getLookupVAT(), requesterVAT).withTraderName(this.toViesString(request.getTraderName())).withTraderCity(this.toViesString(request.getTraderCity())).withTraderPostcode(this.toViesString(request.getTraderPostcode())).withTraderStreet(this.toViesString(request.getTraderStreet()));
            ViesClient client = (ViesClient)UtilitiesManager.getBean((String)"igf.vat.vies.client", ViesClient.class);
            ViesResponse viesResponse = client.checkVat(builder);
            VATQualifiedCheck vatQualifiedCheckResponse = this.toVATQualifiedCheckResponse(viesResponse, request);
            return vatQualifiedCheckResponse;
        }
        catch (VATException e) {
            return this.toVATQualifiedCheckResponse(e, request);
        }
    }

    private VATQualifiedCheck toVATQualifiedCheckResponse(ViesResponse viesResponse, VATQualifiedCheckRequest request) {
        return new VATQualifiedCheck(this.toCheckResultType(viesResponse.getTraderNameMatch()), this.toCheckResultType(viesResponse.getTraderStreetMatch()), this.toCheckResultType(viesResponse.getTraderPostcodeMatch()), this.toCheckResultType(viesResponse.getTraderCityMatch()), this.toCheckResultType(viesResponse.getResponseCode()), this.toDate(viesResponse.getRequestDateTime()), viesResponse.getResponseCode().getErrorId(), request.getLookupVAT().toString(), null, null, viesResponse.getRequestIdentifier().orElse(""), false);
    }

    private String toViesString(String s) {
        return s;
    }

    private static class SingletonHelper {
        private static final ViesVATQualifiedCheckService INSTANCE = new ViesVATQualifiedCheckService();

        private SingletonHelper() {
        }
    }
}

