/*
 * Decompiled with CFR 0.152.
 */
package com.varial.framework.domain.country.vatcheck;

import com.infor.igf.core.util.StringUtil;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.vat.VATNumber;
import com.varial.base.vat.VATNumberFactory;
import com.varial.framework.domain.company.ICompany;
import com.varial.framework.domain.country.vatcheck.IVATQualifiedCheckService;
import com.varial.framework.domain.country.vatcheck.VATCheckExceptionMapper;
import com.varial.framework.domain.country.vatcheck.VATQualifiedCheck;
import com.varial.framework.domain.country.vatcheck.VATQualifiedCheckRequest;
import com.varial.framework.domain.country.vatcheck.bzst.BzstVATQualifiedCheckService;
import com.varial.framework.domain.country.vatcheck.bzst.BzstVATRestQualifiedCheckService;
import com.varial.framework.domain.country.vatcheck.vies.ViesVATQualifiedCheckService;
import com.varial.interfaces.IAccountingCompany;

public class VATQualifiedCheckManager {
    private VATNumber requesterVAT;
    private IVATQualifiedCheckService checkService;

    private VATQualifiedCheckManager() {
    }

    public static VATQualifiedCheckManager getVATQualifiedCheckManager(ICompany company) throws BusinessDomainException {
        String companyVATRegistrationNumber = company.getECTaxNumber(true);
        if (StringUtil.isEmpty((String)companyVATRegistrationNumber)) {
            throw VATCheckExceptionMapper.makeEuVatNumberOfCompanyMissingDomainException();
        }
        VATNumber requesterVAT = new VATNumberFactory().create(companyVATRegistrationNumber);
        VATQualifiedCheckManager result = new VATQualifiedCheckManager();
        result.setRequesterVAT(requesterVAT);
        if (requesterVAT.isGermany()) {
            if (company.getNote().contains("deprecated_bzst-check")) {
                result.setCheckService(BzstVATQualifiedCheckService.getInstance());
            } else {
                result.setCheckService(BzstVATRestQualifiedCheckService.getInstance());
            }
        } else {
            result.setCheckService(ViesVATQualifiedCheckService.getInstance());
        }
        return result;
    }

    private IVATQualifiedCheckService getCheckService() {
        return this.checkService;
    }

    private void setCheckService(IVATQualifiedCheckService checkService) {
        this.checkService = checkService;
    }

    private void setRequesterVAT(VATNumber requesterVAT) {
        this.requesterVAT = requesterVAT;
    }

    private VATNumber getRequesterVAT() {
        return this.requesterVAT;
    }

    public VATQualifiedCheck checkVat(VATQualifiedCheckRequest request, IAccountingCompany company) {
        return this.getCheckService().checkVat(this.getRequesterVAT(), request, company);
    }
}

