/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.servantimpl.ecsaleslist;

import com.infor.igf.core.types.PersistableEnum;
import com.infor.igf.core.util.PersistableEnumUtils;
import com.varial.accounting.domain.ecsaleslist.ECSalesList;
import com.varial.accounting.domain.ecsaleslist.ECSalesListEntry;
import com.varial.accounting.domain.ecsaleslist.ECSalesListFactory;
import com.varial.accounting.domain.ecsaleslist.ECSalesListHelper;
import com.varial.accounting.domain.ecsaleslistcorrection.ECSalesListCorrection;
import com.varial.accounting.domain.ecsaleslistcorrection.ECSalesListCorrectionEntry;
import com.varial.accounting.domain.financialyear.AccountingCompany;
import com.varial.accounting.ecsaleslist.ECSalesListReportFrequencyEnum;
import com.varial.accounting.ecsaleslist.ECSalesListTaxTypeEnum;
import com.varial.accounting.servantimpl.ecsaleslist.ECSalesXMLCharacterConverter;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.types.date.DateHelper;
import com.varial.framework.basictypes.addresses.ElectronicAddress;
import com.varial.framework.basictypes.addresses.PostalAddress;
import com.varial.framework.domain.company.ICompanyTax;
import com.varial.framework.domain.company.JurisdictionType;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class ECSalesExportViaXML {
    protected static final String CLASSNAME = ECSalesExportViaXML.class.getName();
    private final ECSalesList mECSList;
    private ECSalesListCorrection mECSCorrList;
    private static JurisdictionType mJurisdictionType;
    private final ECSalesXMLCharacterConverter mConverter = new ECSalesXMLCharacterConverter();
    private final boolean mBerichtigung;
    private final AccountingCompany mCompany;
    private ECSalesListEntry[] mEntries;
    private ECSalesListCorrectionEntry[] mCorrectionEntries;
    private final boolean mNewRule012010;

    public ECSalesExportViaXML(ECSalesList ecl, JurisdictionType jurisdictionType) {
        this.mECSList = ecl;
        mJurisdictionType = jurisdictionType;
        this.mBerichtigung = false;
        this.mCompany = this.mECSList.getAccountingCompany();
        this.mEntries = this.mECSList.getReportedEntries();
        this.mNewRule012010 = this.mECSList.getCalendarYear() >= 2010;
    }

    public ECSalesExportViaXML(ECSalesListCorrection eclc, JurisdictionType jurisdictionType) throws BusinessDomainException {
        this.mECSCorrList = eclc;
        this.mECSList = this.mECSCorrList.getECSalesList();
        mJurisdictionType = jurisdictionType;
        this.mBerichtigung = true;
        this.mCompany = this.mECSCorrList.getCompany();
        this.mCorrectionEntries = eclc.getReportedCorrectionEntries();
        this.mNewRule012010 = this.mECSList.getCalendarYear() >= 2010;
    }

    public String createXML() throws BusinessDomainException {
        Format f = Format.getPrettyFormat();
        Element root = new Element("a");
        switch (mJurisdictionType) {
            case AT: {
                root = this.export_AT(root);
                f.setEncoding("UTF-8");
                break;
            }
            case BE: {
                root = this.export_BE(root);
                f.setEncoding("ISO-8859-1");
                break;
            }
            case DE: {
                root = this.export_DE(root);
                f.setEncoding("UTF-8");
                break;
            }
            case NL: {
                root = this.export_NL(root);
                f.setEncoding("UTF-8");
                break;
            }
        }
        XMLOutputter op = new XMLOutputter(f);
        String outputString = op.outputString(new Document(root));
        if (mJurisdictionType == JurisdictionType.BE) {
            String additionalNamespace = "xmlns=\"http://www.minfin.fgov.be/InputCommon\" ";
            int pos = outputString.indexOf("xmlns:ns2");
            outputString = outputString.substring(0, pos).concat("xmlns=\"http://www.minfin.fgov.be/InputCommon\" ").concat(outputString.substring(pos));
        }
        return outputString;
    }

    private Element export_BE(Element root) throws BusinessDomainException {
        int i;
        int i2;
        PostalAddress companyAddress = this.getPostalAdress();
        ElectronicAddress electronicAddress = this.mCompany.getElectronicAddress();
        String taxNumber = this.mCompany.getECTaxNumber(false);
        int rowCount = Integer.MIN_VALUE;
        BigDecimal total = BigDecimal.ZERO;
        if (!this.mBerichtigung) {
            rowCount = this.mEntries.length;
            for (i2 = 0; i2 < this.mEntries.length; ++i2) {
                total = total.add(this.mEntries[i2].getCalculatedResult());
            }
        } else {
            rowCount = this.mCorrectionEntries.length;
            for (i2 = 0; i2 < this.mCorrectionEntries.length; ++i2) {
                total = total.add(this.mCorrectionEntries[i2].getNewReportedAmount());
            }
        }
        Namespace namespace = Namespace.getNamespace((String)"ns2", (String)"http://www.minfin.fgov.be/IntraConsignment");
        root = new Element("IntraConsignment", namespace);
        root.setAttribute("IntraListingsNbr", "1");
        Element representative = new Element("Representative", namespace);
        Element elem = new Element("RepresentativeID");
        elem.setAttribute("identificationType", "NVAT");
        elem.setAttribute("issuedBy", companyAddress.getCountry().getIsoCode());
        elem.setText(taxNumber);
        representative.addContent((Content)elem);
        elem = new Element("Name");
        elem.setText(this.mConverter.convert(companyAddress.getName()));
        representative.addContent((Content)elem);
        elem = new Element("Street");
        elem.setText(this.mConverter.convert(companyAddress.getStreet()));
        representative.addContent((Content)elem);
        elem = new Element("PostCode");
        elem.setText(companyAddress.getPostalCode());
        representative.addContent((Content)elem);
        elem = new Element("City");
        elem.setText(this.mConverter.convert(companyAddress.getTown()));
        representative.addContent((Content)elem);
        elem = new Element("CountryCode");
        elem.setText(companyAddress.getCountry().getIsoCode());
        representative.addContent((Content)elem);
        elem = new Element("EmailAddress");
        if (!StringMapper.isNullString((String)electronicAddress.getEMail())) {
            elem.setText(electronicAddress.getEMail());
            representative.addContent((Content)elem);
        }
        elem = new Element("Phone");
        if (!StringMapper.isNullString((String)electronicAddress.getPhoneNumber())) {
            elem.setText(electronicAddress.getPhoneNumber());
            representative.addContent((Content)elem);
        }
        root.addContent((Content)representative);
        Element intraListing = new Element("IntraListing", namespace);
        intraListing.setAttribute("AmountSum", BigDecimalMapper.toString((BigDecimal)total.setScale(2)));
        intraListing.setAttribute("DeclarantReference", "");
        intraListing.setAttribute("ClientsNbr", Integer.toString(rowCount));
        intraListing.setAttribute("SequenceNumber", "1");
        Element declarer = new Element("Declarant", namespace);
        elem = new Element("VATNumber");
        elem.setText(taxNumber);
        declarer.addContent((Content)elem);
        elem = new Element("Name");
        elem.setText(this.mConverter.convert(companyAddress.getName()));
        declarer.addContent((Content)elem);
        elem = new Element("Street");
        elem.setText(this.mConverter.convert(companyAddress.getStreet()));
        declarer.addContent((Content)elem);
        elem = new Element("PostCode");
        elem.setText(companyAddress.getPostalCode());
        declarer.addContent((Content)elem);
        elem = new Element("City");
        elem.setText(this.mConverter.convert(companyAddress.getTown()));
        declarer.addContent((Content)elem);
        elem = new Element("CountryCode");
        elem.setText(companyAddress.getCountry().getIsoCode());
        declarer.addContent((Content)elem);
        elem = new Element("EmailAddress");
        if (!StringMapper.isNullString((String)electronicAddress.getEMail())) {
            elem.setText(electronicAddress.getEMail());
            declarer.addContent((Content)elem);
        }
        elem = new Element("Phone");
        if (!StringMapper.isNullString((String)electronicAddress.getPhoneNumber())) {
            elem.setText(electronicAddress.getPhoneNumber());
            declarer.addContent((Content)elem);
        }
        intraListing.addContent((Content)declarer);
        Element periode = new Element("Period", namespace);
        String s = "Quarter";
        int n = this.mECSList.getQuarter();
        if (this.mECSList.getReportFrequency().value() == 2) {
            s = "Month";
            n = this.mECSList.getMonth() + 1;
        }
        elem = new Element(s, namespace);
        elem.setText(StringMapper.fillUpWithStringLeft((String)String.valueOf(n), (int)2, (String)"0"));
        periode.addContent((Content)elem);
        elem = new Element("Year", namespace);
        elem.setText(Integer.toString(this.mECSList.getCalendarYear()));
        periode.addContent((Content)elem);
        intraListing.addContent((Content)periode);
        if (!this.mBerichtigung) {
            for (i = 0; i < this.mEntries.length; ++i) {
                intraListing.addContent((Content)this.createEntryBE(this.mEntries[i], namespace, i + 1));
            }
        } else {
            for (i = 0; i < this.mCorrectionEntries.length; ++i) {
                ECSalesListEntry orgentry = this.mCorrectionEntries[i].getOldECSalesListEntry();
                if (orgentry != null) {
                    intraListing.addContent((Content)this.createEntryBE(orgentry, namespace, i + 1));
                }
                intraListing.addContent((Content)this.createCorrEntryBE(this.mCorrectionEntries[i], namespace, i + 1));
            }
        }
        String note = "";
        if (!this.mBerichtigung) {
            if (!StringMapper.isNullString((String)this.mECSList.getNote())) {
                note = this.mECSList.getNote();
            }
        } else if (!StringMapper.isNullString((String)this.mECSCorrList.getNote())) {
            note = this.mECSCorrList.getNote();
        }
        if (!StringMapper.isNullString((String)note)) {
            elem = new Element("Comment", namespace);
            elem.setText(this.mConverter.convert(note));
            intraListing.addContent((Content)elem);
        }
        root.addContent((Content)intraListing);
        return root;
    }

    private Element export_AT(Element root) {
        root = new Element("ERKLAERUNGS_UEBERMITTLUNG");
        Element info_daten = new Element("INFO_DATEN");
        Element temp = new Element("ART_IDENTIFIKATIONSBEGRIFF");
        temp.setText("FASTNR");
        info_daten.addContent((Content)temp);
        temp = new Element("IDENTIFIKATIONSBEGRIFF");
        temp.setText(this.getFASTNR());
        info_daten.addContent((Content)temp);
        temp = new Element("PAKET_NR");
        temp.setText("1");
        info_daten.addContent((Content)temp);
        temp = new Element("DATUM_ERSTELLUNG");
        temp.setAttribute("type", "datum");
        temp.setText(DateMapper.toString((Date)DateHelper.today()));
        info_daten.addContent((Content)temp);
        temp = new Element("UHRZEIT_ERSTELLUNG");
        temp.setAttribute("type", "uhrzeit");
        Date currentTime = VDate.getCurrentLocalizedDateAndTime();
        temp.setText(new SimpleDateFormat("HH:mm:ss").format(currentTime));
        info_daten.addContent((Content)temp);
        temp = new Element("ANZAHL_ERKLAERUNGEN");
        temp.setText("1");
        info_daten.addContent((Content)temp);
        root.addContent((Content)info_daten);
        Element erklaerung = new Element("ERKLAERUNG");
        erklaerung.setAttribute("art", "U13");
        temp = new Element("SATZNR");
        temp.setText("1");
        erklaerung.addContent((Content)temp);
        Element allg = new Element("ALLGEMEINE_DATEN");
        temp = new Element("ANBRINGEN");
        temp.setText("U13");
        allg.addContent((Content)temp);
        temp = new Element("ZRVON");
        temp.setAttribute("type", "jahrmonat");
        temp.setText(this.getYear() + "-" + this.getStartMonth());
        allg.addContent((Content)temp);
        temp = new Element("ZRBIS");
        temp.setAttribute("type", "jahrmonat");
        temp.setText(this.getYear() + "-" + this.getEndMonth());
        allg.addContent((Content)temp);
        temp = new Element("FASTNR");
        temp.setText(this.getFASTNR());
        allg.addContent((Content)temp);
        temp = new Element("KUNDENINFO");
        temp.setText("ERZEUGT DURCH VARIAL");
        allg.addContent((Content)temp);
        erklaerung.addContent((Content)allg);
        if (!this.mBerichtigung) {
            for (int i = 0; i < this.mEntries.length; ++i) {
                erklaerung.addContent((Content)this.createEntryAT(this.mEntries[i]));
            }
        } else {
            for (int i = 0; i < this.mCorrectionEntries.length; ++i) {
                erklaerung.addContent((Content)this.createCorrEntryAT(this.mCorrectionEntries[i]));
            }
        }
        root.addContent((Content)erklaerung);
        return root;
    }

    private Element export_DE(Element root) throws BusinessDomainException {
        boolean withNewRule072010 = DateHelper.afterOrEqual((Date)this.mECSList.getPeriodDates().getValidFrom(), (Date)DateMapper.toDate((String)"2010-07-01"));
        boolean isMonthArrangement = false;
        boolean isAvoidance = false;
        if (withNewRule072010) {
            isMonthArrangement = ECSalesListHelper.isMonthArrangement((ECSalesList)this.mECSList);
            isAvoidance = ECSalesListHelper.isAvoidance((ECSalesList)this.mECSList);
        }
        Namespace zmnsp = Namespace.getNamespace((String)"http://www.lucom.com/ffw/xml-data-1.0.xsd");
        root = new Element("xml-data", zmnsp);
        Element temp = new Element("form", zmnsp);
        temp.setText("catalog://Unternehmen/ust/ZM_Formular_online");
        root.addContent((Content)temp);
        Element instanz = new Element("instance", zmnsp);
        Element datenzeile = new Element("datarow", zmnsp);
        temp = new Element("element", zmnsp);
        temp.setAttribute("id", "ID_USER");
        temp.setText(".anonymous");
        datenzeile.addContent((Content)temp);
        temp = new Element("element", zmnsp);
        temp.setAttribute("id", "knri2");
        temp.setText(this.mCompany.getECTaxNumber(false));
        datenzeile.addContent((Content)temp);
        temp = new Element("element", zmnsp);
        temp.setAttribute("id", "jahr");
        temp.setText(this.getYear());
        datenzeile.addContent((Content)temp);
        temp = new Element("element", zmnsp);
        temp.setAttribute("id", "berichtigung");
        temp.setText(Boolean.toString(this.mBerichtigung));
        datenzeile.addContent((Content)temp);
        if (withNewRule072010) {
            temp = new Element("element", zmnsp);
            temp.setAttribute("id", "anzeige");
            temp.setText(Boolean.toString(isMonthArrangement));
            datenzeile.addContent((Content)temp);
            temp = new Element("element", zmnsp);
            temp.setAttribute("id", "widerruf");
            temp.setText(Boolean.toString(isAvoidance));
            datenzeile.addContent((Content)temp);
        }
        temp = new Element("element", zmnsp);
        temp.setAttribute("id", "Uname");
        temp.setText(this.mConverter.convert(this.getPostalAdress().getName()));
        datenzeile.addContent((Content)temp);
        temp = new Element("element", zmnsp);
        temp.setAttribute("id", "Ustrasse");
        temp.setText(this.mConverter.convert(this.getPostalAdress().getStreet()));
        datenzeile.addContent((Content)temp);
        temp = new Element("element", zmnsp);
        temp.setAttribute("id", "Uplz");
        temp.setText(this.mConverter.convert(this.getPostalAdress().getPostalCode()));
        datenzeile.addContent((Content)temp);
        temp = new Element("element", zmnsp);
        temp.setAttribute("id", "Uort");
        temp.setText(this.mConverter.convert(this.getPostalAdress().getTown()));
        datenzeile.addContent((Content)temp);
        temp = new Element("element", zmnsp);
        temp.setAttribute("id", "knri1");
        temp.setText("DE");
        datenzeile.addContent((Content)temp);
        if (this.getElectronicAdress() != null) {
            if (this.getElectronicAdress().getPhoneNumber() != null) {
                temp = new Element("element", zmnsp);
                temp.setAttribute("id", "Utelefon");
                temp.setText(this.getElectronicAdress().getPhoneNumber());
                datenzeile.addContent((Content)temp);
            }
            if (this.getElectronicAdress().getEMail() != null) {
                temp = new Element("element", zmnsp);
                temp.setAttribute("id", "Uemail");
                temp.setText(this.getElectronicAdress().getEMail());
                datenzeile.addContent((Content)temp);
            }
        }
        temp = new Element("element", zmnsp);
        temp.setAttribute("id", "quartal");
        temp.setText(this.mConverter.convert(this.getQuartal(this.mECSList)));
        datenzeile.addContent((Content)temp);
        temp = new Element("element", zmnsp);
        temp.setAttribute("id", "quart");
        temp.setText(this.getQuart(this.mECSList));
        datenzeile.addContent((Content)temp);
        if (this.getTeilnehmerNr() != null) {
            temp = new Element("element", zmnsp);
            temp.setAttribute("id", "zlnr");
            temp.setText(this.getTeilnehmerNr());
            datenzeile.addContent((Content)temp);
        }
        instanz.addContent((Content)datenzeile);
        Element einzelzeilen = new Element("dataset", zmnsp);
        einzelzeilen.setAttribute("id", "tbl_ZM_tabelle");
        if (!this.mBerichtigung) {
            for (int i = 0; i < this.mEntries.length; ++i) {
                if (BigDecimalMapper.isZeroOrNull((BigDecimal)this.mEntries[i].getCalculatedResult())) continue;
                einzelzeilen.addContent((Content)this.createEntryDE(this.mEntries[i], zmnsp, i + 1));
            }
        } else {
            for (int i = 0; i < this.mCorrectionEntries.length; ++i) {
                ECSalesListEntry orgentry = this.mCorrectionEntries[i].getOldECSalesListEntry();
                if (orgentry != null) {
                    einzelzeilen.addContent((Content)this.createEntryDE(orgentry, zmnsp, i + 1));
                }
                einzelzeilen.addContent((Content)this.createCorrEntryDE(this.mCorrectionEntries[i], zmnsp, i + 1));
            }
        }
        instanz.addContent((Content)einzelzeilen);
        root.addContent((Content)instanz);
        return root;
    }

    private String getStartMonth() {
        Date start = this.mECSList.getPeriodDates().getValidFrom();
        int month = new VDate(start).getMonth() + 1;
        StringBuilder res = new StringBuilder();
        if (month < 10) {
            res.append('0');
        }
        res.append(month);
        return res.toString();
    }

    private String getEndMonth() {
        Date end = this.mECSList.getPeriodDates().getValidUntil();
        int month = new VDate(end).getMonth() + 1;
        StringBuilder res = new StringBuilder();
        if (month < 10) {
            res.append('0');
        }
        res.append(month);
        return res.toString();
    }

    private String getFASTNR() {
        if (!StringMapper.isNullString((String)this.getEcTaxOfficeNumber())) {
            StringBuilder res = new StringBuilder();
            res.append(StringMapper.toString((String)this.getEcTaxOfficeNumber()));
            String taxno = StringMapper.toString((String)this.mCompany.getUKTax().getTaxNumber());
            if (taxno.charAt(0) == 'U') {
                res.append(taxno.substring(2, taxno.length()));
            } else {
                res.append(taxno);
            }
            return res.toString();
        }
        return "";
    }

    private String getEcTaxOfficeNumber() {
        ICompanyTax ecTax = ECSalesListHelper.getEcCompanyTax((ECSalesList)this.mECSList);
        return ecTax != null ? ecTax.getTaxOfficeNumber() : null;
    }

    private String getTeilnehmerNr() {
        String res = "";
        if (this.mCompany.getParticipantNumber() != null) {
            res = this.mCompany.getParticipantNumber();
        }
        return res;
    }

    private String getYear() {
        return Integer.toString(this.mECSList.getCalendarYear());
    }

    private PostalAddress getPostalAdress() throws BusinessDomainException {
        PostalAddress pa = this.mCompany.getAddress(DateHelper.today()).getPostalAddress();
        return pa;
    }

    private ElectronicAddress getElectronicAdress() {
        ElectronicAddress electra = this.mCompany.getElectronicAddress();
        return electra;
    }

    private Element createEntryAT(ECSalesListEntry entry) {
        String uid_ms = StringMapper.toString((String)entry.getEcCountryCode()) + StringMapper.toString((String)entry.getVatNumber());
        String betrag = ECSalesListHelper.formatAmount((JurisdictionType)JurisdictionType.AT, (BigDecimal)entry.getCalculatedResult(), (boolean)this.mECSList.getRoundAmounts()).toString();
        String dreieck = "";
        String leistung = "";
        if (entry.getTaxType().value() == 1) {
            dreieck = "J";
        } else if (entry.getTaxType().value() == 3) {
            leistung = "J";
        }
        Element result = new Element("ZM");
        result = this.createEntryXmlAT(result, uid_ms, betrag, dreieck, leistung);
        return result;
    }

    private Element createCorrEntryAT(ECSalesListCorrectionEntry entry) {
        String uid_ms = StringMapper.toString((String)entry.getNewECCountryCode()) + StringMapper.toString((String)entry.getNewEUTaxNumber());
        String betrag = ECSalesListHelper.formatAmount((JurisdictionType)JurisdictionType.AT, (BigDecimal)entry.getNewReportedAmount(), (boolean)this.mECSList.getRoundAmounts()).toString();
        String dreieck = "";
        String leistung = "";
        if (entry.getNewTaxType().value() == 1) {
            dreieck = "J";
        } else if (entry.getNewTaxType().value() == 3) {
            leistung = "J";
        }
        Element result = new Element("ZM");
        result = this.createEntryXmlAT(result, uid_ms, betrag, dreieck, leistung);
        return result;
    }

    private Element createEntryXmlAT(Element result, String uid, String betrag, String dreieck, String leistung) {
        Element temp = new Element("UID_MS");
        temp.setText(uid);
        result.addContent((Content)temp);
        temp = new Element("SUM_BGL");
        temp.setAttribute("type", "kz");
        temp.setText(betrag);
        result.addContent((Content)temp);
        if ("J".equals(dreieck)) {
            temp = new Element("DREIECK");
            temp.setText(dreieck);
            result.addContent((Content)temp);
        }
        if ("J".equals(leistung)) {
            temp = new Element("SOLEI");
            temp.setText(leistung);
            result.addContent((Content)temp);
        }
        return result;
    }

    private Element createEntryDE(ECSalesListEntry entry, Namespace zmnsp, int entryNumber) {
        String dreieck = "false";
        String umsatzArt = "0";
        if (entry.getTaxType().value() == 1) {
            dreieck = "true";
        }
        umsatzArt = ECSalesListFactory.getCodeForTaxType((int)entry.getTaxType().value(), (int)PersistableEnumUtils.toPersistentValue((PersistableEnum)mJurisdictionType), (int)this.mECSList.getCalendarYear(), (boolean)true);
        String betrag = ECSalesListHelper.formatAmount((JurisdictionType)JurisdictionType.DE, (BigDecimal)entry.getCalculatedResult(), (boolean)this.mECSList.getRoundAmounts()).toString();
        if (this.mBerichtigung) {
            betrag = "0";
        }
        Element result = new Element("datarow", zmnsp);
        result = this.createEntryXmlDE(result, entry.getEcCountryCode(), entry.getVatNumber(), dreieck, umsatzArt, betrag, zmnsp, entryNumber);
        return result;
    }

    private Element createCorrEntryDE(ECSalesListCorrectionEntry entry, Namespace zmnsp, int entryNumber) {
        String dreieck = "false";
        String umsatzArt = "0";
        if (entry.getNewTaxType().value() == 1) {
            dreieck = "true";
        }
        umsatzArt = ECSalesListFactory.getCodeForTaxType((int)entry.getNewTaxType().value(), (int)PersistableEnumUtils.toPersistentValue((PersistableEnum)mJurisdictionType), (int)this.mECSList.getCalendarYear(), (boolean)true);
        String betrag = ECSalesListHelper.formatAmount((JurisdictionType)JurisdictionType.DE, (BigDecimal)entry.getNewReportedAmount(), (boolean)this.mECSList.getRoundAmounts()).toString();
        Element result = new Element("datarow", zmnsp);
        result = this.createEntryXmlDE(result, entry.getNewECCountryCode(), entry.getNewEUTaxNumber(), dreieck, umsatzArt, betrag, zmnsp, entryNumber);
        return result;
    }

    private Element createEntryXmlDE(Element result, String land, String uid, String dreieck, String umsatzArt, String betrag, Namespace zmnsp, int entryNumber) {
        Element temp = new Element("element", zmnsp);
        temp.setAttribute("id", "knre1");
        temp.setText(land);
        result.addContent((Content)temp);
        temp = new Element("element", zmnsp);
        temp.setAttribute("id", "knre2");
        temp.setText(uid);
        result.addContent((Content)temp);
        if (this.mNewRule012010) {
            temp = new Element("element", zmnsp);
            temp.setAttribute("id", "zeile_m");
            temp.setText(String.valueOf(entryNumber));
            result.addContent((Content)temp);
            temp = new Element("element", zmnsp);
            temp.setAttribute("id", "umsatz_art");
            temp.setText(umsatzArt);
            result.addContent((Content)temp);
        } else {
            temp = new Element("element", zmnsp);
            temp.setAttribute("id", "dreieck");
            temp.setText(dreieck);
            result.addContent((Content)temp);
        }
        temp = new Element("element", zmnsp);
        temp.setAttribute("id", "betrag");
        temp.setText(betrag);
        result.addContent((Content)temp);
        return result;
    }

    private Element createEntryBE(ECSalesListEntry entry, Namespace namespace, int count) {
        Element result = new Element("IntraClient", namespace);
        result.setAttribute("SequenceNumber", String.valueOf(count));
        Element elem = new Element("CompanyVATNumber", namespace);
        elem.setAttribute("issuedBy", entry.getEcCountryCode());
        elem.setText(entry.getVatNumber());
        result.addContent((Content)elem);
        elem = new Element("Code", namespace);
        elem.setText(ECSalesListFactory.getCodeForTaxType((int)entry.getTaxType().value(), (int)PersistableEnumUtils.toPersistentValue((PersistableEnum)mJurisdictionType), (int)this.mECSList.getCalendarYear(), (boolean)true));
        result.addContent((Content)elem);
        elem = new Element("Amount", namespace);
        elem.setText(BigDecimalMapper.toString((BigDecimal)ECSalesListHelper.formatAmount((JurisdictionType)JurisdictionType.BE, (BigDecimal)entry.getCalculatedResult(), (boolean)this.mECSList.getRoundAmounts())));
        result.addContent((Content)elem);
        return result;
    }

    private Element createCorrEntryBE(ECSalesListCorrectionEntry entry, Namespace namespace, int count) throws BusinessDomainException {
        Element result = new Element("IntraClient", namespace);
        result.setAttribute("SequenceNumber", String.valueOf(count));
        Element elem = new Element("CompanyVATNumber", namespace);
        elem.setAttribute("issuedBy", entry.getNewECCountryCode());
        elem.setText(entry.getNewEUTaxNumber());
        result.addContent((Content)elem);
        elem = new Element("Code", namespace);
        elem.setText(ECSalesListFactory.getCodeForTaxType((int)entry.getNewTaxType().value(), (int)PersistableEnumUtils.toPersistentValue((PersistableEnum)mJurisdictionType), (int)this.mECSList.getCalendarYear(), (boolean)true));
        result.addContent((Content)elem);
        elem = new Element("Amount", namespace);
        elem.setText(BigDecimalMapper.toString((BigDecimal)ECSalesListHelper.formatAmount((JurisdictionType)JurisdictionType.BE, (BigDecimal)entry.getNewReportedAmount(), (boolean)this.mECSList.getRoundAmounts())));
        result.addContent((Content)elem);
        Element correctionPeriod = new Element("CorrectingPeriod", namespace);
        String s = "Quarter";
        int n = this.mECSList.getQuarter();
        if (this.mECSList.getReportFrequency().value() == 2) {
            s = "Month";
            n = this.mECSList.getMonth() + 1;
        }
        elem = new Element(s, namespace);
        elem.setText(StringMapper.fillUpWithStringLeft((String)String.valueOf(n), (int)2, (String)"0"));
        correctionPeriod.addContent((Content)elem);
        elem = new Element("Year", namespace);
        elem.setText(Integer.toString(this.mECSList.getCalendarYear()));
        correctionPeriod.addContent((Content)elem);
        result.addContent((Content)correctionPeriod);
        return result;
    }

    private String getQuartal(ECSalesList report) {
        String result = "";
        if (report.getReportFrequency().equals(ECSalesListReportFrequencyEnum.ESLRF_MONTH)) {
            switch (report.getMonth()) {
                case 0: {
                    result = "Januar";
                    break;
                }
                case 1: {
                    result = "Februar";
                    break;
                }
                case 2: {
                    result = "M\u00e4rz";
                    break;
                }
                case 3: {
                    result = "April";
                    break;
                }
                case 4: {
                    result = "Mai";
                    break;
                }
                case 5: {
                    result = "Juni";
                    break;
                }
                case 6: {
                    result = "Juli";
                    break;
                }
                case 7: {
                    result = "August";
                    break;
                }
                case 8: {
                    result = "September";
                    break;
                }
                case 9: {
                    result = "Oktober";
                    break;
                }
                case 10: {
                    result = "November";
                    break;
                }
                case 11: {
                    result = "Dezember";
                    break;
                }
            }
        } else if (report.getReportFrequency().equals(ECSalesListReportFrequencyEnum.ESLRF_QUARTER)) {
            switch (report.getQuarter()) {
                case 1: {
                    result = "1. Quartal";
                    break;
                }
                case 2: {
                    result = "2. Quartal";
                    break;
                }
                case 3: {
                    result = "3. Quartal";
                    break;
                }
                case 4: {
                    result = "4. Quartal";
                    break;
                }
            }
        } else if (report.getReportFrequency().equals(ECSalesListReportFrequencyEnum.ESLRF_YEAR)) {
            result = "Kalenderjahr";
        }
        return result;
    }

    private String getQuart(ECSalesList report) {
        String result = "";
        if (report.getReportFrequency().equals(ECSalesListReportFrequencyEnum.ESLRF_MONTH)) {
            result = StringMapper.fillUpWithZero((String)String.valueOf(report.getMonth() + 1), (int)2);
        } else if (report.getReportFrequency().equals(ECSalesListReportFrequencyEnum.ESLRF_QUARTER)) {
            result = String.valueOf(report.getQuarter());
        }
        return result;
    }

    private Element export_NL(Element root) throws BusinessDomainException {
        Namespace zmnsp = Namespace.getNamespace((String)"http://xml.belastingdienst.nl/schemas/ICP/2010/01");
        root = new Element("OpgaafICP", zmnsp);
        root.setAttribute("version", "2.0");
        Element identification = new Element("IdentificerendeGegevens", zmnsp);
        Element elem = new Element("BTWIdentificatienummerOB", zmnsp);
        elem.setText(this.mCompany.getECTaxNumber(false));
        identification.addContent((Content)elem);
        elem = new Element("MessageID", zmnsp);
        elem.setText(this.mECSList.getPeriodAsString());
        identification.addContent((Content)elem);
        elem = new Element("LevCode", zmnsp);
        elem.setText("BDRP");
        identification.addContent((Content)elem);
        try {
            elem = new Element("TijdstipAanmaak", zmnsp);
            DatatypeFactory factory = DatatypeFactory.newInstance();
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(DateHelper.today());
            XMLGregorianCalendar xmlGregorianCalendar = factory.newXMLGregorianCalendar(cal);
            elem.setText(xmlGregorianCalendar.toXMLFormat());
            identification.addContent((Content)elem);
        }
        catch (DatatypeConfigurationException e) {
            ExceptionMapper.printException((Throwable)e);
        }
        elem = new Element("Mediumsoort", zmnsp);
        elem.setText("BAPI");
        identification.addContent((Content)elem);
        elem = new Element("Opgaaftijdvak", zmnsp);
        elem.setText(this.getPeriodStringNL(this.mECSList));
        identification.addContent((Content)elem);
        elem = new Element("Valutacode", zmnsp);
        elem.setText(this.mECSList.getFinanceSetup().getBaseCurrency().getSwift());
        identification.addContent((Content)elem);
        root.addContent((Content)identification);
        Element communication = new Element("Communicatiegegevens", zmnsp);
        elem = new Element("Beconnr", zmnsp);
        elem.setText(this.getTeilnehmerNr());
        communication.addContent((Content)elem);
        elem = new Element("Naam", zmnsp);
        elem.setText(StringMapper.maxLength((String)this.getPostalAdress().getName(), (int)35));
        communication.addContent((Content)elem);
        elem = new Element("Adres", zmnsp);
        elem.setText(StringMapper.maxLength((String)this.getPostalAdress().getStreet(), (int)41));
        communication.addContent((Content)elem);
        elem = new Element("Postcode", zmnsp);
        elem.setText(StringMapper.maxLength((String)this.getPostalAdress().getPostalCode(), (int)6));
        communication.addContent((Content)elem);
        elem = new Element("Woonplaats", zmnsp);
        elem.setText(StringMapper.maxLength((String)this.getPostalAdress().getTown(), (int)24));
        communication.addContent((Content)elem);
        if (this.mCompany.getElectronicAddress() != null && !StringMapper.isNullString((String)this.mCompany.getElectronicAddress().getPhoneNumber())) {
            elem = new Element("Telefoon", zmnsp);
            elem.setText(StringMapper.maxLength((String)this.mCompany.getElectronicAddress().getPhoneNumber(), (int)25));
            communication.addContent((Content)elem);
        }
        root.addContent((Content)communication);
        Element fiscal = new Element("FiscaleEenheid", zmnsp);
        elem = new Element("BTWIdentificatieNummerICT", zmnsp);
        elem.setText(this.mCompany.getECTaxNumber(false));
        fiscal.addContent((Content)elem);
        root.addContent((Content)fiscal);
        if (!this.mBerichtigung) {
            for (int i = 0; i < this.mEntries.length; ++i) {
                root.addContent((Content)this.createEntryNL(this.mEntries[i], zmnsp, false));
            }
        } else {
            for (int i = 0; i < this.mCorrectionEntries.length; ++i) {
                ECSalesListEntry orgentry = this.mCorrectionEntries[i].getOldECSalesListEntry();
                if (orgentry != null) {
                    root.addContent((Content)this.createEntryNL(orgentry, zmnsp, true));
                }
                root.addContent((Content)this.createEntryNL(this.mCorrectionEntries[i], zmnsp, false));
            }
        }
        return root;
    }

    private Element createEntryNL(ECSalesListCorrectionEntry entry, Namespace zmnsp, boolean isCorrection) {
        return this.createEntryXmlNL(entry.getNewTaxType(), entry.getNewEUTaxNumber(), entry.getNewECCountryCode(), entry.getNewReportedAmount(), zmnsp, isCorrection);
    }

    private Element createEntryNL(ECSalesListEntry entry, Namespace zmnsp, boolean isCorrection) {
        return this.createEntryXmlNL(entry.getTaxType(), entry.getVatNumber(), entry.getEcCountryCode(), entry.getCalculatedResult(), zmnsp, isCorrection);
    }

    private Element createEntryXmlNL(ECSalesListTaxTypeEnum taxType, String taxNumber, String countryCode, BigDecimal amount, Namespace zmnsp, boolean isCorrection) {
        String title = "";
        String type = "";
        switch (taxType.value()) {
            case 0: {
                if (isCorrection) {
                    title = "CorrectiesLeveringenDiensten";
                    type = "CorrectieLeveringen";
                    break;
                }
                title = "IntracommunautaireLeveringenDiensten";
                type = "Levering";
                break;
            }
            case 3: {
                if (isCorrection) {
                    title = "CorrectiesLeveringenDiensten";
                    type = "CorrectieDiensten";
                    break;
                }
                title = "IntracommunautaireLeveringenDiensten";
                type = "Diensten";
                break;
            }
            case 1: {
                if (isCorrection) {
                    title = "CorrectiesABCLeveringen";
                    type = "Correctie";
                    break;
                }
                title = "IntracommunautaireABCLeveringen";
                type = "Levering";
                break;
            }
        }
        Element result = new Element(title, zmnsp);
        Element typeElement = new Element(type, zmnsp);
        Element elem = new Element("Tijdvak", zmnsp);
        elem.setText(this.getPeriodStringNL(this.mECSList));
        if (isCorrection) {
            typeElement.addContent((Content)elem);
        }
        elem = new Element("Landcode", zmnsp);
        elem.setText(countryCode);
        typeElement.addContent((Content)elem);
        elem = new Element("Nummer", zmnsp);
        elem.setText(taxNumber);
        typeElement.addContent((Content)elem);
        elem = new Element("Bedrag", zmnsp);
        elem.setText(amount.setScale(0, RoundingMode.HALF_DOWN).toString());
        typeElement.addContent((Content)elem);
        result.addContent((Content)typeElement);
        return result;
    }

    private String getPeriodStringNL(ECSalesList report) {
        String result = String.valueOf(report.getCalendarYear()).substring(2);
        if (report.getReportFrequency().equals(ECSalesListReportFrequencyEnum.ESLRF_MONTH)) {
            switch (report.getMonth()) {
                case 0: {
                    result = result.concat("101");
                    break;
                }
                case 1: {
                    result = result.concat("102");
                    break;
                }
                case 2: {
                    result = result.concat("103");
                    break;
                }
                case 3: {
                    result = result.concat("204");
                    break;
                }
                case 4: {
                    result = result.concat("205");
                    break;
                }
                case 5: {
                    result = result.concat("206");
                    break;
                }
                case 6: {
                    result = result.concat("307");
                    break;
                }
                case 7: {
                    result = result.concat("308");
                    break;
                }
                case 8: {
                    result = result.concat("309");
                    break;
                }
                case 9: {
                    result = result.concat("410");
                    break;
                }
                case 10: {
                    result = result.concat("411");
                    break;
                }
                case 11: {
                    result = result.concat("412");
                    break;
                }
            }
        } else if (report.getReportFrequency().equals(ECSalesListReportFrequencyEnum.ESLRF_QUARTER)) {
            switch (report.getQuarter()) {
                case 1: {
                    result = result.concat("100");
                    break;
                }
                case 2: {
                    result = result.concat("200");
                    break;
                }
                case 3: {
                    result = result.concat("300");
                    break;
                }
                case 4: {
                    result = result.concat("400");
                    break;
                }
            }
        } else if (report.getReportFrequency().equals(ECSalesListReportFrequencyEnum.ESLRF_YEAR)) {
            result = result.concat("040");
        }
        return result;
    }
}

