/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.ritenutareport;

import com.varial.accounting.domain.nominaltransactionbase.NominalLedgerEntry;
import com.varial.accounting.domain.nominaltransactionbase.NominalLedgerEntryPersistencyManager;
import com.varial.accounting.domain.ritenutareport.RitenutaActTaxation;
import com.varial.accounting.domain.ritenutareport.RitenutaReport;
import com.varial.accounting.persistency.acttaxation.ActtaxationContainer;
import com.varial.accounting.persistency.acttaxation.IActtaxationDao;
import com.varial.accounting.persistency.ritenutaacttax.IRitenutaacttaxDao;
import com.varial.accounting.persistency.ritenutaacttax.RitenutaacttaxContainer;
import com.varial.accounting.ritenutareport.RitenutaReportJournalEntryStruct;
import com.varial.base.UtilitiesManager;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.session.SessionContext;
import com.varial.framework.basictypes.AmountMapper;
import com.varial.framework.basictypes.OptAmountMapper;
import com.varial.framework.basictypes.optAmount;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.ExceptionMapper;
import java.math.BigDecimal;
import java.util.ArrayList;

public class RitenutaActTaxationPersistencyManager {
    private static final IRitenutaacttaxDao dao = (IRitenutaacttaxDao)UtilitiesManager.getBean((String)"ritenutaacttaxDao", IRitenutaacttaxDao.class);
    private static final IActtaxationDao daoActTaxation = (IActtaxationDao)UtilitiesManager.getBean((String)"acttaxationDao", IActtaxationDao.class);
    private static final String OID_ACTTAXATION_PROPERTY_NAME = "OIDACTTAXATION";

    private static boolean hasRow(String oidActTaxation) {
        return dao.getRowCount(Restrictions.eq((String)OID_ACTTAXATION_PROPERTY_NAME, (String)oidActTaxation)) != 0L;
    }

    public static void setRelationEntriesFromActTaxationContainer(RitenutaActTaxation[] transactionContainers) {
        RitenutaacttaxContainer[] containers = RitenutaActTaxationPersistencyManager.makeContainers(transactionContainers);
        RitenutaActTaxationPersistencyManager.setRelationEntries(containers);
    }

    public static void setRelationEntriesFromStruct(RitenutaReportJournalEntryStruct[] journals) {
        RitenutaacttaxContainer[] containers = RitenutaActTaxationPersistencyManager.makeContainers(journals);
        RitenutaActTaxationPersistencyManager.setRelationEntries(containers);
    }

    private static void setRelationEntries(RitenutaacttaxContainer[] containers) {
        try {
            for (int i = 0; i < containers.length; ++i) {
                if (RitenutaActTaxationPersistencyManager.hasRow(containers[i].oidacttaxation)) {
                    dao.updateAttributes(containers[i], new String[]{"NEWTAXAMOUNT", "NEWTOTALAMOUNT", "NEWNETAMOUNT", "NEWTAXDATE", "NEWNOTFORRITENUTA"}, Restrictions.eq((String)OID_ACTTAXATION_PROPERTY_NAME, (String)containers[i].oidacttaxation));
                } else {
                    dao.insert(SessionContext.getInstance().getSession().getUserCode(), containers[i]);
                }
                if (i <= 0 || i % 100 != 0) continue;
                SessionContext.getInstance().getPersistencySession().flush();
            }
            SessionContext.getInstance().getPersistencySession().flush();
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    private static RitenutaacttaxContainer[] makeContainers(RitenutaActTaxation[] transactionContainers) {
        RitenutaacttaxContainer[] result = new RitenutaacttaxContainer[transactionContainers.length];
        for (int i = 0; i < transactionContainers.length; ++i) {
            result[i] = RitenutaActTaxationPersistencyManager.fillContainer(transactionContainers[i]);
        }
        return result;
    }

    private static RitenutaacttaxContainer fillContainer(RitenutaActTaxation container) {
        RitenutaacttaxContainer result = new RitenutaacttaxContainer();
        result.oidacttaxation = container.getOidActTaxation();
        result.newtaxdate = container.getTaxDate();
        result.newnetamount = container.getReportedAmounts().getNetAmount();
        result.newtaxamount = container.getReportedAmounts().getRitenutaAmount();
        result.newtotalamount = container.getReportedAmounts().getInvoiceAmount();
        result.newnotforritenuta = container.getReportedAmounts().getNotForRitenutaAmount();
        return result;
    }

    private static RitenutaacttaxContainer[] makeContainers(RitenutaReportJournalEntryStruct[] journals) {
        RitenutaacttaxContainer[] result = new RitenutaacttaxContainer[journals.length];
        for (int i = 0; i < journals.length; ++i) {
            result[i] = RitenutaActTaxationPersistencyManager.fillContainer(journals[i]);
        }
        return result;
    }

    private static RitenutaacttaxContainer fillContainer(RitenutaReportJournalEntryStruct struct) {
        RitenutaacttaxContainer result = new RitenutaacttaxContainer();
        result.oidacttaxation = struct.oidActTaxation;
        boolean isDebit = RitenutaActTaxationPersistencyManager.isDebit(struct.oidActTaxation);
        result.newnetamount = RitenutaActTaxationPersistencyManager.removeSign(AmountMapper.fromIdl((String)struct.reportedNetAmount), isDebit);
        result.newtaxamount = RitenutaActTaxationPersistencyManager.removeSign(AmountMapper.fromIdl((String)struct.reportedTaxAmount), isDebit);
        result.newtotalamount = RitenutaActTaxationPersistencyManager.removeSign(AmountMapper.fromIdl((String)struct.reportedGrossAmount), isDebit);
        result.newtaxdate = DateMapper.toDate((String)struct.reportedTransactionDate);
        result.newnotforritenuta = RitenutaActTaxationPersistencyManager.removeSign(OptAmountMapper.fromIdl((optAmount)struct.reportedNotForRitenutaAmount), isDebit);
        return result;
    }

    private static BigDecimal removeSign(BigDecimal signedAmount, boolean isDebit) {
        if (signedAmount == null) {
            return null;
        }
        return isDebit ? signedAmount.negate() : signedAmount;
    }

    private static boolean isDebit(String oidActTaxation) {
        ActtaxationContainer container = daoActTaxation.getRowByObjectID(oidActTaxation);
        NominalLedgerEntry entry = NominalLedgerEntryPersistencyManager.getNominalLedgerEntry((String)container.oidtaxentry);
        return entry.getIsDebit();
    }

    public static void deleteEntries(RitenutaReport ritenutaReport) {
        ActtaxationContainer[] actTaxationContainers = daoActTaxation.getRows(null, Restrictions.eq((String)"oidritenutareport", (String)ritenutaReport.getObjectid()));
        ArrayList<String> oidActTaxationList = new ArrayList<String>();
        for (ActtaxationContainer acttaxationContainer : actTaxationContainers) {
            oidActTaxationList.add(acttaxationContainer.getObjectid());
        }
        if (!oidActTaxationList.isEmpty()) {
            dao.delete(SessionContext.getInstance().getSession().getUserCode(), Restrictions.in((String)OID_ACTTAXATION_PROPERTY_NAME, oidActTaxationList));
        }
    }
}

