/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.payment.reversefactoring;

import com.varial.accounting.domain.payment.GeneratePayment;
import com.varial.accounting.domain.payment.GeneratePaymentRemittance;
import com.varial.accounting.domain.payment.ReverseFactoringHelper;
import com.varial.accounting.domain.payment.reversefactoring.format.ReverseFactoringFormatter;
import com.varial.base.exception.BusinessDomainException;
import com.varial.interfaces.ICurrency;
import com.varial.serverbase.domain.textoutput.FieldSeparatorType;
import com.varial.serverbase.domain.textoutput.LineGenerator;
import com.varial.serverbase.domain.textoutput.OutputField;
import com.varial.serverbase.domain.textoutput.OutputLine;
import com.varial.serverbase.domain.textoutput.OutputLineUtils;
import com.varial.serverbase.domain.textoutput.TextField;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public abstract class ReverseFactoringLineGeneratorImpl
implements LineGenerator {
    protected final GeneratePayment payment;
    private final ReverseFactoringFormatter formatter;
    private final FieldSeparatorType separatorType;

    protected ReverseFactoringLineGeneratorImpl(GeneratePayment payment, FieldSeparatorType separatorType, ReverseFactoringFormatter formatter) {
        this.payment = payment;
        this.separatorType = separatorType;
        this.formatter = formatter;
    }

    public OutputLine getHeadline() {
        return new OutputLine(OutputLineUtils.separate(this.createHeaderLineFields(), (OutputField)this.separatorType.toOutputField()));
    }

    public OutputLine[] getDataLines() {
        return (OutputLine[])Arrays.stream(this.payment.getGeneratePaymentRemittances()).map(this::createExportLine).toArray(OutputLine[]::new);
    }

    private OutputLine createExportLine(GeneratePaymentRemittance remittance) {
        return new OutputLine(OutputLineUtils.separate(this.createOpenItemExportFields(remittance), (OutputField)this.separatorType.toOutputField()));
    }

    protected abstract List<OutputField> createHeaderLineFields();

    protected abstract List<OutputField> createOpenItemExportFields(GeneratePaymentRemittance var1);

    protected OutputField createDateField(Date date) {
        return new TextField(this.formatter.formatDate(date));
    }

    protected OutputField createLimitedTextField(String value, int maxLength) {
        return new TextField(this.formatter.formatLimitedText(value, maxLength, this.separatorType.getCharacter()));
    }

    protected OutputField createTextField(String value) {
        return new TextField(this.formatter.formatText(value, this.separatorType.getCharacter()));
    }

    protected OutputField createFixedTextField(String value) {
        return new TextField(value);
    }

    protected OutputField createAmountField(BigDecimal amount, ICurrency currency) {
        return new TextField(this.formatter.formatAmount(amount, currency));
    }

    protected Date getDueDate(GeneratePaymentRemittance remittance) {
        Date dueDate;
        try {
            dueDate = ReverseFactoringHelper.getDueDate((GeneratePaymentRemittance)remittance);
        }
        catch (BusinessDomainException de) {
            dueDate = null;
        }
        return dueDate;
    }
}

