/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.payment.reversefactoring;

import com.varial.accounting.domain.payment.FinancePaymentSession;
import com.varial.accounting.domain.payment.GeneratePayment;
import com.varial.accounting.domain.payment.GeneratePaymentSession;
import com.varial.accounting.domain.payment.export.FinancePaymentExporter;
import com.varial.accounting.domain.payment.reversefactoring.ReverseFactoringFileNameContext;
import com.varial.base.exception.BusinessDomainException;
import com.varial.framework.basictypes.FileExportStruct;
import com.varial.serverbase.domain.textoutput.LineGenerator;
import com.varial.serverbase.domain.textoutput.LineSeparator;
import com.varial.serverbase.domain.textoutput.OutputStringWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;

public abstract class ReverseFactoringExporter
extends FinancePaymentExporter {
    protected ReverseFactoringExporter(GeneratePaymentSession paymentSession) {
        super((FinancePaymentSession)paymentSession);
    }

    public FileExportStruct[] getFileExport() throws BusinessDomainException {
        GeneratePayment[] generatePayments = ((GeneratePaymentSession)this.getPaymentSession()).getGeneratePayments();
        FileExportStruct[] files = new FileExportStruct[generatePayments.length];
        for (int i = 0; i < generatePayments.length; ++i) {
            files[i] = this.createFileExport(generatePayments[i], i + 1);
        }
        return files;
    }

    private FileExportStruct createFileExport(GeneratePayment payment, int index) throws BusinessDomainException {
        StringWriter appender = new StringWriter();
        OutputStringWriter lineWriter = new OutputStringWriter((Appendable)appender, LineSeparator.CRLF);
        lineWriter.write(this.getLineGenerator(payment));
        ReverseFactoringFileNameContext context = new ReverseFactoringFileNameContext(index, payment);
        return new FileExportStruct(this.getFileName(context), ((Object)appender).toString().getBytes(StandardCharsets.UTF_8));
    }

    protected abstract LineGenerator getLineGenerator(GeneratePayment var1) throws BusinessDomainException;

    protected abstract String getFileName(ReverseFactoringFileNameContext var1);

    public boolean completeFileName() {
        return false;
    }
}

