/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.payment.report.bacspaymentrunlist;

import com.infor.igf.core.util.PersistableEnumUtils;
import com.varial.accounting.domain.bankaccount.BankAccount;
import com.varial.accounting.domain.bankaccount.BankAccountPersistencyManager;
import com.varial.accounting.domain.custsupaddress.CustSupAddress;
import com.varial.accounting.domain.custsupaddress.CustSupAddressPersistencyManagerBase;
import com.varial.accounting.domain.nominalledger.NLItemCompanySetting;
import com.varial.accounting.domain.nominalledger.NLItemCompanySettingPersistencyManager;
import com.varial.accounting.domain.payment.AdvancePayment;
import com.varial.accounting.domain.payment.AdvancePaymentSession;
import com.varial.accounting.domain.payment.FinancePayment;
import com.varial.accounting.domain.payment.FinancePaymentPersistencyManager;
import com.varial.accounting.domain.payment.FinancePaymentSession;
import com.varial.accounting.domain.payment.GeneratePaymentISoftware;
import com.varial.accounting.domain.payment.GeneratePaymentSession;
import com.varial.accounting.domain.payment.PaymentHelper;
import com.varial.accounting.domain.payment.export.PaymentExporterFactory;
import com.varial.accounting.domain.payment.report.PaymentReportContainer;
import com.varial.accounting.domain.payment.report.PaymentReportHelper;
import com.varial.accounting.domain.payment.report.bacspaymentrunlist.BacsPaymentComparator;
import com.varial.accounting.domain.personalaccount.PersonalAccount;
import com.varial.accounting.domain.personalaccount.PersonalAccountContact;
import com.varial.accounting.domain.personalaccount.PersonalAccountPersistencyManager;
import com.varial.accounting.domain.personalaccount.RemittanceType;
import com.varial.accounting.paymentrun.BacsPaymentRunListPrintOptionStruct;
import com.varial.accounting.persistency.genpayremitoi.GenpayremitoiContainer;
import com.varial.base.UtilitiesManager;
import com.varial.common.persistency.payment.PaymentContainer;
import com.varial.framework.basictypes.addresses.IPostalAddress;
import com.varial.framework.domain.advisor.Advisor;
import com.varial.framework.domain.currency.CurrencyPersistencyManager;
import com.varial.framework.domain.payment.sepa.data.PaymentInfoData;
import com.varial.framework.domain.paymentbase.ModeOfPayment;
import com.varial.framework.domain.paymentbase.Payment;
import com.varial.interfaces.ICurrency;
import com.varial.serverbase.domain.language.Language;
import com.varial.serverbase.mapper.StringMapper;
import java.math.BigDecimal;
import java.util.Date;

public class BacsPaymentContainer
extends PaymentReportContainer {
    private final BankAccountPersistencyManager bankAccountPersistencyManager = (BankAccountPersistencyManager)UtilitiesManager.getBean((String)"bankAccountPersistencyManager", BankAccountPersistencyManager.class);
    private PaymentContainer mPaymentContainer;
    private final ICurrency mCurrency;
    private final FinancePaymentSession mSession;
    private final String mPayObjectId;
    private final String mOidPayment;
    private final IPostalAddress mPostalAddress;
    private CustSupAddress mCustSupAddress;
    private PersonalAccount mPersonalAccount;
    private NLItemCompanySetting mNLItemCompanySetting;
    private String mEmail;
    private String mEmailCC;
    private String mFax;
    private String mDefaultEmail;
    private String mDefaultFax;
    private Advisor mAdvisor;
    private RemittanceType mRemittanceType;
    private String mTitle;
    private String mContactName;
    private final String mPAShortName;
    private final String mBankDeviatingOwner;
    private final Date mDocumentDate;
    private final Date mRemittanceDate;
    private Date mExecuteDate;
    private final BankAccount mCompanyBankAccount;
    private boolean mIsDebit;
    private String mNumberAtFactoringCompany;
    private final String mBankName;
    private final String mOidBankAccount;
    private final String mBankSortingCode;
    private final String mBankAccountNumber;
    private final String mSwift;
    private final String mIban;
    private final BigDecimal mAmount;
    private final BigDecimal mPaymentAmount;
    private final BigDecimal mRemmitanceSettlementAmount;
    private final BigDecimal mOpenAmount;
    private final BigDecimal mDiscountAmount;
    private final BigDecimal mBaseAmountOfPayment;
    private final ModeOfPayment mPaymentType;
    private final String mEsrNumber;
    private final String mPostchequeAccount;
    private final String mMemberNumber;
    private final String mRemittanceDescription;
    private final String mReferenceDescription;
    private final String mReferenceNumber;
    private final String mSequenceNumber;
    private final String mOidNominalAccount;
    private final boolean mIsSepaPayment;
    private final String mSepaMandat;
    private final String mProcessId;
    private Date mSepaExecuteDate;
    private String mPAAssociationCode;
    private String mPAAssociationShortAddress;
    private String mNote;

    public BacsPaymentContainer(GeneratePaymentSession session, GenpayremitoiContainer genpayremitoiContainer, PaymentInfoData paymentInfoData, String fileName, PaymentExporterFactory.PaymentExporterType paymentExporterType) {
        super(paymentInfoData, fileName, paymentExporterType);
        this.mSession = session;
        if (session.getAdvisor() != null) {
            this.mAdvisor = session.getAdvisor();
        }
        this.mNumberAtFactoringCompany = genpayremitoiContainer.numberatfactcomp;
        this.mPAShortName = genpayremitoiContainer.p_name;
        this.mIsDebit = this.isDebit(genpayremitoiContainer);
        this.mOidPayment = this.getPaymentOid(genpayremitoiContainer);
        FinancePayment payment = this.getPayment(genpayremitoiContainer, session);
        this.mCurrency = payment.getCurrency();
        this.mCompanyBankAccount = payment.getBankAccount();
        this.mRemittanceType = RemittanceType.NOREMITTANCE;
        if (!StringMapper.isNullString((String)genpayremitoiContainer.oidaddress)) {
            this.mCustSupAddress = CustSupAddressPersistencyManagerBase.getCustSupAddress((String)this.mSession.getAccountingCompany().getObjectid(), (String)genpayremitoiContainer.oidaddress);
        }
        if (!StringMapper.isNullString((String)genpayremitoiContainer.oidpersonalacc)) {
            this.mPersonalAccount = PersonalAccountPersistencyManager.getPersonalAccount((String)genpayremitoiContainer.oidpersonalacc);
            this.setPersonalAccountContactData(this.mPersonalAccount);
            if (!this.mPersonalAccount.getOneOffAccount()) {
                this.mCustSupAddress = this.mPersonalAccount.getAddress();
                if (session.getSendToDeviatingAddress() && this.mPersonalAccount.getDeviatingAddress() != null) {
                    this.mCustSupAddress = this.mPersonalAccount.getDeviatingAddress();
                }
            }
        }
        this.mPostalAddress = this.mCustSupAddress == null ? payment.getPostalAddress() : this.mCustSupAddress.getPostalAddress();
        this.mPayObjectId = this.getOidForReportGroup(genpayremitoiContainer);
        this.mAmount = PaymentReportHelper.format((BigDecimal)PaymentReportHelper.setSignum((BigDecimal)genpayremitoiContainer.originalamount, (boolean)genpayremitoiContainer.isdebit, (boolean)this.mSession.isPayment()), (ICurrency)this.mCurrency);
        this.mPaymentAmount = PaymentReportHelper.format((BigDecimal)this.getPaymentAmount(genpayremitoiContainer, payment), (ICurrency)this.mCurrency);
        this.mRemmitanceSettlementAmount = PaymentReportHelper.format((BigDecimal)genpayremitoiContainer.settlementamount, (ICurrency)this.mCurrency);
        this.mOpenAmount = PaymentReportHelper.format((BigDecimal)PaymentReportHelper.setSignum((BigDecimal)genpayremitoiContainer.openamount, (boolean)genpayremitoiContainer.isdebit, (boolean)this.mSession.isPayment()), (ICurrency)this.mCurrency);
        this.mDiscountAmount = PaymentReportHelper.format((BigDecimal)genpayremitoiContainer.discountamount, (ICurrency)this.mCurrency);
        this.mBaseAmountOfPayment = PaymentReportHelper.format((BigDecimal)this.getBaseAmountOfPayment(genpayremitoiContainer, payment), (ICurrency)this.mSession.getAccountingCompany().getFinanceSetup().getBaseCurrency());
        this.mDocumentDate = genpayremitoiContainer.p_documentdate;
        this.mRemittanceDate = genpayremitoiContainer.oi_documentdate;
        this.mExecuteDate = this.getExecuteDate(payment, session);
        this.mPaymentType = payment.getTypeOfPayment();
        this.mEsrNumber = this.getEsrNumber(payment);
        this.mPostchequeAccount = payment.getPostChequeAccount();
        this.mMemberNumber = this.getMemberNumber(payment);
        this.mBankName = payment.getBankName();
        this.mBankSortingCode = payment.getBankSortingCode();
        this.mBankAccountNumber = payment.getBankAccountNumber();
        this.mSwift = payment.getSwift();
        this.mIban = payment.getShortAddressOwner();
        this.mSepaMandat = payment.getSepaMandate();
        this.mOidBankAccount = this.getBankAccountOid(payment);
        this.mRemittanceDescription = genpayremitoiContainer.details;
        this.mReferenceDescription = genpayremitoiContainer.oi_note;
        this.mReferenceNumber = genpayremitoiContainer.oi_referencenumber;
        this.mSequenceNumber = genpayremitoiContainer.oi_sequencenumber;
        this.mBankDeviatingOwner = PaymentHelper.getPaymentBankDeviatingOwner(payment);
        this.mOidNominalAccount = "";
        this.mIsSepaPayment = payment.isSepaPayment();
        if (this.mIsSepaPayment) {
            this.mSepaExecuteDate = payment.getSepaDirectDebitExecuteDate();
        }
        this.mProcessId = genpayremitoiContainer.processid;
        this.mPAAssociationCode = "";
        this.mPAAssociationShortAddress = "";
        if (session.getIsAssociation()) {
            PersonalAccount pa = PersonalAccountPersistencyManager.getPersonalAccount((String)genpayremitoiContainer.oi_oidpersonalacc);
            this.mPAAssociationCode = pa.getCode();
            this.mPAAssociationShortAddress = pa.getShortAddress();
        }
        this.mNote = genpayremitoiContainer.oi_note;
    }

    private Date getExecuteDate(FinancePayment payment, GeneratePaymentSession session) {
        Date executeDate = null;
        if (payment.getExecuteDate() != null && new GeneratePaymentISoftware(session).getGeneratePaymentPerDueDate(payment.getTypeOfPayment())) {
            executeDate = payment.getExecuteDate();
        } else {
            executeDate = session.getExecuteDate();
            if (executeDate == null) {
                executeDate = session.getCreationDate();
            }
        }
        return executeDate;
    }

    public BacsPaymentContainer(AdvancePaymentSession session, PaymentContainer paymentContainer, PaymentInfoData paymentInfoData, String fileName) {
        super(paymentInfoData, fileName, null);
        this.mSession = session;
        this.mPaymentContainer = paymentContainer;
        this.mOidPayment = this.mPaymentContainer.getObjectid();
        this.mCurrency = CurrencyPersistencyManager.getCurrency((String)this.mPaymentContainer.oidcurrency);
        this.mCompanyBankAccount = this.bankAccountPersistencyManager.getBankAccount(this.mPaymentContainer.oidbankaccount);
        AdvancePaymentSession aps = AdvancePaymentSession.getAdvancePaymentSession((String)this.mPaymentContainer.oidsession);
        AdvancePayment advancePayment = FinancePaymentPersistencyManager.getAdvancePayment((String)this.mPaymentContainer.getObjectid(), (AdvancePaymentSession)aps);
        this.mPostalAddress = advancePayment.getPostalAddress();
        this.mRemittanceType = RemittanceType.NOREMITTANCE;
        if (!StringMapper.isNullString((String)this.mPaymentContainer.oidpersonalacc)) {
            this.mPersonalAccount = PersonalAccountPersistencyManager.getPersonalAccount((String)this.mPaymentContainer.oidpersonalacc);
            this.setPersonalAccountContactData(this.mPersonalAccount);
            if (!this.mPersonalAccount.getOneOffAccount()) {
                this.mCustSupAddress = this.mPersonalAccount.getAddress();
            }
        }
        this.mPayObjectId = this.getOidForReportGroup(this.mPaymentContainer);
        this.mPaymentAmount = this.mAmount = PaymentReportHelper.format((BigDecimal)this.mPaymentContainer.amount, (ICurrency)this.mCurrency);
        this.mRemmitanceSettlementAmount = this.mAmount;
        this.mOpenAmount = BigDecimal.ZERO;
        this.mDiscountAmount = BigDecimal.ZERO;
        this.mBaseAmountOfPayment = PaymentReportHelper.format((BigDecimal)this.mPaymentContainer.baseamount, (ICurrency)this.mCurrency);
        this.mRemittanceDate = this.mDocumentDate = this.mPaymentContainer.documentdate;
        this.mExecuteDate = session.getExecuteDate();
        if (this.mExecuteDate == null) {
            this.mExecuteDate = session.getCreationDate();
        }
        this.mPAShortName = this.mPaymentContainer.name;
        this.mPaymentType = (ModeOfPayment)PersistableEnumUtils.toEnum(ModeOfPayment.class, (int)this.mPaymentContainer.typeofpayment);
        this.mEsrNumber = this.mPaymentContainer.esrnumber;
        this.mPostchequeAccount = this.mPaymentContainer.postchequeaccount;
        this.mMemberNumber = this.mPaymentContainer.membernumber;
        this.mBankName = this.mPaymentContainer.bankname;
        this.mBankSortingCode = this.mPaymentContainer.banksortingcode;
        this.mBankAccountNumber = this.mPaymentContainer.bankaccountnumber;
        this.mSwift = this.mPaymentContainer.swift;
        this.mOidBankAccount = this.mPaymentContainer.oidbankaccount;
        this.mIban = this.mPaymentContainer.shortaddressowner;
        this.mSepaMandat = this.mPaymentContainer.sepamandate;
        this.mRemittanceDescription = this.mPaymentContainer.note;
        this.mReferenceDescription = this.mPaymentContainer.note;
        this.mReferenceNumber = this.mPaymentContainer.referencenumber;
        this.mSequenceNumber = this.mPaymentContainer.sequencenumber;
        this.mBankDeviatingOwner = PaymentHelper.getPaymentBankDeviatingOwner((Payment)advancePayment);
        if (!StringMapper.isNullString((String)this.mPaymentContainer.oidnominalaccount)) {
            this.mOidNominalAccount = this.mPaymentContainer.oidnominalaccount;
            this.mNLItemCompanySetting = NLItemCompanySettingPersistencyManager.getNLAccountCompanySetting((String)this.mPaymentContainer.oidnominalaccount);
        } else {
            this.mOidNominalAccount = "";
        }
        this.mIsSepaPayment = advancePayment.isSepaPayment();
        this.mSepaExecuteDate = advancePayment.getSepaDirectDebitExecuteDate();
        this.mProcessId = this.mPaymentContainer.processid;
    }

    private String getOidForReportGroup(PaymentContainer paymentContainer) {
        Object result = "";
        result = !StringMapper.isNullString((String)paymentContainer.bankaccountnumber) || !StringMapper.isNullString((String)paymentContainer.banksortingcode) || !StringMapper.isNullString((String)paymentContainer.swift) ? paymentContainer.oidpersonalacc + "/" + paymentContainer.bankaccountnumber + "/" + paymentContainer.banksortingcode + "/" + paymentContainer.swift : (!StringMapper.isNullString((String)paymentContainer.oidnominalaccount) ? paymentContainer.oidnominalaccount : paymentContainer.oidpersonalacc);
        return result;
    }

    private String getOidForReportGroup(GenpayremitoiContainer container) {
        return container.oidpersonalacc + "/" + container.p_objectid;
    }

    public String getOidBankAccount() {
        return this.mOidBankAccount;
    }

    public String getCompanyBankName() {
        if (this.mCompanyBankAccount == null) {
            return "";
        }
        if (StringMapper.isNullString((String)this.mCompanyBankAccount.getBankData().getBankName())) {
            return StringMapper.toString((String)this.mCompanyBankAccount.getBankData().getPostalAddress().getName());
        }
        return this.mCompanyBankAccount.getBankData().getBankName();
    }

    public String getCompanyBankSortCode() {
        return this.mCompanyBankAccount == null ? "" : StringMapper.toString((String)this.mCompanyBankAccount.getBankSortingCode());
    }

    public String getCompanyBankAccount() {
        return this.mCompanyBankAccount == null ? "" : StringMapper.toString((String)this.mCompanyBankAccount.getBankAccountNumber());
    }

    public String getCompanyBankSwift() {
        return this.mCompanyBankAccount == null ? "" : StringMapper.toString((String)this.mCompanyBankAccount.getSwift());
    }

    public String getCompanyBankIban() {
        return this.mCompanyBankAccount == null ? "" : PaymentHelper.getIbanForPrintFormat(StringMapper.toString((String)this.mCompanyBankAccount.getOtherReference()));
    }

    public String getBankSortingCode() {
        return StringMapper.toString((String)this.mBankSortingCode);
    }

    public String getBankAccountNumber() {
        return StringMapper.toString((String)this.mBankAccountNumber);
    }

    public String getSwift() {
        return StringMapper.toString((String)this.mSwift);
    }

    public String getPAIban() {
        return PaymentHelper.getIbanForPrintFormat(StringMapper.toString((String)this.mIban));
    }

    public String getSepaMandat() {
        return StringMapper.toString((String)this.mSepaMandat);
    }

    public String getReferenceNumber() {
        return StringMapper.toString((String)this.mReferenceNumber);
    }

    public String getSequenceNumber() {
        return StringMapper.toString((String)this.mSequenceNumber);
    }

    public String getRemittanceDescription() {
        return StringMapper.toString((String)this.mRemittanceDescription);
    }

    public String getReferenceDescription() {
        return StringMapper.toString((String)this.mReferenceDescription);
    }

    public ICurrency getCurrency() {
        return this.mCurrency;
    }

    public String getPACode() {
        if (this.mPersonalAccount != null) {
            return StringMapper.toString((String)this.mPersonalAccount.getCode());
        }
        return "";
    }

    public String getNlAccCode() {
        if (this.mNLItemCompanySetting != null) {
            return StringMapper.toString((String)this.mNLItemCompanySetting.getNominalLedgerItem().getCode());
        }
        return "";
    }

    public boolean getIsForeignPayment() {
        return this.mSession.getIsForeignPayment();
    }

    public String getOidPersonalAccount() {
        if (this.mPersonalAccount != null) {
            return StringMapper.toString((String)this.mPersonalAccount.getObjectid());
        }
        return "";
    }

    public String getPAShortAddress() {
        if (this.mPersonalAccount != null) {
            return StringMapper.toString((String)this.mPersonalAccount.getShortAddress());
        }
        return "";
    }

    public String getNlAccShortName() {
        if (this.mNLItemCompanySetting != null) {
            return StringMapper.toString((String)this.mNLItemCompanySetting.getNominalLedgerItem().getShortName());
        }
        return "";
    }

    public Date getDocumentDate() {
        return this.mDocumentDate;
    }

    public BigDecimal getAmount() {
        return this.mAmount;
    }

    public String getPAName() {
        return StringMapper.toString((String)this.mPostalAddress.getName());
    }

    public String getEmail() {
        return StringMapper.toString((String)this.mEmail);
    }

    public String getEmailCC() {
        return StringMapper.toString((String)this.mEmailCC);
    }

    public String getFax() {
        return StringMapper.toString((String)this.mFax);
    }

    public String getDefaultEmail() {
        return StringMapper.toString((String)this.mDefaultEmail);
    }

    public String getDefaultFax() {
        return StringMapper.toString((String)this.mDefaultFax);
    }

    public String getTitle() {
        return StringMapper.toString((String)this.mTitle);
    }

    public String getContactName() {
        return StringMapper.toString((String)this.mContactName);
    }

    private void setPersonalAccountContactData(PersonalAccount pa) {
        this.mEmail = "";
        this.mEmailCC = "";
        this.mFax = "";
        this.mTitle = "";
        this.mContactName = "";
        PersonalAccountContact contact = pa.getAdviseDefaultContact();
        if (contact != null) {
            this.mRemittanceType = contact.getRemittanceSendType();
            if (this.mRemittanceType == RemittanceType.EMAIL || this.mRemittanceType == RemittanceType.ASCII) {
                this.mEmail = contact.getEmail();
                this.mEmailCC = contact.getEmailCC();
            } else if (this.mRemittanceType == RemittanceType.FAX) {
                this.mFax = contact.getFax();
            }
            this.mTitle = contact.getTitle();
            this.mContactName = contact.getContactPerson();
        }
        if (pa.getDeviatingAddress() != null) {
            if (!StringMapper.isNullString((String)pa.getDeviatingAddress().getEMail())) {
                this.mDefaultEmail = pa.getDeviatingAddress().getEMail();
            }
            if (!StringMapper.isNullString((String)pa.getDeviatingAddress().getFax())) {
                this.mDefaultFax = pa.getDeviatingAddress().getFax();
            }
        } else if (!pa.getOneOffAccount()) {
            if (!StringMapper.isNullString((String)pa.getAddress().getEMail())) {
                this.mDefaultEmail = pa.getAddress().getEMail();
            }
            if (!StringMapper.isNullString((String)pa.getAddress().getFax())) {
                this.mDefaultFax = pa.getAddress().getFax();
            }
        }
    }

    public String getPAShortName() {
        return StringMapper.toString((String)this.mPAShortName);
    }

    public IPostalAddress getPAPostalAddress() {
        return this.mPostalAddress;
    }

    public String getPayObjectId() {
        return this.mPayObjectId;
    }

    public BigDecimal getPaymentAmount() {
        return this.mPaymentAmount;
    }

    public BigDecimal getRemittanceSettlementAmount() {
        return this.mRemmitanceSettlementAmount;
    }

    public BigDecimal getOpenAmount() {
        return this.mOpenAmount;
    }

    public BigDecimal getDiscountAmount() {
        return this.mDiscountAmount;
    }

    public Date getRemittanceDate() {
        return this.mRemittanceDate;
    }

    public ModeOfPayment getPaymentType() {
        return this.mPaymentType;
    }

    public String getEsrNumber() {
        return StringMapper.toString((String)this.mEsrNumber);
    }

    public String getPostchequeAccount() {
        return StringMapper.toString((String)this.mPostchequeAccount);
    }

    public String getMemberNumber() {
        return StringMapper.toString((String)this.mMemberNumber);
    }

    public String getBankName() {
        return StringMapper.toString((String)this.mBankName);
    }

    public String getPayeePhoneNo() {
        if (this.mCustSupAddress != null) {
            return StringMapper.toString((String)this.mCustSupAddress.getPhone());
        }
        return "";
    }

    public String getPayeeFaxNo() {
        if (this.mCustSupAddress != null) {
            return StringMapper.toString((String)this.mCustSupAddress.getFax());
        }
        return "";
    }

    public String getOwnNumberAtPartner() {
        if (this.mPersonalAccount != null) {
            return StringMapper.toString((String)this.mPersonalAccount.getOwnNumberAtPartner());
        }
        return "";
    }

    public Language getPALanguage() {
        if (this.mCustSupAddress != null) {
            return this.mCustSupAddress.getCorrespondenceLanguage();
        }
        if (this.mSession.getAccountingCompany().getLanguageForReport() != null) {
            return this.mSession.getAccountingCompany().getLanguageForReport();
        }
        return this.mSession.getAccountingCompany().getDefaultLanguage();
    }

    public Advisor getAdvisor() {
        if (this.mAdvisor != null) {
            return this.mAdvisor;
        }
        if (this.mPersonalAccount != null) {
            return this.mPersonalAccount.getAdvisor();
        }
        return null;
    }

    public boolean isDebit() {
        return this.mIsDebit;
    }

    private boolean isDebit(GenpayremitoiContainer genContainer) {
        return (genContainer.amountofpayment == null || genContainer.amountofpayment.signum() != -1) && (genContainer.settlementamount == null || genContainer.settlementamount.signum() != -1);
    }

    public RemittanceType getRemittanceType() {
        return this.mRemittanceType;
    }

    public String getBankDeviatingOwner() {
        return this.mBankDeviatingOwner;
    }

    public String getOneOfAccountShortAddress() {
        if (this.mPersonalAccount != null && this.mPersonalAccount.getOneOffAccount() && this.mCustSupAddress != null) {
            return StringMapper.toString((String)this.mCustSupAddress.getShortAddress());
        }
        return "";
    }

    public boolean isSepaPayment() {
        return this.mIsSepaPayment;
    }

    public String getOidNominalAccount() {
        return this.mOidNominalAccount;
    }

    public String getProcessId() {
        return this.mProcessId;
    }

    public String getAdvisorName() {
        Advisor advisor = this.getAdvisor();
        if (advisor != null) {
            return advisor.getName();
        }
        return "";
    }

    public String getAdvisorPhone() {
        Advisor advisor = this.getAdvisor();
        if (advisor != null) {
            return advisor.getPhone();
        }
        return "";
    }

    public String getAdvisorEmail() {
        Advisor advisor = this.getAdvisor();
        if (advisor != null) {
            return advisor.getEmail();
        }
        return "";
    }

    public Date getSepaExecutionDate() {
        if (this.getPaymentInfoData() != null) {
            return this.getPaymentInfoData().getRequestedExecutionDate();
        }
        if (this.mSepaExecuteDate != null) {
            return this.mSepaExecuteDate;
        }
        return this.mExecuteDate;
    }

    public BigDecimal getBaseAmountOfPayment() {
        return this.mBaseAmountOfPayment;
    }

    public String getOidPayment() {
        return this.mOidPayment;
    }

    public String getPAAssociationCode() {
        return this.mPAAssociationCode;
    }

    public String getPAAssociationShortAddress() {
        return this.mPAAssociationShortAddress;
    }

    public String getNumberAtFactoringCompany() {
        return this.mNumberAtFactoringCompany;
    }

    public String getNote() {
        return this.mNote;
    }

    public boolean printSwiftIban() {
        return this.isSepaPayment() || this.missingBankAccountNumber();
    }

    private boolean missingBankAccountNumber() {
        return StringMapper.isNullString((String)this.getBankAccountNumber());
    }

    public static BacsPaymentComparator getBacsPaymentComparator(int accountType, BacsPaymentRunListPrintOptionStruct printOptions) {
        return BacsPaymentComparator.getBacsPaymentComparator(accountType, printOptions);
    }
}

