/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.payment.report.bacspaymentrunlist;

import com.varial.accounting.domain.payment.PaymentHelper;
import com.varial.accounting.domain.payment.report.bacspaymentrunlist.BacsPaymentContainer;
import com.varial.accounting.paymentrun.BacsPaymentRunListPrintOptionStruct;
import com.varial.serverbase.mapper.ExceptionMapper;
import java.util.Comparator;

class BacsPaymentComparator
implements Comparator<BacsPaymentContainer> {
    private final BacsPaymentRunListPrintOptionStruct mPrintOptions;
    private final int mAccountType;

    public BacsPaymentComparator(int accountType, BacsPaymentRunListPrintOptionStruct printOptions) {
        this.mPrintOptions = printOptions;
        this.mAccountType = accountType;
    }

    @Override
    public int compare(BacsPaymentContainer o1, BacsPaymentContainer o2) {
        try {
            int result = 0;
            if (this.mAccountType == 0 && result == 0) {
                result = o1.getBankAccountNumber().compareToIgnoreCase(o2.getBankAccountNumber());
            }
            if (result == 0) {
                result = o1.getFileName().compareTo(o2.getFileName());
            }
            if (result == 0) {
                result = o1.getSepaPaymentInfoId().compareTo(o2.getSepaPaymentInfoId());
            }
            if (result == 0) {
                result = o1.getCurrency().getCode().compareToIgnoreCase(o2.getCurrency().getCode());
            }
            result = this.mPrintOptions.sortByShortAddress ? (this.mAccountType == 2 ? PaymentHelper.convertChar(o1.getNlAccShortName()).compareToIgnoreCase(PaymentHelper.convertChar(o2.getNlAccShortName())) : PaymentHelper.convertChar(o1.getPAShortAddress()).compareToIgnoreCase(PaymentHelper.convertChar(o2.getPAShortAddress()))) : (this.mAccountType == 2 ? PaymentHelper.convertChar(o1.getNlAccCode()).compareToIgnoreCase(PaymentHelper.convertChar(o2.getNlAccCode())) : PaymentHelper.convertChar(o1.getPACode()).compareToIgnoreCase(PaymentHelper.convertChar(o2.getPACode())));
            if (this.mAccountType != 2 && result == 0) {
                result = o1.getOidPersonalAccount().compareTo(o2.getOidPersonalAccount());
            }
            if (this.mAccountType != 0 && result == 0) {
                result = o1.getOidNominalAccount().compareTo(o2.getOidNominalAccount());
            }
            if (this.mAccountType == 0) {
                if (result == 0) {
                    result = o1.getOidPayment().compareTo(o2.getOidPayment());
                }
                if (result == 0) {
                    result = this.mPrintOptions.sortByShortAddress ? PaymentHelper.convertChar(o1.getPAAssociationShortAddress()).compareToIgnoreCase(PaymentHelper.convertChar(o2.getPAAssociationShortAddress())) : PaymentHelper.convertChar(o1.getPAAssociationCode()).compareToIgnoreCase(PaymentHelper.convertChar(o2.getPAAssociationCode()));
                }
            }
            if (result == 0) {
                result = o1.getDocumentDate().compareTo(o2.getDocumentDate());
            }
            if (result == 0) {
                result = o1.getReferenceNumber().compareTo(o2.getReferenceNumber());
            }
            return result;
        }
        catch (Exception e) {
            ExceptionMapper.printException((Throwable)e);
            return 0;
        }
    }

    public static BacsPaymentComparator getBacsPaymentComparator(int accountType, BacsPaymentRunListPrintOptionStruct printOptions) {
        return new BacsPaymentComparator(accountType, printOptions);
    }
}

