/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.payment.iso20022.schema.v10.debit.sepa;

import com.varial.accounting.domain.payment.export.xml.XmlPaymentDataUtils;
import com.varial.accounting.domain.payment.iso20022.common.strategy.CreDtTmStrategy;
import com.varial.accounting.domain.payment.iso20022.common.strategy.PostalAddressPresenceStrategy;
import com.varial.accounting.domain.payment.iso20022.core.schema.IsoPaymentProfile;
import com.varial.accounting.domain.payment.iso20022.schema.v10.common.IsoCreDtTmStrategyFactory;
import com.varial.accounting.domain.payment.iso20022.schema.v10.common.IsoPostalAddressPresenceFactory;
import com.varial.accounting.domain.payment.iso20022.schema.v10.debit.sepa.DebitChargeBearerStrategy;
import com.varial.accounting.domain.payment.iso20022.schema.v10.debit.sepa.DebitChargeBearerStrategyFactory;
import com.varial.accounting.domain.payment.iso20022.schema.v10.debit.sepa.DebitPartyIdentificationBuilder10;
import com.varial.accounting.domain.payment.iso20022.schema.v10.debit.sepa.DebitPaymentTypeInformationStrategy;
import com.varial.accounting.domain.payment.iso20022.schema.v10.debit.sepa.DebitPaymentTypeInformationStrategyFactory;
import com.varial.accounting.domain.payment.iso20022.schema.v10.debit.sepa.DebitPostalAddressBuilder10;
import com.varial.accounting.domain.payment.iso20022.schema.v10.debit.sepa.DebitPostalAddressStrategyFactory10;
import com.varial.framework.domain.payment.sepa.base.DateAdapter;
import com.varial.framework.domain.payment.sepa.data.PartyData;
import com.varial.framework.domain.payment.sepa.data.PaymentData;
import com.varial.framework.domain.payment.sepa.data.PaymentInfoData;
import com.varial.framework.domain.payment.sepa.data.SepaData;
import com.varial.framework.domain.payment.sepa.data.SepaHeaderData;
import com.varial.framework.domain.payment.sepa.data.SepaLocalInstrumentTypeEnum;
import com.varial.framework.domain.payment.sepa.data.SepaSequenceTypeEnum;
import com.varial.framework.domain.payment.sepa.schema.PaymentSchemaMapper;
import com.varial.framework.domain.payment.sepa.schema.PostalAddressBuilder;
import com.varial.framework.domain.payment.sepa.schema.PostalAddressStrategy;
import com.varial.serverbase.mapper.StringMapper;
import iso.sepa.version10.debit.AccountIdentification4Choice;
import iso.sepa.version10.debit.ActiveOrHistoricCurrencyAndAmount;
import iso.sepa.version10.debit.BranchAndFinancialInstitutionIdentification6;
import iso.sepa.version10.debit.CashAccount38;
import iso.sepa.version10.debit.CustomerDirectDebitInitiationV08;
import iso.sepa.version10.debit.DirectDebitTransaction10;
import iso.sepa.version10.debit.DirectDebitTransactionInformation23;
import iso.sepa.version10.debit.FinancialInstitutionIdentification18;
import iso.sepa.version10.debit.GenericPersonIdentification1;
import iso.sepa.version10.debit.GroupHeader83;
import iso.sepa.version10.debit.LocalInstrument2Choice;
import iso.sepa.version10.debit.MandateRelatedInformation14;
import iso.sepa.version10.debit.Party38Choice;
import iso.sepa.version10.debit.PartyIdentification135;
import iso.sepa.version10.debit.PaymentIdentification6;
import iso.sepa.version10.debit.PaymentInstruction29;
import iso.sepa.version10.debit.PaymentMethod2Code;
import iso.sepa.version10.debit.PaymentTypeInformation29;
import iso.sepa.version10.debit.PersonIdentification13;
import iso.sepa.version10.debit.PersonIdentificationSchemeName1Choice;
import iso.sepa.version10.debit.PostalAddress24;
import iso.sepa.version10.debit.RemittanceInformation16;
import iso.sepa.version10.debit.SequenceType3Code;
import iso.sepa.version10.debit.ServiceLevel8Choice;
import java.math.BigDecimal;

public class SepaDebitSchemaMapper
implements PaymentSchemaMapper<CustomerDirectDebitInitiationV08> {
    private final PostalAddressStrategy<PostalAddress24> debtorAddressStrategy;
    private final PostalAddressPresenceStrategy initiatingPartyAddressPresenceStrategy;
    private final PostalAddressPresenceStrategy creditorAddressPresenceStrategy;
    private final DebitPaymentTypeInformationStrategy paymentTypeInformationStrategy;
    private final DebitChargeBearerStrategy chargeBearerStrategy;
    private final CreDtTmStrategy creDtTmStrategy;

    public SepaDebitSchemaMapper(IsoPaymentProfile paymentProfile) {
        this.debtorAddressStrategy = DebitPostalAddressStrategyFactory10.getDebtorAddressStrategy(paymentProfile);
        this.initiatingPartyAddressPresenceStrategy = IsoPostalAddressPresenceFactory.createForSepaDebitInitiatingParty(paymentProfile);
        this.creditorAddressPresenceStrategy = IsoPostalAddressPresenceFactory.createForSepaDebitCreditor(paymentProfile);
        this.paymentTypeInformationStrategy = DebitPaymentTypeInformationStrategyFactory.getStrategy((IsoPaymentProfile)paymentProfile);
        this.chargeBearerStrategy = DebitChargeBearerStrategyFactory.getStrategy((IsoPaymentProfile)paymentProfile);
        this.creDtTmStrategy = IsoCreDtTmStrategyFactory.createForSepa(paymentProfile);
    }

    public CustomerDirectDebitInitiationV08 toSchema(SepaData sepaData) {
        CustomerDirectDebitInitiationV08 directDebit = new CustomerDirectDebitInitiationV08();
        directDebit.setGrpHdr(this.mapHeader(sepaData.getHeader()));
        sepaData.getPaymentInfos().stream().map(this::mapPaymentInformation).forEach(directDebit.getPmtInf()::add);
        return directDebit;
    }

    private PaymentInstruction29 mapPaymentInformation(PaymentInfoData paymentInfoData) {
        PaymentInstruction29 result = new PaymentInstruction29();
        result.setPmtInfId(paymentInfoData.getPaymentInfoID());
        result.setPmtMtd(PaymentMethod2Code.DD);
        result.setReqdColltnDt(new DateAdapter().getCalendarInYYYYMMDD(paymentInfoData.getRequestedExecutionDate()));
        result.setCtrlSum(paymentInfoData.getControlSum());
        result.setNbOfTxs(String.valueOf(paymentInfoData.getNumberOfTransactions()));
        result.setPmtTpInf(this.mapPaymentTypeInformation(paymentInfoData));
        result.setCdtr(this.mapPartyIdentification(paymentInfoData.getPartyData(), this.creditorAddressPresenceStrategy));
        result.setCdtrAcct(this.mapAccount(paymentInfoData.getCompanyIban()));
        if (!StringMapper.isNullString((String)paymentInfoData.getCompanyBic())) {
            result.setCdtrAgt(this.mapFinancialInstitution(paymentInfoData.getCompanyBic()));
        }
        result.setCdtrSchmeId(this.mapCreditorSchemeId(paymentInfoData.getPartyData()));
        paymentInfoData.getPayments().stream().map(this::mapTxInfo).forEach(result.getDrctDbtTxInf()::add);
        return result;
    }

    private PaymentTypeInformation29 mapPaymentTypeInformation(PaymentInfoData paymentInfoData) {
        PaymentTypeInformation29 result = new PaymentTypeInformation29();
        result.getSvcLvl().add(this.mapServiceLevel());
        result.setLclInstrm(this.mapLocalInstrument(paymentInfoData.getSepaLocalInstrumentType()));
        result.setSeqTp(this.mapSequenceType(paymentInfoData.getSequenceType()));
        return result;
    }

    private ServiceLevel8Choice mapServiceLevel() {
        ServiceLevel8Choice result = new ServiceLevel8Choice();
        result.setCd("SEPA");
        return result;
    }

    private SequenceType3Code mapSequenceType(SepaSequenceTypeEnum seqType) {
        switch (seqType) {
            case FRST: {
                return SequenceType3Code.FRST;
            }
            case RCUR: {
                return SequenceType3Code.RCUR;
            }
            case OOFF: {
                return SequenceType3Code.OOFF;
            }
            case FNAL: {
                return SequenceType3Code.FNAL;
            }
        }
        return SequenceType3Code.FRST;
    }

    private LocalInstrument2Choice mapLocalInstrument(SepaLocalInstrumentTypeEnum localInstrumentType) {
        LocalInstrument2Choice result = new LocalInstrument2Choice();
        result.setCd(this.mapLocalInstrumentCode(localInstrumentType));
        return result;
    }

    private String mapLocalInstrumentCode(SepaLocalInstrumentTypeEnum localInstrumentType) {
        switch (localInstrumentType) {
            case B2B: {
                return "B2B";
            }
            case CORE: {
                return "CORE";
            }
            case COR1: {
                return "COR1";
            }
        }
        return "CORE";
    }

    private DirectDebitTransactionInformation23 mapTxInfo(PaymentData paymentData) {
        DirectDebitTransactionInformation23 result = new DirectDebitTransactionInformation23();
        result.setPmtId(this.mapPaymentIdentification(paymentData));
        this.paymentTypeInformationStrategy.applyPaymentTypeInformation(result);
        result.setInstdAmt(this.toActiveOrHistoricAmountType(paymentData.getAmount(), paymentData.getCurrencyCode()));
        this.chargeBearerStrategy.applyChargeBearer(result);
        result.setDrctDbtTx(this.mapDirectDebitTransaction(paymentData));
        if (!StringMapper.isNullString((String)paymentData.getBic())) {
            result.setDbtrAgt(this.mapFinancialInstitution(paymentData.getBic()));
        }
        result.setDbtr(this.mapDebtor(paymentData.getPartyData()));
        result.setDbtrAcct(this.mapAccount(paymentData.getIban()));
        if (!StringMapper.isNullString((String)paymentData.getDeviatingOwner())) {
            result.setUltmtDbtr(this.mapUltimateDebtor(paymentData.getDeviatingOwner()));
        }
        if (!StringMapper.isNullString((String)paymentData.getUnstructuredRemittanceInfoID())) {
            result.setRmtInf(this.mapRemittanceInformation(paymentData.getUnstructuredRemittanceInfoID()));
        }
        return result;
    }

    private PaymentIdentification6 mapPaymentIdentification(PaymentData paymentData) {
        PaymentIdentification6 pi = new PaymentIdentification6();
        pi.setEndToEndId(paymentData.getPaymentEndToEndID());
        return pi;
    }

    private PartyIdentification135 mapDebtor(PartyData debtor) {
        return (PartyIdentification135)new DebitPartyIdentificationBuilder10().setName(debtor.getName()).setPostalAddressBuilder(this.debtorAddressStrategy.getAddress(XmlPaymentDataUtils.getAddress((PartyData)debtor))).build();
    }

    private PartyIdentification135 mapUltimateDebtor(String name) {
        return (PartyIdentification135)new DebitPartyIdentificationBuilder10().setName(name).build();
    }

    private RemittanceInformation16 mapRemittanceInformation(String remittanceInfo) {
        RemittanceInformation16 result = new RemittanceInformation16();
        result.getUstrd().add(remittanceInfo);
        return result;
    }

    private DirectDebitTransaction10 mapDirectDebitTransaction(PaymentData paymentData) {
        DirectDebitTransaction10 result = new DirectDebitTransaction10();
        MandateRelatedInformation14 mri = new MandateRelatedInformation14();
        mri.setMndtId(paymentData.getMandateData().getMandateID());
        mri.setDtOfSgntr(new DateAdapter().getCalendarInYYYYMMDD(paymentData.getMandateData().getMandateDate()));
        mri.setAmdmntInd(Boolean.valueOf(false));
        result.setMndtRltdInf(mri);
        return result;
    }

    private BranchAndFinancialInstitutionIdentification6 mapFinancialInstitution(String bic) {
        BranchAndFinancialInstitutionIdentification6 result = new BranchAndFinancialInstitutionIdentification6();
        FinancialInstitutionIdentification18 instID = new FinancialInstitutionIdentification18();
        instID.setBICFI(bic);
        result.setFinInstnId(instID);
        return result;
    }

    private CashAccount38 mapAccount(String iban) {
        CashAccount38 account = new CashAccount38();
        AccountIdentification4Choice id = new AccountIdentification4Choice();
        id.setIBAN(iban);
        account.setId(id);
        return account;
    }

    private GroupHeader83 mapHeader(SepaHeaderData header) {
        GroupHeader83 result = new GroupHeader83();
        result.setCreDtTm(this.creDtTmStrategy.format(header.getCreationDateTime()));
        result.setInitgPty(this.mapPartyIdentification(header.getInitiatingParty(), this.initiatingPartyAddressPresenceStrategy));
        result.setMsgId(header.getMessageID());
        result.setNbOfTxs(Integer.toString(header.getNumberOfTransactions()));
        result.setCtrlSum(header.getControlSum());
        return result;
    }

    private ActiveOrHistoricCurrencyAndAmount toActiveOrHistoricAmountType(BigDecimal amount, String currencyCode) {
        ActiveOrHistoricCurrencyAndAmount result = new ActiveOrHistoricCurrencyAndAmount();
        result.setCcy(currencyCode);
        result.setValue(amount);
        return result;
    }

    private PartyIdentification135 mapCreditorSchemeId(PartyData creditor) {
        if (creditor == null) {
            return null;
        }
        PartyIdentification135 result = new PartyIdentification135();
        Party38Choice id = new Party38Choice();
        id.setPrvtId(this.mapPersonIdentification(creditor));
        result.setId(id);
        return result;
    }

    private PersonIdentification13 mapPersonIdentification(PartyData creditor) {
        PersonIdentification13 result = new PersonIdentification13();
        GenericPersonIdentification1 gpi = new GenericPersonIdentification1();
        gpi.setId(creditor.getCreditorID());
        PersonIdentificationSchemeName1Choice piSchme = new PersonIdentificationSchemeName1Choice();
        piSchme.setPrtry("SEPA");
        gpi.setSchmeNm(piSchme);
        result.getOthr().add(gpi);
        return result;
    }

    private PartyIdentification135 mapPartyIdentification(PartyData partyData, PostalAddressPresenceStrategy addressPresenceStrategy) {
        DebitPartyIdentificationBuilder10 builder = new DebitPartyIdentificationBuilder10();
        builder.setName(partyData.getName());
        if (addressPresenceStrategy.isPostalAddressRequired()) {
            builder.setPostalAddressBuilder((PostalAddressBuilder)new DebitPostalAddressBuilder10(XmlPaymentDataUtils.getAddress((PartyData)partyData)));
        }
        return (PartyIdentification135)builder.build();
    }
}

