/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.payment.iso20022.schema.v10.debit.sepa;

import com.varial.accounting.domain.payment.iso20022.core.schema.IsoPaymentProfile;
import com.varial.accounting.domain.payment.iso20022.schema.v10.debit.sepa.DebitPostalAddressBuilder10;
import com.varial.base.text.TextFactory;
import com.varial.framework.domain.payment.sepa.data.LocationData;
import com.varial.framework.domain.payment.sepa.schema.AddressFormatMode;
import com.varial.framework.domain.payment.sepa.schema.PostalAddressBuilder;
import com.varial.framework.domain.payment.sepa.schema.PostalAddressStrategy;
import iso.sepa.version10.debit.PostalAddress24;
import java.util.Map;
import java.util.function.Function;

public class DebitPostalAddressStrategyFactory10 {
    private static final Function<LocationData, PostalAddressBuilder<PostalAddress24>> BUILDER = DebitPostalAddressBuilder10::new;
    private static final Map<IsoPaymentProfile, AddressFormatMode> FORMAT_MAP = Map.of(IsoPaymentProfile.SEPA_AT, AddressFormatMode.STRUCTURED, IsoPaymentProfile.SEPA_NL, AddressFormatMode.STRUCTURED);

    private DebitPostalAddressStrategyFactory10() {
    }

    public static PostalAddressStrategy<PostalAddress24> getDebtorAddressStrategy(IsoPaymentProfile paymentProfile) {
        AddressFormatMode mode = FORMAT_MAP.getOrDefault((Object)paymentProfile, AddressFormatMode.UNSTRUCTURED);
        return DebitPostalAddressStrategyFactory10.toStrategy(mode);
    }

    private static PostalAddressStrategy<PostalAddress24> toStrategy(AddressFormatMode mode) {
        switch (mode) {
            case STRUCTURED: {
                return PostalAddressStrategy.structured(BUILDER);
            }
            case UNSTRUCTURED: {
                return PostalAddressStrategy.unstructured(BUILDER);
            }
        }
        throw new IllegalArgumentException(TextFactory.makeArgumentNotSupported((Object)mode));
    }
}

