/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.payment.iso20022.schema.v10.credit.common;

import com.varial.accounting.domain.payment.iso20022.common.strategy.credit.BatchBookingStrategy;
import com.varial.accounting.domain.payment.iso20022.common.strategy.credit.CashAccountStrategy;
import com.varial.accounting.domain.payment.iso20022.common.strategy.credit.ChargesStrategy;
import com.varial.accounting.domain.payment.iso20022.common.strategy.credit.DebtorStrategy;
import com.varial.accounting.domain.payment.iso20022.common.strategy.credit.InitiatingPartyStrategy;
import com.varial.accounting.domain.payment.iso20022.common.strategy.credit.IntermediaryAccountStrategy;
import com.varial.accounting.domain.payment.iso20022.core.schema.IsoPaymentProfile;
import com.varial.accounting.domain.payment.iso20022.schema.v10.common.IsoCreDtTmStrategyFactory;
import com.varial.accounting.domain.payment.iso20022.schema.v10.common.IsoPostalAddressPresenceFactory;
import com.varial.accounting.domain.payment.iso20022.schema.v10.credit.common.CashAccountStrategyFactory;
import com.varial.accounting.domain.payment.iso20022.schema.v10.credit.common.CreditPostalAddressStrategyFactory10;
import com.varial.accounting.domain.payment.iso20022.schema.v10.credit.common.CreditSchemaMappingContext;

public class CreditSchemaMappingContextFactory {
    public CreditSchemaMappingContext createForeignPaymentContext(IsoPaymentProfile paymentProfile) {
        return CreditSchemaMappingContext.builder().setIntermediaryAccountStrategy((IntermediaryAccountStrategy)new IntermediaryAccountStrategy.ForeignPaymentIntermediaryAccountStrategy()).setChargesStrategy((ChargesStrategy)new ChargesStrategy.ForeignPaymentChargesStrategy()).setBatchBookingStrategy((BatchBookingStrategy)new BatchBookingStrategy.ForeignPaymentBatchBookingStrategy()).setCreditorAddressStrategy(new CreditPostalAddressStrategyFactory10().createForForeignPayment(paymentProfile)).setCashAccountStrategy(new CashAccountStrategyFactory().createForForeignPayment(paymentProfile)).setCreDtTmStrategy(IsoCreDtTmStrategyFactory.createForForeignPayment()).build();
    }

    public CreditSchemaMappingContext createSepaContext(IsoPaymentProfile paymentProfile) {
        return CreditSchemaMappingContext.builder().setIntermediaryAccountStrategy((IntermediaryAccountStrategy)new IntermediaryAccountStrategy.SepaIntermediaryAccountStrategy()).setChargesStrategy((ChargesStrategy)new ChargesStrategy.SepaCreditChargesStrategy(paymentProfile)).setBatchBookingStrategy((BatchBookingStrategy)new BatchBookingStrategy.SepaBatchBookingStrategy(paymentProfile)).setCreditorAddressStrategy(new CreditPostalAddressStrategyFactory10().createForSepa(paymentProfile)).setCashAccountStrategy((CashAccountStrategy)new CashAccountStrategy.CashAccountWithSchemeNameStrategy()).setDebtorStrategy((DebtorStrategy)new DebtorStrategy.SepaDebtorStrategy(paymentProfile)).setInitiatingPartyStrategy((InitiatingPartyStrategy)new InitiatingPartyStrategy.SepaInitiatingPartyStrategy(paymentProfile)).setCreDtTmStrategy(IsoCreDtTmStrategyFactory.createForSepa(paymentProfile)).setDebtorAddressPresenceStrategy(IsoPostalAddressPresenceFactory.createForSepaCreditDebtor(paymentProfile)).build();
    }
}

