/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.payment;

import com.varial.accounting.domain.bankaccount.BankAccount;
import com.varial.accounting.domain.bankaccount.BankAccountPersistencyManager;
import com.varial.accounting.domain.bankaccount.IBankData;
import com.varial.accounting.domain.custsupaddress.CustSupAddress;
import com.varial.accounting.domain.custsupaddress.ICustSupAddress;
import com.varial.accounting.domain.financialyear.AccountingCompany;
import com.varial.accounting.domain.financialyear.AccountingCompanyPersistencyManager;
import com.varial.accounting.domain.financialyear.FinancialYear;
import com.varial.accounting.domain.openitem.OpenItem;
import com.varial.accounting.domain.payment.AdvancePayment;
import com.varial.accounting.domain.payment.AdvancePaymentSession;
import com.varial.accounting.domain.payment.FinancePayment;
import com.varial.accounting.domain.payment.FinancePaymentExceptionMapper;
import com.varial.accounting.domain.payment.FinancePaymentSession;
import com.varial.accounting.domain.payment.GeneratePayment;
import com.varial.accounting.domain.payment.GeneratePaymentRemittance;
import com.varial.accounting.domain.payment.GeneratePaymentSession;
import com.varial.accounting.domain.payment.PaymentSessionOptions;
import com.varial.accounting.domain.payment.export.PaymentDetailsHolder;
import com.varial.accounting.domain.personalaccount.IPersonalAccount;
import com.varial.accounting.domain.personalaccount.IPersonalAccountBankAddress;
import com.varial.accounting.domain.personalaccount.PersonalAccount;
import com.varial.accounting.domain.personalaccount.PersonalAccountExceptionMapper;
import com.varial.accounting.domain.refusalreason.IRefusalReason;
import com.varial.accounting.domain.refusalreason.RefusalReasonExceptionMapper;
import com.varial.accounting.domain.sequenceno.ISequenceNo;
import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.iban.IBAN;
import com.varial.base.iban.IBANFactory;
import com.varial.base.types.date.DateHelper;
import com.varial.framework.basictypes.addresses.IPostalAddress;
import com.varial.framework.domain.country.CountryHelper;
import com.varial.framework.domain.country.ICountry;
import com.varial.framework.domain.payment.sepa.base.UnicodeCharacterEscapeHandler;
import com.varial.framework.domain.paymentbase.Payment;
import com.varial.framework.domain.paymentbase.PaymentExceptionMapper;
import com.varial.framework.domain.paymentbase.PaymentSession;
import com.varial.interfaces.IBankAccount;
import com.varial.interfaces.ICurrency;
import com.varial.serverbase.domain.language.ILanguage;
import com.varial.serverbase.domain.language.Language;
import com.varial.serverbase.domain.resource.TranslateableResourceList;
import com.varial.serverbase.domain.textoutput.OutputField;
import com.varial.serverbase.domain.textoutput.OutputLine;
import com.varial.serverbase.domain.textoutput.TextField;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaymentHelper {
    private static Logger LOGGER = LoggerFactory.getLogger((String)PaymentHelper.class.getName());
    private static TranslateableResourceList mGeneratePaymentTextList = TranslateableResourceList.createTranslateableResourceList((String)"GeneratePaymentTextList", (String[])new String[]{"Konto", "s. Avis zur Zahlung vom", "Bill Number"});

    private static String[] getFixedPaymentDetailsAsArray(Payment payment, int maxLines, int maxLineLength) {
        String[] result;
        if (payment.isGeneratePayment()) {
            GeneratePayment gp = (GeneratePayment)payment;
            return PaymentHelper.getReferencesRows(gp, maxLines, maxLineLength);
        }
        String reference = payment.getNote();
        String[] strings = StringMapper.split((String)reference, (int)maxLineLength);
        int extensionCount = strings.length - 1;
        if ((extensionCount = Math.min(extensionCount, maxLines)) == strings.length) {
            result = strings;
        } else {
            result = new String[extensionCount];
            System.arraycopy(strings, 0, result, 0, extensionCount);
        }
        return result;
    }

    public static String getReferencesRowWithCheckPaymentDetails(GeneratePayment gp, boolean checkOPPaymentDetails) {
        GeneratePaymentRemittance[] remittances = gp.getGeneratePaymentRemittances();
        String[] referenceIDs = new String[remittances.length];
        for (int i = 0; i < remittances.length; ++i) {
            String vz = remittances[i].getOpenItem().getDirectDebitOrPaymentDetails();
            referenceIDs[i] = checkOPPaymentDetails && !StringMapper.isNullString((String)vz) ? StringMapper.replaceAllSubString((String)vz, (String)"/", (String)"-") : StringMapper.replaceAllSubString((String)remittances[i].getOpenItem().getReferenceNumber(), (String)"/", (String)"-");
        }
        StringBuilder line = new StringBuilder();
        for (int i = 0; i < referenceIDs.length; ++i) {
            line.append(referenceIDs[i]);
            if (i >= referenceIDs.length - 1) continue;
            line.append('/');
        }
        return line.toString();
    }

    public static String getFixedPaymentDetailsAsString(GeneratePayment gp, int maxLineLength, boolean checkAdvice) {
        String[] references = PaymentHelper.getReferencesRowsWithCheckAdvice(gp, checkAdvice);
        return PaymentHelper.formatRemittancesToString(references, maxLineLength);
    }

    public static String[] getReferencesRowsWithCheckAdvice(GeneratePayment gp, boolean checkAdvice) {
        GeneratePaymentRemittance[] remittances = gp.getGeneratePaymentRemittances();
        Language language = gp.getPersonalAccount().getAccountingCompany().getDefaultLanguage();
        boolean advice = false;
        if (checkAdvice) {
            advice = PaymentHelper.isAdvice(gp);
        }
        Object ownNumberAtPartner = "";
        if (!StringMapper.isNullString((String)gp.getPersonalAccount().getOwnNumberAtPartner())) {
            ownNumberAtPartner = PaymentHelper.getDTA_VerwZweck(language, 0) + " " + gp.getPersonalAccount().getOwnNumberAtPartner();
        }
        String[] result = advice ? new String[2] : new String[remittances.length + 1];
        result[0] = StringMapper.toString((String)((String)ownNumberAtPartner + " "));
        if (advice) {
            result[1] = PaymentHelper.getDTA_VerwZweck(language, 1) + " " + DateMapper.toString((ILanguage)language, (Date)gp.getGeneratePaymentSession().getBaseDatePayment());
        } else {
            StringBuilder tmp = new StringBuilder();
            for (int i = 0; i < remittances.length; ++i) {
                String vz = remittances[i].getOpenItem().getDirectDebitOrPaymentDetails();
                if (!StringMapper.isNullString((String)vz)) {
                    tmp.append(StringMapper.replaceAllSubString((String)vz, (String)"/", (String)"-"));
                } else {
                    tmp.append(StringMapper.replaceAllSubString((String)PaymentHelper.getReference(remittances[i]), (String)"/", (String)"-"));
                    tmp.append(' ');
                    tmp.append(PaymentHelper.getFormattedAmount(remittances[i].getDiscountAmount(), gp.getCurrency()));
                    tmp.append(' ');
                    tmp.append(PaymentHelper.getFormattedAmount(remittances[i].getSettlementAmount(), gp.getCurrency()));
                }
                result[i + 1] = tmp.toString();
                tmp.delete(0, tmp.length());
                LOGGER.debug("ID  {}", (Object)result[i + 1]);
            }
        }
        return result;
    }

    public static String getReference(GeneratePaymentRemittance remittance) {
        String ksefNumber = remittance.getOpenItem().getKsefNumber();
        if (!StringMapper.isNullString((String)ksefNumber)) {
            return ksefNumber;
        }
        return remittance.getOpenItem().getReferenceNumber();
    }

    public static boolean isAdvice(GeneratePayment gp) {
        int entryLimit;
        boolean result = false;
        GeneratePaymentSession gps = gp.getGeneratePaymentSession();
        if (gps.getSplitPaymentType() != null && gps.getSplitPaymentType().value() == 0 && (entryLimit = gp.getGeneratePaymentSession().getEntryLimit()) > 0 && gp.getGeneratePaymentRemittances().length >= entryLimit) {
            result = true;
        }
        return result;
    }

    private static String[] getReferencesRows(GeneratePayment gp, int maxLines, int maxLineLength) {
        GeneratePaymentRemittance[] remittances = gp.getGeneratePaymentRemittances();
        String[] referenceIDs = new String[remittances.length];
        for (int i = 0; i < remittances.length; ++i) {
            referenceIDs[i] = StringMapper.replaceAllSubString((String)remittances[i].getOpenItem().getReferenceNumber(), (String)"/", (String)"-");
        }
        return PaymentHelper.formatRemittancesToArray(referenceIDs, maxLineLength, maxLines, "/", "...");
    }

    private static String formatRemittancesToString(String[] references, int maxLineLength) {
        StringBuilder line = new StringBuilder();
        line.append(references[0]);
        if (line.length() < maxLineLength) {
            for (int i = 1; i < references.length; ++i) {
                if (line.length() + references[i].length() > maxLineLength) continue;
                line.append(references[i]);
                if (line.length() >= maxLineLength || i >= references.length - 1) continue;
                boolean nextIsLast = i + 1 == references.length - 1;
                if (line.length() + references[i + 1].length() + (nextIsLast ? 1 : 4) <= maxLineLength) {
                    line.append('/');
                    continue;
                }
                line.append("/...");
                break;
            }
        }
        return StringMapper.toStringWithTrim((String)line.toString());
    }

    public static String[] formatRemittancesToArray(String[] references, int maxLineLength, int maxLines, String referenceSeparator, String endString) {
        int maxLength = maxLineLength * maxLines;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < references.length; ++i) {
            sb.append(references[i]);
            if (i >= references.length - 1 || references[i].endsWith(referenceSeparator)) continue;
            sb.append(referenceSeparator);
        }
        String resultString = sb.toString();
        if (resultString.length() > maxLength) {
            resultString = resultString.substring(0, maxLength - endString.length()).concat(endString);
        }
        String[] result = StringMapper.split((String)resultString, (int)maxLineLength);
        return result;
    }

    public static IBankData getBankData(Payment p) {
        IBankData bankdata = null;
        IPersonalAccountBankAddress pabankadress = PaymentHelper.getPersonalAccountBankAddress(p);
        if (pabankadress != null) {
            bankdata = PaymentHelper.getPersonalAccountBankAddress(p).getBankData();
        }
        return bankdata;
    }

    public static String getBankDataBIC(Payment p) {
        String bic = "";
        IPersonalAccountBankAddress pabankadress = PaymentHelper.getPersonalAccountBankAddress(p);
        if (pabankadress != null && pabankadress.getBankData() != null) {
            bic = pabankadress.getBankData().getBIC();
        }
        return bic;
    }

    public static IPostalAddress getPersonalAccountBankAddressAsPostalAddress(Payment payment) {
        IPostalAddress result = null;
        IPersonalAccountBankAddress personalAccountBankAddress = PaymentHelper.getPersonalAccountBankAddress(payment);
        if (personalAccountBankAddress != null) {
            result = personalAccountBankAddress.getBankData().getPostalAddress();
        }
        return result;
    }

    public static IPersonalAccountBankAddress getPersonalAccountBankAddress(Payment payment) {
        if (!payment.isFinancePayment()) {
            return null;
        }
        FinancePayment financePayment = (FinancePayment)payment;
        return PaymentHelper.getPersonalAccountBankAddress((IPersonalAccount)financePayment.getPersonalAccount(), payment.getBankAccountNumber(), payment.getShortAddressOwner(), payment.getSwift(), payment.getBankSortingCode(), payment.getPostChequeAccount(), financePayment.getSepaMandate(), financePayment.getSepaMandateDate());
    }

    public static IPersonalAccountBankAddress getPersonalAccountBankAddress(IPersonalAccount personalAccount, String bankAccountNumberPayment, String ibanPayment, String swiftPayment, String bankSortingCodePayment, String postChequeAccountPayment, String sepaMandatePayment, Date sepaMandateDatePayment) {
        IPersonalAccountBankAddress[] addresses = null;
        if (personalAccount != null) {
            addresses = personalAccount.getAllBankAddresses();
        }
        if (addresses == null || addresses.length == 0) {
            return null;
        }
        IPersonalAccountBankAddress result = null;
        IPersonalAccountBankAddress addressWithIbanAndAccountNumber = null;
        IPersonalAccountBankAddress addressWithBankSortingCodeAndAccountNumber = null;
        IPersonalAccountBankAddress addressWithSwiftAndAccountNumber = null;
        IPersonalAccountBankAddress addressWithIban = null;
        IPersonalAccountBankAddress addressWithIbanAndSwift = null;
        IPersonalAccountBankAddress addressWithSepaMandatAndIban = null;
        IPersonalAccountBankAddress addressWithPostChequeAccount = null;
        for (IPersonalAccountBankAddress bankAddress : addresses) {
            if (PaymentHelper.existentAndEqual(ibanPayment, bankAddress.getBankData().getOtherReference()) && PaymentHelper.existentAndEqual(bankAccountNumberPayment, bankAddress.getAccountNumber())) {
                addressWithIbanAndAccountNumber = bankAddress;
            }
            if (PaymentHelper.existentAndEqual(bankSortingCodePayment, bankAddress.getBankData().getBankSortingCode()) && PaymentHelper.existentAndEqual(bankAccountNumberPayment, bankAddress.getAccountNumber())) {
                addressWithBankSortingCodeAndAccountNumber = bankAddress;
            }
            if (PaymentHelper.existentAndEqual(swiftPayment, bankAddress.getBankData().getSwift()) && PaymentHelper.existentAndEqual(bankAccountNumberPayment, bankAddress.getAccountNumber())) {
                addressWithSwiftAndAccountNumber = bankAddress;
            }
            if (PaymentHelper.existentAndEqual(ibanPayment, bankAddress.getBankData().getOtherReference())) {
                addressWithIban = bankAddress;
            }
            if (PaymentHelper.existentAndEqual(swiftPayment, bankAddress.getBankData().getSwift()) && PaymentHelper.existentAndEqual(ibanPayment, bankAddress.getBankData().getOtherReference())) {
                addressWithIbanAndSwift = bankAddress;
            }
            if (PaymentHelper.existentAndEqual(sepaMandatePayment, bankAddress.getSepaMandate()) && PaymentHelper.existentAndEqual(ibanPayment, bankAddress.getBankData().getOtherReference()) && DateHelper.equal((Date)bankAddress.getSepaMandateDate(), (Date)sepaMandateDatePayment)) {
                addressWithSepaMandatAndIban = bankAddress;
            }
            if (!PaymentHelper.existentAndEqual(postChequeAccountPayment, bankAddress.getPostChequeAccount())) continue;
            addressWithPostChequeAccount = bankAddress;
        }
        if (addressWithPostChequeAccount != null) {
            result = addressWithPostChequeAccount;
        } else if (addressWithSepaMandatAndIban != null) {
            result = addressWithSepaMandatAndIban;
        } else if (addressWithIbanAndSwift != null) {
            result = addressWithIbanAndSwift;
        } else if (addressWithIban != null) {
            result = addressWithIban;
        } else if (addressWithSwiftAndAccountNumber != null) {
            result = addressWithSwiftAndAccountNumber;
        } else if (addressWithBankSortingCodeAndAccountNumber != null) {
            result = addressWithBankSortingCodeAndAccountNumber;
        } else if (addressWithIbanAndAccountNumber != null) {
            result = addressWithIbanAndAccountNumber;
        }
        return result;
    }

    private static boolean existentAndEqual(String value1, String value2) {
        boolean result = false;
        if (!StringMapper.isNullString((String)value1)) {
            result = StringMapper.equalWithTrim((String)value1, (String)value2);
        }
        return result;
    }

    public static IBankAccount getIBankAccount(PaymentSession paymentSession) {
        return paymentSession.getIBankAccount();
    }

    public static IPersonalAccountBankAddress getPersonalAccountDefaultBankAddress(PersonalAccount pa) throws BusinessDomainException {
        IPersonalAccountBankAddress result = null;
        if (pa != null) {
            if (pa.getDefaultBankAddress() != null) {
                result = pa.getDefaultBankAddress();
            } else {
                throw PersonalAccountExceptionMapper.makeDefaultBankAddressRequiredDomainException((String)pa.getCode());
            }
        }
        return result;
    }

    public static IPostalAddress getPersonalAccountDefaultBankAddressAsPostalAddress(PersonalAccount pa) throws BusinessDomainException {
        if (pa.getDefaultBankAddress() == null) {
            throw PersonalAccountExceptionMapper.makeDefaultBankAddressRequiredDomainException((String)pa.getCode());
        }
        return pa.getDefaultBankAddress().getBankData().getPostalAddress();
    }

    public static boolean isDirectDebit(PaymentSession paymentSession) {
        boolean result = true;
        result = PaymentHelper.isAdvancePaymentSession(paymentSession) ? false : ((GeneratePaymentSession)paymentSession).getIsDirectDebit();
        return result;
    }

    public static Payment[] getPayments(PaymentSession paymentSession, boolean isDirectDebit) {
        Payment[] result = null;
        result = isDirectDebit ? paymentSession.getPaymentsForDirectDebit() : paymentSession.getPaymentsForBacs();
        return result;
    }

    public static Number[] getNoticeData(Payment[] payments) {
        Number[] numbers = new Number[3];
        BigDecimal paymentSum = BigDecimal.ZERO;
        BigInteger bankSortingCodeSum = BigInteger.ZERO;
        BigInteger bankAccountNumberSum = BigInteger.ZERO;
        for (int j = 0; j < payments.length; ++j) {
            paymentSum = paymentSum.add(payments[j].getAmount());
            bankSortingCodeSum = bankSortingCodeSum.add(new BigInteger(StringMapper.makeDecimalString((String)payments[j].getBankSortingCode())));
            bankAccountNumberSum = bankAccountNumberSum.add(new BigInteger(StringMapper.makeDecimalString((String)payments[j].getBankAccountNumber())));
        }
        numbers[0] = paymentSum;
        numbers[1] = bankSortingCodeSum;
        numbers[2] = bankAccountNumberSum;
        return numbers;
    }

    private static GeneratePaymentRemittance[] getRemittances(GeneratePayment gp) {
        if (gp == null) {
            return null;
        }
        return gp.getGeneratePaymentRemittances();
    }

    public static GeneratePayment getGeneratePayment(Payment payment) {
        if (payment.isGeneratePayment()) {
            return (GeneratePayment)payment;
        }
        return null;
    }

    public static PersonalAccount getPersonalAccount(Payment p) {
        if (p.isFinancePayment()) {
            return ((FinancePayment)p).getPersonalAccount();
        }
        return null;
    }

    public static CustSupAddress getCustSupAddress(Payment payment) {
        CustSupAddress result = null;
        PersonalAccount pa = PaymentHelper.getPersonalAccount(payment);
        if (pa != null) {
            GeneratePaymentRemittance[] remittances;
            if (!pa.getOneOffAccount()) {
                result = pa.getDeviatingAddress() == null ? pa.getAddress() : pa.getDeviatingAddress();
            } else if (payment.isGeneratePayment() && (remittances = PaymentHelper.getRemittances((GeneratePayment)payment)) != null) {
                result = remittances[0].getOpenItem().getOneOffAccountAddress();
            }
        }
        return result;
    }

    public static String getPaymentBankDeviatingOwner(Payment payment) {
        if (payment.isAdvancePayment()) {
            return ((AdvancePayment)payment).getDeviatingOwner();
        }
        IPersonalAccountBankAddress bankAddress = PaymentHelper.getPersonalAccountBankAddress(payment);
        return bankAddress != null ? bankAddress.getDeviatingOwner() : "";
    }

    public static String getDTA_VerwZweck(Language language, int pos) {
        return mGeneratePaymentTextList.getString((ILanguage)language, pos);
    }

    public static String[] getFreePaymentDetailsAsArray(GeneratePayment gp, PaymentDetailsHolder paymentDetailsHolder, int maxLineLength, int maxLines) throws BusinessDomainException {
        ArrayList<String> lineList = new ArrayList<String>();
        GeneratePaymentRemittance[] remittances = gp.getGeneratePaymentRemittances();
        Language language = PaymentHelper.getPaymentDetailsLanguage(gp);
        boolean advice = PaymentHelper.isAdvice(gp);
        String line1 = "";
        String line2n = "";
        String noteOnRemittanceAdvice = "";
        String resultString = "";
        String DELIMITER = "/";
        if (paymentDetailsHolder != null) {
            int i;
            if (paymentDetailsHolder.getLine1() != null) {
                PaymentHelper.checkLanguage(paymentDetailsHolder.getLine1(), language);
                line1 = paymentDetailsHolder.getLine1().getDescription((ILanguage)language);
                resultString = PaymentDetailsHolder.replacePlaceholder((String)line1, (GeneratePaymentRemittance)remittances[0]);
                resultString = resultString.concat("/");
                lineList.add(resultString);
            }
            if (advice && paymentDetailsHolder.getNoteOnRemittanceAdvice() != null) {
                PaymentHelper.checkLanguage(paymentDetailsHolder.getNoteOnRemittanceAdvice(), language);
                noteOnRemittanceAdvice = paymentDetailsHolder.getNoteOnRemittanceAdvice().getDescription((ILanguage)language);
                lineList.add(PaymentDetailsHolder.replacePlaceholder((String)noteOnRemittanceAdvice, (GeneratePaymentRemittance)remittances[0]));
            } else if (paymentDetailsHolder.getAsPerOpenItem().booleanValue()) {
                for (i = 0; i < remittances.length; ++i) {
                    resultString = remittances[i].getOpenItem().getDirectDebitOrPaymentDetails();
                    lineList.add(resultString);
                }
            } else if (paymentDetailsHolder.getLine2n() != null) {
                PaymentHelper.checkLanguage(paymentDetailsHolder.getLine2n(), language);
                line2n = paymentDetailsHolder.getLine2n().getDescription((ILanguage)language);
                for (i = 0; i < remittances.length; ++i) {
                    resultString = PaymentDetailsHolder.replacePlaceholder((String)line2n, (GeneratePaymentRemittance)remittances[i]);
                    lineList.add(resultString);
                }
            }
        }
        String[] result = new String[lineList.size()];
        lineList.toArray(result);
        return PaymentHelper.formatRemittancesToArray(result, maxLineLength, maxLines, "/", "...");
    }

    private static void checkLanguage(IRefusalReason line, Language language) throws BusinessDomainException {
        if (line.getDescription((ILanguage)language) == null || StringMapper.isNullString((String)line.getDescription((ILanguage)language))) {
            throw RefusalReasonExceptionMapper.makeMissingDescriptionForLanguageDomainException((String)language.getCode());
        }
    }

    public static Language getPaymentDetailsLanguage(GeneratePayment gp) {
        Language result = gp.getPaymentSession().getCompany().getDefaultLanguage();
        CustSupAddress custSupAddress = PaymentHelper.getCustSupAddress(gp);
        if (custSupAddress != null && custSupAddress.getCorrespondenceLanguage() != null && custSupAddress.getCorrespondenceLanguage().isUsedForLocalizedString()) {
            result = custSupAddress.getCorrespondenceLanguage();
        }
        return result;
    }

    public static String getFreePaymentDetailsAsString(GeneratePayment gp, PaymentDetailsHolder paymentDetailsHolder, int maxLineLengthFreetext) throws BusinessDomainException {
        String[] detalStrings = PaymentHelper.getFreePaymentDetailsAsArray(gp, paymentDetailsHolder, maxLineLengthFreetext, 1);
        StringBuilder sb = new StringBuilder();
        for (String detail : detalStrings) {
            sb.append(detail).append(' ');
        }
        return sb.toString();
    }

    public static String getFixedOrFreePaymentDetailsAsString(Payment payment, int maxLineLength, boolean checkAdvice, PaymentDetailsHolder paymentDetailsHolder) throws BusinessDomainException {
        String result = "";
        if (payment.isGeneratePayment()) {
            GeneratePayment gp = (GeneratePayment)payment;
            result = paymentDetailsHolder == null ? PaymentHelper.getFixedPaymentDetailsAsString(gp, maxLineLength, checkAdvice) : PaymentHelper.getFreePaymentDetailsAsString(gp, paymentDetailsHolder, maxLineLength);
        } else {
            result = payment.getPaymentNote();
        }
        return StringMapper.toStringWithTrim((String)result);
    }

    public static String[] getFixedOrFreePaymentDetailsAsArray(Payment payment, int maxLineLength, int maxLines, PaymentDetailsHolder paymentDetailsHolder) throws BusinessDomainException {
        String[] result = new String[1];
        if (paymentDetailsHolder == null) {
            result = PaymentHelper.getFixedPaymentDetailsAsArray(payment, maxLines, maxLineLength);
        } else if (payment.isGeneratePayment()) {
            result = PaymentHelper.getFreePaymentDetailsAsArray((GeneratePayment)payment, paymentDetailsHolder, maxLineLength, maxLines);
        }
        return result;
    }

    public static PaymentDetailsHolder getPaymentDetailsHolder(PaymentSession paymentSession) {
        PaymentSessionOptions options;
        GeneratePaymentSession gps;
        PaymentDetailsHolder result = null;
        if (PaymentHelper.isGeneratePaymentSession(paymentSession) && !(gps = (GeneratePaymentSession)paymentSession).getIsBillPayable() && !gps.getIsBillReceivable() && (options = ((GeneratePaymentSession)paymentSession).getOptions()) != null) {
            result = options.getPaymentDetailsHolder();
        }
        return result;
    }

    public static boolean getSplitEcTransfer(PaymentSession paymentSession) {
        if (PaymentHelper.isGeneratePaymentSession(paymentSession)) {
            return ((GeneratePaymentSession)paymentSession).getSplitEcTransfer();
        }
        return false;
    }

    public static void checkIsForeignPayment(PaymentSession paymentSession, PaymentSession firstPaymentSession) {
        if (paymentSession.getIsForeignPayment() != firstPaymentSession.getIsForeignPayment()) {
            throw ExceptionMapper.makeApplicationException((String)"Wrong payment type");
        }
    }

    public static String getFormattedAmount(BigDecimal amount, ICurrency currency) {
        return BigDecimalMapper.toString((BigDecimal)currency.round(amount));
    }

    public static GeneratePaymentRemittance getFirstRemittance(Payment payment) {
        GeneratePaymentRemittance[] remittances;
        GeneratePaymentRemittance result = null;
        GeneratePayment gp = PaymentHelper.getGeneratePayment(payment);
        if (gp != null && (remittances = gp.getGeneratePaymentRemittances()) != null && remittances.length > 0) {
            result = remittances[0];
        }
        return result;
    }

    public static boolean isForeignPayment(PaymentSession exportPaymentSession) {
        return PaymentHelper.isGeneratePaymentSession(exportPaymentSession) && ((GeneratePaymentSession)exportPaymentSession).getIsForeignPayment() && !((GeneratePaymentSession)exportPaymentSession).isSplitPayment();
    }

    public static boolean isGeneratePaymentSession(PaymentSession paymentSession) {
        return paymentSession instanceof GeneratePaymentSession;
    }

    public static boolean isAdvancePaymentSession(PaymentSession paymentSession) {
        return paymentSession instanceof AdvancePaymentSession;
    }

    public static OutputLine getOutputLine(List<OutputField> fieldList) {
        OutputField[] result = new OutputField[fieldList.size()];
        fieldList.toArray(result);
        return new OutputLine(result);
    }

    public static ICurrency getBaseCurrency(PaymentSession paymentSession) {
        if (PaymentHelper.isGeneratePaymentSession(paymentSession)) {
            AccountingCompany company = ((GeneratePaymentSession)paymentSession).getAccountingCompany();
            return company.getFinanceSetup().getBaseCurrency();
        }
        if (PaymentHelper.isAdvancePaymentSession(paymentSession)) {
            AccountingCompany company = ((AdvancePaymentSession)paymentSession).getAccountingCompany();
            return company.getFinanceSetup().getBaseCurrency();
        }
        return null;
    }

    public static String formatSWIFTForMulticash(String swift) {
        String result = "";
        if (!StringMapper.isNullString((String)swift)) {
            if (swift.length() <= 8) {
                result = new TextField(8, 'X', true, 0, swift).getAsString();
                result = result.concat("AXXX");
            } else {
                result = new TextField(12, 'X', true, 0, swift).getAsString();
            }
        }
        return result;
    }

    public static Payment[] splitAWVCodes(Payment[] payments) throws BusinessDomainException {
        if (payments.length <= 0) {
            return payments;
        }
        ArrayList<GeneratePayment> resultList = new ArrayList<GeneratePayment>();
        for (Payment payment : payments) {
            if (!payment.isGeneratePayment()) continue;
            Map<String, List<GeneratePaymentRemittance>> serviceTypeAWVMap = PaymentHelper.getAWVRemittancesMap(payment);
            Map.Entry<String, List<GeneratePaymentRemittance>> entry = null;
            Iterator<Map.Entry<String, List<GeneratePaymentRemittance>>> iter = serviceTypeAWVMap.entrySet().iterator();
            List<GeneratePaymentRemittance> newRemittanceList = null;
            GeneratePaymentRemittance[] newRemittances = null;
            while (iter.hasNext()) {
                entry = iter.next();
                GeneratePayment newPayment = ((GeneratePayment)payment).getAReadOnlyCopyWithoutRemittances();
                newRemittanceList = entry.getValue();
                newRemittances = new GeneratePaymentRemittance[newRemittanceList.size()];
                newRemittances = newRemittanceList.toArray(newRemittances);
                newPayment.setGeneratePaymentRemittances(newRemittances);
                BigDecimal newAmount = BigDecimal.ZERO;
                for (GeneratePaymentRemittance remittance : newRemittances) {
                    newAmount = newAmount.add(remittance.getSettlementAmount());
                    if (BigDecimalMapper.isZeroOrNull((BigDecimal)remittance.getDiscountAmount())) continue;
                    newAmount = newAmount.subtract(remittance.getDiscountAmount());
                }
                newPayment.setECAmount(newAmount);
                resultList.add(newPayment);
            }
        }
        Payment[] result = new Payment[resultList.size()];
        result = resultList.toArray(result);
        return result;
    }

    private static void updateAWVTotalAmountsMap(Map<String, BigDecimal> map, GeneratePaymentRemittance remittance) throws BusinessDomainException {
        String key = "   ";
        if (remittance.getOpenItem().getServiceTypeAWV() != null && !StringMapper.isNullString((String)remittance.getOpenItem().getServiceTypeAWV().getAWVCode())) {
            key = remittance.getOpenItem().getServiceTypeAWV().getAWVCode();
        }
        BigDecimal paymentAmount = remittance.getSettlementAmount();
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)remittance.getDiscountAmount())) {
            paymentAmount = paymentAmount.subtract(remittance.getDiscountAmount());
        }
        if (map.containsKey(key)) {
            BigDecimal amount = map.get(key);
            amount = amount.add(paymentAmount);
            map.remove(key);
            map.put(key, amount);
        } else {
            map.put(key, paymentAmount);
        }
    }

    private static void updateAWVRemittanceMap(Map<String, List<GeneratePaymentRemittance>> map, GeneratePaymentRemittance remittance) throws BusinessDomainException {
        String key = "   ";
        if (remittance.getOpenItem().getServiceTypeAWV() != null && !StringMapper.isNullString((String)remittance.getOpenItem().getServiceTypeAWV().getAWVCode())) {
            key = remittance.getOpenItem().getServiceTypeAWV().getAWVCode();
        }
        List<Object> remittances = null;
        if (map.containsKey(key)) {
            remittances = map.get(key);
            remittances.add(remittance);
        } else {
            remittances = new ArrayList();
            remittances.add(remittance);
            map.put(key, remittances);
        }
    }

    public static Map<String, BigDecimal> getAWVTotalAmountsMap(Payment payment) throws BusinessDomainException {
        TreeMap<String, BigDecimal> result = new TreeMap<String, BigDecimal>();
        if (payment.isGeneratePayment()) {
            GeneratePaymentRemittance[] remittances;
            for (GeneratePaymentRemittance remittance : remittances = PaymentHelper.getGeneratePayment(payment).getGeneratePaymentRemittances()) {
                PaymentHelper.updateAWVTotalAmountsMap(result, remittance);
            }
        }
        return result;
    }

    public static Map<String, List<GeneratePaymentRemittance>> getAWVRemittancesMap(Payment payment) throws BusinessDomainException {
        TreeMap<String, List<GeneratePaymentRemittance>> result = new TreeMap<String, List<GeneratePaymentRemittance>>();
        if (payment.isGeneratePayment()) {
            GeneratePaymentRemittance[] remittances;
            for (GeneratePaymentRemittance remittance : remittances = PaymentHelper.getGeneratePayment(payment).getGeneratePaymentRemittances()) {
                PaymentHelper.updateAWVRemittanceMap(result, remittance);
            }
        }
        return result;
    }

    public static TranslateableResourceList getGeneratePaymentTextList() {
        return mGeneratePaymentTextList;
    }

    public static String convertChar(String stringValue) {
        return new UnicodeCharacterEscapeHandler().checkField(stringValue.toCharArray());
    }

    public static String getIbanForPrintFormat(String validIBAN) {
        IBAN iban;
        String result = validIBAN;
        if (!StringMapper.isNullString((String)validIBAN) && (iban = PaymentHelper.getIban(validIBAN)) != null) {
            result = iban.toPrintFormat();
        }
        return result;
    }

    public static String getIbanForElectronicFormat(String validIBAN) {
        IBAN iban;
        String result = validIBAN;
        if (!StringMapper.isNullString((String)validIBAN) && (iban = PaymentHelper.getIban(validIBAN)) != null) {
            result = iban.toElectronicFormat();
        }
        return result;
    }

    private static IBAN getIban(String ibanString) {
        try {
            IBANFactory factory = (IBANFactory)UtilitiesManager.getBean((String)"ibanFactory", IBANFactory.class);
            return factory.create(ibanString, false);
        }
        catch (Exception e) {
            ExceptionMapper.printException((Throwable)e);
            return null;
        }
    }

    public static boolean checkSepaSwift(String swift, BankAccount bankAccount, ICountry paymentCountry) {
        if (!StringMapper.isNullString((String)swift)) {
            return true;
        }
        ICountry bankCountry = bankAccount.getCountry();
        return paymentCountry != null && bankCountry != null && (paymentCountry.equals(bankCountry) || PaymentHelper.isSepaCountry(paymentCountry) && PaymentHelper.isSepaCountry(bankCountry));
    }

    public static boolean isSepaPayment(FinancePaymentSession paymentSession, BankAccount bankAccount, ICurrency paymentCurrency, ICountry paymentCountry, String paymentIban, String paymentSwift, String paymentSepaMandate, Date paymentSepaMandateDate) {
        boolean isSepaPayment;
        boolean bl = isSepaPayment = PaymentHelper.meetsBasicSepaCriteria(paymentSession, paymentCurrency, bankAccount, paymentCountry) && !StringMapper.isNullString((String)paymentIban) && PaymentHelper.checkSepaSwift(paymentSwift, bankAccount, paymentCountry);
        if (isSepaPayment && PaymentHelper.isDirectDebit((PaymentSession)paymentSession) && (StringMapper.isNullString((String)paymentSession.getAccountingCompany().getUniqueCreditorIdent()) || paymentSepaMandateDate == null || StringMapper.isNullString((String)paymentSepaMandate))) {
            isSepaPayment = false;
        }
        return isSepaPayment;
    }

    public static boolean meetsBasicSepaCriteria(FinancePaymentSession session, ICurrency paymentCurrency, BankAccount bankAccount, ICountry paymentCountry) {
        boolean isEuro = paymentCurrency.isTheEuro();
        boolean bankAccountGeneratesSepa = bankAccount.getGenerateSepa();
        boolean countryIsInSepaArea = PaymentHelper.isSepaCountry(paymentCountry);
        boolean isNotSwissDomesticPayment = !PaymentHelper.isSwissDomesticPayment(bankAccount, paymentCountry);
        boolean sessionAllowsSepa = session.getGenerateSepa();
        return sessionAllowsSepa && isEuro && bankAccountGeneratesSepa && countryIsInSepaArea && isNotSwissDomesticPayment;
    }

    public static boolean isSepaCountry(ICountry country) {
        return country != null && country.hasSepaCodeSet();
    }

    private static boolean isSwissDomesticPayment(BankAccount bankAccount, ICountry bankCountry) {
        return CountryHelper.isCH((ICountry)bankAccount.getCountry()) && CountryHelper.isCH((ICountry)bankCountry);
    }

    public static boolean isCreditNote(GeneratePaymentSession session, OpenItem openItem) {
        boolean isDebit = openItem.getIsDebit();
        boolean isCreditNote = session.isPayment() ? isDebit : !isDebit;
        return isCreditNote;
    }

    public static String getFileUniqueReferenceViaSequenceNumber(PaymentSession paymentSession) throws BusinessDomainException {
        ISequenceNo sequenceNo = ((BankAccountPersistencyManager)UtilitiesManager.getBean((String)"bankAccountPersistencyManager", BankAccountPersistencyManager.class)).getBankAccount(paymentSession.getIBankAccount().getObjectid()).getSequenceNoDirectDebitFile();
        if (sequenceNo == null) {
            throw FinancePaymentExceptionMapper.makeMissingSequenceNoForDirectDebitInstructionFileDomainException((String)paymentSession.getIBankAccount().getCode());
        }
        Date referenceDate = paymentSession.getCreationDate();
        FinancialYear financialYear = AccountingCompanyPersistencyManager.getAccountingCompany((String)paymentSession.getIBankAccount().getCompany().getObjectid()).getFinancialYear(referenceDate);
        if (financialYear == null) {
            throw PaymentExceptionMapper.makeNoFinancialYearDomainException();
        }
        return sequenceNo.getNextNumber(financialYear, referenceDate, false);
    }

    public static ICustSupAddress getAddress(Payment payment) {
        if (!payment.isFinancePayment()) {
            return null;
        }
        PersonalAccount personalAccount = ((FinancePayment)payment).getPersonalAccount();
        if (personalAccount == null) {
            return null;
        }
        if (!personalAccount.getOneOffAccount()) {
            return personalAccount.getAddress();
        }
        if (payment.isGeneratePayment()) {
            return ((GeneratePayment)payment).getOneOffAddress();
        }
        return null;
    }

    public static List<Payment> getPayments(PaymentSession[] paymentSessions, boolean directDebit) {
        return Arrays.stream(paymentSessions).flatMap(paymentSession -> Arrays.stream(PaymentHelper.getPayments(paymentSession, directDebit))).collect(Collectors.toList());
    }

    public static BigDecimal getTotalOfPayments(List<Payment> payments) {
        BigDecimal totalOfPayments = BigDecimal.ZERO;
        for (Payment payment : payments) {
            totalOfPayments = BigDecimalMapper.add((BigDecimal)totalOfPayments, (BigDecimal)payment.getAmount());
        }
        return totalOfPayments;
    }

    public static Date getExecuteDate(PaymentSession[] paymentSessions) {
        if (paymentSessions == null || paymentSessions.length == 0) {
            return null;
        }
        return paymentSessions[0].getExecuteDate() != null ? paymentSessions[0].getExecuteDate() : DateHelper.today();
    }
}

