/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.payment;

import com.varial.accounting.domain.bankaccount.BankAccount;
import com.varial.accounting.domain.payment.FinancePayment;
import com.varial.accounting.domain.payment.FinancePaymentExceptionMapper;
import com.varial.accounting.domain.payment.FinancePaymentSession;
import com.varial.accounting.domain.payment.FinancePaymentUtils;
import com.varial.accounting.domain.payment.GeneratePayment;
import com.varial.accounting.domain.payment.GeneratePaymentSession;
import com.varial.accounting.domain.payment.PaymentHelper;
import com.varial.accounting.domain.payment.PaymentSessionBankAccount;
import com.varial.accounting.domain.payment.PaymentSessionBankAccountUtils;
import com.varial.accounting.domain.payment.PaymentTypeUtils;
import com.varial.accounting.domain.payment.SplitPayment;
import com.varial.accounting.domain.payment.SplitPaymentHelper;
import com.varial.accounting.payment.BankAccountModeOfPaymentEnum;
import com.varial.base.exception.BusinessDomainException;
import com.varial.framework.domain.country.CountryHelper;
import com.varial.framework.domain.country.ICountry;
import com.varial.framework.domain.paymentbase.ModeOfPayment;
import com.varial.framework.domain.paymentbase.Payment;
import com.varial.interfaces.ICurrency;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.persistency.IPersistentObject;
import com.varial.serverbase.persistency.PersistentObjectUtils;
import java.math.BigDecimal;

public class GeneratePaymentBankAccountManager {
    public void reassignBankAccounts(GeneratePaymentSession session) throws BusinessDomainException {
        this.reassignBankAccounts(session, session.getGeneratePayments());
    }

    public void reassignBankAccounts(GeneratePaymentSession session, GeneratePayment[] generatePayments) throws BusinessDomainException {
        PaymentSessionBankAccount[] paymentSessionBankAccounts;
        for (PaymentSessionBankAccount paymentSessionBankAccount : paymentSessionBankAccounts = session.getPaymentSessionBankAccounts()) {
            paymentSessionBankAccount.makeSaveable();
            paymentSessionBankAccount.setTotalOfPayments(null);
        }
        for (GeneratePayment generatePayment : generatePayments) {
            boolean bankAccountHasChanged;
            BigDecimal newTotal;
            boolean stop;
            BankAccount oldBankAccount = generatePayment.getBankAccount();
            PaymentSessionBankAccount sessionBankAccount = this.getValidBankAccount(session, null, generatePayment);
            if (sessionBankAccount == null) {
                throw this.makeNoBankAccountAvailableException(generatePayment);
            }
            do {
                newTotal = this.getNewTotalOfPayments(sessionBankAccount, generatePayment);
                boolean bl = stop = sessionBankAccount.getMaxTotalOfPayments() == null || newTotal.compareTo(sessionBankAccount.getMaxTotalOfPayments()) <= 0;
                if (stop) continue;
                PaymentSessionBankAccount next = this.getValidBankAccount(session, sessionBankAccount, generatePayment);
                if (next != null) {
                    sessionBankAccount = next;
                    continue;
                }
                stop = true;
            } while (!stop);
            sessionBankAccount.setTotalOfPayments(newTotal);
            boolean bl = bankAccountHasChanged = !oldBankAccount.equals((Object)sessionBankAccount.getBankAccount());
            if (bankAccountHasChanged) {
                generatePayment.makeSaveable();
                generatePayment.setPaymentSessionBankAccount(sessionBankAccount);
            }
            this.reassignBankAccountOfSplitPayment(session, generatePayment, bankAccountHasChanged);
        }
    }

    private void reassignBankAccountOfSplitPayment(GeneratePaymentSession session, GeneratePayment generatePayment, boolean bankAccountOfNetPaymentHasChanged) throws BusinessDomainException {
        BankAccount splitPaymentBankAccount;
        if (generatePayment.getSplitPayment() == null) {
            return;
        }
        BankAccount bankAccount = splitPaymentBankAccount = bankAccountOfNetPaymentHasChanged ? SplitPaymentHelper.getBankAccountForSplitPayment((BankAccount)generatePayment.getBankAccount()) : generatePayment.getSplitPayment().getBankAccount();
        if (splitPaymentBankAccount == null) {
            throw FinancePaymentExceptionMapper.makeMissingBankAccountForSplitPaymentDomainException();
        }
        PaymentSessionBankAccount paymentSessionBankAccount = this.getSplitPaymentBankAccountWithCreation(session, splitPaymentBankAccount);
        paymentSessionBankAccount.addToTotalOfPayments((FinancePayment)generatePayment.getSplitPayment());
        if (!PersistentObjectUtils.haveEqualObjectids((IPersistentObject)splitPaymentBankAccount, (IPersistentObject)generatePayment.getSplitPayment().getBankAccount())) {
            generatePayment.getSplitPayment().makeSaveable();
            generatePayment.getSplitPayment().setBankAccount(splitPaymentBankAccount);
        }
    }

    private BusinessDomainException makeNoBankAccountAvailableException(GeneratePayment payment) {
        String persAccCode = StringMapper.toString((String)payment.getPersonalAccount().getCode());
        switch (payment.getTypeOfPayment()) {
            case BACS: {
                return FinancePaymentExceptionMapper.makeNoBankAccountForPaymentsViaBacsDomainException((String)persAccCode);
            }
            case BACS_BILL_OF_EXCHANGE: {
                return FinancePaymentExceptionMapper.makeNoBankAccountForPaymentsViaBacsDomainException((String)persAccCode);
            }
            case BANK_COLLECTION: {
                return FinancePaymentExceptionMapper.makeNoBankAccountForPaymentsViaBankCollectionDomainException((String)persAccCode);
            }
            case DIRECT_DEBIT: {
                return FinancePaymentExceptionMapper.makeNoBankAccountForPaymentsViaDirectDebitDomainException((String)persAccCode);
            }
            case DIRECT_DEBIT_ANTICIPATED: {
                return FinancePaymentExceptionMapper.makeNoBankAccountForPaymentsViaDirectDebitDomainException((String)persAccCode);
            }
            case CHECK: {
                return FinancePaymentExceptionMapper.makeNoBankAccountForPaymentsViaChequeDomainException((String)persAccCode);
            }
            case CHECK_BILL_OF_EXCHANGE: {
                return FinancePaymentExceptionMapper.makeNoBankAccountForPaymentsViaChequeDomainException((String)persAccCode);
            }
            case BILL_OF_EXCHANGE: {
                return FinancePaymentExceptionMapper.makeNoBankAccountForBillOfExchangeDomainException((String)persAccCode);
            }
            case BILL_WITHOUT_ACCEPTANCE: {
                return FinancePaymentExceptionMapper.makeNoBankAccountForBillOfExchangeAcceptedDomainException((String)persAccCode);
            }
        }
        return FinancePaymentExceptionMapper.makeNoBankAccountForPaymentsWithPaymentTypeUnknownDomainException((String)persAccCode);
    }

    private BankAccountModeOfPaymentEnum toBankAccountModeOfPayment(ModeOfPayment paymentType) {
        switch (paymentType) {
            case BACS: {
                return BankAccountModeOfPaymentEnum.BAMPE_BACS;
            }
            case BACS_BILL_OF_EXCHANGE: {
                return BankAccountModeOfPaymentEnum.BAMPE_BACS_BILLOFEXCHANGE;
            }
            case CHECK: {
                return BankAccountModeOfPaymentEnum.BAMPE_CHEQUE;
            }
            case CHECK_BILL_OF_EXCHANGE: {
                return BankAccountModeOfPaymentEnum.BAMPE_CHEQUE_BILLOFEXCHANGE;
            }
            case BANK_COLLECTION: {
                return BankAccountModeOfPaymentEnum.BAMPE_BANKCOLLECTION;
            }
            case DIRECT_DEBIT: {
                return BankAccountModeOfPaymentEnum.BAMPE_DIRECTDEBIT;
            }
            case DIRECT_DEBIT_ANTICIPATED: {
                return BankAccountModeOfPaymentEnum.BAMPE_DIRECTDEBIT;
            }
            case BILL_OF_EXCHANGE: {
                return BankAccountModeOfPaymentEnum.BAMPE_BILLOFEXCHANGE;
            }
            case BILL_WITHOUT_ACCEPTANCE: {
                return BankAccountModeOfPaymentEnum.BAMPE_BILLOFEXCHANGE_ACCEPTED;
            }
        }
        return BankAccountModeOfPaymentEnum.BAMPE_ALL;
    }

    private BigDecimal getNewTotalOfPayments(PaymentSessionBankAccount sessionBankAccount, GeneratePayment payment) {
        BigDecimal amountOfPayment = sessionBankAccount.getAmountOfPayment((FinancePayment)payment);
        BigDecimal result = sessionBankAccount.getTotalOfPayments();
        if (result == null) {
            result = amountOfPayment;
        } else if (amountOfPayment != null) {
            result = result.add(amountOfPayment);
        }
        return result;
    }

    public void checkPaymentSessionBankAccount(GeneratePaymentSession session, GeneratePayment payment) throws BusinessDomainException {
        PaymentSessionBankAccount sessionBankAccount = payment.getPaymentSessionBankAccount();
        if (sessionBankAccount == null || !this.matchesBankAccountPaymentMode(sessionBankAccount.getBankAccountModeOfPayment(), payment.getTypeOfPayment())) {
            PaymentSessionBankAccount next = this.getValidBankAccount(session, sessionBankAccount, payment);
            payment.setPaymentSessionBankAccount(next);
            sessionBankAccount = next;
        }
        if (sessionBankAccount != null) {
            BigDecimal newTotal;
            boolean stop;
            do {
                newTotal = this.getNewTotalOfPayments(sessionBankAccount, payment);
                boolean bl = stop = sessionBankAccount.getMaxTotalOfPayments() == null || newTotal.compareTo(sessionBankAccount.getMaxTotalOfPayments()) <= 0;
                if (stop) continue;
                PaymentSessionBankAccount next = this.getValidBankAccount(session, sessionBankAccount, payment);
                if (next != null) {
                    sessionBankAccount = next;
                    continue;
                }
                stop = true;
            } while (!stop);
            sessionBankAccount.makeSaveable();
            sessionBankAccount.setTotalOfPayments(newTotal);
            payment.setPaymentSessionBankAccount(sessionBankAccount);
            if (payment.getSplitPayment() != null) {
                this.addSplitPayment(session, payment.getSplitPayment());
            }
        }
    }

    private boolean isCurrencyAllowed(PaymentSessionBankAccount sessionBankAccount, ICurrency paymentCurrency, boolean isForeignPayment) {
        BankAccount bankAccount = sessionBankAccount.getBankAccount();
        ICurrency bankCurrency = bankAccount.getCurrency();
        boolean isForeignBankAccount = bankAccount.isForeignBankAccount();
        if (isForeignBankAccount && !paymentCurrency.equals(bankCurrency)) {
            return false;
        }
        if (isForeignPayment) {
            if (isForeignBankAccount) {
                return paymentCurrency.equals(bankCurrency);
            }
            return this.matchesOpenItemCurrency(sessionBankAccount, paymentCurrency);
        }
        return paymentCurrency.equals(bankCurrency) || this.isSwissEuroPayment(sessionBankAccount, paymentCurrency);
    }

    private boolean isSwissEuroPayment(PaymentSessionBankAccount sessionBankAccount, ICurrency paymentCurrency) {
        return !sessionBankAccount.getBankAccount().isForeignBankAccount() && paymentCurrency.isTheEuro() && CountryHelper.isCH((ICountry)sessionBankAccount.getBankAccount().getCountry());
    }

    private PaymentSessionBankAccount getValidBankAccount(GeneratePaymentSession paymentSession, PaymentSessionBankAccount oldSessionBankAccount, GeneratePayment generatePayment) {
        PaymentSessionBankAccount result = null;
        PaymentSessionBankAccount[] sessionBankAccounts = PaymentSessionBankAccountUtils.getPaymentSessionBankAccounts((FinancePaymentSession)paymentSession, (Payment.PaymentType)Payment.PaymentType.GENERATE_PAYMENT);
        int i = 0;
        if (oldSessionBankAccount != null) {
            i = oldSessionBankAccount.getSortNo() + 1;
        }
        while (i < sessionBankAccounts.length) {
            if (this.isValidBankAccount(sessionBankAccounts[i], paymentSession, generatePayment)) {
                result = sessionBankAccounts[i];
                break;
            }
            ++i;
        }
        return result;
    }

    public boolean isValidBankAccount(PaymentSessionBankAccount sessionBankAccount, ICurrency openItemCurrency, ICountry openItemCountry, GeneratePaymentSession paymentSession, ModeOfPayment paymentType) {
        return this.isBankAccountValidForPayment(sessionBankAccount, openItemCurrency, paymentSession, paymentType, openItemCountry, false);
    }

    public boolean isValidBankAccount(PaymentSessionBankAccount sessionBankAccount, GeneratePaymentSession paymentSession, GeneratePayment payment) {
        return this.isBankAccountValidForPayment(sessionBankAccount, payment.getCurrency(), paymentSession, payment.getTypeOfPayment(), payment.getBankCountry(), true);
    }

    private boolean isBankAccountValidForPayment(PaymentSessionBankAccount sessionBankAccount, ICurrency openItemCurrency, GeneratePaymentSession paymentSession, ModeOfPayment paymentType, ICountry openItemCountry, boolean validatePaymentType) {
        BankAccount bankAccount = sessionBankAccount.getBankAccount();
        if (bankAccount.isForeignBankAccount() && !openItemCurrency.equals(bankAccount.getCurrency())) {
            return false;
        }
        if (validatePaymentType && !this.matchesBankAccountPaymentMode(sessionBankAccount.getBankAccountModeOfPayment(), paymentType)) {
            return false;
        }
        if (!this.matchesOpenItemCurrency(sessionBankAccount, openItemCurrency)) {
            return false;
        }
        if (this.isValidForSessionType(sessionBankAccount, openItemCurrency, paymentSession, openItemCountry)) {
            return true;
        }
        return paymentSession.getConsiderSepaArea() && this.meetsBasicSepaCriteriaForAcceptedPaymentTypes(paymentSession, openItemCurrency, bankAccount, openItemCountry, paymentType);
    }

    private boolean meetsBasicSepaCriteriaForAcceptedPaymentTypes(GeneratePaymentSession paymentSession, ICurrency openItemCurrency, BankAccount bankAccount, ICountry openItemCountry, ModeOfPayment paymentType) {
        return this.isSepaPaymentTypeAllowedForSessionIncludingUnknown(paymentSession, paymentType) && PaymentHelper.meetsBasicSepaCriteria((FinancePaymentSession)paymentSession, openItemCurrency, bankAccount, openItemCountry);
    }

    private boolean isSepaPaymentTypeAllowedForSessionIncludingUnknown(GeneratePaymentSession session, ModeOfPayment paymentType) {
        if (paymentType == ModeOfPayment.UNKNOWN) {
            return true;
        }
        return PaymentTypeUtils.isExportPaymentType(paymentType) && PaymentTypeUtils.isPaymentTypeAllowedForSession(session, paymentType);
    }

    public boolean isValidForSessionType(PaymentSessionBankAccount sessionBankAccount, ICurrency openItemCurrency, GeneratePaymentSession paymentSession, ICountry openItemCountry) {
        ICountry bankCountry = sessionBankAccount.getBankAccount().getBankData().getCountry();
        if (paymentSession.getIsForeignPayment()) {
            boolean countryMismatch = !openItemCountry.equals(bankCountry);
            boolean isForeignCurrency = !openItemCurrency.equals(paymentSession.getFinanceSetup().getBaseCurrency());
            return (countryMismatch || isForeignCurrency) && this.isCurrencyAllowed(sessionBankAccount, openItemCurrency, true);
        }
        return openItemCountry.equals(bankCountry) && this.isCurrencyAllowed(sessionBankAccount, openItemCurrency, false);
    }

    private boolean matchesOpenItemCurrency(PaymentSessionBankAccount sessionBankAccount, ICurrency paymentCurrency) {
        return sessionBankAccount.getCurrencyOfOpenItems() == null || paymentCurrency.equals(sessionBankAccount.getCurrencyOfOpenItems());
    }

    private boolean matchesBankAccountPaymentMode(BankAccountModeOfPaymentEnum bankAccountModeOfPayment, ModeOfPayment paymentType) {
        return bankAccountModeOfPayment.value() == 0 || bankAccountModeOfPayment.value() == this.toBankAccountModeOfPayment(paymentType).value();
    }

    public void addSplitPayment(GeneratePaymentSession paymentSession, SplitPayment splitPayment) throws BusinessDomainException {
        if (splitPayment == null) {
            return;
        }
        PaymentSessionBankAccount sessionBankAccount = this.getSplitPaymentBankAccountWithCreation(paymentSession, splitPayment.getBankAccount());
        if (sessionBankAccount != null) {
            sessionBankAccount.makeSaveable();
            sessionBankAccount.addToTotalOfPayments((FinancePayment)splitPayment);
        }
    }

    private PaymentSessionBankAccount getSplitPaymentBankAccountWithCreation(GeneratePaymentSession paymentSession, BankAccount splitPaymentBankAccount) throws BusinessDomainException {
        if (splitPaymentBankAccount == null) {
            return null;
        }
        PaymentSessionBankAccount result = PaymentSessionBankAccountUtils.getPaymentSessionBankAccount((FinancePaymentSession)paymentSession, (BankAccount)splitPaymentBankAccount, (Payment.PaymentType)Payment.PaymentType.SPLIT_PAYMENT);
        if (result == null) {
            result = new PaymentSessionBankAccount((FinancePaymentSession)paymentSession, splitPaymentBankAccount, paymentSession.getUseOpenItemStatus());
            result.setIsSplitPayment(true);
            result.setSortNo(paymentSession.getPaymentSessionBankAccounts().length);
            result.calculateStatistics();
            paymentSession.addPaymentSessionBankAccount(result);
        }
        return result;
    }

    public void removeGeneratePayment(GeneratePaymentSession paymentSession, GeneratePayment generatePayment) {
        FinancePaymentUtils.getFinancePayments((FinancePayment)generatePayment).stream().forEach(p -> this.removeFromTotalOfPayments(paymentSession, (FinancePayment)((Object)p)));
    }

    private void removeFromTotalOfPayments(GeneratePaymentSession paymentSession, FinancePayment financePayment) {
        PaymentSessionBankAccount sessionBankAccount = PaymentSessionBankAccountUtils.getPaymentSessionBankAccount((FinancePaymentSession)paymentSession, (FinancePayment)financePayment);
        if (sessionBankAccount != null) {
            sessionBankAccount.makeSaveable();
            sessionBankAccount.removeFromTotalOfPayments(financePayment);
        }
    }

    public void addGeneratePayment(GeneratePaymentSession paymentSession, GeneratePayment generatePayment) throws BusinessDomainException {
        this.addToTotalOfPayments(paymentSession, generatePayment);
        this.addSplitPayment(paymentSession, generatePayment.getSplitPayment());
    }

    public void addToTotalOfPayments(GeneratePaymentSession paymentSession, FinancePayment financePayment) {
        PaymentSessionBankAccount sessionBankAccount = PaymentSessionBankAccountUtils.getPaymentSessionBankAccount((FinancePaymentSession)paymentSession, (FinancePayment)financePayment);
        if (sessionBankAccount != null) {
            sessionBankAccount.makeSaveable();
            sessionBankAccount.addToTotalOfPayments(financePayment);
        }
    }
}

