/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.openitem.service;

import com.varial.accounting.domain.invoiceallocation.AllocationAmount;
import com.varial.accounting.domain.invoiceallocation.OpenItemAllocation;
import com.varial.accounting.domain.nominaltransactionbase.PersonalAccountEntry;
import com.varial.accounting.domain.openitem.IOpenItem;
import com.varial.accounting.domain.openitem.OpenItem;
import com.varial.accounting.domain.openitem.dates.PaymentEffectiveDateEntriesUpdater;
import com.varial.serverbase.mapper.StringMapper;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class PaymentEffectiveDateService {
    private final PaymentEffectiveDateEntriesUpdater updater;

    public PaymentEffectiveDateService(PaymentEffectiveDateEntriesUpdater updater) {
        this.updater = updater;
    }

    public void updateEffectiveDatesIfAllocated(OpenItemAllocation allocation) {
        Map<PersonalAccountEntry, List<OpenItem>> allocatedEntryMap = this.extractEntries(allocation);
        for (Map.Entry<PersonalAccountEntry, List<OpenItem>> entry : allocatedEntryMap.entrySet()) {
            PersonalAccountEntry allocatedEntry = entry.getKey();
            List<OpenItem> allocatedOpenItems = entry.getValue();
            List<OpenItem> allRelevantOpenItems = this.getUpToDateOpenItems(allocatedEntry, allocatedOpenItems);
            Date effectiveDate = this.determineEffectiveDate(allRelevantOpenItems);
            this.updater.updateIfRequired(allocatedEntry, effectiveDate);
        }
    }

    private Date determineEffectiveDate(List<OpenItem> openItems) {
        List effectiveDates = openItems.stream().map(OpenItem::getPaymentEffectiveDate).collect(Collectors.toList());
        if (effectiveDates.contains(null)) {
            return null;
        }
        return effectiveDates.stream().max(Date::compareTo).orElse(null);
    }

    private List<OpenItem> getUpToDateOpenItems(PersonalAccountEntry entry, List<OpenItem> updatedItems) {
        OpenItem[] allItems = entry.getOpenItems();
        if (updatedItems.size() == allItems.length) {
            return updatedItems;
        }
        ArrayList<OpenItem> result = new ArrayList<OpenItem>();
        result.addAll(updatedItems);
        for (OpenItem itemFromDb : allItems) {
            boolean found = false;
            for (OpenItem updateItem : updatedItems) {
                if (!this.matches(itemFromDb, updateItem)) continue;
                found = true;
                break;
            }
            if (found) continue;
            result.add(itemFromDb);
        }
        return result;
    }

    private boolean matches(IOpenItem item1, IOpenItem item2) {
        return !StringMapper.isNullString((String)item1.getObjectid()) && !StringMapper.isNullString((String)item2.getObjectid()) && item1.getObjectid().equals(item2.getObjectid());
    }

    private Map<PersonalAccountEntry, List<OpenItem>> extractEntries(OpenItemAllocation allocation) {
        HashMap<PersonalAccountEntry, List<OpenItem>> entryMap = new HashMap<PersonalAccountEntry, List<OpenItem>>();
        for (AllocationAmount amount : allocation.getAllocationAmounts()) {
            OpenItem openItem = amount.getOpenItem();
            PersonalAccountEntry entry = openItem.getPersonalAccountEntry();
            if (entry == null || !entry.requiresPaymentEffectiveDate()) continue;
            entryMap.computeIfAbsent(entry, k -> new ArrayList()).add(openItem);
        }
        return entryMap;
    }

    public void clearEffectiveDates(OpenItemAllocation allocation) {
        Map<PersonalAccountEntry, List<OpenItem>> deallocatedEntryMap = this.extractEntries(allocation);
        for (PersonalAccountEntry deallocatedEntry : deallocatedEntryMap.keySet()) {
            this.updater.updateIfRequired(deallocatedEntry, null);
        }
    }

    public void clearEffectiveDates(AllocationAmount allocationAmount) {
        PersonalAccountEntry entry = allocationAmount.getOpenItem().getPersonalAccountEntry();
        this.updater.updateIfRequired(entry, null);
    }
}

