/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.invoiceallocation.returnpayment;

import com.varial.accounting.domain.batch.Batch;
import com.varial.accounting.domain.custsupaddress.CustSupAddress;
import com.varial.accounting.domain.financesetup.FinanceSetup;
import com.varial.accounting.domain.financialyear.FinancialYear;
import com.varial.accounting.domain.invoiceallocation.AllocationAmount;
import com.varial.accounting.domain.invoiceallocation.AllocationAmountFactory;
import com.varial.accounting.domain.invoiceallocation.InvoiceAllocationRemainderOpenItemData;
import com.varial.accounting.domain.invoiceallocation.InvoiceAllocationType;
import com.varial.accounting.domain.invoiceallocation.OpenItemAllocation;
import com.varial.accounting.domain.invoiceallocation.OpenItemAllocationExceptionMapper;
import com.varial.accounting.domain.invoiceallocation.PersonalAccountAdjustmentTransaction;
import com.varial.accounting.domain.invoiceallocation.RemainderOpenItem;
import com.varial.accounting.domain.invoiceallocation.returnpayment.ReturnPaymentStatusEnum;
import com.varial.accounting.domain.invoiceallocation.utils.OpenItemAllocationHelper;
import com.varial.accounting.domain.nominaltransactionbase.TransactionHelper;
import com.varial.accounting.domain.nominaltransactionbase.TransactionPresetPostingHelper;
import com.varial.accounting.domain.nominaltransactionbase.cancellation.CancellationContext;
import com.varial.accounting.domain.nominaltransactionbase.cancellation.CancellationContextBuilder;
import com.varial.accounting.domain.openitem.OpenItem;
import com.varial.accounting.domain.openitem.dates.PaymentEffectiveDateEntriesUpdater;
import com.varial.accounting.domain.openitem.service.PaymentEffectiveDateService;
import com.varial.accounting.domain.personalaccount.PersonalAccount;
import com.varial.accounting.domain.sequenceno.SequenceNoMappingManager;
import com.varial.accounting.domain.transactionpreset.TransactionPreset;
import com.varial.base.UtilitiesManager;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.session.SessionContext;
import com.varial.framework.domain.currency.ConversionRate;
import com.varial.interfaces.ICurrency;
import com.varial.serverbase.domain.user.IUserPersistencyManager;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ReturnPaymentManager {
    private static final IUserPersistencyManager userPersistencyManager = (IUserPersistencyManager)UtilitiesManager.getBean((String)"userPersistencyManager", IUserPersistencyManager.class);

    public static void allocateReturnPayment(OpenItem returnPaymentOpenItem, List<OpenItemAllocation> paymentOpenItemAllocations, Date allocationDate, FinancialYear financialYear, BigDecimal settlementAmount, TransactionPreset adjustmentPreset, BigDecimal adjustmentAmount, BigDecimal remainderOpenItemAmount, CancellationContext cancelData) throws BusinessDomainException {
        if (paymentOpenItemAllocations == null || paymentOpenItemAllocations.isEmpty()) {
            throw OpenItemAllocationExceptionMapper.makePaymentOpenItemAllocationMissingDomainException();
        }
        FinanceSetup financeSetup = financialYear.getCompany().getFinanceSetup();
        boolean returnPaymentWithOpenItemHistory = financeSetup.getReturnPaymentWithOpenItemHistory();
        List<AllocationAmount> paymentAllocationAmounts = ReturnPaymentManager.resetAllocatedPayments(returnPaymentOpenItem, paymentOpenItemAllocations, allocationDate, financialYear, cancelData, returnPaymentWithOpenItemHistory);
        OpenItemAllocation returnPaymentAllocation = ReturnPaymentManager.makeReturnPaymentAllocation(returnPaymentOpenItem, paymentAllocationAmounts, allocationDate, financialYear, settlementAmount, adjustmentPreset, adjustmentAmount, remainderOpenItemAmount);
        ReturnPaymentManager.setReturnPaymentStatus(returnPaymentWithOpenItemHistory, returnPaymentAllocation, paymentOpenItemAllocations);
    }

    public static void setReturnPaymentStatus(boolean returnPaymentWithOpenItemHistory, OpenItemAllocation returnPaymentAllocation, List<OpenItemAllocation> paymentOpenItemAllocations) {
        if (returnPaymentWithOpenItemHistory) {
            returnPaymentAllocation.setReturnPaymentStatus(ReturnPaymentStatusEnum.RPSE_RETURN_PAYMENT);
            int subPriority = returnPaymentAllocation.getSubPriority() - 1;
            returnPaymentAllocation.setSubPriority(subPriority);
            for (OpenItemAllocation openItemAllocation : paymentOpenItemAllocations) {
                openItemAllocation.setReturnPaymentOpenItemAllocation(returnPaymentAllocation);
            }
        }
    }

    private static OpenItemAllocation makeReversalPaymentAllocation(OpenItemAllocation paymentOpenItemAllocation, Date allocationDate, FinancialYear financialYear, OpenItem returnPaymentOpenItem) throws BusinessDomainException {
        OpenItemAllocation result = new OpenItemAllocation(financialYear, allocationDate, InvoiceAllocationType.REVERSAL_PAYMENT, paymentOpenItemAllocation.getPersonalAccount());
        int subPriority = result.getSubPriority() - 1;
        result.setSubPriority(subPriority);
        result.setAssociation(paymentOpenItemAllocation.getAssociation());
        result.setWithSubAccounts(paymentOpenItemAllocation.getWithSubAccounts());
        Batch batch = new Batch(result.getCompany(), userPersistencyManager.query(SessionContext.getInstance().getSession().getUserCode()), true);
        CancellationContext cancelData = new CancellationContextBuilder(financialYear, allocationDate).withDocumentDate(returnPaymentOpenItem.getDocumentDate()).withTaxDate(returnPaymentOpenItem.getDocumentDate()).withReferenceNumber(returnPaymentOpenItem.getReferenceNumber()).withBatch(batch).withInverseDebit(true).build();
        AllocationAmount reversalPaymentAllocationAmount = new AllocationAmount(paymentOpenItemAllocation.getPaymentReceipt(), result, cancelData);
        result.setPaymentReceipt(reversalPaymentAllocationAmount);
        if (paymentOpenItemAllocation.getResidueAdjustment() != null) {
            PersonalAccountAdjustmentTransaction residueAdjustment = new PersonalAccountAdjustmentTransaction(paymentOpenItemAllocation.getResidueAdjustment(), cancelData);
            result.setResidueAdjustment(residueAdjustment);
        }
        if (paymentOpenItemAllocation.getForeignCurrencyAdjustment() != null) {
            PersonalAccountAdjustmentTransaction foreignCurrencyAdjustment = new PersonalAccountAdjustmentTransaction(paymentOpenItemAllocation.getForeignCurrencyAdjustment(), cancelData);
            result.setForeignCurrencyAdjustment(foreignCurrencyAdjustment);
        }
        RemainderOpenItem[] paymentRemainderOpenItems = paymentOpenItemAllocation.getRemainderOpenItems();
        RemainderOpenItem[] reversalRemainderOpenItems = new RemainderOpenItem[paymentRemainderOpenItems.length];
        for (int i = 0; i < reversalRemainderOpenItems.length; ++i) {
            reversalRemainderOpenItems[i] = new RemainderOpenItem(paymentRemainderOpenItems[i], result, cancelData);
        }
        result.setRemainderOpenItems(reversalRemainderOpenItems);
        AllocationAmount[] paymentAllocationAmounts = paymentOpenItemAllocation.getAllocationAmounts();
        AllocationAmount[] reversalPaymentAllocationAmounts = new AllocationAmount[paymentAllocationAmounts.length];
        for (int i = 0; i < reversalPaymentAllocationAmounts.length; ++i) {
            reversalPaymentAllocationAmounts[i] = new AllocationAmount(paymentAllocationAmounts[i], result, cancelData);
        }
        result.setAllocationAmounts(reversalPaymentAllocationAmounts);
        if (!batch.isEmpty()) {
            batch.close();
        } else {
            batch.makeReadOnly();
        }
        return result;
    }

    private static OpenItemAllocation makeReturnPaymentAllocation(OpenItem returnPaymentOpenItem, List<AllocationAmount> paymentAllocationAmounts, Date allocationDate, FinancialYear financialYear, BigDecimal settlementAmount, TransactionPreset adjustmentPreset, BigDecimal adjustmentAmount, BigDecimal remainderOpenItemAmount) throws BusinessDomainException {
        OpenItemAllocation result = new OpenItemAllocation(financialYear, allocationDate, InvoiceAllocationType.DONE, returnPaymentOpenItem.getPersonalAccount());
        result.setSeccurrConversionRates(returnPaymentOpenItem);
        ConversionRate conversionRate = returnPaymentOpenItem.getConversionRate();
        ICurrency currency = returnPaymentOpenItem.getEnteredCurrency();
        AllocationAmount returnPaymentAllocationAmount = AllocationAmountFactory.createAllocationAmount((OpenItem)returnPaymentOpenItem, (OpenItemAllocation)result, (BigDecimal)settlementAmount.abs(), null, (ConversionRate)conversionRate, null);
        result.setPaymentReceipt(returnPaymentAllocationAmount);
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)adjustmentAmount)) {
            PersonalAccountAdjustmentTransaction adjustmentTransaction = ReturnPaymentManager.createAdjustmentTransaction(adjustmentPreset, adjustmentAmount, currency, conversionRate, result, returnPaymentOpenItem.getPersonalAccount(), returnPaymentOpenItem.getOneOffAccountAddress(), returnPaymentOpenItem.getReferenceNumber(), null, false);
            result.setResidueAdjustment(adjustmentTransaction);
        }
        if (!BigDecimalMapper.isZeroOrNull((BigDecimal)remainderOpenItemAmount)) {
            BigDecimal baseAmount = ReturnPaymentManager.getBaseAmount(remainderOpenItemAmount, currency, result.getFinanceSetup().getBaseCurrency(), conversionRate);
            OpenItem remainderOpenItem = ReturnPaymentManager.createRemainderOpenItem(remainderOpenItemAmount, conversionRate, currency, result, returnPaymentOpenItem.getPersonalAccount(), returnPaymentOpenItem.getOneOffAccountAddress(), returnPaymentOpenItem.getReferenceNumber(), returnPaymentOpenItem.getSequenceNumber(), baseAmount);
            result.setRemainderOpenItems(new OpenItem[]{remainderOpenItem});
        }
        AllocationAmount[] allocationAmounts = new AllocationAmount[paymentAllocationAmounts.size()];
        for (int i = 0; i < allocationAmounts.length; ++i) {
            AllocationAmount paymentReceipt = paymentAllocationAmounts.get(i);
            OpenItem openItem = paymentReceipt.getOpenItem();
            allocationAmounts[i] = AllocationAmountFactory.createAllocationAmount((OpenItem)openItem, (OpenItemAllocation)result, (BigDecimal)paymentReceipt.getForeignSettlementAmount().abs(), null, (ConversionRate)conversionRate, null);
        }
        result.setAllocationAmounts(allocationAmounts);
        result.rework();
        return result;
    }

    public static PersonalAccountAdjustmentTransaction createAdjustmentTransaction(TransactionPreset adjustmentPreset, BigDecimal adjustmentAmount, ICurrency currency, ConversionRate conversionRate, OpenItemAllocation openItemAllocation, PersonalAccount personalAccount, CustSupAddress oneOffAddress, String referenceNumber, BigDecimal baseAdjustmentAmount, boolean setBaseAdjustmentAmount) throws BusinessDomainException {
        if (adjustmentPreset == null) {
            throw OpenItemAllocationExceptionMapper.makeAdjustmentPresetMissingDomainException();
        }
        BigDecimal amount = adjustmentAmount.abs();
        boolean isDebit = adjustmentAmount.signum() < 0;
        BigDecimal baseAmount = baseAdjustmentAmount;
        if (baseAmount != null) {
            baseAmount = baseAmount.abs();
        }
        PersonalAccountAdjustmentTransaction result = null;
        try {
            result = TransactionPresetPostingHelper.createPersonalAccountAdjustmentTransaction((Batch)openItemAllocation.getBatch(), (TransactionPreset)adjustmentPreset, (Date)openItemAllocation.getAllocationDate(), (FinancialYear)openItemAllocation.getFinancialYear(), (ICurrency)currency, (BigDecimal)amount, (ConversionRate)conversionRate, (boolean)isDebit, (String)referenceNumber, (PersonalAccount)personalAccount, (CustSupAddress)oneOffAddress, (FinanceSetup)openItemAllocation.getFinanceSetup(), (SequenceNoMappingManager)openItemAllocation.getSequenceNoMappingManager(), (BigDecimal)baseAmount, (boolean)setBaseAdjustmentAmount);
        }
        catch (BusinessDomainException de) {
            if (de.getErrorNumber() == 310 && StringMapper.equal((String)de.getDomain(), (String)"Transaction")) {
                de = isDebit ? OpenItemAllocationExceptionMapper.makeAdjustmentAmountPresetIncorrectCreditDomainException() : OpenItemAllocationExceptionMapper.makeAdjustmentAmountPresetIncorrectDebitDomainException();
            }
            throw de;
        }
        return result;
    }

    public static OpenItem createRemainderOpenItem(BigDecimal amount, ConversionRate conversionRate, ICurrency currency, OpenItemAllocation openItemAllocation, PersonalAccount personalAccount, CustSupAddress oneOffAddress, String referenceNumber, String sequenceNumber, BigDecimal baseAmount) throws BusinessDomainException {
        boolean isDebit = amount.signum() > 0;
        InvoiceAllocationRemainderOpenItemData remainderOpenItemData = new InvoiceAllocationRemainderOpenItemData();
        remainderOpenItemData.setTransactionDate(openItemAllocation.getAllocationDate());
        remainderOpenItemData.setFinancialYear(openItemAllocation.getFinancialYear());
        remainderOpenItemData.setAmount(amount.abs());
        remainderOpenItemData.setConversionRate(conversionRate);
        remainderOpenItemData.setBaseAmount(baseAmount.abs());
        remainderOpenItemData.setCurrency(currency);
        remainderOpenItemData.setPersonalAccount(personalAccount);
        remainderOpenItemData.setOneOffAccountAddress(oneOffAddress);
        remainderOpenItemData.setReferenceNumber(referenceNumber);
        remainderOpenItemData.setProcessId("");
        remainderOpenItemData.setDebit(isDebit);
        remainderOpenItemData.setDocumentDate(openItemAllocation.getAllocationDate());
        remainderOpenItemData.setValueDate(openItemAllocation.getAllocationDate());
        remainderOpenItemData.setDueDate(openItemAllocation.getAllocationDate());
        remainderOpenItemData.setTermOfPayment(null);
        remainderOpenItemData.setPaymentType(personalAccount.getPaymentType());
        remainderOpenItemData.setBankAddress(null);
        remainderOpenItemData.setTaxDate(openItemAllocation.getAllocationDate());
        remainderOpenItemData.setTaxCode(null);
        remainderOpenItemData.setAnalysisCodes(null);
        remainderOpenItemData.setInstalment(false);
        remainderOpenItemData.setOpenItemAllocation(openItemAllocation);
        remainderOpenItemData.setInputTax(personalAccount.isSupplier());
        remainderOpenItemData.setSequenceNumber(sequenceNumber);
        return OpenItemAllocationHelper.createRemainderOpenItem((InvoiceAllocationRemainderOpenItemData)remainderOpenItemData);
    }

    public static List<AllocationAmount> resetAllocatedPayments(OpenItem returnPaymentOpenItem, List<OpenItemAllocation> paymentOpenItemAllocations, Date allocationDate, FinancialYear year, CancellationContext cancelData, boolean returnPaymentWithOpenItemHistory) throws BusinessDomainException {
        if (paymentOpenItemAllocations == null || paymentOpenItemAllocations.size() == 0) {
            throw OpenItemAllocationExceptionMapper.makePaymentOpenItemAllocationMissingDomainException();
        }
        ICurrency currency = returnPaymentOpenItem.getEnteredCurrency();
        ArrayList<AllocationAmount> result = new ArrayList<AllocationAmount>();
        for (OpenItemAllocation oia : paymentOpenItemAllocations) {
            AllocationAmount paymentReceipt = oia.getPaymentReceipt();
            result.add(paymentReceipt);
            OpenItem paymentOpenItem = paymentReceipt.getOpenItem();
            if (!currency.equals(paymentOpenItem.getEnteredCurrency())) {
                throw OpenItemAllocationExceptionMapper.makeReturnPaymentDifferentCurrenciesDomainException();
            }
            oia.makeSaveable();
            oia.setCancellationContext(cancelData);
            if (returnPaymentWithOpenItemHistory) {
                if (TransactionHelper.transactionDateBefore((Date)allocationDate, (FinancialYear)year, (Date)oia.getAllocationDate(), (FinancialYear)oia.getFinancialYear())) {
                    throw OpenItemAllocationExceptionMapper.makeAllocationDateOfPaymentbeforeAllocationDateOfReturnPaymentDomainException();
                }
                oia.setReturnPaymentStatus(ReturnPaymentStatusEnum.RPSE_POSTED_BACK);
                OpenItemAllocation reversalPaymentOpenItemAllocation = ReturnPaymentManager.makeReversalPaymentAllocation(oia, allocationDate, year, returnPaymentOpenItem);
                oia.setReversalPaymentOpenItemAllocation(reversalPaymentOpenItemAllocation);
                new PaymentEffectiveDateService(new PaymentEffectiveDateEntriesUpdater()).clearEffectiveDates(oia);
                continue;
            }
            oia.destroy();
        }
        return result;
    }

    private static BigDecimal getBaseAmount(BigDecimal amount, ICurrency currency, ICurrency baseCurrency, ConversionRate conversionRate) {
        BigDecimal baseAmount = amount.abs();
        if (!baseCurrency.equals(currency)) {
            baseAmount = baseAmount.multiply(conversionRate.getRate());
            baseAmount = baseCurrency.round(baseAmount);
        }
        return baseAmount;
    }
}

