/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.eaudit.export.v35.strategy;

import com.varial.accounting.domain.eaudit.export.common.context.AccountExportContext;
import com.varial.accounting.domain.eaudit.export.common.context.EAuditExportContext;
import com.varial.accounting.domain.eaudit.export.common.dto.TempEAuditExportFileInfo;
import com.varial.accounting.domain.eaudit.export.common.strategy.EAuditExportContentGenerationStrategy;
import com.varial.accounting.domain.eaudit.export.v35.record.writer.EAuditHeaderWriter;
import com.varial.accounting.domain.eaudit.export.v35.record.writer.EAuditRecordWriter;
import com.varial.accounting.domain.eaudit.export.v35.record.writer.EAuditTrailerRecordWriter;
import com.varial.base.exception.BusinessDomainException;
import com.varial.framework.domain.fileio.IOExceptionMapper;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;

public abstract class AbstractEAuditContentGenerationStrategy
implements EAuditExportContentGenerationStrategy {
    private static final Charset CHARSET = StandardCharsets.ISO_8859_1;
    private static final int COMMUNICATION_RECORD_COUNT = 1;
    private static final int CONTROL_RECORD_COUNT = 1;
    private final EAuditHeaderWriter headerWriter = new EAuditHeaderWriter();
    private final EAuditTrailerRecordWriter trailerWriter = new EAuditTrailerRecordWriter();

    public List<TempEAuditExportFileInfo> generateContent(EAuditExportContext exportContext, int startFileNumber, List<AccountExportContext> contexts) throws BusinessDomainException {
        try {
            return this.doGenerateContent(exportContext, startFileNumber, contexts);
        }
        catch (IOException ioe) {
            throw IOExceptionMapper.map((IOException)ioe);
        }
        catch (BusinessDomainException bde) {
            throw bde;
        }
        catch (Exception e) {
            throw e;
        }
    }

    protected abstract List<TempEAuditExportFileInfo> doGenerateContent(EAuditExportContext var1, int var2, List<AccountExportContext> var3) throws IOException, BusinessDomainException;

    protected EAuditRecordWriter startFileWithHeader(Path file, EAuditExportContext exportContext, int fileNumber, boolean isLastFile) throws IOException, BusinessDomainException {
        Writer output = this.newBufferedWriter(file, CHARSET);
        EAuditRecordWriter recordWriter = new EAuditRecordWriter(output);
        this.headerWriter.writeHeader(recordWriter, exportContext, fileNumber, isLastFile);
        return recordWriter;
    }

    protected void finishFile(EAuditRecordWriter recordWriter, EAuditExportContext exportContext, int fileNumber, List<TempEAuditExportFileInfo> contents, Path currentFile, int transactionRecordCount, int totalAccounts, int totalTransactions) throws IOException, BusinessDomainException {
        boolean isFirstFile = contents.isEmpty();
        int totalRecordCount = this.getTotalRecordCount(totalAccounts, totalTransactions, isFirstFile);
        this.trailerWriter.writeTrailer(recordWriter, exportContext.getSession(), fileNumber, totalRecordCount);
        recordWriter.close();
        contents.add(new TempEAuditExportFileInfo(exportContext.getCriteria(), fileNumber, currentFile.getFileName().toString(), transactionRecordCount));
    }

    private int getTotalRecordCount(int totalAccounts, int totalTransactions, boolean isFirstFile) {
        boolean hasTransactionData = totalTransactions > 0;
        int transactionRecordCount = hasTransactionData ? 1 : 0;
        int accountRecordCount = isFirstFile ? totalAccounts : 0;
        return transactionRecordCount + accountRecordCount + 1 + 1;
    }

    protected Path createTempFile(Path baseDir, int fileNumber) throws IOException {
        Path file = baseDir.resolve("export_" + fileNumber + ".txt");
        try {
            Files.deleteIfExists(file);
            Files.createFile(file, new FileAttribute[0]);
            return file;
        }
        catch (IOException e) {
            throw new IOException(String.format("Failed to create export file at path: %s", file), e);
        }
    }

    protected Writer newBufferedWriter(Path path, Charset charset) throws IOException {
        try {
            return Files.newBufferedWriter(path, charset, StandardOpenOption.WRITE);
        }
        catch (IOException e) {
            throw new IOException(String.format("Failed to open writer for file: %s", path), e);
        }
    }
}

