/*
 * Decompiled with CFR 0.152.
 */
package com.varial.transfer.domain.accounting.invoicetransaction;

import com.infor.igf.core.util.StringUtil;
import com.varial.accounting.domain.batch.Batch;
import com.varial.accounting.domain.financialyear.AccountingCompany;
import com.varial.accounting.domain.financialyear.FinancialYear;
import com.varial.accounting.domain.invoiceorcreditnotetransaction.DownPaymentRequestOpenItem;
import com.varial.accounting.domain.invoiceorcreditnotetransaction.DownPaymentRequestPostingManager;
import com.varial.accounting.domain.invoiceorcreditnotetransaction.InvoicePayableTransaction;
import com.varial.accounting.domain.invoiceorcreditnotetransaction.InvoiceReceivableTransaction;
import com.varial.accounting.domain.invoiceorcreditnotetransaction.InvoiceTransaction;
import com.varial.accounting.domain.invoiceorcreditnotetransaction.KsefNumberType;
import com.varial.accounting.domain.nominaltransactionbase.DownPaymentHelper;
import com.varial.accounting.domain.nominaltransactionbase.INominalTransactionBase;
import com.varial.accounting.domain.nominaltransactionbase.NominalLedgerEntry;
import com.varial.accounting.domain.nominaltransactionbase.NominalLedgerEntryMapper;
import com.varial.accounting.domain.nominaltransactionbase.NominalTaxEntry;
import com.varial.accounting.domain.nominaltransactionbase.NominalTaxEntryMapper;
import com.varial.accounting.domain.nominaltransactionbase.NominalTransactionBase;
import com.varial.accounting.domain.nominaltransactionbase.NominalTransactionBasePersistencyManager;
import com.varial.accounting.domain.nominaltransactionbase.PersonalAccountEntry;
import com.varial.accounting.domain.nominaltransactionbase.PersonalAccountEntryMapper;
import com.varial.accounting.domain.nominaltransactionbase.PrepaidTax;
import com.varial.accounting.domain.nominaltransactionbase.cancellation.CancellationContext;
import com.varial.accounting.domain.nominaltransactionbase.cancellation.CancellationContextBuilder;
import com.varial.accounting.domain.nominaltransactionbase.exchangerate.ExchangeRateStrategy;
import com.varial.accounting.domain.nominaltransactionbase.exchangerate.ExchangeRateStrategyFactory;
import com.varial.accounting.domain.nominaltransactionbase.exchangerate.FixedTaxBasisDateStrategy;
import com.varial.accounting.domain.nominaltransactionbase.tax.resolver.FixedTaxRateResolver;
import com.varial.accounting.domain.openitem.OpenItem;
import com.varial.accounting.domain.openitem.OpenItemPersistencyManager;
import com.varial.accounting.domain.openitem.OpenItemType;
import com.varial.accounting.domain.personalaccount.PersonalAccount;
import com.varial.accounting.domain.purchaseregister.PurchaseInvoiceRegisterStatus;
import com.varial.accounting.domain.purchaseregister.PurchaseRegisterInvoice;
import com.varial.accounting.domain.purchaseregister.PurchaseWorkflow;
import com.varial.accounting.domain.taxcode.TaxCode;
import com.varial.accounting.domain.taxcode.TaxRate;
import com.varial.accounting.invoiceorcreditnotetransaction.DownPaymentDataStruct;
import com.varial.accounting.nominaltransactionbase.NominalLedgerEntryStruct;
import com.varial.accounting.transfer.invoice.KSeFNumberTypeEnum;
import com.varial.base.UtilitiesManager;
import com.varial.base.configuration.Configuration;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.session.SessionContext;
import com.varial.framework.domain.company.JurisdictionFactory;
import com.varial.framework.domain.company.JurisdictionType;
import com.varial.framework.domain.currency.ConversionRate;
import com.varial.framework.domain.currency.ConversionTable;
import com.varial.framework.domain.currency.ExchangeRatePersistencyManager;
import com.varial.framework.domain.currency.IConversionTable;
import com.varial.framework.domain.isoftware.ISoftware;
import com.varial.framework.domain.transfer.TransferConfigPersistencyManager;
import com.varial.interfaces.ICurrency;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.domain.user.IUserPersistencyManager;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.transfer.base.TransferExceptionMapper;
import com.varial.transfer.base.TransferHelper;
import com.varial.transfer.base.TransferTransactionHelper;
import com.varial.transfer.domain.accounting.invoicetransaction.AbstractPurchaseRegisterReplacer;
import com.varial.transfer.domain.accounting.invoicetransaction.NLEntryHelper;
import com.varial.transfer.domain.accounting.invoicetransaction.OIAllocationHelper;
import com.varial.transfer.domain.accounting.invoicetransaction.PurchaseRegisterReplacerFactory;
import com.varial.transfer.domain.accounting.invoicetransaction.TransferInvoice;
import com.varial.transfer.domain.accounting.invoicetransaction.TransferInvoiceHelper;
import com.varial.transfer.domain.accounting.invoicetransaction.TransferPersonalAccountEntry;
import com.varial.transfer.domain.accounting.transaction.NLTransactionBaseMapper;
import com.varial.transfer.domain.accounting.transaction.NLTransactionHelper;
import com.varial.transfer.domain.accounting.transaction.PAEntryMapper;
import com.varial.transfer.domain.accounting.transaction.TransferNLEntry;
import com.varial.transfer.domain.accounting.transaction.TransferTax;
import com.varial.transfer.domain.accounting.transaction.TransferTransaction;
import com.varial.transfer.domain.accounting.transaction.TransferTransactionTypeEnum;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import org.springframework.dao.IncorrectResultSizeDataAccessException;
import pl.varial.accounting.domain.taxcode.BaseDatePLType;
import pl.varial.accounting.domain.taxcode.TaxCodePL;

public class InvoiceTransactionCreator {
    private static final IUserPersistencyManager userPersistencyManager = (IUserPersistencyManager)UtilitiesManager.getBean((String)"userPersistencyManager", IUserPersistencyManager.class);

    public static void createOrCancelInvoiceTransaction(TransferInvoice imp) throws BusinessDomainException {
        if (InvoiceTransactionCreator.isInvoiceCancelation(imp) || InvoiceTransactionCreator.isCorrectionCancelation(imp)) {
            InvoiceTransactionCreator.cancelInvoiceTransaction(imp);
        } else {
            if (InvoiceTransactionCreator.cancelationNotAllowed(imp)) {
                throw TransferExceptionMapper.makeCancelationNotAllowedDomainException();
            }
            InvoiceTransactionCreator.createInvoiceTransaction(imp);
        }
    }

    private static void createInvoiceTransaction(TransferInvoice imp) throws BusinessDomainException {
        if (imp.isPurchaseRegister()) {
            InvoiceTransactionCreator.createPurchaseRegisterInvoice(imp);
        } else if (imp.isCustomerInvoice()) {
            InvoiceTransactionCreator.createReceivableInvoiceTransaction(imp);
        } else if (imp.isSupplierInvoice()) {
            InvoiceTransactionCreator.createPayableInvoiceTransaction(imp);
        } else {
            throw new IllegalArgumentException("Invalid invoice type specified!");
        }
    }

    private static void createReceivableInvoiceTransaction(TransferInvoice imp) throws BusinessDomainException {
        Batch batch = TransferTransactionHelper.getBatch((TransferTransaction)imp);
        InvoiceReceivableTransaction result = new InvoiceReceivableTransaction(batch, 0);
        result.setReferenceNumberMustBeUnique(!imp.getImportWithNotUniqueRefNum());
        InvoiceTransactionCreator.fillInvoiceTransaction((InvoiceTransaction)result, imp);
    }

    private static void createPayableInvoiceTransaction(TransferInvoice imp) throws BusinessDomainException {
        Batch batch = TransferTransactionHelper.getBatch((TransferTransaction)imp);
        InvoicePayableTransaction result = new InvoicePayableTransaction(batch, 0);
        result.setReferenceNumberMustBeUnique(!imp.getImportWithNotUniqueRefNum());
        result.setDeliveryDate(imp.getDeliveryDate());
        InvoiceTransactionCreator.fillInvoiceTransaction((InvoiceTransaction)result, imp);
    }

    private static void createPurchaseRegisterInvoice(TransferInvoice imp) throws BusinessDomainException {
        AbstractPurchaseRegisterReplacer replacer = PurchaseRegisterReplacerFactory.getReplacer((TransferInvoice)imp);
        replacer.prepareReplace();
        Batch batch = TransferTransactionHelper.getBatch((TransferTransaction)imp);
        PurchaseRegisterInvoice purchaseRegisterInvoice = new PurchaseRegisterInvoice(batch);
        replacer.replaceWith(purchaseRegisterInvoice);
        PurchaseWorkflow workflow = new PurchaseWorkflow(purchaseRegisterInvoice);
        workflow.setEmailAddress("");
        workflow.setDate(VDate.getCurrentLocalizedDateAndTime());
        workflow.setNote("");
        workflow.setSentFrom(SessionContext.getInstance().getSession().getUserCode());
        workflow.setSentTo("");
        if (ISoftware.getUpdatePurchaseRegister() || TransferConfigPersistencyManager.getTransferConfig().isPurchaseInvoiceRegisterImport()) {
            workflow.setStatus(replacer.getStatus());
        } else {
            workflow.setStatus(PurchaseInvoiceRegisterStatus.NEW);
        }
        purchaseRegisterInvoice.addWorkflow(workflow);
        InvoiceTransactionCreator.fillInvoiceTransaction((InvoiceTransaction)purchaseRegisterInvoice, imp);
    }

    private static void fillInvoiceTransaction(InvoiceTransaction result, TransferInvoice imp) throws BusinessDomainException {
        TaxRate taxRate;
        PersonalAccount personalAccount = TransferHelper.getPersonalAccount((AccountingCompany)result.getCompany(), (String)imp.getPersonalAccountEntry().getOpenItem().getPersonalaccountID(), (boolean)TransferTransactionHelper.isCustomer((TransferInvoice)imp), (String)imp.getPersonalAccountEntry().getOpenItem().getControlAccountID());
        result.setCheckConversionRate(TransferConfigPersistencyManager.getTransferConfig().getCheckConversionRate());
        result.setJPKVATMustBeFilled(false);
        NLTransactionBaseMapper.fillNominalTransactionBase((TransferTransaction)imp, (NominalTransactionBase)result);
        result.setTaxOfficeRate(InvoiceTransactionCreator.getTaxOfficeRate(result, imp));
        if (ISoftware.isKronospan() && JurisdictionType.PL.equals((Object)result.getCompany().getJurisdictionType())) {
            String creatorFromERP = InvoiceTransactionCreator.extractCreator(imp.getPersonalAccountEntry().getAnalysisCodes());
            if (StringUtil.isNotEmpty((String)creatorFromERP)) {
                result.setCreatorId(creatorFromERP);
            }
            result.setDateOfReceipt(imp.getDateOfReceipt());
        }
        result.setKsefNumberType(KsefNumberType.NOT_SPECIFIED);
        if (JurisdictionType.PL.equals((Object)result.getCompany().getJurisdictionType())) {
            result.setDeliveryDate(imp.getDeliveryDate() != null ? imp.getDeliveryDate() : imp.getDocumentDate());
            result.setKsefNumber(imp.getKSeFNumber());
            if (imp.getKSeFNumberType() == KSeFNumberTypeEnum.KSEF_INVOICE_NUMBER) {
                result.setKsefNumberType(KsefNumberType.INVOICE_IDENTIFICATION);
            } else if (imp.getKSeFNumberType() == KSeFNumberTypeEnum.KSEF_IDENT_NUMBER) {
                result.setKsefNumberType(KsefNumberType.COLLECTION_IDENTIFICATION);
            }
        }
        if (imp.isCorrection()) {
            if (!JurisdictionFactory.getJurisdiction((JurisdictionType)result.getCompany().getJurisdictionType()).hasCorrectionTransaction()) {
                throw TransferExceptionMapper.makeCorrectionNotAllowedDomainException();
            }
            if (!StringMapper.isNullString((String)imp.getCorrectionReferenceNumber())) {
                NominalTransactionBase[] transactions;
                FinancialYear corrFY;
                FinancialYear fy = result.getFinancialYear();
                if (imp.getCorrectionDocumentDate() != null && (corrFY = FinancialYear.getFinancialYearByDate((AccountingCompany)result.getCompany(), (Date)imp.getCorrectionDocumentDate())) != null) {
                    fy = corrFY;
                }
                if ((transactions = NominalTransactionBasePersistencyManager.getTransactions((FinancialYear)fy, (PersonalAccount)personalAccount, (boolean)imp.getPersonalAccountEntry().isDebit(), (String)imp.getCorrectionReferenceNumber(), (Date)imp.getCorrectionDocumentDate())).length == 0) {
                    throw TransferExceptionMapper.makeNoTransactionForCorrectionFoundDomainException(fy.getCode(), personalAccount.getCode(), imp.getCorrectionReferenceNumber(), DateMapper.toString((Date)imp.getCorrectionDocumentDate()));
                }
                if (transactions.length > 1) {
                    throw TransferExceptionMapper.makeMultipleTransactionsForCorrectionFoundDomainException(fy.getCode(), personalAccount.getCode(), imp.getCorrectionReferenceNumber(), DateMapper.toString((Date)imp.getCorrectionDocumentDate()));
                }
                if (transactions[0] != null) {
                    result.setCorrectionToDocument(transactions[0]);
                }
            }
            result.setIsCorrection(true);
        }
        result.setNoNetBalance(imp.getNoNetBalance());
        result.setIsInputTax(TransferInvoiceHelper.isInputTax((TransferInvoice)imp));
        result.setIsDownPaymentFinalInvoice(imp.isFinalInvoice());
        PersonalAccountEntry personalAccountEntry = new PersonalAccountEntry((NominalTransactionBase)result);
        personalAccountEntry.setPersonalAccount(personalAccount);
        PAEntryMapper.fillPersonalAccountEntry((PersonalAccountEntry)personalAccountEntry, (TransferPersonalAccountEntry)imp.getPersonalAccountEntry());
        result.setPersonalAccountEntry(personalAccountEntry);
        result.setJpkVAT(imp.getJpkVAT());
        new NLTransactionHelper().setSequenceNumberInto((NominalTransactionBase)result);
        if (imp.getNLEntries().length > 0) {
            new NLEntryHelper().setNLEntries((TransferTransaction)imp, (NominalTransactionBase)result, InvoiceTransactionCreator.getShortAddress(personalAccount));
        }
        if (imp.isFinalInvoice()) {
            if (result.getCompany().getFinanceSetup().getFinalInvoiceWithDownPaymentRequest()) {
                DownPaymentRequestOpenItem[] downPaymentRequestOpenItems = DownPaymentRequestPostingManager.postDownPaymentRequests((InvoiceTransaction)result, (Date)result.getTransactionDate(), (FinancialYear)result.getFinancialYear(), (String[])imp.getPersonalAccountEntry().getOpenItem().getDownPaymentOids());
                result.setDownPaymentRequestOpenItems(downPaymentRequestOpenItems);
                result.getBatch().setHasImportedFinalInvoices(true);
            } else {
                InvoiceTransactionCreator.setPrepaidPaEntries(imp, result);
            }
        }
        if (new NLTransactionHelper().isForeignCurrency((NominalTransactionBase)result)) {
            boolean hasEntriesWithIsGross = false;
            for (TransferNLEntry entry : imp.getNLEntries()) {
                if (!entry.isGross()) continue;
                hasEntriesWithIsGross = true;
                break;
            }
            if (!hasEntriesWithIsGross) {
                result.checkBaseCurrencyBalanced();
                result.setNoConversionToBaseCurrencyForTransfer(true);
            }
        }
        result.setCheckUseTaxNetAmount(false);
        ExchangeRateStrategy strategy = ExchangeRateStrategyFactory.selectStrategy((INominalTransactionBase)result);
        if (strategy instanceof FixedTaxBasisDateStrategy && (taxRate = new FixedTaxRateResolver().resolveAutoFixedTaxRate((NominalTransactionBase)result)) != null) {
            result.setFixedTaxRate(taxRate);
            result.setFixedTaxCode(new TaxCode[]{taxRate.getTaxCode()});
        }
        result.rework();
        result.getBatch().addTransaction((NominalTransactionBase)result);
        InvoiceTransactionCreator.allocateOpenItem(result, imp.getAllocationReferenceNumber(), imp.getAllocationDocumentDate());
    }

    private static String extractCreator(String[] analysisCodes) throws BusinessDomainException {
        if (analysisCodes.length == 10 && StringUtil.isNotEmpty((String)analysisCodes[9])) {
            String creator = analysisCodes[9];
            if (userPersistencyManager.getUserByCode(creator) == null) {
                throw TransferExceptionMapper.makeUserNotFoundException(creator);
            }
            return creator;
        }
        return null;
    }

    private static String getShortAddress(PersonalAccount personalAccount) {
        String shortAddress = "";
        if (TransferConfigPersistencyManager.getTransferConfig().getCopyNameIntoDescription()) {
            shortAddress = personalAccount.getShortAddress();
        }
        return shortAddress;
    }

    private static void allocateOpenItem(InvoiceTransaction result, String allocationReferenceNumber, Date allocationDocumentDate) throws BusinessDomainException {
        if (!result.getIsUnfinished() && !StringMapper.isNullString((String)allocationReferenceNumber) && result.getPersonalAccountEntry() != null && result.getPersonalAccountEntry().getOpenItems() != null && result.getPersonalAccountEntry().getOpenItems().length > 0) {
            OpenItem openItem = result.getPersonalAccountEntry().getOpenItems()[0];
            OpenItem[] foundOpenItems = OpenItemPersistencyManager.getTypedOpenItemByAccRefDate((PersonalAccount)result.getPersonalAccount(), (String)allocationReferenceNumber, (Date)allocationDocumentDate);
            ArrayList<OpenItem> invoices = new ArrayList<OpenItem>();
            for (OpenItem oi : foundOpenItems) {
                if (oi.getOpenItemType() == OpenItemType.PAYMENT || oi.getOpenItemType() == OpenItemType.RECEIPT || oi.getOpenItemType() == OpenItemType.DOWN_PAYMENT_REQUEST) continue;
                invoices.add(oi);
            }
            ArrayList<OpenItem> payments = new ArrayList<OpenItem>();
            if (invoices.isEmpty() && TransferConfigPersistencyManager.getTransferConfig().getAllocatePayments()) {
                for (OpenItem oi : foundOpenItems) {
                    if (oi.getOpenItemType() != OpenItemType.PAYMENT && oi.getOpenItemType() != OpenItemType.RECEIPT) continue;
                    payments.add(oi);
                }
            }
            if (invoices.size() > 1 || payments.size() > 1) {
                throw TransferExceptionMapper.makeMoreThanOneOpenItemForAllocationFoundDomainException(allocationReferenceNumber, DateMapper.toString((Date)allocationDocumentDate));
            }
            OpenItem toAllocate = null;
            if (invoices.size() == 1) {
                toAllocate = (OpenItem)invoices.get(0);
            } else if (payments.size() == 1) {
                toAllocate = (OpenItem)payments.get(0);
            }
            if (toAllocate == null && !TransferConfigPersistencyManager.getTransferConfig().getIgnoreMissingOpenItem()) {
                throw TransferExceptionMapper.makeNoOpenItemForAllocationFoundDomainException(allocationReferenceNumber, DateMapper.toString((Date)allocationDocumentDate));
            }
            if (toAllocate != null) {
                new OIAllocationHelper().createOpenItemAllocation(openItem, new OpenItem[]{toAllocate});
            }
        }
    }

    private static void setPrepaidPaEntries(TransferInvoice imp, InvoiceTransaction result) throws BusinessDomainException {
        PersonalAccount personalAccount = result.getPersonalAccount();
        String[] downPaymentOids = imp.getPersonalAccountEntry().getOpenItem().getDownPaymentOids();
        InvoiceTransactionCreator.checkDownPaymentOids(downPaymentOids);
        BigDecimal conversionRateOfFinalInvoice = result.getConversionRate().getRate();
        DownPaymentDataStruct[] s = DownPaymentHelper.createDownPaymentData((String[])downPaymentOids, (BigDecimal)conversionRateOfFinalInvoice, (Date)result.getTransactionDate(), (FinancialYear)result.getFinancialYear());
        PersonalAccountEntry[] prepaidPaEntries = new PersonalAccountEntry[s.length];
        for (int i = 0; i < prepaidPaEntries.length; ++i) {
            NominalLedgerEntryStruct tmp;
            prepaidPaEntries[i] = new PersonalAccountEntry((NominalTransactionBase)result);
            PersonalAccountEntryMapper.fillPrepaidPaEntry((PersonalAccountEntry)prepaidPaEntries[i], (DownPaymentDataStruct)s[i], (PersonalAccount)personalAccount);
            if (new NLTransactionHelper().isForeignCurrency((NominalTransactionBase)result)) {
                BigDecimal baseAmount = BigDecimalMapper.ZERO;
                if (prepaidPaEntries[i].getEnteredAmount() != null) {
                    baseAmount = prepaidPaEntries[i].getEnteredAmount().multiply(conversionRateOfFinalInvoice);
                    baseAmount = result.getFinanceSetup().getBaseCurrency().round(baseAmount);
                }
                prepaidPaEntries[i].setBaseAmount(baseAmount);
            }
            int subPriority = prepaidPaEntries[i].getSubPriority() - 1;
            NominalLedgerEntry prepaidTaxNominalEntry = null;
            NominalLedgerEntry prepaidTaxAdditionalNominalEntry = null;
            if (s[i].nominalEntries.length > 0) {
                tmp = s[i].nominalEntries[0];
                prepaidTaxNominalEntry = new NominalLedgerEntry((NominalTransactionBase)result);
                prepaidTaxNominalEntry.setIsDownPayment(true);
                prepaidTaxNominalEntry.setSubPriority(subPriority);
                prepaidTaxNominalEntry.setIsPrepaidTax(true);
                NominalLedgerEntryMapper.fillNominalLedgerEntry((NominalLedgerEntry)prepaidTaxNominalEntry, (NominalLedgerEntryStruct)tmp, (boolean)result.getIsUnfinished());
                if (s[i].nominalEntries.length > 1) {
                    tmp = s[i].nominalEntries[1];
                    prepaidTaxAdditionalNominalEntry = new NominalLedgerEntry((NominalTransactionBase)result);
                    prepaidTaxAdditionalNominalEntry.setIsDownPayment(true);
                    prepaidTaxAdditionalNominalEntry.setSubPriority(subPriority);
                    prepaidTaxAdditionalNominalEntry.setIsPrepaidTax(true);
                    NominalLedgerEntryMapper.fillNominalLedgerEntry((NominalLedgerEntry)prepaidTaxAdditionalNominalEntry, (NominalLedgerEntryStruct)tmp, (boolean)result.getIsUnfinished());
                }
            }
            NominalTaxEntry prepaidTaxTaxEntry = null;
            NominalTaxEntry prepaidTaxAdditionalTaxEntry = null;
            if (s[i].taxEntries.length > 0) {
                tmp = s[i].taxEntries[0];
                prepaidTaxTaxEntry = new NominalTaxEntry((NominalTransactionBase)result);
                prepaidTaxTaxEntry.setIsDownPayment(true);
                prepaidTaxTaxEntry.setSubPriority(subPriority);
                prepaidTaxTaxEntry.setIsPrepaidTax(true);
                NominalTaxEntryMapper.fillNominalTaxEntry((NominalTaxEntry)prepaidTaxTaxEntry, (NominalLedgerEntryStruct)tmp, (boolean)result.getIsUnfinished());
                if (s[i].taxEntries.length > 1) {
                    tmp = s[i].taxEntries[1];
                    prepaidTaxAdditionalTaxEntry = new NominalTaxEntry((NominalTransactionBase)result);
                    prepaidTaxAdditionalTaxEntry.setIsDownPayment(true);
                    prepaidTaxAdditionalTaxEntry.setSubPriority(subPriority);
                    prepaidTaxAdditionalTaxEntry.setIsPrepaidTax(true);
                    NominalTaxEntryMapper.fillNominalTaxEntry((NominalTaxEntry)prepaidTaxAdditionalTaxEntry, (NominalLedgerEntryStruct)tmp, (boolean)result.getIsUnfinished());
                }
            }
            PrepaidTax prepaidTax = new PrepaidTax(prepaidTaxNominalEntry, prepaidTaxTaxEntry, prepaidTaxAdditionalNominalEntry, prepaidTaxAdditionalTaxEntry);
            prepaidPaEntries[i].setPrepaidTax(prepaidTax);
        }
        result.setPrepaidPaEntries(prepaidPaEntries);
    }

    private static void checkDownPaymentOids(String[] downPaymentOids) throws BusinessDomainException {
        for (String oid : downPaymentOids) {
            try {
                OpenItem openItem = OpenItemPersistencyManager.getOpenItem((String)oid);
                openItem.reload();
            }
            catch (IncorrectResultSizeDataAccessException e) {
                throw TransferExceptionMapper.makeDownPaymentNotFoundDomainException(oid);
            }
        }
    }

    private static boolean isCorrectionCancelation(TransferInvoice invoice) {
        return invoice.isCorrection() && invoice.isCancel();
    }

    private static boolean isInvoiceCancelation(TransferInvoice invoice) throws BusinessDomainException {
        return TransferInvoiceHelper.isCancelation((TransferInvoice)invoice) && InvoiceTransactionCreator.isInvoice(invoice);
    }

    private static boolean isInvoice(TransferInvoice invoice) {
        return TransferTransactionTypeEnum.TTTE_CUSTOMER_FINALINVOICE.equals((Object)invoice.getType()) || TransferTransactionTypeEnum.TTTE_SUPPLIER_FINALINVOICE.equals((Object)invoice.getType()) || TransferTransactionTypeEnum.TTTE_CUSTOMERINVOICE.equals((Object)invoice.getType()) || TransferTransactionTypeEnum.TTTE_SUPPLIERINVOICE.equals((Object)invoice.getType());
    }

    private static boolean cancelationNotAllowed(TransferInvoice imp) throws BusinessDomainException {
        return TransferInvoiceHelper.isCancelation((TransferInvoice)imp) && imp.isPurchaseRegister();
    }

    private static NominalTransactionBase cancelInvoiceTransaction(TransferInvoice t) throws BusinessDomainException {
        boolean cancelAllocatedOpenItem;
        Date firstOpenDay;
        AccountingCompany company = TransferHelper.getCompany((String)t.getCompanyID());
        FinancialYear year = TransferHelper.getFinancialYear((TransferTransaction)t);
        PersonalAccount personalAccount = TransferHelper.getPersonalAccount((AccountingCompany)company, (String)t.getPersonalAccountEntry().getOpenItem().getPersonalaccountID(), (boolean)t.isCustomerInvoice(), (String)t.getPersonalAccountEntry().getOpenItem().getControlAccountID());
        String referenceNumber = !StringMapper.isNullString((String)t.getReferenceNumberCancel()) ? t.getReferenceNumberCancel() : t.getReferenceNumber();
        NominalTransactionBase[] transactions = NominalTransactionBasePersistencyManager.getTransactions((FinancialYear)year, (PersonalAccount)personalAccount, (boolean)t.getPersonalAccountEntry().isDebit(), (String)referenceNumber, null);
        if (transactions.length == 0) {
            throw TransferExceptionMapper.makeTransactionWithReferenceNumberNotFoundDomainException(referenceNumber);
        }
        if (transactions.length > 1) {
            throw TransferExceptionMapper.makeMultipleTransactionWithReferenceNumberFoundDomainException(referenceNumber);
        }
        if (TransferConfigPersistencyManager.getTransferConfig().getPostInNextFreePeriod() && (firstOpenDay = TransferTransactionHelper.getFirstOpenDay((FinancialYear)year, (TransferTransaction)t)) != null) {
            t.setTransactionDate(firstOpenDay);
        }
        if (!(cancelAllocatedOpenItem = TransferConfigPersistencyManager.getTransferConfig().getCancelAllocatedOpenItem()) && transactions[0].hasAllocatedItem() && !t.getImportCancelInvoiceWithBalancedOpenItem()) {
            throw TransferExceptionMapper.makeOpenItemIsAlreadyBalancedDomainException();
        }
        InvoiceTransaction toCancel = (InvoiceTransaction)transactions[0];
        BigDecimal cancelAmount = toCancel.getNegativePostingsAllowed() || t.isCorrection() ? TransferInvoiceHelper.getCancelAmount((TransferInvoice)t).negate() : TransferInvoiceHelper.getCancelAmount((TransferInvoice)t).abs();
        if (toCancel.getPersonalAccountEntry().getAmount().compareTo(cancelAmount) != 0) {
            throw TransferExceptionMapper.makeAmountCancelTransactionNotMatchingDomainException(toCancel.getPersonalAccountEntry().getAmount() + " / " + cancelAmount);
        }
        Batch batch = t.getSession().getBatchByType(toCancel.getBatch(), t.getBatchType());
        if (batch == null) {
            batch = toCancel.getBatch();
        }
        batch.setTransaction((NominalTransactionBase)toCancel);
        toCancel.makeSaveable();
        if (!toCancel.getIsJournalized()) {
            toCancel.journalize();
        }
        CancellationContext ctx = new CancellationContextBuilder(year, t.getTransactionDate()).withSequenceNumber(t.getSequenceNumber()).withDocumentDate(t.getDocumentDate()).withTaxDate(t.getTaxDate()).withReferenceNumber(t.getReferenceNumber()).withImportApplication(t.getSession().getImportApplication()).build();
        toCancel.cancelTransaction(ctx);
        NominalTransactionBase newTransaction = toCancel.getReverseTransactionBase();
        batch.addTransaction(newTransaction);
        try {
            batch.close();
        }
        catch (BusinessDomainException businessDomainException) {
            // empty catch block
        }
        return newTransaction;
    }

    private static ConversionRate getTaxOfficeRate(InvoiceTransaction result, TransferInvoice imp) throws BusinessDomainException {
        String[] transferTaxesWithoutDupl;
        Configuration configuration = (Configuration)UtilitiesManager.getBean((String)"com.infor.igf.configuration", Configuration.class);
        if (result.getForeignCurrencyRate() == null || result.getForeignCurrencyRate().getConversionRate() == null || imp.getTaxes() == null || imp.getTaxes().length == 0 || !result.getCompany().getJurisdictionType().equals((Object)JurisdictionType.PL) || !ISoftware.isKronospan() && !configuration.useInvRateBaseDateBasedOnTaxcodePL()) {
            return null;
        }
        Date conversionRate = result.getDocumentDate();
        TransferTax[] transferTaxes = imp.getTaxes();
        String[] taxCodes = new String[imp.getTaxes().length];
        for (int i = 0; i < transferTaxes.length; ++i) {
            taxCodes[i] = transferTaxes[i].getTaxCodeID();
        }
        for (String taxCodeID : transferTaxesWithoutDupl = (String[])Arrays.stream(taxCodes).distinct().toArray(String[]::new)) {
            TaxCodePL taxCodePL = (TaxCodePL)TaxCode.getTaxCodeByImportCode((String)taxCodeID, (JurisdictionType)result.getCompany().getJurisdictionType());
            if (taxCodePL != null && (taxCodePL.getBaseDateTaxPLType() == BaseDatePLType.DOCUMENTDATE || taxCodePL.getBaseDateTaxPLType() == BaseDatePLType.NONE)) {
                conversionRate = result.getDocumentDate();
                break;
            }
            conversionRate = result.getTaxDate();
        }
        return InvoiceTransactionCreator.getTaxOfficeRate(imp.getTaxes()[0], result, conversionRate);
    }

    private static ConversionRate getTaxOfficeRate(TransferTax transferTax, InvoiceTransaction result, Date dateConversionRate) throws BusinessDomainException {
        boolean inverseRate = result.getForeignCurrencyRate().getConversionRate().isInverseRate;
        if (BigDecimalMapper.isZeroOrNull((BigDecimal)transferTax.getBaseAmount()) || BigDecimalMapper.isZeroOrNull((BigDecimal)transferTax.getForeignAmount())) {
            ConversionTable conversionTable;
            TaxCode taxCode = TaxCode.getTaxCodeByImportCode((String)transferTax.getTaxCodeID(), (JurisdictionType)result.getCompany().getJurisdictionType());
            if (taxCode != null && taxCode.isEuErwerb() && (conversionTable = result.getFinanceSetup().getTaxOfficeRatesTable()) != null) {
                BigDecimal conversionRate = ExchangeRatePersistencyManager.getConversionRate((IConversionTable)conversionTable, (ICurrency)result.getForeignCurrencyRate().getCurrency(), (ICurrency)result.getBaseCurrency(), (Date)dateConversionRate, (boolean)true);
                return new ConversionRate(conversionRate, inverseRate);
            }
            return null;
        }
        return new ConversionRate(inverseRate ? transferTax.getForeignAmount().divide(transferTax.getBaseAmount(), 9, RoundingMode.HALF_UP) : transferTax.getBaseAmount().divide(transferTax.getForeignAmount(), 9, RoundingMode.HALF_UP), inverseRate);
    }
}

