/*
 * Decompiled with CFR 0.152.
 */
package com.varial.transfer.base;

import com.infor.igf.core.types.PersistableEnum;
import com.infor.igf.core.util.PersistableEnumUtils;
import com.infor.igf.core.util.StacktraceUtils;
import com.varial.base.error.ErrorList;
import com.varial.base.error.ErrorMessage;
import com.varial.base.error.Errors;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.i18n.Translatable;
import com.varial.framework.domain.paymentbase.ModeOfPayment;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.ExceptionMapper;
import java.math.BigDecimal;
import java.util.Date;

public final class TransferExceptionMapper {
    private static final int STACKTRACE_LEVEL = 1;
    private static final int PRESET_NOT_FOUND = 1;
    private static final int CORPORATEACCOUNT_NOT_FOUND = 2;
    private static final int LANGUAGE_NOT_FOUND = 3;
    private static final int PERSONALACCOUNT_ALREADY_EXISTS = 4;
    private static final int FINANCIALYEAR_NOT_FOUND = 5;
    private static final int FINANCESETUP_NOT_FOUND = 6;
    private static final int TAXCODE_HAS_NO_ACCOUNT = 7;
    private static final int DOCUMENTTYPE_NOT_FOUND = 12;
    private static final int NO_TAXTPE_SPECIFIED = 13;
    private static final int NO_TRANSACTION_WITH_REFERENCENUMBER_FOUND = 14;
    private static final int MULTIPLE_TRANSACTIONS_WITH_REFERENCENUMBER_FOUND = 15;
    private static final int AMOUNT_FOR_CANCEL_TRANSACTION_NOT_MATCHING = 16;
    private static final int DOCUMENTTYPE_AND_TAXREGISTER_DONT_MATCH = 17;
    private static final int DOCUMENTTYPE_NOT_ALLOWED = 18;
    private static final int TAXREGISTER_NOT_ALLOWED = 19;
    private static final int LASTDUNNINGDATE_IN_FUTURE = 20;
    private static final int CUSTOMER_HAS_NO_DUNNINGGROUP = 21;
    private static final int DUNNINGGRADE_NO_FOUND = 22;
    private static final int NO_SHORTADDRESS_SPECIFIED = 23;
    private static final int NO_NAME_SPECIFIED = 24;
    private static final int NO_TOWN_SPECIFIED = 25;
    private static final int ADDRESS_NOT_FOUND = 26;
    private static final int COMPANY_NOT_FOUND = 27;
    private static final int FINANCIALYEAR_NOT_FOUND_FOR_CODE = 30;
    private static final int FINANCESETUP_NOT_FOUND_FOR_YEAR = 31;
    private static final int FINANCIALYEARCODE_MISSING = 32;
    private static final int OPENITEM_ALREADY_BALANCED = 35;
    private static final int REPRESENTATIVE_NOT_FOUND = 36;
    private static final int CESSIONBANK_NOT_FOUND = 37;
    private static final int ADVISOR_NOT_FOUND = 38;
    private static final int NO_DOWNPAYMENTREQUEST_WITH_REFNUMBER_FOUND = 39;
    private static final int PERSONALACCOUNTID_NOT_FOUND = 40;
    private static final int ADJUSTMENT_NOT_ALLOWED = 41;
    private static final int PERSONALACCOUNT_NOT_IN_ASSOCIATION = 42;
    private static final int CANCELATION_NOT_ALLOWED = 60;
    private static final int MODEOFPAYMENT_DOES_NOT_FIT = 61;
    private static final int MORE_THAN_ONE_OPENITEM_FOR_CANCELATION = 62;
    private static final int INVALID_DATE_FORMAT = 63;
    private static final int TERMSOFPAYMENT_FOR_BILLOFEXCHANGE_NOT_FOUND = 64;
    private static final int REFUSALREASON_NOT_FOUND = 65;
    private static final int NO_PARENTACCOUNT_FOUND = 66;
    private static final int CHILDACCOUNT_ALREADY_EXISTS = 67;
    private static final int REFUSALREASON_NOT_ALLOWED = 68;
    private static final int CHILDACCOUNT_NOT_FOUND = 69;
    private static final int NO_OPENITEM_FOR_ALLOCATION_FOUND = 71;
    private static final int OIALLOCATION_IN_DIFFERENT_CURRENCIES_NOT_POSSIBLE = 72;
    private static final int ACCOUNTS_HAVE_SAME_CONTROLACCOUNT = 73;
    private static final int REFNUM_OF_INVOICE_ISNOT_UNIQUE = 75;
    private static final int FINANCIALYEAR_HAS_NO_PREVIOUSYEAR = 76;
    private static final int PREVIOUS_FINANCIALYEAR_CLOSED = 77;
    private static final int MULTIPLE_NLTRANSACTIONS_FOUND = 78;
    private static final int NO_NLTRANSACTIONS_FOUND = 79;
    private static final int COUNTRY_NOT_FOUND = 80;
    private static final int CORRECTION_NOT_ALLOWED = 81;
    private static final int MULTIPLE_TRANSACTIONS_FOR_CORRECTION = 82;
    private static final int NO_TRANSACTION_FOR_CORRECTION = 83;
    private static final int PLEASE_ENTER_INSTALMENT_AMOUNTS_MANUALLY = 84;
    private static final int TAXCODE_LOCKED = 85;
    private static final int TERMOFPAYMENT_LOCKED = 86;
    private static final int TERMOFPAYMENT_BILLEXCHANGE_LOCKED = 87;
    private static final int TERMOFPAYMENT_FREEFROMPAYMENT_LOCKED = 88;
    private static final int DUNNINGGROUP_NOT_FOUND = 89;
    private static final int CONVERSIONTABLE_NOT_FOUND = 90;
    private static final int DELIVERYCOUNTRY_NOT_FOUND = 91;
    private static final int BANKADDRESS_NOT_FOUND = 92;
    private static final int OPENITEM_NOT_FOUND = 93;
    private static final int DELIVERYCOUNTRY_IS_MISSING = 94;
    private static final int NOMINALLEDGER_NOT_FOUND = 95;
    private static final int BLOCKREASON_NOT_FOUND = 96;
    private static final int FINALINVOICE_TRANSFERRED = 97;
    private static final int TERMOFPAYMENT_HAS_WRONG_PAYMENTTYPE = 98;
    private static final int MULTIPLE_CASHTRANSFERS_FOUND = 99;
    private static final int NO_CASHTRANSFER_FOUND = 145;
    private static final int MORE_THAN_ONE_OPENITEM_FOR_ALLOCATION_FOUND = 146;
    private static final int PERIOD_NOT_FOUND = 147;
    private static final int SERVICETYPE_NOT_FOUND = 148;
    private static final int SEVERAL_PURCHASE_REGISTER_INVOICES_FOUND = 149;
    private static final int NO_PURCHASE_REGISTER_INVOICE_FOUND = 150;
    private static final int AMOUNT_IS_NOT_MATCHING = 151;
    private static final int STATUS_MUST_BE_NEW_OR_UNFINISHED = 152;
    private static final int TAX_TYPES_MUST_NOT_BE_MIXED = 153;
    private static final int DOWNPAYMENT_NOT_FOUND = 154;
    private static final int REFERENCENUMBER_DOES_NOT_MATCH = 155;
    private static final int CONVERSION_TABLE_MISSING = 156;
    private static final int OUTPUTTAX_TRANSACTION_HAS_INPUTTAX = 157;
    private static final int INPUTTAX_TRANSACTION_HAS_OUTPUTTAX = 158;
    private static final int REPRESENTATIVE_ALREADY_EXISTS = 159;
    private static final int ADDRESS_OR_SUPPLIER_REQUIRED = 160;
    private static final int SHORTNAME_IS_OBLIGATORY = 161;
    private static final int NAME_IS_OBLIGATORY = 162;
    private static final int TOWN_IS_OBLIGATORY = 163;
    private static final int CORRESPONDENCETEXT_NOT_FOUND = 164;
    private static final int DUPLICATE_RECORD_DETECTED = 165;
    private static final int TAX_CODE_NOT_FOUND = 166;
    private static final int NOMINAL_LEDGER_FOR_COMPANY_NOT_FOUND = 167;
    private static final int NLACCOUNT_WAS_NOT_FOUND = 168;
    private static final int NLACCOUNT_IS_REQUIRED = 169;
    private static final int COMPANY_IS_REQUIRED = 170;
    private static final int USER_NOT_FOUND = 171;
    private static final int USER_NOT_THE_SAME_IN_ALL_ENTRIES = 172;
    private static final int QR_REFERENCE_IS_REQUIRED = 173;
    private static final int WRONG_DOCUMENTTYPE_CASH_TRANSACTION = 174;
    @Translatable(type=Translatable.Type.ERRORLIST)
    @Errors
    private static final ErrorList mErrorList = new ErrorList("Transfer", new ErrorMessage[]{new ErrorMessage(1, "Customer/supplier preset not found."), new ErrorMessage(2, "Corporate account not found."), new ErrorMessage(3, "Language not found."), new ErrorMessage(4, "Customer/supplier with this code already exists."), new ErrorMessage(5, "No financial year found for date."), new ErrorMessage(6, "No finance setup found for date."), new ErrorMessage(7, "Tax code has no accounts set."), new ErrorMessage(12, "Documenttype not found."), new ErrorMessage(13, "No tax type specified."), new ErrorMessage(14, "No transaction with referencenumber found."), new ErrorMessage(15, "More than one transaction with referencenumber found."), new ErrorMessage(16, "Amount for cancel transaction doesnot match."), new ErrorMessage(17, "Documenttype and taxregister do not match."), new ErrorMessage(18, "Documenttype not allowed with this transaction."), new ErrorMessage(19, "Taxregister not allowed with this transaction."), new ErrorMessage(20, "Date of last dunning is in the future."), new ErrorMessage(21, "Customer has no dunning group."), new ErrorMessage(22, "Dunning grade not found."), new ErrorMessage(23, "No Shortaddress specified."), new ErrorMessage(24, "No Name specified."), new ErrorMessage(25, "No Town specified."), new ErrorMessage(26, "Address not found."), new ErrorMessage(27, "Company not found."), new ErrorMessage(30, "No financial year found for code."), new ErrorMessage(31, "No finance setup found for year."), new ErrorMessage(32, "Code of financial year must be filled."), new ErrorMessage(40, "PersonalAccountID not found."), new ErrorMessage(35, "Open Item is already balanced. Please confirm the reversing entry."), new ErrorMessage(36, "No representative for the specified code found."), new ErrorMessage(37, "No cession bank for specified code found."), new ErrorMessage(38, "No advisor for specified code found."), new ErrorMessage(39, "No downpaymen request with referencenumber found."), new ErrorMessage(60, "Cancelation for invoice type not allowed."), new ErrorMessage(61, "Mode of payment does not fit (with document, term of payment or personal account"), new ErrorMessage(62, "More than one open item for cancelation found."), new ErrorMessage(63, "Invalid date format! Dates must be specified in the format: YYYY-MM-DD!"), new ErrorMessage(64, "Terms of payment import code for bill of exchange not found."), new ErrorMessage(65, "Refusal reason couldn't be found."), new ErrorMessage(66, "No parent account for child account found. Please create a parent account first."), new ErrorMessage(67, "Child account already exists."), new ErrorMessage(68, "Refusal reasons are only allowed for insurance limits."), new ErrorMessage(69, "No child account found. Check the code or nominal account."), new ErrorMessage(71, "No open item for allocation found. Check the allocation reference number and document date."), new ErrorMessage(72, "Open item allocation in different currencies not possible."), new ErrorMessage(73, "Child account has same control account as parent account."), new ErrorMessage(75, "Reference number of invoice payable is not unique. Do you really want to post?"), new ErrorMessage(76, "No previous year for financial year found."), new ErrorMessage(77, "The previous financial year is already closed."), new ErrorMessage(78, "More than one nominal ledger transaction for cancellation found. The search filter consists of financial year, cancel documentdate, cancel sequencenumber and cancel referencenumber."), new ErrorMessage(79, "No nominal ledger transaction for cancellation found. The search filter consists of financial year, cancel documentdate, cancel sequencenumber and cancel referencenumber."), new ErrorMessage(80, "No country for specified import code found."), new ErrorMessage(81, "Correction document is not allowed for the company's jurisdiction. Please leave correction reference number and correction document date empty."), new ErrorMessage(82, "More than one transaction for correction found. The search filter consists of financial year, personal account, correction referencenumber and correction documentdate."), new ErrorMessage(83, "No transaction for correction found. The search filter consists of financial year, personal account, correction referencenumber and correction documentdate."), new ErrorMessage(84, "Please enter the instalment amounts manually. After successfully importing the record again you can specify them in the accounting program."), new ErrorMessage(85, "The tax code is locked. Please choose a valid one."), new ErrorMessage(86, "The term of payment is locked. Please choose a valid one."), new ErrorMessage(87, "The term of payment for bill of exchange is locked. Please choose a valid one."), new ErrorMessage(88, "The term of payment for payment holiday is locked. Please choose a valid one."), new ErrorMessage(89, "No dunning group for specified code found."), new ErrorMessage(90, "Conversion table could not be found."), new ErrorMessage(91, "Delivery country could not be found."), new ErrorMessage(94, "Delivery country is obligatory! Please specify a value!"), new ErrorMessage(92, "A bank address for the specified personal account, bank sorting code and account number could not be found."), new ErrorMessage(93, "An open item for the specified personal account, reference number and document date could not be found."), new ErrorMessage(95, "Nominal ledger could not be found."), new ErrorMessage(96, "Block reason could not be found."), new ErrorMessage(97, "Please notice: This is a final invoice!"), new ErrorMessage(98, "The term of payment for bill of exchange should have the payment type bill of exchange!"), new ErrorMessage(99, "More than one cash transfer for cancellation found. The search filter consists of financial year, documentdate, sequencenumber and referencenumbercancel."), new ErrorMessage(145, "No cash transfer for cancellation found. The search filter consists of financial year, documentdate, sequencenumber and referencenumbercancel."), new ErrorMessage(146, "More than one open item for allocation found. Maybe an allocation document date is needed!"), new ErrorMessage(41, "The allocation balance is negative or zero. An adjustment transaction is not allowed!"), new ErrorMessage(147, "No valid period for transaction date found!"), new ErrorMessage(148, "Service type not found"), new ErrorMessage(42, "The specified personal account is no member of the association! Please check the remainder open items!"), new ErrorMessage(149, "Several purchase register invoices found!"), new ErrorMessage(150, "No purchase register invoice found!"), new ErrorMessage(151, "The amount of the purchase register invoice is not matching!"), new ErrorMessage(152, "Only new or unfinished purchase register invoices can be updated!"), new ErrorMessage(153, "Tax types (input/output) must not be mixed in nominal ledger transactions!"), new ErrorMessage(154, "Downpayment could not be found!"), new ErrorMessage(155, "Purchase register invoice has been found but the reference number does not match!"), new ErrorMessage(156, "The finance setup doesn't contain a conversion table for this transaction type!"), new ErrorMessage(157, "A transaction using the tax type 'Output VAT' must not use input tax codes!"), new ErrorMessage(158, "A transaction using the tax type 'Input VAT' must not use output tax codes!"), new ErrorMessage(159, "A representative with this code already exists!"), new ErrorMessage(160, "Either an address or a supplier is required!"), new ErrorMessage(161, "Short name is an obligatory field and must not be left empty!"), new ErrorMessage(162, "Name is an obligatory field and must not be left empty!"), new ErrorMessage(163, "Town is an obligatory field and must not be left empty!"), new ErrorMessage(164, "Correspondence Text not found for the specified code!"), new ErrorMessage(165, "Sub Records of personal accounts have to be unique!"), new ErrorMessage(166, "Tax code with the particular import code was not found."), new ErrorMessage(167, "There is no nominal ledger in company's finance setup."), new ErrorMessage(168, "Nominal ledger account was not found."), new ErrorMessage(169, "Nominal ledger account cannot be null or empty string."), new ErrorMessage(170, "The company code cannot be null or empty string."), new ErrorMessage(171, "User does not exist."), new ErrorMessage(172, "Not the same user given in all NL Transaction entries."), new ErrorMessage(173, "A QR-IBAN (IID 30000-31999) can only be used with a QR-Reference. Please specify a QR-Reference."), new ErrorMessage(174, "Die Belegart passt nicht zum Buchungstyp Eingangs-/Ausgangszahlung, bzw. zum Typ des Bankkontos !")});

    private TransferExceptionMapper() {
    }

    public static BusinessDomainException makeQRReferenceRequiredDomainException() {
        return TransferExceptionMapper.makeTransferDomainException("", 173, mErrorList.getDefaultString(173));
    }

    private static BusinessDomainException makeTransferDomainException(String value, int errorNumber, String reason) {
        return ExceptionMapper.makeDomainException((String)"Transfer", (String)StacktraceUtils.getCallingClassAndMethod((int)1), (String)value, (int)errorNumber, (String)reason);
    }

    public static BusinessDomainException makePresetNotFoundDomainException(String code) {
        return TransferExceptionMapper.makeTransferDomainException(code, 1, mErrorList.getDefaultString(1));
    }

    public static BusinessDomainException makeCorporateAccountNotFoundDomainException(String code) {
        return TransferExceptionMapper.makeTransferDomainException(code, 2, mErrorList.getDefaultString(2));
    }

    public static BusinessDomainException makeLanguageNotFoundDomainException(String code) {
        return TransferExceptionMapper.makeTransferDomainException(code, 3, mErrorList.getDefaultString(3));
    }

    public static BusinessDomainException makePersonalAccountAlreadyExistsDomainException(String code) {
        return TransferExceptionMapper.makeTransferDomainException(code, 4, mErrorList.getDefaultString(4));
    }

    public static BusinessDomainException makeFinancialYearNotFoundDomainException(Date d) {
        return TransferExceptionMapper.makeTransferDomainException(DateMapper.toString((Date)d), 5, mErrorList.getDefaultString(5));
    }

    public static BusinessDomainException makeFinancialYearNotFoundForCodeDomainException() {
        return TransferExceptionMapper.makeTransferDomainException("", 30, mErrorList.getDefaultString(30));
    }

    public static BusinessDomainException makeFinanceSetupNotFoundDomainException(Date d) {
        return TransferExceptionMapper.makeTransferDomainException(DateMapper.toString((Date)d), 6, mErrorList.getDefaultString(6));
    }

    public static BusinessDomainException makeFinanceSetupNotFoundForYearDomainException() {
        return TransferExceptionMapper.makeTransferDomainException("", 31, mErrorList.getDefaultString(31));
    }

    public static BusinessDomainException makeFinancialYearCodeIsMissingDomainException() {
        return TransferExceptionMapper.makeTransferDomainException("", 32, mErrorList.getDefaultString(32));
    }

    public static BusinessDomainException makeTaxCodeHasNoAccountDomainException(String taxCode) {
        return TransferExceptionMapper.makeTransferDomainException(taxCode, 7, mErrorList.getDefaultString(7));
    }

    public static BusinessDomainException makeDocumentTypeNotFoundDomainException(String code) {
        return TransferExceptionMapper.makeTransferDomainException(code, 12, mErrorList.getDefaultString(12));
    }

    public static BusinessDomainException makeNoTaxTypeSpecifiedDomainException() {
        return TransferExceptionMapper.makeTransferDomainException("", 13, mErrorList.getDefaultString(13));
    }

    public static BusinessDomainException makeTransactionWithReferenceNumberNotFoundDomainException(String referenceNumber) {
        return TransferExceptionMapper.makeTransferDomainException(referenceNumber, 14, mErrorList.getDefaultString(14));
    }

    public static BusinessDomainException makeMultipleTransactionWithReferenceNumberFoundDomainException(String referenceNumber) {
        return TransferExceptionMapper.makeTransferDomainException(referenceNumber, 15, mErrorList.getDefaultString(15));
    }

    public static BusinessDomainException makeAmountCancelTransactionNotMatchingDomainException(String amounts) {
        return TransferExceptionMapper.makeTransferDomainException(amounts, 16, mErrorList.getDefaultString(16));
    }

    public static BusinessDomainException makeDocumentTypeTaxregisterNotMatchingDomainException() {
        return TransferExceptionMapper.makeTransferDomainException("", 17, mErrorList.getDefaultString(17));
    }

    public static BusinessDomainException makeDocumentTypeNotAllowedDomainException() {
        return TransferExceptionMapper.makeTransferDomainException("", 18, mErrorList.getDefaultString(18));
    }

    public static BusinessDomainException makeTaxRegisterNotAllowedDomainException() {
        return TransferExceptionMapper.makeTransferDomainException("", 19, mErrorList.getDefaultString(19));
    }

    public static BusinessDomainException makeLastDunningDateInFutureDomainException() {
        return TransferExceptionMapper.makeTransferDomainException("", 20, mErrorList.getDefaultString(20));
    }

    public static BusinessDomainException makeCustomerHasNoDunningGroupDomainException() {
        return TransferExceptionMapper.makeTransferDomainException("", 21, mErrorList.getDefaultString(21));
    }

    public static BusinessDomainException makeDunningGradeNotFoundDomainException() {
        return TransferExceptionMapper.makeTransferDomainException("", 22, mErrorList.getDefaultString(22));
    }

    public static BusinessDomainException makeNoShortAddressSpecifiedDomainException() {
        return TransferExceptionMapper.makeTransferDomainException("", 23, mErrorList.getDefaultString(23));
    }

    public static BusinessDomainException makeNoNameSpecifiedDomainException() {
        return TransferExceptionMapper.makeTransferDomainException("", 24, mErrorList.getDefaultString(24));
    }

    public static BusinessDomainException makeNoTownSpecifiedDomainException() {
        return TransferExceptionMapper.makeTransferDomainException("", 25, mErrorList.getDefaultString(25));
    }

    public static BusinessDomainException makeCompanyNotFoundDomainException(String companyID) {
        return TransferExceptionMapper.makeTransferDomainException(companyID, 27, mErrorList.getDefaultString(27));
    }

    public static BusinessDomainException makePersonalAccountIdNotFoundDomainException() {
        return TransferExceptionMapper.makeTransferDomainException("", 40, mErrorList.getDefaultString(40));
    }

    public static BusinessDomainException makeOpenItemIsAlreadyBalancedDomainException() {
        return TransferExceptionMapper.makeTransferDomainException("", 35, mErrorList.getDefaultString(35));
    }

    public static BusinessDomainException makeNoRepresentativeForCodeFoundDomainException(String id) {
        return TransferExceptionMapper.makeTransferDomainException(id, 36, mErrorList.getDefaultString(36));
    }

    public static BusinessDomainException makeCessionBankNotFoundDomainException(String id) {
        return TransferExceptionMapper.makeTransferDomainException(id, 37, mErrorList.getDefaultString(37));
    }

    public static BusinessDomainException makeNoAdvisorForCodeFoundDomainException(String id) {
        return TransferExceptionMapper.makeTransferDomainException(id, 38, mErrorList.getDefaultString(38));
    }

    public static BusinessDomainException makeDownpaymentRequestWithReferenceNumberNotFoundDomainException(String refnum) {
        return TransferExceptionMapper.makeTransferDomainException(refnum, 39, mErrorList.getDefaultString(39));
    }

    public static BusinessDomainException makeModeOfPaymentDoesNotFitDomainException(ModeOfPayment paymentType) {
        return TransferExceptionMapper.makeTransferDomainException(PersistableEnumUtils.toSQLPropertyValue((PersistableEnum)paymentType), 61, mErrorList.getDefaultString(61));
    }

    public static BusinessDomainException makeCancelationNotAllowedDomainException() {
        return TransferExceptionMapper.makeTransferDomainException("", 60, mErrorList.getDefaultString(60));
    }

    public static BusinessDomainException makeMoreThanOneOpenItemForCancelationDomainException() {
        return TransferExceptionMapper.makeTransferDomainException("", 62, mErrorList.getDefaultString(62));
    }

    public static BusinessDomainException makeInvalidDateFormatDomainException(String invalidDate) {
        return TransferExceptionMapper.makeTransferDomainException(invalidDate, 63, mErrorList.getDefaultString(63));
    }

    public static BusinessDomainException makeTermsOfPaymentForBillOfExchangeNotFoundDomainException(String importCode) {
        return TransferExceptionMapper.makeTransferDomainException(importCode, 64, mErrorList.getDefaultString(64));
    }

    public static BusinessDomainException makeRefusalReasonNotFoundDomainException(String refusalReasonID) {
        return TransferExceptionMapper.makeTransferDomainException(refusalReasonID, 65, mErrorList.getDefaultString(65));
    }

    public static BusinessDomainException makeNoParentAccountFoundDomainException(String parentAccountCode) {
        return TransferExceptionMapper.makeTransferDomainException(parentAccountCode, 66, mErrorList.getDefaultString(66));
    }

    public static BusinessDomainException makeChildAccountAlreadyExistsDomainException(String childAccountCode, String nominalAccountCode) {
        return TransferExceptionMapper.makeTransferDomainException(childAccountCode + " / " + nominalAccountCode, 67, mErrorList.getDefaultString(67));
    }

    public static BusinessDomainException makeRefusalReasonNotAllowedDomainException(String refusalreasonID) {
        return TransferExceptionMapper.makeTransferDomainException(refusalreasonID, 68, mErrorList.getDefaultString(68));
    }

    public static BusinessDomainException makeChildAccountNotFoundDomainException(String childAccountCode, String nominalAccountCode) {
        return TransferExceptionMapper.makeTransferDomainException(childAccountCode + " / " + nominalAccountCode, 69, mErrorList.getDefaultString(69));
    }

    public static BusinessDomainException makeNoOpenItemForAllocationFoundDomainException(String allocationReferenceNumber, String allocationDocumentDate) {
        String value = "Allocation reference number: >" + allocationReferenceNumber + "<, Allocation document date: >" + allocationDocumentDate + "<";
        return TransferExceptionMapper.makeTransferDomainException(value, 71, mErrorList.getDefaultString(71));
    }

    public static BusinessDomainException makeOpenItemAllocationInDifferentCurrenciesNotPossibleDomainException() {
        return TransferExceptionMapper.makeTransferDomainException("", 72, mErrorList.getDefaultString(72));
    }

    public static BusinessDomainException makeAccountsHaveSameControlAccount(String parentConAcc, String childConAcc) {
        return TransferExceptionMapper.makeTransferDomainException(parentConAcc + " / " + childConAcc, 73, mErrorList.getDefaultString(73));
    }

    public static BusinessDomainException makeReferenceNumberOfInvoiceIsNotUnique(String refNum) {
        return TransferExceptionMapper.makeTransferDomainException(refNum, 75, mErrorList.getDefaultString(75));
    }

    public static BusinessDomainException makeFinancialYearHasNoPreviousYear(String yearCode) {
        return TransferExceptionMapper.makeTransferDomainException(yearCode, 76, mErrorList.getDefaultString(76));
    }

    public static BusinessDomainException makePreviousFinancialYearClosedDomainException(String yearCode) {
        return TransferExceptionMapper.makeTransferDomainException(yearCode, 77, mErrorList.getDefaultString(77));
    }

    public static BusinessDomainException makeMultipleNLTransactionsForCancellationFoundDomainException(String financialYearCode, String cancelReferenceNumber, String cancelSequenceNumber, String cancelDocumentDate) {
        String value = "Financial year: " + financialYearCode + ", cancel referencenumber: " + cancelReferenceNumber + ", cancel sequencenumber: " + cancelSequenceNumber + ", cancel documentdate: " + cancelDocumentDate;
        return TransferExceptionMapper.makeTransferDomainException(value, 78, mErrorList.getDefaultString(78));
    }

    public static BusinessDomainException makeNoNLTransactionForCancellationFoundDomainException(String financialYearCode, String cancelReferenceNumber, String cancelSequenceNumber, String cancelDocumentDate) {
        String value = "Financial year: " + financialYearCode + ", cancel referencenumber: " + cancelReferenceNumber + ", cancel sequencenumber: " + cancelSequenceNumber + ", cancel documentdate: " + cancelDocumentDate;
        return TransferExceptionMapper.makeTransferDomainException(value, 79, mErrorList.getDefaultString(79));
    }

    public static BusinessDomainException makeCountryNotFoundDomainException(String importCode) {
        return TransferExceptionMapper.makeTransferDomainException(importCode, 80, mErrorList.getDefaultString(80));
    }

    public static BusinessDomainException makeCorrectionNotAllowedDomainException() {
        return TransferExceptionMapper.makeTransferDomainException("", 81, mErrorList.getDefaultString(81));
    }

    public static BusinessDomainException makeMultipleTransactionsForCorrectionFoundDomainException(String financialYearCode, String personalAccountCode, String correctionReferenceNumber, String correctionDocumentDate) {
        String value = "Financial year: " + financialYearCode + ", personal account: " + personalAccountCode + ", correction referencenumber: " + correctionReferenceNumber + ", correction documentdate: " + correctionDocumentDate;
        return TransferExceptionMapper.makeTransferDomainException(value, 82, mErrorList.getDefaultString(82));
    }

    public static BusinessDomainException makeNoTransactionForCorrectionFoundDomainException(String financialYearCode, String personalAccountCode, String correctionReferenceNumber, String correctionDocumentDate) {
        String value = "Financial year: " + financialYearCode + ", personal account: " + personalAccountCode + ", correction referencenumber: " + correctionReferenceNumber + ", correction documentdate: " + correctionDocumentDate;
        return TransferExceptionMapper.makeTransferDomainException(value, 83, mErrorList.getDefaultString(83));
    }

    public static BusinessDomainException makeEnterInstalmentAmountsManuallyDomainException() {
        return TransferExceptionMapper.makeTransferDomainException("", 84, mErrorList.getDefaultString(84));
    }

    public static BusinessDomainException makeTaxcodeLockedDomainException(String taxCodeID) {
        return TransferExceptionMapper.makeTransferDomainException(taxCodeID, 85, mErrorList.getDefaultString(85));
    }

    public static BusinessDomainException makeTermOfPaymentLockedDomainException(String termOfPaymentID) {
        return TransferExceptionMapper.makeTransferDomainException(termOfPaymentID, 86, mErrorList.getDefaultString(86));
    }

    public static BusinessDomainException makeTermOfPaymentBillExchangeLockedDomainException(String termOfPaymentID) {
        return TransferExceptionMapper.makeTransferDomainException(termOfPaymentID, 87, mErrorList.getDefaultString(87));
    }

    public static BusinessDomainException makeTermOfPaymentFreeFromPaymentLockedDomainException(String termOfPaymentID) {
        return TransferExceptionMapper.makeTransferDomainException(termOfPaymentID, 88, mErrorList.getDefaultString(88));
    }

    public static BusinessDomainException makeDunningGroupNotFoundDomainException(String dunningGroupID) {
        return TransferExceptionMapper.makeTransferDomainException(dunningGroupID, 89, mErrorList.getDefaultString(89));
    }

    public static BusinessDomainException makeConversionTableNotFoundDomainException(String conversionTableID) {
        return TransferExceptionMapper.makeTransferDomainException(conversionTableID, 90, mErrorList.getDefaultString(90));
    }

    public static BusinessDomainException makeDeliveryCountryNotFoundDomainException(String countryID) {
        return TransferExceptionMapper.makeTransferDomainException(countryID, 91, mErrorList.getDefaultString(91));
    }

    public static BusinessDomainException makeBankAddressNotFoundDomainException(String paCode, String bankSortingCode, String bankAccountNumber) {
        return TransferExceptionMapper.makeTransferDomainException("personalaccount: " + paCode + " / banksortingcode: " + bankSortingCode + " / bankaccountnumber: " + bankAccountNumber, 92, mErrorList.getDefaultString(92));
    }

    public static BusinessDomainException makeOpenItemNotFoundDomainException(String paCode, String referenceNumber, String documentDate) {
        return TransferExceptionMapper.makeTransferDomainException("personalaccount: " + paCode + " / referencenumber: " + referenceNumber + " / documentdate: " + documentDate, 93, mErrorList.getDefaultString(93));
    }

    public static BusinessDomainException makeNominalLedgerNotFoundDomainException(String nlLedgerCode) {
        return TransferExceptionMapper.makeTransferDomainException(nlLedgerCode, 95, mErrorList.getDefaultString(95));
    }

    public static BusinessDomainException makeDeliveryCountryMissingDomainException() {
        return TransferExceptionMapper.makeTransferDomainException("", 94, mErrorList.getDefaultString(94));
    }

    public static BusinessDomainException makeBlockReasonNotFoundDomainException(String blockReasonID) {
        return TransferExceptionMapper.makeTransferDomainException(blockReasonID, 96, mErrorList.getDefaultString(96));
    }

    public static BusinessDomainException makeFinalInvoiceTransferredDomainException(String referenceNumber) {
        return TransferExceptionMapper.makeTransferDomainException(referenceNumber, 97, mErrorList.getDefaultString(97));
    }

    public static BusinessDomainException makeTermOfPaymentHasWrongPaymentTypeDomainException(String termID) {
        return TransferExceptionMapper.makeTransferDomainException(termID, 98, mErrorList.getDefaultString(98));
    }

    public static BusinessDomainException makeMultipleCashTransfersForCancellationFoundDomainException(String financialYearCode, String cancelReferenceNumber, String cancelSequenceNumber, String cancelDocumentDate) {
        String value = "Financial year: " + financialYearCode + ", referenceNumberCancel: " + cancelReferenceNumber + ", sequenceNumber: " + cancelSequenceNumber + ", documentDate: " + cancelDocumentDate;
        return TransferExceptionMapper.makeTransferDomainException(value, 99, mErrorList.getDefaultString(99));
    }

    public static BusinessDomainException makeNoCashTransferForCancellationFoundDomainException(String financialYearCode, String cancelReferenceNumber, String cancelSequenceNumber, String cancelDocumentDate) {
        String value = "Financial year: " + financialYearCode + ", referenceNumberCancel: " + cancelReferenceNumber + ", sequenceNumber: " + cancelSequenceNumber + ", documentDate: " + cancelDocumentDate;
        return TransferExceptionMapper.makeTransferDomainException(value, 145, mErrorList.getDefaultString(145));
    }

    public static BusinessDomainException makeMoreThanOneOpenItemForAllocationFoundDomainException(String allocationReferenceNumber, String allocationDocumentDate) {
        String value = "Allocation reference number: [" + allocationReferenceNumber + "], Allocation document date: [" + allocationDocumentDate + "]";
        return TransferExceptionMapper.makeTransferDomainException(value, 146, mErrorList.getDefaultString(146));
    }

    public static BusinessDomainException makeAdjustmentNotAllowedDomainException(String value) {
        return TransferExceptionMapper.makeTransferDomainException(value, 41, mErrorList.getDefaultString(41));
    }

    public static BusinessDomainException makePeriodNotFoundDomainException(Date transactionDate, String yearCode) {
        String value = "Transaction date [" + DateMapper.toString((Date)transactionDate) + "], Financial year [" + yearCode + "]";
        return TransferExceptionMapper.makeTransferDomainException(value, 147, mErrorList.getDefaultString(147));
    }

    public static BusinessDomainException makeServiceTypeNotFoundDomainException(String awvCode) {
        return TransferExceptionMapper.makeTransferDomainException(awvCode, 148, mErrorList.getDefaultString(148));
    }

    public static BusinessDomainException makePersonalAccountNotInAssociationDomainException(String associationID, String personalAccountID) {
        return TransferExceptionMapper.makeTransferDomainException("AssociationID [" + associationID + "], PersonalAccountID [" + personalAccountID + "]", 42, mErrorList.getDefaultString(42));
    }

    public static BusinessDomainException makeSeveralPurchaseRegisterInvoicesFoundDomainException(String referenceNumber) {
        return TransferExceptionMapper.makeTransferDomainException(referenceNumber, 149, mErrorList.getDefaultString(149));
    }

    public static BusinessDomainException makeNoPurchaseRegisterInvoiceFoundDomainException(String referenceNumber) {
        return TransferExceptionMapper.makeTransferDomainException(referenceNumber, 150, mErrorList.getDefaultString(150));
    }

    public static BusinessDomainException makeAmountIsNotMatchingDomainException(BigDecimal foundAmount, BigDecimal importAmount) {
        return TransferExceptionMapper.makeTransferDomainException("Existing amount: [" + foundAmount + "], imported amount: [" + importAmount + "]", 151, mErrorList.getDefaultString(151));
    }

    public static BusinessDomainException makeStatusMustBeNewOrUnfinishedDomainException() {
        return TransferExceptionMapper.makeTransferDomainException("", 152, mErrorList.getDefaultString(152));
    }

    public static BusinessDomainException makeTaxTypesMustNotBeMixedDomainException(String taxCodeID) {
        return TransferExceptionMapper.makeTransferDomainException(taxCodeID, 153, mErrorList.getDefaultString(153));
    }

    public static BusinessDomainException makeDownPaymentNotFoundDomainException(String downPaymentOid) {
        return TransferExceptionMapper.makeTransferDomainException(downPaymentOid, 154, mErrorList.getDefaultString(154));
    }

    public static BusinessDomainException makeReferenceNumberDoesNotMatchDomainException(String referenceNumber) {
        return TransferExceptionMapper.makeTransferDomainException(referenceNumber, 155, mErrorList.getDefaultString(155));
    }

    public static BusinessDomainException makeConversionTableMissingDomainException(String tableType) {
        return TransferExceptionMapper.makeTransferDomainException("Conversion table type [" + tableType + "]", 156, mErrorList.getDefaultString(156));
    }

    public static BusinessDomainException makeInputTaxNotAllowedDomainException(String taxCodeId) {
        return TransferExceptionMapper.makeTransferDomainException(taxCodeId, 157, mErrorList.getDefaultString(157));
    }

    public static BusinessDomainException makeOutputTaxNotAllowedDomainException(String taxCodeId) {
        return TransferExceptionMapper.makeTransferDomainException(taxCodeId, 158, mErrorList.getDefaultString(158));
    }

    public static BusinessDomainException makeRepresentativeAlreadyExistsDomainException(String representativeID) {
        return TransferExceptionMapper.makeTransferDomainException(representativeID, 159, mErrorList.getDefaultString(159));
    }

    public static BusinessDomainException makeEitherAddressOrSupplierRequiredDomainException() {
        return TransferExceptionMapper.makeTransferDomainException("", 160, mErrorList.getDefaultString(160));
    }

    public static BusinessDomainException makeShortNameIsObligatoryDomainException() {
        return TransferExceptionMapper.makeTransferDomainException("", 161, mErrorList.getDefaultString(161));
    }

    public static BusinessDomainException makeNameIsObligatoryDomainException() {
        return TransferExceptionMapper.makeTransferDomainException("", 162, mErrorList.getDefaultString(162));
    }

    public static BusinessDomainException makeTownIsObligatoryDomainException() {
        return TransferExceptionMapper.makeTransferDomainException("", 163, mErrorList.getDefaultString(163));
    }

    public static BusinessDomainException makeCorrespondenceTextNotFoundDomainException(String value) {
        return TransferExceptionMapper.makeTransferDomainException(value, 164, mErrorList.getDefaultString(164));
    }

    public static BusinessDomainException makeDuplicateRecordDetectedDomainException(String value) {
        return TransferExceptionMapper.makeTransferDomainException(value, 165, mErrorList.getDefaultString(165));
    }

    public static BusinessDomainException makeTaxCodeWasNotFoundDomainException(String taxCodeID) {
        return TransferExceptionMapper.makeTransferDomainException(taxCodeID, 166, mErrorList.getDefaultString(166));
    }

    public static BusinessDomainException makeNominalLedgerForCompanyNotFoundDomainException(String companyCode) {
        return TransferExceptionMapper.makeTransferDomainException("Company: " + companyCode, 167, mErrorList.getDefaultString(167));
    }

    public static BusinessDomainException makeNlAccountNotFoundDomainException(String nlAccountCode) {
        return TransferExceptionMapper.makeTransferDomainException("Nominal Ledger account: " + nlAccountCode, 168, mErrorList.getDefaultString(168));
    }

    public static BusinessDomainException makeCompanyCodeRequiredDomainException(String companyCode) {
        return TransferExceptionMapper.makeTransferDomainException("Company code: " + companyCode, 170, mErrorList.getDefaultString(170));
    }

    public static BusinessDomainException makeNlAccountRequiredDomainException(String nlAccountCode) {
        return TransferExceptionMapper.makeTransferDomainException("Nominal Ledger account: " + nlAccountCode, 169, mErrorList.getDefaultString(169));
    }

    public static BusinessDomainException makeUserNotFoundException(String userCode) {
        return TransferExceptionMapper.makeTransferDomainException(userCode, 171, mErrorList.getDefaultString(171));
    }

    public static BusinessDomainException makeUserNotTheSameInAllNLEntriesException() {
        return TransferExceptionMapper.makeTransferDomainException("", 172, mErrorList.getDefaultString(172));
    }

    public static BusinessDomainException makeWrongDocumentTypeForCashTransactionDomainException() {
        return TransferExceptionMapper.makeTransferDomainException("", 174, mErrorList.getDefaultString(174));
    }
}

