/*
 * Decompiled with CFR 0.152.
 */
package com.varial.assetaccounting.domain.fixedasset;

import com.varial.accounting.domain.financialyear.AccountingCompany;
import com.varial.accounting.domain.nominalledger.NominalLedgerAccount;
import com.varial.assetaccounting.assetaccsetup.CostCentreValidationEnum;
import com.varial.assetaccounting.calculationmethod.BaseCalcEnum;
import com.varial.assetaccounting.calculationmethod.DepreciationTypeEnum;
import com.varial.assetaccounting.calculationmethod.MethodTypeEnum;
import com.varial.assetaccounting.depreciation.DepreciationFunctionEnum;
import com.varial.assetaccounting.domain.accountgroup.AccountGroup;
import com.varial.assetaccounting.domain.assetaccsetup.AssetaccountingSetup;
import com.varial.assetaccounting.domain.averageusefulllife.AssetsAverageUsefullLife;
import com.varial.assetaccounting.domain.calculationmethod.CalcMethod;
import com.varial.assetaccounting.domain.calculationmethod.CalcMethodPersistencyManager;
import com.varial.assetaccounting.domain.calculationmethod.DepreciationMethodData;
import com.varial.assetaccounting.domain.depreciation.DepreciationCalculation;
import com.varial.assetaccounting.domain.depreciation.DepreciationCalculationHelper;
import com.varial.assetaccounting.domain.depreciationarea.DepreciationArea;
import com.varial.assetaccounting.domain.fafinancialyear.FAFinancialYear;
import com.varial.assetaccounting.domain.fixedasset.DepreciationPlanIT;
import com.varial.assetaccounting.domain.fixedasset.DepreciationStartMapper;
import com.varial.assetaccounting.domain.fixedasset.FACostCentre;
import com.varial.assetaccounting.domain.fixedasset.FASplitDeprAccount;
import com.varial.assetaccounting.domain.fixedasset.FASplitDeprAccountPersistencyManager;
import com.varial.assetaccounting.domain.fixedasset.FixedAsset;
import com.varial.assetaccounting.domain.fixedasset.FixedAssetAreaAccumValues;
import com.varial.assetaccounting.domain.fixedasset.FixedAssetAreaPersistencyManager;
import com.varial.assetaccounting.domain.fixedasset.FixedAssetData;
import com.varial.assetaccounting.domain.fixedasset.FixedAssetExceptionMapper;
import com.varial.assetaccounting.domain.fixedasset.FixedAssetTransaction;
import com.varial.assetaccounting.domain.fixedasset.FixedAssetTransactionExceptionMapper;
import com.varial.assetaccounting.domain.fixedasset.FixedAssetTransactionPersistencyManager;
import com.varial.assetaccounting.domain.fixedasset.StatusMapper;
import com.varial.assetaccounting.domain.indexseries.IndexSeries;
import com.varial.assetaccounting.fixedasset.DepreciationStartEnum;
import com.varial.assetaccounting.fixedasset.FolderEnum;
import com.varial.assetaccounting.fixedasset.StatusEnum;
import com.varial.assetaccounting.fixedasset.TransactionEnum;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.persistency.criterion.Criterion;
import com.varial.base.persistency.criterion.Junction;
import com.varial.base.persistency.criterion.Restrictions;
import com.varial.base.protocol.ProtocolText;
import com.varial.base.types.date.DateHelper;
import com.varial.costing.base.domain.costcentrebase.CostCentreBase;
import com.varial.framework.basictypes.ReportFileStructCallback;
import com.varial.framework.domain.company.JurisdictionType;
import com.varial.interfaces.ICurrency;
import com.varial.serverbase.basictypes.VDate;
import com.varial.serverbase.domain.language.Language;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.BooleanMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.persistency.IPersistentObject;
import com.varial.serverbase.persistency.PersistentObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixedAssetArea
extends PersistentObject {
    protected static Logger LOGGER = LoggerFactory.getLogger((String)FixedAssetArea.class.getName());
    private static final int PRIORITY = 2;
    protected static final String CLASSNAME = FixedAssetArea.class.getName();
    private static final String PROTOCOL_CLASSNAME = "FixedAsset";
    private FixedAsset mFixedAsset;
    private DepreciationArea mArea;
    private AccountGroup mAccountGroup;
    private DepreciationStartEnum mDepreciationStart;
    private short mPeriodInYears;
    private short mPeriodInMonth;
    private String mOidDepreciationMethod;
    private BigDecimal mDepreciationPercent;
    private BigDecimal mShiftFactor;
    private BigDecimal mPerfInUnits;
    private BigDecimal mResidualUnits;
    private String mOidSpecDepreciationMethod;
    private BigDecimal mSpecDepreciationPercent;
    private boolean mDepBelowZero;
    private BigDecimal mDepResValue;
    private IndexSeries mReplacementIndex;
    private String mOidImputedInterestMethod;
    private BigDecimal mImputedInterestPercent;
    private Date mDeprStartDate;
    private Date mLastDeprDate;
    private Date mLastInterestCalcDate;
    private Date mSpecDeprStartDate;
    private Date mRetirementDate;
    private Date mProcessingDate;
    private short mResPeriodInYears;
    private short mResPeriodInMonth;
    private StatusEnum mStatus;
    private boolean mIsFullDisposed;
    private BigDecimal mReplacementValue;
    private BigDecimal mHistoricalAcquisitionValue;
    private AssetsAverageUsefullLife mReferenzToAvUsefullLifeTable;
    private BigDecimal mAcquisitionValue;
    private BigDecimal mNetBookValue;
    private BigDecimal mAccumDeprValue;
    private DepreciationPlanIT[] mDeprPlanIT;
    private FASplitDeprAccount[] mFASplitDeprAccount;
    private BigDecimal mTaxAcquisitionValuePL;
    private Date mInterruptDeprFromDate;
    private Date mInterruptDeprToDate;
    private Date mValidFromDate;
    private Date mValidToDate;
    private String mOidCompany;
    private FolderEnum mType;
    private int mLifeInDays;
    private int mResLifeInDays;
    private NominalLedgerAccount mAssetAccount;
    private NominalLedgerAccount mNewAddOffsetAccount;
    private NominalLedgerAccount mDisposalOffsetAccount;
    private NominalLedgerAccount mAccValuationDepr;
    private boolean mIsCalledFromDepreciation;
    private BigDecimal mFixDeprAmount;
    private final String mYearLowValue2018 = "2017-12-31";
    private Date mCheckDateForValidation;
    private static final String FIXEDASSET = "fixedAsset";
    private static final String AREA = "area";
    private static final String ACCOUNTGROUP = "accountgroup";
    private static final String DEPRECIATIONSTART = "depreciationStart";
    private static final String PERIODINYEARS = "periodinyears";
    private static final String PERIODINMONTH = "periodinmonth";
    private static final String OIDDEPRECIATIONMETHOD = "oiddepreciationmethod";
    private static final String DEPRECIATIONPERCENT = "depreciationpercent";
    private static final String SHIFTFACTOR = "shiftfactor";
    private static final String PERFINUNITS = "perfinunits";
    private static final String RESIDUALUNITS = "residualunits";
    private static final String OIDSPECDEPRECIATIONMETHOD = "oidspecdepreciationmethod";
    private static final String SPECDEPRECIATIONPERCENT = "specdepreciationpercent";
    private static final String DEPBELOWZERO = "depbelowzero";
    private static final String DEPRESVALUE = "depresvalue";
    private static final String REPLACEMENTINDEX = "replacementindex";
    private static final String OIDIMPUTEDINTERESTMETHOD = "oidimputedinterestmethod";
    private static final String IMPUTEDINTERESTPERCENT = "imputedinterestpercent";
    private static final String DEPRSTARTDATE = "deprstartdate";
    private static final String LASTDEPRDATE = "lastdeprdate";
    private static final String LASTINTERESTCALCDATE = "lastinterestcalcdate";
    private static final String SPECDEPRSTARTDATE = "specdeprstartdate";
    private static final String PROCESSINGDATE = "processingdate";
    private static final String RETIREMENTDATE = "retirementdate";
    private static final String RESPERIODINYEARS = "resperiodinyears";
    private static final String RESPERIODINMONTH = "resperiodinmonth";
    private static final String STATUS = "status";
    private static final String ISFULLDISPOSED = "isfulldisposed";
    private static final String REPLACEMENTVALUE = "replacementvalue";
    private static final String HISTORICALACQUISITIONVALUE = "historicalAcquisitionValue";
    private static final String TAXACQUISITIONVALUEPL = "taxAcquisitionValuePL";
    private static final String ACQUISITIONVALUE = "AcquisitionValue";
    private static final String NETBOOKVALUE = "NetBookValue";
    private static final String ACCUMDEPRVALUE = "AccumDeprValue";
    private static final String VALIDFROMDATE = "validfromdate";
    private static final String VALIDTODATE = "validtodate";
    private static final String FIXDEPRAMOUNT = "fixdepramount";
    public static ProtocolText[] mDefaults = new ProtocolText[]{new ProtocolText("fixedAsset", "Fixed Asset"), new ProtocolText("area", "Area"), new ProtocolText("accountgroup", "Account Group"), new ProtocolText("depreciationStart", "Depreciation Start"), new ProtocolText("periodinyears", "Life in Years"), new ProtocolText("periodinmonth", "Life in Months"), new ProtocolText("oiddepreciationmethod", "Depreciation Method"), new ProtocolText("depreciationpercent", "Depreciation Percent"), new ProtocolText("shiftfactor", "Shift Factor"), new ProtocolText("perfinunits", "Performance in Units"), new ProtocolText("residualunits", "Residual Units"), new ProtocolText("oidspecdepreciationmethod", "Special Depreciation Method"), new ProtocolText("specdepreciationpercent", "Special Depreciation Percent"), new ProtocolText("depbelowzero", "Depreciation below Zero"), new ProtocolText("depresvalue", "Depreciation Residual Value"), new ProtocolText("replacementindex", "Replacement Index"), new ProtocolText("oidimputedinterestmethod", "Imputed Interest Method"), new ProtocolText("imputedinterestpercent", "Imputed Interest Percent"), new ProtocolText("deprstartdate", "Depreciation Start Date"), new ProtocolText("lastdeprdate", "Last Depreciation Date"), new ProtocolText("lastinterestcalcdate", "Last Interest Calculation Date"), new ProtocolText("specdeprstartdate", "Special Depreciation Start Date"), new ProtocolText("processingdate", "Processing Date"), new ProtocolText("retirementdate", "Retirement Date"), new ProtocolText("resperiodinyears", "Remaining Life in Years"), new ProtocolText("resperiodinmonth", "Remaining Life in Months"), new ProtocolText("status", "Status"), new ProtocolText("isfulldisposed", "Is full Disposed"), new ProtocolText("replacementvalue", "Replacement Value"), new ProtocolText("historicalAcquisitionValue", "Historical Acquisition Value"), new ProtocolText("taxAcquisitionValuePL", "Tax Acquisition Value"), new ProtocolText("AcquisitionValue", "Acquisition Value"), new ProtocolText("NetBookValue", "Net Book Value"), new ProtocolText("AccumDeprValue", "Accumulated Depreciation Value"), new ProtocolText("validfromdate", "Valid from Date"), new ProtocolText("validtodate", "Valid to Date"), new ProtocolText("fixdepramount", "Fix Depreciation Amount")};
    private boolean mIsFromTransfer = false;
    private Language mGlobalLanguage;

    public FixedAssetArea(FixedAsset fixedAsset) {
        super(2);
        this.mFixedAsset = fixedAsset;
    }

    public FixedAssetArea(boolean readOnly, FixedAsset fixedAsset) {
        super(2, readOnly);
        this.mFixedAsset = fixedAsset;
        this.setProtocolling(this.getProtocolClassName());
        super.setObjectidCompanyForProtocol(this.mFixedAsset.getAccountCompany().getObjectid());
    }

    public FixedAssetArea(String objectid, int version, FixedAsset fixedAsset) {
        super(2, objectid, version);
        this.mFixedAsset = fixedAsset;
        this.setProtocolling(this.getProtocolClassName());
        super.setObjectidCompanyForProtocol(this.mFixedAsset.getAccountCompany().getObjectid());
    }

    public FixedAssetArea(FixedAsset fixedAsset, FixedAssetArea originalArea) {
        super(2);
        this.mFixedAsset = fixedAsset;
        this.setDeprArea(originalArea.getDeprArea());
        this.setAccountGroup(originalArea.getAccountGroup());
        this.setDepreciationStart(originalArea.getDepreciationStart());
        this.setPeriodInYears(originalArea.getPeriodInYears());
        this.setPeriodInMonth(originalArea.getPeriodInMonth());
        this.setOidDepreciationMethod(originalArea.getOidDepreciationMethod());
        this.setDepreciationPercent(originalArea.getDepreciationPercent());
        this.setShiftFactor(originalArea.getShiftFactor());
        this.setPerfInUnits(originalArea.getPerfInUnits());
        this.setResidualUnits(originalArea.getResidualUnits());
        this.setOidSpecDepreciationMethod(originalArea.getOidSpecDepreciationMethod());
        this.setSpecDepreciationPercent(originalArea.getSpecDepreciationPercent());
        this.setDepBelowZero(originalArea.getDepBelowZero());
        this.setDepResValue(originalArea.getDepResValue());
        this.setReplacementIndex(originalArea.getReplacementIndex());
        this.setOidImputedInterestMethod(originalArea.getOidImputedInterestMethod());
        this.setImputedInterestPercent(originalArea.getImputedInterestPercent());
        this.setDeprStartDate(originalArea.getDeprStartDate());
        this.setLastDeprDate(originalArea.getLastDeprDate());
        this.setResPeriodInYears(originalArea.getResPeriodInYears());
        this.setResPeriodInMonth(originalArea.getResPeriodInMonth());
        this.setStatus(originalArea.getStatus());
        this.setIsFullDisposed(originalArea.getIsFullDisposed());
        this.setReplacementValue(originalArea.getReplacementValue());
        this.setHistoricalAcquisitionValue(originalArea.getHistoricalAcquisitionValue());
        this.setReferenzToAvUsefullLifeTable(originalArea.getReferenzToAvUsefullLifeTable());
        this.setDepreciationPlanIT(originalArea.getDepreciationPlanIT());
        this.setFASplitDeprAccounts(originalArea.getFASplitDeprAccounts());
        this.setTaxAcquisitionValuePL(originalArea.getTaxAcquisitionValuePL());
        this.setValidFromDate(originalArea.getValidFromDate());
        this.setValidToDate(originalArea.getValidToDate());
        this.setOidCompany(originalArea.getOidCompany());
        this.setType(originalArea.getType());
        this.setUsefullLifeInDays(originalArea.getUsefullLifeInDays());
        this.setResLifeInDays(originalArea.getResLifeInDays());
        this.setAssetAccount(originalArea.getAssetAccount());
        this.setAccValuationDepreciation(originalArea.getAccValuationDepreciation());
        this.setNewAddOffsetAccount(originalArea.getNewAddOffsetAccount());
        this.setDisposalOffsetAccount(originalArea.getDisposalOffsetAccount());
        this.setFixDeprAmount(originalArea.getFixDeprAmount());
    }

    protected void load() {
        FixedAssetAreaPersistencyManager.load((FixedAssetArea)this);
    }

    protected void deleteImpl() {
        FixedAssetAreaPersistencyManager.delete((FixedAssetArea)this);
    }

    public String getClassName() {
        return this.getProtocolClassName();
    }

    public String getProtocolClassName() {
        return PROTOCOL_CLASSNAME;
    }

    public String getDomainKey() {
        return this.mFixedAsset.getDomainKey() + "/" + this.mArea.getCode();
    }

    protected void saveImpl() {
        FixedAssetAreaPersistencyManager.save((FixedAssetArea)this);
    }

    public static FixedAssetArea[] getFixedAssetAreas(FixedAsset fixedAsset) {
        return FixedAssetAreaPersistencyManager.getFixedAssetAreas((FixedAsset)fixedAsset);
    }

    public static FixedAssetArea[] getFixedAssetAreas(AccountingCompany company, FixedAsset fa) {
        DepreciationArea[] deprAreas = DepreciationArea.getDepreciationAreas((AccountingCompany)company);
        FixedAssetArea[] faa = new FixedAssetArea[deprAreas.length];
        for (int i = 0; i < deprAreas.length; ++i) {
            faa[i] = new FixedAssetArea(fa);
            faa[i].setDeprArea(deprAreas[i]);
            faa[i].setDepreciationStart(DepreciationStartEnum.DSE_ACQ_MONTH);
            faa[i].setStatus(StatusEnum.STE_ACTIVATED);
            faa[i].setType(FolderEnum.FOE_FIXEDASSET);
        }
        return faa;
    }

    public static FixedAssetArea[] getFixedAssetAreas(ReportFileStructCallback callback, Language language, DepreciationArea deprArea) {
        return FixedAssetAreaPersistencyManager.getFixedAssetAreas((ReportFileStructCallback)callback, (Language)language, (DepreciationArea)deprArea);
    }

    public static FixedAssetArea getFixedAssetArea(FixedAsset fixedAsset, DepreciationArea deprArea) {
        return FixedAssetAreaPersistencyManager.getFixedAssetArea((FixedAsset)fixedAsset, (DepreciationArea)deprArea);
    }

    protected void setData(DepreciationArea area, AccountGroup accountGroup, DepreciationStartEnum depreciationStart, short periodInYears, short periodInMonth, String oidDepreciationMethod, BigDecimal depreciationPercent, BigDecimal shiftFactor, BigDecimal perfInUnits, BigDecimal residualUnits, String oidSpecDepreciationMethod, BigDecimal specDepreciationPercent, boolean depBelowZero, BigDecimal depResValue, IndexSeries replacementIndex, String oidImputedInterestMethod, BigDecimal imputedInterestPercent, Date deprStartDate, Date lastDeprDate, Date lastInterestCalcDate, Date specDeprStartDate, short resPeriodInYears, short resPeriodInMonth, StatusEnum status, boolean isFullDisposed, BigDecimal replacementValue, BigDecimal historicalAcquisitionValue, DepreciationPlanIT[] deprPlanIT, Date processingDate, Date retirementDate, AssetsAverageUsefullLife referenzToAvUsefullLifeTable, BigDecimal taxAcquisitionValuePL, Date interruptDeprFromDate, Date interruptDeprToDate, Date validFromDate, Date validToDate, String oidCompany, FolderEnum type, int lifeInDays, int resLifeInDays, NominalLedgerAccount assetAccount, NominalLedgerAccount newAddOffsetAccount, NominalLedgerAccount disposalOffsetAccount, NominalLedgerAccount accValuationDepr, BigDecimal acquisiationValue, BigDecimal netBookValue, BigDecimal accumDeprValue, boolean isCalledFromDepreciation, BigDecimal fixDeprAmount) {
        this.mArea = area;
        this.mAccountGroup = accountGroup;
        this.mDepreciationStart = depreciationStart;
        this.mPeriodInYears = periodInYears;
        this.mPeriodInMonth = periodInMonth;
        this.mOidDepreciationMethod = oidDepreciationMethod;
        this.mDepreciationPercent = depreciationPercent;
        this.mShiftFactor = shiftFactor;
        this.mPerfInUnits = perfInUnits;
        this.mResidualUnits = residualUnits;
        this.mOidSpecDepreciationMethod = oidSpecDepreciationMethod;
        this.mSpecDepreciationPercent = specDepreciationPercent;
        this.mDepBelowZero = depBelowZero;
        this.mDepResValue = depResValue;
        this.mReplacementIndex = replacementIndex;
        this.mOidImputedInterestMethod = oidImputedInterestMethod;
        this.mImputedInterestPercent = imputedInterestPercent;
        this.mDeprStartDate = deprStartDate;
        this.mLastDeprDate = lastDeprDate;
        this.mLastInterestCalcDate = lastInterestCalcDate;
        this.mSpecDeprStartDate = specDeprStartDate;
        this.mResPeriodInYears = resPeriodInYears;
        this.mResPeriodInMonth = resPeriodInMonth;
        this.mStatus = status;
        this.mIsFullDisposed = isFullDisposed;
        this.mReplacementValue = replacementValue;
        this.mHistoricalAcquisitionValue = historicalAcquisitionValue;
        this.mDeprPlanIT = deprPlanIT;
        this.mProcessingDate = processingDate;
        this.mRetirementDate = retirementDate;
        this.mReferenzToAvUsefullLifeTable = referenzToAvUsefullLifeTable;
        this.mTaxAcquisitionValuePL = taxAcquisitionValuePL;
        this.mInterruptDeprFromDate = interruptDeprFromDate;
        this.mInterruptDeprToDate = interruptDeprToDate;
        this.mValidFromDate = validFromDate;
        this.mValidToDate = validToDate;
        this.mOidCompany = oidCompany;
        this.mType = type;
        this.mLifeInDays = lifeInDays;
        this.mResLifeInDays = resLifeInDays;
        this.mAssetAccount = assetAccount;
        this.mNewAddOffsetAccount = newAddOffsetAccount;
        this.mDisposalOffsetAccount = disposalOffsetAccount;
        this.mAccValuationDepr = accValuationDepr;
        this.mAcquisitionValue = acquisiationValue;
        this.mNetBookValue = netBookValue;
        this.mAccumDeprValue = accumDeprValue;
        this.mIsCalledFromDepreciation = isCalledFromDepreciation;
        this.mFixDeprAmount = fixDeprAmount;
    }

    public void checkDeprMethodIsNotNull(Language language) throws BusinessDomainException {
        this.mGlobalLanguage = language;
        if (this.mFixedAsset.getType().equals(FolderEnum.FOE_FIXEDASSET) && this.mStatus != StatusEnum.STE_LEASING_OPE && this.mStatus != StatusEnum.STE_PLANNED && this.mStatus != StatusEnum.STE_UNDER_CONSTR && this.mStatus != StatusEnum.STE_NO_DEPRECIATION && this.mStatus != StatusEnum.STE_SPEC_RESERVE && !this.getIsFullDisposed() && !this.mArea.getCalculative() && StringMapper.isNullString((String)this.mOidDepreciationMethod)) {
            throw FixedAssetExceptionMapper.makeCalcMethodMissingDomainException((String)this.mFixedAsset.getCode());
        }
    }

    public void checkForCorrectDeprMethod(Language language) throws BusinessDomainException {
        CalcMethod calcMethod;
        this.mGlobalLanguage = language;
        if (this.mFixedAsset.getType().equals(FolderEnum.FOE_FIXEDASSET) && this.mStatus != StatusEnum.STE_LEASING_OPE && this.mStatus != StatusEnum.STE_PLANNED && this.mStatus != StatusEnum.STE_UNDER_CONSTR && this.mStatus != StatusEnum.STE_NO_DEPRECIATION && this.mStatus != StatusEnum.STE_SPEC_RESERVE && !this.getIsFullDisposed() && this.mArea.getCalculative() && this.getDepBelowZero() && !StringMapper.isNullString((String)this.mOidDepreciationMethod) && BigDecimalMapper.compareTo((BigDecimal)this.getNetBookValue(), (BigDecimal)BigDecimal.ZERO) < 0 && (calcMethod = CalcMethodPersistencyManager.getCalcMethod((String)this.mOidDepreciationMethod)) != null && calcMethod.getBaseForCalc().value() == 3) {
            throw FixedAssetExceptionMapper.makeDeprMethodNotValidForBelowZeroException((String)this.mFixedAsset.getCode(), (String)"FixedAssetArea.checkForCorrectDeprMethod");
        }
    }

    public void check(Language language, Date checkDateForValidation) throws BusinessDomainException {
        this.mGlobalLanguage = language;
        this.mCheckDateForValidation = checkDateForValidation;
        this.check();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void check() throws BusinessDomainException {
        BigDecimal splittetAcquisitionValue;
        FixedAssetData faData;
        FixedAssetData fad;
        CalcMethod calcMethod;
        LOGGER.debug("check(...)");
        if (this.mFixedAsset.getType().equals(FolderEnum.FOE_FIXEDASSET) && this.mStatus != StatusEnum.STE_LEASING_OPE && this.mStatus != StatusEnum.STE_PLANNED && this.mStatus != StatusEnum.STE_UNDER_CONSTR && this.mStatus != StatusEnum.STE_NO_DEPRECIATION && this.mStatus != StatusEnum.STE_SIMULATION && this.mStatus != StatusEnum.STE_SPEC_RESERVE && !this.mIsFromTransfer && this.mPeriodInYears == 0 && this.mPeriodInMonth == 0) {
            throw FixedAssetExceptionMapper.makeUsefullLifeException((String)this.mFixedAsset.getCode(), (String)"FixedAssetArea.check", (Language)this.mGlobalLanguage);
        }
        if (this.mFixedAsset.getType().equals(FolderEnum.FOE_FIXEDASSET)) {
            calcMethod = null;
            if (!StringMapper.isNullString((String)this.mOidDepreciationMethod)) {
                calcMethod = CalcMethodPersistencyManager.getCalcMethod((String)this.mOidDepreciationMethod);
            }
            boolean degressiveMethod = false;
            if (calcMethod != null) {
                if (calcMethod instanceof DepreciationMethodData && ((DepreciationMethodData)calcMethod).getDepreciationType().value() == 1) {
                    degressiveMethod = true;
                }
                if (!(!(calcMethod instanceof DepreciationMethodData) || !this.mArea.getBelongsToBalanceSheet() || this.mFixedAsset.getNote() != null && this.mFixedAsset.getNote().equals("Degressiv") || this.mArea.getNote() != null && this.mArea.getNote().equals("Degressiv") || this.mArea.getJurisdictionType() != JurisdictionType.DE || ((DepreciationMethodData)calcMethod).getDepreciationType().value() != 1 || !(this.getUsefullLifeInYears() > 0.0))) {
                    BigDecimal maxDeprPerc = BigDecimalMapper.ZERO;
                    if (this.mDeprStartDate == null) throw FixedAssetExceptionMapper.makeDeprStartDateNotFilledException((String)this.mFixedAsset.getCode(), (String)"FixedAssetArea.check");
                    if (DateHelper.before((Date)this.mDeprStartDate, (Date)DateMapper.toDate((String)"2001-01-01")) || DateHelper.between((Date)this.mDeprStartDate, (Date)DateMapper.toDate((String)"2006-01-01"), (Date)DateMapper.toDate((String)"2007-12-31"))) {
                        if (BigDecimalMapper.compareTo((BigDecimal)((DepreciationMethodData)calcMethod).getPercentage(), (BigDecimal)new BigDecimal(30)) > 0) {
                            throw FixedAssetExceptionMapper.makeDecliningBalanceMethodPercWrongDomainException((String)this.mFixedAsset.getCode(), (String)"FixedAssetArea.check");
                        }
                        maxDeprPerc = new BigDecimal(100.0 / this.getUsefullLifeInYears() * 3.0);
                    } else if (DateHelper.between((Date)this.mDeprStartDate, (Date)DateMapper.toDate((String)"2001-01-01"), (Date)DateMapper.toDate((String)"2005-12-31"))) {
                        if (BigDecimalMapper.compareTo((BigDecimal)((DepreciationMethodData)calcMethod).getPercentage(), (BigDecimal)new BigDecimal(20)) > 0) {
                            throw FixedAssetExceptionMapper.makeDecliningBalanceMethodPerc2001WrongDomainException((String)this.mFixedAsset.getCode(), (String)"FixedAssetArea.check");
                        }
                        maxDeprPerc = new BigDecimal(100.0 / this.getUsefullLifeInYears() * 2.0);
                    } else if (DateHelper.between((Date)this.mDeprStartDate, (Date)DateMapper.toDate((String)"2009-01-01"), (Date)DateMapper.toDate((String)"2010-12-31"))) {
                        if (BigDecimalMapper.compareTo((BigDecimal)((DepreciationMethodData)calcMethod).getPercentage(), (BigDecimal)new BigDecimal(25)) > 0) {
                            throw FixedAssetExceptionMapper.makeDecliningBalanceMethod25PercWrongDomainException((String)this.mFixedAsset.getCode(), (String)"FixedAssetArea.check");
                        }
                        maxDeprPerc = new BigDecimal(100.0 / this.getUsefullLifeInYears() * 2.5);
                    } else if (DateHelper.between((Date)this.mDeprStartDate, (Date)DateMapper.toDate((String)"2020-01-01"), (Date)DateMapper.toDate((String)"2022-12-31"))) {
                        if (BigDecimalMapper.compareTo((BigDecimal)((DepreciationMethodData)calcMethod).getPercentage(), (BigDecimal)new BigDecimal(25)) > 0) {
                            throw FixedAssetExceptionMapper.makeDecliningBalanceMethod25PercCovid19WrongDomainException((String)this.mFixedAsset.getCode(), (String)"FixedAssetArea.check");
                        }
                        maxDeprPerc = new BigDecimal(100.0 / this.getUsefullLifeInYears() * 2.5);
                    } else if (DateHelper.between((Date)this.mDeprStartDate, (Date)DateMapper.toDate((String)"2024-04-01"), (Date)DateMapper.toDate((String)"2024-12-31"))) {
                        if (BigDecimalMapper.compareTo((BigDecimal)((DepreciationMethodData)calcMethod).getPercentage(), (BigDecimal)new BigDecimal(20)) > 0) {
                            throw FixedAssetExceptionMapper.makeDecliningBalanceMethod20Percent2024WrongDomainException((String)this.mFixedAsset.getCode(), (String)"FixedAssetArea.check");
                        }
                        maxDeprPerc = new BigDecimal(100.0 / this.getUsefullLifeInYears() * 2.0);
                    } else if (DateHelper.between((Date)this.mDeprStartDate, (Date)DateMapper.toDate((String)"2025-07-01"), (Date)DateMapper.toDate((String)"2027-12-31"))) {
                        if (BigDecimalMapper.compareTo((BigDecimal)((DepreciationMethodData)calcMethod).getPercentage(), (BigDecimal)new BigDecimal(30)) > 0) {
                            throw FixedAssetExceptionMapper.makeDecliningBalanceMethod30Percent2025WrongDomainException((String)this.mFixedAsset.getCode(), (String)"FixedAssetArea.check");
                        }
                        maxDeprPerc = new BigDecimal(100.0 / this.getUsefullLifeInYears() * 3.0);
                    } else {
                        if (!DateHelper.between((Date)this.mDeprStartDate, (Date)DateMapper.toDate((String)"2011-01-01"), (Date)DateMapper.toDate((String)"2019-12-31"))) throw FixedAssetExceptionMapper.makeDegrMethodNotValidException((String)this.mFixedAsset.getCode(), (String)"FixedAssetArea.check");
                        if (BigDecimalMapper.compareTo((BigDecimal)((DepreciationMethodData)calcMethod).getPercentage(), (BigDecimal)new BigDecimal(50)) > 0) {
                            throw FixedAssetExceptionMapper.makeDegrMethodNotValidException((String)this.mFixedAsset.getCode(), (String)"FixedAssetArea.check");
                        }
                        maxDeprPerc = ((DepreciationMethodData)calcMethod).getPercentage();
                    }
                    if (BigDecimalMapper.compareTo((BigDecimal)((DepreciationMethodData)calcMethod).getPercentage(), (BigDecimal)maxDeprPerc) > 0) {
                        this.mDepreciationPercent = maxDeprPerc.setScale(2, RoundingMode.HALF_EVEN);
                    }
                }
                if (calcMethod instanceof DepreciationMethodData && ((DepreciationMethodData)calcMethod).getDepreciationType().value() == 6 && !this.mIsFullDisposed) {
                    if (BigDecimalMapper.compareTo((BigDecimal)this.mFixDeprAmount, (BigDecimal)BigDecimal.ZERO) <= 0) throw FixedAssetExceptionMapper.makeFixDeprAmountNotFilledException((String)this.mFixedAsset.getCode(), (String)calcMethod.getCode());
                    if (BigDecimalMapper.compareTo((BigDecimal)this.mFixDeprAmount, (BigDecimal)this.mAcquisitionValue) > 0 && BigDecimalMapper.compareTo((BigDecimal)this.mAcquisitionValue, (BigDecimal)BigDecimal.ZERO) > 0) {
                        throw FixedAssetExceptionMapper.makeFixDeprAmountToHighException((String)this.mFixedAsset.getCode(), (String)"FixedAssetArea.check");
                    }
                }
            }
            if (calcMethod != null && this.mDeprStartDate != null && (this.mStatus == StatusEnum.STE_ACTIVATED || this.mStatus == StatusEnum.STE_GRANT || this.mStatus == StatusEnum.STE_LOW_VALUE_5_YEARS || this.mStatus == StatusEnum.STE_LOW_VALUE)) {
                if (this.mLastDeprDate == null) {
                    if (calcMethod.getValidUntil() != null && DateHelper.afterOrEqual((Date)this.mDeprStartDate, (Date)calcMethod.getValidUntil())) {
                        throw FixedAssetExceptionMapper.makeCalcMethodInvalidDomainException((String)this.mFixedAsset.getCode(), (String)calcMethod.getCode());
                    }
                    if (calcMethod.getValidFrom() != null && DateHelper.before((Date)this.mDeprStartDate, (Date)calcMethod.getValidFrom())) {
                        throw FixedAssetExceptionMapper.makeCalcMethodInvalidFromDomainException((String)this.mFixedAsset.getCode(), (String)calcMethod.getCode());
                    }
                } else {
                    Date lastDeprDate = this.mLastDeprDate;
                    if (this.mProcessingDate != null && DateHelper.after((Date)this.mProcessingDate, (Date)this.mDeprStartDate)) {
                        lastDeprDate = this.mProcessingDate;
                    }
                    if (this.mCheckDateForValidation != null) {
                        lastDeprDate = this.mCheckDateForValidation;
                    }
                    if (calcMethod.getValidUntil() != null && !degressiveMethod && DateHelper.after((Date)lastDeprDate, (Date)calcMethod.getValidUntil())) {
                        throw FixedAssetExceptionMapper.makeCalcMethodInvalidDomainException((String)this.mFixedAsset.getCode(), (String)calcMethod.getCode());
                    }
                    if (calcMethod.getValidFrom() != null && !degressiveMethod && DateHelper.before((Date)lastDeprDate, (Date)calcMethod.getValidFrom())) {
                        throw FixedAssetExceptionMapper.makeCalcMethodInvalidFromDomainException((String)this.mFixedAsset.getCode(), (String)calcMethod.getCode());
                    }
                }
            }
        }
        if (this.mStatus == StatusEnum.STE_LOW_VALUE_5_YEARS) {
            calcMethod = null;
            if (StringMapper.isNullString((String)this.mOidDepreciationMethod)) {
                throw FixedAssetExceptionMapper.makeCalcMethodMissingDomainException((String)this.mFixedAsset.getCode());
            }
            calcMethod = CalcMethodPersistencyManager.getCalcMethod((String)this.mOidDepreciationMethod);
            if (calcMethod == null) throw FixedAssetExceptionMapper.makeCalcMethodMissingDomainException((String)this.mFixedAsset.getCode());
            if (calcMethod.getMethodTypeEnum() != MethodTypeEnum.MTE_DEPRECIATION) {
                throw FixedAssetExceptionMapper.makeCalcMethodMissingDomainException((String)this.mFixedAsset.getCode());
            }
            DepreciationMethodData deprMethod = (DepreciationMethodData)calcMethod;
            if (calcMethod.getBaseForCalc() != BaseCalcEnum.BCE_PURCHASE_VAL) {
                throw FixedAssetExceptionMapper.makeCalcMethodWrongDomainException((String)this.mFixedAsset.getCode(), (String)calcMethod.getCode());
            }
            if (deprMethod.getDepreciationType() != DepreciationTypeEnum.DTE_STRAIGHT_LINE) {
                throw FixedAssetExceptionMapper.makeCalcMethodWrongDomainException((String)this.mFixedAsset.getCode(), (String)calcMethod.getCode());
            }
            if (deprMethod.getPeriodInYears() != 5) {
                throw FixedAssetExceptionMapper.makeCalcMethodWrongDomainException((String)this.mFixedAsset.getCode(), (String)calcMethod.getCode());
            }
            if (BigDecimalMapper.compareTo((BigDecimal)deprMethod.getPercentage(), (BigDecimal)new BigDecimal(20)) != 0) {
                throw FixedAssetExceptionMapper.makeCalcMethodWrongDomainException((String)this.mFixedAsset.getCode(), (String)calcMethod.getCode());
            }
            if (this.mArea.getJurisdictionType() == JurisdictionType.DE && this.mDeprStartDate != null && DateHelper.before((Date)this.mDeprStartDate, (Date)DateMapper.toDate((String)"2008-01-01"))) {
                throw FixedAssetExceptionMapper.makeCalcMethodInvalidFromDomainException((String)this.mFixedAsset.getCode(), (String)calcMethod.getCode());
            }
        }
        if (this.mStatus == StatusEnum.STE_ACTIVATED || this.mStatus == StatusEnum.STE_LOW_VALUE || this.mStatus == StatusEnum.STE_LOW_VALUE_5_YEARS || this.mStatus == StatusEnum.STE_SPEC_RESERVE || this.mStatus == StatusEnum.STE_GRANT || this.mStatus == StatusEnum.STE_SIMULATION) {
            if (this.getDepreciationStart() == null) {
                throw ExceptionMapper.makeApplicationException((String)"DepreciationStart must be filled");
            }
            if (this.mFixedAsset.getType().equals(FolderEnum.FOE_FIXEDASSET) && this.mArea.getJurisdictionType() == JurisdictionType.DE && !this.mArea.getCalculative() && this.mDepreciationStart.equals(DepreciationStartEnum.DSE_HALF_YEAR) && DateHelper.after((Date)this.mDeprStartDate, (Date)DateMapper.toDate((String)"2003-12-31"))) {
                throw FixedAssetExceptionMapper.halfYearRuleWrongDomainException((String)this.mFixedAsset.getCode(), (String)"FixedAssetArea.check");
            }
            if (this.mArea.getBelongsToBalanceSheet() && this.mFixedAsset.getAccValuationDepreciation() == null && AssetaccountingSetup.getValidAssetaccountingSetup((AccountingCompany)this.mFixedAsset.getAccountCompany()).getIsIndirDeprWithValAcc()) {
                throw FixedAssetExceptionMapper.makeNoValuationAccountException((String)this.mFixedAsset.getCode(), (String)"FixedAssetData.check");
            }
        }
        if ((this.mArea.getBelongsToBalanceSheet() || this.mArea.getTransferDataCost()) && !this.mIsFullDisposed && AssetaccountingSetup.getValidAssetaccountingSetup((AccountingCompany)this.mFixedAsset.getAccountCompany()).getCheckCostCentres() != CostCentreValidationEnum.CCVE_NO && this.mFixedAsset instanceof FixedAssetData && (fad = (FixedAssetData)this.mFixedAsset) != null && fad.getCostCenters() != null) {
            Date validDate;
            FACostCentre[] facc = fad.getCostCenters();
            if (this.mCheckDateForValidation != null) {
                validDate = this.mCheckDateForValidation;
            } else {
                validDate = this.mProcessingDate;
                if (AssetaccountingSetup.getValidAssetaccountingSetup((AccountingCompany)this.mFixedAsset.getAccountCompany()).getCheckCostCentres() == CostCentreValidationEnum.CCVE_FA_LAST_DEPRECIATION && this.mLastDeprDate != null) {
                    validDate = this.mLastDeprDate;
                }
                if (validDate == null || DateHelper.before((Date)validDate, (Date)fad.getAcquisitionDate())) {
                    validDate = fad.getAcquisitionDate();
                }
            }
            for (int i = 0; i < facc.length; ++i) {
                CostCentreBase ccb = facc[i].getCostCentreBase();
                ccb.requireLoaded();
                if (ccb.isValidAt(validDate)) continue;
                if (this.mCheckDateForValidation != null) {
                    throw FixedAssetExceptionMapper.makeCostCentreNotValidDeprUntilDateDomainException((String)facc[i].getCostCentreBase().getCode(), (String)"FixedAssetArea.check");
                }
                if (AssetaccountingSetup.getValidAssetaccountingSetup((AccountingCompany)this.mFixedAsset.getAccountCompany()).getCheckCostCentres() != CostCentreValidationEnum.CCVE_FA_LAST_DEPRECIATION) throw FixedAssetExceptionMapper.makeCostCentreNotValidDomainException((String)facc[i].getCostCentreBase().getCode(), (String)"FixedAssetArea.check");
                throw FixedAssetExceptionMapper.makeCostCentreNotValidDateLastAfADomainException((String)facc[i].getCostCentreBase().getCode(), (String)"FixedAssetArea.check");
            }
        }
        if (this.mStatus == StatusEnum.STE_LOW_VALUE && this.mArea.getBelongsToBalanceSheet() && BigDecimalMapper.compareTo((BigDecimal)this.mArea.getLimit(), (BigDecimal)BigDecimal.ZERO) > 0 && !this.mIsFullDisposed && this.mFixedAsset instanceof FixedAssetData && DateHelper.after((Date)(faData = (FixedAssetData)this.mFixedAsset).getAcquisitionDate(), (Date)DateMapper.toDate((String)"2017-12-31")) && BigDecimalMapper.compareTo((BigDecimal)(splittetAcquisitionValue = this.getSplittetAcquisitionValue(faData.getQuantity())), (BigDecimal)this.mArea.getLimit()) > 0) {
            if (this.mArea.getJurisdictionType() != JurisdictionType.DE) throw FixedAssetTransactionExceptionMapper.makeAmountLowValueToLargeDomainException((String)"FixedAssetTransaction.check", (String)this.mArea.getCode());
            throw FixedAssetExceptionMapper.makeLowValueAssetToHighException((String)faData.getCode());
        }
        if (this.mStatus != null) return;
        throw ExceptionMapper.makeApplicationException((String)"Status must be filled");
    }

    public FixedAsset getFixedAsset() {
        return this.mFixedAsset;
    }

    public void setFixedAsset(FixedAsset fixedAsset) {
        this.protocol(FIXEDASSET, (IPersistentObject)this.mFixedAsset, (IPersistentObject)fixedAsset);
        this.mFixedAsset = fixedAsset;
    }

    public String getObjectidForProtocol() {
        return this.mFixedAsset.getObjectid();
    }

    public DepreciationArea getDeprArea() {
        this.requireLoaded();
        return this.mArea;
    }

    public Date getValidFromDate() {
        this.requireLoaded();
        return this.mValidFromDate;
    }

    public void setValidFromDate(Date validFromDate) {
        this.protocol(VALIDFROMDATE, this.mValidFromDate, validFromDate);
        this.mValidFromDate = validFromDate;
    }

    public Date getValidToDate() {
        this.requireLoaded();
        return this.mValidToDate;
    }

    public void setValidToDate(Date validToDate) {
        this.protocol(VALIDTODATE, this.mValidToDate, validToDate);
        this.mValidToDate = validToDate;
    }

    public void setDeprArea(DepreciationArea area) {
        this.protocol(AREA, (IPersistentObject)this.mArea, (IPersistentObject)area);
        this.mArea = area;
    }

    public AccountGroup getAccountGroup() {
        this.requireLoaded();
        return this.mAccountGroup;
    }

    public void setAccountGroup(AccountGroup accountGroup) {
        this.protocol(ACCOUNTGROUP, (IPersistentObject)this.mAccountGroup, (IPersistentObject)accountGroup);
        this.mAccountGroup = accountGroup;
    }

    public DepreciationStartEnum getDepreciationStart() {
        this.requireLoaded();
        return this.mDepreciationStart;
    }

    public void setDepreciationStart(DepreciationStartEnum depreciationStart) {
        this.protocol(DEPRECIATIONSTART, DepreciationStartMapper.toString((DepreciationStartEnum)this.mDepreciationStart), DepreciationStartMapper.toString((DepreciationStartEnum)depreciationStart));
        this.mDepreciationStart = depreciationStart;
    }

    public boolean isActivated() {
        if (this.isNew() || this.mFixedAsset == null || this.mArea == null) {
            return false;
        }
        String[] values = new String[]{Integer.toString(0), Integer.toString(1), Integer.toString(2), Integer.toString(3), Integer.toString(4)};
        Junction junction = Restrictions.conjunction().add(Restrictions.eq((String)"oidfixedasset", (String)this.mFixedAsset.getObjectid())).add(Restrictions.eq((String)"oiddeprearea", (String)this.mArea.getObjectid())).add(Restrictions.not((Criterion)Restrictions.in((String)"transactenum", (String[])values)));
        FixedAssetTransaction[] fat = FixedAssetTransactionPersistencyManager.getTransactions(null, (Criterion)junction);
        return fat.length != 0;
    }

    public short getPeriodInYears() {
        this.requireLoaded();
        return this.mPeriodInYears;
    }

    public void setPeriodInYears(short periodInYears) {
        this.protocol(PERIODINYEARS, this.mPeriodInYears, periodInYears);
        if (this.mPeriodInYears != periodInYears) {
            this.mPeriodInYears = periodInYears;
        }
    }

    public short getPeriodInMonth() {
        this.requireLoaded();
        return this.mPeriodInMonth;
    }

    public void setPeriodInMonth(short periodInMonth) {
        this.protocol(PERIODINMONTH, this.mPeriodInMonth, periodInMonth);
        if (this.mPeriodInMonth != periodInMonth) {
            this.mPeriodInMonth = periodInMonth;
        }
    }

    public String getOidDepreciationMethod() {
        this.requireLoaded();
        return this.mOidDepreciationMethod;
    }

    public void setOidDepreciationMethod(String oidDepreciationMethod) {
        CalcMethod m1 = null;
        CalcMethod m2 = null;
        if (!StringMapper.isNullString((String)this.mOidDepreciationMethod)) {
            m1 = CalcMethodPersistencyManager.getCalcMethod((String)this.mOidDepreciationMethod);
        }
        if (!StringMapper.isNullString((String)oidDepreciationMethod)) {
            m2 = CalcMethodPersistencyManager.getCalcMethod((String)oidDepreciationMethod);
        }
        this.protocol(OIDDEPRECIATIONMETHOD, (IPersistentObject)m1, (IPersistentObject)m2);
        this.mOidDepreciationMethod = oidDepreciationMethod;
    }

    public BigDecimal getDepreciationPercent() {
        this.requireLoaded();
        return this.mDepreciationPercent;
    }

    public void setDepreciationPercent(BigDecimal depreciationPercent) {
        if (this.mDepreciationPercent != null && depreciationPercent != null) {
            this.mDepreciationPercent = this.mDepreciationPercent.setScale(depreciationPercent.scale(), RoundingMode.DOWN);
        }
        this.protocol(DEPRECIATIONPERCENT, this.mDepreciationPercent, depreciationPercent);
        this.mDepreciationPercent = depreciationPercent;
    }

    public BigDecimal getShiftFactor() {
        this.requireLoaded();
        return this.mShiftFactor;
    }

    public void setShiftFactor(BigDecimal shiftFactor) {
        if (this.mShiftFactor != null && shiftFactor != null) {
            this.mShiftFactor = this.mShiftFactor.setScale(shiftFactor.scale(), RoundingMode.DOWN);
        }
        this.protocol(SHIFTFACTOR, this.mShiftFactor, shiftFactor);
        this.mShiftFactor = shiftFactor;
    }

    public BigDecimal getPerfInUnits() {
        this.requireLoaded();
        return this.mPerfInUnits;
    }

    public void setPerfInUnits(BigDecimal perfInUnits) {
        this.protocol(PERFINUNITS, this.mPerfInUnits, perfInUnits);
        this.mPerfInUnits = perfInUnits;
    }

    public BigDecimal getResidualUnits() {
        this.requireLoaded();
        return this.mResidualUnits;
    }

    public void setResidualUnits(BigDecimal residualUnits) {
        this.protocol(RESIDUALUNITS, this.mResidualUnits, residualUnits);
        this.mResidualUnits = residualUnits;
    }

    public String getOidSpecDepreciationMethod() {
        this.requireLoaded();
        return this.mOidSpecDepreciationMethod;
    }

    public void setOidSpecDepreciationMethod(String oidSpecDepreciationMethod) {
        CalcMethod m1 = null;
        CalcMethod m2 = null;
        if (!StringMapper.isNullString((String)this.mOidSpecDepreciationMethod)) {
            m1 = CalcMethodPersistencyManager.getCalcMethod((String)this.mOidSpecDepreciationMethod);
        }
        if (!StringMapper.isNullString((String)oidSpecDepreciationMethod)) {
            m2 = CalcMethodPersistencyManager.getCalcMethod((String)oidSpecDepreciationMethod);
        }
        this.protocol(OIDSPECDEPRECIATIONMETHOD, (IPersistentObject)m1, (IPersistentObject)m2);
        this.mOidSpecDepreciationMethod = oidSpecDepreciationMethod;
    }

    public BigDecimal getSpecDepreciationPercent() {
        this.requireLoaded();
        return this.mSpecDepreciationPercent;
    }

    public void setSpecDepreciationPercent(BigDecimal specDepreciationPercent) {
        if (this.mSpecDepreciationPercent != null) {
            this.mSpecDepreciationPercent = this.mSpecDepreciationPercent.setScale(specDepreciationPercent.scale(), RoundingMode.DOWN);
        }
        this.protocol(SPECDEPRECIATIONPERCENT, this.mSpecDepreciationPercent, specDepreciationPercent);
        this.mSpecDepreciationPercent = specDepreciationPercent;
    }

    public boolean getDepBelowZero() {
        this.requireLoaded();
        return this.mDepBelowZero;
    }

    public void setDepBelowZero(boolean depBelowZero) {
        this.protocol(DEPBELOWZERO, this.mDepBelowZero, depBelowZero);
        this.mDepBelowZero = depBelowZero;
    }

    public BigDecimal getDepResValue() {
        this.requireLoaded();
        return this.mDepResValue;
    }

    public void setDepResValue(BigDecimal depResValue) {
        if (this.mDepResValue != null && depResValue != null) {
            this.mDepResValue = this.mDepResValue.setScale(depResValue.scale(), RoundingMode.DOWN);
        }
        this.protocol(DEPRESVALUE, this.mDepResValue, depResValue);
        this.mDepResValue = depResValue;
    }

    public IndexSeries getReplacementIndex() {
        this.requireLoaded();
        return this.mReplacementIndex;
    }

    public void setReplacementIndex(IndexSeries replacementIndex) {
        this.protocol(REPLACEMENTINDEX, (IPersistentObject)this.mReplacementIndex, (IPersistentObject)replacementIndex);
        this.mReplacementIndex = replacementIndex;
    }

    public String getOidImputedInterestMethod() {
        this.requireLoaded();
        return this.mOidImputedInterestMethod;
    }

    public void setOidImputedInterestMethod(String oidImputedInterestMethod) {
        CalcMethod m1 = null;
        CalcMethod m2 = null;
        if (!StringMapper.isNullString((String)this.mOidImputedInterestMethod)) {
            m1 = CalcMethodPersistencyManager.getCalcMethod((String)this.mOidImputedInterestMethod);
        }
        if (!StringMapper.isNullString((String)oidImputedInterestMethod)) {
            m2 = CalcMethodPersistencyManager.getCalcMethod((String)oidImputedInterestMethod);
        }
        this.protocol(OIDIMPUTEDINTERESTMETHOD, (IPersistentObject)m1, (IPersistentObject)m2);
        this.mOidImputedInterestMethod = oidImputedInterestMethod;
    }

    public BigDecimal getImputedInterestPercent() {
        this.requireLoaded();
        return this.mImputedInterestPercent;
    }

    public void setImputedInterestPercent(BigDecimal imputedInterestPercent) {
        if (this.mImputedInterestPercent != null) {
            this.mImputedInterestPercent = this.mImputedInterestPercent.setScale(imputedInterestPercent.scale(), RoundingMode.DOWN);
        }
        this.protocol(IMPUTEDINTERESTPERCENT, this.mImputedInterestPercent, imputedInterestPercent);
        this.mImputedInterestPercent = imputedInterestPercent;
    }

    public static String[] toString(FixedAssetArea[] a) {
        if (a == null) {
            return new String[0];
        }
        String[] result = new String[a.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = a[i].getFixedAsset().getCode();
        }
        return result;
    }

    public Date getDeprStartDate() {
        this.requireLoaded();
        return this.mDeprStartDate;
    }

    public void setDeprStartDate(Date deprStartDate) {
        this.protocol(DEPRSTARTDATE, this.mDeprStartDate, deprStartDate);
        this.mDeprStartDate = deprStartDate;
    }

    public Date getLastDeprDate() {
        this.requireLoaded();
        return this.mLastDeprDate;
    }

    public void setLastDeprDate(Date lastDeprDate) {
        this.protocol(LASTDEPRDATE, this.mLastDeprDate, lastDeprDate);
        this.mLastDeprDate = lastDeprDate;
    }

    public void setLastDeprDateWithouProtocol(Date lastDeprDate) {
        this.mLastDeprDate = lastDeprDate;
    }

    public Date getLastInterestCalcDate() {
        this.requireLoaded();
        return this.mLastInterestCalcDate;
    }

    public void setLastInterestCalcDate(Date lastInterestCalcDate) {
        this.mLastInterestCalcDate = lastInterestCalcDate;
    }

    public Date getSpecDeprStartDate() {
        this.requireLoaded();
        return this.mSpecDeprStartDate;
    }

    public void setSpecDeprStartDate(Date specDeprStartDate) {
        this.mSpecDeprStartDate = specDeprStartDate;
    }

    public Date getProcessingDate() {
        this.requireLoaded();
        return this.mProcessingDate;
    }

    public void setProcessingDate(Date processingDate) {
        this.mProcessingDate = processingDate;
    }

    public Date getRetirementDate() {
        this.requireLoaded();
        return this.mRetirementDate;
    }

    public void setRetirementDate(Date retirementDate) {
        this.protocol(RETIREMENTDATE, this.mRetirementDate, retirementDate);
        this.mRetirementDate = retirementDate;
    }

    public Date getInterruptDeprFromDate() {
        this.requireLoaded();
        return this.mInterruptDeprFromDate;
    }

    public void setInterruptDeprFromDate(Date interruptDeprFromDate) {
        this.mInterruptDeprFromDate = interruptDeprFromDate;
    }

    public Date getInterruptDeprToDate() {
        this.requireLoaded();
        return this.mInterruptDeprToDate;
    }

    public void setInterruptDeprToDate(Date interruptDeprToDate) {
        this.mInterruptDeprToDate = interruptDeprToDate;
    }

    public short getResPeriodInYears() {
        this.requireLoaded();
        return this.mResPeriodInYears;
    }

    public void setResPeriodInYears(short resPeriodInYears) {
        this.protocol(RESPERIODINYEARS, this.mResPeriodInYears, resPeriodInYears);
        this.mResPeriodInYears = resPeriodInYears;
    }

    public void setResPeriodInYearsWithoutProtocol(short resPeriodInYears) {
        this.mResPeriodInYears = resPeriodInYears;
    }

    public short getResPeriodInMonth() {
        this.requireLoaded();
        return this.mResPeriodInMonth;
    }

    public void setResPeriodInMonth(short resPeriodInMonth) {
        this.protocol(RESPERIODINMONTH, this.mResPeriodInMonth, resPeriodInMonth);
        this.mResPeriodInMonth = resPeriodInMonth;
    }

    public void setResPeriodInMonthWithoutProtocol(short resPeriodInMonth) {
        this.mResPeriodInMonth = resPeriodInMonth;
    }

    public StatusEnum getStatus() {
        this.requireLoaded();
        return this.mStatus;
    }

    public void setStatus(StatusEnum status) {
        this.protocol(STATUS, StatusMapper.toString((StatusEnum)this.mStatus), StatusMapper.toString((StatusEnum)status));
        this.mStatus = status;
    }

    public boolean getIsFullDisposed() {
        this.requireLoaded();
        return this.mIsFullDisposed;
    }

    public void setIsFullDisposed(boolean isFullDisposed) {
        this.protocol(ISFULLDISPOSED, this.mIsFullDisposed, isFullDisposed);
        this.mIsFullDisposed = isFullDisposed;
    }

    public short getUsefullLifeInMonth() {
        return (short)(this.getPeriodInYears() * 12 + this.getPeriodInMonth());
    }

    public double getUsefullLifeInYears() {
        return this.getPeriodInYears() + this.getPeriodInMonth() / 12;
    }

    public void setUsefullLifeInMonth(int month) {
        this.setPeriodInYears((short)(month / 12));
        this.setPeriodInMonth((short)(month % 12));
    }

    public short getResidualLifeInMonth() {
        return (short)(this.getResPeriodInYears() * 12 + this.getResPeriodInMonth());
    }

    public void setResidualLifeInMonth(int month) {
        this.setResPeriodInYears((short)(month / 12));
        this.setResPeriodInMonth((short)(month % 12));
    }

    public int getUsefullLifeInDays() {
        this.requireLoaded();
        return this.mLifeInDays;
    }

    public void setUsefullLifeInDays(int days) {
        this.mLifeInDays = days;
    }

    public int getResLifeInDays() {
        this.requireLoaded();
        return this.mResLifeInDays;
    }

    public void setResLifeInDays(int resDays) {
        this.mResLifeInDays = resDays;
    }

    public BigDecimal getReplacementValue() {
        this.requireLoaded();
        return this.mReplacementValue;
    }

    public void setReplacementValue(BigDecimal replacementValue) {
        if (this.mReplacementValue != null) {
            this.mReplacementValue = this.mReplacementValue.setScale(replacementValue.scale(), RoundingMode.DOWN);
        }
        this.protocol(REPLACEMENTVALUE, this.mReplacementValue, replacementValue);
        this.mReplacementValue = replacementValue;
    }

    public BigDecimal getHistoricalAcquisitionValue() {
        this.requireLoaded();
        return this.mHistoricalAcquisitionValue;
    }

    public void setHistoricalAcquisitionValue(BigDecimal historicalAcquisitionValue) {
        if (this.mHistoricalAcquisitionValue != null) {
            this.mHistoricalAcquisitionValue = this.mHistoricalAcquisitionValue.setScale(historicalAcquisitionValue.scale(), RoundingMode.DOWN);
        }
        this.protocol(HISTORICALACQUISITIONVALUE, this.mHistoricalAcquisitionValue, historicalAcquisitionValue);
        this.mHistoricalAcquisitionValue = historicalAcquisitionValue;
    }

    public BigDecimal getAcquisitionValue() {
        this.requireLoaded();
        return this.mAcquisitionValue;
    }

    public void setAcquisitionValue(BigDecimal acquisitionValue) {
        if (this.mAcquisitionValue != null) {
            this.mAcquisitionValue = this.mAcquisitionValue.setScale(acquisitionValue.scale(), RoundingMode.DOWN);
        }
        this.mAcquisitionValue = acquisitionValue;
    }

    public BigDecimal getNetBookValue() {
        this.requireLoaded();
        return this.mNetBookValue;
    }

    public void setNetBookValue(BigDecimal netBookValue) {
        if (this.mNetBookValue != null) {
            this.mNetBookValue = this.mNetBookValue.setScale(netBookValue.scale(), RoundingMode.DOWN);
        }
        this.mNetBookValue = netBookValue;
    }

    public BigDecimal getAccumDeprValue() {
        this.requireLoaded();
        return this.mAccumDeprValue;
    }

    public void setAccumDeprValue(BigDecimal accumDeprValue) {
        if (this.mAccumDeprValue != null) {
            this.mAccumDeprValue = this.mAccumDeprValue.setScale(accumDeprValue.scale(), RoundingMode.DOWN);
        }
        this.mAccumDeprValue = accumDeprValue;
    }

    public AssetsAverageUsefullLife getReferenzToAvUsefullLifeTable() {
        this.requireLoaded();
        return this.mReferenzToAvUsefullLifeTable;
    }

    public void setReferenzToAvUsefullLifeTable(AssetsAverageUsefullLife referenzToAvUsefullLifeTable) {
        this.mReferenzToAvUsefullLifeTable = referenzToAvUsefullLifeTable;
    }

    public void setIsFromTransfer(boolean isFromTransfer) {
        this.mIsFromTransfer = isFromTransfer;
    }

    public DepreciationPlanIT[] getDepreciationPlanIT() {
        this.requireLoaded();
        return this.mDeprPlanIT;
    }

    public void setDepreciationPlanIT(DepreciationPlanIT[] deprPlanIT) {
        this.mDeprPlanIT = deprPlanIT;
    }

    public FASplitDeprAccount[] getFASplitDeprAccounts() {
        if (this.mFASplitDeprAccount == null) {
            if (!this.isNew()) {
                this.mFASplitDeprAccount = FASplitDeprAccountPersistencyManager.getFASplitDeprAccounts((FixedAssetArea)this);
                for (int i = this.mFASplitDeprAccount.length - 1; i > 0; --i) {
                    for (int j = 0; j < i; ++j) {
                        if (this.mFASplitDeprAccount[j].getDeprAccount().getCode().compareTo(this.mFASplitDeprAccount[j + 1].getDeprAccount().getCode()) <= 0) continue;
                        FASplitDeprAccount temp = this.mFASplitDeprAccount[j];
                        this.mFASplitDeprAccount[j] = this.mFASplitDeprAccount[j + 1];
                        this.mFASplitDeprAccount[j + 1] = temp;
                    }
                }
            } else {
                this.mFASplitDeprAccount = new FASplitDeprAccount[0];
            }
        }
        return this.mFASplitDeprAccount;
    }

    public void setFASplitDeprAccounts(FASplitDeprAccount[] splitDeprAccounts) {
        if (this.mFASplitDeprAccount != null) {
            for (int i = 0; i < this.mFASplitDeprAccount.length; ++i) {
                this.mFASplitDeprAccount[i].makeReadOnly();
            }
        }
        this.mFASplitDeprAccount = splitDeprAccounts;
        if (this.mFASplitDeprAccount == null) {
            this.mFASplitDeprAccount = new FASplitDeprAccount[0];
        }
    }

    public BigDecimal getTaxAcquisitionValuePL() {
        this.requireLoaded();
        return this.mTaxAcquisitionValuePL;
    }

    public void setTaxAcquisitionValuePL(BigDecimal taxAcquisitionValuePL) {
        if (this.mTaxAcquisitionValuePL != null) {
            this.mTaxAcquisitionValuePL = this.mTaxAcquisitionValuePL.setScale(taxAcquisitionValuePL.scale(), RoundingMode.DOWN);
        }
        this.protocol(TAXACQUISITIONVALUEPL, this.mTaxAcquisitionValuePL, taxAcquisitionValuePL);
        this.mTaxAcquisitionValuePL = taxAcquisitionValuePL;
    }

    public FolderEnum getType() {
        this.requireLoaded();
        return this.mType;
    }

    public void setType(FolderEnum type) {
        this.mType = type;
    }

    public String getOidCompany() {
        this.requireLoaded();
        return this.mOidCompany;
    }

    public void setOidCompany(String oidCompany) {
        this.mOidCompany = oidCompany;
    }

    public NominalLedgerAccount getAssetAccount() {
        this.requireLoaded();
        return this.mAssetAccount;
    }

    public void setAssetAccount(NominalLedgerAccount assetAccount) {
        this.protocol("assetaccount", (IPersistentObject)this.mAssetAccount, (IPersistentObject)assetAccount);
        this.mAssetAccount = assetAccount;
    }

    public NominalLedgerAccount getNewAddOffsetAccount() {
        this.requireLoaded();
        return this.mNewAddOffsetAccount;
    }

    public void setNewAddOffsetAccount(NominalLedgerAccount newAddOffsetAccount) {
        this.protocol("newaddoffsetaccount", (IPersistentObject)this.mNewAddOffsetAccount, (IPersistentObject)newAddOffsetAccount);
        this.mNewAddOffsetAccount = newAddOffsetAccount;
    }

    public NominalLedgerAccount getDisposalOffsetAccount() {
        this.requireLoaded();
        return this.mDisposalOffsetAccount;
    }

    public void setDisposalOffsetAccount(NominalLedgerAccount disposalOffsetAccount) {
        this.protocol("disposaloffsetaccount", (IPersistentObject)this.mDisposalOffsetAccount, (IPersistentObject)disposalOffsetAccount);
        this.mDisposalOffsetAccount = disposalOffsetAccount;
    }

    public NominalLedgerAccount getAccValuationDepreciation() {
        this.requireLoaded();
        return this.mAccValuationDepr;
    }

    public boolean getIsCalledFromDepreciation() {
        this.requireLoaded();
        return this.mIsCalledFromDepreciation;
    }

    public void setIsCalledFromDepreciation(boolean isCalledFromDepreciation) {
        this.mIsCalledFromDepreciation = isCalledFromDepreciation;
    }

    public void setAccValuationDepreciation(NominalLedgerAccount accValuationDepr) {
        this.protocol("accvaluationdepr", (IPersistentObject)this.mAccValuationDepr, (IPersistentObject)accValuationDepr);
        this.mAccValuationDepr = accValuationDepr;
    }

    public BigDecimal getFixDeprAmount() {
        this.requireLoaded();
        return this.mFixDeprAmount;
    }

    public void setFixDeprAmount(BigDecimal fixDeprAmount) {
        if (this.mFixDeprAmount != null) {
            this.mFixDeprAmount = this.mFixDeprAmount.setScale(fixDeprAmount.scale(), RoundingMode.DOWN);
        }
        this.protocol(FIXDEPRAMOUNT, this.mFixDeprAmount, fixDeprAmount);
        this.mFixDeprAmount = fixDeprAmount;
    }

    private BigDecimal getSplittetAcquisitionValue(String quantity) {
        DepreciationCalculationHelper dch = this.getAccumulatedValues(null, (ICurrency)null);
        BigDecimal splittetAcqisitionValue = BigDecimal.ZERO;
        if (dch != null) {
            splittetAcqisitionValue = dch.getAccumAcquisitionValue();
            BigDecimal accumQuantity = BigDecimal.ZERO;
            if (quantity != "") {
                accumQuantity = BigDecimalMapper.toBigDecimal((String)quantity);
            }
            if (dch.getQuantity() != null && dch.getQuantity() != "") {
                accumQuantity = accumQuantity.add(BigDecimalMapper.toBigDecimal((String)dch.getQuantity()));
            }
            if (accumQuantity.compareTo(BigDecimal.ZERO) > 0 && splittetAcqisitionValue.compareTo(BigDecimal.ZERO) > 0) {
                splittetAcqisitionValue = splittetAcqisitionValue.divide(accumQuantity, 2, RoundingMode.HALF_EVEN);
            }
        }
        return splittetAcqisitionValue;
    }

    public DepreciationCalculationHelper getAccumulatedValues() {
        return this.getAccumulatedValues(null, (ICurrency)null);
    }

    public DepreciationCalculationHelper getAccumulatedValues(BigDecimal exchangeRate, ICurrency targetCurrency) {
        LOGGER.debug("getAccumulatedValues(...)");
        DepreciationCalculation deprCalc = new DepreciationCalculation(this, DepreciationFunctionEnum.DEFE_CALCULATION);
        List transactCache = deprCalc.buildTransactionsCache(null, exchangeRate, targetCurrency, false);
        if (!transactCache.isEmpty()) {
            return (DepreciationCalculationHelper)transactCache.get(transactCache.size() - 1);
        }
        return null;
    }

    public boolean checkValuesForDate(Date untilDate, boolean isAcquisitionValueFilterSet, boolean isResidualValueFilterSet, BigDecimal fromAcquisitionValue, BigDecimal toAcquisitionValue, BigDecimal fromNetBookValue, BigDecimal toNetBookValue) {
        DepreciationCalculationHelper deprHelperRV;
        DepreciationCalculationHelper deprHelperAV;
        if (isAcquisitionValueFilterSet && (deprHelperAV = this.getAccumulatedValuesForImportCheck(untilDate)) != null && (fromAcquisitionValue != null && deprHelperAV.getAccumAcquisitionValue().compareTo(fromAcquisitionValue) < 0 || toAcquisitionValue != null && deprHelperAV.getAccumAcquisitionValue().compareTo(toAcquisitionValue) > 0)) {
            return true;
        }
        return isResidualValueFilterSet && (deprHelperRV = this.getAccumulatedValuesForImportCheck(untilDate)) != null && (fromNetBookValue != null && deprHelperRV.getNetBookValue().compareTo(fromNetBookValue) < 0 || toNetBookValue != null && deprHelperRV.getNetBookValue().compareTo(toNetBookValue) > 0);
    }

    public DepreciationCalculationHelper getAccumulatedValuesForImportCheck(Date untilDate) {
        LOGGER.debug("getAccumulatedValuesForImportCheck(...)");
        FixedAssetTransaction[] faTransactions = FixedAssetTransaction.getFixedAssetTransactions((FixedAssetArea)this, (Date)untilDate, (boolean)false);
        DepreciationCalculation deprCalc = new DepreciationCalculation(this, DepreciationFunctionEnum.DEFE_CALCULATION);
        List transactCache = deprCalc.buildTransactionsCache(faTransactions, null, null, false);
        if (!transactCache.isEmpty()) {
            return (DepreciationCalculationHelper)transactCache.get(transactCache.size() - 1);
        }
        return null;
    }

    public FixedAssetAreaAccumValues getAccumulatedValues(Date fromDate, Date untilDate) {
        FixedAssetAreaAccumValues accumVal = new FixedAssetAreaAccumValues(this);
        DepreciationCalculation deprCalc = new DepreciationCalculation(this, DepreciationFunctionEnum.DEFE_CALCULATION);
        List transactCache = deprCalc.buildTransactionsCache(null);
        DepreciationCalculationHelper dchBeginDate = null;
        if (fromDate != null) {
            dchBeginDate = DepreciationCalculation.getDeprCalcHelperBeforeOrEqualDate((List)transactCache, (Date)DateHelper.yesterday((Date)fromDate), (boolean)true, (boolean)false);
        }
        DepreciationCalculationHelper dchEndDate = DepreciationCalculation.getDeprCalcHelperBeforeOrEqualDate((List)transactCache, (Date)untilDate, (boolean)true, (boolean)false);
        DepreciationCalculationHelper dchBeforeFullDisposal = null;
        if (dchEndDate != null && dchEndDate.getTransactionType().value() == 20) {
            dchBeforeFullDisposal = (DepreciationCalculationHelper)transactCache.get(dchEndDate.getIndex() - 1);
        }
        accumVal.addDepreciationCalculationHelper(dchBeginDate, dchEndDate, dchBeforeFullDisposal, false, null);
        return accumVal;
    }

    public boolean hasTransactions() {
        return FixedAssetTransaction.checkTransactionExistenceForFixedAssetArea((FixedAsset)this.mFixedAsset, (DepreciationArea)this.mArea);
    }

    public boolean checkExistsActivation(String oidFixedAsset, String oidDepreciationArea) {
        LOGGER.debug("checkExistsActivation(...)");
        Junction junction = Restrictions.conjunction().add(Restrictions.eq((String)"oidfixedasset", (String)oidFixedAsset)).add(Restrictions.eq((String)"oiddeprearea", (String)oidDepreciationArea)).add(Restrictions.ne((String)"iscancelled", (String)BooleanMapper.toString((boolean)true))).add(Restrictions.ne((String)"iscancellation", (String)BooleanMapper.toString((boolean)true))).add(Restrictions.or((Criterion)Restrictions.eq((String)"transactenum", (String)Integer.toString(TransactionEnum.TRE_ACTIVATE_ASSET_UNDER_CONSTR.value())), (Criterion)Restrictions.eq((String)"transactenum", (String)Integer.toString(TransactionEnum.TRE_FULL_DISPOSAL.value()))));
        FixedAssetTransaction[] transactions = FixedAssetTransaction.getTransactions(null, null, (Criterion)junction);
        return transactions.length > 0;
    }

    public boolean checkFixedAssetAreaIsUnchangeable() {
        FixedAssetTransaction[] transactions = FixedAssetTransaction.getTransactions((FixedAssetData)((FixedAssetData)this.mFixedAsset), (DepreciationArea)this.mArea);
        int numberOfTransactions = 0;
        for (int i = 0; i < transactions.length; ++i) {
            if (transactions[i].getTransactionEnum().equals(TransactionEnum.TRE_NEW_ADDITION) || transactions[i].getTransactionEnum().equals(TransactionEnum.TRE_EXISTING_ADDITION)) continue;
            if (transactions[i].getIsCancelation()) {
                --numberOfTransactions;
                continue;
            }
            ++numberOfTransactions;
        }
        return numberOfTransactions > 0;
    }

    public BigDecimal getBaseForDepreciation(String oidCalcMethod, Date untilDate) {
        DepreciationCalculation deprCalc = new DepreciationCalculation(this, DepreciationFunctionEnum.DEFE_CALCULATION);
        List transactCache = deprCalc.buildTransactionsCache(null);
        DepreciationCalculationHelper dch = DepreciationCalculation.getDeprCalcHelperForDate((List)transactCache, (Date)untilDate, null);
        CalcMethod calcMethod = null;
        BigDecimal baseForDepr = BigDecimal.ZERO;
        if (!StringMapper.isNullString((String)oidCalcMethod)) {
            calcMethod = CalcMethodPersistencyManager.getCalcMethod((String)oidCalcMethod);
        }
        if (calcMethod != null) {
            baseForDepr = DepreciationCalculation.getBaseForDepreciation((DepreciationCalculationHelper)dch, (CalcMethod)calcMethod, (FixedAssetArea)this, (Date)untilDate, null, (boolean)false, (Language)this.mFixedAsset.getAccountCompany().getDefaultLanguage());
        }
        return baseForDepr;
    }

    public static int calculateLifeInMonth(Date deprStartDate, Date processingDate) {
        int diffMonth = 0;
        if (processingDate != null && deprStartDate != null) {
            VDate vdDeprStart = new VDate(deprStartDate);
            VDate vdproc = new VDate(processingDate);
            if (!vdproc.isLastDayOfMonth()) {
                vdproc = new VDate(DateHelper.yesterday((Date)DateHelper.getFirstDayOfMonth((Date)processingDate)));
            }
            diffMonth = vdproc.getYear() * 12 + vdproc.getMonth() + 1 - (vdDeprStart.getYear() * 12 + vdDeprStart.getMonth() + 1) + 1;
        }
        if (diffMonth < 0) {
            diffMonth = 0;
        }
        return diffMonth;
    }

    public static int calculateLifeInDays(Date acquisitionDate, Date deprStartDate, int lifeInMonth) {
        int lifeInDays = 0;
        Date startDate = deprStartDate;
        if (lifeInMonth > 0) {
            if (deprStartDate == null) {
                startDate = acquisitionDate;
            }
            Calendar cal = DateHelper.toCalendar((String)DateMapper.toString((Date)startDate));
            cal.add(2, lifeInMonth);
            Date endDate = cal.getTime();
            lifeInDays = DateHelper.getDiffInDays((Date)endDate, (Date)startDate);
        }
        return lifeInDays;
    }

    public static int calculateResidualLifeInMonth(int lifeInMonth, Date deprStartDate, Date untilDate) {
        int resMonth;
        int doneMonth = 0;
        if (untilDate != null && deprStartDate != null) {
            VDate vdDeprStart = new VDate(deprStartDate);
            VDate vdLastdepr = new VDate(untilDate);
            if (!vdLastdepr.isLastDayOfMonth()) {
                vdLastdepr = new VDate(DateHelper.yesterday((Date)DateHelper.getFirstDayOfMonth((Date)untilDate)));
            }
            doneMonth = vdLastdepr.getYear() * 12 + vdLastdepr.getMonth() + 1 - (vdDeprStart.getYear() * 12 + vdDeprStart.getMonth() + 1) + 1;
        }
        if ((resMonth = lifeInMonth - doneMonth) > lifeInMonth) {
            resMonth = lifeInMonth;
        }
        if (resMonth < 0) {
            resMonth = 0;
        }
        return resMonth;
    }

    public static int calculateResLifeInDays(Date processingDate, int resLifeInMonth) {
        int resLifeInDays = 0;
        if (resLifeInMonth > 0) {
            Calendar cal = DateHelper.toCalendar((String)DateMapper.toString((Date)processingDate));
            cal.add(2, resLifeInMonth);
            Date endDate = cal.getTime();
            resLifeInDays = DateHelper.getDiffInDays((Date)endDate, (Date)processingDate);
        }
        return resLifeInDays;
    }

    public static int calculateResLifeInDays(int usefullLifeInDays, Date deprStartDate, Date lastDeprDate, boolean addDay) {
        int resLifeInDays = 0;
        int usedLifeInDays = 0;
        if (deprStartDate != null && lastDeprDate != null && DateHelper.after((Date)lastDeprDate, (Date)deprStartDate)) {
            usedLifeInDays = DateHelper.getDiffInDays((Date)lastDeprDate, (Date)deprStartDate);
            if (addDay) {
                ++usedLifeInDays;
            }
        }
        if (usefullLifeInDays > usedLifeInDays) {
            resLifeInDays = usefullLifeInDays - usedLifeInDays;
        }
        return resLifeInDays;
    }

    public static int calculateResidualLifeInMonthBelowZero(int lifeInMonth, Date deprStartDate, Date untilDate) {
        int doneMonth = 0;
        if (untilDate != null && deprStartDate != null) {
            VDate vdDeprStart = new VDate(deprStartDate);
            VDate vdLastdepr = new VDate(untilDate);
            if (!vdLastdepr.isLastDayOfMonth()) {
                vdLastdepr = new VDate(DateHelper.yesterday((Date)DateHelper.getFirstDayOfMonth((Date)untilDate)));
            }
            doneMonth = vdLastdepr.getYear() * 12 + vdLastdepr.getMonth() + 1 - (vdDeprStart.getYear() * 12 + vdDeprStart.getMonth() + 1) + 1;
        }
        int resMonth = lifeInMonth - doneMonth;
        return resMonth;
    }

    public static int calculateResidualLifeInDaysBelowZero(int lifeInDays, Date deprStartDate, Date untilDate) {
        int doneDays = 0;
        if (untilDate != null && deprStartDate != null) {
            doneDays = DateHelper.getDiffInDays((Date)untilDate, (Date)deprStartDate);
        }
        int resDays = lifeInDays - doneDays;
        return resDays;
    }

    public int getNumberOfYear(FAFinancialYear finYear) {
        Date deprStartDate;
        if (this.mDeprStartDate == null || finYear == null) {
            return 0;
        }
        FAFinancialYear firstFinYear = FAFinancialYear.getFAFinancialYearOrNullForDate((AccountingCompany)this.mFixedAsset.getAccountCompany(), (Date)this.mDeprStartDate, null);
        if (firstFinYear == null) {
            VDate date1 = new VDate(finYear.getValidFrom());
            VDate date2 = new VDate(this.mDeprStartDate);
            VDate vdDeprStart = new VDate(date2.getYear(), date1.getMonth(), date1.getDay());
            deprStartDate = vdDeprStart.getDate();
        } else {
            deprStartDate = firstFinYear.getValidFrom();
        }
        if (deprStartDate != null && DateHelper.before((Date)finYear.getValidFrom(), (Date)deprStartDate)) {
            return 0;
        }
        return DateHelper.getDiffInMonths((Date)finYear.getValidFrom(), (Date)deprStartDate) / 12 + 1;
    }

    public static FAFinancialYear getFAFinancialYearForNumberOfYear(int numberOfYear, Date deprStartDate, AccountingCompany company, FAFinancialYear[] finYears) {
        if (--numberOfYear < 0 || deprStartDate == null) {
            return null;
        }
        Date deprDate = new VDate(deprStartDate).addYears(numberOfYear).getDate();
        return FAFinancialYear.getFAFinancialYearOrNullForDate((AccountingCompany)company, (Date)deprDate, (FAFinancialYear[])finYears);
    }

    static {
        FixedAsset.mProtocolList.add(mDefaults);
    }
}

