/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.invoiceorcreditnotetransaction.report;

import com.infor.igf.core.util.StringUtil;
import com.varial.accounting.domain.documenttype.DocumentCategoryType;
import com.varial.accounting.domain.financialyear.AccountingCompany;
import com.varial.accounting.domain.invoiceorcreditnotetransaction.report.InvoiceOrCreditNoteTransactionContainer;
import com.varial.accounting.domain.invoiceorcreditnotetransaction.report.TransactionBaseDataForReport;
import com.varial.accounting.persistency.nlacctransact.NlacctransactContainer;
import com.varial.base.UtilitiesManager;
import com.varial.base.configuration.Configuration;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.jasperreports.JasperParameterHashMap;
import com.varial.base.jasperreports.ReportFlags;
import com.varial.base.persistency.PersistencyDataSet;
import com.varial.base.types.Ternary;
import com.varial.base.types.date.DateHelper;
import com.varial.framework.basictypes.ReportExportFormatType;
import com.varial.framework.domain.company.ICompany;
import com.varial.framework.domain.company.JurisdictionType;
import com.varial.framework.domain.isoftware.ISoftware;
import com.varial.interfaces.ICurrency;
import com.varial.license.service.ILicenseService;
import com.varial.serverbase.domain.language.ILanguage;
import com.varial.serverbase.domain.language.Language;
import com.varial.serverbase.domain.resource.TranslateableResourceList;
import com.varial.serverbase.mapper.BigDecimalFormatter;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.shared.Version;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvoiceOrCreditNoteTransactionReportDataSource
implements JRDataSource {
    private static Logger LOGGER = LoggerFactory.getLogger((String)InvoiceOrCreditNoteTransactionReportDataSource.class.getName());
    private final Configuration configuration = (Configuration)UtilitiesManager.getBean((String)"com.infor.igf.configuration", Configuration.class);
    private static final ILicenseService licenseService = (ILicenseService)UtilitiesManager.getBean((String)"licenseService", ILicenseService.class);
    public static final String PROPKEY_SOFTWARENAME = "com.varial.reports.SoftwareName";
    private static final boolean ISLOVAT = ISoftware.isLovat();
    private static final boolean ISKRONOSPAN = ISoftware.isKronospan();
    private final ReportFlags mReportFlags;
    private final Language mLanguage;
    private boolean mHasNext = true;
    private final PersistencyDataSet mDataset;
    private InvoiceOrCreditNoteTransactionContainer mContainer;
    private final AccountingCompany mCompany;
    private final ICurrency mBaseCurrency;
    private final String mRelease;
    private String mReleaseInfoPrefix;
    private BigDecimalFormatter mBigDecimalFormatter;
    private String mOidTransaction;
    private TransactionBaseDataForReport mTransactionBaseData;
    private final boolean mIsRO;
    private final boolean mFirst;
    private final NlacctransactContainer[] mNltContainer;
    private final int lengthDataset = 0;
    private int counter = 0;
    private final ReportExportFormatType mReportExportFormatType;
    private static final String P_JASPERHELPER = "P_ReportFlags";
    private static final String P_BIGDECIMALFORMATTER = "P_BigDecimalFormatter";
    private static final String P_COMPANY = "P_Company";
    private static final String P_COMPANYADDRESS = "P_CompanyAddress";
    private static final String P_COMPANYTAXNUMBER = "P_CompanyTaxNumber";
    private static final String P_COMPANYECTAXNUMBER = "P_CompanyECTaxNumber";
    private static final String P_RELEASE = "P_Release";
    private static final String P_CURRENCYSIGN = "P_CurrencySign";
    private static final String S_INVOICEDOCUMENT = "S_InvoiceDocument";
    private static final String S_PAGE = "S_Page";
    private static final String S_COMPANY = "S_Company";
    private static final String S_REFERENCENUMBER = "S_ReferenceNumber";
    private static final String S_GROSSAMOUNT = "S_GrossAmount";
    private static final String S_REFERENCEDATE = "S_ReferenceDate";
    private static final String S_SERVICEPROVISIONDATE = "S_ServiceProvisionDate";
    private static final String S_SERVICETYPE = "S_ServiceType";
    private static final String S_COSTTYPE = "S_CostType";
    private static final String S_CENTER = "S_Center";
    private static final String S_ORDERNUMBER = "S_OrderNumber";
    private static final String S_ORDERNUMBERONEWORD = "S_OrderNumberOneWord";
    private static final String S_CREDIT = "S_Credit";
    private static final String S_DEBIT = "S_Debit";
    private static final String S_VALUE = "S_Value";
    private static final String S_TAXCODE = "S_TaxCode";
    private static final String S_DESCRIPTION = "S_Description";
    private static final String S_CONTROLLED = "S_Controlled";
    private static final String S_APPROVED = "S_Approved";
    private static final String S_BOOKEDTODAY = "S_BookedToday";
    private static final String S_TRANSPORT = "S_Transport";
    private static final String S_ORDER = "S_Order";
    private static final String S_DISPATCHDATE = "S_DispatchDate";
    private static final String S_FOREIGNCURRENCY = "S_ForeignCurrency";
    private static final String S_BASECURRENCY = "S_BaseCurrency";
    private static final String S_SEQUENCENUMBER = "S_SequenceNumber";
    private static final String S_DOCUMENTTYPE = "S_DocumentType";
    private static final String S_ACCOUNT = "S_Account";
    private static final String S_VALUEDATE = "S_ValueDate";
    private static final String S_TRANSACTIONDATE = "S_TransactionDate";
    private static final String S_COSTUNIT = "S_CostUnit";
    private static final String S_CONTROLACCOUNT = "S_ControlAccount";
    private static final String S_TAXNUMBER = "S_TaxNumber";
    private static final String S_ECTAXNUMBER = "S_ECTaxNumber";
    private static final String S_FROM = "S_From";
    private static final String S_TO = "S_To";
    private static final String S_DOCUMENTDATE = "S_DocumtentDate";
    private static final String S_TOTALAMOUNT = "S_TotalAmount";
    private static final String S_ATTACHMENT = "S_Attachment";
    private static final String S_DRAWER = "S_Drawer";
    private static final String S_INCOME_CASH_DOCUMENT = "S_IncomeCashDocument";
    private static final String S_OUTCOME_CASH_DOCUMENT = "S_OutcomeCashDocument";
    private static final String S_FINANCIALYEAR = "S_FinancialYear";
    private static final String S_FACTUALLY_CORRECT = "S_FactuallyCorrect";
    private static final String S_ARITHMETICALLY_CORRECT = "S_ArithmeticallyCorrect";
    private static final String S_FOR_PAYMENT = "S_ForPayment";
    private static final String S_POSTED = "S_Posted";
    private static final String S_POSTEDBY = "S_PostedBy";
    private static final String S_NETPLIMPACT = "S_NetPLImpact";
    private static final String S_YES = "S_Yes";
    private static final String S_NO = "S_No";
    private static final String S_CREATED = "S_Created";
    private static final String S_UPDATED = "S_Updated";
    private static final String S_INVOICEDOCUMENT1 = "S_InvoiceDocument1";
    private static final String S_ADDRESS = "S_Address";
    private static final String S_DELIVERYADDRESS = "S_DeliveryAddress";
    private static final String S_CONDITION = "S_Condition";
    private static final String S_QUANTITYAMOUNT = "S_QuantityAmount";
    private static final String S_QUANTITYUNIT = "S_QuantityUnit";
    private static final String S_TAXRATE = "S_TaxRate";
    private static final String S_AMOUNT = "S_Amount";
    private static final String S_DUEDATE = "S_DueDate";
    private static final String S_NETAMOUNT = "S_NetAmount";
    private static final String S_GROSSAMOUNT1 = "S_GrossAmount1";
    private static final String S_MESSAGE1 = "S_Message1";
    private static final String S_MESSAGE2 = "S_Message2";
    private static final String S_TOTAL = "S_Total";
    public static final String S_CARRYFORWARD = "S_CarryForward";
    public static final String S_CARRYOVER = "S_CarryOver";
    private static final int INVOICEDOCUMENT = 0;
    private static final int PAGE = 1;
    private static final int COMPANY = 2;
    private static final int REFERENCENUMBER = 3;
    private static final int GROSSAMOUNT = 4;
    private static final int REFERENCEDATE = 5;
    private static final int SERVICEPROVISIONDATE = 6;
    private static final int SERVICETYPE = 7;
    private static final int CENTER = 8;
    private static final int ORDERNUMBER = 9;
    private static final int CREDIT = 10;
    private static final int DEBIT = 11;
    private static final int VALUE = 12;
    private static final int TAXCODE = 13;
    private static final int DESCRIPTION = 14;
    private static final int CONTROLLED = 15;
    private static final int APPROVED = 16;
    private static final int BOOKEDTODAY = 17;
    private static final int TRANSPORT = 18;
    private static final int ORDER = 19;
    private static final int DISPATCHDATE = 20;
    private static final int FOREIGNCURRENCY = 21;
    private static final int BASECURRENCY = 22;
    private static final int SEQUENCENUMBER = 23;
    private static final int DOCUMENTTYPE = 24;
    private static final int ACCOUNT = 25;
    private static final int VALUEDATE = 26;
    private static final int TRANSACTIONDATE = 27;
    private static final int COSTUNIT = 28;
    private static final int ORDERNUMBERONEWORD = 29;
    private static final int CONTROLACCOUNT = 30;
    private static final int TAXNUMBER = 31;
    private static final int ECTAXNUMBER = 32;
    private static final int FROM = 33;
    private static final int TO = 34;
    private static final int DOCUMENTDATE = 35;
    private static final int TOTALAMOUNT = 36;
    private static final int ATTACHMENT = 37;
    private static final int DRAWER = 38;
    private static final int INCOME_CASH_DOCUMENT = 39;
    private static final int OUTCOME_CASH_DOCUMENT = 40;
    private static final int POSTED = 41;
    private static final int POSTEDBY = 42;
    private static final int YES = 43;
    private static final int NO = 44;
    private static final int NETPLIMPACT = 45;
    private static final int COSTTYPE = 46;
    private static final int FINANCIALYEAR = 47;
    private static final int FACTUALLY_CORRECT = 48;
    private static final int ARITHMETICALLY_CORRECT = 49;
    private static final int FOR_PAYMENT = 50;
    private static final int CREATED = 51;
    private static final int UPDATED = 52;
    private static final int INVOICEDOCUMENT1 = 55;
    private static final int DELIVERYADDRESS = 56;
    private static final int ADDRESS = 57;
    private static final int CONDITION = 58;
    private static final int QUANTITYAMOUNT = 59;
    private static final int QUANTITYUNIT = 60;
    private static final int TAXRATE = 61;
    private static final int AMOUNT = 62;
    private static final int DUEDATE = 63;
    private static final int NETAMOUNT = 64;
    private static final int GROSSAMOUNT1 = 65;
    private static final int MESSAGE1 = 66;
    private static final int MESSAGE2 = 67;
    private static final int TOTAL = 68;
    private static final int CARRYFORWARD = 69;
    private static final int CARRYOVER = 70;
    private static final String F_PAYMENT_RECEIPT = "F_Payment_Receipt";
    private static final String F_FOREIGNGROSSAMOUNT = "F_ForeignGrossAmount";
    private static final String F_BASEGROSSAMOUNT = "F_BaseGrossAmount";
    private static final String F_BASEGROSSAMOUNT_LETTER = "F_BaseGrossAmountLetter";
    private static final String F_RECEIPTDATE = "F_ReceiptDate";
    private static final String F_ORDERNUMBER = "F_OrderNumber";
    private static final String F_VALUEDATE = "F_ValueDate";
    private static final String F_ACCOUNTCODE = "F_AccountCode";
    private static final String F_SHORTNAME = "F_Shortname";
    private static final String F_ADDRESS = "F_Address";
    private static final String F_POSTALADDRESS = "F_PostalAddress";
    private static final String F_TAXNUMBER = "F_TaxNumber";
    private static final String F_ECTAXNUMBER = "F_ECTaxNumber";
    private static final String F_TRANSACTIONDATE = "F_TransactionDate";
    private static final String F_DOCUMENTDATE = "F_DocumentDate";
    private static final String F_TAXDATE = "F_TaxDate";
    private static final String F_TRANSACTIONTYPE = "F_TransactionType";
    private static final String F_TRANSACTIONTYPEASINT = "F_TransactionTypeAsInt";
    private static final String F_REFERENCENUMBER = "F_ReferenceNumber";
    private static final String F_SEQUENCENUMBER = "F_SequenceNumber";
    private static final String F_TAX = "F_Tax";
    private static final String F_TAXRATE = "F_TaxRate";
    private static final String F_DEBIT = "F_Debit";
    private static final String F_DEBITOC = "F_DebitOC";
    private static final String F_BASEAMOUNT = "F_BaseAmount";
    private static final String F_CREDIT = "F_Credit";
    private static final String F_CREDITOC = "F_CreditOC";
    private static final String F_DESCRIPTION = "F_Description";
    private static final String F_INVOICEOID = "F_InvoiceOid";
    private static final String F_BASECURRENCY = "F_BaseCurrency";
    private static final String F_FOREIGNCURRENCY = "F_ForeignCurrency";
    private static final String F_ISPERSONAL = "F_IsPersonal";
    private static final String F_ISDEBIT = "F_IsDebit";
    private static final String F_DOCUMENTTYPE = "F_DocumentType";
    private static final String F_ISPURCHASE = "F_IsPurchase";
    private static final String F_ISCONTROLACCOUNT = "F_IsControlAccount";
    private static final String F_CODECONTROLACCOUNT = "F_CodeControlAccount";
    private static final String F_NAMECONTRAACCOUNT = "F_NameContraAccount";
    private static final String F_SUBREPORT_DATASOURCE = "F_SubReport_DataSource";
    private static final String F_ISPERSONALACCOUNTENTRY = "F_IsPersonalAccountEntry";
    private static final String F_ISTAXENTRY = "F_IsTaxEntry";
    private static final String F_FINANCIALYEAR = "F_FinancialYear";
    private static final String F_POSTED = "F_Posted";
    private static final String F_ISACCTYPE_PL = "F_IsAccountType_PL";
    private static final String F_TIMESTAMPOFTRANSACTION = "F_TimestampOfTransaction";
    private static final String F_LASTUSERID = "F_LastUserID";
    private static final String F_CREATIONDATE = "F_CreationDate";
    private static final String F_CREATORID = "F_CreatorID";
    private static final String F_QUANTITYAMOUNT = "F_QuantityAmount";
    private static final String F_QUANTITYUNIT = "F_QuantityUnit";
    private static final String F_DUEDATE = "F_DueDate";
    private static final String F_NETAMOUNT = "F_NetAmount";
    private static final String F_PAYMENTCONDITIONDESC = "F_PaymentConditionDesc";
    public static final String F_ARCHIVEKEYWORDS = "F_ArchiveKeywords";
    public static final String F_DUMMY = "F_Dummy";
    private static TranslateableResourceList mInvoiceOrCreditNoteTransactionReportList = TranslateableResourceList.createTranslateableResourceList((String)"InvoiceOrCreditNoteTransactionReportList", (String[])new String[]{"Invoice Document", "Page", "Company", "Ref. Number", "Gross Amount", "Ref. Date", "Service Prov. Date", "Service Type", "Center", "Order Number", "Credit", "Debit", "Value", "Tax Code", "Description", "Controlled", "Approved", "Booked Today", "Transport", "Order", "Dispatch Date", "Foreign Currency", "Base Currency", "Sequence Number", "Document Type", "Account", "Value Date", "Transaction Date", "Cost Unit", "Ordernumber", "Control Account", "Tax Number", "EC Tax Number", "From", "To", "Document Date", "\u00d6sszesen", "Mell\u00e9klet", "Ki\u00e1ll\u00edt\u00f3", "Bev\u00e9teli p\u00e9nzt\u00e1rbizonylat", "Kiad\u00e1si p\u00e9nzt\u00e1rbizonylat", "Posted", "Posted by", "Yes", "No", "Net P/L Impact", "Cost Type", "Gesch\u00e4ftsjahr", "sachlich richtig", "rechnerisch richtig", "zur Zahlung/Heute gebucht", "Erstellt", "Ge\u00e4ndert", "Binnen", "dagen na factuurdatum", "Factuur", "Afleveradres", "Factuuradres", "Betalingsconditie", "Hoeveelheid", "Eenheid", "BTW", "Bedrag", "Vervaldatum", "Belastbaar", "Bedrag incl. BTW", "Eventuele reclamaties binnen 8 dagen na factuurdatum", "Graag bij betaling klantnr en factuurnr. vermelden", "Totaal", "Z przeniesienia", "Do przeniesienia"});
    private static final String[] what = new String[]{"", "ezer", "milli\u00f3", "milli\u00e1rd"};
    private static final String[] num = new String[]{"", "egy", "kett\u00f5", "h\u00e1rom", "n\u00e9gy", "\u00f6t", "hat", "h\u00e9t", "nyolc", "kilenc"};
    private static final String[] tens = new String[]{"", "t\u00edz", "h\u00fasz", "harminc", "negyven", "\u00f6tven", "hatvan", "hetven", "nyolcvan", "kilencven"};
    private static final String[] tenssomething = new String[]{"", "tizen", "huszon", "harminc", "negyven", "\u00f6tven", "hatvan", "hetven", "nyolcvan", "kilencven"};
    private static final String _hundred_ = "sz\u00e1z";
    private static final String _zero_ = "nulla";

    public InvoiceOrCreditNoteTransactionReportDataSource(PersistencyDataSet dataset, NlacctransactContainer[] nltContainer, AccountingCompany company, boolean isRO, ReportExportFormatType reportExportFormatType) {
        this.mDataset = dataset;
        this.mNltContainer = nltContainer;
        this.mCompany = company;
        this.mBaseCurrency = company.getFinanceSetup().getBaseCurrency();
        this.mLanguage = this.mCompany.getDefaultLanguage();
        this.mReportFlags = new ReportFlags();
        this.mRelease = Version.getVersion();
        this.mIsRO = isRO;
        this.mReportExportFormatType = reportExportFormatType;
        this.mBigDecimalFormatter = this.mLanguage.hasLocale() ? new BigDecimalFormatter(this.mLanguage.getLocale()) : new BigDecimalFormatter();
        this.mOidTransaction = "";
        this.mFirst = true;
        try {
            this.mReleaseInfoPrefix = StringMapper.toString((String)this.configuration.getPrefixForReleaseInfo()).trim() + " ";
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean getHasNext() {
        return this.mIsRO && this.mFirst || this.mHasNext;
    }

    public boolean next() throws JRException {
        boolean result = false;
        try {
            if (this.mDataset != null) {
                result = this.mHasNext = this.mDataset.hasNext();
                this.mContainer = this.mHasNext ? this.makeContainer((NlacctransactContainer)this.mDataset.getNext()) : null;
                ++this.counter;
            } else {
                result = this.mHasNext = this.counter < this.mNltContainer.length;
                this.mContainer = this.mHasNext ? this.makeContainer(this.mNltContainer[this.counter]) : null;
                ++this.counter;
            }
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
        return result;
    }

    private String makeAnchiveKeyWort(InvoiceOrCreditNoteTransactionContainer container) {
        if (!licenseService.isArchiveLicensed("FI")) {
            return " ";
        }
        if (this.mReportExportFormatType != ReportExportFormatType.ARCHIVE) {
            Ternary autoArchiving = this.configuration.getAutomaticArchivingType();
            if (!licenseService.isArchiveLicensed("FI")) {
                autoArchiving = Ternary.FALSE;
            }
        }
        StringBuffer strBuffer = new StringBuffer("C21030:Buchungsbeleg ");
        strBuffer.append("C21004:");
        strBuffer.append(this.mCompany.getCode()).append(' ');
        strBuffer.append("C21005:");
        strBuffer.append(container.getFinancialYear()).append(' ');
        strBuffer.append("C21007:");
        strBuffer.append(container.getShortName()).append(' ');
        strBuffer.append("C21008:");
        strBuffer.append(container.getCode()).append(' ');
        strBuffer.append("C21006:");
        strBuffer.append(container.getReferenceNumber()).append(' ');
        strBuffer.append("C21040:");
        strBuffer.append(container.getTransactionTypeAsString());
        return strBuffer.toString();
    }

    private boolean transactionChanged(String oidTransact) {
        if (!this.mOidTransaction.equals(oidTransact)) {
            this.mOidTransaction = oidTransact;
            return true;
        }
        return false;
    }

    private InvoiceOrCreditNoteTransactionContainer makeContainer(NlacctransactContainer container) {
        try {
            if (this.transactionChanged(container.t_objectid)) {
                this.mTransactionBaseData = new TransactionBaseDataForReport(container, this.mBaseCurrency);
            }
            return new InvoiceOrCreditNoteTransactionContainer(container, this.mTransactionBaseData, this.mLanguage, this.mCompany);
        }
        catch (Exception e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    public Object getFieldValue(JRField field) throws JRException {
        Object value = null;
        if (this.mContainer != null) {
            try {
                if (F_DUMMY.equals(field.getName())) {
                    value = this.counter < this.mNltContainer.length;
                } else if (F_FOREIGNGROSSAMOUNT.equals(field.getName())) {
                    value = this.mContainer.getForeignGrossAmount();
                } else if (F_FINANCIALYEAR.equals(field.getName())) {
                    value = this.mContainer.getFinancialYear();
                } else if (F_BASEGROSSAMOUNT.equals(field.getName())) {
                    value = this.mContainer.getBaseGrossAmount();
                } else if (F_BASEGROSSAMOUNT_LETTER.equals(field.getName())) {
                    value = InvoiceOrCreditNoteTransactionReportDataSource.numberToLetter(this.mContainer.getBaseGrossAmount(), this.mLanguage);
                } else if (F_BASECURRENCY.equals(field.getName())) {
                    value = this.mContainer.getBaseCurrencyCode();
                } else if (F_FOREIGNCURRENCY.equals(field.getName())) {
                    value = this.mContainer.getForeignCurrencyCode();
                } else if (F_TRANSACTIONTYPE.equals(field.getName())) {
                    value = this.mContainer.getTransactionTypeAsString();
                } else if (F_TRANSACTIONTYPEASINT.equals(field.getName())) {
                    value = this.mContainer.getDocumentCategory();
                } else if (F_ACCOUNTCODE.equals(field.getName())) {
                    value = this.mContainer.getCode();
                } else if (F_SHORTNAME.equals(field.getName())) {
                    value = this.mContainer.getShortName();
                    if (ISKRONOSPAN && !StringMapper.isNullString((String)this.mCompany.getCountry().getIsoCode()) && this.mCompany.getCountry().getIsoCode().equals("TR") && this.mContainer.getIsPersonalAccountEntry()) {
                        value = this.mContainer.getName();
                    }
                } else if (F_ADDRESS.equals(field.getName())) {
                    value = this.mContainer.getAddress();
                } else if (F_TAXNUMBER.equals(field.getName())) {
                    value = this.mContainer.getTaxNumber();
                } else if (F_ECTAXNUMBER.equals(field.getName())) {
                    value = this.mContainer.getECTaxNumber();
                } else if (F_TRANSACTIONDATE.equals(field.getName())) {
                    value = this.mContainer.getTransactionDate();
                } else if (F_DOCUMENTDATE.equals(field.getName())) {
                    value = this.mContainer.getDocumentDate();
                } else if (F_TAXDATE.equals(field.getName())) {
                    value = this.mContainer.getTaxDate();
                } else if (F_REFERENCENUMBER.equals(field.getName())) {
                    value = this.mContainer.getReferenceNumber();
                } else if (F_SEQUENCENUMBER.equals(field.getName())) {
                    value = this.mContainer.getSequenceNumber();
                } else if (F_TAX.equals(field.getName())) {
                    value = this.mContainer.getTaxCode();
                } else if (F_BASEAMOUNT.equals(field.getName())) {
                    value = this.mContainer.getBaseAmount();
                } else if (F_DEBIT.equals(field.getName())) {
                    value = this.mContainer.getAmountDebit();
                } else if (F_DEBITOC.equals(field.getName())) {
                    value = this.mContainer.getAmountDebitOC();
                } else if (F_CREDIT.equals(field.getName())) {
                    value = this.mContainer.getAmountCredit();
                } else if (F_CREDITOC.equals(field.getName())) {
                    value = this.mContainer.getAmountCreditOC();
                } else if (F_ISPERSONAL.equals(field.getName())) {
                    value = this.mContainer.isPersonal();
                } else if (F_ISDEBIT.equals(field.getName())) {
                    value = this.mContainer.isDebit();
                } else if (F_DESCRIPTION.equals(field.getName())) {
                    value = this.mContainer.getDescription();
                } else if (F_RECEIPTDATE.equals(field.getName())) {
                    value = this.mContainer.getReceiptDate();
                } else if (F_VALUEDATE.equals(field.getName())) {
                    value = this.mContainer.getValueDate();
                } else if (F_ORDERNUMBER.equals(field.getName())) {
                    value = this.mContainer.getProcessID();
                } else if (F_INVOICEOID.equals(field.getName())) {
                    value = this.mContainer.getOidTransaction();
                } else if (F_ISPURCHASE.equals(field.getName())) {
                    value = this.mContainer.getDocumentCategory() == DocumentCategoryType.PURCHASEINVOICES.persistentValue() || this.mContainer.getDocumentCategory() == DocumentCategoryType.PURCHASECREDITNOTES.persistentValue() ? Boolean.TRUE : Boolean.FALSE;
                } else if (F_ISPERSONALACCOUNTENTRY.equals(field.getName())) {
                    value = this.mContainer.getIsPersonalAccountEntry() ? Boolean.TRUE : Boolean.FALSE;
                } else if (F_DOCUMENTTYPE.equals(field.getName())) {
                    value = this.mContainer.getDocumentType();
                } else if (F_ISCONTROLACCOUNT.equals(field.getName())) {
                    value = this.mContainer.getIsControlAccount();
                } else if (F_CODECONTROLACCOUNT.equals(field.getName())) {
                    value = this.mContainer.getCodeControlAccount();
                } else if (F_NAMECONTRAACCOUNT.equals(field.getName())) {
                    if (this.mContainer.getContraPersonalAccount() != null) {
                        value = this.mContainer.getContraPersonalAccount().getAddress().getPostalAddress().getName();
                    }
                } else if (F_SUBREPORT_DATASOURCE.equals(field.getName())) {
                    value = this.mContainer.getCostingTransactionDataSource();
                } else if (F_PAYMENT_RECEIPT.equals(field.getName())) {
                    value = this.mTransactionBaseData.isPayment() ? mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 40) : mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 39);
                } else if (ISLOVAT) {
                    if (F_POSTED.equals(field.getName())) {
                        value = this.mContainer.getIsPosted();
                    } else if (F_ISACCTYPE_PL.equals(field.getName())) {
                        value = this.mContainer.getIsPLAccountEntry();
                    }
                } else if (F_LASTUSERID.equals(field.getName())) {
                    value = this.mContainer.getLastUserID();
                } else if (F_TIMESTAMPOFTRANSACTION.equals(field.getName())) {
                    if (this.mContainer.getTimestampOfTransaction() != null) {
                        value = DateHelper.toDateAndTime((Date)this.mContainer.getTimestampOfTransaction());
                    }
                } else if (F_CREATORID.equals(field.getName())) {
                    value = this.mContainer.getCreatorID();
                } else if (F_CREATIONDATE.equals(field.getName())) {
                    if (this.mContainer.getCreationDate() != null) {
                        value = DateHelper.toDateAndTime((Date)this.mContainer.getCreationDate());
                    }
                } else if (F_POSTALADDRESS.equals(field.getName())) {
                    value = this.mContainer.getPostalAddress();
                } else if (F_ISTAXENTRY.equals(field.getName())) {
                    value = this.mContainer.getIsTaxEntry();
                } else if (F_TAXRATE.equals(field.getName())) {
                    value = this.mContainer.getTaxRate();
                } else if (F_QUANTITYAMOUNT.equals(field.getName())) {
                    value = this.mContainer.getQuantityAmount();
                } else if (F_QUANTITYUNIT.equals(field.getName())) {
                    value = this.mContainer.getQuantityUnit();
                } else if (F_PAYMENTCONDITIONDESC.equals(field.getName())) {
                    value = this.mContainer.getPaymentConditionDesc();
                } else if (F_DUEDATE.equals(field.getName())) {
                    value = this.mContainer.getDueDate();
                } else if (F_NETAMOUNT.equals(field.getName())) {
                    value = this.mContainer.getNetAmount();
                } else if (F_ARCHIVEKEYWORDS.equals(field.getName())) {
                    value = this.makeAnchiveKeyWort(this.mContainer);
                }
                if (value instanceof String) {
                    value = StringUtil.toJasperString((String)((String)value));
                } else if (value instanceof Date) {
                    value = DateMapper.toString((ILanguage)this.mLanguage, (Date)((Date)value));
                } else if (value instanceof BigDecimal) {
                    value = this.mContainer.getForeignCurrency() != null ? this.mContainer.getForeignCurrency().round((BigDecimal)value) : this.mContainer.getBaseCurrency().round((BigDecimal)value);
                }
            }
            catch (Exception e) {
                ExceptionMapper.printException((Throwable)e);
            }
        }
        return value;
    }

    private String getDateTimeString(Language language, Date valueDate) {
        String result = "";
        String dateString = DateMapper.toString((ILanguage)language, (Date)valueDate);
        String dateTimeString = valueDate.toString();
        result = dateString.concat(dateTimeString.substring(10, 19));
        return result;
    }

    private static String numberToLetter(BigDecimal baseGrossAmount, Language language) {
        StringBuilder result = new StringBuilder();
        if (language.getCode().equalsIgnoreCase("HU")) {
            if (baseGrossAmount.equals(BigDecimal.ZERO)) {
                return _zero_;
            }
            BigDecimal[] res = new BigDecimal[]{baseGrossAmount, BigDecimal.ZERO};
            int idx = 0;
            do {
                res = res[0].divideAndRemainder(BigDecimal.valueOf(1000L));
                if (baseGrossAmount.compareTo(BigDecimal.valueOf(2000L)) == 1 && idx != 0 && result.length() != 0) {
                    result.insert(0, '-');
                }
                result.insert(0, what[idx]);
                result.insert(0, InvoiceOrCreditNoteTransactionReportDataSource.sayHU(res[1].intValue()));
                ++idx;
            } while (res[0].compareTo(BigDecimal.ZERO) == 1);
            result.insert(0, ", azaz ");
        }
        return result.toString();
    }

    private static String sayHU(int i) {
        int hundred = i / 100;
        int ten = (i %= 100) / 10;
        i %= 10;
        StringBuilder result = new StringBuilder();
        if (hundred != 0) {
            result.append(num[hundred]);
            result.append(_hundred_);
        }
        result.append(ten != 0 ? tenssomething[ten] : tens[ten]).append(num[i]);
        return result.toString();
    }

    public Map<String, Object> getParameters() throws BusinessDomainException {
        JasperParameterHashMap parameters = new JasperParameterHashMap();
        parameters.put(P_JASPERHELPER, this.mReportFlags);
        parameters.put(P_BIGDECIMALFORMATTER, this.mBigDecimalFormatter);
        if (this.mCompany.getJurisdictionType() == JurisdictionType.PL && ISoftware.isKronospan()) {
            parameters.put(P_COMPANY, this.mCompany.getCurrentAddress().getPostalAddress().getName());
        } else {
            parameters.put(P_COMPANY, this.mCompany.getCode() + " / " + this.mCompany.getCurrentAddress().getShortName());
        }
        parameters.put(P_COMPANYADDRESS, this.mCompany.getCurrentAddress().getPostalAddress().getFormatedAddressWithPostOfficeBox((ICompany)this.mCompany, (ILanguage)this.mLanguage));
        String taxNumber = "";
        if (this.mCompany.getUKTax() != null && !StringMapper.isNullString((String)this.mCompany.getUKTax().getTaxNumber())) {
            taxNumber = this.mCompany.getUKTax().getTaxNumber();
        }
        parameters.put(P_COMPANYTAXNUMBER, taxNumber);
        taxNumber = "";
        if (this.mCompany.getECTax() != null && !StringMapper.isNullString((String)this.mCompany.getECTax().getTaxNumber())) {
            taxNumber = this.mCompany.getECTax().getTaxNumber();
        }
        parameters.put(P_COMPANYECTAXNUMBER, taxNumber);
        parameters.put(P_RELEASE, this.mReleaseInfoPrefix.concat(this.mRelease));
        if (this.mBaseCurrency.getSwift().equals("EUR")) {
            parameters.put(P_CURRENCYSIGN, "\u20ac");
        } else {
            parameters.put(P_CURRENCYSIGN, this.mBaseCurrency.getSwift());
        }
        parameters.put(S_FINANCIALYEAR, mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 47));
        parameters.put(S_INVOICEDOCUMENT, mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 0));
        parameters.put(S_PAGE, mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 1));
        parameters.put(S_COMPANY, mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 2));
        parameters.put(S_REFERENCENUMBER, mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 3));
        parameters.put(S_GROSSAMOUNT, mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 4));
        parameters.put(S_REFERENCEDATE, mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 5));
        parameters.put(S_SERVICEPROVISIONDATE, mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 6));
        parameters.put(S_SERVICETYPE, mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 7));
        parameters.put(S_CENTER, mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 8));
        parameters.put(S_COSTTYPE, mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 46));
        parameters.put(S_ORDERNUMBER, mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 9));
        parameters.put(S_ORDERNUMBERONEWORD, mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 29));
        parameters.put(S_CREDIT, mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 10));
        parameters.put(S_DEBIT, mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 11));
        parameters.put(S_VALUE, mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 12));
        parameters.put(S_TAXCODE, mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 13));
        parameters.put(S_DESCRIPTION, mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 14));
        parameters.put(S_FACTUALLY_CORRECT, mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 48));
        parameters.put(S_ARITHMETICALLY_CORRECT, mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 49));
        parameters.put(S_FOR_PAYMENT, mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 50));
        parameters.put(S_CONTROLLED, mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 15));
        parameters.put(S_APPROVED, mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 16));
        parameters.put(S_BOOKEDTODAY, mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 17));
        parameters.put(S_TRANSPORT, mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 18));
        parameters.put(S_ORDER, mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 19));
        parameters.put(S_DISPATCHDATE, mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 20));
        parameters.put(S_FOREIGNCURRENCY, mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 21));
        parameters.put(S_BASECURRENCY, mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 22));
        parameters.put(S_SEQUENCENUMBER, mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 23));
        parameters.put(S_VALUEDATE, mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 26));
        parameters.put(S_DOCUMENTTYPE, mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 24));
        parameters.put(S_ACCOUNT, mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 25));
        parameters.put(S_TRANSACTIONDATE, mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 27));
        parameters.put(S_COSTUNIT, mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 28));
        parameters.put(S_CONTROLACCOUNT, mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 30));
        parameters.put(S_TAXNUMBER, mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 31));
        parameters.put(S_ECTAXNUMBER, mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 32));
        parameters.put(S_FROM, mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 33));
        parameters.put(S_TO, mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 34));
        parameters.put(S_DOCUMENTDATE, mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 35));
        parameters.put(S_TOTALAMOUNT, mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 36));
        parameters.put(S_ATTACHMENT, mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 37));
        parameters.put(S_DRAWER, mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 38));
        parameters.put(S_INCOME_CASH_DOCUMENT, mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 39));
        parameters.put(S_OUTCOME_CASH_DOCUMENT, mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 40));
        if (ISLOVAT) {
            parameters.put(S_POSTED, mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 41));
            parameters.put(S_POSTEDBY, mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 42));
            parameters.put(S_NETPLIMPACT, mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 45));
            parameters.put(S_YES, mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 43));
            parameters.put(S_NO, mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 44));
        }
        parameters.put(S_CREATED, mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 51));
        parameters.put(S_UPDATED, mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 52));
        parameters.put(S_INVOICEDOCUMENT1, mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 55));
        parameters.put(S_ADDRESS, mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 57));
        parameters.put(S_DELIVERYADDRESS, mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 56));
        parameters.put(S_CONDITION, mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 58));
        parameters.put(S_QUANTITYAMOUNT, mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 59));
        parameters.put(S_QUANTITYUNIT, mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 60));
        parameters.put(S_TAXRATE, mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 61));
        parameters.put(S_AMOUNT, mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 62));
        parameters.put(S_DUEDATE, mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 63));
        parameters.put(S_NETAMOUNT, mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 64));
        parameters.put(S_GROSSAMOUNT1, mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 65));
        parameters.put(S_MESSAGE1, mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 66));
        parameters.put(S_MESSAGE2, mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 67));
        parameters.put(S_TOTAL, mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 68));
        if (ISoftware.getSpecialJournalPrintsForKronospanPL() && ISoftware.isKronospan() && this.mCompany.getJurisdictionType() == JurisdictionType.PL) {
            parameters.put(S_CARRYOVER, mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 70));
            parameters.put(S_CARRYFORWARD, mInvoiceOrCreditNoteTransactionReportList.getString((ILanguage)this.mLanguage, 69));
            String softwareName = this.configuration.getString(PROPKEY_SOFTWARENAME);
            if (StringMapper.isNullString((String)softwareName)) {
                softwareName = "Infor Global Financials";
            }
            parameters.put(P_RELEASE, (softwareName + " ").concat(Version.getVersion()));
        }
        LOGGER.debug("getParameters - OK");
        return parameters;
    }
}

