/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.invoiceorcreditnotetransaction;

import com.varial.accounting.domain.batch.Batch;
import com.varial.accounting.domain.custsupaddress.CustSupAddress;
import com.varial.accounting.domain.downpaymentrequestallocation.DownPaymentRequestAllocationHelper;
import com.varial.accounting.domain.financesetup.ConversionTableType;
import com.varial.accounting.domain.financesetup.ReAllocationOfReferenceNumberActionType;
import com.varial.accounting.domain.financialyear.AccountingCompany;
import com.varial.accounting.domain.financialyear.FinancialYear;
import com.varial.accounting.domain.invoiceorcreditnotetransaction.DiscountType;
import com.varial.accounting.domain.invoiceorcreditnotetransaction.DownPaymentRequestOpenItem;
import com.varial.accounting.domain.invoiceorcreditnotetransaction.DownPaymentRequestOpenItemPersistencyManager;
import com.varial.accounting.domain.invoiceorcreditnotetransaction.DownPaymentRequestPostingManager;
import com.varial.accounting.domain.invoiceorcreditnotetransaction.IInvoiceTransaction;
import com.varial.accounting.domain.invoiceorcreditnotetransaction.InvoiceTransactionData;
import com.varial.accounting.domain.invoiceorcreditnotetransaction.InvoiceTransactionHelper;
import com.varial.accounting.domain.invoiceorcreditnotetransaction.KsefNumberType;
import com.varial.accounting.domain.invoiceorcreditnotetransaction.PostBackDownPaymentRequestReasonEnum;
import com.varial.accounting.domain.invoiceorcreditnotetransaction.SetOpenDownPaymentRequestsToDoneMessageEnum;
import com.varial.accounting.domain.nominalledger.NLAccountCompanySetting;
import com.varial.accounting.domain.nominaltransactionbase.BankAccountEntry;
import com.varial.accounting.domain.nominaltransactionbase.BaseDifferenceEntry;
import com.varial.accounting.domain.nominaltransactionbase.EuVatNumberHelper;
import com.varial.accounting.domain.nominaltransactionbase.IEuVatNumber;
import com.varial.accounting.domain.nominaltransactionbase.NominalLedgerEntry;
import com.varial.accounting.domain.nominaltransactionbase.NominalTaxEntry;
import com.varial.accounting.domain.nominaltransactionbase.NominalTransactionBase;
import com.varial.accounting.domain.nominaltransactionbase.NominalTransactionBasePersistencyManager;
import com.varial.accounting.domain.nominaltransactionbase.PersonalAccountEntry;
import com.varial.accounting.domain.nominaltransactionbase.PrepaidTax;
import com.varial.accounting.domain.nominaltransactionbase.ProcessingStatus;
import com.varial.accounting.domain.nominaltransactionbase.TransactionExceptionMapper;
import com.varial.accounting.domain.nominaltransactionbase.cancellation.CancellationContext;
import com.varial.accounting.domain.openitem.IOpenItem;
import com.varial.accounting.domain.openitem.OpenItem;
import com.varial.accounting.domain.openitem.OpenItemDiscountManager;
import com.varial.accounting.domain.openitem.OpenItemPersistencyManager;
import com.varial.accounting.domain.openitem.OpenItemProcessingProgramType;
import com.varial.accounting.domain.openitem.OpenItemProcessingProgramTypeMapper;
import com.varial.accounting.domain.personalaccount.PersonalAccount;
import com.varial.accounting.domain.purchaseregister.PurchaseInvoiceRegisterStatus;
import com.varial.accounting.domain.termsofpayment.ITermOfPayment;
import com.varial.base.UtilitiesManager;
import com.varial.base.configuration.Configuration;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.types.date.DateHelper;
import com.varial.framework.domain.company.JurisdictionType;
import com.varial.framework.domain.isoftware.ISoftware;
import com.varial.framework.domain.jpkvat.IJPKVAT;
import com.varial.framework.domain.jpkvat.JPKVATPersistentUtils;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.mapper.StringMapper;
import com.varial.serverbase.persistency.IPersistentObject;
import com.varial.serverbase.persistency.PersistentObject;
import com.varial.serverbase.persistency.PersistentObjectUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;

public abstract class InvoiceTransaction
extends NominalTransactionBase
implements IInvoiceTransaction {
    private final Configuration configuration = (Configuration)UtilitiesManager.getBean((String)"com.infor.igf.configuration", Configuration.class);
    private PersonalAccountEntry mPersonalAccountEntry;
    private NominalLedgerEntry[] mNominalEntries;
    private NominalTaxEntry[] mTaxEntries;
    private InvoiceTransaction mPuraIvaTo;
    private DiscountType mDiscountType;
    private NominalLedgerEntry[] mEnteredEntries;
    private PersonalAccount mPersonalAccount;
    private boolean mNoNetBalance;
    private BigDecimal mTaxTotal;
    private BigDecimal mBaseTaxTotal;
    private ITermOfPayment mInstalmentTermOfPayment;
    private Date mDeliveryDate;
    private boolean mIsDownPaymentFinalInvoice;
    private PersonalAccountEntry[] mPrepaidPaEntries;
    private PrepaidTax[] mPrepaidTaxes;
    private NominalLedgerEntry[] mPrepaidTaxEntries;
    private DownPaymentRequestOpenItem[] mDownPaymentRequestOpenItems;
    private boolean mHasDownPaymentRequestOpenItems;
    private int mCurrentEntryNo = 0;
    private BigDecimal mDiscountPercent1 = null;
    private PostBackDownPaymentRequestReasonEnum mPostBackDownPaymentRequestReason = PostBackDownPaymentRequestReasonEnum.PBDPRR_UNKNOWN;
    private SetOpenDownPaymentRequestsToDoneMessageEnum mSetOpenDownPaymentRequestsToDoneMessage = SetOpenDownPaymentRequestsToDoneMessageEnum.NONE;
    private OpenItemProcessingProgramType mSetToDoneProcessingProgram = OpenItemProcessingProgramType.NONE;
    private IJPKVAT jpkVAT;
    private IJPKVAT jpkVAT_old;
    private boolean referenceNumberMustBeUnique = true;
    private boolean jpkVATMustBeFilled = true;
    private PersonalAccount mPersonalAccount_old;
    private String ksefNumber;
    private KsefNumberType ksefNumberType;
    private final String dateForKSeFNumber = "2026-02-01";

    public InvoiceTransaction(Batch batch, int transactionPersistencyType) throws BusinessDomainException {
        super(batch, transactionPersistencyType);
        this.ksefNumberType = KsefNumberType.NOT_SPECIFIED;
    }

    public InvoiceTransaction(AccountingCompany company, int transactionPersistencyType) {
        super(company, transactionPersistencyType);
    }

    public InvoiceTransaction(boolean readOnly, int transactionPersistencyType) {
        super(readOnly, transactionPersistencyType);
    }

    protected InvoiceTransaction(String objectid, int transactionPersistencyType) {
        super(objectid, transactionPersistencyType);
    }

    public InvoiceTransaction(String objectid, int version, int transactionPersistencyType) {
        super(objectid, version, transactionPersistencyType);
    }

    public InvoiceTransaction(String objectid, int version, Batch batch, int transactionPersistencyType) {
        super(objectid, version, batch, transactionPersistencyType);
    }

    protected InvoiceTransaction(InvoiceTransaction toCancel, CancellationContext cancellationContext) throws BusinessDomainException {
        super((NominalTransactionBase)toCancel, cancellationContext);
        this.setNoNetBalance(toCancel.getNoNetBalance());
        this.setPersonalAccount(toCancel.getPersonalAccount());
        this.setDiscountType(toCancel.getDiscountType());
        this.setDeliveryDate(toCancel.getDeliveryDate());
        this.setTaxTotal(BigDecimalMapper.negate((BigDecimal)toCancel.getTaxTotal()));
        this.setBaseTaxTotal(BigDecimalMapper.negate((BigDecimal)toCancel.getBaseTaxTotal()));
        this.setJpkVAT(toCancel.getJpkVAT());
        this.setKsefNumber(toCancel.getKsefNumber());
        this.setKsefNumberType(toCancel.getKsefNumberType());
        this.setPersonalAccountEntry(new PersonalAccountEntry(toCancel.getPersonalAccountEntry(), (NominalTransactionBase)this, cancellationContext));
        NominalLedgerEntry[] entries = new NominalLedgerEntry[toCancel.getNominalEntries().length];
        for (int i = 0; i < toCancel.getNominalEntries().length; ++i) {
            entries[i] = new NominalLedgerEntry(toCancel.getNominalEntries()[i], (NominalTransactionBase)this, cancellationContext);
        }
        this.setNominalEntries(entries);
        NominalTaxEntry[] taxEntries = new NominalTaxEntry[toCancel.getTaxEntries().length];
        for (int i = 0; i < toCancel.getTaxEntries().length; ++i) {
            taxEntries[i] = new NominalTaxEntry(toCancel.getTaxEntries()[i], (NominalTransactionBase)this, cancellationContext);
        }
        this.setTaxEntries(taxEntries);
        this.setIsDownPaymentFinalInvoice(toCancel.getIsDownPaymentFinalInvoice());
        this.setInstalmentTermOfPayment(toCancel.getInstalmentTermOfPayment());
        PersonalAccountEntry[] prepaidPaEntries = new PersonalAccountEntry[toCancel.getPrepaidPaEntries().length];
        for (int i = 0; i < prepaidPaEntries.length; ++i) {
            prepaidPaEntries[i] = new PersonalAccountEntry(toCancel.getPrepaidPaEntries()[i], (NominalTransactionBase)this, cancellationContext);
        }
        this.setPrepaidPaEntries(prepaidPaEntries);
        DownPaymentRequestPostingManager.resetInvoices((CancellationContext)cancellationContext, (DownPaymentRequestOpenItem[])toCancel.getDownPaymentRequestOpenItems());
        toCancel.setPostBackDownPaymentRequestReason(PostBackDownPaymentRequestReasonEnum.PBDPRR_REVERSING);
        toCancel.setDownPaymentRequestOpenItems(null);
        this.addToAccountBalance();
    }

    protected void destroyImpl() throws BusinessDomainException {
        if (this.getUseType() != null && this.getUseType().value() == 25 && !this.getIsAutomaticProcessing()) {
            throw TransactionExceptionMapper.makeInvoiceGeneratedDueToDownPaymentRequestCannotBeDeletedDomainException();
        }
        if (this.getDownPaymentRequestOpenItems() != null && this.getDownPaymentRequestOpenItems().length > 0) {
            DownPaymentRequestPostingManager.resetInvoices((CancellationContext)this.getCancellationContext(), (DownPaymentRequestOpenItem[])this.getDownPaymentRequestOpenItems());
            this.setPostBackDownPaymentRequestReason(PostBackDownPaymentRequestReasonEnum.PBDPRR_DELETING);
            for (int i = 0; i < this.getDownPaymentRequestOpenItems().length; ++i) {
                this.getDownPaymentRequestOpenItems()[i].makeSaveable();
                this.getDownPaymentRequestOpenItems()[i].destroy();
            }
        }
        super.destroyImpl();
    }

    public void setData(InvoiceTransactionData data) {
        this.mPuraIvaTo = data.getPuraIvaTo();
        this.mIsDownPaymentFinalInvoice = data.isDownPaymentFinalInvoice();
        this.mNoNetBalance = data.isNoNetBalance();
        this.mDiscountType = data.getDiscountType();
        this.mPersonalAccount = data.getPersonalAccount();
        this.mTaxTotal = data.getTaxTotal();
        this.mBaseTaxTotal = data.getBaseTaxTotal();
        this.mInstalmentTermOfPayment = data.getInstalmentTermOfPayment();
        this.mHasDownPaymentRequestOpenItems = data.hasDownPaymentRequestOpenItems();
        this.mDeliveryDate = data.getDeliveryDate();
        this.jpkVAT = data.getJpkVAT();
        this.jpkVAT_old = data.getJpkVAT();
        this.mPersonalAccount_old = data.getPersonalAccount();
        this.ksefNumber = data.getKsefNumber();
        this.ksefNumberType = data.getKsefNumberType();
    }

    public BigDecimal getCalculatedTotal() {
        BigDecimal result = this.getPersonalAccountEntry().getEnteredAmount();
        try {
            if (result.signum() == 0) {
                result = this.checkBalanced();
            }
            return result;
        }
        catch (BusinessDomainException e) {
            throw ExceptionMapper.makeApplicationException((Throwable)e);
        }
    }

    protected abstract void deleteCancellationTransaction() throws BusinessDomainException;

    protected abstract void createCancellationTransaction(CancellationContext var1) throws BusinessDomainException;

    protected void adjustOpenItems() throws BusinessDomainException {
        if (this.getReverseTransactionBase() != null) {
            return;
        }
        this.mPersonalAccountEntry.adjustInvoices();
        this.getPrepaidPaEntries();
        for (int i = 0; i < this.mPrepaidPaEntries.length; ++i) {
            this.mPrepaidPaEntries[i].adjustPrepaidOpenItems();
        }
    }

    protected void setDownPaymentRequestsToDone() throws BusinessDomainException {
        OpenItem[] downPaymentRequests;
        if (this.getIsUnfinished() || !this.getIsDownPaymentFinalInvoice()) {
            return;
        }
        if ((this.getPersonalAccountEntry().getPersonalAccount().isCustomer() && this.getPersonalAccountEntry().getIsDebit() && ISoftware.getSetOpenDownPaymentRequestsOfCustomersAutomaticallyToDoneWhenSavingFinalInvoice() || this.getPersonalAccountEntry().getPersonalAccount().isSupplier() && !this.getPersonalAccountEntry().getIsDebit() && ((Configuration)UtilitiesManager.getBean((String)"com.infor.igf.configuration", Configuration.class)).isEnabledSetOpenDownPaymentRequestsOfSuppliersAutomaticallyToDoneWhenSavingFinalInvoice()) && (downPaymentRequests = OpenItemPersistencyManager.getOpenDownPaymentRequests((PersonalAccount)this.getPersonalAccountEntry().getPersonalAccount())) != null && downPaymentRequests.length > 0) {
            int numberOfAllOpenDownPaymentRequests = 0;
            for (OpenItem openItem : downPaymentRequests) {
                if (!StringMapper.equalWithTrim((String)openItem.getProcessID(), (String)this.getProcessId())) continue;
                ++numberOfAllOpenDownPaymentRequests;
                List processingIn = OpenItemProcessingProgramTypeMapper.getProcessingProgramTypes((IOpenItem)openItem);
                if (!processingIn.isEmpty()) {
                    this.mSetToDoneProcessingProgram = (OpenItemProcessingProgramType)processingIn.get(0);
                    continue;
                }
                openItem.makeSaveable();
                DownPaymentRequestAllocationHelper.setDownPaymentRequestToDone((OpenItem)openItem, (boolean)false);
            }
            if (numberOfAllOpenDownPaymentRequests != 0) {
                this.mSetOpenDownPaymentRequestsToDoneMessage = this.mSetToDoneProcessingProgram == OpenItemProcessingProgramType.NONE ? SetOpenDownPaymentRequestsToDoneMessageEnum.ALL_SET_TO_DONE : SetOpenDownPaymentRequestsToDoneMessageEnum.NOT_SET_BECAUSE_OF_PROCESSING_PROGRAM;
            }
        }
    }

    protected void setContraAccounts() {
        int i;
        this.getPersonalAccountEntry();
        this.getNominalEntries();
        this.getTaxEntries();
        NLAccountCompanySetting contraNLAccount = null;
        if (!this.getIsDownPaymentFinalInvoice()) {
            if (this.mNominalEntries.length > 0) {
                contraNLAccount = this.mNominalEntries[0].getAccount();
            } else if (this.mTaxEntries.length > 0) {
                contraNLAccount = this.mTaxEntries[0].getAccount();
            }
        }
        for (i = 0; i < this.mNominalEntries.length; ++i) {
            if (contraNLAccount != null && !contraNLAccount.equals((Object)this.mNominalEntries[i].getAccount())) {
                contraNLAccount = null;
            }
            this.mNominalEntries[i].setContraPersonalAccount(this.mPersonalAccountEntry.getPersonalAccount());
            this.mNominalEntries[i].setContraOneOffAddress(this.mPersonalAccountEntry.getOneOffAddressFromOpenItem());
            this.mNominalEntries[i].setContraNLAccount(this.mPersonalAccountEntry.getAccount());
        }
        for (i = 0; i < this.mTaxEntries.length; ++i) {
            if (contraNLAccount != null && this.mNominalEntries.length == 0 && !contraNLAccount.equals((Object)this.mTaxEntries[i].getAccount())) {
                contraNLAccount = null;
            }
            this.mTaxEntries[i].setContraPersonalAccount(this.mPersonalAccountEntry.getPersonalAccount());
            this.mTaxEntries[i].setContraOneOffAddress(this.mPersonalAccountEntry.getOneOffAddressFromOpenItem());
            this.mTaxEntries[i].setContraNLAccount(this.mPersonalAccountEntry.getAccount());
        }
        this.mPersonalAccountEntry.setContraNLAccount(contraNLAccount);
        if (this.getBaseDifferenceEntry() != null) {
            this.getBaseDifferenceEntry().setContraPersonalAccount(this.mPersonalAccountEntry.getPersonalAccount());
            this.getBaseDifferenceEntry().setContraOneOffAddress(this.mPersonalAccountEntry.getOneOffAddressFromOpenItem());
            this.getBaseDifferenceEntry().setContraNLAccount(this.mPersonalAccountEntry.getAccount());
        }
        this.getPrepaidPaEntries();
        for (i = 0; i < this.mPrepaidPaEntries.length; ++i) {
            NominalTaxEntry[] prepaidTaxEntries;
            NominalLedgerEntry[] prepaidNLEntries;
            PrepaidTax prepaidTax = this.mPrepaidPaEntries[i].getPrepaidTax();
            if (prepaidTax == null) continue;
            for (NominalLedgerEntry prepaidNLEntry : prepaidNLEntries = prepaidTax.getNominalEntries()) {
                prepaidNLEntry.setContraPersonalAccount(this.mPersonalAccountEntry.getPersonalAccount());
                prepaidNLEntry.setContraOneOffAddress(this.mPersonalAccountEntry.getOneOffAddressFromOpenItem());
                prepaidNLEntry.setContraNLAccount(this.mPersonalAccountEntry.getAccount());
            }
            for (NominalTaxEntry prepaidTaxEntry : prepaidTaxEntries = prepaidTax.getTaxEntries()) {
                prepaidTaxEntry.setContraPersonalAccount(this.mPersonalAccountEntry.getPersonalAccount());
                prepaidTaxEntry.setContraOneOffAddress(this.mPersonalAccountEntry.getOneOffAddressFromOpenItem());
                prepaidTaxEntry.setContraNLAccount(this.mPersonalAccountEntry.getAccount());
            }
        }
    }

    protected void setEuVatNumber() throws BusinessDomainException {
        IEuVatNumber euVatNumber;
        int i;
        this.getNominalEntries();
        this.getTaxEntries();
        for (i = 0; i < this.mNominalEntries.length; ++i) {
            euVatNumber = EuVatNumberHelper.getEUVATNumber((NominalLedgerEntry)this.mNominalEntries[i]);
            this.mNominalEntries[i].setEuVatNumber(euVatNumber);
        }
        for (i = 0; i < this.mTaxEntries.length; ++i) {
            euVatNumber = EuVatNumberHelper.getEUVATNumber((NominalLedgerEntry)this.mTaxEntries[i]);
            this.mTaxEntries[i].setEuVatNumber(euVatNumber);
        }
        this.getPrepaidPaEntries();
        for (i = 0; i < this.mPrepaidPaEntries.length; ++i) {
            NominalTaxEntry[] prepaidTaxEntries;
            PrepaidTax prepaidTax = this.mPrepaidPaEntries[i].getPrepaidTax();
            if (prepaidTax == null) continue;
            for (NominalTaxEntry prepaidTaxEntry : prepaidTaxEntries = prepaidTax.getTaxEntries()) {
                IEuVatNumber euVatNumber2 = EuVatNumberHelper.getEUVATNumber((NominalLedgerEntry)prepaidTaxEntry);
                prepaidTaxEntry.setEuVatNumber(euVatNumber2);
            }
        }
    }

    protected void setNoNetBalance() {
        NominalLedgerEntry[] entries = this.getNominalEntries();
        for (int i = 0; i < entries.length; ++i) {
            if (this.getNoNetBalance()) {
                entries[i].setNoNetBalance(true);
                continue;
            }
            entries[i].setNoNetBalance(entries[i].getAccount().getNoNetBalance());
        }
        boolean allEntriesHasNoNetbalance = true;
        for (int i = 0; i < entries.length; ++i) {
            if (entries[i].getNoNetBalance()) continue;
            allEntriesHasNoNetbalance = false;
        }
        if (entries.length > 0 && allEntriesHasNoNetbalance) {
            this.setNoNetBalance(true);
        }
        this.getPersonalAccountEntry().setNoNetBalance(this.getNoNetBalance());
    }

    public PersonalAccount getPersonalAccount() {
        this.requireLoaded();
        if (this.mPersonalAccount == null) {
            this.mPersonalAccount = this.getPersonalAccountEntry().getPersonalAccount();
        }
        return this.mPersonalAccount;
    }

    public void setPersonalAccount(PersonalAccount personalAccount) {
        this.mPersonalAccount = personalAccount;
    }

    public BigDecimal getTaxTotal() {
        this.requireLoaded();
        return this.mTaxTotal;
    }

    protected void setTaxTotal(BigDecimal taxTotal) {
        this.mTaxTotal = taxTotal;
    }

    public BigDecimal getBaseTaxTotal() {
        this.requireLoaded();
        return this.mBaseTaxTotal;
    }

    protected void setBaseTaxTotal(BigDecimal baseTaxTotal) {
        this.mBaseTaxTotal = baseTaxTotal;
    }

    public ITermOfPayment getInstalmentTermOfPayment() {
        this.requireLoaded();
        return this.mInstalmentTermOfPayment;
    }

    public void setInstalmentTermOfPayment(ITermOfPayment instalmentTermOfPayment) {
        this.mInstalmentTermOfPayment = instalmentTermOfPayment;
    }

    protected boolean getHasReconciledItem() {
        return false;
    }

    protected boolean getHasAllocatedItem() {
        return this.getPersonalAccountEntry() != null && this.getPersonalAccountEntry().hasAllocatedOpenItem();
    }

    protected boolean getHasAllocatedDownPaymentItem() {
        PersonalAccountEntry[] prepaidPaEntries = this.getPrepaidPaEntries();
        return prepaidPaEntries != null && prepaidPaEntries.length > 0;
    }

    protected boolean getHasItemIncludedInPaymentSession() {
        return this.getPersonalAccountEntry() != null && this.getPersonalAccountEntry().hasOpenItemIncludedInPaymentSession();
    }

    protected boolean getHasItemIncludedInInstalment() {
        return this.getPersonalAccountEntry() != null && this.getPersonalAccountEntry().hasOpenItemIncludedInInstalment();
    }

    public InvoiceTransaction getPuraIvaTo() {
        this.requireLoaded();
        return this.mPuraIvaTo;
    }

    public void setPuraIvaTo(InvoiceTransaction puraIvaTo) {
        this.protocol("puraivato", (IPersistentObject)this.mPuraIvaTo, (IPersistentObject)puraIvaTo);
        this.mPuraIvaTo = puraIvaTo;
    }

    public DiscountType getDiscountType() {
        this.requireLoaded();
        if (this.mDiscountType == null) {
            this.mDiscountType = InvoiceTransactionHelper.getDiscountType((NominalTransactionBase)this);
        }
        return this.mDiscountType;
    }

    public void setDiscountType(DiscountType discountType) {
        this.mDiscountType = discountType;
    }

    public abstract NominalTransactionBase getReverseTransactionBase();

    public NominalLedgerEntry[] getAllEnteredEntries() {
        if (this.mEnteredEntries == null) {
            if (!this.isNew()) {
                this.loadEntries();
            }
            if (this.mEnteredEntries == null) {
                this.mEnteredEntries = new NominalLedgerEntry[0];
            }
        }
        return this.mEnteredEntries;
    }

    public NominalLedgerEntry[] getSortedAllEnteredEntries() {
        if (this.mEnteredEntries == null) {
            if (!this.isNew()) {
                this.loadEntries();
            }
            if (this.mEnteredEntries == null) {
                this.mEnteredEntries = new NominalLedgerEntry[0];
            }
        }
        return this.getSortedEnteredEntries();
    }

    private NominalLedgerEntry[] getSortedEnteredEntries() {
        LinkedList<Object> enteredEntries = new LinkedList<Object>();
        if (this.mPersonalAccountEntry != null) {
            enteredEntries.add(this.mPersonalAccountEntry);
        }
        if (this.mNominalEntries != null && this.mNominalEntries.length != 0) {
            enteredEntries.addAll(Arrays.asList(this.getSortedNominalEntries()));
        }
        if (this.mTaxEntries != null && this.mTaxEntries.length != 0) {
            enteredEntries.addAll(Arrays.asList(this.getSortedTaxEntries()));
        }
        if (this.mPrepaidPaEntries != null && this.mPrepaidPaEntries.length != 0) {
            enteredEntries.addAll(Arrays.asList(this.mPrepaidPaEntries));
            if (this.mPrepaidTaxEntries != null && this.mPrepaidTaxEntries.length != 0) {
                enteredEntries.addAll(Arrays.asList(this.mPrepaidTaxEntries));
            }
        }
        return enteredEntries.toArray(new NominalLedgerEntry[0]);
    }

    public boolean getIsDownPaymentFinalInvoice() {
        this.requireLoaded();
        return this.mIsDownPaymentFinalInvoice;
    }

    public void setIsDownPaymentFinalInvoice(boolean isDownPaymentFinalInvoice) {
        this.protocol("isdownpaymentfinalinvoice", this.mIsDownPaymentFinalInvoice, isDownPaymentFinalInvoice);
        this.mIsDownPaymentFinalInvoice = isDownPaymentFinalInvoice;
    }

    public boolean getNoNetBalance() {
        this.requireLoaded();
        return this.mNoNetBalance;
    }

    public void setNoNetBalance(boolean noNetBalance) {
        this.protocol("nonetbalance", this.mNoNetBalance, noNetBalance);
        this.mNoNetBalance = noNetBalance;
    }

    public PersonalAccountEntry getPersonalAccountEntry() {
        this.loadEntries();
        return this.mPersonalAccountEntry;
    }

    public void setPersonalAccountEntry(PersonalAccountEntry personalAccountEntry) {
        if (personalAccountEntry == null) {
            throw ExceptionMapper.makeApplicationException((String)"InvoiceTransaction.setPersonalAccountEntry: PersonalAccountEntry is null");
        }
        this.getPersonalAccountEntry();
        if (!this.isNew() && !PersistentObjectUtils.haveEqualObjectids((IPersistentObject)personalAccountEntry, (IPersistentObject)this.mPersonalAccountEntry)) {
            throw ExceptionMapper.makeApplicationException((String)"InvoiceTransaction.setPersonalAccountEntry: wrong personalaccount entry for transaction");
        }
        this.mPersonalAccountEntry = personalAccountEntry;
        this.mPersonalAccountEntry.setEntryNumber(0);
        this.adjustEnteredEntries();
    }

    public NominalLedgerEntry[] getNominalEntries() {
        if (this.mNominalEntries == null) {
            if (!this.isNew()) {
                this.loadEntries();
            }
            if (this.mNominalEntries == null) {
                this.mNominalEntries = new NominalLedgerEntry[0];
            }
        }
        return this.mNominalEntries;
    }

    public void setNominalEntries(NominalLedgerEntry[] nominalEntries) throws BusinessDomainException {
        if (!this.isNew() && !PersistentObjectUtils.equalDetailObjects((PersistentObject[])this.getNominalEntries(), (PersistentObject[])nominalEntries)) {
            this.checkIfAmendingAllowed(new ProcessingStatus.TransactionStatusType[]{ProcessingStatus.TransactionStatusType.JOURNALISED, ProcessingStatus.TransactionStatusType.CANCELLATION, ProcessingStatus.TransactionStatusType.CREATED_VAT_RETURN, ProcessingStatus.TransactionStatusType.CREATED_EC_SALES_LIST, ProcessingStatus.TransactionStatusType.HAS_ALLOCATED_ITEM});
        }
        for (int i = 0; i < nominalEntries.length; ++i) {
            nominalEntries[i].setEntryNumber(this.getNextEntryNo());
        }
        List changed = PersistentObjectUtils.removeUnusedObjects((IPersistentObject[])this.getNominalEntries(), (IPersistentObject[])nominalEntries);
        this.mNominalEntries = new NominalLedgerEntry[changed.size()];
        this.mNominalEntries = changed.toArray(this.mNominalEntries);
        this.adjustEnteredEntries();
    }

    public NominalTaxEntry[] getTaxEntries() {
        if (this.mTaxEntries == null) {
            if (!this.isNew()) {
                this.loadEntries();
            }
            if (this.mTaxEntries == null) {
                this.mTaxEntries = new NominalTaxEntry[0];
            }
        }
        return this.mTaxEntries;
    }

    public void setTaxEntries(NominalTaxEntry[] taxEntries) throws BusinessDomainException {
        if (!this.isNew() && !PersistentObjectUtils.equalDetailObjects((PersistentObject[])this.getTaxEntries(), (PersistentObject[])taxEntries)) {
            this.checkIfAmendingAllowed(new ProcessingStatus.TransactionStatusType[]{ProcessingStatus.TransactionStatusType.JOURNALISED, ProcessingStatus.TransactionStatusType.CANCELLATION, ProcessingStatus.TransactionStatusType.CREATED_VAT_RETURN, ProcessingStatus.TransactionStatusType.CREATED_EC_SALES_LIST, ProcessingStatus.TransactionStatusType.HAS_ALLOCATED_ITEM, ProcessingStatus.TransactionStatusType.HAS_OPEN_ITEM_PAID_BY_SPLIT_PAYMENT});
        }
        for (int i = 0; i < taxEntries.length; ++i) {
            taxEntries[i].setEntryNumber(this.getNextEntryNo());
        }
        List changed = PersistentObjectUtils.removeUnusedObjects((IPersistentObject[])this.getTaxEntries(), (IPersistentObject[])taxEntries);
        this.mTaxEntries = new NominalTaxEntry[changed.size()];
        this.mTaxEntries = changed.toArray(this.mTaxEntries);
        this.adjustEnteredEntries();
    }

    public PersonalAccountEntry[] getPrepaidPaEntries() {
        if (this.mPrepaidPaEntries == null) {
            if (!this.isNew()) {
                this.loadEntries();
            }
            if (this.mPrepaidPaEntries == null) {
                this.mPrepaidPaEntries = new PersonalAccountEntry[0];
            }
        }
        return this.mPrepaidPaEntries;
    }

    public void setPrepaidPaEntries(PersonalAccountEntry[] prepaidPaEntries) throws BusinessDomainException {
        if (!this.isNew() && !PersistentObjectUtils.equalDetailObjects((PersistentObject[])this.getPrepaidPaEntries(), (PersistentObject[])prepaidPaEntries)) {
            this.checkIfAmendingAllowed(new ProcessingStatus.TransactionStatusType[]{ProcessingStatus.TransactionStatusType.JOURNALISED, ProcessingStatus.TransactionStatusType.CANCELLATION, ProcessingStatus.TransactionStatusType.CREATED_EC_SALES_LIST});
        }
        LinkedList<PrepaidTax> prepaidTaxesList = new LinkedList<PrepaidTax>();
        if (prepaidPaEntries == null) {
            prepaidPaEntries = new PersonalAccountEntry[]{};
        }
        for (int i = 0; i < prepaidPaEntries.length; ++i) {
            prepaidPaEntries[i].setEntryNumber(this.getNextEntryNo());
            PrepaidTax prepaidTax = prepaidPaEntries[i].getPrepaidTax();
            if (prepaidTax == null) continue;
            prepaidTaxesList.add(prepaidTax);
        }
        List changed = PersistentObjectUtils.removeUnusedObjects((IPersistentObject[])this.getPrepaidPaEntries(), (IPersistentObject[])prepaidPaEntries);
        this.mPrepaidPaEntries = new PersonalAccountEntry[changed.size()];
        this.mPrepaidPaEntries = changed.toArray(this.mPrepaidPaEntries);
        LinkedList<Object> prepaidTaxes = new LinkedList<Object>();
        for (int i = 0; i < this.mPrepaidPaEntries.length; ++i) {
            PrepaidTax prepaidTax = this.mPrepaidPaEntries[i].getPrepaidTax();
            if (prepaidTax == null) continue;
            prepaidTaxes.add(prepaidTax.getNominalEntry());
            prepaidTaxes.add(prepaidTax.getTaxEntry());
            if (prepaidTax.getAdditionalNominalEntry() == null) continue;
            prepaidTaxes.add(prepaidTax.getAdditionalNominalEntry());
            prepaidTaxes.add(prepaidTax.getAdditionalTaxEntry());
        }
        NominalLedgerEntry[] prepaidTaxEntries = new NominalLedgerEntry[prepaidTaxes.size()];
        prepaidTaxes.toArray(prepaidTaxEntries);
        List changed2 = PersistentObjectUtils.removeUnusedObjects((IPersistentObject[])this.getPrepaidTaxEntries(), (IPersistentObject[])prepaidTaxEntries);
        this.mPrepaidTaxEntries = new NominalLedgerEntry[changed2.size()];
        this.mPrepaidTaxEntries = changed2.toArray(this.mPrepaidTaxEntries);
        this.mPrepaidTaxes = new PrepaidTax[prepaidTaxesList.size()];
        prepaidTaxesList.toArray(this.mPrepaidTaxes);
        this.adjustEnteredEntries();
    }

    public PrepaidTax[] getPrepaidTaxes() {
        if (this.mPrepaidTaxes == null) {
            this.getPrepaidPaEntries();
            LinkedList<PrepaidTax> prepaidTaxes = new LinkedList<PrepaidTax>();
            for (int i = 0; i < this.mPrepaidPaEntries.length; ++i) {
                PrepaidTax prepaidTax = this.mPrepaidPaEntries[i].getPrepaidTax();
                if (prepaidTax == null) continue;
                prepaidTaxes.add(prepaidTax);
            }
            this.mPrepaidTaxes = new PrepaidTax[prepaidTaxes.size()];
            prepaidTaxes.toArray(this.mPrepaidTaxes);
        }
        return this.mPrepaidTaxes;
    }

    public NominalLedgerEntry[] getPrepaidTaxEntries() {
        if (this.mPrepaidTaxEntries == null) {
            if (!this.isNew()) {
                this.loadEntries();
            }
            if (this.mPrepaidTaxEntries == null) {
                this.mPrepaidTaxEntries = new NominalLedgerEntry[0];
            }
        }
        return this.mPrepaidTaxEntries;
    }

    private void loadEntries() {
        if (!this.mLoadedEntries) {
            NominalLedgerEntry[] entries = NominalLedgerEntry.getEntries((NominalTransactionBase)this);
            this.setLoadedEntries(entries);
        }
    }

    public void setLoadedEntries(NominalLedgerEntry[] entries) {
        LinkedList<NominalLedgerEntry> nominalEntries = new LinkedList<NominalLedgerEntry>();
        LinkedList<NominalTaxEntry> taxEntries = new LinkedList<NominalTaxEntry>();
        LinkedList<NominalLedgerEntry> prepaidPersonalAccountEntries = new LinkedList<NominalLedgerEntry>();
        LinkedList<PrepaidTax> prepaidTaxes = new LinkedList<PrepaidTax>();
        LinkedList<Object> prepaidTaxEntries = new LinkedList<Object>();
        for (NominalLedgerEntry entry : entries) {
            if (entry instanceof PersonalAccountEntry) {
                if (entry.getIsDownPayment()) {
                    prepaidPersonalAccountEntries.add(entry);
                    PrepaidTax prepaidTax = ((PersonalAccountEntry)entry).getPrepaidTax();
                    if (prepaidTax == null) continue;
                    prepaidTaxes.add(prepaidTax);
                    prepaidTaxEntries.add(prepaidTax.getNominalEntry());
                    prepaidTaxEntries.add(prepaidTax.getTaxEntry());
                    if (prepaidTax.getAdditionalNominalEntry() == null) continue;
                    prepaidTaxEntries.add(prepaidTax.getAdditionalNominalEntry());
                    prepaidTaxEntries.add(prepaidTax.getAdditionalTaxEntry());
                    continue;
                }
                this.mPersonalAccountEntry = (PersonalAccountEntry)entry;
                continue;
            }
            if (entry instanceof NominalTaxEntry) {
                if (entry.getIsDownPayment()) continue;
                taxEntries.add((NominalTaxEntry)entry);
                continue;
            }
            if (entry instanceof BaseDifferenceEntry) {
                this.mBaseDifferenceEntry = (BaseDifferenceEntry)entry;
                continue;
            }
            if (entry.getIsDownPayment()) continue;
            nominalEntries.add(entry);
        }
        this.mNominalEntries = new NominalLedgerEntry[nominalEntries.size()];
        nominalEntries.toArray(this.mNominalEntries);
        this.mTaxEntries = new NominalTaxEntry[taxEntries.size()];
        taxEntries.toArray(this.mTaxEntries);
        this.mPrepaidPaEntries = new PersonalAccountEntry[prepaidPersonalAccountEntries.size()];
        prepaidPersonalAccountEntries.toArray(this.mPrepaidPaEntries);
        this.mPrepaidTaxes = new PrepaidTax[prepaidTaxes.size()];
        prepaidTaxes.toArray(this.mPrepaidTaxes);
        this.mPrepaidTaxEntries = new NominalLedgerEntry[prepaidTaxEntries.size()];
        prepaidTaxEntries.toArray(this.mPrepaidTaxEntries);
        this.adjustEnteredEntries();
        this.mLoadedEntries = true;
    }

    private void adjustEnteredEntries() {
        LinkedList<Object> enteredEntries = new LinkedList<Object>();
        if (this.mPersonalAccountEntry != null) {
            enteredEntries.add(this.mPersonalAccountEntry);
        }
        if (this.mNominalEntries != null && this.mNominalEntries.length != 0) {
            enteredEntries.addAll(Arrays.asList(this.mNominalEntries));
        }
        if (this.mTaxEntries != null && this.mTaxEntries.length != 0) {
            enteredEntries.addAll(Arrays.asList(this.mTaxEntries));
        }
        if (this.mPrepaidPaEntries != null && this.mPrepaidPaEntries.length != 0) {
            enteredEntries.addAll(Arrays.asList(this.mPrepaidPaEntries));
            if (this.mPrepaidTaxEntries != null && this.mPrepaidTaxEntries.length != 0) {
                enteredEntries.addAll(Arrays.asList(this.mPrepaidTaxEntries));
            }
        }
        this.mEnteredEntries = new NominalLedgerEntry[enteredEntries.size()];
        this.mEnteredEntries = enteredEntries.toArray(this.mEnteredEntries);
    }

    protected void checkFinishedTransaction() throws BusinessDomainException {
        this.checkTotal();
        this.checkForeignCurrencyRate();
        this.checkTransactionDate();
        this.checkDocumentDate();
        this.checkReferenceNumber();
        if (JurisdictionType.PL.equals((Object)this.getCompany().getJurisdictionType())) {
            this.checkKsefNumber();
        }
        this.checkPersonalAccountAndVoucherType();
        this.checkBalanced();
        if (this.isInvoiceReceivableTransaction()) {
            this.checkCurrencyTolerance(ConversionTableType.SALESINVOICE);
        } else {
            this.checkCurrencyTolerance(ConversionTableType.PURCHASEINVOICE);
        }
        this.checkTaxes();
        this.checkTaxDate();
        this.checkCostingForEntries();
        this.checkDownPaymentFinalInvoice();
        this.mPersonalAccountEntry.checkOpenItems();
    }

    private void checkDownPaymentFinalInvoice() throws BusinessDomainException {
        if (!this.getIsDownPaymentFinalInvoice()) {
            return;
        }
        if (StringMapper.isNullString((String)this.getProcessId())) {
            throw TransactionExceptionMapper.makeDownPaymentProcessidMissingDomainException();
        }
        if (this.mPrepaidPaEntries != null) {
            for (int i = 0; i < this.mPrepaidPaEntries.length; ++i) {
                this.mPrepaidPaEntries[i].checkPrepaidPaEntry();
            }
        }
    }

    protected BigDecimal checkBalanced() throws BusinessDomainException {
        if (!(this.getNominalEntries() != null && this.getNominalEntries().length != 0 || this.getTaxEntries() != null && this.getTaxEntries().length != 0 || this.getPrepaidPaEntries() != null && this.getPrepaidPaEntries().length != 0)) {
            throw TransactionExceptionMapper.makeNotBalancedDomainException();
        }
        return super.checkBalanced();
    }

    protected abstract void checkPersonalAccountAndVoucherType() throws BusinessDomainException;

    private void checkTotal() throws BusinessDomainException {
        if (this.getPersonalAccountEntry().getEnteredAmount().compareTo(this.getTotal()) != 0) {
            throw TransactionExceptionMapper.makeWrongInvoiceTotalDomainException();
        }
    }

    private int getNextEntryNo() {
        ++this.mCurrentEntryNo;
        return this.mCurrentEntryNo;
    }

    public boolean getUseNotDueTaxAccount() {
        return true;
    }

    public BigDecimal getDiscountPercent1() {
        if (this.mDiscountPercent1 == null) {
            this.mDiscountPercent1 = BigDecimalMapper.ZERO;
            OpenItem[] openItems = this.getPersonalAccountEntry().getOpenItems();
            BigDecimal total = this.getPersonalAccountEntry().getEnteredAmount();
            for (int i = 0; i < openItems.length; ++i) {
                BigDecimal discountPercent = OpenItemDiscountManager.getFirstPercentDiscount((OpenItem)openItems[i]);
                BigDecimal originalAmount = openItems[i].getOriginalAmount();
                if (!BigDecimalMapper.isZeroOrNull((BigDecimal)discountPercent) && originalAmount != null && !BigDecimalMapper.isZeroOrNull((BigDecimal)total)) {
                    discountPercent = originalAmount.multiply(discountPercent).divide(total, 9, RoundingMode.HALF_UP);
                }
                if (BigDecimalMapper.isZeroOrNull((BigDecimal)discountPercent)) continue;
                this.mDiscountPercent1 = this.mDiscountPercent1.add(discountPercent);
            }
        }
        return this.mDiscountPercent1;
    }

    public BigDecimal makeBaseTotal() {
        return this.getPersonalAccountEntry().getBaseAmount();
    }

    public boolean getNegativePostingsAllowed() {
        return this.getJurisdiction().getAllowNegativePostings();
    }

    public boolean getIsForeignPersonalAccount() throws BusinessDomainException {
        CustSupAddress address = this.getPersonalAccountEntry().getCustSupAddress();
        return address.getPostalAddress() != null && address.getPostalAddress().getCountry() != null && !address.getPostalAddress().getCountry().equals(this.getOwnCountry());
    }

    public boolean getIsInterestInvoice() {
        OpenItem[] openItems = this.getPersonalAccountEntry().getOpenItems();
        return openItems != null && openItems.length > 0 ? openItems[0].isInterestOpenItem() : false;
    }

    public DownPaymentRequestOpenItem[] getDownPaymentRequestOpenItems() {
        if (this.mDownPaymentRequestOpenItems == null) {
            if (!this.isNew()) {
                this.mDownPaymentRequestOpenItems = DownPaymentRequestOpenItemPersistencyManager.getDownPaymentRequestOpenItems((InvoiceTransaction)this);
            }
            if (this.mDownPaymentRequestOpenItems == null) {
                this.mDownPaymentRequestOpenItems = new DownPaymentRequestOpenItem[0];
            }
        }
        return this.mDownPaymentRequestOpenItems;
    }

    public void setDownPaymentRequestOpenItems(DownPaymentRequestOpenItem[] downPaymentRequestOpenItems) throws BusinessDomainException {
        List changed = PersistentObjectUtils.removeUnusedObjects((IPersistentObject[])this.getDownPaymentRequestOpenItems(), (IPersistentObject[])downPaymentRequestOpenItems);
        this.mDownPaymentRequestOpenItems = new DownPaymentRequestOpenItem[changed.size()];
        changed.toArray(this.mDownPaymentRequestOpenItems);
        for (int i = 0; i < this.mDownPaymentRequestOpenItems.length; ++i) {
            this.mDownPaymentRequestOpenItems[i].setSortNo(i);
        }
        this.setHasDownPaymentRequestOpenItems(this.mDownPaymentRequestOpenItems.length > 0);
    }

    public void setDownPaymentRequests(OpenItem[] downPaymentRequests, Date transactionDate, FinancialYear financialYear) throws BusinessDomainException {
        DownPaymentRequestOpenItem[] downPaymentRequestOpenItems;
        if (this.isNew()) {
            downPaymentRequestOpenItems = DownPaymentRequestPostingManager.postDownPaymentRequests((InvoiceTransaction)this, (Date)transactionDate, (FinancialYear)financialYear, (OpenItem[])downPaymentRequests);
        } else {
            int i;
            DownPaymentRequestOpenItem[] oldDownPaymentRequestOpenItems = this.getDownPaymentRequestOpenItems();
            HashMap<String, DownPaymentRequestOpenItem> oldMap = new HashMap<String, DownPaymentRequestOpenItem>();
            for (int i2 = 0; i2 < oldDownPaymentRequestOpenItems.length; ++i2) {
                oldMap.put(oldDownPaymentRequestOpenItems[i2].getDownPaymentRequest().getObjectid(), oldDownPaymentRequestOpenItems[i2]);
            }
            ArrayList<DownPaymentRequestOpenItem> keepList = new ArrayList<DownPaymentRequestOpenItem>();
            ArrayList<OpenItem> newList = new ArrayList<OpenItem>();
            if (downPaymentRequests != null) {
                for (int i3 = 0; i3 < downPaymentRequests.length; ++i3) {
                    String oidDownPaymentRequest = downPaymentRequests[i3].getObjectid();
                    DownPaymentRequestOpenItem downPaymentRequestOpenItem = (DownPaymentRequestOpenItem)oldMap.get(oidDownPaymentRequest);
                    if (downPaymentRequestOpenItem == null) {
                        newList.add(downPaymentRequests[i3]);
                        continue;
                    }
                    keepList.add(downPaymentRequestOpenItem);
                    oldMap.remove(oidDownPaymentRequest);
                }
            }
            Collection c = oldMap.values();
            DownPaymentRequestOpenItem[] deleteList = new DownPaymentRequestOpenItem[c.size()];
            c.toArray(deleteList);
            DownPaymentRequestPostingManager.resetInvoices((CancellationContext)this.getCancellationContext(), (DownPaymentRequestOpenItem[])deleteList);
            OpenItem[] newDownPaymentRequests = new OpenItem[newList.size()];
            newList.toArray(newDownPaymentRequests);
            DownPaymentRequestOpenItem[] newDownPaymentRequestOpenItems = DownPaymentRequestPostingManager.postDownPaymentRequests((InvoiceTransaction)this, (Date)transactionDate, (FinancialYear)financialYear, (OpenItem[])newDownPaymentRequests);
            int length = newDownPaymentRequestOpenItems.length + keepList.size();
            downPaymentRequestOpenItems = new DownPaymentRequestOpenItem[length];
            for (i = 0; i < keepList.size(); ++i) {
                downPaymentRequestOpenItems[i] = (DownPaymentRequestOpenItem)keepList.get(i);
                InvoiceTransaction invoice = downPaymentRequestOpenItems[i].getInvoiceTransaction();
                if (invoice == null) continue;
                if (!DateHelper.equal((Date)invoice.getTransactionDate(), (Date)transactionDate)) {
                    invoice.makeSaveable();
                    invoice.setTransactionDate(transactionDate);
                }
                if (invoice.getFinancialYear().equals((Object)financialYear)) continue;
                invoice.makeSaveable();
                invoice.setFinancialYear(financialYear);
            }
            while (i < length) {
                downPaymentRequestOpenItems[i] = newDownPaymentRequestOpenItems[i - keepList.size()];
                ++i;
            }
            this.setPostBackDownPaymentRequestReason(PostBackDownPaymentRequestReasonEnum.PBDPRR_REMOVING);
        }
        this.setDownPaymentRequestOpenItems(downPaymentRequestOpenItems);
    }

    public boolean getHasDownPaymentRequestOpenItems() {
        this.requireLoaded();
        return this.mHasDownPaymentRequestOpenItems;
    }

    private void setHasDownPaymentRequestOpenItems(boolean hasDownPaymentRequestOpenItems) {
        this.mHasDownPaymentRequestOpenItems = hasDownPaymentRequestOpenItems;
    }

    public PostBackDownPaymentRequestReasonEnum getPostBackDownPaymentRequestReason() {
        return this.mPostBackDownPaymentRequestReason;
    }

    public void setPostBackDownPaymentRequestReason(PostBackDownPaymentRequestReasonEnum reason) {
        this.mPostBackDownPaymentRequestReason = reason;
    }

    public boolean isInvoiceTransaction() {
        return true;
    }

    public boolean getIsDownPaymentCreditNote() {
        return this.getUseType() != null && this.getUseType().value() == 26;
    }

    public boolean getIsDownPaymentInvoice() {
        return this.getUseType() != null && this.getUseType().value() == 25;
    }

    public void setPurchaseInvoiceRegisterStatus(PurchaseInvoiceRegisterStatus purchaseInvoiceRegisterStatus) {
        PersonalAccountEntry personalAccountEntry = this.getPersonalAccountEntry();
        if (personalAccountEntry == null) {
            return;
        }
        OpenItem[] openItems = personalAccountEntry.getOpenItems();
        if (openItems != null) {
            for (OpenItem openItem : openItems) {
                openItem.makeSaveable();
                openItem.setPurchaseInvoiceRegisterStatus(purchaseInvoiceRegisterStatus);
            }
        }
    }

    public SetOpenDownPaymentRequestsToDoneMessageEnum getSetOpenDownPaymentRequestsToDoneMessage() {
        return this.mSetOpenDownPaymentRequestsToDoneMessage;
    }

    public OpenItemProcessingProgramType getSetToDoneProcessingProgram() {
        return this.mSetToDoneProcessingProgram;
    }

    public BankAccountEntry[] getBankAccountEntries() {
        return new BankAccountEntry[0];
    }

    public void setCreatorId(String creatorId) {
        this.mCreatorID = creatorId;
    }

    protected boolean getHasOpenItemPaidBySplitPayment() {
        if (this.getTaxEntries() == null || this.getTaxEntries().length == 0) {
            return false;
        }
        for (NominalTaxEntry nominalTaxEntry : this.getTaxEntries()) {
            if (nominalTaxEntry.getSplitPayments() == null || nominalTaxEntry.getSplitPayments().size() <= 0) continue;
            return true;
        }
        return false;
    }

    public Date getDeliveryDate() {
        this.requireLoaded();
        return this.mDeliveryDate;
    }

    public void setDeliveryDate(Date deliveryDate) {
        this.protocol("deliverydate", this.mDeliveryDate, deliveryDate);
        this.mDeliveryDate = deliveryDate;
    }

    public PersonalAccountEntry[] getAllPersonalAccountEntries() {
        ArrayList<PersonalAccountEntry> personalAccountEntries = new ArrayList<PersonalAccountEntry>();
        if (this.getPersonalAccountEntry() != null) {
            personalAccountEntries.add(this.getPersonalAccountEntry());
        }
        if (this.getPrepaidPaEntries() != null) {
            personalAccountEntries.addAll(Arrays.asList(this.getPrepaidPaEntries()));
        }
        return personalAccountEntries.toArray(new PersonalAccountEntry[0]);
    }

    public IJPKVAT getJpkVAT() {
        this.requireLoaded();
        return this.jpkVAT;
    }

    public void setJpkVAT(IJPKVAT jpkVAT) throws BusinessDomainException {
        if (!this.isNew() && this.changedJPKVAT(jpkVAT)) {
            this.checkIfAmendingAllowed(new ProcessingStatus.TransactionStatusType[]{ProcessingStatus.TransactionStatusType.VAT_RETURN_CLOSED});
        }
        this.jpkVAT = jpkVAT;
    }

    private boolean changedJPKVAT(IJPKVAT newJPKVAT) {
        this.requireLoaded();
        return !StringMapper.equalWithTrim((String)JPKVATPersistentUtils.toPersistentValue((IJPKVAT)newJPKVAT), (String)JPKVATPersistentUtils.toPersistentValue((IJPKVAT)this.jpkVAT_old));
    }

    public void setReferenceNumberMustBeUnique(boolean referenceNumberMustBeUnique) {
        this.referenceNumberMustBeUnique = referenceNumberMustBeUnique;
    }

    public boolean referenceNumberMustBeUnique() {
        ReAllocationOfReferenceNumberActionType reAllocationOfReferenceNumberAction = this.isInvoiceReceivableTransaction() ? this.getFinanceSetup().getActionPostingSalesType() : this.getFinanceSetup().getActionPostingPurchaseType();
        switch (reAllocationOfReferenceNumberAction) {
            case REJECT: {
                return true;
            }
            case ADMITAFTERNOTIFICATION: {
                return this.referenceNumberMustBeUnique;
            }
            case NO_ACTION: {
                return false;
            }
        }
        throw ExceptionMapper.makeApplicationException((String)"unknown action type");
    }

    protected void calculateTaxTotals() {
        if (this.getFixedTaxRate() != null || this.isPurchaseRegisterInvoice()) {
            BigDecimal originalTaxTotal = BigDecimalMapper.ZERO;
            BigDecimal baseTaxTotal = BigDecimalMapper.ZERO;
            List<NominalTaxEntry> allTaxEntries = this.getAllTaxEntries();
            for (NominalTaxEntry nominalTaxEntry : allTaxEntries) {
                if (this.getPersonalAccountEntry().getIsDebit() != nominalTaxEntry.getIsDebit()) {
                    originalTaxTotal = originalTaxTotal.add(nominalTaxEntry.getEnteredAmount());
                    baseTaxTotal = baseTaxTotal.add(nominalTaxEntry.getBaseAmount());
                    continue;
                }
                originalTaxTotal = originalTaxTotal.subtract(nominalTaxEntry.getEnteredAmount());
                baseTaxTotal = baseTaxTotal.subtract(nominalTaxEntry.getBaseAmount());
            }
            this.setTaxTotal(originalTaxTotal);
            this.setBaseTaxTotal(baseTaxTotal);
        } else {
            this.setTaxTotal(null);
            this.setBaseTaxTotal(null);
        }
    }

    public List<NominalTaxEntry> getAllTaxEntries() {
        ArrayList<NominalTaxEntry> result = new ArrayList<NominalTaxEntry>();
        result.addAll(Arrays.asList(this.getTaxEntries()));
        for (PersonalAccountEntry prepaidPaEntry : this.getPrepaidPaEntries()) {
            PrepaidTax prepaidTax = prepaidPaEntry.getPrepaidTax();
            if (prepaidTax == null) continue;
            result.addAll(Arrays.asList(prepaidTax.getTaxEntries()));
        }
        return result;
    }

    public void setJPKVATMustBeFilled(boolean jpkVATMustBeFilled) {
        this.jpkVATMustBeFilled = jpkVATMustBeFilled;
    }

    public boolean jpkVATMustBeFilled() {
        return this.isPL() && !this.getIsRecurring() && !this.getFromRecurringToTrue() && this.jpkVATMustBeFilled && !ISoftware.isKronospan() && !ISoftware.getDoNotCheckIfJpkVatMissing();
    }

    protected boolean isReferenceNumberNotUnique() {
        return StringMapper.isNullString((String)this.getReferenceNumber()) || NominalTransactionBasePersistencyManager.checkReferenceNumberOfInvoice((InvoiceTransaction)this) > 1L;
    }

    protected boolean changedPersonalAccount() {
        this.requireLoaded();
        return !this.isNew() && !PersistentObjectUtils.haveEqualObjectids((IPersistentObject)this.getPersonalAccountEntry().getPersonalAccount(), (IPersistentObject)this.mPersonalAccount_old);
    }

    public String getKsefNumber() {
        this.requireLoaded();
        return this.ksefNumber;
    }

    public void setKsefNumber(String ksefNumber) {
        this.ksefNumber = ksefNumber;
    }

    public KsefNumberType getKsefNumberType() {
        this.requireLoaded();
        return this.ksefNumberType;
    }

    public void setKsefNumberType(KsefNumberType ksefNumberType) {
        this.ksefNumberType = ksefNumberType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void checkKsefNumber() throws BusinessDomainException {
        String ksefNumber = this.getKsefNumber();
        if (!StringMapper.isNullString((String)ksefNumber)) {
            if ("OFF".equalsIgnoreCase(ksefNumber) || "BFK".equalsIgnoreCase(ksefNumber) || "DI".equalsIgnoreCase(ksefNumber)) {
                if (DateHelper.before((Date)this.getDocumentDate(), (Date)DateMapper.toDate((String)"2026-02-01"))) {
                    throw TransactionExceptionMapper.makeKsefNumberWrongLengthDomainException();
                }
                if (this.getKsefNumberType() == KsefNumberType.NOT_SPECIFIED) return;
                throw TransactionExceptionMapper.makeKSEFNumberTypeMayNotBeSpecifiedWhenOffBfkDIDomainException();
            }
            if (this.getKsefNumberType() == KsefNumberType.NOT_SPECIFIED) {
                throw TransactionExceptionMapper.makeKSEFNumberTypeMustBeSpecifiedDomainException();
            }
            if (ksefNumber.length() != 35) {
                throw TransactionExceptionMapper.makeKsefNumberWrongLengthDomainException();
            }
            String ecTaxNumber = ksefNumber.substring(0, 10);
            if (!ecTaxNumber.chars().allMatch(Character::isDigit)) {
                throw TransactionExceptionMapper.makeKsefNumberPart1EctaxXNrNotNumericDomainException();
            }
            if (this.getPersonalAccount() == null) throw TransactionExceptionMapper.makePersonalAccountNotSet();
            if (this.isInvoiceReceivableTransaction()) {
                if (this.getCompany().getECTax() != null && !StringMapper.isNullString((String)this.getCompany().getECTax().getTaxNumber()) && !ecTaxNumber.equals(this.getCompany().getECTax().getTaxNumber())) {
                    throw TransactionExceptionMapper.makeKsefNumberPart1EctaxXNrNotEqualToCompanyDomainException();
                }
            } else {
                CustSupAddress custsupAddress = this.getPersonalAccount().getAddress();
                if (custsupAddress != null && !StringMapper.isNullString((String)custsupAddress.getEcTaxNumber()) && !ecTaxNumber.equals(custsupAddress.getEcTaxNumber())) {
                    throw TransactionExceptionMapper.makeKsefNumberPart1EctaxXNrNotEqualToPaDomainException();
                }
            }
            if (ksefNumber.charAt(10) != '-') {
                throw TransactionExceptionMapper.makeKsefNumberWrongFormatDomainException();
            }
            String dateYYYYMMDD = ksefNumber.substring(11, 19);
            if (!dateYYYYMMDD.chars().allMatch(Character::isDigit)) {
                throw TransactionExceptionMapper.makeKsefNumberPart2DateNotNumericDomainException();
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            simpleDateFormat.setLenient(false);
            Date documentDateKSeF = null;
            try {
                documentDateKSeF = simpleDateFormat.parse(dateYYYYMMDD);
            }
            catch (ParseException e) {
                throw TransactionExceptionMapper.makeKsefNumberPart2DateWrongFormatDomainException();
            }
            if (!DateHelper.validate((Date)documentDateKSeF)) {
                throw TransactionExceptionMapper.makeKsefNumberPart2DateWrongFormatDomainException();
            }
            if (!ISoftware.getDoNotCheckDocumentDateOfKSeFNumber() && !DateHelper.before((Date)this.getDocumentDate(), (Date)DateMapper.toDate((String)"2026-02-01"))) {
                int toleranceDays = Integer.MIN_VALUE;
                String toleranceDaysS = this.configuration.getString("com.varial.server.CheckToleranceKSeFNumber");
                if (toleranceDaysS != null) {
                    if (!StringMapper.isNumericValue((String)toleranceDaysS)) throw TransactionExceptionMapper.makeToleranceInDaysNotValidDomainException();
                    toleranceDays = Integer.parseInt(toleranceDaysS);
                    if (toleranceDays < 0 || toleranceDays > 99) {
                        throw TransactionExceptionMapper.makeToleranceInDaysNotValidDomainException();
                    }
                    Date startDate = this.getDocumentDate();
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(startDate);
                    cal.add(5, toleranceDays);
                    Date toleranceDate = cal.getTime();
                    if (DateHelper.before((Date)documentDateKSeF, (Date)this.getDocumentDate())) {
                        throw TransactionExceptionMapper.makeDocumentDateOfKSeFNumberMayNotBeforeDocumentDateDomainException();
                    }
                    if (!DateHelper.between((Date)documentDateKSeF, (Date)this.getDocumentDate(), (Date)toleranceDate)) {
                        throw TransactionExceptionMapper.makeDocumentDateOfKSeFNumberNotValidDomainException();
                    }
                } else if (!DateHelper.equal((Date)documentDateKSeF, (Date)this.getDocumentDate())) {
                    throw TransactionExceptionMapper.makeKsefNumberPart2DateNotEqualDocDateDomainException();
                }
            }
            if (ksefNumber.charAt(19) != '-') {
                throw TransactionExceptionMapper.makeKsefNumberWrongFormatDomainException();
            }
            if (ksefNumber.charAt(32) != '-') {
                throw TransactionExceptionMapper.makeKsefNumberWrongFormatDomainException();
            }
            String checkNumber = ksefNumber.substring(33, 35);
            if (checkNumber.chars().allMatch(Character::isLetterOrDigit)) return;
            throw TransactionExceptionMapper.makeKsefNumberPart4CheckNrNotCorrectDomainException();
        }
        if (!DateHelper.before((Date)this.getDocumentDate(), (Date)DateMapper.toDate((String)"2026-02-01"))) {
            throw TransactionExceptionMapper.makeKSeFNumberMayNotBeEmptyDomainException();
        }
        if (this.getKsefNumberType() == KsefNumberType.NOT_SPECIFIED) return;
        throw TransactionExceptionMapper.makeKSEFNumberTypeMayNotBeSpecifiedDomainException();
    }
}

