/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.globaljournal.report;

import com.infor.igf.core.util.PersistableEnumUtils;
import com.varial.accounting.domain.bankaccount.BankAccount;
import com.varial.accounting.domain.bankaccount.BankAccountPersistencyManager;
import com.varial.accounting.domain.documenttype.DocumentCategoryMapper;
import com.varial.accounting.domain.financesetup.CurrencyType;
import com.varial.accounting.domain.financesetup.FinanceSetup;
import com.varial.accounting.domain.financialyear.AccountingCompany;
import com.varial.accounting.domain.financialyear.FinancialYear;
import com.varial.accounting.domain.financialyear.FinancialYearPersistencyManager;
import com.varial.accounting.domain.globaljournal.GlobalJournalType;
import com.varial.accounting.domain.nominalledger.NLAccountCompanySetting;
import com.varial.accounting.domain.nominalledger.NLItemCompanySetting;
import com.varial.accounting.domain.nominalledger.NLItemCompanySettingPersistencyManager;
import com.varial.accounting.domain.nominalledger.NominalLedgerGroup;
import com.varial.accounting.domain.nominaltransactionbase.JournalTransactionGroupEnum;
import com.varial.accounting.domain.nominaltransactionbase.JournalTransactionGroupMapper;
import com.varial.accounting.domain.nominaltransactionbase.NlentryContainerHelper;
import com.varial.accounting.domain.nominaltransactionbase.NlentryTaxRegisterPersistencyManager;
import com.varial.accounting.domain.nominaltransactionbase.NominalTransactionBase;
import com.varial.accounting.domain.nominaltransactionbase.TransactionType;
import com.varial.accounting.domain.nominaltransactionbase.TransactionTypeMapper;
import com.varial.accounting.domain.personalaccount.PersonalAccount;
import com.varial.accounting.domain.personalaccount.PersonalAccountPersistencyManager;
import com.varial.accounting.domain.taxcode.TaxRate;
import com.varial.accounting.domain.taxcode.TaxRatePersistencyManager;
import com.varial.accounting.domain.taxregisterreport.TaxRegisterReportHelper;
import com.varial.accounting.persistency.nlacctransact.NlacctransactContainer;
import com.varial.base.UtilitiesManager;
import com.varial.base.text.TextFactory;
import com.varial.base.types.date.DateHelper;
import com.varial.framework.domain.company.JurisdictionType;
import com.varial.framework.domain.currency.ConversionRateUtils;
import com.varial.framework.domain.currency.CurrencyPersistencyManager;
import com.varial.framework.domain.isoftware.ISoftware;
import com.varial.interfaces.ICurrency;
import com.varial.serverbase.domain.language.ILanguage;
import com.varial.serverbase.domain.language.Language;
import com.varial.serverbase.mapper.BigDecimalFormatter;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;

public class GlobalJournalReportContainer {
    private final AccountingCompany mCompany;
    private final NlacctransactContainer mContainer;
    private final Language mGlobalLanguage;
    private final BigDecimalFormatter mFormatter;
    private String mAccountCode;
    private String mName;
    private String mName1;
    private String mShortName;
    private final String mAccountGroupCode;
    private final String mAccountGroupName;
    private final String mAccountGroupShortName;
    private final String mSequenceNumber;
    private final String mTransactionDate;
    private final String mDocumentDate;
    private final String mReferenceNumber;
    private final String mDescription;
    private String mTransactionNote;
    private final String mContraAccount;
    private String mTaxCode;
    private BigDecimal mDebitAmount;
    private BigDecimal mCreditAmount;
    private String mTransactionType;
    private final String mMonthYear;
    private String mForeignCurrencyCode;
    private BigDecimal mForeignOriginalAmount;
    private BigDecimal mConversionRate;
    private boolean mIsDebit;
    private final String mOidTransaction;
    private final String mOidNlEntry;
    private final JournalTransactionGroupEnum mJournalTransactionGroupType;
    private final String mJourTransActGroupAsString;
    private final String mTransactionTypeNumberAsString;
    private final String mOidActCosting;
    private String mControlAccount;
    private final String mJournalNumber;
    private final String mJournalNumber1;
    private final BigDecimal mGlobalJournalNumber;
    private String mTaxRegisterNumber;
    private final String mFinancialYearCode;
    private final String mCalendarYear;
    private final String mUserOfPosting;
    private final String mCreationDate;
    private final String mDeliveryDate;
    private static final String INTERFACE_USER_NAME = "veis";

    public GlobalJournalReportContainer(AccountingCompany company, NlacctransactContainer container, Language globalLanguage, BigDecimalFormatter formatter, CurrencyType currencyType, ICurrency currency, GlobalJournalType globalJournalType, boolean isSpecialJournalPrintsForKronospanPL) {
        this.mCompany = company;
        this.mGlobalLanguage = globalLanguage;
        this.mContainer = container;
        this.mFormatter = formatter;
        FinancialYear financialYear = FinancialYearPersistencyManager.getFinancialYear((String)container.oidfinancialyear);
        this.mControlAccount = "";
        NominalLedgerGroup nlGroup = null;
        if (StringMapper.isNullString((String)this.mContainer.oidpersonalacc) || isSpecialJournalPrintsForKronospanPL && ISoftware.isKronospan() && globalJournalType == GlobalJournalType.FINAL) {
            NLItemCompanySetting nlItemCompSet = NLItemCompanySettingPersistencyManager.getNLItemCompanySettingWithCache((String)container.s_objectid);
            this.mAccountCode = nlItemCompSet.getNominalLedgerItem().getCode();
            this.mName = nlItemCompSet.getShortName();
            this.mName1 = nlItemCompSet.getShortName();
            this.mShortName = nlItemCompSet.getShortName();
            nlGroup = nlItemCompSet.getNominalLedgerItem().getParentGroup();
            while (nlGroup.getParentGroup() != null && nlGroup.getCode().length() != 3) {
                nlGroup = nlGroup.getParentGroup();
            }
        } else {
            PersonalAccount personalAccount = PersonalAccountPersistencyManager.getPersonalAccount((String)container.oidpersonalacc);
            this.mAccountCode = personalAccount.getCode();
            this.mName1 = this.mName = (this.mShortName = personalAccount.getShortAddress());
            if (!personalAccount.getOneOffAccount()) {
                this.mName = personalAccount.getAddress().getPostalAddress().getName();
                this.mName1 = personalAccount.getAddress().getPostalAddress().getName1();
            }
            NLAccountCompanySetting setting = personalAccount.getControlAccount(container.isdownpayment, container.transactiondate, financialYear);
            nlGroup = setting.getNominalLedgerItem().getParentGroup();
            this.mControlAccount = setting.getNominalLedgerItemCode();
        }
        this.mAccountGroupCode = nlGroup.getCode();
        this.mAccountGroupName = nlGroup.getDescription((ILanguage)this.mGlobalLanguage);
        this.mAccountGroupShortName = nlGroup.getShortName();
        this.mContraAccount = isSpecialJournalPrintsForKronospanPL && ISoftware.isKronospan() && globalJournalType == GlobalJournalType.FINAL ? "" : GlobalJournalReportContainer.getContraAccount(container);
        this.mTransactionNote = this.mContainer.t_note;
        this.mDescription = this.mContainer.description;
        this.mSequenceNumber = this.mContainer.sequencenumber;
        this.mTransactionDate = DateMapper.toString((ILanguage)this.mGlobalLanguage, (Date)this.mContainer.transactiondate);
        this.mDocumentDate = DateMapper.toString((ILanguage)this.mGlobalLanguage, (Date)this.mContainer.documentdate);
        this.mReferenceNumber = this.mContainer.referencenumber;
        if (this.mCompany.getJurisdictionType() == JurisdictionType.IT && ISoftware.isKronospan()) {
            NominalTransactionBase ntb = NominalTransactionBase.getNominalTransactionBase((String)container.t_objectid, (int)0);
            this.mTaxRegisterNumber = TaxRegisterReportHelper.isReverseChargeMethod((AccountingCompany)this.mCompany, (Date)ntb.getFinancialYear().getValidFrom()) ? NlentryTaxRegisterPersistencyManager.getTaxRegisterNumberByOidNlEntry((String)container.getObjectid()) : ntb.getTaxRegisterNumber();
        }
        this.mTaxCode = "";
        TaxRate taxRate = null;
        if (!StringMapper.isNullString((String)this.mContainer.oidtaxrate)) {
            taxRate = TaxRatePersistencyManager.getTaxRate((String)this.mContainer.oidtaxrate);
        }
        if (taxRate == null && !StringMapper.isNullString((String)this.mContainer.oidfixtaxrate)) {
            taxRate = TaxRatePersistencyManager.getTaxRate((String)this.mContainer.oidfixtaxrate);
        }
        if (taxRate != null) {
            this.mTaxCode = taxRate.getTaxCode().getCode() + " - " + this.mFormatter.toString(currency.round(taxRate.getRate())) + " %";
        }
        if (container.debit) {
            this.mIsDebit = true;
            this.mDebitAmount = GlobalJournalReportContainer.getAmount(container, currencyType);
            this.mCreditAmount = BigDecimalMapper.ZERO;
        } else {
            this.mIsDebit = false;
            this.mDebitAmount = BigDecimalMapper.ZERO;
            this.mCreditAmount = GlobalJournalReportContainer.getAmount(container, currencyType);
        }
        this.mTransactionType = "";
        this.mTransactionType = this.mContainer.transactiontype == 1 || this.mContainer.transactiontype == 5 || this.mContainer.transactiontype == 4 ? DocumentCategoryMapper.toString((ILanguage)this.mGlobalLanguage, (int)this.mContainer.documentcategory) : TransactionTypeMapper.toString((Language)this.mGlobalLanguage, (TransactionType)((TransactionType)PersistableEnumUtils.toEnum(TransactionType.class, (int)this.mContainer.transactiontype)));
        this.mMonthYear = new SimpleDateFormat("MM.yyyy").format(this.mContainer.transactiondate);
        this.mForeignCurrencyCode = "";
        this.mForeignOriginalAmount = BigDecimal.valueOf(0L);
        this.mConversionRate = BigDecimal.valueOf(0L);
        this.mOidTransaction = container.t_objectid;
        this.mOidNlEntry = container.e_objectid;
        int journalType = GlobalJournalReportContainer.getJournalType(container.jourtransactgroup, container.transactiontype);
        this.mJourTransActGroupAsString = String.valueOf(journalType);
        this.mJournalTransactionGroupType = JournalTransactionGroupMapper.toEntryType((int)journalType);
        this.mTransactionTypeNumberAsString = String.valueOf(this.mContainer.transactiontype);
        ICurrency foreignCurrency = CurrencyPersistencyManager.getCurrency((String)container.oidenteredcurrency);
        if (!foreignCurrency.equals(this.mCompany.getFinanceSetup().getBaseCurrency())) {
            this.mConversionRate = container.entrytype == 1 && !BigDecimalMapper.isZeroOrNull((BigDecimal)container.taxofficerate) ? ConversionRateUtils.getRateForReports((BigDecimal)container.taxofficerate, (BigDecimal)container.inversetaxoffrate) : ConversionRateUtils.getRateForReports((BigDecimal)container.conversionrate, (BigDecimal)container.inverseconversrate);
            this.mForeignCurrencyCode = foreignCurrency.getCode();
            this.mForeignOriginalAmount = NlentryContainerHelper.getEnteredNetAmount((NlacctransactContainer)container, (FinanceSetup)this.mCompany.getFinanceSetup());
        }
        this.mOidActCosting = container.oidactcosting;
        this.mJournalNumber = container.t_journalno;
        this.mJournalNumber1 = container.e_journalno;
        this.mGlobalJournalNumber = container.journalrownumber;
        this.mFinancialYearCode = container.financialyearcode;
        this.mCalendarYear = financialYear.getCalendarYear();
        this.mUserOfPosting = ISoftware.getSpecialJournalPrintsForKronospanPL() && ISoftware.isKronospan() && this.mCompany.getJurisdictionType() == JurisdictionType.PL ? (container.t_lastuserid.equals(INTERFACE_USER_NAME) ? container.creatorid : container.t_lastuserid) : container.creatorid;
        this.mCreationDate = DateHelper.toDateAndTime((Date)container.creationdate);
        this.mDeliveryDate = container.deliverydate != null ? DateMapper.toString((ILanguage)this.mGlobalLanguage, (Date)container.deliverydate) : this.mDocumentDate;
    }

    public static int getJournalType(int jourtransactgroup, int transactiontype) {
        int result = jourtransactgroup;
        if (jourtransactgroup == Integer.MIN_VALUE) {
            switch (transactiontype) {
                case 14: {
                    result = 0;
                    break;
                }
                case 12: {
                    result = 2;
                    break;
                }
                case 11: {
                    result = 1;
                    break;
                }
                default: {
                    result = 3;
                }
            }
        }
        return result;
    }

    public static String getContraAccount(NlacctransactContainer container) {
        boolean isPersonalAccount;
        String result = "";
        boolean isBankAccount = !StringMapper.isNullString((String)container.oidcontrabankacc);
        boolean bl = isPersonalAccount = !StringMapper.isNullString((String)container.oidcontrapersacc);
        if (isBankAccount) {
            BankAccount account = ((BankAccountPersistencyManager)UtilitiesManager.getBean((String)"bankAccountPersistencyManager", BankAccountPersistencyManager.class)).getBankAccount(container.oidcontrabankacc);
            result = StringMapper.toString((String)account.getCode());
        } else if (isPersonalAccount) {
            PersonalAccount account = PersonalAccountPersistencyManager.getPersonalAccount((String)container.oidcontrapersacc);
            result = StringMapper.toString((String)account.getCode());
        } else if (!StringMapper.isNullString((String)container.oidcontranlaccount)) {
            NLItemCompanySetting nlItemCompSet = NLItemCompanySettingPersistencyManager.getNLItemCompanySettingWithCache((String)container.oidcontranlaccount);
            result = StringMapper.toString((String)nlItemCompSet.getNominalLedgerItem().getCode());
        }
        return result;
    }

    @Deprecated
    public static String getContraAccountSAFT(NlacctransactContainer container, FinancialYear financialYear) {
        boolean isPersonalAccount;
        String result = "";
        boolean isBankAccount = !StringMapper.isNullString((String)container.oidcontrabankacc);
        boolean bl = isPersonalAccount = !StringMapper.isNullString((String)container.oidcontrapersacc);
        if (isBankAccount) {
            BankAccount account = ((BankAccountPersistencyManager)UtilitiesManager.getBean((String)"bankAccountPersistencyManager", BankAccountPersistencyManager.class)).getBankAccount(container.oidcontrabankacc);
            result = !container.debit ? account.getNominalAccount().getNominalLedgerItemCode() : StringMapper.toString((String)account.getCode());
        } else if (isPersonalAccount) {
            PersonalAccount account = PersonalAccountPersistencyManager.getPersonalAccount((String)container.oidcontrapersacc);
            if (!container.debit) {
                NLAccountCompanySetting nlaccountCompanySetting = account.getNominalAccount(container.transactiondate, financialYear);
                result = nlaccountCompanySetting.getNominalLedgerAccount().getCode();
            } else {
                result = StringMapper.toString((String)account.getCode());
            }
        } else if (!StringMapper.isNullString((String)container.oidcontranlaccount)) {
            NLItemCompanySetting nlItemCompSet = NLItemCompanySettingPersistencyManager.getNLItemCompanySettingWithCache((String)container.oidcontranlaccount);
            result = StringMapper.toString((String)nlItemCompSet.getNominalLedgerItem().getCode());
        }
        return result;
    }

    public String getAccountCode() {
        return this.mAccountCode;
    }

    public String getName() {
        return this.mName;
    }

    public String getName1() {
        return this.mName1;
    }

    public String getShortName() {
        return this.mShortName;
    }

    public String getAccountGroupCode() {
        return this.mAccountGroupCode;
    }

    public String getAccountGroupName() {
        return this.mAccountGroupName;
    }

    public String getAccountGroupShortName() {
        return this.mAccountGroupShortName;
    }

    public String getSequenceNumber() {
        return this.mSequenceNumber;
    }

    public String getTransactionDate() {
        return this.mTransactionDate;
    }

    public String getDocumentDate() {
        return this.mDocumentDate;
    }

    public String getReferenceNumber() {
        return this.mReferenceNumber;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public String getContraAccount() {
        return this.mContraAccount;
    }

    public String getTaxCode() {
        return this.mTaxCode;
    }

    public BigDecimal getDebitAmount() {
        return this.mDebitAmount;
    }

    public BigDecimal getCreditAmount() {
        return this.mCreditAmount;
    }

    public String getTransactionType() {
        return this.mTransactionType;
    }

    public String getMonthYear() {
        return this.mMonthYear;
    }

    public String getForeignCurrencyCode() {
        return this.mForeignCurrencyCode;
    }

    public BigDecimal getForeignOriginalAmount() {
        return this.mForeignOriginalAmount;
    }

    public BigDecimal getConversionRate() {
        return this.mConversionRate;
    }

    public boolean getIsDebit() {
        return this.mIsDebit;
    }

    public String getOidTransaction() {
        return this.mOidTransaction;
    }

    public String getOidNlEntry() {
        return this.mOidNlEntry;
    }

    public String getJourTransActGroupAsString() {
        return this.mJourTransActGroupAsString;
    }

    public JournalTransactionGroupEnum getJourTransActGroup() {
        return this.mJournalTransactionGroupType;
    }

    public String getTransactionTypeNumberAsString() {
        return this.mTransactionTypeNumberAsString;
    }

    public String getTransactionNote() {
        return this.mTransactionNote;
    }

    public void setTransactionNote(String transactionNote) {
        this.mTransactionNote = transactionNote;
    }

    public String getOidActCosting() {
        return this.mOidActCosting;
    }

    public String getControlAccount() {
        return this.mControlAccount;
    }

    public String getJournalNumber() {
        return this.mJournalNumber;
    }

    public String getJournalNumber1() {
        return this.mJournalNumber1;
    }

    public BigDecimal getGlobalJournalNumber() {
        return this.mGlobalJournalNumber;
    }

    public String getTaxRegisterNumber() {
        return this.mTaxRegisterNumber;
    }

    public static BigDecimal getAmount(NlacctransactContainer container, CurrencyType currencyType) {
        BigDecimal result;
        switch (currencyType) {
            case BASE_CURRENCY: {
                result = container.baseamount;
                break;
            }
            case SECONDARY_CURRENCY_1: {
                result = container.seccurr1amount;
                break;
            }
            case SECONDARY_CURRENCY_2: {
                result = container.seccurr2amount;
                break;
            }
            case SECONDARY_CURRENCY_3: {
                result = container.seccurr3amount;
                break;
            }
            case SECONDARY_CURRENCY_4: {
                result = container.seccur4amount;
                break;
            }
            default: {
                throw new IllegalArgumentException(TextFactory.makeArgumentNotSupported((Object)currencyType));
            }
        }
        return result;
    }

    public String getFinancialYearCode() {
        return this.mFinancialYearCode;
    }

    public String getCalendarYear() {
        return this.mCalendarYear;
    }

    public String getUserOfPosting() {
        return this.mUserOfPosting;
    }

    public String getCreationDate() {
        return this.mCreationDate;
    }

    public String getDeliveryDate() {
        return this.mDeliveryDate;
    }
}

