/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.eaudit.export.v35.record.builder;

import com.varial.accounting.domain.eaudit.IEAuditSession;
import com.varial.accounting.domain.eaudit.common.record.builder.AbstractEAuditRecordBuilder;
import com.varial.accounting.domain.eaudit.export.context.EAuditExportContext;
import com.varial.accounting.domain.eaudit.export.types.EAuditFieldType;
import com.varial.accounting.domain.eaudit.validation.EAuditErrorMessage;
import com.varial.accounting.domain.eaudit.validation.EmailAddressValidator;
import com.varial.accounting.domain.eaudit.validation.PhoneNumberValidator;
import com.varial.base.exception.BusinessDomainException;
import com.varial.framework.basictypes.Salutation;
import com.varial.framework.basictypes.addresses.IPostalAddress;
import com.varial.framework.domain.advisor.IAdvisor;
import com.varial.framework.domain.errormessage.TranslatableErrorMessage;
import com.varial.serverbase.mapper.DateMapper;
import com.varial.serverbase.mapper.ExceptionMapper;
import com.varial.serverbase.mapper.StringMapper;
import java.time.LocalDateTime;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EAuditCommunicationRecordBuilder
extends AbstractEAuditRecordBuilder<EAuditCommunicationRecordBuilder> {
    private static final Logger logger = LoggerFactory.getLogger(EAuditCommunicationRecordBuilder.class);
    private static final String RECORD_TYPE = "DSKO";
    private static final String RECORD_VERSION = "04";

    protected EAuditCommunicationRecordBuilder self() {
        return this;
    }

    private EAuditCommunicationRecordBuilder appendName(String name, EAuditFieldType nameType) throws BusinessDomainException {
        return (EAuditCommunicationRecordBuilder)this.appendFieldWithMandatoryCheck(30, this.convertAndTrim(name), nameType);
    }

    protected String getRecordType() {
        return RECORD_TYPE;
    }

    protected String getRecordVersion() {
        return RECORD_VERSION;
    }

    private EAuditCommunicationRecordBuilder prodId(String prodId) {
        return (EAuditCommunicationRecordBuilder)this.appendField(7, prodId);
    }

    private EAuditCommunicationRecordBuilder modId(String modId) {
        return (EAuditCommunicationRecordBuilder)this.appendField(8, modId);
    }

    private EAuditCommunicationRecordBuilder town(IPostalAddress address) throws BusinessDomainException {
        return (EAuditCommunicationRecordBuilder)this.appendFieldWithMandatoryCheck(34, this.convertAndTrim(address.getTown()), EAuditFieldType.COMPANY_TOWN);
    }

    private EAuditCommunicationRecordBuilder postalCode(IPostalAddress address) throws BusinessDomainException {
        return (EAuditCommunicationRecordBuilder)this.appendFieldWithMandatoryCheck(10, this.convertAndTrim(address.getPostalCode()), EAuditFieldType.COMPANY_POSTAL_CODE);
    }

    private EAuditCommunicationRecordBuilder street(IPostalAddress address) {
        return (EAuditCommunicationRecordBuilder)this.appendField(33, this.convertAndTrim(address.getStreet1()));
    }

    private EAuditCommunicationRecordBuilder phone(IAdvisor contactPerson, EAuditExportContext exportContext) throws BusinessDomainException {
        String phone = StringMapper.toStringOrNullWithTrim((String)contactPerson.getPhone());
        if (phone != null && !phone.isBlank() && !PhoneNumberValidator.isValidDIN5008Format((String)phone)) {
            logger.warn("E-Audit Export for session '{}', period {}-{}: the contact person's phone number '{}' does not comply with DIN 5008.", new Object[]{exportContext.getSession().getName(), DateMapper.toDDMMYYYYPointSeparationString((Date)exportContext.getCriteria().getDateFrom()), DateMapper.toDDMMYYYYPointSeparationString((Date)exportContext.getCriteria().getDateTo()), phone});
        }
        return (EAuditCommunicationRecordBuilder)this.appendFieldWithMandatoryCheck(20, this.convertAndTrim(phone), EAuditFieldType.CONTACT_PERSON_PHONE);
    }

    private EAuditCommunicationRecordBuilder email(IAdvisor contactPerson) throws BusinessDomainException {
        String email = contactPerson.getEmail();
        if (email != null && !email.isBlank()) {
            this.validateEmail(email);
        }
        return (EAuditCommunicationRecordBuilder)this.appendFieldWithMandatoryCheck(70, this.convertAndTrim(email), EAuditFieldType.CONTACT_PERSON_EMAIL);
    }

    private void validateEmail(String email) throws BusinessDomainException {
        if (!EmailAddressValidator.isValid((String)email)) {
            throw ExceptionMapper.makeDomainException((TranslatableErrorMessage)EAuditErrorMessage.INVALID_CONTACT_PERSON_EMAIL, (String)email);
        }
    }

    private EAuditCommunicationRecordBuilder name(IAdvisor contactPerson) throws BusinessDomainException {
        return this.appendName(this.convertAndTrim(contactPerson.getName()), EAuditFieldType.CONTACT_PERSON_NAME);
    }

    private EAuditCommunicationRecordBuilder salutation(IAdvisor contactPerson) throws BusinessDomainException {
        if (this.isMissing(contactPerson.getSalutation())) {
            throw ExceptionMapper.makeDomainException((TranslatableErrorMessage)EAuditErrorMessage.CONTACT_PERSON_SALUTATION_MISSING);
        }
        return (EAuditCommunicationRecordBuilder)this.appendField(1, Salutation.MS == contactPerson.getSalutation() ? "W" : "M");
    }

    private boolean isMissing(Salutation salutation) {
        return salutation == null || salutation == Salutation.NOT_SPECIFIED;
    }

    private EAuditCommunicationRecordBuilder fax() {
        return (EAuditCommunicationRecordBuilder)this.blank(20);
    }

    private EAuditCommunicationRecordBuilder buildingNumber() {
        return (EAuditCommunicationRecordBuilder)this.blank(9);
    }

    private EAuditCommunicationRecordBuilder companyName1(IPostalAddress address) throws BusinessDomainException {
        return this.appendName(this.convertAndTrim(address.getName1()), EAuditFieldType.COMPANY_NAME_1);
    }

    private EAuditCommunicationRecordBuilder companyName2(IPostalAddress address) throws BusinessDomainException {
        return this.appendName(this.convertAndTrim(address.getName2()), EAuditFieldType.COMPANY_NAME_2);
    }

    private EAuditCommunicationRecordBuilder companyName3(IPostalAddress address) throws BusinessDomainException {
        return this.appendName(this.convertAndTrim(address.getName3()), EAuditFieldType.COMPANY_NAME_3);
    }

    public EAuditCommunicationRecordBuilder buildFrom(EAuditExportContext exportContext) throws BusinessDomainException {
        IEAuditSession session = exportContext.getSession();
        IPostalAddress address = session.getAccountingCompany().getCurrentAddress().getPostalAddress();
        IAdvisor contactPerson = session.getContactPerson();
        return (EAuditCommunicationRecordBuilder)((EAuditCommunicationRecordBuilder)((EAuditCommunicationRecordBuilder)((EAuditCommunicationRecordBuilder)((EAuditCommunicationRecordBuilder)((EAuditCommunicationRecordBuilder)((EAuditCommunicationRecordBuilder)((EAuditCommunicationRecordBuilder)((EAuditCommunicationRecordBuilder)((EAuditCommunicationRecordBuilder)this.recordType()).eubpProcedure()).senderNumber(session)).receiverNumber(session)).recordVersion()).localDateTime(20, LocalDateTime.now())).noError()).noError()).senderNumber(session)).prodId(session.getProdId()).modId(session.getModId()).companyName1(address).companyName2(address).companyName3(address).postalCode(address).town(address).street(address).buildingNumber().salutation(contactPerson).name(contactPerson).phone(contactPerson, exportContext).fax().email(contactPerson).blank(5);
    }
}

