/*
 * Decompiled with CFR 0.152.
 */
package com.varial.accounting.domain.bankstatementposting.camt.camt053.de.version00108;

import com.infor.igf.core.util.StringUtil;
import com.varial.accounting.domain.bankstatementposting.BankStatementPostingHelper;
import com.varial.accounting.domain.bankstatementposting.camt.CamtStatementNumberBuilder;
import com.varial.accounting.domain.bankstatementposting.camt.camt053.de.CamtTransactionCodeMapperDE;
import com.varial.accounting.domain.bankstatementposting.data.BankStatementAmountAndCurrency;
import com.varial.accounting.domain.bankstatementposting.data.BankStatementHeader;
import com.varial.accounting.domain.bankstatementposting.data.BankStatementOrderingParty;
import com.varial.accounting.domain.bankstatementposting.data.BankStatementPayment;
import com.varial.accounting.domain.bankstatementposting.data.BankStatementTransactionCode;
import com.varial.base.UtilitiesManager;
import com.varial.base.configuration.Configuration;
import com.varial.framework.domain.payment.sepa.base.DateAdapter;
import com.varial.serverbase.mapper.BigDecimalMapper;
import com.varial.serverbase.mapper.StringMapper;
import de.sepa.camt053.version00108.AccountStatement9;
import de.sepa.camt053.version00108.ActiveOrHistoricCurrencyAndAmount;
import de.sepa.camt053.version00108.AmountAndCurrencyExchange3;
import de.sepa.camt053.version00108.BranchAndFinancialInstitutionIdentification6;
import de.sepa.camt053.version00108.CashAccount38;
import de.sepa.camt053.version00108.CashAccount39;
import de.sepa.camt053.version00108.CashBalance8;
import de.sepa.camt053.version00108.Charges6;
import de.sepa.camt053.version00108.ChargesRecord3;
import de.sepa.camt053.version00108.CreditDebitCode;
import de.sepa.camt053.version00108.EntryTransaction10;
import de.sepa.camt053.version00108.GenericPersonIdentification1;
import de.sepa.camt053.version00108.MessageIdentification2;
import de.sepa.camt053.version00108.Party40Choice;
import de.sepa.camt053.version00108.PartyIdentification135;
import de.sepa.camt053.version00108.PaymentReturnReason5;
import de.sepa.camt053.version00108.ProprietaryBankTransactionCodeStructure1;
import de.sepa.camt053.version00108.Purpose2Choice;
import de.sepa.camt053.version00108.ReportEntry10;
import de.sepa.camt053.version00108.TransactionAgents5;
import de.sepa.camt053.version00108.TransactionParties6;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.datatype.XMLGregorianCalendar;

public class Camt053DE00108DataMapper {
    private static final Set<String> R_TRANSACTION_CODES = Set.of("108", "109", "110", "111", "159", "160", "181", "183", "184");
    private final CamtTransactionCodeMapperDE transactionCodeMapper = new CamtTransactionCodeMapperDE();

    public BankStatementHeader mapHeader(AccountStatement9 statement) {
        BankStatementHeader header = new BankStatementHeader();
        header.setStatementNumber(this.buildStatementNumber(statement));
        header.setStatementDate(DateAdapter.getDate((XMLGregorianCalendar)statement.getCreDtTm()));
        header.setIbanHouseBank(this.getIban(statement.getAcct()));
        header.setOpeningBalance(this.getOpeningBalance(statement));
        header.setClosingBalance(this.getClosingBalance(statement));
        return header;
    }

    private BigDecimal getOpeningBalance(AccountStatement9 statement) {
        return statement.getBal().stream().filter(this::isOpeningBalance).map(this::getAmount).findAny().orElse(null);
    }

    private boolean isOpeningBalance(CashBalance8 balance) {
        String cd = balance.getTp().getCdOrPrtry() != null ? balance.getTp().getCdOrPrtry().getCd() : null;
        return cd != null && (StringMapper.equalWithTrim((String)cd, (String)"PRCD") || StringMapper.equalWithTrim((String)cd, (String)"OPBD"));
    }

    private BigDecimal getClosingBalance(AccountStatement9 statement) {
        return statement.getBal().stream().filter(this::isClosingBalance).map(this::getAmount).findAny().orElse(null);
    }

    private boolean isClosingBalance(CashBalance8 balance) {
        String cd = balance.getTp().getCdOrPrtry() != null ? balance.getTp().getCdOrPrtry().getCd() : null;
        return cd != null && StringMapper.equalWithTrim((String)cd, (String)"CLBD");
    }

    private BigDecimal getAmount(CashBalance8 balance) {
        return this.mapAmountAndCurrency(balance.getAmt(), this.isDebit(balance.getCdtDbtInd())).getAmount();
    }

    private String getIban(CashAccount39 account) {
        return account != null && account.getId() != null ? account.getId().getIBAN() : null;
    }

    private String buildStatementNumber(AccountStatement9 statement) {
        Configuration configuration = (Configuration)UtilitiesManager.getBean((String)"com.infor.igf.configuration", Configuration.class);
        return new CamtStatementNumberBuilder().setElctrncSeqNb(statement.getElctrncSeqNb()).setLglSeqNb(statement.getLglSeqNb()).setStatementId(statement.getId()).setCamt53DeTagForStatementNumber(configuration.getCamt53DeTagForStatementNumber().intValue()).setCamt53TagForStatementNumber(configuration.getCamt53TagForStatementNumber().intValue()).build();
    }

    public BankStatementPayment mapPayment(ReportEntry10 entry, EntryTransaction10 transaction) {
        BankStatementPayment payment = new BankStatementPayment();
        payment.setTransactionDate(DateAdapter.getDate((XMLGregorianCalendar)entry.getBookgDt().getDt()));
        payment.setValueDate(DateAdapter.getDate((XMLGregorianCalendar)entry.getValDt().getDt()));
        payment.setAdditionalInfo2(this.getAdditionalInfo2(entry));
        boolean isDebit = this.isDebitTransaction(entry, transaction);
        payment.setCurrencyAndAmount(this.mapAmountAndCurrency(this.getTransactionCurrencyAndAmount(entry, transaction), isDebit));
        payment.setOriginalCurrencyAndAmount(this.getOriginalAmountAndCurrency(this.getTransactionOriginalCurrencyAndAmount(entry, transaction), isDebit));
        payment.setChargesCurrencyAndAmount(this.getChargesAmountAndCurrency(transaction, isDebit));
        payment.setReferenceNumber(this.getReferenceNumber(transaction));
        payment.setTransactionCode(this.mapTransactionCode(transaction));
        payment.setTransactionText(this.getTransactionText(transaction.getPurp()));
        payment.setOrderingParty(this.mapOrderingParty(entry, transaction));
        payment.setRemittances(this.mapRemittances(transaction));
        payment.setReturnInfo(this.buildReturnInfo(transaction.getRtrInf()));
        return payment;
    }

    private boolean isDebit(CreditDebitCode code) {
        return CreditDebitCode.DBIT == code;
    }

    private boolean isCredit(CreditDebitCode code) {
        return CreditDebitCode.CRDT == code;
    }

    private boolean isDebitTransaction(ReportEntry10 entry, EntryTransaction10 transaction) {
        CreditDebitCode code = this.extractCreditDebitCode(entry, transaction);
        return this.isDebit(code);
    }

    private boolean isOrderingPartyDebitSide(ReportEntry10 entry, EntryTransaction10 transaction) {
        CreditDebitCode code = this.extractCreditDebitCode(entry, transaction);
        return this.isRTransaction(transaction) ? this.isDebit(code) : this.isCredit(code);
    }

    private CreditDebitCode extractCreditDebitCode(ReportEntry10 entry, EntryTransaction10 transaction) {
        return transaction.getCdtDbtInd() != null ? transaction.getCdtDbtInd() : entry.getCdtDbtInd();
    }

    private boolean isRTransaction(EntryTransaction10 transaction) {
        String code = this.getProprietaryTransactionCode(transaction);
        return R_TRANSACTION_CODES.contains(code);
    }

    private String getProprietaryTransactionCode(EntryTransaction10 transaction) {
        BankStatementTransactionCode mappedCode = this.mapTransactionCode(transaction);
        return mappedCode != null ? mappedCode.getCodeOfTransactionType() : null;
    }

    private BankStatementTransactionCode mapTransactionCode(EntryTransaction10 transaction) {
        String proprietaryCode = this.extractProprietaryCode(transaction);
        return this.transactionCodeMapper.map(proprietaryCode);
    }

    private String extractProprietaryCode(EntryTransaction10 transaction) {
        if (transaction.getBkTxCd() != null && transaction.getBkTxCd().getPrtry() != null) {
            return transaction.getBkTxCd().getPrtry().getCd();
        }
        return null;
    }

    private CashAccount38 getCashAccountSafe(TransactionParties6 parties, boolean isDebit) {
        if (parties == null) {
            return null;
        }
        return isDebit ? parties.getDbtrAcct() : parties.getCdtrAcct();
    }

    private PartyIdentification135 getPartyIdentificationSafe(TransactionParties6 parties, boolean isDebit) {
        Party40Choice choice = this.getPartyChoiceSafe(parties, isDebit);
        return choice != null ? choice.getPty() : null;
    }

    private Party40Choice getPartyChoiceSafe(TransactionParties6 parties, boolean isDebit) {
        if (parties == null) {
            return null;
        }
        if (isDebit) {
            return parties.getUltmtDbtr() != null ? parties.getUltmtDbtr() : parties.getDbtr();
        }
        return parties.getUltmtCdtr() != null ? parties.getUltmtCdtr() : parties.getCdtr();
    }

    private BankStatementOrderingParty mapOrderingParty(ReportEntry10 entry, EntryTransaction10 transaction) {
        if (transaction == null) {
            return null;
        }
        boolean isDebit = this.isOrderingPartyDebitSide(entry, transaction);
        TransactionParties6 parties = transaction.getRltdPties();
        TransactionAgents5 agents = transaction.getRltdAgts();
        BankStatementOrderingParty orderingParty = new BankStatementOrderingParty();
        orderingParty.setOrderingPartyName1(this.getOrderingPartyName(parties, isDebit));
        orderingParty.setOrderingPartyIban(this.getOrderingPartyIban(parties, isDebit));
        orderingParty.setOrderingPartyAccountNumber(this.getOrderingPartyAccountNumber(parties, agents, isDebit));
        orderingParty.setCreditorId(this.getOrderingPartyCreditorId(parties, isDebit));
        orderingParty.setMandateReference(this.getOrderingPartyMandateReference(transaction));
        orderingParty.setOrderingPartySwift(this.getOrderingPartySwift(agents, isDebit));
        return orderingParty;
    }

    private String getOrderingPartyName(TransactionParties6 parties, boolean isDebit) {
        PartyIdentification135 id = this.getPartyIdentificationSafe(parties, isDebit);
        return id != null ? id.getNm() : null;
    }

    private String getOrderingPartyIban(TransactionParties6 parties, boolean isDebit) {
        CashAccount38 acct = this.getCashAccountSafe(parties, isDebit);
        return acct != null && acct.getId() != null ? acct.getId().getIBAN() : null;
    }

    private String getOrderingPartyAccountNumber(TransactionParties6 parties, boolean isDebit) {
        CashAccount38 acct = this.getCashAccountSafe(parties, isDebit);
        return acct != null && acct.getId() != null && acct.getId().getOthr() != null ? acct.getId().getOthr().getId() : null;
    }

    private String getOrderingPartySwift(TransactionAgents5 agents, boolean isDebit) {
        BranchAndFinancialInstitutionIdentification6 finInst = this.getFinancialInstituationSafe(agents, isDebit);
        return finInst != null && finInst.getFinInstnId() != null ? finInst.getFinInstnId().getBICFI() : null;
    }

    private String getOrderingPartyMandateReference(EntryTransaction10 transaction) {
        return transaction.getRefs() != null ? transaction.getRefs().getMndtId() : null;
    }

    private String getOrderingPartyAccountNumber(TransactionParties6 parties, TransactionAgents5 agents, boolean isDebit) {
        String partyAcct = this.getOrderingPartyAccountNumber(parties, isDebit);
        if (StringUtil.isNotEmpty((String)partyAcct)) {
            return partyAcct;
        }
        BranchAndFinancialInstitutionIdentification6 finInst = this.getFinancialInstituationSafe(agents, isDebit);
        return finInst != null && finInst.getFinInstnId() != null && finInst.getFinInstnId().getOthr() != null ? finInst.getFinInstnId().getOthr().getId() : null;
    }

    private BranchAndFinancialInstitutionIdentification6 getFinancialInstituationSafe(TransactionAgents5 agents, boolean isDebit) {
        if (agents == null) {
            return null;
        }
        return isDebit ? agents.getDbtrAgt() : agents.getCdtrAgt();
    }

    private String getOrderingPartyCreditorId(TransactionParties6 parties, boolean isDebit) {
        PartyIdentification135 id = this.getPartyIdentificationSafe(parties, isDebit);
        return isDebit && id != null && id.getId() != null && id.getId().getPrvtId() != null && !id.getId().getPrvtId().getOthr().isEmpty() ? ((GenericPersonIdentification1)id.getId().getPrvtId().getOthr().get(0)).getId() : null;
    }

    private BankStatementAmountAndCurrency getChargesAmountAndCurrency(EntryTransaction10 transaction, boolean isDebit) {
        if (transaction == null) {
            return null;
        }
        Charges6 charges = transaction.getChrgs();
        if (charges == null) {
            return null;
        }
        if (charges.getTtlChrgsAndTaxAmt() != null) {
            return this.mapAmountAndCurrency(charges.getTtlChrgsAndTaxAmt(), isDebit);
        }
        return this.extractChargesAmountAndCurrency(charges.getRcrd());
    }

    private BankStatementAmountAndCurrency extractChargesAmountAndCurrency(List<ChargesRecord3> chargesRecords) {
        Set currencies = chargesRecords.stream().map(charges -> charges.getAmt().getCcy()).collect(Collectors.toSet());
        if (currencies.size() > 1) {
            return null;
        }
        return new BankStatementAmountAndCurrency(this.getChargesSum(chargesRecords), (String)currencies.iterator().next());
    }

    private BigDecimal getChargesSum(List<ChargesRecord3> chargesRecords) {
        BigDecimal sum = BigDecimal.ZERO;
        for (ChargesRecord3 chargesRecord : chargesRecords) {
            BankStatementAmountAndCurrency currencyAndAmount = this.mapAmountAndCurrency(chargesRecord.getAmt(), this.isDebit(chargesRecord.getCdtDbtInd()));
            sum = BigDecimalMapper.add((BigDecimal)sum, (BigDecimal)currencyAndAmount.getAmount());
        }
        return sum;
    }

    private AmountAndCurrencyExchange3 getTransactionOriginalCurrencyAndAmount(ReportEntry10 entry, EntryTransaction10 transaction) {
        return transaction.getAmtDtls() != null ? transaction.getAmtDtls() : entry.getAmtDtls();
    }

    private BankStatementAmountAndCurrency getOriginalAmountAndCurrency(AmountAndCurrencyExchange3 amtDtls, boolean isDebit) {
        return amtDtls != null && amtDtls.getInstdAmt() != null ? this.mapAmountAndCurrency(amtDtls.getInstdAmt().getAmt(), isDebit) : null;
    }

    private BankStatementAmountAndCurrency mapAmountAndCurrency(ActiveOrHistoricCurrencyAndAmount currencyAndAmount, boolean isDebit) {
        if (currencyAndAmount == null) {
            return null;
        }
        return new BankStatementAmountAndCurrency(this.getAmount(currencyAndAmount, isDebit), currencyAndAmount.getCcy());
    }

    private BigDecimal getAmount(ActiveOrHistoricCurrencyAndAmount currencyAndAmount, boolean isDebit) {
        return currencyAndAmount.getValue() != null && isDebit ? currencyAndAmount.getValue().negate() : currencyAndAmount.getValue();
    }

    private ActiveOrHistoricCurrencyAndAmount getTransactionCurrencyAndAmount(ReportEntry10 entry, EntryTransaction10 transaction) {
        return transaction.getAmt() != null ? transaction.getAmt() : entry.getAmt();
    }

    private List<String> mapRemittances(EntryTransaction10 transaction) {
        List<String> cardRemittances;
        if (this.isCardPayment(transaction) && !(cardRemittances = this.getCardPaymentRemittances(transaction)).isEmpty()) {
            return cardRemittances;
        }
        return this.getUnstructuredRemittances(transaction);
    }

    private boolean isCardPayment(EntryTransaction10 transaction) {
        if (transaction == null || transaction.getBkTxCd() == null || transaction.getBkTxCd().getDomn() == null || transaction.getBkTxCd().getDomn().getFmly() == null) {
            return false;
        }
        String domnCd = transaction.getBkTxCd().getDomn().getCd();
        String fmlyCd = transaction.getBkTxCd().getDomn().getFmly().getCd();
        return "PMNT".equals(domnCd) && "MCRD".equals(fmlyCd);
    }

    private List<String> getUnstructuredRemittances(EntryTransaction10 transaction) {
        return transaction.getRmtInf() != null && transaction.getRmtInf().getUstrd() != null ? transaction.getRmtInf().getUstrd() : Collections.emptyList();
    }

    private List<String> getCardPaymentRemittances(EntryTransaction10 transaction) {
        String pmtInfId = transaction.getRefs() != null ? transaction.getRefs().getPmtInfId() : null;
        return !StringMapper.isNullString((String)pmtInfId) ? List.of(pmtInfId) : Collections.emptyList();
    }

    private String getReferenceNumber(EntryTransaction10 transaction) {
        return transaction.getRefs() != null ? transaction.getRefs().getEndToEndId() : null;
    }

    private String getAdditionalInfo2(ReportEntry10 entry) {
        String additionalInfo = BankStatementPostingHelper.checkAdditionalEntryInfo((String)entry.getAddtlNtryInf());
        return StringUtil.isNotEmpty((String)additionalInfo) ? additionalInfo : this.getMessageId(entry);
    }

    private String getMessageId(ReportEntry10 entry) {
        MessageIdentification2 messageId = entry.getAddtlInfInd();
        return messageId != null ? StringMapper.toString((String)messageId.getMsgNmId()) + "/" + StringMapper.toString((String)messageId.getMsgId()) : null;
    }

    private String getTransactionText(Purpose2Choice purpose) {
        return purpose != null ? purpose.getCd() : null;
    }

    private String buildReturnInfo(PaymentReturnReason5 returnInfo) {
        String details;
        if (returnInfo == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        if (returnInfo.getOrgnlBkTxCd() != null && returnInfo.getOrgnlBkTxCd().getPrtry() != null) {
            ProprietaryBankTransactionCodeStructure1 proprietaryCode = returnInfo.getOrgnlBkTxCd().getPrtry();
            if (!StringMapper.isNullString((String)proprietaryCode.getCd())) {
                builder.append(proprietaryCode.getCd()).append('/');
            }
            if (!StringMapper.isNullString((String)proprietaryCode.getIssr())) {
                builder.append(proprietaryCode.getIssr()).append('/');
            }
        }
        if (returnInfo.getOrgtr() != null && returnInfo.getOrgtr().getId() != null && returnInfo.getOrgtr().getId().getOrgId() != null && !StringMapper.isNullString((String)returnInfo.getOrgtr().getNm())) {
            builder.append(returnInfo.getOrgtr().getNm()).append('/');
        }
        if (returnInfo.getRsn() != null && !StringMapper.isNullString((String)returnInfo.getRsn().getCd())) {
            builder.append(returnInfo.getRsn().getCd()).append('/');
        }
        if (!returnInfo.getAddtlInf().isEmpty() && !StringMapper.isNullString((String)(details = (String)returnInfo.getAddtlInf().get(0)))) {
            builder.append(details);
        }
        return builder.toString();
    }
}

