/*
 * Decompiled with CFR 0.152.
 */
package ch.varial.accounting.domain.payment.iso.util;

import com.varial.accounting.domain.payment.FinancePayment;
import com.varial.accounting.domain.payment.FinancePaymentSession;
import com.varial.accounting.domain.payment.GeneratePayment;
import com.varial.accounting.domain.payment.GeneratePaymentRemittance;
import com.varial.accounting.domain.payment.GeneratePaymentSession;
import com.varial.accounting.domain.payment.export.util.PaymentExportHelper;
import com.varial.base.exception.BusinessDomainException;
import com.varial.base.types.date.DateHelper;
import com.varial.framework.basictypes.addresses.PostalAddress;
import com.varial.framework.domain.company.CompanyAddress;
import com.varial.interfaces.IBankAccount;
import com.varial.serverbase.mapper.StringMapper;
import java.util.Date;

public class Iso20022ChPaymentUtils {
    private static final String RAIFFEISEN_FLAG = "#RaibaCH#";

    private Iso20022ChPaymentUtils() {
    }

    public static boolean isRaiffeisen(IBankAccount bankAccount) {
        return bankAccount != null && bankAccount.getNote() != null && bankAccount.getNote().contains(RAIFFEISEN_FLAG);
    }

    public static boolean isPaymentPerOpenItemEnabled(FinancePaymentSession session) {
        return session.isGeneratePaymentSession() && ((GeneratePaymentSession)session).getPaymentPerOpenItem();
    }

    public static GeneratePaymentRemittance[] getRemittances(FinancePayment payment) {
        return payment.isGeneratePayment() ? ((GeneratePayment)payment).getGeneratePaymentRemittances() : new GeneratePaymentRemittance[]{};
    }

    public static Date getRequestedExecutionDate(FinancePaymentSession session) {
        return PaymentExportHelper.addTargetDaysSEPA((Date)Iso20022ChPaymentUtils.getExecutionDate(session), (int)0);
    }

    public static Date getExecutionDate(FinancePaymentSession session) {
        Date baseDate;
        if (session.getExecuteDate() != null) {
            return session.getExecuteDate();
        }
        if (session.isGeneratePaymentSession() && (baseDate = ((GeneratePaymentSession)session).getBaseDatePayment()) != null) {
            return baseDate;
        }
        return DateHelper.tomorrow((Date)session.getCreationDate());
    }

    private static CompanyAddress getCompanyAddress(FinancePaymentSession session) throws BusinessDomainException {
        return session.getAccountingCompany().getAddress(session.getCreationDate());
    }

    public static PostalAddress getCompanyPostalAddress(FinancePaymentSession session) throws BusinessDomainException {
        return Iso20022ChPaymentUtils.getCompanyAddress(session).getPostalAddress();
    }

    public static String getSessionName(FinancePaymentSession session) {
        return StringMapper.toStringWithTrim((String)session.getName());
    }

    public static String getReferenceNumber(FinancePayment payment) {
        String referenceNumber = payment.getReferenceNumber();
        if (!StringMapper.isNullString((String)referenceNumber)) {
            return StringMapper.toStringWithTrim((String)referenceNumber);
        }
        return StringMapper.toStringWithTrim((String)payment.getFinancePaymentSession().getName());
    }

    public static String getBankAccountCode(FinancePaymentSession session) {
        return session.getIBankAccount() != null ? session.getIBankAccount().getCode() : "";
    }

    public static String getCompanyName(FinancePaymentSession session) throws BusinessDomainException {
        return Iso20022ChPaymentUtils.getCompanyPostalAddress(session).getName();
    }
}

