/*
 * Decompiled with CFR 0.152.
 */
package ch.varial.accounting.domain.payment.iso.schemamapper.version3.debit;

import ch.iso.version3.debit.AccountIdentification4Choice;
import ch.iso.version3.debit.ActiveOrHistoricCurrencyAndAmount;
import ch.iso.version3.debit.BranchAndFinancialInstitutionIdentification4;
import ch.iso.version3.debit.CashAccount16;
import ch.iso.version3.debit.ClearingSystemMemberIdentification2;
import ch.iso.version3.debit.CreditorReferenceInformation2;
import ch.iso.version3.debit.CreditorReferenceType1Choice;
import ch.iso.version3.debit.CreditorReferenceType2;
import ch.iso.version3.debit.CustomerDirectDebitInitiationV02;
import ch.iso.version3.debit.DirectDebitTransactionInformation9;
import ch.iso.version3.debit.FinancialInstitutionIdentification7;
import ch.iso.version3.debit.GenericAccountIdentification1;
import ch.iso.version3.debit.GenericFinancialIdentification1;
import ch.iso.version3.debit.GenericOrganisationIdentification1;
import ch.iso.version3.debit.GenericPersonIdentification1;
import ch.iso.version3.debit.GroupHeader39;
import ch.iso.version3.debit.LocalInstrument2Choice;
import ch.iso.version3.debit.OrganisationIdentification4;
import ch.iso.version3.debit.Party6Choice;
import ch.iso.version3.debit.PartyIdentification32;
import ch.iso.version3.debit.PaymentIdentification1;
import ch.iso.version3.debit.PaymentInstructionInformation4;
import ch.iso.version3.debit.PaymentMethod2Code;
import ch.iso.version3.debit.PaymentTypeInformation20;
import ch.iso.version3.debit.PersonIdentification5;
import ch.iso.version3.debit.PersonIdentificationSchemeName1Choice;
import ch.iso.version3.debit.PostalAddress6;
import ch.iso.version3.debit.RemittanceInformation5;
import ch.iso.version3.debit.ServiceLevel8Choice;
import ch.iso.version3.debit.StructuredRemittanceInformation7;
import ch.varial.accounting.domain.payment.iso.data.GroupHeaderData;
import ch.varial.accounting.domain.payment.iso.data.PartyAccount;
import ch.varial.accounting.domain.payment.iso.data.PartyAgent;
import ch.varial.accounting.domain.payment.iso.data.PartyData;
import ch.varial.accounting.domain.payment.iso.data.PaymentInfoData;
import ch.varial.accounting.domain.payment.iso.data.PaymentTransferData;
import ch.varial.accounting.domain.payment.iso.data.PostalAddress;
import ch.varial.accounting.domain.payment.iso.data.RemittanceInformation;
import ch.varial.accounting.domain.payment.iso.data.TransactionInfoData;
import ch.varial.accounting.domain.payment.iso.data.TransactionType;
import com.varial.framework.domain.payment.sepa.base.DateAdapter;
import com.varial.serverbase.mapper.StringMapper;
import java.util.Map;

public class DebitSchemaMapper {
    private static final Map<TransactionType, String> SERVICE_LEVEL_MAP = Map.of(TransactionType.TYPE_DD, "CHDD", TransactionType.TYPE_TA, "CHTA");
    private static final Map<TransactionType, String> SCHEME_NAME_MAP = Map.of(TransactionType.TYPE_DD, "CHDD", TransactionType.TYPE_TA, "CHLS");

    public CustomerDirectDebitInitiationV02 toSchema(PaymentTransferData transferData) {
        CustomerDirectDebitInitiationV02 noun = new CustomerDirectDebitInitiationV02();
        noun.setGrpHdr(this.mapGroupHeader(transferData.getHeader()));
        for (PaymentInfoData paymentInfoData : transferData.getPaymentInfos()) {
            noun.getPmtInf().add(this.mapPaymentInformation(paymentInfoData));
        }
        return noun;
    }

    private GroupHeader39 mapGroupHeader(GroupHeaderData headerData) {
        GroupHeader39 header = new GroupHeader39();
        header.setMsgId(headerData.getMessageID());
        header.setCreDtTm(new DateAdapter().getCalendarInYYYYMMDDHHmmSS(headerData.getCreationDateTime()));
        header.setNbOfTxs(Integer.toString(headerData.getNumberOfTransactions()));
        header.setInitgPty(this.mapInitiatingParty(headerData.getInitiatingParty()));
        header.setCtrlSum(headerData.getControlSum());
        return header;
    }

    private PartyIdentification32 mapInitiatingParty(PartyData partyData) {
        PartyIdentification32 id = new PartyIdentification32();
        id.setNm(partyData.getName());
        id.setId(this.mapPartyInitiatingId(partyData.getUniqueId()));
        id.setPstlAdr(this.mapPostalAddress(partyData.getPostalAddress()));
        return id;
    }

    private Party6Choice mapPartyInitiatingId(String uniqueId) {
        Party6Choice id = new Party6Choice();
        id.setOrgId(this.mapOrganisationIdentification(uniqueId));
        return id;
    }

    private OrganisationIdentification4 mapOrganisationIdentification(String uniqueId) {
        OrganisationIdentification4 id = new OrganisationIdentification4();
        id.setOthr(this.mapOtherOrganisationIdentification(uniqueId));
        return id;
    }

    private GenericOrganisationIdentification1 mapOtherOrganisationIdentification(String uniqueId) {
        GenericOrganisationIdentification1 id = new GenericOrganisationIdentification1();
        id.setId(uniqueId);
        return id;
    }

    private PaymentInstructionInformation4 mapPaymentInformation(PaymentInfoData paymentInfo) {
        PaymentInstructionInformation4 info = new PaymentInstructionInformation4();
        info.setPmtInfId(paymentInfo.getPaymentInfoID());
        info.setPmtMtd(PaymentMethod2Code.DD);
        info.setReqdColltnDt(new DateAdapter().getCalendarInYYYYMMDD(paymentInfo.getRequestedExecutionDate()));
        info.setPmtTpInf(this.mapPaymentTypeInformation(paymentInfo));
        info.setCdtr(this.mapPartyIdentification(paymentInfo.getPartyData()));
        info.setCdtrAcct(this.mapPartyAccount(paymentInfo.getPartyAccount()));
        info.setCdtrAgt(this.mapPartyAgent(paymentInfo.getPartyAgent()));
        info.setCdtrSchmeId(this.mapCreditorSchemeIdentification(paymentInfo));
        for (TransactionInfoData transactionInfoData : paymentInfo.getTransactionInfos()) {
            info.getDrctDbtTxInf().add(this.mapTransactionInformation(transactionInfoData));
        }
        return info;
    }

    private PartyIdentification32 mapCreditorSchemeIdentification(PaymentInfoData paymentInfo) {
        PartyIdentification32 id = new PartyIdentification32();
        id.setId(this.mapCreditorSchemeParty(paymentInfo));
        return id;
    }

    private Party6Choice mapCreditorSchemeParty(PaymentInfoData paymentInfo) {
        Party6Choice id = new Party6Choice();
        id.setPrvtId(this.mapCreditorSchemePrivateIdentfication(paymentInfo));
        return id;
    }

    private PersonIdentification5 mapCreditorSchemePrivateIdentfication(PaymentInfoData paymentInfo) {
        PersonIdentificationSchemeName1Choice schemeName = new PersonIdentificationSchemeName1Choice();
        schemeName.setPrtry(SCHEME_NAME_MAP.get((Object)paymentInfo.getTransactionType()));
        GenericPersonIdentification1 pid = new GenericPersonIdentification1();
        pid.setSchmeNm(schemeName);
        pid.setId(paymentInfo.getPartyData().getUniqueId());
        PersonIdentification5 id = new PersonIdentification5();
        id.setOthr(pid);
        return id;
    }

    private CashAccount16 mapPartyAccount(PartyAccount partyAccount) {
        CashAccount16 account = new CashAccount16();
        account.setId(this.mapCreditorAccountIdentification(partyAccount));
        return account;
    }

    private PaymentTypeInformation20 mapPaymentTypeInformation(PaymentInfoData paymentInfo) {
        PaymentTypeInformation20 paymentTypeInfo = new PaymentTypeInformation20();
        paymentTypeInfo.setLclInstrm(this.mapLocalInstrument(paymentInfo.getLocalInstrument()));
        paymentTypeInfo.setSvcLvl(this.mapServiceLevel(paymentInfo.getTransactionType()));
        return paymentTypeInfo;
    }

    private ServiceLevel8Choice mapServiceLevel(TransactionType transactionType) {
        ServiceLevel8Choice serviceLevel = new ServiceLevel8Choice();
        serviceLevel.setPrtry(SERVICE_LEVEL_MAP.get((Object)transactionType));
        return serviceLevel;
    }

    private PartyIdentification32 mapPartyIdentification(PartyData partyData) {
        PartyIdentification32 party = new PartyIdentification32();
        party.setNm(partyData.getName());
        party.setPstlAdr(this.mapPostalAddress(partyData.getPostalAddress()));
        return party;
    }

    private FinancialInstitutionIdentification7 mapFinancialInstituationId(PartyAgent agent) {
        FinancialInstitutionIdentification7 id = new FinancialInstitutionIdentification7();
        id.setClrSysMmbId(this.mapClearingSystemMemberIdentification(agent.getBankSortingCode()));
        if (!StringMapper.isNullString((String)agent.getOther())) {
            GenericFinancialIdentification1 other = new GenericFinancialIdentification1();
            other.setId(agent.getOther());
            id.setOthr(other);
        }
        return id;
    }

    private BranchAndFinancialInstitutionIdentification4 mapPartyAgent(PartyAgent agent) {
        BranchAndFinancialInstitutionIdentification4 result = new BranchAndFinancialInstitutionIdentification4();
        result.setFinInstnId(this.mapFinancialInstituationId(agent));
        return result;
    }

    private ClearingSystemMemberIdentification2 mapClearingSystemMemberIdentification(String bankSortingCode) {
        ClearingSystemMemberIdentification2 memberId = new ClearingSystemMemberIdentification2();
        memberId.setMmbId(bankSortingCode);
        return memberId;
    }

    private DirectDebitTransactionInformation9 mapTransactionInformation(TransactionInfoData transInfoData) {
        DirectDebitTransactionInformation9 info = new DirectDebitTransactionInformation9();
        info.setInstdAmt(this.mapAmount(transInfoData));
        info.setDbtr(this.mapPartyIdentification(transInfoData.getPartyData()));
        info.setDbtrAgt(this.mapPartyAgent(transInfoData.getPartyAgent()));
        info.setDbtrAcct(this.mapPartyAccount(transInfoData.getPartyAccount()));
        info.setPmtId(this.mapPaymentIdentification1(transInfoData));
        info.setRmtInf(this.mapRemittanceInformation(transInfoData.getRemittanceInformation()));
        return info;
    }

    private RemittanceInformation5 mapRemittanceInformation(RemittanceInformation remInfoData) {
        if (remInfoData == null) {
            return null;
        }
        RemittanceInformation5 remInfo = new RemittanceInformation5();
        if (remInfoData.getReferenceType().equals((Object)TransactionType.ReferenceType.UNSTRUCTURED)) {
            remInfo.setUstrd(remInfoData.getReference());
        } else {
            remInfo.setStrd(this.mapStructuredRemittanceInformation(remInfoData));
            remInfoData.getNote().ifPresent(arg_0 -> ((RemittanceInformation5)remInfo).setUstrd(arg_0));
        }
        return remInfo;
    }

    private StructuredRemittanceInformation7 mapStructuredRemittanceInformation(RemittanceInformation remInfoData) {
        CreditorReferenceType1Choice refTypeChoice = new CreditorReferenceType1Choice();
        refTypeChoice.setPrtry(remInfoData.getReferenceType().value());
        CreditorReferenceType2 refType = new CreditorReferenceType2();
        refType.setCdOrPrtry(refTypeChoice);
        CreditorReferenceInformation2 refInfo = new CreditorReferenceInformation2();
        refInfo.setTp(refType);
        refInfo.setRef(remInfoData.getReference());
        StructuredRemittanceInformation7 structuredInfo = new StructuredRemittanceInformation7();
        structuredInfo.setCdtrRefInf(refInfo);
        return structuredInfo;
    }

    private PaymentIdentification1 mapPaymentIdentification1(TransactionInfoData transInfoData) {
        PaymentIdentification1 id = new PaymentIdentification1();
        id.setInstrId(transInfoData.getPaymentId());
        id.setEndToEndId(transInfoData.getEndToEndId());
        return id;
    }

    private AccountIdentification4Choice mapCreditorAccountIdentification(PartyAccount partyAccount) {
        AccountIdentification4Choice accountId = new AccountIdentification4Choice();
        if (!StringMapper.isNullString((String)partyAccount.getIban())) {
            accountId.setIBAN(partyAccount.getIban());
        }
        if (!StringMapper.isNullString((String)partyAccount.getOther())) {
            accountId.setOthr(this.mapAccountOther(partyAccount.getOther()));
        }
        return accountId;
    }

    private GenericAccountIdentification1 mapAccountOther(String other) {
        if (StringMapper.isNullString((String)other)) {
            return null;
        }
        GenericAccountIdentification1 otherId = new GenericAccountIdentification1();
        otherId.setId(other);
        return otherId;
    }

    private PostalAddress6 mapPostalAddress(PostalAddress address) {
        if (address == null) {
            return null;
        }
        PostalAddress6 postalAddress = new PostalAddress6();
        if (!StringMapper.isNullString((String)address.getCountry())) {
            postalAddress.setCtry(address.getCountry());
        }
        if (address.getAddressLines() != null && !address.getAddressLines().isEmpty()) {
            for (String addressLine : address.getAddressLines()) {
                postalAddress.getAdrLine().add(addressLine);
            }
        } else {
            if (!StringMapper.isNullString((String)address.getStreet())) {
                postalAddress.setStrtNm(address.getStreet());
            }
            if (!StringMapper.isNullString((String)address.getPostCode())) {
                postalAddress.setPstCd(address.getPostCode());
            }
            if (!StringMapper.isNullString((String)address.getTown())) {
                postalAddress.setTwnNm(address.getTown());
            }
        }
        return postalAddress;
    }

    private ActiveOrHistoricCurrencyAndAmount mapAmount(TransactionInfoData transInfoData) {
        ActiveOrHistoricCurrencyAndAmount amount = new ActiveOrHistoricCurrencyAndAmount();
        amount.setValue(transInfoData.getAmount());
        amount.setCcy(transInfoData.getCurrencyCode());
        return amount;
    }

    private LocalInstrument2Choice mapLocalInstrument(TransactionType.LocalInstrument localInstrument) {
        LocalInstrument2Choice localInstrumentInfo = new LocalInstrument2Choice();
        localInstrumentInfo.setPrtry(localInstrument.schemaValue());
        return localInstrumentInfo;
    }
}

