/*
 * Decompiled with CFR 0.152.
 */
package ch.varial.accounting.domain.payment.iso.schemamapper.version3.credit;

import ch.sepa.version3.credit.AccountIdentification4ChoiceCH;
import ch.sepa.version3.credit.ActiveOrHistoricCurrencyAndAmount;
import ch.sepa.version3.credit.AmountType3Choice;
import ch.sepa.version3.credit.BranchAndFinancialInstitutionIdentification4CH;
import ch.sepa.version3.credit.BranchAndFinancialInstitutionIdentification4CHBicOrClrId;
import ch.sepa.version3.credit.CashAccount16CHId;
import ch.sepa.version3.credit.CashAccount16CHIdTpCcy;
import ch.sepa.version3.credit.ChargeBearerType1Code;
import ch.sepa.version3.credit.ClearingSystemIdentification2Choice;
import ch.sepa.version3.credit.ClearingSystemMemberIdentification2;
import ch.sepa.version3.credit.CreditTransferTransactionInformation10CH;
import ch.sepa.version3.credit.CreditorReferenceInformation2;
import ch.sepa.version3.credit.CreditorReferenceType1Choice;
import ch.sepa.version3.credit.CreditorReferenceType2;
import ch.sepa.version3.credit.CustomerCreditTransferInitiationV03CH;
import ch.sepa.version3.credit.DocumentType3Code;
import ch.sepa.version3.credit.FinancialInstitutionIdentification7CH;
import ch.sepa.version3.credit.FinancialInstitutionIdentification7CHBicOrClrId;
import ch.sepa.version3.credit.GenericAccountIdentification1CH;
import ch.sepa.version3.credit.GenericFinancialIdentification1CH;
import ch.sepa.version3.credit.GroupHeader32CH;
import ch.sepa.version3.credit.InstructionForCreditorAgent1;
import ch.sepa.version3.credit.LocalInstrument2Choice;
import ch.sepa.version3.credit.PartyIdentification32CH;
import ch.sepa.version3.credit.PartyIdentification32CHName;
import ch.sepa.version3.credit.PartyIdentification32CHNameAndId;
import ch.sepa.version3.credit.PaymentIdentification1;
import ch.sepa.version3.credit.PaymentInstructionInformation3CH;
import ch.sepa.version3.credit.PaymentMethod3Code;
import ch.sepa.version3.credit.PaymentTypeInformation19CH;
import ch.sepa.version3.credit.PostalAddress6CH;
import ch.sepa.version3.credit.RemittanceInformation5CH;
import ch.sepa.version3.credit.StructuredRemittanceInformation7;
import ch.varial.accounting.domain.payment.iso.data.ChargeBearerType;
import ch.varial.accounting.domain.payment.iso.data.GroupHeaderData;
import ch.varial.accounting.domain.payment.iso.data.PartyAccount;
import ch.varial.accounting.domain.payment.iso.data.PartyAgent;
import ch.varial.accounting.domain.payment.iso.data.PartyData;
import ch.varial.accounting.domain.payment.iso.data.PaymentInfoData;
import ch.varial.accounting.domain.payment.iso.data.PaymentTransferData;
import ch.varial.accounting.domain.payment.iso.data.PostalAddress;
import ch.varial.accounting.domain.payment.iso.data.RemittanceInformation;
import ch.varial.accounting.domain.payment.iso.data.TransactionInfoData;
import ch.varial.accounting.domain.payment.iso.data.TransactionType;
import com.infor.igf.core.util.StringUtil;
import com.varial.framework.domain.payment.sepa.base.DateAdapter;
import com.varial.serverbase.mapper.StringMapper;

public class CreditSchemaMapper {
    private static final String CLEARING_SYSTEM_IDENTIFICATION_CODE = "CHBCC";

    public CustomerCreditTransferInitiationV03CH toSchema(PaymentTransferData transferData) {
        CustomerCreditTransferInitiationV03CH noun = new CustomerCreditTransferInitiationV03CH();
        noun.setGrpHdr(this.mapGroupHeader(transferData.getHeader()));
        for (PaymentInfoData paymentInfoData : transferData.getPaymentInfos()) {
            noun.getPmtInf().add(this.mapPaymentInformation(paymentInfoData));
        }
        return noun;
    }

    private GroupHeader32CH mapGroupHeader(GroupHeaderData headerData) {
        GroupHeader32CH header = new GroupHeader32CH();
        header.setMsgId(headerData.getMessageID());
        header.setCreDtTm(new DateAdapter().getCalendarInYYYYMMDDHHmmSS(headerData.getCreationDateTime()));
        header.setNbOfTxs(Integer.toString(headerData.getNumberOfTransactions()));
        header.setInitgPty(this.mapPartyIdentification(headerData.getInitiatingParty()));
        header.setCtrlSum(headerData.getControlSum());
        return header;
    }

    private PartyIdentification32CHNameAndId mapPartyIdentification(PartyData partyData) {
        PartyIdentification32CHNameAndId ident = new PartyIdentification32CHNameAndId();
        ident.setNm(partyData.getName());
        return ident;
    }

    private PaymentInstructionInformation3CH mapPaymentInformation(PaymentInfoData paymentInfo) {
        PaymentInstructionInformation3CH info = new PaymentInstructionInformation3CH();
        info.setPmtInfId(paymentInfo.getPaymentInfoID());
        info.setPmtMtd(PaymentMethod3Code.TRF);
        info.setBtchBookg(Boolean.valueOf(true));
        info.setReqdExctnDt(new DateAdapter().getCalendarInYYYYMMDD(paymentInfo.getRequestedExecutionDate()));
        info.setDbtr(this.mapDebtor(paymentInfo.getPartyData()));
        info.setDbtrAcct(this.mapDebtorAccount(paymentInfo.getPartyAccount()));
        info.setDbtrAgt(this.mapDebtorAgent(paymentInfo.getPartyAgent()));
        info.setNbOfTxs(String.valueOf(paymentInfo.getNumberOfTransactions()));
        for (TransactionInfoData transactionInfoData : paymentInfo.getTransactionInfos()) {
            info.getCdtTrfTxInf().add(this.mapTransactionInformation(transactionInfoData));
        }
        return info;
    }

    private BranchAndFinancialInstitutionIdentification4CHBicOrClrId mapDebtorAgent(PartyAgent partyAgent) {
        if (StringMapper.isNullString((String)partyAgent.getBic()) && StringMapper.isNullString((String)partyAgent.getBankSortingCode())) {
            return null;
        }
        FinancialInstitutionIdentification7CHBicOrClrId id = new FinancialInstitutionIdentification7CHBicOrClrId();
        if (!StringMapper.isNullString((String)partyAgent.getBic())) {
            id.setBIC(partyAgent.getBic());
        } else if (!StringMapper.isNullString((String)partyAgent.getBankSortingCode())) {
            id.setClrSysMmbId(this.mapClearingSystemMemberIdentification(partyAgent.getBankSortingCode()));
        }
        BranchAndFinancialInstitutionIdentification4CHBicOrClrId debtorAgent = new BranchAndFinancialInstitutionIdentification4CHBicOrClrId();
        debtorAgent.setFinInstnId(id);
        return debtorAgent;
    }

    private CashAccount16CHIdTpCcy mapDebtorAccount(PartyAccount partyAccount) {
        if (StringMapper.isNullString((String)partyAccount.getIban()) && StringMapper.isNullString((String)partyAccount.getOther())) {
            return null;
        }
        CashAccount16CHIdTpCcy debtorAccount = new CashAccount16CHIdTpCcy();
        debtorAccount.setId(this.mapAccountIdentification(partyAccount));
        return debtorAccount;
    }

    private PartyIdentification32CH mapDebtor(PartyData partyData) {
        PartyIdentification32CH debtor = new PartyIdentification32CH();
        debtor.setNm(partyData.getName());
        debtor.setPstlAdr(this.mapPostalAddress(partyData.getPostalAddress()));
        return debtor;
    }

    private CreditTransferTransactionInformation10CH mapTransactionInformation(TransactionInfoData transInfoData) {
        CreditTransferTransactionInformation10CH info = new CreditTransferTransactionInformation10CH();
        info.setAmt(this.mapAmount(transInfoData));
        info.setCdtr(this.mapCreditor(transInfoData.getPartyData()));
        info.setCdtrAcct(this.mapCreditorAccount(transInfoData.getPartyAccount()));
        info.setCdtrAgt(this.mapCreditorAgent(transInfoData.getPartyAgent()));
        info.setPmtId(this.mapPaymentIdentification1(transInfoData));
        info.setRmtInf(this.mapRemittanceInformation(transInfoData.getRemittanceInformation()));
        info.setPmtTpInf(this.mapPaymentTypeInformation(transInfoData.getLocalInstrument()));
        info.setUltmtCdtr(this.mapCreditor(transInfoData.getUltimatePartyData()));
        info.setChrgBr(this.mapChargeBearerType(transInfoData.getChargeBearer()));
        this.setPurposeCode(transInfoData, info);
        return info;
    }

    private void setPurposeCode(TransactionInfoData transInfoData, CreditTransferTransactionInformation10CH info) {
        if (StringUtil.isNotEmpty((String)transInfoData.getPurposeCode())) {
            InstructionForCreditorAgent1 instr = new InstructionForCreditorAgent1();
            instr.setInstrInf(transInfoData.getPurposeCode());
            info.getInstrForCdtrAgt().add(instr);
        }
    }

    private PaymentTypeInformation19CH mapPaymentTypeInformation(TransactionType.LocalInstrument localInstrument) {
        if (localInstrument == null) {
            return null;
        }
        PaymentTypeInformation19CH paymentTypeInfo = new PaymentTypeInformation19CH();
        paymentTypeInfo.setLclInstrm(this.mapLocalInstrument(localInstrument));
        return paymentTypeInfo;
    }

    private RemittanceInformation5CH mapRemittanceInformation(RemittanceInformation remInfoData) {
        if (remInfoData == null) {
            return null;
        }
        RemittanceInformation5CH remInfo = new RemittanceInformation5CH();
        if (remInfoData.getReferenceType().equals((Object)TransactionType.ReferenceType.UNSTRUCTURED)) {
            remInfo.setUstrd(remInfoData.getReference());
        } else {
            remInfo.setStrd(this.mapStructuredRemittanceInformation(remInfoData));
        }
        return remInfo;
    }

    private StructuredRemittanceInformation7 mapStructuredRemittanceInformation(RemittanceInformation remInfoData) {
        StructuredRemittanceInformation7 structuredInfo = new StructuredRemittanceInformation7();
        structuredInfo.setCdtrRefInf(this.mapCreditorReferenceInformation(remInfoData));
        return structuredInfo;
    }

    private CreditorReferenceInformation2 mapCreditorReferenceInformation(RemittanceInformation remInfoData) {
        CreditorReferenceInformation2 refInfo = new CreditorReferenceInformation2();
        refInfo.setRef(remInfoData.getReference());
        if (TransactionType.ReferenceType.SCOR.equals((Object)remInfoData.getReferenceType()) || TransactionType.ReferenceType.QRR.equals((Object)remInfoData.getReferenceType())) {
            refInfo.setTp(this.mapCreditorReferenceType(remInfoData.getReferenceType()));
        }
        return refInfo;
    }

    private CreditorReferenceType2 mapCreditorReferenceType(TransactionType.ReferenceType referenceType) {
        CreditorReferenceType1Choice refTypeChoice = new CreditorReferenceType1Choice();
        if (TransactionType.ReferenceType.SCOR.equals((Object)referenceType)) {
            refTypeChoice.setCd(DocumentType3Code.SCOR);
        } else {
            refTypeChoice.setPrtry("QRR");
        }
        CreditorReferenceType2 refType = new CreditorReferenceType2();
        refType.setCdOrPrtry(refTypeChoice);
        return refType;
    }

    private PaymentIdentification1 mapPaymentIdentification1(TransactionInfoData transInfoData) {
        PaymentIdentification1 id = new PaymentIdentification1();
        id.setInstrId(transInfoData.getPaymentId());
        id.setEndToEndId(transInfoData.getEndToEndId());
        return id;
    }

    private BranchAndFinancialInstitutionIdentification4CH mapCreditorAgent(PartyAgent partyAgent) {
        if (partyAgent == null) {
            return null;
        }
        BranchAndFinancialInstitutionIdentification4CH id = new BranchAndFinancialInstitutionIdentification4CH();
        id.setFinInstnId(this.mapFinancialInstituationIdentification(partyAgent));
        return id;
    }

    private FinancialInstitutionIdentification7CH mapFinancialInstituationIdentification(PartyAgent partyAgent) {
        FinancialInstitutionIdentification7CH id = new FinancialInstitutionIdentification7CH();
        if (!StringMapper.isNullString((String)partyAgent.getName())) {
            id.setNm(partyAgent.getName());
        }
        if (!StringMapper.isNullString((String)partyAgent.getBic())) {
            id.setBIC(partyAgent.getBic());
        }
        if (!StringMapper.isNullString((String)partyAgent.getOther())) {
            id.setOthr(this.mapAgentOther(partyAgent.getOther()));
        }
        if (partyAgent.getPostalAddress() != null) {
            id.setPstlAdr(this.mapPostalAddress(partyAgent.getPostalAddress()));
        }
        if (!StringMapper.isNullString((String)partyAgent.getBankSortingCode())) {
            id.setClrSysMmbId(this.mapClearingSystemMemberIdentification(partyAgent.getBankSortingCode()));
        }
        return id;
    }

    private ClearingSystemMemberIdentification2 mapClearingSystemMemberIdentification(String bankSortingCode) {
        ClearingSystemMemberIdentification2 memberId = new ClearingSystemMemberIdentification2();
        ClearingSystemIdentification2Choice id = new ClearingSystemIdentification2Choice();
        id.setCd(CLEARING_SYSTEM_IDENTIFICATION_CODE);
        memberId.setClrSysId(id);
        memberId.setMmbId(bankSortingCode);
        return memberId;
    }

    private AccountIdentification4ChoiceCH mapAccountIdentification(PartyAccount partyAccount) {
        AccountIdentification4ChoiceCH id = new AccountIdentification4ChoiceCH();
        if (!StringMapper.isNullString((String)partyAccount.getIban())) {
            id.setIBAN(partyAccount.getIban());
        }
        if (!StringMapper.isNullString((String)partyAccount.getOther())) {
            id.setOthr(this.mapAccountOther(partyAccount.getOther()));
        }
        return id;
    }

    private CashAccount16CHId mapCreditorAccount(PartyAccount partyAccount) {
        CashAccount16CHId creditorAccount = new CashAccount16CHId();
        creditorAccount.setId(this.mapAccountIdentification(partyAccount));
        return creditorAccount;
    }

    private GenericAccountIdentification1CH mapAccountOther(String other) {
        if (StringMapper.isNullString((String)other)) {
            return null;
        }
        GenericAccountIdentification1CH otherId = new GenericAccountIdentification1CH();
        otherId.setId(other);
        return otherId;
    }

    private GenericFinancialIdentification1CH mapAgentOther(String other) {
        if (StringMapper.isNullString((String)other)) {
            return null;
        }
        GenericFinancialIdentification1CH otherId = new GenericFinancialIdentification1CH();
        otherId.setId(other);
        return otherId;
    }

    private PartyIdentification32CHName mapCreditor(PartyData partyData) {
        if (partyData == null) {
            return null;
        }
        PartyIdentification32CHName creditor = new PartyIdentification32CHName();
        creditor.setNm(partyData.getName());
        creditor.setPstlAdr(this.mapPostalAddress(partyData.getPostalAddress()));
        return creditor;
    }

    private PostalAddress6CH mapPostalAddress(PostalAddress address) {
        if (address == null) {
            return null;
        }
        PostalAddress6CH postalAddress = new PostalAddress6CH();
        if (!StringMapper.isNullString((String)address.getCountry())) {
            postalAddress.setCtry(address.getCountry());
        }
        if (address.getAddressLines() != null && !address.getAddressLines().isEmpty()) {
            for (String addressLine : address.getAddressLines()) {
                postalAddress.getAdrLine().add(addressLine);
            }
        } else {
            if (!StringMapper.isNullString((String)address.getStreet())) {
                postalAddress.setStrtNm(address.getStreet());
            }
            if (!StringMapper.isNullString((String)address.getBuildingNumber())) {
                postalAddress.setBldgNb(address.getBuildingNumber());
            }
            if (!StringMapper.isNullString((String)address.getPostCode())) {
                postalAddress.setPstCd(address.getPostCode());
            }
            if (!StringMapper.isNullString((String)address.getTown())) {
                postalAddress.setTwnNm(address.getTown());
            }
        }
        return postalAddress;
    }

    private AmountType3Choice mapAmount(TransactionInfoData transInfoData) {
        ActiveOrHistoricCurrencyAndAmount amount = new ActiveOrHistoricCurrencyAndAmount();
        amount.setValue(transInfoData.getAmount());
        amount.setCcy(transInfoData.getCurrencyCode());
        AmountType3Choice amountType = new AmountType3Choice();
        amountType.setInstdAmt(amount);
        return amountType;
    }

    private LocalInstrument2Choice mapLocalInstrument(TransactionType.LocalInstrument localInstrument) {
        LocalInstrument2Choice localInstrumentInfo = new LocalInstrument2Choice();
        if (TransactionType.LocalInstrument.CPP.equals((Object)localInstrument)) {
            localInstrumentInfo.setCd(TransactionType.LocalInstrument.CPP.value());
        } else {
            localInstrumentInfo.setPrtry(localInstrument.value());
        }
        return localInstrumentInfo;
    }

    private ChargeBearerType1Code mapChargeBearerType(ChargeBearerType chargeBearer) {
        if (chargeBearer == null) {
            return null;
        }
        switch (chargeBearer) {
            case OUR: {
                return ChargeBearerType1Code.DEBT;
            }
            case BEN: {
                return ChargeBearerType1Code.CRED;
            }
            case SHAR: {
                return ChargeBearerType1Code.SHAR;
            }
            case SLEV: {
                return ChargeBearerType1Code.SLEV;
            }
        }
        return null;
    }
}

