/*
 * Decompiled with CFR 0.152.
 */
package ch.varial.accounting.domain.payment.iso.resolver;

import ch.varial.accounting.domain.payment.iso.data.TransactionType;
import ch.varial.accounting.domain.payment.iso.util.Iso20022ChPaymentUtils;
import com.varial.accounting.domain.payment.FinancePayment;
import com.varial.serverbase.mapper.StringMapper;

public class TransactionTypeResolver {
    private static final String CHF = "CHF";
    private static final String EUR = "EUR";
    public static final String FIX_POSTFINANCE_IID = "09000";
    private static final String[] POSTFINANCE_IIDS = new String[]{"9000", "09000"};

    public TransactionType resolveCredit(FinancePayment payment) {
        if (this.isForeignPayment(payment)) {
            return TransactionType.TYPE_6;
        }
        if (this.isForeignCurrency(payment)) {
            return TransactionType.TYPE_4;
        }
        if (this.isEsrPayment(payment)) {
            return TransactionType.TYPE_1;
        }
        if (this.matchesType21Criteria(payment)) {
            return TransactionType.TYPE_21;
        }
        return TransactionType.TYPE_3;
    }

    public TransactionType resolveDebit(FinancePayment payment) {
        return this.isDD(payment) ? TransactionType.TYPE_DD : TransactionType.TYPE_TA;
    }

    private boolean matchesType21Criteria(FinancePayment payment) {
        return !StringMapper.isNullString((String)payment.getPostChequeAccount()) && StringMapper.isNullString((String)payment.getShortAddressOwner()) && Iso20022ChPaymentUtils.getRemittances(payment).length == 1;
    }

    private boolean isForeignPayment(FinancePayment payment) {
        return !StringMapper.equalWithTrim((String)payment.getBankCountry().getIsoCode(), (String)payment.getBankAccount().getBankData().getCountry().getIsoCode());
    }

    private boolean isForeignCurrency(FinancePayment payment) {
        String currency = payment.getCurrency().getSwift();
        return !StringMapper.equalWithTrim((String)CHF, (String)currency) && !StringMapper.equalWithTrim((String)EUR, (String)currency);
    }

    private boolean isEsrPayment(FinancePayment payment) {
        return payment.getEsrPayment() != null;
    }

    private boolean isDD(FinancePayment payment) {
        return !StringMapper.isNullString((String)payment.getPostChequeAccount()) && this.isPostFinanceIid(payment.getBankSortingCode()) && !StringMapper.isNullString((String)payment.getBankAccount().getPcCode()) && this.isPostFinanceIid(payment.getBankAccount().getBankSortingCode());
    }

    private boolean isPostFinanceIid(String bankSortingCode) {
        if (StringMapper.isNullString((String)bankSortingCode)) {
            return false;
        }
        for (String iid : POSTFINANCE_IIDS) {
            if (!StringMapper.equalWithTrim((String)bankSortingCode, (String)iid)) continue;
            return true;
        }
        return false;
    }
}

