/*
 * Decompiled with CFR 0.152.
 */
package ch.varial.accounting.domain.payment.iso.format;

import ch.varial.accounting.domain.payment.iso.format.Iso20022ChEscapeHandler;
import com.varial.accounting.domain.payment.PaymentHelper;
import com.varial.framework.domain.paymentbase.BankDataChecker;
import com.varial.serverbase.mapper.StringMapper;

public class Iso20022ChFieldFormatter {
    private static final int MAX_STRUCTURED_REFERENCE_LENGTH = 35;
    public static final int MAX_UNSTRUCTURED_REMITTANCE_LENGTH = 140;
    private static final int MAX_NAME_LENGTH = 70;
    private static final int MAX_ID_LENGTH = 35;
    private static final int MAX_ADDRESS_FIELD_LENGTH = 35;
    private static final int MAX_ADDRESS_LINE_LENGTH = 70;
    private static final char[] WHITESPACE_CHARS = new char[]{' '};
    private static final char[] CONTROL_CHARS = new char[]{'\b', '\t', '\n', '\f', '\r', '\\'};
    private static final String PLACEHOLDER_IF_EMPTY = ".";
    private final Iso20022ChEscapeHandler escapeHandler;

    public Iso20022ChFieldFormatter(Iso20022ChEscapeHandler escapeHandler) {
        this.escapeHandler = escapeHandler;
    }

    public String formatName(String name) {
        return this.formatDefault(name, 70);
    }

    public String formatAddressField(String value) {
        return this.formatDefault(value, 35);
    }

    public String formatAddressLine(String value) {
        return this.formatDefault(value, 70);
    }

    public String formatId(String id) {
        return this.formatDefault(id, 35);
    }

    public String formatStructuredReference(String reference) {
        return this.formatDefault(reference, 35);
    }

    public String formatUnstructuredRemittance(String remittance) {
        this.escapeHandler.useUnstructuredRemittanceContext();
        return this.formatAndTruncate(remittance, 140);
    }

    public String formatFixPostChequeAccount(String account) {
        return BankDataChecker.toOcrBDataFormat((String)account);
    }

    public String formatIban(String iban) {
        return PaymentHelper.getIbanForElectronicFormat(iban);
    }

    public String formatEsrMemberNumber(String memberNumber) {
        return this.removeWhitespace(memberNumber);
    }

    public String formatEsrNumber(String esrNumber) {
        return this.removeWhitespace(esrNumber);
    }

    public String formatSwift(String swift) {
        return this.removeWhitespace(swift);
    }

    public String formatBankSortingCode(String bankSortingCode) {
        return this.removeWhitespace(bankSortingCode);
    }

    public String formatPostChequeAccount(String postChequeAccount) {
        return this.removeWhitespace(postChequeAccount);
    }

    public String formatBankAccountNumber(String bankAccountNumber) {
        return this.removeWhitespace(bankAccountNumber);
    }

    private String formatDefault(String input, int maxLength) {
        this.escapeHandler.useDefaultContext();
        return this.formatAndTruncate(input, maxLength);
    }

    private String removeWhitespace(String value) {
        return StringMapper.removeChars((String)value, (char[])WHITESPACE_CHARS);
    }

    private String formatAndTruncate(String input, int maxLength) {
        String preprocessed = this.preprocess(input);
        String escaped = this.escape(preprocessed);
        return escaped.length() <= maxLength ? escaped : StringMapper.maxLength((String)escaped, (int)maxLength);
    }

    private String preprocess(String input) {
        if (StringMapper.isNullString((String)input)) {
            return "";
        }
        String cleaned = StringMapper.removeChars((String)input, (char[])CONTROL_CHARS);
        if (cleaned.contains("//")) {
            cleaned = StringMapper.replaceAllSubString((String)cleaned, (String)"//", (String)" ");
        }
        if (cleaned.startsWith("/")) {
            cleaned = cleaned.substring(1, cleaned.length());
        }
        return (cleaned = StringMapper.toStringWithTrim((String)cleaned)).isEmpty() ? PLACEHOLDER_IF_EMPTY : cleaned;
    }

    private String escape(String input) {
        return this.escapeHandler.checkField(input.toCharArray());
    }
}

