/*
 * Decompiled with CFR 0.152.
 */
package ch.varial.accounting.domain.payment.iso.format;

import ch.varial.accounting.domain.payment.iso.format.Iso20022ChEscapeContext;
import ch.varial.accounting.domain.payment.iso.util.Iso20022ChPaymentUtils;
import com.varial.framework.domain.payment.sepa.base.UnicodeCharacterEscapeHandler;
import com.varial.interfaces.IBankAccount;
import java.util.Map;
import java.util.Set;

public class Iso20022ChEscapeHandler
extends UnicodeCharacterEscapeHandler {
    private static final Map<Character, String> CHAR_REPLACEMENTS = Map.of(Character.valueOf('\u00c4'), "AE", Character.valueOf('\u00d6'), "OE", Character.valueOf('\u00dc'), "UE", Character.valueOf('\u00df'), "ss", Character.valueOf('\u00e4'), "ae", Character.valueOf('\u00f6'), "oe", Character.valueOf('\u00fc'), "ue", Character.valueOf('&'), "+");
    private static final Set<Character> DOT_REPLACEMENTS = Set.of(Character.valueOf('!'), Character.valueOf('\"'), Character.valueOf('#'), Character.valueOf('%'), Character.valueOf('*'), Character.valueOf(';'), Character.valueOf('='), Character.valueOf('@'), Character.valueOf('_'), Character.valueOf('$'), Character.valueOf('['), Character.valueOf(']'), Character.valueOf('{'), Character.valueOf('}'), Character.valueOf('`'), Character.valueOf('~'));
    private static final Set<Character> ALLOWED_SPECIALS = Set.of(Character.valueOf('-'), Character.valueOf('\''), Character.valueOf(':'), Character.valueOf('?'), Character.valueOf(','), Character.valueOf('+'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('/'), Character.valueOf('.'), Character.valueOf(' '));
    private Iso20022ChEscapeContext escapeContext = Iso20022ChEscapeContext.DEFAULT;
    private final boolean allowPercentAndEquals;

    public Iso20022ChEscapeHandler(IBankAccount bankAccount) {
        this.allowPercentAndEquals = Iso20022ChPaymentUtils.isRaiffeisen(bankAccount);
    }

    public String convertChar(char ch) {
        if (CHAR_REPLACEMENTS.containsKey(Character.valueOf(ch))) {
            return CHAR_REPLACEMENTS.get(Character.valueOf(ch));
        }
        if (DOT_REPLACEMENTS.contains(Character.valueOf(ch))) {
            if (this.escapeContext == Iso20022ChEscapeContext.UNSTRUCTURED_REMITTANCE && this.allowPercentAndEquals && (ch == '%' || ch == '=')) {
                return String.valueOf(ch);
            }
            return ".";
        }
        if (Character.isDigit(ch) || Character.isLowerCase(ch) || Character.isUpperCase(ch) || ALLOWED_SPECIALS.contains(Character.valueOf(ch)) || ch == '\n') {
            return String.valueOf(ch);
        }
        return super.convertChar(ch);
    }

    public void useDefaultContext() {
        this.escapeContext = Iso20022ChEscapeContext.DEFAULT;
    }

    public void useUnstructuredRemittanceContext() {
        this.escapeContext = Iso20022ChEscapeContext.UNSTRUCTURED_REMITTANCE;
    }
}

