/*
 * Decompiled with CFR 0.152.
 */
package ch.varial.accounting.domain.payment.iso.data;

import ch.varial.accounting.domain.payment.iso.data.AddressBuilderStrategy;
import ch.varial.accounting.domain.payment.iso.data.PostalAddress;
import ch.varial.accounting.domain.payment.iso.format.Iso20022ChFieldFormatter;
import com.varial.framework.basictypes.addresses.IPostalAddress;

public class PostalAddressFactory {
    private final Iso20022ChFieldFormatter formatter;
    private AddressBuilderStrategy strategy;

    public PostalAddressFactory(Iso20022ChFieldFormatter formatter) {
        this.formatter = formatter;
    }

    public PostalAddressFactory withUnstructuredFormat() {
        this.strategy = new AddressBuilderStrategy.UnstructuredAddressBuilder(this.formatter);
        return this;
    }

    public PostalAddressFactory withStructuredFormat() {
        this.strategy = new AddressBuilderStrategy.StructuredAddressBuilder(this.formatter);
        return this;
    }

    public PostalAddress create(IPostalAddress address) {
        return this.strategy.build(address);
    }
}

