/*
 * Decompiled with CFR 0.152.
 */
package ch.varial.accounting.domain.payment.iso.data;

import ch.varial.accounting.domain.payment.iso.data.PostalAddress;

public class PartyData {
    private final String name;
    private final PostalAddress postalAddress;
    private final String uniqueId;

    private PartyData(Builder builder) {
        this.name = builder.name;
        this.postalAddress = builder.postalAddress;
        this.uniqueId = builder.uniqueId;
    }

    public String getName() {
        return this.name;
    }

    public PostalAddress getPostalAddress() {
        return this.postalAddress;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String name;
        private PostalAddress postalAddress;
        private String uniqueId;

        public PartyData build() {
            return new PartyData(this);
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withPostalAddress(PostalAddress postalAddress) {
            this.postalAddress = postalAddress;
            return this;
        }

        public Builder withUniqueId(String uniqueId) {
            this.uniqueId = uniqueId;
            return this;
        }
    }
}

